/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.general2d;

import java.awt.Component;
import java.awt.FontMetrics;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Chart2D;
import quadbase.common.util.internal.QbUtil;

public class BarChart2D
extends Chart2D {
    public BarChart2D(Component component, ColData[] colData, boolean[] usedColumns) {
        super(component, 1, colData, usedColumns);
        if (this.nstring == 0) {
            if (this.nint + this.nreal == 0) {
                throw nocategoryError;
            }
            if (this.nint + this.nreal + this.ntime < 2) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.dataDim = 1;
            this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
        } else {
            this.mDataMap[0] = this.nstringcol[0];
            if (this.nstring == 1) {
                this.dataDim = 1;
            } else {
                this.mDataMap[1] = this.nstringcol[1];
                this.dataDim = 2;
            }
            if (this.nint + this.nreal + this.ntime < 1) {
                throw nonumericError;
            }
            this.valueCol = this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0];
        }
        this.bvalueCol = true;
        this.makeTable();
    }

    public BarChart2D(Chart _chart) {
        super(1, _chart);
        if (!this.bvalueCol) {
            this.valueCol = _chart.coordCol[0];
            this.bvalueCol = true;
        }
        if (_chart.isStackType() && _chart.dataDim == 2) {
            this.mDataMap[0] = _chart.mDataMap[1];
            this.mDataMap[1] = _chart.mDataMap[0];
            this.dataDim = 2;
        } else {
            this.dataDim = _chart.dataDim >= 2 || this.bmDataMap[1] ? 2 : 1;
        }
        this.checkSpecialColumn(1);
        this.copyTable(_chart);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        double value;
        boolean doSwapAxis;
        if (this.notEnoughData()) {
            return;
        }
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(xmax - xmin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        boolean X_int = false;
        if (this.a_x.columnField != null && this.a_x.columnField.getName().startsWith("count_")) {
            X_int = true;
        }
        StepSize xstep = null;
        StepSize xstep2 = null;
        boolean bl = doSwapAxis = this.isSwapAxis && this.subvalueCol >= 0;
        if (this.isJoinAxis()) {
            this.findMinMaxVal();
            this.findMinMaxVal2();
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
            xstep = new StepSize(this.a_x, xmax, xmin, this.maxvalue, this.minvalue, fstep, this.getVdec(), false, false, X_int);
            this.a_x.setAxisGridX(xstep, ymin, ymin, ymax, this.colData[this.valueCol], this.axisThickness);
            xstep2 = new StepSize(this.a_s, xmax, xmin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.a_s.setAxisGridX(xstep2, ymax, ymin, ymax, this.colData[this.subvalueCol], this.axisThickness);
        } else if (doSwapAxis) {
            this.findMinMaxVal();
            xstep = new StepSize(this.a_x, xmax, xmin, this.maxvalue, this.minvalue, fstep, this.getVdec(), false, false, X_int);
            this.a_x.setAxisGridX(xstep, ymax, ymin, ymax, this.colData[this.valueCol], this.axisThickness);
            this.findMinMaxVal2();
            xstep2 = new StepSize(this.a_s, xmax, xmin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.a_s.setAxisGridX(xstep2, ymin, ymin, ymax, this.colData[this.subvalueCol], this.axisThickness);
        } else {
            this.findMinMaxVal();
            xstep = new StepSize(this.a_x, xmax, xmin, this.maxvalue, this.minvalue, fstep, this.getVdec(), false, false, X_int);
            this.a_x.setAxisGridX(xstep, ymin, ymin, ymax, this.colData[this.valueCol], this.axisThickness);
            if (this.subvalueCol >= 0) {
                this.findMinMaxVal2();
                xstep2 = new StepSize(this.a_s, xmax, xmin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
                this.a_s.setAxisGridX(xstep2, ymax, ymin, ymax, this.colData[this.subvalueCol], this.axisThickness);
            }
        }
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        Point3D[] coord = new Point3D[noCategory];
        boolean zoomYDir = this.isYZoomed && (this.getZoomOption() == 1 || this.getZoomOption() == 2);
        double maxColWidth = (double)(xmax - xmin) * this.getMaxBarWidthRatioToPlotArea();
        if (this.dataDim == 1) {
            double delta = (double)(ymax - ymin) / ((double)noCategory * (1.0 + this.barwidthRatio));
            double delta2 = delta * this.barwidthRatio;
            if (delta > maxColWidth) {
                delta2 += delta - maxColWidth;
                delta = maxColWidth;
            }
            double lasty = (double)ymin + delta2 / 2.0;
            for (int i = 0; i < noCategory; ++i) {
                double nexty = lasty + delta;
                loc[0] = i;
                value = this.isDataLimitAtAxisScale() ? this.mData.getValue(loc, this.a_x) * this.flashRatio : this.mData.getValue(loc) * this.flashRatio;
                this.mData.setAreaCoord(xstep.interpolatePixel(value), xstep.zeroAxis, (int)lasty, (int)nexty, loc, zoomYDir);
                int m = (int)((lasty + nexty) / 2.0);
                if (zoomYDir && ((m = this.calculateZoomedY(m)) < this.chartyorigin || m > this.chartyorigin + this.chartheight)) {
                    m = -100;
                }
                coord[i] = new Point3D(xstep.zeroAxis, m, 0);
                if (xstep2 != null) {
                    value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                    this.mData2.setPointCoord(xstep2.interpolatePixel(value), m, loc);
                }
                lasty = nexty + delta2;
            }
        } else {
            int noSeries = this.mDataLen[0];
            double newBarWidthRatio = this.barwidthRatio;
            double delta = (double)(ymax - ymin) / ((double)noCategory * (this.barwidthRatio + (double)noSeries));
            double delta2 = delta * this.barwidthRatio;
            if (delta > maxColWidth) {
                delta2 += (delta - maxColWidth) * (double)noSeries;
                delta = maxColWidth;
                newBarWidthRatio = delta2 / delta;
            }
            double lasty = (double)ymin + delta2 / 2.0;
            double a = (newBarWidthRatio + (double)noSeries) * delta;
            double b = lasty + (double)noSeries * delta / 2.0;
            for (int i = 0; i < noCategory; ++i) {
                loc[1] = i;
                int k = 0;
                for (int j = 0; j < noSeries; ++j) {
                    loc[0] = j;
                    double nexty = lasty + delta;
                    value = this.isDataLimitAtAxisScale() ? this.mData.getValue(loc, this.a_x) * this.flashRatio : this.mData.getValue(loc) * this.flashRatio;
                    this.mData.setAreaCoord(xstep.interpolatePixel(value), xstep.zeroAxis, (int)lasty, (int)nexty, loc, zoomYDir);
                    int m = (int)((lasty + nexty) / 2.0);
                    k = (int)(a * (double)i + b);
                    if (zoomYDir) {
                        if ((m = this.calculateZoomedY(m)) < this.chartyorigin || m > this.chartyorigin + this.chartheight) {
                            m = -100;
                        }
                        if ((k = this.calculateZoomedY(k)) < this.chartyorigin || k > this.chartyorigin + this.chartheight) {
                            k = -100;
                        }
                    }
                    if (xstep2 != null) {
                        value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                        this.mData2.setPointCoord(xstep2.interpolatePixel(value), m, loc);
                    }
                    lasty = nexty;
                }
                lasty += delta2;
                coord[i] = new Point3D(xstep.zeroAxis, k, 0);
            }
        }
        this.setAutomatic(xstep2 != null);
        int colfield = this.mDataMap[this.dataDim - 1];
        this.a_y.set(xstep.zeroAxis, ymin, xstep.zeroAxis, ymax, this.axisThickness, this.colData[colfield].getFieldName(), coord, xstep.zeroAxis == xmax, this.colData[colfield]);
        if (this.isGridAlignedWithTicker()) {
            Point3D[] coord2 = new Point3D[noCategory];
            for (int i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(xmin, coord[i].y, 0);
            }
            this.a_y.grid.set(coord2, xmin, xmax);
        } else {
            Point3D[] coord2 = new Point3D[noCategory - 1];
            for (int i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(xmin, (coord[i].y + coord[i + 1].y) / 2, 0);
            }
            this.a_y.grid.set(coord2, xmin, xmax);
        }
        this.prepareLabel();
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }

    @Override
    public void draw(CGraphics g) {
        this.draw2D(g, 1);
    }
}

