/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.general2d;

import java.awt.Component;
import java.awt.FontMetrics;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Chart2D;
import quadbase.chart.chart2d.Overlay2D;
import quadbase.common.util.internal.QbUtil;

public class ColChart2D
extends Chart2D {
    public ColChart2D(Component component, ColData[] colData, boolean[] usedColumns) {
        super(component, 0, colData, usedColumns);
        if (this.nstring == 0) {
            if (this.nint + this.nreal == 0) {
                throw nocategoryError;
            }
            if (this.nint + this.nreal + this.ntime < 2) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.dataDim = 1;
            this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
        } else {
            this.mDataMap[0] = this.nstringcol[0];
            if (this.nstring == 1) {
                this.dataDim = 1;
            } else {
                this.mDataMap[1] = this.nstringcol[1];
                this.dataDim = 2;
            }
            if (this.nint + this.nreal + this.ntime < 1) {
                throw nonumericError;
            }
            this.valueCol = this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0];
        }
        this.bvalueCol = true;
        this.makeTable();
    }

    public ColChart2D(Chart _chart) {
        super(0, _chart);
        if (!this.bvalueCol) {
            this.valueCol = _chart.coordCol[0];
            this.bvalueCol = true;
        }
        if (_chart.isStackType() && _chart.dataDim == 2) {
            this.mDataMap[0] = _chart.mDataMap[1];
            this.mDataMap[1] = _chart.mDataMap[0];
            this.dataDim = 2;
        } else {
            this.dataDim = _chart.dataDim >= 2 || this.bmDataMap[1] ? 2 : 1;
        }
        this.checkSpecialColumn(1);
        this.copyTable(_chart);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        double value;
        boolean doSwapAxis;
        if (this.notEnoughData()) {
            return;
        }
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(ymax - ymin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        boolean Y_int = false;
        if (this.a_y.columnField != null && this.a_y.columnField.getName().startsWith("count_")) {
            Y_int = true;
        }
        StepSize ystep = null;
        StepSize ystep2 = null;
        boolean bl = doSwapAxis = this.isSwapAxis && this.subvalueCol >= 0;
        if (this.isJoinAxis()) {
            this.findMinMaxVal();
            this.findMinMaxVal2();
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec(), false, false, Y_int);
            this.a_y.setAxisGridY(ystep, xmin, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
        } else if (doSwapAxis) {
            this.findMinMaxVal();
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec(), false, false, Y_int);
            this.a_y.setAxisGridY(ystep, xmax, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            this.findMinMaxVal2();
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.a_s.setAxisGridY(ystep2, xmin, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
        } else {
            this.findMinMaxVal();
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec(), false, false, Y_int);
            this.a_y.setAxisGridY(ystep, xmin, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            if (this.subvalueCol >= 0) {
                this.findMinMaxVal2();
                ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
                this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
            }
        }
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        Point3D[] coord = new Point3D[noCategory];
        boolean zoomXDir = this.isXZoomed && (this.getZoomOption() == 0 || this.getZoomOption() == 2);
        double maxColWidth = (double)(xmax - xmin) * this.getMaxBarWidthRatioToPlotArea();
        if (this.dataDim == 1) {
            double delta = (double)(xmax - xmin) / ((double)noCategory * (1.0 + this.barwidthRatio));
            double delta2 = delta * this.barwidthRatio;
            if (delta > maxColWidth) {
                delta2 += delta - maxColWidth;
                delta = maxColWidth;
            }
            double lastx = (double)xmin + delta2 / 2.0;
            int m = 0;
            for (int i = 0; i < noCategory; ++i) {
                double nextx = lastx + delta;
                loc[0] = i;
                value = this.isDataLimitAtAxisScale() ? this.mData.getValue(loc, this.a_y) * this.flashRatio : this.mData.getValue(loc) * this.flashRatio;
                this.mData.setAreaCoord((int)lastx, (int)nextx, ystep.interpolatePixel(value), ystep.zeroAxis, loc, zoomXDir);
                m = (int)((lastx + nextx) / 2.0);
                if (this.isHistogram() && this.getCategoryType() != 12 && this.getCategoryType() != -1 && this.getCategoryType() != 1 && this.getCategoryType() != 16 && this.getCategoryType() != -7) {
                    m = (int)((double)m - delta / 2.0);
                }
                if (zoomXDir && ((m = this.calculateZoomedX(m)) < this.chartxorigin || m > this.chartxorigin + this.chartwidth)) {
                    m = -100;
                }
                if (ystep2 != null && !this.isOverlayCombo()) {
                    value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                    this.mData2.setPointCoord(m, ystep2.interpolatePixel(value), loc);
                }
                coord[i] = new Point3D(m, ystep.zeroAxis, 0);
                lastx = nextx + delta2;
            }
        } else {
            int noSeries = this.mDataLen[0];
            double newBarWidthRatio = this.barwidthRatio;
            double delta = (double)(xmax - xmin) / ((double)noCategory * (this.barwidthRatio + (double)noSeries));
            double delta2 = delta * this.barwidthRatio;
            if (delta > maxColWidth) {
                delta2 += (delta - maxColWidth) * (double)noSeries;
                delta = maxColWidth;
                newBarWidthRatio = delta2 / delta;
            }
            double lastx = (double)xmin + delta2 / 2.0;
            double a = (newBarWidthRatio + (double)noSeries) * delta;
            double b = lastx + (double)noSeries * delta / 2.0;
            int m = 0;
            for (int i = 0; i < noCategory; ++i) {
                loc[1] = i;
                for (int j = 0; j < noSeries; ++j) {
                    loc[0] = j;
                    double nextx = lastx + delta;
                    value = this.isDataLimitAtAxisScale() ? this.mData.getValue(loc, this.a_y) * this.flashRatio : this.mData.getValue(loc) * this.flashRatio;
                    this.mData.setAreaCoord((int)lastx, (int)nextx, ystep.interpolatePixel(value), ystep.zeroAxis, loc, zoomXDir);
                    m = (int)((lastx + nextx) / 2.0);
                    if (zoomXDir && ((m = this.calculateZoomedX(m)) < this.chartxorigin || m > this.chartxorigin + this.chartwidth)) {
                        m = -100;
                    }
                    if (ystep2 != null && !this.isOverlayCombo()) {
                        value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                        this.mData2.setPointCoord(m, ystep2.interpolatePixel(value), loc);
                    }
                    lastx = nextx;
                }
                lastx += delta2;
                m = (int)(a * (double)i + b);
                if (zoomXDir && ((m = this.calculateZoomedX(m)) < this.chartxorigin || m > this.chartxorigin + this.chartwidth)) {
                    m = -100;
                }
                coord[i] = new Point3D(m, ystep.zeroAxis, 0);
            }
        }
        if (ystep2 != null && this.isOverlayCombo()) {
            Overlay2D.computeChart(this, this.mData2.chart.dataDim, this.mData2.chart.mDataLen, this.mData2, ystep, ystep2, xmin, xmax);
        }
        this.setAutomatic(ystep2 != null);
        int colfield = this.mDataMap[this.dataDim - 1];
        this.a_x.set(xmin, ystep.zeroAxis, xmax, ystep.zeroAxis, this.axisThickness, this.colData[colfield].getFieldName(), coord, ystep.zeroAxis == ymax, this.colData[colfield]);
        if (this.isGridAlignedWithTicker()) {
            Point3D[] coord2 = new Point3D[noCategory];
            for (int i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(coord[i].x, ymin, 0);
            }
            this.a_x.grid.set(coord2, ymin, ymax);
        } else {
            Point3D[] coord2 = new Point3D[noCategory - 1];
            for (int i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D((coord[i].x + coord[i + 1].x) / 2, ymin, 0);
            }
            this.a_x.grid.set(coord2, ymin, ymax);
        }
        this.prepareLabel();
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }

    @Override
    public void draw(CGraphics g) {
        this.draw2D(g, 1);
    }

    @Override
    public void drawChart(CGraphics g) {
        this.drawChart2D(g, 1);
    }
}

