/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.general2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Line;
import quadbase.chart.MultiDimData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Chart2D;
import quadbase.chart.chart2d.Ticker2D;
import quadbase.common.util.flash.FlashGraphics;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.ControlRange;
import quadbase.util.internal.ICompareObject;
import quadbase.util.internal.NumberCompare;
import quadbase.util.internal.SortObject;

public class DialChart2D
extends Chart2D {
    private static final Logger LOGGER = Logger.getLogger(DialChart2D.class.getName());
    private double startingAngle = 0.0;
    private double endingAngle = 0.0;
    private int centerX = 0;
    private int centerY = 0;
    private Dimension[] labelOffset;
    private ControlRange centerPt;

    public DialChart2D(Component component, ColData[] colData, boolean[] usedColumns) {
        super(component, 17, colData, usedColumns);
        if (this.nstring == 0) {
            if (this.nint + this.nreal == 0) {
                throw nocategoryError;
            }
            if (this.nint + this.nreal < 2) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.dataDim = 1;
            this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
        } else {
            this.mDataMap[0] = this.nstringcol[0];
            this.dataDim = 1;
            if (this.nint + this.nreal < 1) {
                throw nonumericError;
            }
            this.valueCol = this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0];
        }
        this.bvalueCol = true;
        this.makeTable();
        this.doTypeMapping();
        this.setArrowState(false);
    }

    public DialChart2D(Chart _chart) {
        super(17, _chart);
        if (!this.bvalueCol) {
            this.valueCol = _chart.coordCol[0];
            this.bvalueCol = true;
        }
        if (_chart.isStackType() && _chart.dataDim == 2) {
            this.mDataMap[0] = _chart.mDataMap[1];
            this.dataDim = 1;
        } else {
            this.dataDim = 1;
        }
        this.checkSpecialColumn(1);
        this.copyTable(_chart);
        this.doTypeMapping();
        if (_chart.getChartType() != 17) {
            this.setArrowState(false);
        }
    }

    @Override
    public void doTypeMapping() {
        if (this.getHandLength() == null || this.getHandLength().length != this.mDataLen[0]) {
            double sector = 0.9 / (double)this.mDataLen[this.dataDim - 1];
            double[] handLength = new double[this.mDataLen[this.dataDim - 1]];
            for (int i = 0; i < this.mDataLen[0]; ++i) {
                handLength[i] = sector * (double)(this.mDataLen[0] - i);
            }
            this.setHandLength(handLength);
        }
    }

    public double[] getDefaultHandLength() {
        double sector = 0.9 / (double)this.mDataLen[this.dataDim - 1];
        double[] handLength = new double[this.mDataLen[this.dataDim - 1]];
        for (int i = 0; i < this.mDataLen[0]; ++i) {
            handLength[i] = sector * (double)(this.mDataLen[0] - i);
        }
        return handLength;
    }

    private void allocateLabelOffset(int len) {
        this.labelOffset = new Dimension[len];
        for (int i = 0; i < len; ++i) {
            this.labelOffset[i] = new Dimension(0, 0);
        }
    }

    @Override
    public Dimension getLabelOffset(int categoryIndex) {
        if (this.labelOffset == null) {
            return new Dimension(0, 0);
        }
        return this.labelOffset[categoryIndex];
    }

    @Override
    public void setLabelOffset(int index, Dimension newOffset) {
        if (this.labelOffset == null || index >= this.labelOffset.length) {
            return;
        }
        this.labelOffset[index] = newOffset;
    }

    @Override
    public void setLabelOffset(Dimension[] newOffset) {
        if (newOffset == null) {
            return;
        }
        this.labelOffset = newOffset;
    }

    @Override
    public int countLabelOffset() {
        if (this.labelOffset == null) {
            return 0;
        }
        return this.labelOffset.length;
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        if (this.notEnoughData()) {
            return;
        }
        this.a_y.logScale = false;
        this.startingAngle = this.getStartAngleForDial();
        this.endingAngle = this.getEndAngleForDial();
        if (this.endingAngle <= this.startingAngle) {
            this.endingAngle += 360.0;
        }
        int axisWidth = (xmax - xmin) / 2;
        if (xmax - xmin > ymax - ymin) {
            axisWidth = (ymax - ymin) / 2;
        }
        if (this.isDrawFullCircleForDial()) {
            this.centerX = (xmin + xmax) / 2;
            this.centerY = (ymin + ymax) / 2;
        } else if (this.startingAngle >= 0.0 && this.endingAngle <= 90.0) {
            this.centerX = xmin;
            this.centerY = ymin;
            axisWidth = xmax - xmin;
            if (xmax - xmin > ymax - ymin) {
                axisWidth = ymax - ymin;
            }
        } else if (this.startingAngle >= 90.0 && this.endingAngle <= 180.0) {
            this.centerX = xmin;
            this.centerY = ymax;
            axisWidth = xmax - xmin;
            if (xmax - xmin > ymax - ymin) {
                axisWidth = ymax - ymin;
            }
        } else if (this.startingAngle >= 180.0 && this.endingAngle <= 270.0) {
            this.centerX = xmax;
            this.centerY = ymax;
            axisWidth = xmax - xmin;
            if (xmax - xmin > ymax - ymin) {
                axisWidth = ymax - ymin;
            }
        } else if (this.startingAngle >= 270.0 && this.endingAngle <= 360.0) {
            this.centerX = xmax;
            this.centerY = ymin;
            axisWidth = xmax - xmin;
            if (xmax - xmin > ymax - ymin) {
                axisWidth = ymax - ymin;
            }
        } else {
            this.centerX = (xmin + xmax) / 2;
            this.centerY = (ymin + ymax) / 2;
        }
        int noCategory = this.mDataLen[this.dataDim - 1];
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(ymax - ymin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        this.findMinMaxVal();
        StepSize step = new StepSize(this.a_y, this.centerY + axisWidth, this.centerY, this.maxvalue, this.minvalue, fstep, this.getVdec(), false, true);
        this.setAxisGrid(this.a_y, step, this.centerX, this.centerY, xmin, xmax, this.colData[this.valueCol]);
        int[] loc = new int[this.dataDim];
        double[] defaultHandValue = this.getDefaultHandLength();
        double[] hand = this.getHandLength();
        for (int i = 0; i < noCategory; ++i) {
            loc[this.dataDim - 1] = i;
            if (i >= hand.length) continue;
            this.setAreaCoord(this.mData, step, loc, this.mData.getValue(loc) * this.flashRatio, i < hand.length ? hand[i] : defaultHandValue[i]);
        }
        this.setAutomatic(false);
        this.prepareLabel();
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }

    private void setAxisGrid(Axis axis, StepSize sz, int centerX, int centerY, int xmin, int xmax, ColData colField) {
        double sector = (this.endingAngle - this.startingAngle) % 360.0 / (double)sz.totalstep;
        int totalstep = sz.totalstep + 1;
        if (sector == 0.0) {
            totalstep = sz.totalstep;
            sector = 360.0 / (double)sz.totalstep;
        }
        if (this.labelOffset == null || this.labelOffset.length != totalstep) {
            this.allocateLabelOffset(totalstep);
        }
        Point3D[] coord = new Point3D[totalstep];
        Object[] svalue = new Object[totalstep];
        axis.stepsize = sz;
        axis.columnField = colField;
        int width = sz.newMaxPixel - sz.newMinPixel;
        for (int i = 0; i < totalstep; ++i) {
            double angle = (sector * (double)i + this.startingAngle) % 360.0;
            int ptX = centerX + (int)Math.rint(Math.sin(this.toRadian(angle)) * (double)width);
            int ptY = centerY + (int)Math.rint(Math.cos(this.toRadian(angle)) * (double)width);
            coord[i] = new Point3D(ptX, ptY);
            axis.setNumericLabel(svalue, sz, i);
        }
        axis.set(centerX, sz.newMinPixel, centerX, sz.newMaxPixel, this.axisThickness, svalue, coord, centerX == xmax, colField);
        axis.grid.set(coord, xmin, xmax);
    }

    private void setAreaCoord(MultiDimData data, StepSize step, int[] loc, double value, double handRatio) {
        if (data.level < this.dataDim) {
            this.setAreaCoord(data.multiData[loc[data.level]], step, loc, value, handRatio);
            return;
        }
        Point point = this.interpolatePixel(step, value, handRatio);
        if (this.showArrow) {
            Point[] arrow = this.setArrowCoord(this.convertScaleToDegree(step, value), (double)(step.newMaxPixel - step.newMinPixel) * handRatio + (double)this.centerY, data.getLineThickness());
            data.area.setpos(point.x, point.y, arrow[0].x, this.centerX, this.centerY, arrow[0].y);
            data.area2 = this.copyArea(data.area);
            data.area2.setpos(arrow[1].x, arrow[1].y, arrow[3].x, arrow[2].x, arrow[2].y, arrow[3].y);
        } else {
            data.area.setpos(point.x, point.y, this.centerX, this.centerY);
        }
        data.point.x = point.x;
        data.point.y = point.y;
        data.point.color = data.area.areaColor;
    }

    private Point[] setArrowCoord(double angle, double handLen, int lineThickness) {
        int thick = Math.abs(lineThickness);
        int arrh = (int)((double)(thick * 8) / 3.0);
        int arrw = thick * 5;
        int arrd = (int)((double)(thick * 10) / 3.0);
        int y = (int)(handLen + (double)(thick / 2));
        int[] yp = new int[]{y, y - arrw, y - arrd, y - arrw};
        int xOffset = 0;
        int[] xp = new int[]{this.centerX + xOffset, this.centerX + xOffset + arrh, this.centerX + xOffset, this.centerX + xOffset - arrh};
        Point[] point = new Point[4];
        for (int i = 0; i < 4; ++i) {
            double width = this.centerX - xp[i];
            double height = yp[i] - this.centerY;
            double len = Math.sqrt(Math.pow(width, 2.0) + Math.pow(height, 2.0));
            double angle2 = this.toRadian(angle) - Math.atan(width / height);
            int ptX = this.centerX + (int)Math.rint(Math.sin(angle2) * len);
            int ptY = this.centerY + (int)Math.rint(Math.cos(angle2) * len);
            point[i] = new Point(ptX, ptY);
        }
        return point;
    }

    private Point interpolatePixel(StepSize stepsize, double value, double handRatio) {
        double hand = stepsize.newMaxPixel - stepsize.newMinPixel;
        double angle = this.convertScaleToDegree(stepsize, value);
        int ptX = this.centerX + (int)Math.rint(Math.sin(this.toRadian(angle)) * (hand * handRatio));
        int ptY = this.centerY + (int)Math.rint(Math.cos(this.toRadian(angle)) * (hand * handRatio));
        return new Point(ptX, ptY);
    }

    private double toRadian(double degree) {
        return degree * Math.PI / 180.0;
    }

    private double convertScaleToDegree(StepSize stepsize, double value) {
        double valueScale;
        double ratio;
        if (value < stepsize.minvalue) {
            value = stepsize.minvalue;
        }
        if (value > stepsize.maxvalue) {
            value = stepsize.maxvalue;
        }
        if ((ratio = (this.endingAngle - this.startingAngle) % 360.0 / (valueScale = stepsize.maxvalue - stepsize.minvalue)) == 0.0) {
            ratio = 360.0 / valueScale;
        }
        return (value - stepsize.minvalue) * ratio + this.startingAngle;
    }

    private double toAbsDegree(double degree) {
        while (degree < 0.0) {
            degree += 360.0;
        }
        return degree % 360.0;
    }

    @Override
    public Object insideSelect(CGraphics g, int x, int y, Object target, int i, String[] stable) {
        target = this.selectCenterPoint(g, this.axis[1], x, y);
        if (target != null) {
            this.targetName = "Center";
            return target;
        }
        target = this.selectArea(g, this.mData, x, y);
        if (target != null) {
            this.targetName = this.getInformation((MultiDimData)target);
            return target;
        }
        if (this.axis[1].ticker != null && this.axis[1].ticker.showline && this.axis[1].ticker.showText && this.axis[1].ticker.select(g, x, y)) {
            this.targetName = "ticker";
            return this.axis[1].ticker;
        }
        target = this.selectControlRange(g, this.axis[1], x, y);
        if (target != null) {
            ControlRange controlRange = (ControlRange)target;
            this.targetName = controlRange.getTitle() + " " + controlRange.getStartScale(this) + " to " + controlRange.getEndScale(this);
            return target;
        }
        if (this.selectClockArea(g, this.axis[1], x, y)) {
            this.targetName = "clock area";
            return this.axis[1];
        }
        if (this.border.drawBorder && this.border.borderSelect(g, x, y)) {
            this.targetName = "chart border";
            return this.border;
        }
        if (this.background.drawArea && this.background.select(g, x, y)) {
            this.targetName = "chart background";
            return this.background;
        }
        return null;
    }

    private boolean selectClockArea(CGraphics g, Axis axis, int x, int y) {
        int centerX = axis.startp.x;
        int centerY = g.height - axis.startp.y;
        int width = (axis.endp.y - axis.startp.y) * 2;
        if (this.isDrawFullCircleForDial() || this.endingAngle - this.startingAngle >= 360.0) {
            return this.mData.insideArc(centerX, centerY, width, width, 0, 360, x, y);
        }
        int ptS = (int)(this.startingAngle % 360.0);
        ptS = (360 - ptS + 90) % 360;
        int ptE = (int)(this.endingAngle % 360.0);
        if (ptS < (ptE = (360 - ptE + 90) % 360)) {
            ptS += 360;
        }
        return this.mData.insideArc(centerX, centerY, width, width, ptE, ptS - ptE, x, y);
    }

    private ControlRange selectControlRange(CGraphics g, Axis axis, int x, int y) {
        int centerX = axis.startp.x;
        int centerY = g.height - axis.startp.y;
        int width = axis.endp.y - axis.startp.y;
        Vector<ControlRange> controlRangeList = this.getControlRangeList();
        for (int i = controlRangeList.size() - 1; i >= 0; --i) {
            double eAngle;
            int offset;
            ControlRange controlRange = controlRangeList.elementAt(i);
            int thickness = (int)((double)(controlRange.getThickness() * width) / 100.0);
            int tickerWidth = thickness + (offset = (int)((double)(controlRange.getOffset() * width) / 100.0));
            if (tickerWidth > width) {
                tickerWidth = width;
            }
            Point center = controlRange.getCenter();
            int cx = centerX + (int)((double)(center.x * width) / 100.0);
            int cy = centerY - (int)((double)(center.y * width) / 100.0);
            double sAngle = this.convertScaleToDegree(axis.stepsize, controlRange.getStartScale(this));
            if (sAngle == (eAngle = this.convertScaleToDegree(axis.stepsize, controlRange.getEndScale(this)))) continue;
            double dstartAngle = this.toAbsDegree(90.0 - eAngle);
            double darcAngle = this.toAbsDegree(eAngle - sAngle);
            if (darcAngle == 0.0) {
                dstartAngle = 0.0;
                darcAngle = 360.0;
            }
            int startAngle = (int)Math.rint(dstartAngle);
            int arcAngle = (int)Math.rint(darcAngle);
            if (this.mData.insideArc(cx, cy, (width - tickerWidth) * 2, (width - tickerWidth) * 2, 0, 360, x, y)) {
                return null;
            }
            if (!this.mData.insideArc(cx, cy, (width - offset) * 2, (width - offset) * 2, startAngle, arcAngle, x, y)) continue;
            return controlRange;
        }
        return null;
    }

    private ControlRange selectCenterPoint(CGraphics g, Axis axis, int x, int y) {
        if (this.centerPt == null) {
            return null;
        }
        int width = axis.endp.y - axis.startp.y;
        int radius = (int)(this.getRadiusForInternalDial() * (double)width);
        if (radius <= 0) {
            return null;
        }
        int centerX = axis.startp.x;
        int centerY = g.height - axis.startp.y;
        if (this.isDrawFullCircleForDial() || this.endingAngle - this.startingAngle >= 360.0) {
            if (this.mData.insideArc(centerX, centerY, radius * 2, radius * 2, 0, 360, x, y)) {
                return this.centerPt;
            }
        } else {
            int ptS = (int)(this.startingAngle % 360.0);
            ptS = (360 - ptS + 90) % 360;
            int ptE = (int)(this.endingAngle % 360.0);
            if (ptS < (ptE = (360 - ptE + 90) % 360)) {
                ptS += 360;
            }
            if (this.mData.insideArc(centerX, centerY, radius * 2, radius * 2, ptE, ptS - ptE, x, y)) {
                return this.centerPt;
            }
            return null;
        }
        return null;
    }

    private void drawAxisCircle(CGraphics g, Axis axis) {
        int centerX = axis.startp.x;
        int centerY = axis.startp.y;
        int width = axis.endp.y - axis.startp.y;
        int tickerWidth = this.getTickerLength();
        int labelWidth = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.ticker.font, this.mData.chart.isAdjustFont())).getHeight() / 2 + tickerWidth;
        if (axis.isLabelOutsidePlotArea()) {
            labelWidth = tickerWidth != width ? (labelWidth - tickerWidth + 3) * -1 : (labelWidth - tickerWidth) * -1;
        }
        if (axis.bshow) {
            g.setColor(axis.color);
            if (this.isDrawFullCircleForDial() || this.endingAngle - this.startingAngle >= 360.0) {
                g.fillArc(centerX, centerY, width * 2, width * 2, 0, 360, null, this.drawDataBorder, false);
            } else {
                int ptS = (int)(this.startingAngle % 360.0);
                ptS = (360 - ptS + 90) % 360;
                int ptE = (int)(this.endingAngle % 360.0);
                if (ptS < (ptE = (360 - ptE + 90) % 360)) {
                    ptS += 360;
                }
                g.fillArc(centerX, centerY, width * 2, width * 2, ptE, ptS - ptE, null, this.drawDataBorder, false);
            }
        }
        this.drawColorSection(g, axis);
        double sector = (this.endingAngle - this.startingAngle) % 360.0 / (double)axis.stepsize.totalstep;
        int totalstep = axis.stepsize.totalstep + 1;
        if (sector == 0.0) {
            totalstep = axis.stepsize.totalstep;
            sector = 360.0 / (double)axis.stepsize.totalstep;
        }
        boolean fullCircle = (this.endingAngle - this.startingAngle) % 360.0 == 0.0;
        for (int i = 0; i < totalstep; ++i) {
            double padding;
            int pivot;
            int subInterval;
            double angle = (sector * (double)i + this.startingAngle) % 360.0;
            if (i % axis.columnField.tickerSepSize == 0) {
                int maxX = centerX + (int)Math.rint(Math.sin(this.toRadian(angle)) * (double)(width - tickerWidth));
                int maxY = centerY + (int)Math.rint(Math.cos(this.toRadian(angle)) * (double)(width - tickerWidth));
                ((Ticker2D)axis.ticker).drawLine(g, maxX, maxY, axis.ticker.point[i].x, axis.ticker.point[i].y, this.is3DShadowForTickerOn(), axis.gridThickness);
            }
            if ((subInterval = this.getSubTickerCount()) > 0 && (i != totalstep - 1 || fullCircle)) {
                double subSector = sector / (double)subInterval;
                for (int j = 1; j < subInterval; ++j) {
                    double subAngle = angle + subSector * (double)j;
                    int maxX = centerX + (int)Math.rint(Math.sin(this.toRadian(subAngle)) * (double)(width - this.getSubTickerLength()));
                    int maxY = centerY + (int)Math.rint(Math.cos(this.toRadian(subAngle)) * (double)(width - this.getSubTickerLength()));
                    int minX = centerX + (int)Math.rint(Math.sin(this.toRadian(subAngle)) * (double)width);
                    int minY = centerY + (int)Math.rint(Math.cos(this.toRadian(subAngle)) * (double)width);
                    ((Ticker2D)axis.ticker).drawLine(g, maxX, maxY, minX, minY, this.is3DShadowForTickerOn(), this.getSubTickerThickness());
                }
            }
            if (!axis.showTicker || i % axis.columnField.sepSize != 0) continue;
            Dimension dim = this.getLabelOffset(i);
            CString tmp = axis.ticker.label[i].copy();
            tmp.getFontWidthHeight(g);
            double labelHeight = tmp.height / 2;
            int maxX = 0;
            int maxY = 0;
            if (!axis.isLabelOutsidePlotArea()) {
                maxX = centerX + (int)Math.rint(Math.sin(this.toRadian(angle)) * (double)width) + dim.width;
                maxY = centerY + (int)Math.rint(Math.cos(this.toRadian(angle)) * ((double)width - labelHeight)) - dim.height;
                pivot = (int)Math.rint(Math.sin(this.toRadian(angle)) / 2.0 * (double)tmp.width);
                maxX -= pivot;
                padding = (double)width * 0.03;
                if (!axis.ticker.tickerInward) {
                    padding += (double)tickerWidth;
                }
                maxX -= (int)Math.rint(Math.sin(this.toRadian(angle)) * padding);
                maxY -= (int)Math.rint(Math.cos(this.toRadian(angle)) * padding);
            } else {
                maxX = centerX + (int)Math.rint(Math.sin(this.toRadian(angle)) * (double)width) + dim.width;
                maxY = centerY + (int)Math.rint(Math.cos(this.toRadian(angle)) * ((double)width + labelHeight)) - dim.height;
                pivot = (int)Math.rint(Math.sin(this.toRadian(angle)) / 2.0 * (double)tmp.width);
                maxX += pivot;
                padding = (double)width * 0.03;
                if (axis.ticker.tickerInward) {
                    padding += (double)tickerWidth;
                }
                maxX += (int)Math.rint(Math.sin(this.toRadian(angle)) * padding);
                maxY += (int)Math.rint(Math.cos(this.toRadian(angle)) * padding);
            }
            axis.ticker.label[i].setpos(new Point3D(maxX, maxY));
            axis.ticker.drawLabel(g, i, axis.ticker.maxp, axis.ticker.minp);
        }
    }

    private void drawColorSection(CGraphics g, Axis axis) {
        int centerX = axis.startp.x;
        int centerY = axis.startp.y;
        int width = axis.endp.y - axis.startp.y;
        Vector<ControlRange> controlRangeList = this.getControlRangeList();
        for (int i = 0; i < controlRangeList.size(); ++i) {
            double eAngle;
            double sAngle;
            int offset;
            ControlRange controlRange = controlRangeList.elementAt(i);
            int thickness = (int)((double)(controlRange.getThickness() * width) / 100.0);
            int tickerWidth = thickness + (offset = (int)((double)(controlRange.getOffset() * width) / 100.0));
            if (tickerWidth > width) {
                tickerWidth = width;
            }
            if ((sAngle = this.convertScaleToDegree(axis.stepsize, controlRange.getStartScale(this))) == (eAngle = this.convertScaleToDegree(axis.stepsize, controlRange.getEndScale(this)))) continue;
            Point center = controlRange.getCenter();
            int x = centerX + (int)((double)(center.x * width) / 100.0);
            int y = centerY + (int)((double)(center.y * width) / 100.0);
            g.setColor(controlRange.getColor());
            double dstartAngle = this.toAbsDegree(90.0 - eAngle);
            double darcAngle = this.toAbsDegree(eAngle - sAngle);
            if (darcAngle == 0.0) {
                darcAngle = 360.0;
            }
            int startAngle = (int)Math.rint(dstartAngle);
            int arcAngle = (int)Math.rint(darcAngle);
            if (!controlRange.isShowAxis()) {
                g.fillDoughnutArc(x, y, (width - offset) * 2, (width - offset) * 2, startAngle, arcAngle, null, controlRange.isDrawBorder() || controlRange.isDrawFullBorder(), false, axis.color, controlRange.getThickness());
                continue;
            }
            g.fillArc(x, y, (width - offset) * 2, (width - offset) * 2, startAngle, arcAngle, null, controlRange.isDrawBorder() || controlRange.isDrawFullBorder(), false);
            g.setColor(axis.color);
            int innerCircleOffset = 0;
            if (controlRangeList.size() == 1) {
                innerCircleOffset = 2;
            }
            if (!controlRange.isDrawFullBorder()) {
                g.fillArc(x, y, (width - tickerWidth) * 2, (width - tickerWidth) * 2, startAngle - innerCircleOffset, arcAngle + innerCircleOffset * 2, null, false, false);
                continue;
            }
            g.fillArc(x, y, (width - tickerWidth) * 2, (width - tickerWidth) * 2, startAngle, arcAngle, null, false, false);
            this.drawSideBorder(g, centerX, centerY, startAngle, width - offset, width - tickerWidth);
            this.drawSideBorder(g, centerX, centerY, startAngle + arcAngle, width - offset, width - tickerWidth);
        }
        if (this.drawDataBorder) {
            g.setColor(Color.black);
            if (this.isDrawFullCircleForDial() || this.endingAngle - this.startingAngle >= 360.0) {
                g.drawArc(centerX, centerY, width * 2, width * 2, 0, 360);
            } else {
                int ptS = (int)(this.startingAngle % 360.0);
                ptS = (360 - ptS + 90) % 360;
                int ptE = (int)(this.endingAngle % 360.0);
                if (ptS < (ptE = (360 - ptE + 90) % 360)) {
                    ptS += 360;
                }
                g.drawArc(centerX, centerY, width * 2, width * 2, ptE, ptS - ptE);
            }
        }
    }

    private void drawSideBorder(CGraphics g, int centerX, int centerY, int anglePT, int startRadius, int endRadius) {
        int tickerThickness = 1;
        g.setColor(Color.black);
        int angle = (int)((double)(450 - anglePT) % 360.0);
        int X1 = centerX + (int)Math.rint(Math.sin(this.toRadian(angle)) * (double)startRadius);
        int Y1 = centerY + (int)Math.rint(Math.cos(this.toRadian(angle)) * (double)startRadius);
        int X2 = centerX + (int)Math.rint(Math.sin(this.toRadian(angle)) * (double)endRadius);
        int Y2 = centerY + (int)Math.rint(Math.cos(this.toRadian(angle)) * (double)endRadius);
        g.fillLine(X1, Y1, X2, Y2, tickerThickness);
    }

    private int getCenterPointYOffset() {
        if (this.isDrawFullCircleForDial()) {
            return 0;
        }
        if (this.startingAngle >= 270.0 && this.endingAngle <= 450.0) {
            return -5;
        }
        if (this.startingAngle >= 90.0 && this.endingAngle <= 270.0) {
            return 5;
        }
        return 0;
    }

    private void drawCenterPoint(CGraphics g, Axis axis) {
        int width = axis.endp.y - axis.startp.y;
        int radius = (int)(this.getRadiusForInternalDial() * (double)width);
        if (radius <= 0) {
            return;
        }
        int centerX = axis.startp.x;
        int centerY = axis.startp.y;
        if (this.centerPt == null) {
            this.centerPt = this.createCenterPoint();
        }
        g.setColor(this.centerPt.getColor());
        boolean state = this.getPrimaryDataGradientSupport().isGradientEnabled();
        this.getPrimaryDataGradientSupport().setGradientEnabled(true);
        if (this.isDrawFullCircleForDial() || this.endingAngle - this.startingAngle >= 360.0) {
            g.fillArc(centerX, centerY, radius * 2, radius * 2, 0, 360, null, false, false);
        } else {
            int ptS = (int)(this.startingAngle % 360.0);
            ptS = (360 - ptS + 90) % 360;
            int ptE = (int)(this.endingAngle % 360.0);
            if (ptS < (ptE = (360 - ptE + 90) % 360)) {
                ptS += 360;
            }
            g.fillArc(centerX, centerY, radius * 2, radius * 2, ptE, ptS - ptE, null, false, false);
        }
        this.getPrimaryDataGradientSupport().setGradientEnabled(state);
    }

    private void drawArea(CGraphics g, MultiDimData data) {
        if (data.level < this.dataDim) {
            ICompareObject[] values = new NumberCompare[data.multiData.length];
            for (int i = 0; i < data.multiData.length; ++i) {
                values[i] = new NumberCompare(new Float(data.multiData[i].plotData.getValue()), i);
            }
            int[] index = SortObject.sortIndex(values, false);
            for (int i = 0; i < data.multiData.length; ++i) {
                this.drawArea(g, data.multiData[index[i]]);
            }
        } else {
            Color lineColor = data.area.areaColor;
            int p1X = data.area.p1.x;
            int p1Y = g.height - data.area.p1.y;
            int centerX = data.area.p2.x;
            int centerY = g.height - data.area.p2.y;
            if (this.showArrow && data.area2 != null && (this.getNeedleOption() == 1 || this.getNeedleOption() == 0)) {
                p1X = data.area2.p2.x;
                p1Y = g.height - data.area2.p2.y;
            }
            switch (this.getNeedleOption()) {
                case 1: {
                    this.drawPointer(g, p1X, p1Y, centerX, centerY + this.getCenterPointYOffset(), data.getLineThickness(), lineColor, data);
                    break;
                }
                case 2: {
                    this.drawTriangularPointer(g, p1X, p1Y, centerX, centerY + this.getCenterPointYOffset(), data.getLineThickness(), lineColor, data);
                    break;
                }
                case 0: {
                    Line.drawLine(g, p1X, p1Y, centerX, centerY + this.getCenterPointYOffset(), data.getLineThickness(), lineColor, data);
                    break;
                }
                case 4: {
                    this.drawRoundBlade(g, p1X, p1Y, centerX, centerY + this.getCenterPointYOffset(), data.getLineThickness(), lineColor, data);
                    break;
                }
                default: {
                    this.drawPointedBlade(g, p1X, p1Y, centerX, centerY + this.getCenterPointYOffset(), data.getLineThickness(), lineColor, data);
                }
            }
            if (!this.showArrow || data.area2 == null) {
                return;
            }
            int[] ptX = new int[]{data.area.p1.z, data.area2.p1.x, data.area2.p2.x, data.area2.p1.z};
            int[] ptY = new int[]{data.area.p2.z, data.area2.p1.y, data.area2.p2.y, data.area2.p2.z};
            g.setColor(lineColor);
            g.fillPolygon(new Polygon(ptX, ptY, 4), data);
        }
    }

    private void drawPointer(CGraphics g, int x2, int y2, int x1, int y1, int thick, Color color, MultiDimData data) {
        int diffX = (x2 - x1) / 3;
        int diffY = (y2 - y1) / 3;
        Line.drawLine(g, x1, y1, x1 + diffX, y1 + diffY, thick * 2, color.brighter(), data);
        Line.drawLine(g, x1 + diffX, y1 + diffY, x1 + diffX * 2, y1 + diffY * 2, thick, color, data);
        Line.drawLine(g, x1 + diffX * 2, y1 + diffY * 2, x2, y2, thick / 2, color.darker(), data);
    }

    private void drawPointedBlade(CGraphics g, int x2, int y2, int x1, int y1, int thick, Color color, MultiDimData data) {
        Line.drawPointedBlade(g, x1, y1, x2, y2, thick, color, data, false, true);
    }

    private void drawRoundBlade(CGraphics g, int x2, int y2, int x1, int y1, int thick, Color color, MultiDimData data) {
        Line.drawRoundBlade(g, x1, y1, x2, y2, thick, color, data, true);
    }

    private void drawTriangularPointer(CGraphics g, int x2, int y2, int x1, int y1, int thick, Color color, MultiDimData data) {
        Line.drawTriangularPointer(g, x1, y1, x2, y2, thick, color, data, false, true);
    }

    private MultiDimData selectArea(CGraphics g, MultiDimData data, int x, int y) {
        if (data.level < this.dataDim) {
            ICompareObject[] values = new NumberCompare[data.multiData.length];
            for (int i = 0; i < data.multiData.length; ++i) {
                values[i] = new NumberCompare(new Float(data.multiData[i].plotData.getValue()), i);
            }
            int[] index = SortObject.sortIndex(values, true);
            for (int i = 0; i < data.multiData.length; ++i) {
                if (this.selectArea(g, data.multiData[index[i]], x, y) == null) continue;
                return data.multiData[index[i]];
            }
        } else {
            int p1Y = g.height - data.area.p1.y;
            int p2Y = g.height - data.area.p2.y;
            if (Line.pickLine(data.area.p1.x, p1Y, data.area.p2.x, p2Y, x, y)) {
                return data;
            }
        }
        return null;
    }

    @Override
    public void drawAxis(CGraphics g, Axis axis) {
        if (g.g instanceof IFlashGraphics) {
            double[] flashVal = new double[]{0.98, 0.96, 0.92, 0.96, 0.98, 1.0, 0.98, 0.96, 0.98, 1.0, 0.99, 0.98, 0.99, 1.0};
            if (this.flashFrameCount > 1) {
                ((FlashGraphics)g.g).initFrameSet(this.flashFrameCount + flashVal.length);
            }
            int k = 0;
            for (int i = 0; i < this.flashFrameCount; ++i) {
                ((IFlashGraphics)((Object)g.g)).setFrame(k++);
                this.flashRatio = ((double)i + 1.0) / (double)this.flashFrameCount;
                this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                this.drawAxis_INTERNAL(g, axis);
            }
            if (this.flashFrameCount > 1) {
                for (double element : flashVal) {
                    ((IFlashGraphics)((Object)g.g)).setFrame(k++);
                    this.flashRatio = element;
                    this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                    this.drawAxis_INTERNAL(g, axis);
                }
            }
            ((IFlashGraphics)((Object)g.g)).setFrame(-1);
        } else {
            this.drawAxis_INTERNAL(g, axis);
        }
    }

    private void drawAxis_INTERNAL(CGraphics g, Axis axis) {
        this.drawAxisCircle(g, axis);
        this.drawArea(g, this.mData);
        this.drawCenterPoint(g, axis);
        if (this.showPoint) {
            this.mData.drawPoint(g);
        }
    }

    @Override
    public void draw(CGraphics g) {
        this.background.draw(g, this.background, null, true, this.background);
        this.border.draw(g);
        this.drawAxis(g, this.a_y);
        this.dataLineSet.drawDataLineList();
        this.drawLabel(g);
        this.mainTitle.draw(g);
    }

    @Override
    public Color getCenterColorForDial() {
        if (this.centerPt == null) {
            this.centerPt = this.createCenterPoint();
        }
        return this.centerPt.getColor();
    }

    @Override
    public void setCenterColorForDial(Color c) {
        if (this.centerPt == null) {
            this.centerPt = this.createCenterPoint();
        }
        this.centerPt.setColor(c);
    }

    private ControlRange createCenterPoint() {
        return new ControlRange(0.0, 0.0, Color.black, "Center", 0, 0, new Point(0, 0), false, false);
    }

    @Override
    public void drawDialPlotFGImage(Graphics g, Component component) {
        try {
            if (this.dialPlotFGImage != null && this.showDialPlotFGImage) {
                int h;
                int w;
                int y0;
                int x0;
                if (!this.isDrawFullCircleForDial() && this.startingAngle >= 0.0 && this.endingAngle <= 90.0) {
                    if (this.background.p2.x - this.background.p1.x > this.background.p2.y - this.background.p1.y) {
                        int diff = (int)(this.dialFGPlotSizeRatio * (double)(this.background.p2.y - this.background.p1.y));
                        x0 = this.background.p1.x - diff;
                        y0 = this.winHeight - this.background.p1.y - diff;
                        w = diff * 2;
                        h = diff * 2;
                    } else {
                        int diff = (int)(this.dialFGPlotSizeRatio * (double)(this.background.p2.x - this.background.p1.x));
                        x0 = this.background.p1.x - diff;
                        w = 2 * diff;
                        h = 2 * diff;
                        y0 = this.winHeight - (this.background.p1.y + h / 2);
                    }
                } else if (!this.isDrawFullCircleForDial() && this.startingAngle >= 90.0 && this.endingAngle <= 180.0) {
                    if (this.background.p2.x - this.background.p1.x > this.background.p2.y - this.background.p1.y) {
                        int diff = (int)(this.dialFGPlotSizeRatio * (double)(this.background.p2.y - this.background.p1.y));
                        x0 = this.background.p1.x - diff;
                        w = diff * 2;
                        h = diff * 2;
                        y0 = this.winHeight - (this.background.p2.y + h / 2);
                    } else {
                        int diff = (int)(this.dialFGPlotSizeRatio * (double)(this.background.p2.x - this.background.p1.x));
                        x0 = this.background.p1.x - diff;
                        w = diff * 2;
                        h = diff * 2;
                        y0 = this.winHeight - (this.background.p2.y + h / 2);
                    }
                } else if (!this.isDrawFullCircleForDial() && this.startingAngle >= 180.0 && this.endingAngle <= 270.0) {
                    if (this.background.p2.x - this.background.p1.x > this.background.p2.y - this.background.p1.y) {
                        int diff = (int)(this.dialFGPlotSizeRatio * (double)(this.background.p2.y - this.background.p1.y));
                        w = diff * 2;
                        h = diff * 2;
                        x0 = this.background.p2.x - diff;
                        y0 = this.winHeight - (this.background.p2.y + h / 2);
                    } else {
                        int diff = (int)(this.dialFGPlotSizeRatio * (double)(this.background.p2.x - this.background.p1.x));
                        x0 = this.background.p2.x - diff;
                        w = diff * 2;
                        h = diff * 2;
                        y0 = this.winHeight - (this.background.p2.y + h / 2);
                    }
                } else if (!this.isDrawFullCircleForDial() && this.startingAngle >= 270.0 && this.endingAngle <= 360.0) {
                    if (this.background.p2.x - this.background.p1.x > this.background.p2.y - this.background.p1.y) {
                        int diff = (int)(this.dialFGPlotSizeRatio * (double)(this.background.p2.y - this.background.p1.y));
                        w = diff * 2;
                        h = diff * 2;
                        x0 = this.background.p2.x - diff;
                        y0 = this.winHeight - (this.background.p1.y + h / 2);
                    } else {
                        int diff = (int)(this.dialFGPlotSizeRatio * (double)(this.background.p2.x - this.background.p1.x));
                        w = diff * 2;
                        h = diff * 2;
                        x0 = this.background.p2.x - diff;
                        y0 = this.winHeight - this.background.p1.y - h / 2;
                    }
                } else if (this.background.p2.x - this.background.p1.x > this.background.p2.y - this.background.p1.y) {
                    int diff = (int)(this.dialFGPlotSizeRatio * (double)(this.background.p2.y - this.background.p1.y));
                    x0 = this.background.p1.x + (this.background.p2.x - this.background.p1.x - diff) / 2;
                    y0 = this.winHeight - (this.background.p2.y + this.background.p1.y) / 2 - diff / 2;
                    w = diff;
                    h = diff;
                } else {
                    int diff = (int)(this.dialFGPlotSizeRatio * (double)(this.background.p2.x - this.background.p1.x));
                    x0 = (this.background.p1.x + this.background.p2.x) / 2 - diff / 2;
                    y0 = this.winHeight - this.background.p2.y + (this.background.p2.y - this.background.p1.y - diff) / 2;
                    w = diff;
                    h = diff;
                }
                this.dialPlotFGImage.draw(this, g, x0, y0, w, h, component);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to draw dial plot foreground image", ex);
        }
    }

    @Override
    public void drawDialPlotBGImage(Graphics g, Component component) {
        try {
            if (this.dialPlotBGImage != null && this.showDialPlotBGImage) {
                int h;
                int w;
                int y0;
                int x0;
                if (!this.isDrawFullCircleForDial() && this.startingAngle >= 0.0 && this.endingAngle <= 90.0) {
                    if (this.background.p2.x - this.background.p1.x > this.background.p2.y - this.background.p1.y) {
                        int diff = (int)(this.dialBGPlotSizeRatio * (double)(this.background.p2.y - this.background.p1.y));
                        x0 = this.background.p1.x - diff;
                        y0 = this.winHeight - this.background.p1.y - diff;
                        w = diff * 2;
                        h = diff * 2;
                    } else {
                        int diff = (int)(this.dialBGPlotSizeRatio * (double)(this.background.p2.x - this.background.p1.x));
                        x0 = this.background.p1.x - diff;
                        w = 2 * diff;
                        h = 2 * diff;
                        y0 = this.winHeight - (this.background.p1.y + h / 2);
                    }
                } else if (!this.isDrawFullCircleForDial() && this.startingAngle >= 90.0 && this.endingAngle <= 180.0) {
                    if (this.background.p2.x - this.background.p1.x > this.background.p2.y - this.background.p1.y) {
                        int diff = (int)(this.dialBGPlotSizeRatio * (double)(this.background.p2.y - this.background.p1.y));
                        x0 = this.background.p1.x - diff;
                        w = diff * 2;
                        h = diff * 2;
                        y0 = this.winHeight - (this.background.p2.y + h / 2);
                    } else {
                        int diff = (int)(this.dialBGPlotSizeRatio * (double)(this.background.p2.x - this.background.p1.x));
                        x0 = this.background.p1.x - diff;
                        w = diff * 2;
                        h = diff * 2;
                        y0 = this.winHeight - (this.background.p2.y + h / 2);
                    }
                } else if (!this.isDrawFullCircleForDial() && this.startingAngle >= 180.0 && this.endingAngle <= 270.0) {
                    if (this.background.p2.x - this.background.p1.x > this.background.p2.y - this.background.p1.y) {
                        int diff = (int)(this.dialBGPlotSizeRatio * (double)(this.background.p2.y - this.background.p1.y));
                        w = diff * 2;
                        h = diff * 2;
                        x0 = this.background.p2.x - diff;
                        y0 = this.winHeight - (this.background.p2.y + h / 2);
                    } else {
                        int diff = (int)(this.dialBGPlotSizeRatio * (double)(this.background.p2.x - this.background.p1.x));
                        x0 = this.background.p2.x - diff;
                        w = diff * 2;
                        h = diff * 2;
                        y0 = this.winHeight - (this.background.p2.y + h / 2);
                    }
                } else if (!this.isDrawFullCircleForDial() && this.startingAngle >= 270.0 && this.endingAngle <= 360.0) {
                    if (this.background.p2.x - this.background.p1.x > this.background.p2.y - this.background.p1.y) {
                        int diff = (int)(this.dialBGPlotSizeRatio * (double)(this.background.p2.y - this.background.p1.y));
                        w = diff * 2;
                        h = diff * 2;
                        x0 = this.background.p2.x - diff;
                        y0 = this.winHeight - (this.background.p1.y + h / 2);
                    } else {
                        int diff = (int)(this.dialBGPlotSizeRatio * (double)(this.background.p2.x - this.background.p1.x));
                        w = diff * 2;
                        h = diff * 2;
                        x0 = this.background.p2.x - diff;
                        y0 = this.winHeight - this.background.p1.y - h / 2;
                    }
                } else if (this.background.p2.x - this.background.p1.x > this.background.p2.y - this.background.p1.y) {
                    int diff = (int)(this.dialBGPlotSizeRatio * (double)(this.background.p2.y - this.background.p1.y));
                    x0 = this.background.p1.x + (this.background.p2.x - this.background.p1.x - diff) / 2;
                    y0 = this.winHeight - (this.background.p2.y + this.background.p1.y) / 2 - diff / 2;
                    w = diff;
                    h = diff;
                } else {
                    int diff = (int)(this.dialBGPlotSizeRatio * (double)(this.background.p2.x - this.background.p1.x));
                    x0 = (this.background.p1.x + this.background.p2.x) / 2 - diff / 2;
                    y0 = this.winHeight - this.background.p2.y + (this.background.p2.y - this.background.p1.y - diff) / 2;
                    w = diff;
                    h = diff;
                }
                this.dialPlotBGImage.draw(this, g, x0, y0, w, h, component);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to draw dial plot background image", ex);
        }
    }
}

