/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.general2d;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.MultiDimData;
import quadbase.chart.PlotData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Axis2D;
import quadbase.chart.chart2d.Chart2D;
import quadbase.chart.chart2d.Overlay2D;
import quadbase.chart.chart2d.types2d.general2d.LineChart2D;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.internal.Composite;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.RenderingChart;

public class OverlayChart2D
extends Chart2D {
    static final int PRIMARY_AXIS = -1;
    static final int SECONDARY_AXIS = -2;
    double[] minvalueA;
    double[] maxvalueA;

    public OverlayChart2D(Component component, ColData[] colData, boolean[] usedColumns) {
        super(component, 14, colData, usedColumns);
        if (this.nstring == 0) {
            if (this.nint + this.nreal == 0) {
                throw nocategoryError;
            }
            if (this.nint + this.nreal + this.ntime < 2) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.dataDim = 1;
            this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
        } else {
            this.mDataMap[0] = this.nstringcol[0];
            if (this.nstring == 1) {
                this.dataDim = 1;
            } else {
                this.mDataMap[1] = this.nstringcol[1];
                this.dataDim = 2;
            }
            if (this.nint + this.nreal + this.ntime < 1) {
                throw nonumericError;
            }
            int n = this.valueCol = this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0];
        }
        if (this.dataDim == 2) {
            this.showLine = true;
        }
        this.bvalueCol = true;
        this.makeTable();
        this.doTypeMapping();
    }

    public OverlayChart2D(Chart _chart) {
        super(14, _chart);
        if (!this.bvalueCol) {
            this.valueCol = _chart.coordCol[0];
            this.bvalueCol = true;
        }
        if (_chart.isStackType() && _chart.dataDim == 2) {
            this.mDataMap[0] = _chart.mDataMap[1];
            this.mDataMap[1] = _chart.mDataMap[0];
            this.dataDim = 2;
        } else {
            int n = this.dataDim = _chart.dataDim >= 2 || this.bmDataMap[1] ? 2 : 1;
        }
        if (!(_chart instanceof OverlayChart2D) && this.dataDim == 2) {
            this.showLine = true;
        }
        this.checkSpecialColumn(1);
        this.copyTable(_chart);
        this.doTypeMapping();
    }

    private void initSeriesType() {
        int[] axisType;
        int[] seriesType;
        if (this.dataDim == 2) {
            seriesType = new int[this.mDataLen[0]];
            axisType = new int[this.mDataLen[0]];
            for (int i = 0; i < this.mDataLen[0]; ++i) {
                seriesType[i] = this.colData[this.mDataMap[0]] != null && this.colData[this.mDataMap[0]].getFieldType() != null && i < this.colData[this.mDataMap[0]].getFieldType().length ? this.colData[this.mDataMap[0]].getFieldType()[i] : (i == 0 ? 7 : (i == 1 ? 0 : 3));
                axisType[i] = this.colData[this.mDataMap[0]] != null && this.colData[this.mDataMap[0]].getAxisPosition() != null && i < this.colData[this.mDataMap[0]].getAxisPosition().length ? this.colData[this.mDataMap[0]].getAxisPosition()[i] : -1;
            }
        } else {
            seriesType = new int[]{0};
            axisType = new int[]{-1};
        }
        this.setSeriesType(seriesType);
        this.setAxisPosition(axisType);
    }

    @Override
    public void doTypeMapping() {
        if (this.dataDim != 2 || this.getSeriesType() == null || this.getSeriesType().length != this.mDataLen[0]) {
            this.initSeriesType();
        }
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        boolean doSwapAxis;
        if (this.notEnoughData()) {
            return;
        }
        this.resortOverlayTemplateAttribute();
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(ymax - ymin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        StepSize ystep = null;
        StepSize ystep2 = null;
        StepSize[] yStepAxis = null;
        if (this.dataDim == 2) {
            yStepAxis = new StepSize[this.mDataLen[0]];
        }
        boolean bl = doSwapAxis = this.isSwapAxis && this.subvalueCol >= 0;
        if (this.isJoinAxis()) {
            this.findMinMaxVal();
            this.findMinMaxVal2();
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            this.a_y.setAxisGridY(ystep, xmin, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
            LineChart2D.lineData(this.dataDim, xmin, xmax, ystep2, this.mData2, this.mDataLen, true);
        } else if (doSwapAxis) {
            this.findMinMaxVal();
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            this.a_y.setAxisGridY(ystep, xmax, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            this.findMinMaxVal2();
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.a_s.setAxisGridY(ystep2, xmin, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
            LineChart2D.lineData(this.dataDim, xmin, xmax, ystep2, this.mData2, this.mDataLen, true);
        } else if (this.subvalueCol < 0 && this.drawSecAxisForOverlay()) {
            this.findMinMaxVal();
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            this.findMinMaxVal2();
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getVdec());
            this.a_y.setAxisGridY(ystep, xmin, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            if (this.secData == null || this.secData.getName() != this.colData[this.valueCol].getName() || this.secData.getOriginalDataType() != this.colData[this.valueCol].getOriginalDataType()) {
                ColData backupSecData = null;
                if (this.secData != null) {
                    backupSecData = this.secData;
                }
                this.secData = new ColData(this.colData[this.valueCol].getName(), "", this.colData[this.valueCol].getOriginalDataType(), -1, this.colData[this.valueCol].getStringDisplaySize(), this.colData.length);
                if (backupSecData != null) {
                    this.secData.copyAttributes(backupSecData);
                } else {
                    this.secData.copyAttributes(this.colData[this.valueCol]);
                }
            }
            this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.secData, this.axisThickness);
        } else {
            this.findMinMaxVal();
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            this.a_y.setAxisGridY(ystep, xmin, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            if (this.subvalueCol >= 0) {
                this.findMinMaxVal2();
                ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
                this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
                LineChart2D.lineData(this.dataDim, xmin, xmax, ystep2, this.mData2, this.mDataLen, true);
            }
        }
        if (yStepAxis != null) {
            if (this.axisData == null || this.axisData.length != yStepAxis.length || this.colDataAxis.length != yStepAxis.length) {
                this.axisData = new ColData[yStepAxis.length];
                this.colDataAxis = new Axis2D[yStepAxis.length];
            }
            int xorigin = this.calcNextAxisXOrigin(g, this.a_y);
            Font f = new Font("Courier", 1, 12);
            for (int i = 0; i < yStepAxis.length; ++i) {
                if (!this.drawAxis(i)) {
                    this.colDataAxis[i] = null;
                    this.axisData[i] = null;
                    continue;
                }
                if (this.colDataAxis[i] == null) {
                    this.colDataAxis[i] = this.setAxis(1, new CString("", f, 4), false);
                }
                yStepAxis[i] = new StepSize(this.colDataAxis[i], ymax, ymin, this.maxvalueA[i], this.minvalueA[i], fstep, this.getVdec());
                if (this.axisData[i] == null || this.axisData[i].getName() != this.colData[this.valueCol].getName() || this.axisData[i].getOriginalDataType() != this.colData[this.valueCol].getOriginalDataType()) {
                    this.axisData[i] = new ColData(this.colData[this.valueCol].getName(), this.colData[this.valueCol].getOriginalDataType(), this.colData.length);
                    this.axisData[i].copyAttributes(this.colData[this.valueCol]);
                }
                this.colDataAxis[i].setAxisShift(yStepAxis[i].minvalue);
                this.colDataAxis[i].setAxisGridY(yStepAxis[i], xorigin, xmin, xmax, this.axisData[i], this.axisThickness);
                this.colDataAxis[i].xorigin = xorigin;
                xorigin = this.calcNextAxisXOrigin(g, this.colDataAxis[i]);
            }
        } else {
            this.axisData = null;
            this.colDataAxis = null;
        }
        int noCategory = this.mDataLen[this.dataDim - 1];
        Point3D[] coord = Overlay2D.computeChart(this, this.dataDim, this.mDataLen, this.mData, ystep, ystep2, yStepAxis, xmin, xmax);
        if (this.subvalueCol < 0) {
            ystep2 = null;
        }
        this.setAutomatic(ystep2 != null);
        int colfield = this.mDataMap[this.dataDim - 1];
        this.a_x.set(xmin, ystep.zeroAxis, xmax, ystep.zeroAxis, this.axisThickness, this.colData[colfield].getFieldName(), coord, ystep.zeroAxis == ymax, this.colData[colfield]);
        if (this.isGridAlignedWithTicker()) {
            Point3D[] coord2 = new Point3D[noCategory];
            for (int i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(coord[i].x, ymin, 0);
            }
            this.a_x.grid.set(coord2, ymin, ymax);
        } else {
            Point3D[] coord2 = new Point3D[noCategory - 1];
            for (int i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D((coord[i].x + coord[i + 1].x) / 2, ymin, 0);
            }
            this.a_x.grid.set(coord2, ymin, ymax);
        }
        this.prepareLabel();
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }

    private final void resortOverlayTemplateAttribute() {
        int noChart = 1;
        if (this.dataDim == 2) {
            noChart = this.mDataLen[this.dataDim - 2];
        }
        if (this.getAxisPosition().length <= noChart && this.colData[this.mDataMap[0]].org_showAxis != null && noChart <= this.colData[this.mDataMap[0]].org_showAxis.length) {
            int[] axisPos = new int[noChart];
            int[] fieldType = new int[noChart];
            Axis[] org_colDataAxis = this.colData[this.mDataMap[0]].org_colDataAxis;
            for (int i = 0; i < noChart; ++i) {
                axisPos[i] = this.colData[this.mDataMap[0]].org_showAxis[i];
                fieldType[i] = this.colData[this.mDataMap[0]].org_fieldType[i];
                if (this.colDataAxis == null || this.colDataAxis.length <= i || this.colDataAxis[i] == null || org_colDataAxis == null || i >= org_colDataAxis.length || org_colDataAxis[i] == null) continue;
                this.colDataAxis[i] = org_colDataAxis[i];
            }
            this.colData[this.mDataMap[0]].setAxisPosition(axisPos);
            this.colData[this.mDataMap[0]].setFieldType(fieldType);
        }
    }

    private int calcNextAxisXOrigin(CGraphics g, Axis axis) {
        if (!this.isAutoAxisPosition()) {
            int res = axis.endp.x - this.getAxisGapOffset();
            return res > 0 ? res : 0;
        }
        int offset = 5 + this.getAxisGapOffset();
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(axis.font, this.mData.chart.isAdjustFont()));
        int minStr = fm.stringWidth(axis.formating(axis.stepsize.minvalue));
        int maxStr = fm.stringWidth(axis.formating(axis.stepsize.maxvalue));
        int res = axis.endp.x - ((minStr > maxStr ? minStr : maxStr) + (offset += axis.ticker.twidth));
        if (axis.title.bshow && axis.title.str != null && !axis.title.str.trim().equals("")) {
            FontMetrics fm2 = g.getFontMetrics(QbUtil.resizeViewerFont(axis.title.font, this.mData.chart.isAdjustFont()));
            int fstep = fm2.getMaxAscent() + fm2.getMaxDescent();
            res = res - axis.titleoffset - fstep;
        }
        return res > 0 ? res : 0;
    }

    @Override
    public void draw(CGraphics g) {
        this.background.draw(g, this.background, null, true, this.background);
        this.drawControlRange(g, 0);
        if (!this.isGridInFront()) {
            this.a_x.drawGrid(g);
            this.a_y.drawGrid(g);
            if (this.getChartType() == 14 && this.colDataAxis != null) {
                Axis[] axisArray = this.colDataAxis;
                int n = axisArray.length;
                for (int i = 0; i < n; ++i) {
                    Axis colDataAxi = axisArray[i];
                    if (colDataAxi == null) continue;
                    colDataAxi.drawGrid(g);
                }
            }
        }
        if (IOUtil.isJava2D()) {
            Axis[] backupG = g.g;
            Image buffImg = Composite.getBufferedImage((Graphics)backupG, this.winWidth, this.winHeight);
            g.g = Composite.createGraphics((Graphics)backupG, buffImg);
            this.drawChart(g);
            this.drawControlRange(g, 1);
            Composite.drawImage((Graphics)backupG, buffImg);
            g.g = backupG;
        } else {
            this.drawChart(g);
        }
        if (this.showLegend2()) {
            if (this.showLine2) {
                this.mData2.drawLine(g);
            }
            if (this.showPoint2) {
                this.mData2.drawPoint(g);
            }
        }
        this.dataLineSet.drawDataLineList();
        if (this.isGridInFront()) {
            this.a_x.drawGrid(g);
            this.a_y.drawGrid(g);
            if (this.getChartType() == 14 && this.colDataAxis != null) {
                for (Axis colDataAxi : this.colDataAxis) {
                    if (colDataAxi == null) continue;
                    colDataAxi.drawGrid(g);
                }
            }
        }
        this.border.draw(g);
        boolean restoreRendering = false;
        if (this.setAntiAliasForChartOnly && this.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        this.a_x.draw(g);
        this.a_y.draw(g);
        if (this.colDataAxis != null) {
            for (Axis colDataAxi : this.colDataAxis) {
                if (colDataAxi == null) continue;
                colDataAxi.draw(g);
            }
        }
        if (this.showLegend2() || this.drawSecAxisForOverlay()) {
            this.a_s.draw(g);
        }
        this.drawPoints(g);
        this.drawLabel(g);
        this.mainTitle.draw(g);
        if (restoreRendering) {
            this.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        if (this.checkZoomStatus() && this.getZoomOption() != -1) {
            this.drawScrollBars(g);
        }
    }

    @Override
    public void drawChart(CGraphics g) {
        if (g.g instanceof IFlashGraphics) {
            for (int i = 0; i < this.flashFrameCount; ++i) {
                ((IFlashGraphics)((Object)g.g)).setFrame(i);
                this.flashRatio = ((double)i + 1.0) / (double)this.flashFrameCount;
                this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                Overlay2D.drawChart(g, this, this.mData);
            }
            ((IFlashGraphics)((Object)g.g)).setFrame(-1);
        } else {
            Overlay2D.drawChart(g, this, this.mData);
        }
    }

    @Override
    public void findMinMaxVal() {
        this.setDefaultMinMaxValue(true);
        this.findData(this.mData, -1);
        this.checkMinMaxValue(true);
        this.findMinMaxValColAxis();
    }

    @Override
    public void findMinMaxVal2() {
        this.setDefaultMinMaxValue(false);
        this.findData(this.mData, -2);
        if (this.subvalueCol >= 0) {
            this.mData2.findMinMaxVal(this, false);
        }
        this.checkMinMaxValue(false);
    }

    private void findMinMaxValColAxis() {
        if (this.dataDim == 1) {
            return;
        }
        this.minvalueA = new double[this.mDataLen[0]];
        this.maxvalueA = new double[this.mDataLen[0]];
        for (int i = 0; i < this.minvalueA.length; ++i) {
            this.maxvalueA[i] = -1.7976931348623157E308;
            this.minvalueA[i] = Double.MAX_VALUE;
            this.findData(this.mData, i);
        }
    }

    private boolean drawAxis(int axisIdx) {
        return this.maxvalueA[axisIdx] != -1.7976931348623157E308;
    }

    private void findData(MultiDimData data, int findAxis) {
        int[] axisPos;
        int noChart = 1;
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        if (this.dataDim == 2) {
            noChart = this.mDataLen[this.dataDim - 2];
        }
        if ((axisPos = this.getAxisPosition()).length != noChart) {
            axisPos = this.getAxisPosition();
        }
        for (int i = 0; i < noChart; ++i) {
            if (this.dataDim == 2) {
                loc[0] = i;
            }
            for (int j = 0; j < noCategory; ++j) {
                double d;
                double val;
                loc[this.dataDim - 1] = j;
                PlotData plotData = data.getPlotData(loc);
                if (plotData.isEmpty()) continue;
                if (axisPos[i] == -1 || this.dataDim == 1) {
                    double d2;
                    val = plotData.getValue();
                    if (d2 > this.maxvalue) {
                        this.maxvalue = val;
                    }
                    if (!(val < this.minvalue)) continue;
                    this.minvalue = val;
                    continue;
                }
                if (axisPos[i] == -2) {
                    double d3;
                    val = plotData.getValue();
                    if (d3 > this.maxvalue2) {
                        this.maxvalue2 = val;
                    }
                    if (!(val < this.minvalue2)) continue;
                    this.minvalue2 = val;
                    continue;
                }
                if (findAxis != axisPos[i]) continue;
                val = plotData.getValue();
                if (d > this.maxvalueA[findAxis]) {
                    this.maxvalueA[findAxis] = val;
                }
                if (!(val < this.minvalueA[findAxis])) continue;
                this.minvalueA[findAxis] = val;
            }
        }
    }
}

