/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.general2d;

import java.awt.Component;
import java.awt.FontMetrics;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Coordinate;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Chart2D;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.QbUtil;

public class ScatterChart2D
extends Chart2D {
    public ScatterChart2D(Component component, ColData[] colData) {
        block12: {
            block10: {
                block13: {
                    block11: {
                        super(component, 2, colData);
                        this.showPoint = true;
                        this.showArea = false;
                        this.mDataMap[0] = this.nCol;
                        if (this.nint + this.nreal + this.ndatetime < 1) {
                            throw nonumericError;
                        }
                        this.dataDim = 1;
                        if (this.nint + this.nreal + this.ndatetime != 1) break block10;
                        if (this.nint <= 0) break block11;
                        this.mDataMap[0] = this.mDataMap[1] = this.nintcol[0];
                        this.coordCol[0] = this.coordCol[1] = this.nintcol[0];
                        break block12;
                    }
                    if (this.nreal <= 0) break block13;
                    this.mDataMap[0] = this.mDataMap[1] = this.nrealcol[0];
                    this.coordCol[0] = this.coordCol[1] = this.nrealcol[0];
                    break block12;
                }
                if (this.ndatetime <= 0) break block12;
                this.mDataMap[0] = this.mDataMap[1] = this.ndatetimecol[0];
                this.coordCol[0] = this.coordCol[1] = this.ndatetimecol[0];
                break block12;
            }
            int nrealCt = 0;
            int ntimeCt = 0;
            int nintCt = 0;
            int coordCt = 2;
            if (!this.is2DChart && this.nint + this.nreal + this.ndatetime > 2) {
                coordCt = 3;
            }
            int i = 0;
            if (this.nint + this.nreal == 1) {
                this.coordCol[i++] = this.ndatetimecol[ntimeCt++];
            }
            while (i < coordCt) {
                if (this.nreal > nrealCt) {
                    this.coordCol[i] = this.nrealcol[nrealCt++];
                } else if (this.nint > nintCt) {
                    this.coordCol[i] = this.nintcol[nintCt++];
                } else if (this.ndatetime > ntimeCt) {
                    this.coordCol[i] = this.ndatetimecol[ntimeCt++];
                }
                ++i;
            }
        }
        this.bcoordCol[1] = true;
        this.bcoordCol[0] = true;
        if (!this.is2DChart) {
            this.bcoordCol[2] = true;
        }
        this.makeTable();
        this.setDateTimeAxes();
    }

    public ScatterChart2D(Chart _chart) {
        super(2, _chart);
        if (_chart.getChartType() != 2) {
            this.showArea = false;
            this.showPoint = true;
        }
        if (!this.bcoordCol[0]) {
            this.coordCol[0] = this.valueCol;
            if (this.nreal + this.nint < 2) {
                this.coordCol[1] = this.valueCol;
            } else {
                this.coordCol[1] = this.valueCol;
                this.addNewColumnFromDataMapping = true;
                this.coordCol[1] = this.nreal > 0 ? (this.nrealcol[0] != this.valueCol ? this.nrealcol[0] : (this.nreal > 1 ? this.nrealcol[1] : this.nintcol[0])) : (this.nintcol[0] != this.valueCol ? this.nintcol[0] : this.nintcol[1]);
            }
            this.bcoordCol[1] = true;
            this.bcoordCol[0] = true;
            this.bcoordCol[2] = false;
            this.dataDim = 1;
            this.mDataMap[0] = this.nCol;
        } else {
            if (!this.is2DChart && !this.bcoordCol[2]) {
                this.bcoordCol[2] = false;
            }
            if (_chart.chartType == 2 || _chart.chartType == 19) {
                this.dataDim = _chart.dataDim;
                this.mDataMap[0] = _chart.mDataMap[0];
                if (_chart.chartType == 19) {
                    this.bcoordCol[2] = false;
                }
                if (!_chart.is2DChart) {
                    this.bcoordCol[2] = false;
                }
            } else {
                this.bcoordCol[2] = false;
                this.dataDim = 1;
                this.mDataMap[0] = this.nCol;
            }
        }
        this.copyTable(_chart);
        this.setDateTimeAxes();
    }

    private void setDateTimeAxes() {
        this.labelDateTime[0] = DataType.isDateTime(this.colData[this.coordCol[0]].axisType);
        this.labelDateTime[1] = DataType.isDateTime(this.colData[this.coordCol[1]].axisType);
        this.a_x.displayLabelAsDate = this.labelDateTime[0];
        this.a_y.displayLabelAsDate = this.labelDateTime[1];
        this.a_x.setTimeChart(true);
        this.a_y.setTimeChart(true);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        if (this.notEnoughData()) {
            return;
        }
        this.findMinMaxCoord();
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        StepSize ystep = new StepSize(this.a_y, ymax, ymin, this.maxCoord.y, this.minCoord.y, (int)((double)(ymax - ymin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent()))), this.getCoorddec(this.coordCol[1]), DataType.isDateTime(this.colData[this.coordCol[1]].axisType));
        fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_x.font, this.mData.chart.isAdjustFont()));
        StepSize xstep = new StepSize(this.a_x, xmax, xmin, this.maxCoord.x, this.minCoord.x, (int)((double)(xmax - xmin) / (5.0 * (double)fm.charWidth('8'))), this.getCoorddec(this.coordCol[0]), DataType.isDateTime(this.colData[this.coordCol[0]].axisType));
        this.a_y.setAxisGridY(ystep, xstep.zeroAxis, xmin, xmax, this.colData[this.coordCol[1]], this.axisThickness);
        this.a_x.setAxisGridX(xstep, ystep.zeroAxis, ymin, ymax, this.colData[this.coordCol[0]], this.axisThickness);
        if (xstep.zeroAxis != xmin && xstep.zeroAxis != xmax) {
            CString s;
            s.setPlacement((s = this.a_y.ticker.label[ystep.stepBelow]).getPlacement() == 2 ? 5 : 8);
        }
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        if (this.dataDim == 1) {
            for (int i = 0; i < noCategory; ++i) {
                loc[0] = i;
                this.setPointCoord(xstep, ystep, loc);
                this.mData.multiData[i].point.automatic = true;
            }
        } else {
            int noSeries = this.mDataLen[0];
            for (int i = 0; i < noSeries; ++i) {
                loc[0] = i;
                this.mData.multiData[i].point.automatic = false;
                for (int j = 0; j < noCategory; ++j) {
                    loc[1] = j;
                    this.setPointCoord(xstep, ystep, loc);
                    this.mData.multiData[i].multiData[j].point.automatic = true;
                }
            }
        }
        this.setAutomatic(false);
        this.mData.sortPoint();
        this.prepareLabel();
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }

    @Override
    public void draw(CGraphics g) {
        this.draw2D(g, 2);
    }

    @Override
    public void drawChart(CGraphics g) {
        this.drawChart2D(g, 2);
    }

    private void setPointCoord(StepSize xstep, StepSize ystep, int[] loc) {
        int yPt;
        int xPt;
        Coordinate coord = (Coordinate)this.mData.getElement(loc);
        if (coord == null) {
            return;
        }
        if (this.flashRatio != 1.0) {
            double avgX = (xstep.maxvalue - xstep.minvalue) / 2.0;
            double avgY = (ystep.maxvalue - ystep.minvalue) / 2.0;
            xPt = xstep.interpolatePixel((coord.x - avgX) * this.flashRatio + avgX);
            yPt = ystep.interpolatePixel((coord.y - avgY) * this.flashRatio + avgY);
        } else {
            xPt = xstep.interpolatePixel(coord.x);
            yPt = ystep.interpolatePixel(coord.y);
        }
        int yPt2 = yPt;
        if (this.isAreaCutOffSupport() && coord.y > this.getAreaCutOffPoint()) {
            yPt2 = ystep.interpolatePixel(this.getAreaCutOffPoint());
        }
        int bWidth = (int)Math.ceil(10.0 - this.barwidthRatio);
        this.mData.setAreaCoord(xPt - bWidth, xPt + bWidth, yPt2, ystep.zeroAxis, loc, false);
        this.mData.setPointCoord(xPt, yPt, loc);
    }
}

