/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.hilow2d;

import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.HiLowData;
import quadbase.chart.IHLCOChart;
import quadbase.chart.MultiDimData;
import quadbase.chart.chart2d.types2d.hilow2d.HiLowChart2D;

public class HLCOChart2D
extends HiLowChart2D
implements IHLCOChart {
    public HLCOChart2D(Component component, ColData[] colData) {
        super(component, colData, 10);
    }

    public HLCOChart2D(Chart _chart) {
        super(_chart, 10);
    }

    @Override
    public void drawSym(CGraphics g, Color c, int x1, int x2, HiLowData hilow, MultiDimData data, boolean candleStick) {
        double w2 = Math.max((int)((float)(x2 - x1) * this.candleWidth) / 2, 1);
        double m = (double)(x1 + x2) / 2.0;
        g.setColor(c);
        HiLowData orgData = data.orgHilow;
        int vhi = (int)hilow.vhi;
        int vlow = (int)hilow.vlow;
        int vopen = (int)Math.round(hilow.vopen);
        int vclose = (int)Math.round(hilow.vclose);
        if (this.isValueZoom()) {
            int origin = this.chartyorigin;
            int top = this.chartyorigin + this.chartheight;
            if (vhi > top) {
                vhi = top;
            }
            if (vhi < origin) {
                vhi = origin;
            }
            if (vlow < origin) {
                vlow = origin;
            }
            if (vlow > top) {
                vlow = top;
            }
            if (candleStick) {
                if (vopen > top) {
                    vopen = top;
                }
                if (vopen < origin) {
                    vopen = origin;
                }
                if (vclose < origin) {
                    vclose = origin;
                }
                if (vclose > top) {
                    vclose = top;
                }
            } else {
                if (vopen > top) {
                    vopen = -1;
                }
                if (vopen < origin) {
                    vopen = -1;
                }
                if (vclose < origin) {
                    vclose = -1;
                }
                if (vclose > top) {
                    vclose = -1;
                }
            }
        }
        if (vhi != vlow) {
            g.fillArea((int)Math.round(m - w2), vhi, (int)Math.round(m + w2), vlow, 1, 1, data, false, 0, this.getPrimaryDataGradientSupport());
            this.drawBorder(g, c, (int)Math.round(m - w2), vhi, (int)Math.round(m + w2), vlow);
        }
        if (candleStick) {
            if (hilow.vopen != -1.7976931348623157E308 && hilow.vclose != -1.7976931348623157E308) {
                if (orgData.vopen > orgData.vclose) {
                    g.setColor(this.candleDownColor);
                } else {
                    g.setColor(this.candleUpColor);
                }
                g.fillArea(x1, vopen, x2, vclose, 1, 1, data, false, 0, this.getPrimaryDataGradientSupport());
                this.drawBorder(g, c, x1, vopen, x2, vclose);
            }
        } else {
            if (hilow.vopen != -1.7976931348623157E308 && vopen != -1) {
                g.fillArea(x1, (int)Math.round((double)vopen + w2), (int)Math.round(m - w2), (int)Math.round((double)vopen - w2), 1, 1, data, false, 0, this.getPrimaryDataGradientSupport());
                this.drawBorder(g, c, x1, (int)Math.round((double)vopen + w2), (int)Math.round(m - w2), (int)Math.round((double)vopen - w2));
            }
            if (hilow.vclose != -1.7976931348623157E308 && vclose != -1) {
                g.fillArea((int)Math.round(m + w2), (int)Math.round((double)vclose + w2), x2, (int)Math.round((double)vclose - w2), 1, 1, data, false, 0, this.getPrimaryDataGradientSupport());
                this.drawBorder(g, c, (int)Math.round(m + w2), (int)Math.round((double)vclose + w2), x2, (int)Math.round((double)vclose - w2));
            }
        }
    }

    private void drawBorder(CGraphics g, Color c, int x1, int y1, int x2, int y2) {
        if (g.chart.isDrawBorderForWhiteArea() && c.getRGB() == Color.white.getRGB() || g.chart.getDataBorder()) {
            g.setColor(g.chart.getDataBorderColor());
            g.drawBorder(x1, y1, x2, y2, 1, false, 0);
            g.setColor(c);
        }
    }

    @Override
    public void prepareSym(Object sp, Vector vec, Color c, int x1, int x2, int z1, int z2, HiLowData hilow, Object obj, boolean candle) {
    }
}

