/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.stack2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.MultiDimData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.Chart2D;
import quadbase.chart.chart2d.Overlay2D;
import quadbase.chart.chart2d.types2d.stack2d.StackChart2D;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.common.util.internal.QbUtil;
import quadbase.util.internal.Composite;
import quadbase.util.internal.IOUtil;

public class StackAreaChart2D
extends Chart2D {
    public StackAreaChart2D(Component component, ColData[] colData) {
        super(component, 8, colData);
        if (this.nstring == 0) {
            if (this.nint < 1) {
                throw notenoughError;
            }
            if (this.nint + this.nreal + this.ntime < 3) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 1 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.mDataMap[1] = this.nintcol[iindex++];
            this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
        } else {
            this.mDataMap[1] = this.nstringcol[0];
            if (this.nstring == 1) {
                if (this.nint + this.nreal < 2) {
                    throw nonumericError;
                }
                int rindex = 0;
                int iindex = 0;
                this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
                this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
            } else {
                this.mDataMap[0] = this.nstringcol[1];
                if (this.nint + this.nreal + this.ntime < 1) {
                    throw nonumericError;
                }
                this.valueCol = this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0];
            }
        }
        this.bvalueCol = true;
        this.dataDim = 2;
        this.makeTable();
    }

    public StackAreaChart2D(Chart _chart) {
        super(8, _chart);
        if (!this.bvalueCol) {
            this.valueCol = _chart.coordCol[0];
            this.bvalueCol = true;
        }
        if (_chart.dataDim >= 3) {
            int t = this.mDataMap[0];
            this.mDataMap[0] = this.mDataMap[1];
            this.mDataMap[1] = this.mDataMap[2];
            this.mDataMap[2] = t;
        } else if (_chart.dataDim == 1) {
            if (!this.bmDataMap[1]) {
                if (this.nstring + this.nint < 1) {
                    throw notenoughError;
                }
                if (this.nstring + this.nint + this.nreal < 2) {
                    throw notenoughError;
                }
                this.mDataMap[1] = this.nstring >= 2 ? (this.mDataMap[0] == this.nstringcol[0] ? this.nstringcol[1] : this.nstringcol[0]) : (this.nstring == 1 ? (this.mDataMap[0] == this.nstringcol[0] && this.nint > 0 ? this.nintcol[0] : this.nstringcol[0]) : (this.mDataMap[0] == this.nintcol[0] && this.nint > 1 ? this.nintcol[1] : this.nintcol[0]));
                this.addNewColumnFromDataMapping = true;
            }
            this.bmDataMap[2] = false;
        } else {
            if (_chart.isStackType() && _chart.dataDim == 2) {
                if (this.chartType == _chart.chartType) {
                    this.mDataMap[0] = _chart.mDataMap[0];
                    this.mDataMap[1] = _chart.mDataMap[1];
                } else {
                    this.mDataMap[0] = _chart.mDataMap[1];
                    this.mDataMap[1] = _chart.mDataMap[0];
                }
            }
            this.bmDataMap[2] = false;
        }
        this.dataDim = 2;
        this.checkSpecialColumn(2);
        this.copyTable(_chart);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        boolean doSwapAxis;
        if (this.notEnoughData()) {
            return;
        }
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(ymax - ymin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        StepSize ystep = null;
        StepSize ystep2 = null;
        boolean bl = doSwapAxis = this.isSwapAxis && this.subvalueCol >= 0;
        if (this.isJoinAxis()) {
            this.findMinMaxSum();
            if (this.comboType == 0 || this.comboType == 3) {
                this.findMinMaxVal2();
            } else {
                this.findMinMaxCumSum2();
            }
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            ystep.zeroAxis = ystep.interpolatePixel(0.0);
            this.a_y.setAxisGridY(ystep, xmin, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
            this.yAxisCenter = ystep.zeroAxis;
        } else if (doSwapAxis) {
            this.findMinMaxSum();
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            ystep.zeroAxis = ystep.interpolatePixel(0.0);
            this.a_y.setAxisGridY(ystep, xmax, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            if (this.comboType == 0 || this.comboType == 3) {
                this.findMinMaxVal2();
            } else {
                this.findMinMaxCumSum2();
            }
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.yAxisCenter = ystep.zeroAxis;
            this.a_s.setAxisGridY(ystep2, xmin, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
            this.a_s.grid.bshow = true;
        } else {
            this.findMinMaxCumSum();
            ystep = new StepSize(this.a_y, ymax, ymin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            ystep.zeroAxis = ystep.interpolatePixel(0.0);
            this.a_y.setAxisGridY(ystep, xmin, xmin, xmax, this.colData[this.valueCol], this.axisThickness);
            if (this.subvalueCol >= 0) {
                this.findMinMaxVal2();
                ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
                this.a_s.setAxisGridY(ystep2, xmax, xmin, xmax, this.colData[this.subvalueCol], this.axisThickness);
            }
            this.yAxisCenter = ystep.zeroAxis;
            this.a_s.grid.bshow = true;
        }
        int noCategory = this.mDataLen[0];
        Point3D[] coord = new Point3D[noCategory];
        int noSum = this.mDataLen[1];
        int[] loc = new int[this.dataDim];
        double delta = (double)(xmax - xmin) / ((double)noCategory - 1.0);
        double nextx = xmin;
        if (ystep2 != null && this.getComboType() == 3 && this.getComboSeries() >= 0 || this.showOffsetTicker()) {
            delta = (double)(xmax - xmin) / (double)noCategory;
            nextx = (double)xmin + delta / 2.0;
        }
        for (int i = 0; i < noCategory; ++i) {
            loc[0] = i;
            double sum = 0.0;
            for (int j = 0; j < noSum; ++j) {
                loc[1] = j;
                sum += this.mData.getValue(loc) * this.flashRatio;
                if (this.isDataLimitAtAxisScale()) {
                    if (sum > this.a_y.maxScale) {
                        sum = this.a_y.maxScale;
                    } else if (sum < this.a_y.minScale) {
                        sum = this.a_y.minScale;
                    }
                }
                this.mData.setPointCoord((int)nextx, ystep.interpolatePixel(sum), loc);
                this.mData.setFlashPointCoord((int)nextx, ystep.interpolatePixel(sum - this.mData.getValue(loc) / 2.0), loc);
                if (ystep2 == null || this.getComboType() == 3) continue;
                double value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) : this.mData2.getValue(loc);
                this.mData2.setPointCoord((int)nextx, ystep2.interpolatePixel(value), loc);
            }
            coord[i] = new Point3D((int)nextx, ystep.zeroAxis, 0);
            nextx += delta;
        }
        if (ystep2 != null && this.getComboType() == 3 && this.getComboSeries() >= 0) {
            Overlay2D.computeChart(this, this.mData2.chart.dataDim, this.mData2.chart.mDataLen, this.mData2, ystep, ystep2, xmin, xmax);
        }
        int colfield = this.mDataMap[0];
        this.a_x.set(xmin, ystep.zeroAxis, xmax, ystep.zeroAxis, this.axisThickness, this.colData[colfield].getFieldName(), coord, ystep.zeroAxis == ymax, this.colData[colfield]);
        Point3D[] coord2 = new Point3D[noCategory];
        for (int i = 0; i < coord2.length; ++i) {
            coord2[i] = new Point3D(coord[i].x, ymin, 0);
        }
        this.a_x.grid.set(coord2, ymin, ymax);
        this.syncColor();
        this.prepareLabel();
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }

    static void fillStackArea(CGraphics g, Chart chart, boolean fill, MultiDimData data) {
        Point3D[] points = chart.a_x.ticker.point;
        boolean[] hideData = chart.colData[chart.mDataMap[1]].hideData;
        for (int i = 0; i < chart.mDataLen[0] - 1; ++i) {
            int lasty2;
            int lastx1 = points[i].x;
            int lastx2 = points[i + 1].x;
            int lasty1 = lasty2 = chart.yAxisCenter;
            for (int j = 0; j < chart.mDataLen[1]; ++j) {
                boolean hideDataArea;
                Polygon p = new Polygon();
                p.addPoint(lastx2, lasty2);
                p.addPoint(lastx1, lasty1);
                MultiDimData m1 = data.multiData[i].multiData[j];
                MultiDimData m2 = data.multiData[i + 1].multiData[j];
                lastx1 = m1.point.x;
                lasty1 = m1.point.y;
                lastx2 = m2.point.x;
                lasty2 = m2.point.y;
                p.addPoint(lastx1, lasty1);
                p.addPoint(lastx2, lasty2);
                boolean bl = hideDataArea = hideData == null || j >= hideData.length ? false : hideData[j];
                if (hideDataArea || m1.plotData.isEmpty() || m2.plotData.isEmpty()) continue;
                if (fill) {
                    g.setColor(m1.area.areaColor);
                    g.fillPolygon(p, m1);
                } else {
                    g.drawLineForArea(p, i == 0, i == chart.mDataLen[0] - 2, m1.area.areaColor.darker());
                }
                if (!chart.isDrawBorderForWhiteArea() || m1.area.areaColor.getRGB() != Color.white.getRGB()) continue;
                g.drawLineForArea(p, i == 0, i == chart.mDataLen[0] - 2, Color.black);
            }
        }
    }

    @Override
    public void draw(CGraphics g) {
        Image buffImg;
        Graphics backupG;
        this.background.draw(g, this.background, null, true, this.background);
        this.drawControlRange(g, 0);
        if (!this.isGridInFront()) {
            this.a_x.drawGrid(g);
            this.a_y.drawGrid(g);
        }
        if (IOUtil.isJava2D()) {
            backupG = g.g;
            buffImg = Composite.getBufferedImage(backupG, this.winWidth, this.winHeight);
            g.g = Composite.createGraphics(backupG, buffImg);
            this.drawChart(g);
            this.drawControlRange(g, 1);
            Composite.drawImage(backupG, buffImg);
            g.g = backupG;
        } else {
            this.drawChart(g);
        }
        this.dataLineSet.drawDataLineList();
        if (this.isGridInFront()) {
            this.a_x.drawGrid(g);
            this.a_y.drawGrid(g);
        }
        if (this.subvalueCol >= 0) {
            this.a_s.draw(g);
        }
        this.border.draw(g);
        this.a_x.draw(g);
        this.a_y.draw(g);
        if (IOUtil.isJava2D()) {
            backupG = g.g;
            buffImg = Composite.getBufferedImage(backupG, this.winWidth, this.winHeight);
            g.g = Composite.createGraphics(backupG, buffImg);
            this.drawPoints(g);
            this.drawControlRange(g, 2);
            Composite.drawImage(backupG, buffImg);
            g.g = backupG;
        }
        this.mainTitle.draw(g);
        if (this.legend2.chart != null) {
            this.legend2.chart.cgraphics = g;
        }
    }

    @Override
    public void drawChart(CGraphics g) {
        if (g.g instanceof IFlashGraphics) {
            for (int i = 0; i < this.flashFrameCount; ++i) {
                ((IFlashGraphics)((Object)g.g)).setFrame(i);
                this.flashRatio = ((double)i + 1.0) / (double)this.flashFrameCount;
                this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                StackAreaChart2D.fillStackArea(g, this, true, this.mData);
                if (this.drawDataBorder) {
                    StackAreaChart2D.fillStackArea(g, this, false, this.mData);
                }
                if (this.showLine) {
                    this.mData.drawLine(g);
                }
                if (this.showPoint) {
                    this.mData.drawPoint(g);
                }
                if (this.subvalueCol >= 0) {
                    if (this.getComboType() == 3 && this.getComboSeries() >= 0) {
                        Overlay2D.drawArea(g, this, this.mData2);
                        if (this.showLine2) {
                            Overlay2D.drawLine(g, this, this.mData2);
                        }
                    } else if (this.showLine2) {
                        StackChart2D.drawLine(g, this.mData2, this.mDataLen, this.dataDim, this.isDataLimitAtAxisScale());
                    }
                    if (this.showPoint2) {
                        this.mData2.drawPoint(g);
                    }
                }
                this.drawLabel(g);
            }
            ((IFlashGraphics)((Object)g.g)).setFrame(-1);
        } else {
            StackAreaChart2D.fillStackArea(g, this, true, this.mData);
            if (this.drawDataBorder) {
                StackAreaChart2D.fillStackArea(g, this, false, this.mData);
            }
            if (this.showLine) {
                this.mData.drawLine(g);
            }
            if (this.showPoint) {
                this.mData.drawPoint(g);
            }
            if (this.subvalueCol >= 0) {
                if (this.getComboType() == 3 && this.getComboSeries() >= 0) {
                    Overlay2D.drawArea(g, this, this.mData2);
                    if (this.showLine2) {
                        Overlay2D.drawLine(g, this, this.mData2);
                    }
                } else if (this.showLine2) {
                    StackChart2D.drawLine(g, this.mData2, this.mDataLen, this.dataDim, this.isDataLimitAtAxisScale());
                }
                if (this.showPoint2) {
                    this.mData2.drawPoint(g);
                }
            }
            this.drawLabel(g);
        }
    }

    @Override
    public boolean notEnoughData() {
        return this.nRow <= 1;
    }
}

