/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.stack2d;

import java.awt.Component;
import java.awt.FontMetrics;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.types2d.stack2d.StackChart2D;
import quadbase.common.util.internal.QbUtil;

public class StackBarChart2D
extends StackChart2D {
    public StackBarChart2D(Component component, ColData[] colData, boolean[] usedColumns) {
        super(component, 5, colData, usedColumns);
    }

    public StackBarChart2D(Chart _chart) {
        super(5, _chart);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        int currentx;
        double t;
        int lastx1;
        int lastx2;
        double sum1;
        double sum2;
        boolean doSwapAxis;
        if (this.notEnoughData()) {
            return;
        }
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_x.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(xmax - xmin) / (2.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        StepSize xstep = null;
        StepSize xstep2 = null;
        boolean bl = doSwapAxis = this.isSwapAxis && this.subvalueCol >= 0;
        if (this.isJoinAxis()) {
            this.findMinMaxSum();
            this.findMinMaxVal2();
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
            xstep = new StepSize(this.a_x, xmax, xmin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            if (!this.checkZoomStatus() || this.getZoomOption() == -1) {
                xstep.zeroAxis = xstep.interpolatePixel(0.0);
            }
            this.a_x.setAxisGridX(xstep, ymin, ymin, ymax, this.colData[this.valueCol], this.axisThickness);
            xstep2 = new StepSize(this.a_s, xmax, xmin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.a_s.setAxisGridX(xstep2, ymax, ymin, ymax, this.colData[this.subvalueCol], this.axisThickness);
        } else if (doSwapAxis) {
            this.findMinMaxSum();
            xstep = new StepSize(this.a_x, xmax, xmin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            if (!this.checkZoomStatus() || this.getZoomOption() == -1) {
                xstep.zeroAxis = xstep.interpolatePixel(0.0);
            }
            this.a_x.setAxisGridX(xstep, ymax, ymin, ymax, this.colData[this.valueCol], this.axisThickness);
            this.findMinMaxVal2();
            xstep2 = new StepSize(this.a_s, xmax, xmin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
            this.a_s.setAxisGridX(xstep2, ymin, ymin, ymax, this.colData[this.subvalueCol], this.axisThickness);
        } else {
            this.findMinMaxSum();
            xstep = new StepSize(this.a_x, xmax, xmin, this.maxvalue, this.minvalue, fstep, this.getVdec());
            if (!this.checkZoomStatus() || this.getZoomOption() == -1) {
                xstep.zeroAxis = xstep.interpolatePixel(0.0);
            }
            this.a_x.setAxisGridX(xstep, ymin, ymin, ymax, this.colData[this.valueCol], this.axisThickness);
            if (this.subvalueCol >= 0) {
                this.findMinMaxVal2();
                xstep2 = new StepSize(this.a_s, xmax, xmin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
                this.a_s.setAxisGridX(xstep2, ymax, ymin, ymax, this.colData[this.subvalueCol], this.axisThickness);
            }
        }
        int noCategory = this.mDataLen[this.dataDim - 2];
        int[] loc = new int[this.dataDim];
        Point3D[] coord = new Point3D[noCategory];
        boolean zoomYDir = this.isYZoomed && (this.getZoomOption() == 1 || this.getZoomOption() == 2);
        double maxColWidth = (double)(xmax - xmin) * this.getMaxBarWidthRatioToPlotArea();
        if (this.dataDim == 2) {
            double delta = (double)(ymax - ymin) / ((double)noCategory * (1.0 + this.barwidthRatio));
            double delta2 = delta * this.barwidthRatio;
            if (delta > maxColWidth) {
                delta2 += delta - maxColWidth;
                delta = maxColWidth;
            }
            double lasty = (double)ymin + delta2 / 2.0;
            for (int i = 0; i < noCategory; ++i) {
                double nexty = lasty + delta;
                loc[0] = i;
                sum2 = 0.0;
                sum1 = 0.0;
                lastx1 = lastx2 = xstep.zeroAxis;
                int m = (int)((lasty + nexty) / 2.0);
                if (zoomYDir && ((m = this.calculateZoomedY(m)) < this.chartyorigin || m > this.chartyorigin + this.chartheight)) {
                    m = -100;
                }
                for (int j = 0; j < this.mDataLen[1]; ++j) {
                    double d;
                    loc[1] = j;
                    t = this.mData.getValue(loc) * this.flashRatio;
                    if (d >= 0.0) {
                        sum1 += t;
                        if (this.isDataLimitAtAxisScale() && sum1 > this.a_x.maxScale) {
                            sum1 = this.a_x.maxScale;
                        }
                        currentx = xstep.interpolatePixel(sum1);
                        this.mData.setAreaCoord(currentx, lastx1, (int)lasty, (int)nexty, loc, zoomYDir);
                        lastx1 = currentx;
                    } else {
                        sum2 += t;
                        if (this.isDataLimitAtAxisScale() && sum2 < this.a_x.minScale) {
                            sum2 = this.a_x.minScale;
                        }
                        currentx = xstep.interpolatePixel(sum2);
                        this.mData.setAreaCoord(currentx, lastx2, (int)lasty, (int)nexty, loc, zoomYDir);
                        lastx2 = currentx;
                    }
                    if (xstep2 == null) continue;
                    double value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                    this.mData2.setPointCoord(xstep2.interpolatePixel(value), m, loc);
                }
                coord[i] = new Point3D(xstep.zeroAxis, m, 0);
                lasty = nexty + delta2;
            }
        } else {
            int noSeries = this.mDataLen[0];
            double delta = (double)(ymax - ymin) / ((double)noCategory * (this.barwidthRatio + (double)noSeries));
            double delta2 = delta * this.barwidthRatio;
            double newBarWidthRatio = this.barwidthRatio;
            if (delta > maxColWidth) {
                delta2 += (delta - maxColWidth) * (double)noSeries;
                delta = maxColWidth;
                newBarWidthRatio = delta2 / delta;
            }
            double lasty = (double)ymin + delta2 / 2.0;
            double a = (newBarWidthRatio + (double)noSeries) * delta;
            double b = lasty + (double)noSeries * delta / 2.0;
            for (int i = 0; i < noCategory; ++i) {
                loc[1] = i;
                for (int j = 0; j < noSeries; ++j) {
                    loc[0] = j;
                    double nexty = lasty + delta;
                    lastx1 = lastx2 = xstep.zeroAxis;
                    sum2 = 0.0;
                    sum1 = 0.0;
                    int m = (int)((lasty + nexty) / 2.0);
                    if (zoomYDir && ((m = this.calculateZoomedY(m)) < this.chartyorigin || m > this.chartyorigin + this.chartheight)) {
                        m = -100;
                    }
                    for (int k = 0; k < this.mDataLen[2]; ++k) {
                        double d;
                        loc[2] = k;
                        t = this.mData.getValue(loc) * this.flashRatio;
                        if (d >= 0.0) {
                            sum1 += t;
                            if (this.isDataLimitAtAxisScale() && sum1 > this.a_x.maxScale) {
                                sum1 = this.a_x.maxScale;
                            }
                            currentx = xstep.interpolatePixel(sum1);
                            this.mData.setAreaCoord(currentx, lastx1, (int)lasty, (int)nexty, loc, zoomYDir);
                            lastx1 = currentx;
                        } else {
                            sum2 += t;
                            if (this.isDataLimitAtAxisScale() && sum2 < this.a_x.minScale) {
                                sum2 = this.a_x.minScale;
                            }
                            currentx = xstep.interpolatePixel(sum2);
                            this.mData.setAreaCoord(currentx, lastx2, (int)lasty, (int)nexty, loc, zoomYDir);
                            lastx2 = currentx;
                        }
                        if (xstep2 == null) continue;
                        double value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                        this.mData2.setPointCoord(xstep2.interpolatePixel(value), m, loc);
                    }
                    lasty = nexty;
                }
                lasty += delta2;
                int tt = (int)(a * (double)i + b);
                if (zoomYDir && ((tt = this.calculateZoomedY(tt)) < this.chartyorigin || tt > this.chartyorigin + this.chartheight)) {
                    tt = -100;
                }
                coord[i] = new Point3D(xstep.zeroAxis, tt, 0);
            }
        }
        int colField = this.mDataMap[this.dataDim - 2];
        this.a_y.set(xstep.zeroAxis, ymin, xstep.zeroAxis, ymax, this.axisThickness, this.colData[colField].getFieldName(), coord, xstep.zeroAxis == xmax, this.colData[colField]);
        if (this.isGridAlignedWithTicker()) {
            Point3D[] coord2 = new Point3D[noCategory];
            for (int i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(xmin, coord[i].y, 0);
            }
            this.a_y.grid.set(coord2, xmin, xmax);
        } else {
            Point3D[] coord2 = new Point3D[noCategory - 1];
            for (int i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(xmin, (coord[i].y + coord[i + 1].y) / 2, 0);
            }
            this.a_y.grid.set(coord2, xmin, xmax);
        }
        this.syncColor();
        if (this.cgraphics == null) {
            this.cgraphics = g;
        }
        this.prepareLabel();
        super.computeCoord(g, xmin, xmax, ymin, ymax);
    }
}

