/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart2d.types2d.stack2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.MultiDimData;
import quadbase.chart.Point3D;
import quadbase.chart.chart2d.Chart2D;
import quadbase.chart.chart2d.MultiDimData2D;
import quadbase.chart.chart2d.Overlay2D;
import quadbase.chart.chart2d.types2d.stack2d.StackAreaChart2D;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.util.internal.Composite;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.RenderingChart;

public abstract class StackChart2D
extends Chart2D {
    public StackChart2D(Component component, int chartType, ColData[] colData) {
        this(component, chartType, colData, null);
    }

    public StackChart2D(Component component, int chartType, ColData[] colData, boolean[] usedColumns) {
        super(component, chartType, colData, usedColumns);
        if (this.nstring == 0) {
            if (this.nint < 1) {
                throw notenoughError;
            }
            if (this.nint + this.nreal + this.ntime < 3) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 1 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.mDataMap[1] = this.nintcol[iindex++];
            this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
        } else {
            this.mDataMap[1] = this.nstringcol[0];
            if (this.nstring == 1) {
                if (this.nint + this.nreal + this.ntime < 2) {
                    throw nonumericError;
                }
                int rindex = 0;
                int iindex = 0;
                this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
                this.valueCol = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
            } else {
                this.mDataMap[0] = this.nstringcol[1];
                if (this.nint + this.nreal + this.ntime < 1) {
                    throw nonumericError;
                }
                this.valueCol = this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0];
            }
        }
        this.dataDim = 2;
        this.bvalueCol = true;
        this.makeTable();
    }

    public StackChart2D(int chartType, Chart _chart) {
        super(chartType, _chart);
        if (!this.bvalueCol) {
            this.valueCol = _chart.coordCol[0];
            this.bvalueCol = true;
        }
        if (_chart.dataDim < 3) {
            if (_chart.dataDim == 2) {
                if (_chart.isStackType() && _chart.dataDim == 2) {
                    if (chartType == _chart.chartType) {
                        this.mDataMap[0] = _chart.mDataMap[0];
                        this.mDataMap[1] = _chart.mDataMap[1];
                    } else {
                        this.mDataMap[0] = _chart.mDataMap[1];
                        this.mDataMap[1] = _chart.mDataMap[0];
                    }
                    for (int i = 2; i < this.nCol; ++i) {
                        this.bmDataMap[i] = false;
                    }
                    this.dataDim = 2;
                } else {
                    if (!this.is2DChart && chartType == 8 && _chart.is2DChart && _chart.chartType == 8 && this.bmDataMap[2]) {
                        int t = this.mDataMap[2];
                        this.mDataMap[2] = this.mDataMap[1];
                        this.mDataMap[1] = this.mDataMap[0];
                        this.mDataMap[0] = t;
                    }
                    this.dataDim = this.bmDataMap[2] ? 3 : 2;
                }
            } else {
                this.dataDim = 2;
                this.bmDataMap[2] = false;
                if (!this.bmDataMap[1]) {
                    if (this.nstring == 0) {
                        if (this.nint + this.nreal < 2) {
                            throw notenoughError;
                        }
                        this.mDataMap[1] = this.nintcol[0] == this.mDataMap[0] && this.nint > 1 ? this.nintcol[1] : this.nintcol[0];
                        this.addNewColumnFromDataMapping = true;
                        this.bmDataMap[1] = true;
                    } else if (this.nstring == 1) {
                        if (this.mDataMap[0] != this.nstringcol[0]) {
                            this.mDataMap[1] = this.nstringcol[0];
                            this.bmDataMap[1] = true;
                        } else {
                            if (this.nint + this.nreal == 0) {
                                throw notenoughError;
                            }
                            this.mDataMap[1] = this.nint > 0 ? this.nintcol[0] : this.nstringcol[0];
                            this.addNewColumnFromDataMapping = true;
                            this.bmDataMap[1] = true;
                        }
                    } else {
                        this.mDataMap[1] = this.mDataMap[0] == this.nstringcol[0] ? this.nstringcol[1] : this.nstringcol[0];
                        this.addNewColumnFromDataMapping = true;
                        this.bmDataMap[1] = true;
                    }
                } else if (_chart.isCircularChart()) {
                    this.mDataMap[0] = _chart.mDataMap[1];
                    this.mDataMap[1] = _chart.mDataMap[0];
                }
            }
        } else {
            this.dataDim = 3;
        }
        this.checkSpecialColumn(2);
        this.copyTable(_chart);
    }

    public static void drawLine(CGraphics g, MultiDimData data, int[] mDataLen, int dataDim, boolean isDataLimitAtAxisScale) {
        Point3D lastpoint = null;
        Point3D lastNonNull = null;
        if (dataDim == 2) {
            for (int i = 0; i < mDataLen[1]; ++i) {
                Color lineColor = data.multiData[0].multiData[i].area.areaColor;
                int thickness = data.multiData[0].multiData[i].getLineThickness();
                lastpoint = null;
                lastNonNull = null;
                for (int j = 0; j < mDataLen[0]; ++j) {
                    MultiDimData a = data.multiData[j].multiData[i];
                    if (a.plotData.isEmpty()) {
                        lastpoint = null;
                        continue;
                    }
                    Point3D currpoint = a.point;
                    boolean setToolTipsForFlash = false;
                    if (g.g instanceof IFlashGraphics) {
                        setToolTipsForFlash = true;
                        ((IFlashGraphics)((Object)g.g)).setToolTipsAndLink(a);
                    }
                    if (lastpoint != null) {
                        if (g.chart.selectStep == null || g.chart.selectStep.length <= i || !g.chart.selectStep[i]) {
                            if (isDataLimitAtAxisScale && (currpoint.y > g.chart.background.p2.y || lastpoint.y > g.chart.background.p2.y || currpoint.y < g.chart.background.p1.y || lastpoint.y < g.chart.background.p1.y)) {
                                MultiDimData2D.drawLineSegmentWithLimitAtAxisScaleCheck(g, lastpoint.x, lastpoint.y, currpoint.x, currpoint.y, lineColor, null, thickness, lastpoint.shape);
                            } else {
                                ((Chart2D)g.chart).horzVertLine2D.drawLineSegment(g, lineColor, lastpoint.x, lastpoint.y, currpoint.x, currpoint.y, thickness, null, lastpoint.shape);
                            }
                        } else {
                            double stepR = g.chart.getStepLineRatio2();
                            int rX = lastpoint.x + (int)((double)(currpoint.x - lastpoint.x) * stepR);
                            ((Chart2D)g.chart).horzVertLine2D.drawLineSegment(g, lineColor, lastpoint.x, lastpoint.y, rX, lastpoint.y, thickness, null, lastpoint.shape);
                            ((Chart2D)g.chart).horzVertLine2D.drawLineSegment(g, lineColor, rX, lastpoint.y, rX, currpoint.y, thickness, null, lastpoint.shape);
                            ((Chart2D)g.chart).horzVertLine2D.drawLineSegment(g, lineColor, rX, currpoint.y, currpoint.x, currpoint.y, thickness, null, lastpoint.shape);
                        }
                    } else if (lastNonNull != null && g.chart.showNulldataLine && !g.chart.isApplyLineStyleToNullData()) {
                        ((Chart2D)g.chart).horzVertLine2D.drawLineSegment(g, lineColor, lastNonNull.x, lastNonNull.y, currpoint.x, currpoint.y, thickness, null, 657921);
                    }
                    lastpoint = currpoint;
                    lastNonNull = currpoint;
                    if (!setToolTipsForFlash) continue;
                    ((IFlashGraphics)((Object)g.g)).resetToolTipsAndLink();
                }
            }
        } else {
            for (int i = 0; i < mDataLen[0]; ++i) {
                for (int j = 0; j < mDataLen[2]; ++j) {
                    Color lineColor = data.multiData[i].multiData[0].multiData[j].area.areaColor;
                    int thickness = data.multiData[i].multiData[0].multiData[j].getLineThickness();
                    lastpoint = null;
                    for (int k = 0; k < mDataLen[1]; ++k) {
                        MultiDimData a = data.multiData[i].multiData[k].multiData[j];
                        if (a.plotData.isEmpty()) {
                            lastpoint = null;
                            continue;
                        }
                        boolean setToolTipsForFlash = false;
                        if (g.g instanceof IFlashGraphics) {
                            setToolTipsForFlash = true;
                            ((IFlashGraphics)((Object)g.g)).setToolTipsAndLink(a);
                        }
                        Point3D currpoint = a.point;
                        if (lastpoint != null) {
                            if (g.chart.selectStep == null || g.chart.selectStep.length <= j || !g.chart.selectStep[j]) {
                                if (isDataLimitAtAxisScale && (currpoint.y > g.chart.background.p2.y || lastpoint.y > g.chart.background.p2.y || currpoint.y < g.chart.background.p1.y || lastpoint.y < g.chart.background.p1.y)) {
                                    MultiDimData2D.drawLineSegmentWithLimitAtAxisScaleCheck(g, lastpoint.x, lastpoint.y, currpoint.x, currpoint.y, lineColor, null, thickness, lastpoint.shape);
                                } else {
                                    ((Chart2D)g.chart).horzVertLine2D.drawLineSegment(g, lineColor, lastpoint.x, lastpoint.y, currpoint.x, currpoint.y, thickness, null, 0);
                                }
                            } else {
                                double stepR = g.chart.getStepLineRatio2();
                                int rX = lastpoint.x + (int)((double)(currpoint.x - lastpoint.x) * stepR);
                                ((Chart2D)g.chart).horzVertLine2D.drawLineSegment(g, lineColor, lastpoint.x, lastpoint.y, rX, lastpoint.y, thickness, null, 0);
                                ((Chart2D)g.chart).horzVertLine2D.drawLineSegment(g, lineColor, rX, lastpoint.y, rX, currpoint.y, thickness, null, 0);
                                ((Chart2D)g.chart).horzVertLine2D.drawLineSegment(g, lineColor, rX, currpoint.y, currpoint.x, currpoint.y, thickness, null, 0);
                            }
                        } else if (lastNonNull != null && g.chart.showNulldataLine && !g.chart.isApplyLineStyleToNullData()) {
                            ((Chart2D)g.chart).horzVertLine2D.drawLineSegment(g, lineColor, lastNonNull.x, lastNonNull.y, currpoint.x, currpoint.y, thickness, null, 657921);
                        }
                        lastNonNull = currpoint;
                        lastpoint = currpoint;
                        if (!setToolTipsForFlash) continue;
                        ((IFlashGraphics)((Object)g.g)).resetToolTipsAndLink();
                    }
                }
            }
        }
    }

    @Override
    public void draw(CGraphics g) {
        this.background.draw(g, this.background, null, true, this.background);
        this.drawControlRange(g, 0);
        if (!this.isGridInFront()) {
            this.axis[0].drawGrid(g);
            this.axis[1].drawGrid(g);
        }
        if (IOUtil.isJava2D()) {
            Graphics backupG = g.g;
            Image buffImg = Composite.getBufferedImage(backupG, this.winWidth, this.winHeight);
            g.g = Composite.createGraphics(backupG, buffImg);
            this.drawChart(g);
            this.drawControlRange(g, 1);
            Composite.drawImage(backupG, buffImg);
            g.g = backupG;
        } else {
            this.drawChart(g);
        }
        if (this.isGridInFront()) {
            this.axis[0].drawGrid(g);
            this.axis[1].drawGrid(g);
        }
        this.dataLineSet.drawDataLineList();
        this.border.draw(g);
        boolean restoreRendering = false;
        if (this.setAntiAliasForChartOnly && this.isAntiAliasEnabled()) {
            restoreRendering = true;
            this.setAntiAliasEnabled(false);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        this.axis[0].draw(g);
        this.axis[1].draw(g);
        if (this.subvalueCol >= 0) {
            this.axis[3].draw(g);
        }
        this.mainTitle.draw(g);
        if (this.legend2.chart != null) {
            this.legend2.chart.cgraphics = g;
        }
        if (restoreRendering) {
            this.setAntiAliasEnabled(true);
            RenderingChart.setRenderingHint(g.g, this.renderingKey, this.renderingValue);
        }
        if (this.checkZoomStatus() && this.getZoomOption() != -1) {
            this.drawScrollBars(g);
        }
    }

    @Override
    public void drawChart(CGraphics g) {
        boolean isTransparent = false;
        if (this.subvalueCol >= 0 && this.dataDim == 2 && this.comboType == 1) {
            isTransparent = this.isTranslucentSupport();
            if (isTransparent) {
                Composite.setCompositeSrcOver(g.g, this.getTranslucentValue());
            }
            StackAreaChart2D.fillStackArea(g, this, true, this.mData2);
            if (this.drawDataBorder) {
                StackAreaChart2D.fillStackArea(g, this, false, this.mData2);
            }
        } else if (this.subvalueCol >= 0 && this.comboType == 3 && this.getComboSeries() >= 0) {
            Overlay2D.drawArea(g, this, this.mData2);
            isTransparent = this.isTranslucentSupport();
            if (isTransparent) {
                Composite.setCompositeSrcOver(g.g, this.getTranslucentValue());
            }
        }
        if (g.g instanceof IFlashGraphics) {
            for (int i = 0; i < this.flashFrameCount; ++i) {
                ((IFlashGraphics)((Object)g.g)).setFrame(i);
                this.flashRatio = ((double)i + 1.0) / (double)this.flashFrameCount;
                this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                this.mData.drawArea(g);
                if (isTransparent) {
                    Composite.setOriginalComposite(g.g);
                }
                if (this.showLine) {
                    StackChart2D.drawLine(g, this.mData, this.mDataLen, this.dataDim, this.isDataLimitAtAxisScale());
                }
                if (this.showPoint) {
                    this.mData.drawPoint(g);
                }
                if (this.subvalueCol >= 0 && this.comboType == 3 && this.getComboSeries() >= 0) {
                    if (this.showLine2) {
                        Overlay2D.drawLine(g, this, this.mData2);
                    }
                    if (this.showPoint2) {
                        this.mData2.drawPoint(g);
                    }
                } else if (this.subvalueCol >= 0 && this.comboType == 0) {
                    if (this.showLine2) {
                        StackChart2D.drawLine(g, this.mData2, this.mDataLen, this.dataDim, this.isDataLimitAtAxisScale());
                    }
                    if (this.showPoint2) {
                        this.mData2.drawPoint(g);
                    }
                }
                this.drawLabel(g);
            }
            ((IFlashGraphics)((Object)g.g)).setFrame(-1);
        } else {
            this.mData.drawArea(g);
            if (isTransparent) {
                Composite.setOriginalComposite(g.g);
            }
            if (this.showLine) {
                StackChart2D.drawLine(g, this.mData, this.mDataLen, this.dataDim, this.isDataLimitAtAxisScale());
            }
            if (this.showPoint) {
                this.mData.drawPoint(g);
            }
            if (this.subvalueCol >= 0 && this.comboType == 3 && this.getComboSeries() >= 0) {
                if (this.showLine2) {
                    Overlay2D.drawLine(g, this, this.mData2);
                }
                if (this.showPoint2) {
                    this.mData2.drawPoint(g);
                }
            } else if (this.subvalueCol >= 0 && this.comboType == 0) {
                if (this.showLine2) {
                    StackChart2D.drawLine(g, this.mData2, this.mDataLen, this.dataDim, this.isDataLimitAtAxisScale());
                }
                if (this.showPoint2) {
                    this.mData2.drawPoint(g);
                }
            }
            this.drawLabel(g);
        }
    }
}

