/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Point;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.ColData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.Grid3D;
import quadbase.chart.chart3d.Ticker3D;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.common.util.internal.QbUtil;

public class Axis3D
extends Axis {
    public Vertex startv;
    public Vertex endv;
    private Face[] faceList;

    public Axis3D(int direction, CString name, boolean showgrid) {
        super(direction, name);
        this.grid = new Grid3D(direction, showgrid);
        this.ticker = new Ticker3D(this);
        this.faceList = new Face[6];
    }

    @Override
    public Object getFaceList() {
        return this.faceList;
    }

    @Override
    public Object getFaceList(int i) {
        return this.faceList[i];
    }

    @Override
    public void setWallColor(Object sp, Color color) {
        Space space = (Space)sp;
        Face.setFaceListColor(space, this.faceList, color);
    }

    @Override
    public void setTicker(Object sp, Object[] name, Point3D[] p, boolean reverseSide, ColData colField) {
        Space space = (Space)sp;
        this.columnField = colField;
        this.ticker.modify(name, space, p, reverseSide, this.xyzchart);
        if (this.orient != 2) {
            this.startv = ((Ticker3D)this.ticker).vertex[0];
            this.endv = ((Ticker3D)this.ticker).vertex[((Ticker3D)this.ticker).vertex.length - 1];
        }
        this.is3D = true;
    }

    @Override
    public void setTicker(Object sp, int xmax, int wall_zlength) {
        Space space = (Space)sp;
        this.columnField = null;
        Vertex v1 = new Vertex(xmax, 0.0f, 0.0f, space);
        Vertex v2 = new Vertex(xmax, 0.0f, wall_zlength, space);
        this.setVertex(v1, v2);
    }

    @Override
    public void setVertex(Object sv, Object ev) {
        Vertex startv = (Vertex)sv;
        Vertex endv = (Vertex)ev;
        this.startv = startv;
        this.endv = endv;
        this.is3D = true;
    }

    @Override
    public void setAxisGridY(Object sp, StepSize sz, int xmax, int ymax, int zmax, ColData colField) {
        Space space = (Space)sp;
        this.setAxisGridY(space, sz, xmax, ymax, zmax, colField, 0, zmax);
    }

    @Override
    public void setAxisGridY(Object sp, StepSize sz, int xmax, int ymax, int zmax, ColData colField, int px, int pz) {
        Space space = (Space)sp;
        this.stepsize = sz;
        this.columnField = colField;
        Point3D[] coord = new Point3D[sz.totalstep + 1];
        Object[] svalue = new Object[sz.totalstep + 1];
        for (int i = 0; i <= sz.totalstep; ++i) {
            coord[i] = new Point3D(px, i * sz.width / sz.totalstep + sz.newMinPixel, pz);
            this.setNumericLabel(svalue, sz, i);
        }
        if (this.isShowSubTickers() && this.logBase == 10.0 && this.logScale) {
            Point3D[] subTickers = new Point3D[sz.totalstep * (int)(this.logBase - 2.0)];
            int ct = 0;
            for (int i = 1; i <= sz.totalstep; ++i) {
                double curVal;
                double step = curVal = this.getNumericValue(sz, i - 1);
                curVal += step;
                int j = 0;
                while ((double)j < this.logBase - 2.0) {
                    subTickers[ct++] = new Point3D(px, sz.interpolatePixel(curVal), pz);
                    curVal += step;
                    ++j;
                }
            }
            this.ticker.setSubTickers(subTickers);
        }
        this.grid.set(space, coord, xmax, zmax);
        this.setTicker(space, svalue, coord, false, colField);
        this.xyzchart = false;
        this.reversexlabel = false;
    }

    @Override
    public void setAxisGridX(Object sp, StepSize sz, int xmax, int ymax, int zmax, ColData colField) {
        Space space = (Space)sp;
        this.setAxisGridX(space, sz, xmax, ymax, zmax, colField, 0, zmax);
    }

    @Override
    public void setAxisGridX(Object sp, StepSize sz, int xmax, int ymax, int zmax, ColData colField, int py, int pz) {
        Space space = (Space)sp;
        this.stepsize = sz;
        this.columnField = colField;
        Point3D[] coord = new Point3D[sz.totalstep + 1];
        Object[] svalue = new Object[sz.totalstep + 1];
        for (int i = 0; i <= sz.totalstep; ++i) {
            coord[i] = new Point3D(i * sz.width / sz.totalstep + sz.newMinPixel, py, pz);
            this.setNumericLabel(svalue, sz, i);
        }
        if (this.isShowSubTickers() && this.logBase == 10.0 && this.logScale) {
            Point3D[] subTickers = new Point3D[sz.totalstep * (int)(this.logBase - 2.0)];
            int ct = 0;
            for (int i = 1; i <= sz.totalstep; ++i) {
                double curVal;
                double step = curVal = this.getNumericValue(sz, i - 1);
                curVal += step;
                int j = 0;
                while ((double)j < this.logBase - 2.0) {
                    subTickers[ct++] = new Point3D(sz.interpolatePixel(curVal), py, pz);
                    curVal += step;
                    ++j;
                }
            }
            this.ticker.setSubTickers(subTickers);
        }
        this.grid.set(space, coord, ymax, zmax);
        this.reversexlabel = py != 0;
        this.setTicker(space, svalue, coord, false, colField);
        this.xyzchart = false;
    }

    @Override
    public void setAxisGridZ(Object sp, StepSize sz, int xmax, int ymax, int zmax, ColData colField) {
        Space space = (Space)sp;
        this.stepsize = sz;
        this.columnField = colField;
        Point3D[] coord = new Point3D[sz.totalstep + 1];
        Object[] svalue = new Object[sz.totalstep + 1];
        for (int i = 0; i <= sz.totalstep; ++i) {
            coord[i] = new Point3D(xmax, 0, i * sz.width / sz.totalstep + sz.newMinPixel);
            this.setNumericLabel(svalue, sz, i);
        }
        if (this.isShowSubTickers() && this.logBase == 10.0 && this.logScale) {
            Point3D[] subTickers = new Point3D[sz.totalstep * (int)(this.logBase - 2.0)];
            int ct = 0;
            for (int i = 1; i <= sz.totalstep; ++i) {
                double curVal;
                double step = curVal = this.getNumericValue(sz, i - 1);
                curVal += step;
                int j = 0;
                while ((double)j < this.logBase - 2.0) {
                    subTickers[ct++] = new Point3D(xmax, 0, sz.interpolatePixel(curVal));
                    curVal += step;
                    ++j;
                }
            }
            this.ticker.setSubTickers(subTickers);
        }
        this.grid.set(space, coord, xmax, ymax);
        this.xyzchart = true;
        this.setTicker(space, svalue, coord, true, colField);
    }

    @Override
    public void setXWall(Object sp, int xlength, int ylength, int zlength, Color color) {
        Space space = (Space)sp;
        space.addBox(this.faceList, (float)xlength, (float)ylength, -5.0f, -5.0f, -5.0f, -20.0f, color, false, (Object)this);
        this.setFaceState();
        Vertex v1 = new Vertex(0.0f, 0.0f, -0.5f, space);
        Vertex v2 = new Vertex(xlength, 0.0f, -0.5f, space);
        Vertex v3 = new Vertex(xlength, ylength, -0.5f, space);
        Vertex v4 = new Vertex(0.0f, ylength, 0.0f, space);
        Face f = new Face(v1, v2, v3, v4, Color.black, space, this.grid);
        f.bshow = false;
        f = new Face(v4, v3, v2, v1, Color.black, space, this.grid);
        f.bshow = false;
        v1 = new Vertex(xlength / 2 - 5, 0.0f, zlength, space);
        v2 = new Vertex(xlength / 2 + 5, 0.0f, zlength, space);
        v3 = new Vertex(xlength / 2 + 5, 0.0f, zlength + 5, space);
        v4 = new Vertex(xlength / 2 - 5, 0.0f, zlength + 5, space);
        f = new Face(v1, v2, v3, v4, Color.black, space, this.ticker);
        f.bshow = false;
        f = new Face(v4, v3, v2, v1, Color.black, space, this.ticker);
        f.bshow = false;
    }

    @Override
    public void setYWall(Object sp, int xlength, int ylength, int zlength, Color color) {
        Space space = (Space)sp;
        space.addBox(this.faceList, -5.0f, (float)ylength, (float)zlength, -20.0f, -20.0f, -20.0f, color, false, (Object)this);
        this.setFaceState();
        Vertex v1 = new Vertex(-0.5f, 0.0f, 0.0f, space);
        Vertex v2 = new Vertex(-0.5f, 0.0f, zlength, space);
        Vertex v3 = new Vertex(-0.5f, ylength, zlength, space);
        Vertex v4 = new Vertex(-0.5f, ylength, 0.0f, space);
        Face f = new Face(v1, v2, v3, v4, Color.black, space, this.grid);
        f.bshow = false;
        f = new Face(v4, v3, v2, v1, Color.black, space, this.grid);
        f.bshow = false;
        v1 = new Vertex(0.0f, ylength / 2 - 5, zlength, space);
        v2 = new Vertex(0.0f, ylength / 2 + 5, zlength, space);
        v3 = new Vertex(0.0f, ylength / 2 + 5, zlength + 5, space);
        v4 = new Vertex(0.0f, ylength / 2 - 5, zlength + 5, space);
        f = new Face(v1, v2, v3, v4, Color.black, space, this.ticker);
        f.bshow = false;
        f = new Face(v4, v3, v2, v1, Color.black, space, this.ticker);
        f.bshow = false;
    }

    @Override
    public void setSWall(Object sp, int xlength, int ylength, int zlength, Color color) {
        Space space = (Space)sp;
        this.startp.y = 100;
        this.endp.y = 0;
        this.ticker.reverseSide = true;
        Vertex v1 = new Vertex(xlength, ylength / 2 - 5, 0.0f, space);
        Vertex v2 = new Vertex(xlength, ylength / 2 + 5, 0.0f, space);
        Vertex v3 = new Vertex(xlength, ylength / 2 + 5, 5.0f, space);
        Vertex v4 = new Vertex(xlength, ylength / 2 - 5, 5.0f, space);
        Face f = new Face(v1, v2, v3, v4, Color.black, space, this.grid);
        f.bshow = false;
        f = new Face(v4, v3, v2, v1, Color.black, space, this.grid);
        f.bshow = false;
        f = new Face(v1, v2, v3, v4, Color.black, space, this.ticker);
        f.bshow = false;
        f = new Face(v4, v3, v2, v1, Color.black, space, this.ticker);
        f.bshow = false;
    }

    @Override
    public void setZWall(Object sp, int xlength, int ylength, int zlength, Color color) {
        Space space = (Space)sp;
        space.addBox(this.faceList, (float)xlength, -5.0f, (float)zlength, -5.0f, -20.0f, -20.0f, color, false, (Object)this);
        this.setFaceState();
        Vertex v1 = new Vertex(xlength, -0.5f, 0.0f, space);
        Vertex v2 = new Vertex(xlength, -0.5f, zlength, space);
        Vertex v3 = new Vertex(0.0f, -0.5f, zlength, space);
        Vertex v4 = new Vertex(0.0f, -0.5f, 0.0f, space);
        Face f = new Face(v1, v2, v3, v4, Color.black, space, this.grid);
        f.bshow = false;
        f = new Face(v4, v3, v2, v1, Color.black, space, this.grid);
        f.bshow = false;
        this.setVertex(v1, v2);
        v1 = new Vertex(xlength, 0.0f, zlength / 2 - 5, space);
        v2 = new Vertex(xlength, 0.0f, zlength / 2 + 5, space);
        v3 = new Vertex(xlength + 5, 0.0f, zlength / 2 + 5, space);
        v4 = new Vertex(xlength + 5, 5.0f, zlength / 2 - 5, space);
        f = new Face(v1, v2, v3, v4, Color.black, space, this.ticker);
        f.bshow = false;
        f = new Face(v4, v3, v2, v1, Color.black, space, this.ticker);
        f.bshow = false;
    }

    @Override
    public void setFaceState() {
        for (int i = 0; i < 6; ++i) {
            this.faceList[i].bshow = this.bshow;
        }
    }

    @Override
    public void drawTicker(CGraphics g) {
        if (this.ticker.label != null && this.showTitleTicker) {
            this.ticker.draw(g);
        } else if (this.is3D) {
            this.ticker.minp = new Point((this.startv.screen_x + this.endv.screen_x) / 2, (this.startv.screen_y + this.endv.screen_y) / 2);
        }
    }

    @Override
    public void drawAxis(CGraphics g) {
        this.drawTicker(g);
        if (this.bshow) {
            g.setColor(this.color);
            if (this.is3D && ((Chart3D)g.chart).drawType == 0 && this.orient != 3) {
                Space.drawFrameBox(g, this.faceList);
            }
        }
        this.drawAxisTitle(g);
    }

    @Override
    public void drawAxisTitle(CGraphics g) {
        if (!this.title.bshow) {
            return;
        }
        if (this.is3D) {
            double centery;
            double centerx;
            if (this.orient == 1) {
                this.title.setpos(new Point3D(this.ticker.minp.x - this.titleoffset, g.height - (this.startv.screen_y + this.endv.screen_y) / 2 + this.titlevoffset));
                this.title.setPlacement(4);
                if (this.title.automatic) {
                    this.title.setAngle(90);
                }
                this.title.draw(g);
                return;
            }
            if (this.orient == 3) {
                if (this.startv.x == this.endv.x) {
                    this.title.setpos(new Point3D(this.ticker.maxp.x + this.titleoffset, g.height - (this.startv.screen_y + this.endv.screen_y) / 2 + this.titlevoffset));
                    this.title.setPlacement(2);
                    if (this.title.automatic) {
                        this.title.setAngle(90);
                    }
                } else {
                    this.title.setpos(new Point3D((this.startv.screen_x + this.endv.screen_x) / 2 - this.titleoffset, this.ticker.maxp.y + this.titlevoffset));
                    this.title.setPlacement(1);
                    if (this.title.automatic) {
                        this.title.setAngle(0);
                    }
                }
                this.title.draw(g);
                return;
            }
            double angle = 0.0;
            double slope = 0.0;
            if (this.orient == 0) {
                centerx = (double)(this.startv.screen_x + this.endv.screen_x) / 2.0 + (double)this.titlevoffset;
                centery = (double)g.height - (double)(this.startv.screen_y + this.endv.screen_y) / 2.0 - (double)this.titleoffset;
            } else {
                centerx = (double)(this.startv.screen_x + this.endv.screen_x) / 2.0 - (double)this.titleoffset;
                centery = (double)g.height - (double)(this.startv.screen_y + this.endv.screen_y) / 2.0 + (double)this.titlevoffset;
            }
            int ay = this.startv.screen_y - this.endv.screen_y;
            if (ay != 0) {
                FontMetrics fm;
                double r3;
                double r1;
                double deter;
                double b;
                double r2;
                double xpos2;
                double a;
                double ypos2;
                int ax = this.startv.screen_x - this.endv.screen_x;
                slope = (double)ax / (double)ay;
                angle = 180.0 * Math.atan(slope) / Math.PI;
                ay = -ay;
                double xpos1 = 0.0;
                double ypos1 = 0.0;
                double distance = 0.0;
                if (this.ticker.label != null) {
                    for (int i = 0; i < this.ticker.label.length; ++i) {
                        double d;
                        if (i % (this.columnField == null ? 1 : this.columnField.sepSize) != 0) continue;
                        int bx = (angle > 0.0 ? this.ticker.label[i].minx : this.ticker.label[i].maxx) - this.endv.screen_x;
                        int by = this.ticker.label[i].miny - g.height + this.endv.screen_y;
                        double dist = (double)Math.abs(ax * by - ay * bx) / Math.sqrt(ax * ax + ay * ay);
                        if (!(d > distance)) continue;
                        distance = dist;
                    }
                }
                if ((ypos2 = (a = slope) * (xpos2 = (-(r2 = 2.0 * (-centerx + a * (b = centery - a * centerx) - a * centery)) - (deter = Math.sqrt(r2 * r2 - 4.0 * (r1 = 1.0 + a * a) * (r3 = centerx * centerx + b * b - 2.0 * centery * b + centery * centery - (distance += (double)((fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.title.font, g.chart.isAdjustFont()))).getMaxAscent() + fm.getMaxDescent())) * distance)))) / (2.0 * r1)) + b) == (ypos1 = a * (xpos1 = (-r2 + deter) / (2.0 * r1)) + b)) {
                    xpos1 = Math.min(xpos1, xpos2);
                } else if (ypos2 < ypos1) {
                    ypos1 = ypos2;
                    xpos1 = xpos2;
                }
                int fontH = this.title.getFontWidthHeight(g);
                if (ypos1 < (double)fontH) {
                    ypos1 = fontH;
                }
                this.title.setpos(new Point3D((int)xpos1, (int)ypos1, 0));
                this.title.setPlacement(0);
                angle = angle > 0.0 ? (angle < 20.0 ? (angle -= 270.0) : (angle -= 90.0)) : (angle += 90.0);
                if (this.title.automatic) {
                    this.title.setAngle(angle);
                }
            } else {
                if (this.ticker.label != null) {
                    this.title.setpos(new Point3D((int)centerx + this.titlevoffset, this.ticker.minp.y - this.titleoffset, 0));
                } else {
                    this.title.setpos(new Point3D((int)centerx + this.titlevoffset, (int)centery - this.titleoffset, 0));
                }
                this.title.setPlacement(3);
            }
        }
        this.title.draw(g);
    }

    @Override
    public void drawFrameWall(CGraphics g) {
        boolean old = this.faceList[0].bshow;
        for (int i = 0; i < 6; ++i) {
            Face face = this.faceList[i];
            face.bshow = true;
            face.draw(g, 0);
            face.bshow = old;
        }
    }
}

