/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d;

import java.awt.Color;
import java.util.Vector;
import quadbase.chart.StepSize;
import quadbase.chart.chart3d.VertexPolygon;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.util.ColorSpectrum;

public class ColorSpectrumUtil {
    Space space;
    ColorSpectrum colorSpectrum;
    int nValue;
    float[] valueInPixel;
    Color[] color;
    transient int nCutPixel;
    transient float[] cutPixel;
    Vector vertexList;

    public ColorSpectrumUtil(Space space, ColorSpectrum colorSpectrum, StepSize yStepSize) {
        this.space = space;
        this.colorSpectrum = colorSpectrum;
        this.nValue = colorSpectrum.getValueCount();
        if (this.nValue > 0) {
            double[] value = colorSpectrum.getValue();
            this.valueInPixel = new float[this.nValue];
            for (int i = 0; i < this.nValue; ++i) {
                this.valueInPixel[i] = yStepSize.interpolatePixel(value[i]);
            }
        }
        this.color = colorSpectrum.getColor();
        if (this.nValue > 0) {
            this.cutPixel = new float[this.nValue];
        }
    }

    Color getColor(float pixelValue) {
        Color[] colorArray = this.colorSpectrum.getColor();
        if (this.nValue == 0) {
            return colorArray[0];
        }
        for (int i = 0; i < this.nValue; ++i) {
            if (!(pixelValue < this.valueInPixel[i])) continue;
            return colorArray[i];
        }
        return colorArray[this.nValue];
    }

    public void addFace(Vector faceList, Vertex v1, Vertex v2, Vertex v3, Vertex v4, Object object) {
        float min = Math.min(Math.min(v1.y, v2.y), Math.min(v3.y, v4.y));
        float max = Math.max(Math.max(v1.y, v2.y), Math.max(v3.y, v4.y));
        if (this.nValue == 0) {
            faceList.addElement(new Face(v1, v2, v3, v4, this.color[0], this.space, object));
            return;
        }
        if (this.inSameRange(min, max)) {
            faceList.addElement(new Face(v1, v2, v3, v4, this.getColor(min), this.space, object));
            return;
        }
        VertexPolygon vp = new VertexPolygon(v1, v2, v3, v4, this.space, object);
        vp.cutPolygon(this.valueInPixel);
        vp.addFace(faceList, this);
    }

    private boolean inSameRange(float y1, float y2) {
        if (y1 == y2) {
            return true;
        }
        for (int i = 0; i < this.nValue; ++i) {
            float current = this.valueInPixel[i];
            if (y1 <= current && y2 <= current) {
                return true;
            }
            if (!(y1 < current) || !(current < y2)) continue;
            return false;
        }
        return true;
    }
}

