/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d;

import java.io.OutputStream;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ExportChart;
import quadbase.chart.FaceData;
import quadbase.chart.ImageMapNode;
import quadbase.chart.MultiDimData;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.DrillDownMap3D;
import quadbase.chart.chart3d.FieldDrillDownMap3D;
import quadbase.chart.chart3d.ImageMap3D;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.ListNode;
import quadbase.util.HyperLink;
import quadbase.util.PickData;

public class ExportChart3D
extends ExportChart {
    public ExportChart3D(Chart chart) {
        super(chart);
    }

    @Override
    public void createImageMap(OutputStream out, String filename) throws Exception {
        if (this.ch.cgraphics.maplist != null && this.ch.cgraphics.maplist.size() > 0) {
            new ImageMap3D(filename, this.ch.cgraphics.maplist).write(out);
        }
    }

    @Override
    public void createDrillDownMap(OutputStream out, String filename, String chartFile, String servletLoc, PickData[] pickData, String[] argv) throws Exception {
        if (this.ch.cgraphics.maplist != null && this.ch.cgraphics.maplist.size() > 0) {
            new DrillDownMap3D(filename, this.ch.cgraphics.maplist).write(out, chartFile, servletLoc, pickData, argv);
        }
    }

    @Override
    public void createFieldDrillDownMap(OutputStream out, String filename, String chartFile, String servletLoc, String[] argv) throws Exception {
        if (this.ch.cgraphics.maplist != null && this.ch.cgraphics.maplist.size() > 0) {
            new FieldDrillDownMap3D(filename, this.ch.cgraphics.maplist).write(out, chartFile, servletLoc, argv);
        }
    }

    @Override
    public void createImageMapForFaceObject(Chart chart, boolean isGIFDrillDown) {
        ExportChart3D.createImageMapForFaceObject(chart);
    }

    public static void createImageMapForFaceObject(Chart chart) {
        if (!(chart instanceof Chart3D)) {
            return;
        }
        if (((Chart3D)chart).space == null) {
            return;
        }
        ListNode currNode = ((Chart3D)chart).space.getFaceList().getHeadNode();
        while (currNode.getNext() != null) {
            FaceData faceData;
            currNode = currNode.getNext();
            Face face = (Face)currNode.getElement();
            String link = null;
            String target = null;
            String hint = null;
            if (face.bshow && face.object instanceof MultiDimData) {
                HyperLink lnk = CGraphics.getLink((MultiDimData)face.object);
                if (lnk != null) {
                    link = lnk.link;
                    target = lnk.target;
                    hint = lnk.hint;
                }
            } else if (face.bshow && face.object instanceof FaceData && (faceData = (FaceData)face.object).getHyperLink() != null && !faceData.getHyperLink().trim().equals("")) {
                link = faceData.getHyperLink();
                target = faceData.getTarget();
                hint = faceData.getHint();
            }
            if (link == null) continue;
            chart.cgraphics.maplist.addElement(new ImageMapNode(face, link, target, hint));
        }
    }
}

