/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d;

import java.awt.Color;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.DataLine;
import quadbase.chart.TrendLine;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.util.Point_2D;

public class TrendLine3D
extends TrendLine {
    Face[] faceList;

    public TrendLine3D(Chart chart) {
        super(chart);
    }

    public TrendLine3D(Chart chart, TrendLine tline) {
        super(chart, tline);
    }

    public TrendLine3D(Chart chart, int linetype, int coeff, String title) {
        super(chart, linetype, coeff, title);
    }

    @Override
    public final void setColor(Color color) {
        this.color = color;
        if (this.faceList != null && ((Chart3D)this.chart).space != null) {
            for (Face element : this.faceList) {
                element.setColor(((Chart3D)this.chart).space, color);
            }
        }
    }

    @Override
    public void compute() {
        this.error_data = false;
        if (this.chart.mData2 == null) {
            this.useSubvalue = false;
        }
        if (this.chart.isCircularChart()) {
            return;
        }
        this.makeTitle();
    }

    @Override
    public void prepare3DLine() {
        int thick = this.getThickness();
        int lineType = this.getLineType();
        if (lineType == 7) {
            int newpixel = DataLine.isBarChartType(this.chart) ? this.getHortLineYPixel2() : this.getHortLineYPixel();
            this.faceList = new Face[6];
            ((Chart3D)this.chart).space.addBox(this.faceList, (float)((Chart3D)this.chart).wall_xlength, (float)(newpixel + thick), (float)((Chart3D)this.chart).wall_zlength, 0.0f, (float)(newpixel - thick), 0.0f, this.getColor(), true, (Object)this);
        } else if (lineType == 8) {
            int newpixel = DataLine.isBarChartType(this.chart) ? this.getVertLineXPixel() : this.getVertLineXPixel2();
            this.faceList = new Face[6];
            ((Chart3D)this.chart).space.addBox(this.faceList, (float)(newpixel + thick), (float)((Chart3D)this.chart).wall_ylength, (float)((Chart3D)this.chart).wall_zlength, (float)(newpixel - thick), 0.0f, 0.0f, this.getColor(), true, (Object)this);
        }
    }

    @Override
    protected final void drawLine(CGraphics g) {
        if (this.chart.isCircularChart() || this.error_data) {
            return;
        }
        if (!this.chart.is2DChart && !this.calculatemode) {
            if (this.faceList != null && ((Chart3D)this.chart).drawType == 0) {
                for (Face element : this.faceList) {
                    element.draw(g, 0);
                }
            }
            return;
        }
    }

    @Override
    protected Point_2D getAbsPosition() {
        float x = 0.0f;
        float y = 0.0f;
        int thick = this.getThickness();
        if (this.linetype == 7) {
            x = 0.0f;
            y = this.absPosY - thick;
        } else if (this.linetype == 8) {
            x = this.absPosX - thick;
            y = 0.0f;
        }
        Vertex v = new Vertex(x, y, 0.0f);
        ((Chart3D)this.chart).space.transform(v);
        x = v.screen_x;
        y = this.chart.winHeight - v.screen_y;
        return new Point_2D(x, y);
    }
}

