/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d;

import java.awt.Color;
import java.util.Vector;
import java.util.logging.Logger;
import quadbase.chart.chart3d.ColorSpectrumUtil;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.ListNode;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;

public class VertexPolygon {
    private static final Logger LOGGER = Logger.getLogger(VertexPolygon.class.getName());
    Space space;
    Object object;
    ListNode node0;
    VertexPolygon next;

    public VertexPolygon(Vertex v1, Vertex v2, Vertex v3, Space space, Object object) {
        this.node0 = new ListNode(v1);
        ListNode node1 = new ListNode(v2);
        ListNode node2 = new ListNode(v3);
        this.node0.setNext(node1);
        this.node0.setPrev(node2);
        node1.setNext(node2);
        node1.setPrev(this.node0);
        node2.setNext(this.node0);
        node2.setPrev(node1);
        this.space = space;
        this.object = object;
    }

    public VertexPolygon(Vertex v1, Vertex v2, Vertex v3, Vertex v4, Space space, Object object) {
        this.node0 = new ListNode(v1);
        ListNode node1 = new ListNode(v2);
        ListNode node2 = new ListNode(v3);
        ListNode node3 = new ListNode(v4);
        this.node0.setNext(node1);
        this.node0.setPrev(node3);
        node1.setNext(node2);
        node1.setPrev(this.node0);
        node2.setNext(node3);
        node2.setPrev(node1);
        node3.setNext(this.node0);
        node3.setPrev(node2);
        this.space = space;
        this.object = object;
    }

    public VertexPolygon(ListNode node0, Space space, Object object) {
        this.node0 = node0;
        this.space = space;
        this.object = object;
    }

    public void cutPolygon(float[] allCutPixels) {
        Float cutPixel = this.getFirstCutPixel(allCutPixels);
        if (cutPixel == null) {
            return;
        }
        float thisCut = cutPixel.floatValue();
        ListNode split1 = null;
        ListNode currentNode = this.node0;
        ListNode ignoreNode = null;
        do {
            Vertex currentVertex = (Vertex)currentNode.getElement();
            if (currentVertex.y == thisCut) {
                if (split1 == null) {
                    split1 = currentNode;
                    ignoreNode = currentNode.getNext();
                    continue;
                }
                if (ignoreNode != currentNode) {
                    this.splitPolygon(allCutPixels, split1, currentNode);
                    break;
                }
                if (ignoreNode == null) continue;
                ignoreNode = ignoreNode.getNext();
                continue;
            }
            Vertex nextVertex = (Vertex)currentNode.getNext().getElement();
            float currentY = currentVertex.y;
            float nextY = nextVertex.y;
            if (!(nextY > thisCut && thisCut > currentY) && (!(nextY < thisCut) || !(thisCut < currentY))) continue;
            Vertex middleVertex = this.getMiddleVertex(currentVertex, nextVertex, thisCut);
            ListNode middleNode = new ListNode(middleVertex);
            middleNode.setNext(currentNode.getNext());
            middleNode.setPrev(currentNode);
            currentNode.setNext(middleNode);
            middleNode.getNext().setPrev(middleNode);
            if (split1 == null) {
                split1 = middleNode;
                currentNode = currentNode.getNext();
                continue;
            }
            this.splitPolygon(allCutPixels, split1, middleNode);
            break;
        } while ((currentNode = currentNode.getNext()) != this.node0);
        if (split1 == null) {
            LOGGER.fine("VertexPolygon: Internal error 0");
        }
    }

    public void print() {
        ListNode currentNode = this.node0;
        do {
            Vertex temp = (Vertex)currentNode.getElement();
        } while ((currentNode = currentNode.getNext()) != this.node0);
        if (this.next != null) {
            this.next.print();
        }
    }

    public static void main(String[] argv) {
        Vertex v1 = new Vertex(0.0f, 1000.0f, 0.0f);
        Vertex v2 = new Vertex(500.0f, 0.0f, 0.0f);
        Vertex v3 = new Vertex(500.0f, 0.0f, 1000.0f);
        Vertex v4 = new Vertex(0.0f, 1000.0f, 1000.0f);
        VertexPolygon polygon = new VertexPolygon(v1, v2, v3, v4, null, null);
        float[] allCutPixels = new float[]{400.0f};
        polygon.cutPolygon(allCutPixels);
        polygon.print();
    }

    private Float getFirstCutPixel(float[] cutPixel) {
        Vertex currentVertex = (Vertex)this.node0.getElement();
        float max = currentVertex.y;
        float min = currentVertex.y;
        for (ListNode currentNode = this.node0.getNext(); currentNode != this.node0; currentNode = currentNode.getNext()) {
            currentVertex = (Vertex)currentNode.getElement();
            max = Math.max(max, currentVertex.y);
            min = Math.min(min, currentVertex.y);
        }
        for (float temp : cutPixel) {
            if (!(min < temp) || !(temp < max)) continue;
            return Float.valueOf(temp);
        }
        return null;
    }

    private Vertex getMiddleVertex(Vertex v1, Vertex v2, float middleY) {
        float middleX = (v2.x - v1.x) * (middleY - v1.y) / (v2.y - v1.y) + v1.x;
        float middleZ = (v2.z - v1.z) * (middleY - v1.y) / (v2.y - v1.y) + v1.z;
        return new Vertex(middleX, middleY, middleZ, this.space);
    }

    private void splitPolygon(float[] allCutPixels, ListNode split1, ListNode split2) {
        ListNode split1Copy = new ListNode(split1.getElement());
        ListNode split2Copy = new ListNode(split2.getElement());
        ListNode split1Next = split1.getNext();
        ListNode split2Prev = split2.getPrev();
        split1.setNext(split2);
        split2.setPrev(split1);
        split1Copy.setNext(split1Next);
        split1Copy.setPrev(split2Copy);
        split2Copy.setNext(split1Copy);
        split2Copy.setPrev(split2Prev);
        split1Next.setPrev(split1Copy);
        split2Prev.setNext(split2Copy);
        VertexPolygon newPolygon = new VertexPolygon(split1Copy, this.space, this.object);
        newPolygon.next = this.next;
        this.next = newPolygon;
        this.cutPolygon(allCutPixels);
        newPolygon.cutPolygon(allCutPixels);
    }

    public void addFace(Vector faceList, ColorSpectrumUtil sUtil) {
        this.splitPolygonToFaces(faceList, sUtil);
        if (this.next != null) {
            this.next.addFace(faceList, sUtil);
        }
    }

    private void splitPolygonToFaces(Vector faceList, ColorSpectrumUtil sUtil) {
        Vertex v1 = (Vertex)this.node0.getElement();
        Vertex v2 = (Vertex)this.node0.getNext().getElement();
        Vertex v3 = (Vertex)this.node0.getNext().getNext().getElement();
        float anyYpixel = (v1.y + v2.y + v3.y) / 3.0f;
        Color color = sUtil.getColor(anyYpixel);
        ListNode currentNode = this.node0.getNext().getNext().getNext();
        while (true) {
            if (currentNode == this.node0) {
                this.add3(faceList, v1, v2, v3, color);
                break;
            }
            Vertex v4 = (Vertex)currentNode.getElement();
            this.add4(faceList, v1, v2, v3, v4, color);
            currentNode = currentNode.getNext();
            if (currentNode == this.node0) break;
            v2 = v4;
            v3 = (Vertex)currentNode.getElement();
            currentNode = currentNode.getNext();
        }
    }

    private void add3(Vector faceList, Vertex v1, Vertex v2, Vertex v3, Color color) {
        faceList.addElement(new Face(v1, v2, v3, v3, color, this.space, this.object));
    }

    private void add4(Vector faceList, Vertex v1, Vertex v2, Vertex v3, Vertex v4, Color color) {
        faceList.addElement(new Face(v1, v2, v3, v4, color, this.space, this.object));
    }
}

