/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.lib3d;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.logging.Logger;
import quadbase.chart.CGraphics;
import quadbase.chart.QbPattern;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.Shape3D;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.util.internal.Graphics2DTool;

public class CircumFace
extends Face {
    private static final Logger LOGGER = Logger.getLogger(CircumFace.class.getName());
    static final int CIRCUM_SECTORS = 40;
    private Shape3D circumFill;
    private Shape3D circumOpen;
    CircumFace previousFace = null;
    CircumFace nextFace = null;
    private boolean isInnerCircum;

    public CircumFace(double cx, double cy, double z1, double z2, double width, double height, double startangle, double spanangle, Color color, Space space, Object object, CircumFace previousFace, boolean isInnerCircum) {
        super(new Vertex((float)(cx + width * Math.cos(startangle)), (float)(cy + height * Math.sin(startangle)), (float)z1, space), new Vertex((float)(cx + width * Math.cos(startangle)), (float)(cy + height * Math.sin(startangle)), (float)z2, space), new Vertex((float)(cx + width * Math.cos(startangle + spanangle)), (float)(cy + height * Math.sin(startangle + spanangle)), (float)z2, space), new Vertex((float)(cx + width * Math.cos(startangle + spanangle)), (float)(cy + height * Math.sin(startangle + spanangle)), (float)z1, space), color, space, object);
        this.isInnerCircum = isInnerCircum;
        if (isInnerCircum) {
            Vertex tmp = this.v2;
            this.v2 = this.v1;
            this.v1 = tmp;
            tmp = this.v4;
            this.v4 = this.v3;
            this.v3 = tmp;
        }
        this.circumFill = Shape3D.createCircum3D(space, cx, cy, z1, z2, width, height, startangle, spanangle, true);
        this.circumOpen = Shape3D.createCircum3D(space, cx, cy, z1, z2, width, height, startangle, spanangle, false);
        this.previousFace = previousFace;
        if (previousFace != null) {
            previousFace.nextFace = this;
        }
    }

    public boolean isInnerCircum() {
        return this.isInnerCircum;
    }

    @Override
    public void draw(CGraphics cg, int drawType, int[] xpoints, int[] ypoints, boolean isDataPoint) {
        if (!this.bshow) {
            return;
        }
        Graphics g = cg.g;
        g.setColor(this.color.color);
        xpoints[0] = this.v1.screen_x;
        ypoints[0] = this.v1.screen_y;
        xpoints[1] = this.v2.screen_x;
        ypoints[1] = this.v2.screen_y;
        xpoints[2] = this.v3.screen_x;
        ypoints[2] = this.v3.screen_y;
        xpoints[3] = this.v4.screen_x;
        ypoints[3] = this.v4.screen_y;
        for (int i = 0; i < 4; ++i) {
            if (xpoints[i] >= -500 && ypoints[i] >= -500) continue;
            LOGGER.finest("Negative coordinates - Skipped drawing of a plane");
            return;
        }
        if (drawType != 0) {
            if (cg.g instanceof IFlashGraphics) {
                xpoints[4] = this.v1.screen_x;
                ypoints[4] = this.v1.screen_y;
            }
            if (drawType == 3 || drawType == 4) {
                this.fillShape(cg, xpoints, ypoints, this.color.color, false);
            } else {
                this.fillShape(cg, xpoints, ypoints, this.color.color, isDataPoint);
            }
            this.smoothEdges(g, xpoints, ypoints);
            if (drawType == 2 || drawType == 4) {
                this.drawWire(cg, xpoints, ypoints, isDataPoint);
            }
        } else {
            this.drawWire(cg, xpoints, ypoints, false);
        }
    }

    @Override
    void drawWire(CGraphics cg, int[] xpoints, int[] ypoints, boolean isDataPoint) {
        if (isDataPoint) {
            cg.g.setColor(cg.chart.getDataBorderColor());
        }
        this.drawShape(cg.g, xpoints, ypoints);
    }

    private void fillShape(CGraphics cg, int[] xpoints, int[] ypoints, Color fillColor, boolean usePattern) {
        Graphics g = cg.g;
        Object oldValue = null;
        Graphics2D g2d = null;
        if (g instanceof Graphics2D) {
            g2d = (Graphics2D)g;
            oldValue = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (usePattern && fillColor instanceof QbPattern && ((QbPattern)fillColor).getPatternTypeID() != 0) {
            Graphics2DTool.fillPatternShape(g, (QbPattern)fillColor, this.circumFill);
        } else if (g instanceof IFlashGraphics || g instanceof Graphics2D) {
            Color nextColor = this.nextFace != null ? this.nextFace.color.color : this.color.color;
            int a = this.v2.screen_y - this.v1.screen_y;
            int b = this.v1.screen_x - this.v2.screen_x;
            int c = this.v4.screen_x - this.v3.screen_x;
            int d = this.v4.screen_y - this.v3.screen_y;
            float s = (float)(b * (this.v1.screen_x - this.v4.screen_x) + a * (this.v4.screen_y - this.v1.screen_y)) / (float)(b * c - a * d);
            float x = (float)this.v4.screen_x + (float)c * s;
            float y = (float)this.v4.screen_y + (float)d * s;
            GradientPaint gradientPaint = new GradientPaint(this.v1.screen_x, this.v1.screen_y, this.color.color, x, y, nextColor);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setPaint(gradientPaint);
                ((Graphics2D)g).fill(this.circumFill);
            } else {
                ((IFlashGraphics)((Object)g)).setGradientPaint(gradientPaint);
                ((IFlashGraphics)((Object)g)).fill(this.circumFill);
            }
        } else {
            g.fillPolygon(xpoints, ypoints, 4);
        }
        if (g2d != null) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldValue);
        }
    }

    private void smoothEdges(Graphics g, int[] xpoints, int[] ypoints) {
        if (g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComposite = g2d.getComposite();
            g2d.setComposite(AlphaComposite.SrcOver);
            Stroke oldStroke = g2d.getStroke();
            g2d.setStroke(new BasicStroke(2.0f));
            this.drawShape(g, xpoints, ypoints);
            g2d.setStroke(oldStroke);
            g2d.setComposite(oldComposite);
        } else if (!(g instanceof IFlashGraphics)) {
            this.drawShape(g, xpoints, ypoints);
        }
    }

    private void drawShape(Graphics g, int[] xpoints, int[] ypoints) {
        if (g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g)).draw(this.circumOpen);
        } else if (g instanceof Graphics2D) {
            ((Graphics2D)g).draw(this.circumOpen);
        } else {
            g.drawLine(xpoints[1], ypoints[1], xpoints[2], ypoints[2]);
            g.drawLine(xpoints[3], ypoints[3], xpoints[0], ypoints[0]);
        }
        this.drawEdges(g);
    }

    private void drawEdges(Graphics g) {
        if (this.previousFace == null) {
            g.drawLine(this.v1.screen_x, this.v1.screen_y, this.v2.screen_x, this.v2.screen_y);
        }
        if (this.nextFace == null) {
            g.drawLine(this.v3.screen_x, this.v3.screen_y, this.v4.screen_x, this.v4.screen_y);
        }
    }
}

