/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.lib3d;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import quadbase.chart.CGraphics;
import quadbase.chart.chart3d.lib3d.PieFace;
import quadbase.chart.chart3d.lib3d.Shape3D;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.util.internal.RenderingChart;

public class DoughnutPieFace
extends PieFace {
    static final double MAX_SPAN_ANGLE = 0.39269908169872414;
    boolean isBottom = false;

    public DoughnutPieFace(double cx, double cy, double z, double width, double height, double startangle, double spanangle, double pieThickness, Color color, Space space, Object object, byte pieType) {
        super(new Vertex((float)(cx + width * pieThickness * Math.cos(startangle)), (float)(cy + height * pieThickness * Math.sin(startangle)), (float)z, space), new Vertex((float)(cx + width * Math.cos(startangle)), (float)(cy + height * Math.sin(startangle)), (float)z, space), new Vertex((float)(cx + width * Math.cos(startangle + spanangle)), (float)(cy + height * Math.sin(startangle + spanangle)), (float)z, space), new Vertex((float)(cx + width * pieThickness * Math.cos(startangle + spanangle)), (float)(cy + height * pieThickness * Math.sin(startangle + spanangle)), (float)z, space), color, space, object);
        if (z > 0.0) {
            this.isBottom = true;
            Vertex tmp = this.v2;
            this.v2 = this.v1;
            this.v1 = tmp;
            tmp = this.v4;
            this.v4 = this.v3;
            this.v3 = tmp;
        }
        this.pieType = pieType;
        this.shapeOpen = Shape3D.createDoughnutPie3D(space, cx, cy, z, width, height, startangle, spanangle, pieThickness, false);
        this.shapeFill = Shape3D.createDoughnutPie3D(space, cx, cy, z, width, height, startangle, spanangle, pieThickness, true);
    }

    @Override
    public void draw(CGraphics cg, int drawType, int[] xpoints, int[] ypoints, boolean isDataPoint) {
        if ((drawType == 3 || drawType == 4) && cg.g instanceof Graphics2D) {
            Graphics2D g2d = (Graphics2D)cg.g;
            Color c = this.originalColor.color;
            Space sp = (Space)cg.chart.getSpace();
            Color color1 = this.computeColor(this.v1, sp, c);
            Color color2 = this.computeColor(this.v2, sp, c);
            Color color3 = this.computeColor(this.v3, sp, c);
            Color color4 = this.computeColor(this.v4, sp, c);
            GradientPaint gradient = this.isBottom ? new GradientPaint(this.v1.screen_x, this.v1.screen_y, color1, this.v4.screen_x, this.v4.screen_y, color4) : new GradientPaint(this.v2.screen_x, this.v2.screen_y, color2, this.v3.screen_x, this.v3.screen_y, color3);
            g2d.setPaint(gradient);
            Object oldValue = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            RenderingChart.setRenderingHint(cg.g, cg.chart.renderingKey, cg.chart.renderingValue);
            g2d.fill(this.shapeFill);
            g2d.setClip(this.shapeFill);
            this.drawShadeTriangle(g2d, this.v1.screen_x, this.v1.screen_y, this.v2.screen_x, this.v2.screen_y, this.v3.screen_x, this.v3.screen_y, color1, color2, color3);
            this.drawShadeTriangle(g2d, this.v1.screen_x, this.v1.screen_y, this.v3.screen_x, this.v3.screen_y, this.v4.screen_x, this.v4.screen_y, color1, color3, color4);
            g2d.setClip(null);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldValue);
            g2d.setPaint(new GradientPaint(this.v1.screen_x, this.v1.screen_y, color1, this.v2.screen_x, this.v2.screen_y, color2));
            g2d.draw(new Line2D.Float(this.v1.screen_x, this.v1.screen_y, this.v2.screen_x, this.v2.screen_y));
            g2d.setPaint(new GradientPaint(this.v3.screen_x, this.v3.screen_y, color3, this.v4.screen_x, this.v4.screen_y, color4));
            g2d.draw(new Line2D.Float(this.v3.screen_x, this.v3.screen_y, this.v4.screen_x, this.v4.screen_y));
            g2d.setPaint(gradient);
            this.smoothEdges(g2d, xpoints, ypoints, false);
            if (drawType == 4) {
                this.drawWire(cg, xpoints, ypoints, isDataPoint);
            }
        } else {
            super.draw(cg, drawType, xpoints, ypoints, isDataPoint);
        }
    }

    @Override
    protected void drawShape(Graphics g, int[] xpoints, int[] ypoints) {
        if (g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g)).draw(this.shapeOpen);
        } else if (g instanceof Graphics2D) {
            ((Graphics2D)g).draw(this.shapeOpen);
        } else {
            g.drawLine(xpoints[1], ypoints[1], xpoints[2], ypoints[2]);
            g.drawLine(xpoints[3], ypoints[3], xpoints[0], ypoints[0]);
        }
        this.drawEdges(g);
    }

    @Override
    protected void drawEdges(Graphics g) {
        if (this.pieType == 2 || this.pieType == 3) {
            g.drawLine(this.v1.screen_x, this.v1.screen_y, this.v2.screen_x, this.v2.screen_y);
        }
        if (this.pieType == 1 || this.pieType == 3) {
            g.drawLine(this.v3.screen_x, this.v3.screen_y, this.v4.screen_x, this.v4.screen_y);
        }
    }
}

