/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.lib3d;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.util.Vector;
import java.util.logging.Logger;
import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.Line;
import quadbase.chart.MultiDimData;
import quadbase.chart.QbPattern;
import quadbase.chart.chart3d.Axis3D;
import quadbase.chart.chart3d.lib3d.ShareColor;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vector3D;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.util.IGradientPropertySet;
import quadbase.util.internal.Graphics2DTool;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.SVGEncoder;

public class Face {
    private static final Logger LOGGER = Logger.getLogger(Face.class.getName());
    public static final int WIREFRAME = 0;
    public static final int FLAT = 1;
    public static final int FLAT_BORDER = 2;
    public static final int GOURAUD = 3;
    public static final int GOURAUD_BORDER = 4;
    public static final double EPSI = 1.0E-4;
    public static final int SIDENONE = 0;
    public static final int SIDE123 = 1;
    public static final int SIDE341 = 2;
    public Vertex v1;
    public Vertex v2;
    public Vertex v3;
    public Vertex v4;
    public Vector3D normal;
    public ShareColor color;
    public ShareColor originalColor;
    public boolean isFixedColor = false;
    public boolean bshow = true;
    float coeff;
    public Object object;
    Vector skipLines = new Vector();
    static final int SKIP_LINE_12 = 1;
    static final int SKIP_LINE_23 = 2;
    static final int SKIP_LINE_34 = 3;
    static final int SKIP_LINE_14 = 4;

    public Face(Vertex _v1, Vertex _v2, Vertex _v3, Vertex _v4, Color color, Space space, Object object) {
        this(_v1, _v2, _v3, _v4, color, space, object, false);
    }

    public Face(Vertex _v1, Vertex _v2, Vertex _v3, Vertex _v4, Color color, Space space, Object object, boolean isFixedColor) {
        this.object = object;
        this.v1 = _v1;
        this.v2 = _v2;
        this.v3 = _v3;
        this.v4 = _v4;
        this.isFixedColor = isFixedColor;
        this.normal = new Vector3D();
        this.color = new ShareColor();
        this.originalColor = new ShareColor();
        if (!this.computeNormal()) {
            return;
        }
        this.originalColor.setColor(color);
        this.color.setColor(space.computeColor(this.normal, color));
        space.hiddenSurface.addFace(this);
    }

    public Face(Vertex _v1, Vertex _v2, Vertex _v3, Vertex _v4, Face face) {
        this(_v1, _v2, _v3, _v4, face, 0);
    }

    public Face(Vertex _v1, Vertex _v2, Vertex _v3, Vertex _v4, Face face, int shiftNode) {
        this.v1 = _v1;
        this.v2 = _v2;
        this.v3 = _v3;
        this.v4 = _v4;
        this.normal = face.normal;
        this.color = face.color;
        this.originalColor = face.originalColor;
        this.coeff = face.coeff;
        this.object = face.object;
        this.skipLines = this.shiftNode(face.skipLines, shiftNode);
    }

    public void setSkipLine(int k) {
        if (!this.skipLine(k)) {
            this.skipLines.add(k);
        }
    }

    private Vector shiftNode(Vector skipLines, int inc) {
        Vector<Integer> res = new Vector<Integer>();
        for (int i = 0; i < skipLines.size(); ++i) {
            int val;
            for (val = (Integer)skipLines.elementAt(i) + inc; val < 1; val += 4) {
            }
            while (val > 4) {
                val -= 4;
            }
            res.add(val);
        }
        return res;
    }

    void resetSkipLine() {
        this.skipLines = new Vector();
    }

    boolean skipLine(int j) {
        for (int i = 0; i < this.skipLines.size(); ++i) {
            if ((Integer)this.skipLines.elementAt(i) != j) continue;
            return true;
        }
        return false;
    }

    public final boolean computeNormal() {
        Vector3D temp = new Vector3D();
        this.normal.buildVector(this.v1, this.v2);
        if ((double)this.normal.i > -1.0E-4 && (double)this.normal.i < 1.0E-4 && (double)this.normal.j > -1.0E-4 && (double)this.normal.j < 1.0E-4 && (double)this.normal.k > -1.0E-4 && (double)this.normal.k < 1.0E-4) {
            this.normal.buildVector(this.v3, this.v4);
        }
        temp.buildVector(this.v3, this.v2);
        if ((double)temp.i > -1.0E-4 && (double)temp.i < 1.0E-4 && (double)temp.j > -1.0E-4 && (double)temp.j < 1.0E-4 && (double)temp.k > -1.0E-4 && (double)temp.k < 1.0E-4) {
            temp.buildVector(this.v1, this.v4);
        }
        this.normal.cross(temp);
        if ((double)this.normal.i > -1.0E-4 && (double)this.normal.i < 1.0E-4 && (double)this.normal.j > -1.0E-4 && (double)this.normal.j < 1.0E-4 && (double)this.normal.k > -1.0E-4 && (double)this.normal.k < 1.0E-4) {
            return false;
        }
        this.normal.norm();
        this.coeff = this.normal.i * this.v1.x + this.normal.j * this.v1.y + this.normal.k * this.v1.z;
        return true;
    }

    public Color getColor() {
        return this.originalColor.color;
    }

    public final void setColor(Space space, Color color) {
        if (this.isFixedColor) {
            color = color instanceof QbPattern && ((QbPattern)color).getPatternTypeID() != 0 ? new QbPattern(this.getColor(), ((QbPattern)color).getPatternTypeID()) : new Color(this.getColor().getRGB());
        }
        this.originalColor.setColor(color);
        this.color.setColor(space.computeColor(this.normal, color));
    }

    public static final void setFaceListColor(Space space, Face[] faceList, Color color) {
        if (faceList == null || space == null) {
            return;
        }
        for (Face element : faceList) {
            if (element == null) continue;
            element.setColor(space, color);
        }
    }

    public final void draw(CGraphics g, int drawType) {
        this.draw(g, drawType, new int[5], new int[5]);
    }

    public final void draw(CGraphics cg, int drawType, int[] xpoints, int[] ypoints) {
        this.draw(cg, drawType, xpoints, ypoints, false);
    }

    public void draw(CGraphics cg, int drawType, int[] xpoints, int[] ypoints, boolean isDataPoint) {
        if (cg.chart.isPatternOn() || cg.chart.isTranslucent()) {
            if (drawType == 3) {
                drawType = 1;
            }
            if (drawType == 4) {
                drawType = 2;
            }
        }
        if (cg.g instanceof IFlashGraphics || IOUtil.isSVGIncluded() && SVGEncoder.isSVGGraphics(cg.g)) {
            if (drawType == 3) {
                drawType = 1;
            }
            if (drawType == 4) {
                drawType = 2;
            }
        }
        if (this.bshow) {
            Graphics g = cg.g;
            g.setColor(this.color.color);
            xpoints[0] = this.v1.screen_x;
            ypoints[0] = this.v1.screen_y;
            xpoints[1] = this.v2.screen_x;
            ypoints[1] = this.v2.screen_y;
            xpoints[2] = this.v3.screen_x;
            ypoints[2] = this.v3.screen_y;
            xpoints[3] = this.v4.screen_x;
            ypoints[3] = this.v4.screen_y;
            xpoints[4] = this.v1.screen_x;
            ypoints[4] = this.v1.screen_y;
            for (int i = 0; i < 4; ++i) {
                if (xpoints[i] >= -500 && ypoints[i] >= -500) continue;
                LOGGER.finest("Skipped drawing of a plane");
                return;
            }
            IGradientPropertySet gradientSupport = null;
            if (this.object instanceof MultiDimData) {
                gradientSupport = cg.chart.getPrimaryDataGradientSupport();
                if (((MultiDimData)this.object).isSecondary()) {
                    gradientSupport = cg.chart.getSecondaryDataGradientSupport();
                }
            } else if (this.object instanceof Axis3D && cg.chart.background != null) {
                gradientSupport = cg.chart.background;
            }
            if (drawType == 1 || drawType == 2) {
                Polygon p;
                if (isDataPoint && this.color.color instanceof QbPattern && ((QbPattern)this.color.color).getPatternTypeID() != 0) {
                    p = new Polygon(xpoints, ypoints, 4);
                    Graphics2DTool.fillPatternPolygon(g, (QbPattern)this.color.color, p);
                } else if (gradientSupport != null && gradientSupport.isGradientEnabled()) {
                    p = new Polygon(xpoints, ypoints, 4);
                    Graphics2DTool.fillGradientPolygon(g, cg.chart, this.color.color, p, gradientSupport);
                } else {
                    g.fillPolygon(xpoints, ypoints, 4);
                }
                if (drawType == 2) {
                    if (cg.chart.getChartType() == 12) {
                        Color tmpColor = cg.g.getColor();
                        cg.setColor(Color.black);
                        this.drawWire(cg, xpoints, ypoints, isDataPoint);
                        cg.setColor(tmpColor);
                    } else {
                        this.drawWire(cg, xpoints, ypoints, isDataPoint);
                    }
                } else if (!(gradientSupport != null && gradientSupport.isGradientEnabled() || cg.chart.isTranslucent())) {
                    this.drawWire(cg, xpoints, ypoints, false);
                }
            } else if (drawType == 3 || drawType == 4) {
                Color c = this.originalColor.color;
                Space sp = (Space)cg.chart.getSpace();
                Color color1 = this.computeColor(this.v1, sp, c);
                Color color2 = this.computeColor(this.v2, sp, c);
                Color color3 = this.computeColor(this.v3, sp, c);
                Color color4 = this.computeColor(this.v4, sp, c);
                this.drawShadeTriangle(g, this.v1.screen_x, this.v1.screen_y, this.v2.screen_x, this.v2.screen_y, this.v3.screen_x, this.v3.screen_y, color1, color2, color3);
                this.drawShadeTriangle(g, this.v1.screen_x, this.v1.screen_y, this.v3.screen_x, this.v3.screen_y, this.v4.screen_x, this.v4.screen_y, color1, color3, color4);
                if (drawType == 4) {
                    this.drawWire(cg, xpoints, ypoints, isDataPoint);
                } else {
                    this.drawWire(cg, xpoints, ypoints, false);
                }
            } else if (drawType == 0) {
                this.drawWire(cg, xpoints, ypoints, false);
            }
        }
    }

    void drawWire(CGraphics cg, int[] xpoints, int[] ypoints, boolean isDataPoint) {
        int thickness = 1;
        Color c = cg.chart.getDataBorderColor();
        if (isDataPoint) {
            cg.g.setColor(c);
        }
        int len = xpoints.length;
        for (int i = 1; i < xpoints.length; ++i) {
            Color lineColor = isDataPoint ? c : cg.g.getColor();
            thickness = cg.chart.getDataBorderThickness();
            if (this.skipLine(i)) {
                if (this.object instanceof Axis) {
                    if (cg.chart.get3DDrawType() == 0) {
                        lineColor = cg.chart.getDesktopArea().areaColor;
                    } else {
                        lineColor = this.color.color;
                        if (cg.chart.thickRatio > 2.0) {
                            thickness = 2;
                        }
                    }
                } else {
                    lineColor = this.color.color;
                }
            }
            Line.drawLine(cg, xpoints[i - 1], ypoints[i - 1], xpoints[i], ypoints[i], thickness, lineColor, null, false, false, Color.black);
        }
        thickness = cg.chart.getDataBorderThickness();
        if (!this.skipLine(0)) {
            Line.drawLine(cg, xpoints[len - 1], ypoints[len - 1], xpoints[0], ypoints[0], thickness, isDataPoint ? c : cg.g.getColor());
        }
    }

    protected Color computeColor(Vertex v, Space sp, Color c) {
        Vector3D lightvec = new Vector3D(sp.lightpos.x - v.x, sp.lightpos.y - v.y, sp.lightpos.z - v.z, true);
        float cos_diffuse = Math.abs(lightvec.dot(this.normal));
        if (cos_diffuse < 0.3f) {
            cos_diffuse = 0.2f + (cos_diffuse + 1.0f) / 10.0f;
        }
        return new Color(Math.min((int)(sp.ambient_r + sp.intensity_r * ((float)c.getRed() * cos_diffuse)), 255), Math.min((int)(sp.ambient_g + sp.intensity_g * ((float)c.getGreen() * cos_diffuse)), 255), Math.min((int)(sp.ambient_b + sp.intensity_b * ((float)c.getBlue() * cos_diffuse)), 255));
    }

    protected void drawShadeTriangle(Graphics g, int x1, int y1, int x2, int y2, int x3, int y3, Color c1, Color c2, Color c3) {
        if (y3 >= y2) {
            if (y2 >= y1) {
                this.drawOrderTriangle(g, x1, y1, x2, y2, x3, y3, c1, c2, c3);
            } else if (y3 >= y1) {
                this.drawOrderTriangle(g, x2, y2, x1, y1, x3, y3, c2, c1, c3);
            } else {
                this.drawOrderTriangle(g, x2, y2, x3, y3, x1, y1, c2, c3, c1);
            }
        } else if (y3 >= y1) {
            this.drawOrderTriangle(g, x1, y1, x3, y3, x2, y2, c1, c3, c2);
        } else if (y1 >= y2) {
            this.drawOrderTriangle(g, x3, y3, x2, y2, x1, y1, c3, c2, c1);
        } else {
            this.drawOrderTriangle(g, x3, y3, x1, y1, x2, y2, c3, c1, c2);
        }
    }

    private final void drawOrderTriangle(Graphics g, int x1, int y1, int x2, int y2, int x3, int y3, Color c1, Color c2, Color c3) {
        int j;
        float startx = x1;
        float endx = x1;
        float d12 = 0.0f;
        float d13 = 0.0f;
        float d23 = 0.0f;
        int r1 = c1.getRed();
        int r2 = c2.getRed();
        int r3 = c3.getRed();
        int g1 = c1.getGreen();
        int g2 = c2.getGreen();
        int g3 = c3.getGreen();
        int b1 = c1.getBlue();
        int b2 = c2.getBlue();
        int b3 = c3.getBlue();
        float r12 = 0.0f;
        float g12 = 0.0f;
        float b12 = 0.0f;
        float r13 = 0.0f;
        float g13 = 0.0f;
        float b13 = 0.0f;
        float r23 = 0.0f;
        float g23 = 0.0f;
        float b23 = 0.0f;
        int dy = y2 - y1;
        float startr = r1;
        float endr = r1;
        float startg = g1;
        float endg = g1;
        float startb = b1;
        float endb = b1;
        if (dy != 0) {
            d12 = (float)(x2 - x1) / (float)dy;
            r12 = (float)(r2 - r1) / (float)dy;
            g12 = (float)(g2 - g1) / (float)dy;
            b12 = (float)(b2 - b1) / (float)dy;
        }
        if ((dy = y3 - y1) != 0) {
            d13 = (float)(x3 - x1) / (float)dy;
            r13 = (float)(r3 - r1) / (float)dy;
            g13 = (float)(g3 - g1) / (float)dy;
            b13 = (float)(b3 - b1) / (float)dy;
        }
        if ((dy = y3 - y2) != 0) {
            d23 = (float)(x3 - x2) / (float)dy;
            r23 = (float)(r3 - r2) / (float)dy;
            g23 = (float)(g3 - g2) / (float)dy;
            b23 = (float)(b3 - b2) / (float)dy;
        }
        g.setColor(c1);
        g.drawLine(x1, y1, x1, y1);
        for (j = y1 + 1; j <= y2; ++j) {
            this.fillLine(g, Math.round(startx += d13), Math.round(endx += d12), j, (int)(startr += r13), (int)(startg += g13), (int)(startb += b13), (int)(endr += r12), (int)(endg += g12), (int)(endb += b12));
        }
        endx = x2;
        endr = r2;
        endg = g2;
        endb = b2;
        for (j = y2 + 1; j < y3; ++j) {
            this.fillLine(g, Math.round(startx += d13), Math.round(endx += d23), j, (int)(startr += r13), (int)(startg += g13), (int)(startb += b13), (int)(endr += r23), (int)(endg += g23), (int)(endb += b23));
        }
    }

    private final void fillLine(Graphics g, int x1, int x2, int y, int r1, int g1, int b1, int r2, int g2, int b2) {
        if (g instanceof Graphics2D || g instanceof IFlashGraphics) {
            Color color1 = new Color(r1, g1, b1);
            Color color2 = new Color(r2, g2, b2);
            if (g instanceof Graphics2D) {
                ((Graphics2D)g).setPaint(new GradientPaint(x1, y, color1, x2, y, color2));
            } else {
                ((IFlashGraphics)((Object)g)).setGradientPaint(new GradientPaint(x1, y, color1, x2, y, color2));
            }
            g.drawLine(x1, y, x2, y);
        } else if (x1 == x2) {
            g.setColor(new Color((r1 + r2) / 2, (g1 + g2) / 2, (b1 + b2) / 2));
            g.drawLine(x1, y, x2, y);
        } else {
            int dx = x2 - x1;
            float dr = (float)(r2 - r1) / (float)dx;
            float dg = (float)(g2 - g1) / (float)dx;
            float db = (float)(b2 - b1) / (float)dx;
            float cr = r1;
            float cg = g1;
            float cb = b1;
            if (x1 > x2) {
                for (int i = x1; i >= x2; --i) {
                    g.setColor(new Color((int)cr, (int)cg, (int)cb));
                    g.drawLine(i, y, i, y);
                    cr -= dr;
                    cg -= dg;
                    cb -= db;
                }
            } else {
                for (int i = x1; i <= x2; ++i) {
                    g.setColor(new Color((int)cr, (int)cg, (int)cb));
                    g.drawLine(i, y, i, y);
                    cr += dr;
                    cg += dg;
                    cb += db;
                }
            }
        }
    }

    public boolean select(int x, int y) {
        if (this.v1.screen_x == this.v2.screen_x && this.v2.screen_x == this.v3.screen_x && this.v3.screen_x == this.v4.screen_x || this.v1.screen_y == this.v2.screen_y && this.v2.screen_y == this.v3.screen_y && this.v3.screen_y == this.v4.screen_y) {
            return false;
        }
        return Line.rightside(this.v1.screen_x, this.v1.screen_y, this.v2.screen_x, this.v2.screen_y, x, y) && Line.rightside(this.v2.screen_x, this.v2.screen_y, this.v3.screen_x, this.v3.screen_y, x, y) && Line.rightside(this.v3.screen_x, this.v3.screen_y, this.v4.screen_x, this.v4.screen_y, x, y) && Line.rightside(this.v4.screen_x, this.v4.screen_y, this.v1.screen_x, this.v1.screen_y, x, y);
    }

    public int selectSide(int x, int y) {
        if (Line.rightside(this.v1.screen_x, this.v1.screen_y, this.v3.screen_x, this.v3.screen_y, x, y)) {
            if (Line.rightside(this.v3.screen_x, this.v3.screen_y, this.v4.screen_x, this.v4.screen_y, x, y) && Line.rightside(this.v4.screen_x, this.v4.screen_y, this.v1.screen_x, this.v1.screen_y, x, y)) {
                return 2;
            }
        } else if (Line.rightside(this.v1.screen_x, this.v1.screen_y, this.v2.screen_x, this.v2.screen_y, x, y) && Line.rightside(this.v2.screen_x, this.v2.screen_y, this.v3.screen_x, this.v3.screen_y, x, y)) {
            return 1;
        }
        return 0;
    }
}

