/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.lib3d;

import quadbase.chart.chart3d.lib3d.CircumFace;
import quadbase.chart.chart3d.lib3d.DList;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.ListNode;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vector3D;

public class FacePriority {
    DList frontFaces = new DList();
    DList backFaces = new DList();
    DList cutFaces = new DList();
    DList parallelFaces = new DList();
    public static float EPSI = 0.01f;
    Face face;

    public FacePriority(Face face) {
        this.face = face;
    }

    public void setPriority(Space space, DList faceList) {
        Vector3D nor = this.face.normal;
        ListNode currNode = faceList.headNode;
        while (currNode.next != null) {
            currNode = currNode.next;
            Face face2 = (Face)currNode.getElement();
            if (face2 == this.face) continue;
            float s1 = face2.v1.x * nor.i + face2.v1.y * nor.j + face2.v1.z * nor.k - this.face.coeff;
            float s2 = face2.v2.x * nor.i + face2.v2.y * nor.j + face2.v2.z * nor.k - this.face.coeff;
            float s3 = face2.v3.x * nor.i + face2.v3.y * nor.j + face2.v3.z * nor.k - this.face.coeff;
            float s4 = face2.v4.x * nor.i + face2.v4.y * nor.j + face2.v4.z * nor.k - this.face.coeff;
            if (s1 > -EPSI && s1 < EPSI && s2 > -EPSI && s2 < EPSI && s3 > -EPSI && s3 < EPSI && s4 > -EPSI && s4 < EPSI) {
                this.parallelFaces.add(face2);
                continue;
            }
            if (s1 > -EPSI && s2 > -EPSI && s3 > -EPSI && s4 > -EPSI) {
                this.frontFaces.add(face2);
                continue;
            }
            if (s1 < EPSI && s2 < EPSI && s3 < EPSI && s4 < EPSI) {
                this.backFaces.add(face2);
                continue;
            }
            if (face2 instanceof CircumFace) {
                this.frontFaces.add(face2);
                continue;
            }
            boolean doApproximation = space.is3DApproximationUsed;
            if (doApproximation) {
                float average = (s1 + s2 + s3 + s4) / 4.0f;
                if (average > 0.0f) {
                    this.frontFaces.add(face2);
                    continue;
                }
                this.backFaces.add(face2);
                continue;
            }
            this.cutFaces.add(face2);
        }
    }

    void removeFace(Face f) {
        this.frontFaces.remove(f);
        this.backFaces.remove(f);
        this.cutFaces.remove(f);
        this.parallelFaces.remove(f);
    }

    public String toString() {
        return "-- Face -- " + this.face + "\nFront    :" + this.frontFaces + "\nBack     :" + this.backFaces + "\nCut      :" + this.cutFaces + "\nParallel :" + this.parallelFaces + "\n";
    }
}

