/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.lib3d;

import quadbase.chart.Axis;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.DataLine;
import quadbase.chart.FaceData;
import quadbase.chart.Grid;
import quadbase.chart.MultiDimData;
import quadbase.chart.Ticker;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.lib3d.BunchesNode;
import quadbase.chart.chart3d.lib3d.ConnectNode;
import quadbase.chart.chart3d.lib3d.DList;
import quadbase.chart.chart3d.lib3d.Face;
import quadbase.chart.chart3d.lib3d.ListNode;
import quadbase.chart.chart3d.lib3d.PieFace;
import quadbase.chart.chart3d.lib3d.PriorityTable;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.SwitchNode;
import quadbase.chart.chart3d.lib3d.Vector3D;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.common.util.internal.IFlashGraphics;
import quadbase.util.internal.Composite;
import quadbase.util.internal.IOUtil;
import quadbase.util.internal.RenderingChart;
import quadbase.util.internal.SVGEncoder;

public class HiddenSurface {
    DList faceList = new DList();
    ListNode reversefaceList;
    PriorityTable priorityTable = new PriorityTable();
    boolean recompute_reverseLink;
    public ConnectNode treeRoot = null;

    public final void addFace(Face f) {
        this.faceList.add(f);
    }

    public void reset() {
        this.treeRoot = null;
        this.faceList = new DList();
        this.priorityTable = new PriorityTable();
    }

    public final void scaling(Space space, float sx, float sy, float sz) {
        int i = 0;
        while (i < space.vertex_no) {
            Vertex v = space.vertexList[i++];
            v.x *= sx;
            v.y *= sy;
            v.z *= sz;
        }
    }

    public void draw(CGraphics g, Space space) {
        ListNode currNode = this.faceList.getHeadNode();
        if (this.treeRoot == null) {
            this.scaling(space, space.xscale, space.yscale, space.zscale);
            while (currNode.next != null) {
                ListNode prevNode = currNode;
                if (((Face)(currNode = currNode.getNext()).getElement()).computeNormal()) continue;
                prevNode.next = currNode.next;
                currNode = prevNode;
            }
            this.treeRoot = this.priorityTable.dynamicBuildFeudalTree(space, this.faceList);
            this.scaling(space, 1.0f / space.xscale, 1.0f / space.yscale, 1.0f / space.zscale);
        }
        this.faceList = new DList();
        space.transform();
        this.recompute_reverseLink = true;
        this.generatePriorityList(this.treeRoot, space.viewVec);
        int[] xpoints = new int[5];
        int[] ypoints = new int[5];
        currNode = this.faceList.headNode;
        Chart chart = g.chart;
        boolean drawWallX = false;
        boolean drawWallY = false;
        boolean drawWallZ = false;
        boolean drawTickerX = false;
        boolean drawTickerY = false;
        boolean drawTickerZ = false;
        boolean drawTickerS = false;
        currNode = currNode.next;
        int m = 0;
        int dtype = g.chart.get3DDrawType();
        if (g.chart.isPatternOn() || g.chart.isTranslucent()) {
            if (dtype == 3) {
                dtype = 1;
            }
            if (dtype == 4) {
                dtype = 2;
            }
        }
        if (g.g instanceof IFlashGraphics || IOUtil.isSVGIncluded() && SVGEncoder.isSVGGraphics(g.g)) {
            if (dtype == 3) {
                dtype = 1;
            }
            if (dtype == 4) {
                dtype = 2;
            }
        }
        int listsize = this.faceList.size();
        boolean bhint = dtype == 3 || dtype == 4;
        Axis ax = chart.axis[0];
        Axis ay = chart.axis[1];
        Axis az = chart.axis[2];
        Axis as = chart.axis[3];
        boolean bframe = chart.showWallFrame;
        boolean isTranslucent = chart.isTranslucentSupport();
        while (currNode != null) {
            if (bhint) {
                g.showHint("Rendering... " + m++ * 100 / listsize + "% Completed");
            }
            Face face = (Face)currNode.getElement();
            if (face.object instanceof FaceData && ((FaceData)face.object).isSurfaceChart()) {
                if (isTranslucent) {
                    Composite.setCompositeSrcOver(g.g, chart.getTranslucentValue());
                }
                face.draw(g, dtype, xpoints, ypoints);
            } else if (face.object instanceof MultiDimData || face.object instanceof DataLine) {
                if (face.object instanceof MultiDimData) {
                    if (g.g instanceof IFlashGraphics) {
                        boolean setToolTip = true;
                        if (chart.isCircularChart()) {
                            setToolTip = face instanceof PieFace;
                        }
                        if (setToolTip) {
                            ((IFlashGraphics)((Object)g.g)).setToolTipsAndLink(face.object);
                        }
                    }
                } else if (face.object instanceof DataLine && g.g instanceof IFlashGraphics) {
                    ((IFlashGraphics)((Object)g.g)).setAxes();
                }
                if (isTranslucent) {
                    Composite.setCompositeSrcOver(g.g, chart.getTranslucentValue());
                }
                face.draw(g, dtype, xpoints, ypoints, face.object instanceof MultiDimData);
                if (g.chart.getChartType() != 9 && g.chart.getChartType() != 10) {
                    CString topLabel;
                    if (g.chart.isStackType()) {
                        CString topLabel2;
                        if (g.chart.getTopValueState() && g.chart.getStackLabelState() && face.object instanceof MultiDimData && (topLabel2 = ((MultiDimData)face.object).topLabel) != null) {
                            ((Chart3D)g.chart).drawLabel3D(g, topLabel2);
                        }
                    } else if (face.object instanceof MultiDimData && (topLabel = ((MultiDimData)face.object).topLabel) != null && g.chart.isTopLabelVisible(topLabel)) {
                        ((Chart3D)g.chart).drawLabel3D(g, topLabel);
                    }
                }
                if (g.g instanceof IFlashGraphics) {
                    ((IFlashGraphics)((Object)g.g)).resetToolTipsAndLink();
                    ((IFlashGraphics)((Object)g.g)).resetAxes();
                }
            } else if (face.object instanceof Axis) {
                if (g.g instanceof IFlashGraphics) {
                    ((IFlashGraphics)((Object)g.g)).setAxes();
                }
                if (((Axis)face.object).bshow) {
                    if (isTranslucent) {
                        if (g.chart.getAddOnChart() != null && g.chart.getAddOnChart().size() > 0) {
                            Composite.setCompositeSrcOver(g.g, chart.getTranslucentValue());
                        } else {
                            Composite.setOriginalComposite(g.g);
                        }
                    }
                    face.draw(g, dtype, xpoints, ypoints);
                }
                if (g.g instanceof IFlashGraphics) {
                    ((IFlashGraphics)((Object)g.g)).resetAxes();
                }
            } else if (!(face.object instanceof CString)) {
                if (face.object instanceof Grid) {
                    if (g.g instanceof IFlashGraphics) {
                        ((IFlashGraphics)((Object)g.g)).setAxes();
                    }
                    if (isTranslucent) {
                        Composite.setOriginalComposite(g.g);
                    }
                    if (face.object == ax.grid) {
                        if (!drawWallX) {
                            this.drawGrid(g, ax, false);
                            this.drawGrid(g, ay, true);
                            if (bframe) {
                                ax.drawFrameWall(g);
                            }
                            drawWallX = true;
                        }
                    } else if (face.object == ay.grid) {
                        if (!drawWallY) {
                            this.drawGrid(g, ay, false);
                            this.drawGrid(g, az, true);
                            if (bframe) {
                                ay.drawFrameWall(g);
                            }
                            drawWallY = true;
                        }
                    } else if (face.object == az.grid && !drawWallZ) {
                        this.drawGrid(g, ax, true);
                        this.drawGrid(g, az, false);
                        if (bframe) {
                            az.drawFrameWall(g);
                        }
                        drawWallZ = true;
                    }
                    if (g.g instanceof IFlashGraphics) {
                        ((IFlashGraphics)((Object)g.g)).resetAxes();
                    }
                } else if (face.object instanceof Ticker) {
                    if (g.g instanceof IFlashGraphics) {
                        ((IFlashGraphics)((Object)g.g)).setAxes();
                    }
                    if (isTranslucent) {
                        Composite.setOriginalComposite(g.g);
                    }
                    boolean restoreRendering = false;
                    if (chart.setAntiAliasForChartOnly && chart.isAntiAliasEnabled()) {
                        restoreRendering = true;
                        chart.setAntiAliasEnabled(false);
                        RenderingChart.setRenderingHint(g.g, chart.renderingKey, chart.renderingValue);
                    }
                    if (face.object == ax.ticker) {
                        if (!drawTickerX) {
                            ax.drawAxis(g);
                            drawTickerX = true;
                        }
                    } else if (face.object == ay.ticker) {
                        if (!drawTickerY) {
                            ay.drawAxis(g);
                            drawTickerY = true;
                        }
                    } else if (face.object == az.ticker) {
                        if (!drawTickerZ) {
                            az.drawAxis(g);
                            drawTickerZ = true;
                        }
                    } else if (face.object == as.ticker && !drawTickerS) {
                        as.drawAxis(g);
                        drawTickerS = true;
                    }
                    if (restoreRendering) {
                        chart.setAntiAliasEnabled(true);
                        RenderingChart.setRenderingHint(g.g, chart.renderingKey, chart.renderingValue);
                    }
                }
            }
            currNode = currNode.next;
            if (!(g.g instanceof IFlashGraphics)) continue;
            ((IFlashGraphics)((Object)g.g)).resetAxes();
        }
        if (chart.getChartType() == 3 && chart.getTopValueState() && chart.topLabels != null && chart.topLabels.size() > 0 && chart.topLabels.lastElement() instanceof CString) {
            ((Chart3D)g.chart).drawLabel3D(g, (CString)chart.topLabels.lastElement());
        }
        if (bhint) {
            g.showHint("Rendering... 100% Completed");
        }
    }

    private void generatePriorityList(ConnectNode connectNode, Vector3D viewVec) {
        SwitchNode sn;
        if (connectNode == null) {
            return;
        }
        if (connectNode.backNode != null) {
            this.addAllBunches(connectNode.backNode, viewVec);
        }
        if ((sn = connectNode.splitNode) != null) {
            Vector3D n = sn.face.normal;
            if (viewVec.i * n.i + viewVec.j * n.j + viewVec.k * n.k < 0.0f) {
                this.generatePriorityList(sn.rightNode, viewVec);
                this.faceList.add(sn.face);
                this.addAllBunches(sn.middleNode, viewVec);
                this.generatePriorityList(sn.leftNode, viewVec);
            } else {
                this.generatePriorityList(sn.leftNode, viewVec);
                this.addAllBunches(sn.middleNode, viewVec);
                this.generatePriorityList(sn.rightNode, viewVec);
            }
        }
        if (connectNode.frontNode != null) {
            this.addAllBunches(connectNode.frontNode, viewVec);
        }
    }

    private void addAllBunches(BunchesNode bnode, Vector3D viewVec) {
        while (bnode != null) {
            DList vec = bnode.vec;
            ListNode currNode = vec.headNode;
            while (currNode.next != null) {
                currNode = currNode.next;
                Face f = (Face)currNode.getElement();
                Vector3D n = f.normal;
                if (!(viewVec.i * n.i + viewVec.j * n.j + viewVec.k * n.k < 0.0f)) continue;
                this.faceList.add(f);
            }
            bnode = bnode.nextNode;
        }
    }

    public Object select(Chart chart, int x, int y) {
        for (ListNode currNode = this.reversefaceList = this.reverseLink(); currNode != this.faceList.headNode; currNode = currNode.getPrev()) {
            if (currNode == null) {
                return null;
            }
            if (!((Face)currNode.getElement()).select(x, y)) continue;
            Object target = ((Face)currNode.getElement()).object;
            if (target instanceof FaceData && ((FaceData)target).isSurfaceChart()) {
                return target;
            }
            if (target instanceof MultiDimData) {
                if (chart.getChartType() == 3) {
                    return this.getLineMultiDimData(currNode, x, y);
                }
                return target;
            }
            if (target instanceof DataLine) {
                return target;
            }
            if (target instanceof Axis && ((Axis)target).bshow) {
                return target;
            }
            if (!(target instanceof Grid) || !chart.axis[((Grid)target).orient].bshow) continue;
            return chart.axis[((Grid)target).orient];
        }
        return null;
    }

    private MultiDimData getLineMultiDimData(ListNode currNode, int x, int y) {
        Face curFace = (Face)currNode.getElement();
        MultiDimData curData = (MultiDimData)curFace.object;
        MultiDimData nextData = this.getNextData(curData);
        Vertex pt = this.pick3DPoint(x, y);
        double step = Math.abs(curFace.v3.x - curFace.v1.x) / 2.0f;
        double breakPt = (double)curFace.v1.x + step;
        if (step == 0.0) {
            if (curData == curData.parent.multiData[0]) {
                return curData;
            }
            return nextData;
        }
        if (this.nextSection(pt.x, breakPt, breakPt + step)) {
            return nextData;
        }
        return curData;
    }

    private boolean nextSection(double x, double x1, double x2) {
        double minX = x1 < x2 ? x1 : x2;
        return x > minX;
    }

    private MultiDimData getNextData(MultiDimData curData) {
        int ct = curData.parent.multiData.length - 1;
        for (int i = 0; i < ct; ++i) {
            if (curData.parent.multiData[i] != curData) continue;
            return curData.parent.multiData[i + 1];
        }
        return curData;
    }

    public Vertex pick3DPoint(int x, int y) {
        for (ListNode currNode = this.reversefaceList = this.reverseLink(); currNode != this.faceList.headNode; currNode = currNode.getPrev()) {
            int side;
            Face f = (Face)currNode.getElement();
            if (!(f.object instanceof MultiDimData) && !(f.object instanceof Axis) || (side = f.selectSide(x, y)) == 0) continue;
            if (side == 1) {
                return this.backProjectPoint(f.v1, f.v2, f.v3, x, y);
            }
            return this.backProjectPoint(f.v3, f.v4, f.v1, x, y);
        }
        return null;
    }

    private Vertex backProjectPoint(Vertex v1, Vertex v2, Vertex v3, int x, int y) {
        int a1 = v2.screen_x - v3.screen_x;
        int b1 = v3.screen_x - v1.screen_x;
        int c1 = x - v1.screen_x;
        int a2 = v2.screen_y - v3.screen_y;
        int b2 = v3.screen_y - v1.screen_y;
        int c2 = y - v1.screen_y;
        float delta = a1 * b2 - a2 * b1;
        if (delta != 0.0f) {
            float st = (float)(c1 * b2 - c2 * b1) / delta;
            float t = (float)(a1 * c2 - a2 * c1) / delta;
            return new Vertex(st * (v2.x - v3.x) + t * (v3.x - v1.x) + v1.x, st * (v2.y - v3.y) + t * (v3.y - v1.y) + v1.y, st * (v2.z - v3.z) + t * (v3.z - v1.z) + v1.z);
        }
        int d = v2.screen_x - v3.screen_x;
        if (d == 0) {
            d = v2.screen_y - v3.screen_y;
            if (d == 0) {
                return new Vertex(v2.x, v2.y, v2.z);
            }
            delta = (float)(y - v3.screen_y) / (float)d;
        } else {
            delta = (float)(x - v3.screen_x) / (float)d;
        }
        return new Vertex(delta * (v2.x - v3.x) + v3.x, delta * (v2.y - v3.y) + v3.y, delta * (v2.z - v3.z) + v3.z);
    }

    private ListNode reverseLink() {
        if (!this.recompute_reverseLink) {
            return this.faceList.lastNode;
        }
        ListNode currNode = this.faceList.headNode;
        while (currNode.next != null) {
            ListNode prevNode = currNode;
            currNode = currNode.getNext();
            currNode.prev = prevNode;
        }
        this.recompute_reverseLink = false;
        return currNode;
    }

    private void drawGrid(CGraphics g, Axis ax, boolean odd) {
        ax.grid.draw(g, odd, ax.skipGridOffset, ax.columnField != null ? ax.columnField.tickerSepSize : 1);
    }
}

