/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.lib3d;

import quadbase.chart.chart3d.lib3d.Vector3D;
import quadbase.chart.chart3d.lib3d.Vertex;

public class Matrix {
    float xx;
    float xy;
    float xz;
    float xo;
    float yx;
    float yy;
    float yz;
    float yo;
    float zx;
    float zy;
    float zz;
    float zo;

    public Matrix() {
        this.xx = 1.0f;
        this.yy = 1.0f;
        this.zz = 1.0f;
    }

    public Matrix(Vector3D v1, Vector3D v2, Vector3D v3, boolean rowOrder) {
        if (rowOrder) {
            this.xx = v1.i;
            this.xy = v1.j;
            this.xz = v1.k;
            this.xo = 0.0f;
            this.yx = v2.i;
            this.yy = v2.j;
            this.yz = v2.k;
            this.yo = 0.0f;
            this.zx = v3.i;
            this.zy = v3.k;
            this.zz = v3.k;
            this.zo = 0.0f;
        } else {
            this.xx = v1.i;
            this.xy = v2.i;
            this.xz = v3.i;
            this.xo = 0.0f;
            this.yx = v1.j;
            this.yy = v2.j;
            this.yz = v3.j;
            this.yo = 0.0f;
            this.zx = v1.k;
            this.zy = v2.k;
            this.zz = v3.k;
            this.zo = 0.0f;
        }
    }

    public final void transform(Vertex v, Vertex u) {
        u.x = v.x * this.xx + v.y * this.xy + v.z * this.xz + this.xo;
        u.y = v.x * this.yx + v.y * this.yy + v.z * this.yz + this.yo;
        u.z = v.x * this.zx + v.y * this.zy + v.z * this.zz + this.zo;
    }

    public final void lookat(float from_x, float from_y, float from_z, float to_x, float to_y, float to_z) {
        float x = from_x - to_x;
        float y = from_y - to_y;
        float z = from_z - to_z;
        float t1 = x * x + z * z;
        if (t1 != 0.0f) {
            float t2 = (float)Math.sqrt(t1 + y * y);
            this.yy = t1;
            t1 = (float)Math.sqrt(t1);
            this.zo = 1.0f - t2;
            this.xx = z / t1;
            this.xy = 0.0f;
            this.xz = -x / t1;
            this.zx = x / t2;
            this.zy = y / t2;
            this.zz = z / t2;
            this.yx = -x * y / (t1 *= t2);
            this.yy /= t1;
            this.yz = -y * z / t1;
        } else {
            this.zy = 1.0f;
            this.xx = 1.0f;
            this.yz = -1.0f;
            this.zz = 0.0f;
            this.zx = 0.0f;
            this.yy = 0.0f;
            this.yx = 0.0f;
            this.xz = 0.0f;
            this.xy = 0.0f;
            this.zo = (float)(1.0 - Math.sqrt(y * y));
            if ((double)this.zo == 1.0) {
                this.zo = 0.9999f;
            }
        }
        this.xo = -(to_x * this.xx + to_y * this.xy + to_z * this.xz);
        this.yo = -(to_x * this.yx + to_y * this.yy + to_z * this.yz);
        this.zo = -(to_x * this.zx + to_y * this.zy + to_z * this.zz) + this.zo;
    }

    public void translate(Vertex v) {
        this.xo += v.x;
        this.yo += v.y;
        this.zo += v.z;
    }

    public String toString() {
        return "[" + this.xo + "," + this.xx + "," + this.xy + "," + this.xz + ";" + this.yo + "," + this.yx + "," + this.yy + "," + this.yz + ";" + this.zo + "," + this.zx + "," + this.zy + "," + this.zz + "]";
    }

    public static final float determinant(float x1, float x2, float x3, float x4, float x5, float x6, float x7, float x8, float x9) {
        return x1 * (x5 * x9 - x6 * x8) - x2 * (x4 * x9 - x6 * x7) + x3 * (x4 * x8 - x5 * x7);
    }
}

