/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.lib3d;

import quadbase.chart.chart3d.lib3d.Vertex;

public class Vector3D {
    public float i;
    public float j;
    public float k;

    public Vector3D() {
    }

    public Vector3D(float x, float y, float z) {
        this.i = x;
        this.j = y;
        this.k = z;
    }

    public Vector3D(Vector3D v) {
        this.i = v.i;
        this.j = v.j;
        this.k = v.k;
    }

    public Vector3D(float x, float y, float z, boolean normalized) {
        float t = (float)Math.sqrt(x * x + y * y + z * z);
        this.i = x / t;
        this.j = y / t;
        this.k = z / t;
    }

    public final Vector3D buildVector(Vertex vert1, Vertex vert2) {
        this.i = vert2.x - vert1.x;
        this.j = vert2.y - vert1.y;
        this.k = vert2.z - vert1.z;
        return this;
    }

    public final float dot(Vector3D v1) {
        return v1.i * this.i + v1.j * this.j + v1.k * this.k;
    }

    public final float dot(Vertex v1) {
        return v1.x * this.i + v1.y * this.j + v1.z * this.k;
    }

    public final void cross(Vector3D v1) {
        float tempi = this.j * v1.k - this.k * v1.j;
        float tempj = this.k * v1.i - this.i * v1.k;
        this.k = this.i * v1.j - this.j * v1.i;
        this.i = tempi;
        this.j = tempj;
    }

    public final boolean norm() {
        float t = (float)Math.sqrt(this.i * this.i + this.j * this.j + this.k * this.k);
        if (t != 0.0f) {
            this.i /= t;
            this.j /= t;
            this.k /= t;
            return true;
        }
        return false;
    }

    public String toString() {
        return "i:" + this.i + " j:" + this.j + " k:" + this.k;
    }
}

