/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.types3d.general3d;

import java.awt.Component;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.IPieChart;
import quadbase.chart.PieChart;
import quadbase.chart.Point3D;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.types3d.general3d.DoughnutChart3D;
import quadbase.common.util.internal.IFlashGraphics;

public class PieChart3D
extends Chart3D
implements IPieChart {
    PieChart pieChart;

    public PieChart3D(Component component, ColData[] colData, boolean[] usedColumns) {
        this(component, 6, colData, usedColumns);
    }

    public PieChart3D(Chart chart) {
        this(6, chart);
    }

    PieChart3D(Component component, int type, ColData[] colData, boolean[] usedColumns) {
        super(component, type, colData, usedColumns);
        this.pieChart = new PieChart(this);
    }

    public PieChart3D(int type, Chart chart) {
        super(type, chart);
        this.pieChart = new PieChart(this, chart);
    }

    @Override
    public PieChart getPieChart() {
        return this.pieChart;
    }

    @Override
    public void copyAttributes(IPieChart iPieChart) {
        this.pieChart.copyAttributes(iPieChart.getPieChart());
    }

    @Override
    public void transformPoint(Point3D point) {
        this.space.transform(point);
    }

    @Override
    public void resetHiddenSurface() {
        if (this.hiddenSurface != null) {
            this.hiddenSurface.reset();
        }
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        if (this.notEnoughData()) {
            return;
        }
        if (this.hiddenSurface.treeRoot != null) {
            this.space.resize(xmin, xmax, ymin, ymax);
            this.pieChart.assignCoordinates();
            this.space.recomputeColor();
            return;
        }
        if (this.chartType == 20 && this.pieChart.concentricDoughnut) {
            int pieCount = 0;
            pieCount = this.dataDim == 1 ? 1 : this.mDataLen[1];
            this.pieChart.pieheight = new int[pieCount];
            this.pieChart.piewidth = new int[pieCount];
            this.pieChart.pieThickness = new int[pieCount];
            this.pieChart.pieThickness[0] = 50;
            if (this.pieChart.center == null || pieCount != this.pieChart.center.length) {
                this.pieChart.allocateLabel(pieCount, this.mDataLen[0]);
            }
            int xwidth = xmax - xmin;
            int ywidth = ymax - ymin;
            if (xwidth != 0 && ywidth != 0) {
                int maxChartHeight = xwidth < ywidth ? xwidth : ywidth;
                this.pieChart.pieheight[0] = this.pieChart.piewidth[0] = 2 * maxChartHeight / (2 + pieCount);
                this.pieChart.center[0].x = (xmin + xmax) / 2;
                this.pieChart.center[0].y = (ymin + ymax) / 2;
                for (int i = 1; i < pieCount; ++i) {
                    this.pieChart.center[i].y = this.pieChart.center[0].y;
                    this.pieChart.center[i].x = this.pieChart.center[0].x;
                    this.pieChart.pieheight[i] = this.pieChart.piewidth[i] = this.pieChart.pieheight[i - 1] + this.pieChart.pieheight[0] * this.pieChart.pieThickness[0] / 100;
                    this.pieChart.pieThickness[i] = this.pieChart.pieheight[0] * this.pieChart.pieThickness[0] / this.pieChart.pieheight[i];
                }
                this.pieChart.assignCoordinates();
            }
            this.mData.prepare3DDoughnut(this.space, this.wall_zlength);
            this.adjustInitScale(xwidth, ywidth);
            return;
        }
        int orgW = xmax - xmin;
        int orgH = ymax - ymin;
        double gapRatio = this.pieChart.getGapRatioBetweenPies() * 3.0;
        int oldxmin = xmin;
        int oldxmax = xmax;
        int oldymin = ymin;
        int oldymax = ymax;
        ymin = 0;
        xmin = 0;
        float ratio = (float)(oldxmax - oldxmin) / (float)(oldymax - oldymin);
        ymax = 1000;
        xmax = (int)((float)ymax * ratio);
        this.wall_ylength = ymax;
        this.wall_xlength = xmax;
        this.wall_zlength = (int)(200.0 * this.thickRatio);
        this.createSpace(oldxmin, oldxmax, oldymin, oldymax, ratio);
        int pieCount = 0;
        pieCount = this.dataDim == 1 ? 1 : this.mDataLen[1];
        this.pieChart.pieheight = new int[pieCount];
        this.pieChart.piewidth = new int[pieCount];
        this.pieChart.pieThickness = new int[pieCount];
        this.pieChart.pieThickness[0] = 50;
        if (this.pieChart.center == null || pieCount != this.pieChart.center.length) {
            this.pieChart.allocateLabel(pieCount, this.mDataLen[0]);
        }
        int xwidth = xmax / 2;
        int ywidth = ymax / 2;
        if (pieCount == 1) {
            this.pieChart.piewidth[0] = xwidth < ywidth ? xwidth : ywidth;
            this.pieChart.pieheight[0] = this.pieChart.piewidth[0];
            this.pieChart.center[0].x = xmax / 2;
            this.pieChart.center[0].y = ymax / 2;
        } else {
            int col = 1;
            int row = 1;
            if (this.pieChart.isBestFit()) {
                double d;
                double a;
                double b;
                if (this.pieChart.isExploded()) {
                    gapRatio += this.pieChart.sliceDistance / 2.0;
                }
                if ((col = (int)Math.rint((-(b = gapRatio * (double)(xmax - ymax)) + Math.sqrt(b * b + 4.0 * (a = (double)ymax * (gapRatio + 1.0)) * (d = (double)(pieCount * xmax) * (1.0 + gapRatio)))) / (2.0 * a))) <= 0) {
                    col = 1;
                }
                row = (int)Math.ceil((double)pieCount / (double)col);
            } else if (this.pieChart.isDrawLinearly()) {
                col = pieCount;
                row = 1;
            } else {
                int n = col = this.pieChart.piePerRow > pieCount ? pieCount : this.pieChart.piePerRow;
                if (col <= 0) {
                    col = 1;
                }
                row = (int)Math.ceil((double)pieCount / (double)col);
            }
            for (int i = 0; i < pieCount; ++i) {
                int yOffset;
                int d1 = (int)Math.floor((double)xmax / ((double)col + (double)col * gapRatio - gapRatio));
                int d2 = (int)Math.floor((double)ymax / ((double)row + (double)row * gapRatio - gapRatio));
                this.pieChart.piewidth[i] = d1 < d2 ? d1 : d2;
                this.pieChart.pieheight[i] = this.pieChart.piewidth[i];
                int xOffset = (int)Math.floor(((double)xmax - (double)this.pieChart.pieheight[i] * ((double)col + gapRatio * (double)col - gapRatio)) / 2.0);
                if (xOffset < 0) {
                    xOffset = 0;
                }
                if ((yOffset = (int)Math.floor(((double)ymax - (double)this.pieChart.pieheight[i] * ((double)row + gapRatio * (double)row - gapRatio)) / 2.0)) < 0) {
                    yOffset = 0;
                }
                if (row == 1) {
                    this.pieChart.center[i].y = ymax / 2;
                } else {
                    int cRow = (int)Math.floor((double)i / (double)col);
                    this.pieChart.center[i].y = ymax - (int)Math.rint((double)this.pieChart.pieheight[i] * ((double)cRow * gapRatio + (double)(cRow + 1) / 2.0 + (double)cRow / 2.0)) - yOffset;
                }
                if (col == 1) {
                    this.pieChart.center[i].x = xmax / 2;
                } else {
                    int cCol = i % col;
                    this.pieChart.center[i].x = (int)Math.rint((double)this.pieChart.pieheight[i] * ((double)cCol * gapRatio + (double)(cCol + 1) / 2.0 + (double)cCol / 2.0)) + xOffset;
                }
                this.pieChart.pieThickness[i] = this.pieChart.pieThickness[0];
            }
        }
        this.pieChart.assignCoordinates();
        if (this instanceof DoughnutChart3D) {
            this.mData.prepare3DDoughnut(this.space, this.wall_zlength);
        } else {
            this.mData.prepare3DPie(this.space, this.wall_zlength);
        }
        this.adjustInitScale(orgW, orgH);
    }

    @Override
    public void drawLabel(CGraphics g) {
        if (g.g instanceof IFlashGraphics) {
            ((IFlashGraphics)((Object)g.g)).setTopLabels();
            this.pieChart.drawLabel(g);
            ((IFlashGraphics)((Object)g.g)).resetTopLabels();
        } else {
            this.pieChart.drawLabel(g);
        }
    }

    @Override
    public void draw(CGraphics g) {
        if (g.g instanceof IFlashGraphics) {
            int k = 0;
            boolean isExploded = false;
            double sliceDistance = this.pieChart.getSliceDistance();
            int loopCt = 1;
            if (this.flashFrameCount > 1) {
                isExploded = this.pieChart.isExploded();
                loopCt = 2;
                if (isExploded) {
                    loopCt = 3;
                    if (this.flashFrameCount == 2) {
                        loopCt = 2;
                    }
                    this.pieChart.setSliceDistance(0.0);
                }
            }
            int framePerLoop = this.flashFrameCount / loopCt;
            int lastFramePerLoop = this.flashFrameCount - loopCt * framePerLoop + framePerLoop;
            if (isExploded && this.flashFrameCount == 2) {
                framePerLoop = 1;
                lastFramePerLoop = 1;
            }
            for (int i = 0; i < (isExploded ? loopCt - 1 : loopCt); ++i) {
                if (i == 0) {
                    this.flashIsFirstLoopForPie = true;
                }
                boolean isLastLoop = i + 1 >= (isExploded ? loopCt - 1 : loopCt);
                for (int j = 1; j <= (!isExploded && isLastLoop ? lastFramePerLoop : framePerLoop); ++j) {
                    ((IFlashGraphics)((Object)g.g)).setFrame(k);
                    this.flashRatio = (double)j / (double)framePerLoop;
                    this.hiddenSurface.reset();
                    this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                    this.draw_3D(g, 3);
                    ++k;
                }
                this.flashIsFirstLoopForPie = false;
            }
            if (isExploded) {
                for (int j = 1; j <= lastFramePerLoop; ++j) {
                    ((IFlashGraphics)((Object)g.g)).setFrame(k);
                    this.pieChart.setSliceDistance((double)j / (double)lastFramePerLoop * sliceDistance);
                    this.hiddenSurface.reset();
                    this.computeCoord(g, this.chartxorigin, this.chartxorigin + this.chartwidth, this.chartyorigin, this.chartheight + this.chartyorigin);
                    this.draw_3D(g, 3);
                    ++k;
                }
            }
            ((IFlashGraphics)((Object)g.g)).setFrame(-1);
        } else {
            this.draw_3D(g, 3);
        }
    }

    @Override
    public boolean notEnoughData() {
        return this.nRow <= 0;
    }
}

