/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.types3d.hilow3d;

import java.awt.Color;
import java.awt.Component;
import java.util.Vector;
import java.util.logging.Logger;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.HiLowData;
import quadbase.chart.IHLCOChart;
import quadbase.chart.MultiDimData;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.types3d.hilow3d.HiLowChart3D;

public class HLCOChart3D
extends HiLowChart3D
implements IHLCOChart {
    private static final Logger LOGGER = Logger.getLogger(HLCOChart3D.class.getName());

    public HLCOChart3D(Component component, ColData[] colData) {
        super(component, colData, 10);
    }

    public HLCOChart3D(Chart _chart) {
        super(_chart, 10);
    }

    @Override
    public void draw(CGraphics g) {
        this.draw3D(g, 1);
    }

    @Override
    public void drawSym(CGraphics g, Color c, int x1, int x2, HiLowData hilow, MultiDimData data, boolean candleStick) {
        LOGGER.fine("HLCOChart3D: drawSym");
    }

    @Override
    public void prepareSym(Object sp, Vector vec, Color c, int x1, int x2, int z1, int z2, HiLowData hilow, Object obj, boolean candle) {
        Space space = (Space)sp;
        double w2 = (int)((double)(x2 - x1) * 0.3) / 2;
        double m = (double)(x1 + x2) / 2.0;
        if (candle) {
            int z3 = (z2 - z1) / 3;
            if (hilow.vopen != -1.7976931348623157E308 && hilow.vclose != -1.7976931348623157E308) {
                Color col;
                int close;
                int open;
                HiLowData orgData = ((MultiDimData)obj).orgHilow;
                if (orgData.vopen > orgData.vclose) {
                    open = (int)hilow.vopen + 1;
                    close = (int)hilow.vclose - 1;
                    col = Color.red;
                } else {
                    open = (int)hilow.vclose + 1;
                    close = (int)hilow.vopen - 1;
                    col = Color.green;
                }
                space.addBox(vec, (float)((int)Math.round(m - w2)), (float)((int)hilow.vhi), (float)(z1 + z3), (float)((int)Math.round(m + w2)), (float)open, (float)(z2 - z3), c, true, obj);
                space.addBox(vec, (float)((int)Math.round(m - w2)), (float)close, (float)(z1 + z3), (float)((int)Math.round(m + w2)), (float)((int)hilow.vlow), (float)(z2 - z3), c, true, obj);
                space.addBox(vec, x1, close, z1, x2, open, z2, col, true, obj, true);
            } else {
                space.addBox(vec, (float)((int)Math.round(m - w2)), (float)((int)hilow.vhi), (float)(z1 + z3), (float)((int)Math.round(m + w2)), (float)((int)hilow.vlow), (float)(z2 - z3), c, true, obj);
            }
        } else {
            space.addBox(vec, (float)((int)Math.round(m - w2)), (float)((int)hilow.vhi), (float)z1, (float)((int)Math.round(m + w2)), (float)((int)hilow.vlow), (float)z2, c, true, obj);
            if (hilow.vopen != -1.7976931348623157E308) {
                space.addBox(vec, (float)x1, (float)((int)Math.round(hilow.vopen + w2)), (float)z1, (float)((int)Math.round(m - w2)), (float)((int)Math.round(hilow.vopen - w2)), (float)z2, c, true, obj);
            }
            if (hilow.vclose != -1.7976931348623157E308) {
                space.addBox(vec, (float)((int)Math.round(m + w2)), (float)((int)Math.round(hilow.vclose + w2)), (float)z1, (float)x2, (float)((int)Math.round(hilow.vclose - w2)), (float)z2, c, true, obj);
            }
        }
    }
}

