/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.types3d.hilow3d;

import java.awt.Component;
import java.awt.FontMetrics;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.HiLowData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart2d.types2d.hilow2d.HiLowChart2D;
import quadbase.chart.chart3d.Chart3D;
import quadbase.chart.chart3d.Grid3D;
import quadbase.chart.chart3d.types3d.hilow3d.HLCOChart3D;
import quadbase.common.util.internal.QbUtil;

public class HiLowChart3D
extends Chart3D {
    protected static final double STRIPRATIO = 0.3;

    public HiLowChart3D(Component component, ColData[] colData) {
        this(component, colData, 9);
    }

    public HiLowChart3D(Chart _chart) {
        this(_chart, 9);
    }

    public HiLowChart3D(Component component, ColData[] colData, int ctype) {
        super(component, ctype, colData);
        if (this.nstring == 0) {
            if (this.nint + this.nreal == 0) {
                throw nocategoryError;
            }
            if (this.nint + this.nreal + this.ntime < 2) {
                throw nonumericError;
            }
            int rindex = 0;
            int iindex = 0;
            this.mDataMap[0] = this.nint > 0 ? this.nintcol[iindex++] : this.nrealcol[rindex++];
            this.hilowCol.low = this.nreal > 0 ? this.nrealcol[rindex++] : this.nintcol[iindex++];
            this.hilowCol.hi = this.hilowCol.low;
        } else {
            this.mDataMap[0] = this.nstringcol[0];
            if (this.nint + this.nreal + this.ntime < 1) {
                throw nonumericError;
            }
            this.hilowCol.low = this.nreal > 0 ? this.nrealcol[0] : this.nintcol[0];
            this.hilowCol.hi = this.hilowCol.low;
        }
        this.valueCol = this.hilowCol.hi;
        this.coordCol[0] = this.hilowCol.hi;
        this.coordCol[1] = this.hilowCol.low;
        this.coordCol[2] = 0;
        this.bcoordCol[1] = true;
        this.bcoordCol[0] = true;
        this.bcoordCol[2] = false;
        this.dataDim = 1;
        this.makeTable();
    }

    public HiLowChart3D(Chart _chart, int ctype) {
        super(ctype, _chart);
        if (_chart instanceof HiLowChart2D || _chart instanceof HiLowChart3D) {
            this.hilowCol.copy(_chart.hilowCol);
        } else {
            this.addNewColumnFromDataMapping = true;
            if (this.hilowCol.hi == -1) {
                int n = this.hilowCol.hi = this.bvalueCol ? this.valueCol : _chart.coordCol[0];
            }
            if (this.hilowCol.low == -1) {
                int n = this.hilowCol.low = this.bvalueCol ? this.valueCol : _chart.coordCol[1];
            }
        }
        if (_chart.isStackType() && _chart.dataDim == 2) {
            this.mDataMap[0] = _chart.mDataMap[1];
            this.mDataMap[1] = _chart.mDataMap[0];
            this.dataDim = 2;
        } else {
            this.dataDim = _chart.dataDim >= 2 || this.bmDataMap[1] ? 2 : 1;
        }
        this.checkSpecialColumn(1);
        this.copyTable(_chart);
    }

    private HiLowData interpolateHiLow(StepSize step, HiLowData hilow) {
        double close;
        double hi = step.interpolatePixel(hilow.vhi);
        double low = step.interpolatePixel(hilow.vlow);
        double open = hilow.vopen == -1.7976931348623157E308 ? -1.7976931348623157E308 : (double)step.interpolatePixel(hilow.vopen);
        double d = close = hilow.vclose == -1.7976931348623157E308 ? -1.7976931348623157E308 : (double)step.interpolatePixel(hilow.vclose);
        if (this instanceof HLCOChart3D) {
            double midPt = (hi - low) / 2.0 + low;
            hi = (hi - midPt) * this.flashRatio + midPt;
            low = (low - midPt) * this.flashRatio + midPt;
        } else {
            double midPt = (hi - low) / 2.0 + low;
            if (hilow.vclose != -1.7976931348623157E308) {
                midPt = close;
            }
            hi = (hi - midPt) * this.flashRatio + midPt;
            low = (low - midPt) * this.flashRatio + midPt;
        }
        return new HiLowData(hi, low, open, close);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        Point3D[] coord2;
        HiLowData hilow;
        int t2;
        int t1;
        int i;
        int t4;
        int t3;
        if (this.notEnoughData()) {
            return;
        }
        if (this.hiddenSurface.treeRoot != null) {
            this.space.resize(xmin, xmax, ymin, ymax);
            this.space.recomputeColor();
            return;
        }
        int orgW = xmax - xmin;
        int orgH = ymax - ymin;
        int thick = 2;
        Point3D[] scoord = null;
        int oldxmin = xmin;
        int oldxmax = xmax;
        int oldymin = ymin;
        int oldymax = ymax;
        ymin = 0;
        xmin = 0;
        float ratio = (float)(oldxmax - oldxmin) / (float)(oldymax - oldymin);
        ymax = 1000;
        this.wall_ylength = 1000;
        xmax = (int)((float)ymax * ratio);
        FontMetrics fm = g.getFontMetrics(QbUtil.resizeViewerFont(this.a_y.font, this.mData.chart.isAdjustFont()));
        int fstep = (int)((double)(oldymax - oldymin) / (3.0 * (double)(fm.getMaxAscent() + fm.getMaxDescent())));
        this.findMinMaxVal();
        if (this.subvalueCol >= 0) {
            this.findMinMaxVal2();
        }
        if (this.isJoinAxis()) {
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
        }
        StepSize ystep = new StepSize(this.a_y, ymax, 0, this.maxvalue, this.minvalue, fstep, this.getCoorddec(this.hilowCol.hi));
        StepSize ystep2 = null;
        if (this.subvalueCol >= 0) {
            ystep2 = new StepSize(this.a_s, ymax, ymin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
        }
        this.createSpace(oldxmin, oldxmax, oldymin, oldymax, ratio);
        int noCategory = this.mDataLen[this.dataDim - 1];
        int[] loc = new int[this.dataDim];
        Point3D[] coord = new Point3D[noCategory];
        double delta = (double)xmax / ((double)noCategory * 2.0 + 1.0);
        if (this.dataDim == 1) {
            double lastx = delta;
            int lastz = (int)delta;
            int nextz = (int)(delta * (double)(1 + thick));
            this.wall_xlength = xmax;
            this.wall_zlength = (int)((double)nextz + delta);
            t3 = (lastz + nextz) / 2;
            t4 = (int)((double)(nextz - lastz) / (2.0 * this.thickRatio));
            for (i = 0; i < noCategory; ++i) {
                double nextx = lastx + delta;
                loc[0] = i;
                t1 = (int)((lastx + nextx) / 2.0);
                t2 = (int)((nextx - lastx) * this.thickRatio / 2.0);
                hilow = (HiLowData)this.mData.getElement(loc);
                if (hilow != null) {
                    this.mData.setAreaCoord(t1 - t2, t1 + t2, this.interpolateHiLow(ystep, hilow), hilow, t3 - t4, t3 + t4, loc);
                }
                if (ystep2 != null) {
                    if (this.comboType == 2) {
                        this.mData2.setAreaCoord(t1 - t2, t1 + t2, ystep2.zeroAxis, ystep2.interpolatePixel(this.mData2.getValue(loc)), t3 - t4, t3 + t4, loc);
                    } else {
                        this.mData2.setPointCoord(t1, ystep2.interpolatePixel(this.mData2.getValue(loc)), t3, loc);
                    }
                }
                coord[i] = new Point3D((int)((lastx + nextx) / 2.0), 0, this.wall_zlength);
                lastx = nextx + delta;
            }
        } else {
            int noSeries = this.mDataLen[0];
            scoord = new Point3D[noSeries];
            double temp = noSeries * (thick + 1) + 1;
            this.wall_zlength = (int)(delta * temp);
            if (this.wall_zlength < xmax) {
                this.wall_xlength = xmax;
            } else {
                delta = (double)xmax / temp;
                this.wall_zlength = xmax;
                this.wall_xlength = (int)(delta * (double)(2 * noCategory + 1));
            }
            double lastx = delta;
            double stepz = delta * (double)thick;
            for (i = 0; i < noCategory; ++i) {
                loc[1] = i;
                double lastz = delta;
                double nextx = lastx + delta;
                t1 = (int)((lastx + nextx) / 2.0);
                t2 = (int)((nextx - lastx) * this.thickRatio / 2.0);
                for (int j = 0; j < noSeries; ++j) {
                    loc[0] = j;
                    double nextz = lastz + stepz;
                    t3 = (int)((lastz + nextz) / 2.0);
                    t4 = (int)((nextz - lastz) / (2.0 * this.thickRatio));
                    hilow = (HiLowData)this.mData.getElement(loc);
                    if (hilow != null) {
                        this.mData.setAreaCoord(t1 - t2, t1 + t2, this.interpolateHiLow(ystep, hilow), hilow, t3 - t4, t3 + t4, loc);
                    }
                    if (ystep2 != null) {
                        if (this.comboType == 2) {
                            this.mData2.setAreaCoord(t1 - t2, t1 + t2, ystep2.zeroAxis, ystep2.interpolatePixel(this.mData2.getValue(loc)), t3 - t4, t3 + t4, loc);
                        } else {
                            this.mData2.setPointCoord(t1, ystep2.interpolatePixel(this.mData2.getValue(loc)), t3, loc);
                        }
                    }
                    if (i == 0) {
                        scoord[j] = new Point3D(this.wall_xlength, 0, (int)((lastz + nextz) / 2.0));
                    }
                    lastz = nextz + delta;
                }
                coord[i] = new Point3D((int)((lastx + nextx) / 2.0), 0, this.wall_zlength);
                lastx = nextx + delta;
            }
        }
        this.setAutomatic(ystep2 != null);
        this.a_y.setAxisGridY(this.space, ystep, this.wall_xlength, ymax, this.wall_zlength, this.colData[this.hilowCol.hi]);
        this.a_y.setYWall(this.space, this.wall_xlength, ymax, this.wall_zlength, this.wallbackground.areaColor);
        if (this.subvalueCol >= 0) {
            this.a_s.setAxisGridY(this.space, ystep2, this.wall_xlength, ymax, this.wall_zlength, this.colData[this.subvalueCol], this.wall_xlength, 0);
            this.a_s.setSWall(this.space, this.wall_xlength, ymax, this.wall_zlength, this.wallbackground.areaColor);
        }
        this.a_z.setZWall(this.space, this.wall_xlength, ymax, this.wall_zlength, this.wallbackground.areaColor);
        this.a_x.setXWall(this.space, this.wall_xlength, ymax, this.wall_zlength, this.wallbackground.areaColor);
        int colfield = this.mDataMap[this.dataDim - 1];
        this.a_x.setTicker(this.space, this.colData[colfield].getFieldName(), coord, false, this.colData[colfield]);
        if (this.isGridAlignedWithTicker()) {
            coord2 = new Point3D[noCategory];
            for (i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(coord[i].x, 0, 0);
            }
            this.a_x.grid.set(this.space, coord2, ymax, this.wall_zlength);
        } else {
            coord2 = new Point3D[noCategory - 1];
            for (i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D((coord[i].x + coord[i + 1].x) / 2, 0, 0);
            }
            this.a_x.grid.set(this.space, coord2, ymax, this.wall_zlength);
        }
        if (this.dataDim == 2) {
            this.a_z.setTicker(this.space, this.colData[this.mDataMap[0]].getFieldName(), scoord, true, this.colData[this.mDataMap[0]]);
            this.a_z.showTitleTicker = true;
            Point3D[] coord3 = new Point3D[scoord.length - 1];
            for (i = 0; i < coord3.length; ++i) {
                coord3[i] = new Point3D(0, 0, (scoord[i].z + scoord[i + 1].z) / 2);
            }
            this.a_z.grid.set(this.space, coord3, this.wall_xlength, this.wall_ylength);
        } else {
            this.a_z.setTicker(this.space, this.wall_xlength, this.wall_zlength);
            this.a_z.showTitleTicker = false;
            ((Grid3D)this.a_z.grid).lineList = null;
        }
        this.mData.prepare3DBox(this.space);
        if (this.subvalueCol >= 0) {
            this.mData2.prepare3DLine(this.space, delta * this.thickRatio, 30.0 * this.thickRatio);
        }
        if (this.subvalueCol >= 0) {
            if (this.comboType == 2) {
                this.mData2.prepare3DBox(this.space);
            } else {
                this.mData2.prepare3DLine(this.space, delta * this.thickRatio, 30.0 * this.thickRatio);
            }
        }
        this.prepareLabel();
        this.adjustInitScale(orgW, orgH);
    }

    @Override
    public void draw(CGraphics g) {
        this.draw3D(g, 1);
    }
}

