/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.chart3d.types3d.stack3d;

import java.awt.Component;
import quadbase.chart.CGraphics;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.Point3D;
import quadbase.chart.StepSize;
import quadbase.chart.chart3d.Grid3D;
import quadbase.chart.chart3d.types3d.stack3d.StackChart3D;
import quadbase.common.util.internal.QbUtil;

public class StackBarChart3D
extends StackChart3D {
    public StackBarChart3D(Component component, ColData[] colData, boolean[] usedColumns) {
        super(component, 5, colData, usedColumns);
    }

    public StackBarChart3D(Chart _chart) {
        super(5, _chart);
    }

    @Override
    public void computeCoord(CGraphics g, int xmin, int xmax, int ymin, int ymax) {
        Point3D[] coord2;
        double nexty;
        double lasty;
        int noSeries;
        int currentx;
        double t;
        int j;
        int t2;
        int t1;
        int lastx1;
        int lastx2;
        double sum1;
        double sum2;
        int i;
        int t4;
        int t3;
        if (this.notEnoughData()) {
            return;
        }
        if (this.hiddenSurface.treeRoot != null) {
            this.space.resize(xmin, xmax, ymin, ymax);
            this.space.recomputeColor();
            return;
        }
        int orgW = xmax - xmin;
        int orgH = ymax - ymin;
        int thick = 2;
        Point3D[] scoord = null;
        int oldxmin = xmin;
        int oldxmax = xmax;
        int oldymin = ymin;
        int oldymax = ymax;
        ymin = 0;
        xmin = 0;
        float ratio = (float)(oldxmax - oldxmin) / (float)(oldymax - oldymin);
        ymax = 1000;
        this.wall_xlength = xmax = (int)((float)ymax * ratio);
        int fstep = (int)((double)(oldxmax - oldxmin) / (7.0 * (double)g.getFontMetrics(QbUtil.resizeViewerFont(this.a_x.font, this.mData.chart.isAdjustFont())).charWidth('8')));
        this.findMinMaxSum();
        if (this.subvalueCol >= 0) {
            this.findMinMaxVal2();
        }
        if (this.isJoinAxis()) {
            if (this.maxvalue > this.maxvalue2) {
                this.maxvalue2 = this.maxvalue;
            } else {
                this.maxvalue = this.maxvalue2;
            }
            if (this.minvalue < this.minvalue2) {
                this.minvalue2 = this.minvalue;
            } else {
                this.minvalue = this.minvalue2;
            }
        }
        StepSize xstep = new StepSize(this.a_x, xmax, xmin, this.maxvalue, this.minvalue, fstep, this.getVdec());
        xstep.zeroAxis = xstep.interpolatePixel(0.0);
        StepSize xstep2 = null;
        if (this.subvalueCol >= 0) {
            xstep2 = new StepSize(this.a_s, xmax, xmin, this.maxvalue2, this.minvalue2, fstep, this.getSubVdec());
        }
        this.createSpace(oldxmin, oldxmax, oldymin, oldymax, ratio);
        int noCategory = this.mDataLen[this.dataDim - 2];
        int[] loc = new int[this.dataDim];
        Point3D[] coord = new Point3D[noCategory];
        double delta = (double)ymax / ((double)noCategory * 2.0 + 1.0);
        if (this.a_x.getMaxScale() < 0.0) {
            this.a_x.setMaxScale(0.0);
        }
        if (this.a_x.getMinScale() > 0.0) {
            this.a_x.setMinScale(0.0);
        }
        if (this.dataDim == 2) {
            int lastz = (int)delta;
            int nextz = (int)(delta * (double)(1 + thick));
            double lasty2 = delta;
            this.wall_ylength = ymax;
            this.wall_zlength = (int)((double)nextz + delta);
            t3 = (lastz + nextz) / 2;
            t4 = (int)((double)(nextz - lastz) / (2.0 * this.thickRatio));
            for (i = 0; i < noCategory; ++i) {
                loc[0] = i;
                sum2 = 0.0;
                sum1 = 0.0;
                lastx1 = lastx2 = xstep.zeroAxis;
                double nexty2 = lasty2 + delta;
                t1 = (int)((lasty2 + nexty2) / 2.0);
                t2 = (int)((nexty2 - lasty2) * this.thickRatio / 2.0);
                for (j = 0; j < this.mDataLen[1]; ++j) {
                    double d;
                    loc[1] = j;
                    t = this.mData.getValue(loc) * this.flashRatio;
                    if (d >= 0.0) {
                        sum1 += t;
                        if (this.isDataLimitAtAxisScale() && sum1 > this.a_x.maxScale) {
                            sum1 = this.a_x.maxScale;
                        }
                        currentx = xstep.interpolatePixel(sum1);
                        this.mData.setAreaCoord(currentx, lastx1, t1 + t2, t1 - t2, t3 + t4, t3 - t4, loc);
                        lastx1 = currentx;
                    } else {
                        sum2 += t;
                        if (this.isDataLimitAtAxisScale() && sum2 < this.a_x.maxScale) {
                            sum2 = this.a_x.minScale;
                        }
                        currentx = xstep.interpolatePixel(sum2);
                        this.mData.setAreaCoord(currentx, lastx2, t1 + t2, t1 - t2, t3 + t4, t3 - t4, loc);
                        lastx2 = currentx;
                    }
                    if (xstep2 == null) continue;
                    double value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                    this.mData2.setPointCoord(xstep2.interpolatePixel(value), t1, t3, loc);
                }
                coord[i] = new Point3D(0, t1, this.wall_zlength);
                lasty2 = nexty2 + delta;
            }
        } else if (this.isDrawSeriesOnCategoryAxis()) {
            noSeries = this.mDataLen[0];
            delta = (double)ymax / ((double)noCategory * (double)(noSeries + 1) + 1.0);
            int lastz = (int)delta;
            int nextz = (int)(delta * (double)(1 + thick));
            lasty = delta;
            this.wall_ylength = ymax;
            this.wall_zlength = (int)((double)nextz + delta);
            t3 = (lastz + nextz) / 2;
            t4 = (int)((double)(nextz - lastz) / (2.0 * this.thickRatio));
            int k = 0;
            for (i = 0; i < noCategory; ++i) {
                loc[1] = i;
                int tmpT1 = (int)((lasty + lasty + delta * (double)noSeries) / 2.0);
                for (j = 0; j < noSeries; ++j) {
                    loc[0] = j;
                    sum2 = 0.0;
                    sum1 = 0.0;
                    lastx1 = lastx2 = xstep.zeroAxis;
                    nexty = lasty + delta;
                    t1 = (int)((lasty + nexty) / 2.0);
                    t2 = (int)((nexty - lasty) * this.thickRatio / 2.0);
                    for (k = 0; k < this.mDataLen[2]; ++k) {
                        double d;
                        loc[2] = k;
                        t = this.mData.getValue(loc) * this.flashRatio;
                        if (d >= 0.0) {
                            sum1 += t;
                            if (this.isDataLimitAtAxisScale() && sum1 > this.a_x.maxScale) {
                                sum1 = this.a_x.maxScale;
                            }
                            currentx = xstep.interpolatePixel(sum1);
                            this.mData.setAreaCoord(currentx, lastx1, t1 + t2, t1 - t2, t3 + t4, t3 - t4, loc);
                            lastx1 = currentx;
                        } else {
                            sum2 += t;
                            if (this.isDataLimitAtAxisScale() && sum2 < this.a_x.maxScale) {
                                sum2 = this.a_x.minScale;
                            }
                            currentx = xstep.interpolatePixel(sum2);
                            this.mData.setAreaCoord(currentx, lastx2, t1 + t2, t1 - t2, t3 + t4, t3 - t4, loc);
                            lastx2 = currentx;
                        }
                        if (xstep2 == null) continue;
                        double value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                        this.mData2.setPointCoord(xstep2.interpolatePixel(value), t1, t3, loc);
                    }
                    lasty = nexty;
                }
                coord[i] = new Point3D(0, tmpT1, this.wall_zlength);
                lasty += delta;
            }
        } else {
            noSeries = this.mDataLen[0];
            scoord = new Point3D[noSeries];
            double temp = noSeries * (thick + 1) + 1;
            this.wall_zlength = (int)(delta * temp);
            if (this.wall_zlength < ymax) {
                this.wall_ylength = ymax;
            } else {
                delta = (double)ymax / temp;
                this.wall_zlength = ymax;
                this.wall_ylength = (int)(delta * (double)(2 * noCategory + 1));
            }
            lasty = (double)ymin + delta;
            double stepz = delta * (double)thick;
            for (i = 0; i < noCategory; ++i) {
                loc[1] = i;
                double lastz = delta;
                nexty = lasty + delta;
                t1 = (int)((lasty + nexty) / 2.0);
                t2 = (int)((nexty - lasty) * this.thickRatio / 2.0);
                for (j = 0; j < noSeries; ++j) {
                    loc[0] = j;
                    double nextz = lastz + stepz;
                    lastx1 = lastx2 = xstep.zeroAxis;
                    sum2 = 0.0;
                    sum1 = 0.0;
                    t3 = (int)((lastz + nextz) / 2.0);
                    t4 = (int)((nextz - lastz) / (2.0 * this.thickRatio));
                    for (int k = 0; k < this.mDataLen[2]; ++k) {
                        double d;
                        loc[2] = k;
                        t = this.mData.getValue(loc) * this.flashRatio;
                        if (d >= 0.0) {
                            sum1 += t;
                            if (this.isDataLimitAtAxisScale() && sum1 > this.a_x.maxScale) {
                                sum1 = this.a_x.maxScale;
                            }
                            currentx = xstep.interpolatePixel(sum1);
                            this.mData.setAreaCoord(currentx, lastx1, t1 + t2, t1 - t2, t3 + t4, t3 - t4, loc);
                            lastx1 = currentx;
                        } else {
                            sum2 += t;
                            if (this.isDataLimitAtAxisScale() && sum2 < this.a_x.maxScale) {
                                sum2 = this.a_x.minScale;
                            }
                            currentx = xstep.interpolatePixel(sum2);
                            this.mData.setAreaCoord(currentx, lastx2, t1 + t2, t1 - t2, t3 + t4, t3 - t4, loc);
                            lastx2 = currentx;
                        }
                        if (xstep2 == null) continue;
                        double value = this.isDataLimitAtAxisScale() ? this.mData2.getValue(loc, this.a_s) * this.flashRatio : this.mData2.getValue(loc) * this.flashRatio;
                        this.mData2.setPointCoord(xstep2.interpolatePixel(value), t1, t3, loc);
                    }
                    if (i == 0) {
                        scoord[j] = new Point3D(xmax, 0, (int)((lastz + nextz) / 2.0));
                    }
                    lastz = nextz + delta;
                }
                coord[i] = new Point3D(0, t1, this.wall_zlength);
                lasty = nexty + delta;
            }
        }
        this.a_x.setAxisGridX(this.space, xstep, xmax, this.wall_ylength, this.wall_zlength, this.colData[this.valueCol]);
        this.a_x.setXWall(this.space, xmax, this.wall_ylength, this.wall_zlength, this.wallbackground.areaColor);
        if (this.subvalueCol >= 0) {
            this.a_s.setAxisGridX(this.space, xstep2, xmax, this.wall_ylength, this.wall_zlength, this.colData[this.subvalueCol], this.wall_ylength, 0);
            this.a_s.setSWall(this.space, xmax, this.wall_ylength, this.wall_zlength, this.wallbackground.areaColor);
        }
        this.a_z.setZWall(this.space, xmax, this.wall_ylength, this.wall_zlength, this.wallbackground.areaColor);
        int colfield = this.mDataMap[this.dataDim - 2];
        this.a_y.setTicker(this.space, this.colData[colfield].getFieldName(), coord, false, this.colData[colfield]);
        this.a_y.setYWall(this.space, xmax, this.wall_ylength, this.wall_zlength, this.wallbackground.areaColor);
        if (this.isGridAlignedWithTicker()) {
            coord2 = new Point3D[noCategory];
            for (i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(xmin, coord[i].y, 0);
            }
            this.a_y.grid.set(this.space, coord2, xmax, this.wall_zlength);
        } else {
            coord2 = new Point3D[noCategory - 1];
            for (i = 0; i < coord2.length; ++i) {
                coord2[i] = new Point3D(xmin, (coord[i].y + coord[i + 1].y) / 2, 0);
            }
            this.a_y.grid.set(this.space, coord2, xmax, this.wall_zlength);
        }
        if (this.dataDim == 3 && !this.isDrawSeriesOnCategoryAxis()) {
            this.a_z.setTicker(this.space, this.colData[this.mDataMap[0]].getFieldName(), scoord, true, this.colData[this.mDataMap[0]]);
            this.a_z.showTitleTicker = true;
            Point3D[] coord3 = new Point3D[scoord.length - 1];
            for (i = 0; i < coord3.length; ++i) {
                coord3[i] = new Point3D(0, 0, (scoord[i].z + scoord[i + 1].z) / 2);
            }
            this.a_z.grid.set(this.space, coord3, xmax, this.wall_ylength);
        } else {
            this.a_z.setTicker(this.space, xmax, this.wall_zlength);
            this.a_z.showTitleTicker = false;
            ((Grid3D)this.a_z.grid).lineList = null;
        }
        this.syncColor();
        this.mData.prepare3DBox(this.space);
        if (this.subvalueCol >= 0) {
            this.prepare3DLine(this.space, this.mData2, (int)(delta * this.thickRatio), (int)(30.0 * this.thickRatio), true);
        }
        if (this.cgraphics == null) {
            this.cgraphics = g;
        }
        this.prepareLabel();
        this.adjustInitScale(orgW, orgH);
    }

    @Override
    public void draw(CGraphics g) {
        this.draw3D(g, 1);
    }
}

