/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.JPanel;
import quadbase.chart.Chart;
import quadbase.chart.PreprocInfo;
import quadbase.chart.designer.AggregateOptions;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ZoomDialog;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.internal.DateTime;

public class AggregateDialog
extends QbDialog {
    AggregateOptions aggregateOpts = null;
    ChartMain chartMain = null;
    boolean secondaryAxisExists = false;
    boolean changeTSValue = false;
    int categoryType;
    boolean cancelDialog = false;
    private boolean isForDrillDown = false;

    public AggregateDialog(ChartMain chartMain, boolean isSecondaryAxis, int categoryType, boolean changeTSChart) {
        this(chartMain, isSecondaryAxis, categoryType, changeTSChart, true, false);
    }

    public AggregateDialog(ChartMain chartMain, boolean isSecondaryAxis, int categoryType, boolean changeTSChart, boolean showCancel, boolean isForDrillDown) {
        super(chartMain, LanguageEncoder.getText("Aggregate Options..."), true);
        this.chartMain = chartMain;
        this.secondaryAxisExists = isSecondaryAxis;
        this.categoryType = categoryType;
        this.isForDrillDown = isForDrillDown;
        this.changeTSValue = changeTSChart;
        this.aggregateOpts = new AggregateOptions(LanguageEncoder.getText("Enter aggregation options"), isSecondaryAxis, categoryType, showCancel, isForDrillDown, chartMain.chart.isHiLow());
        this.aggregateOpts.extractPreprocInfo(chartMain.chart);
        this.aggregateOpts.addActionListener(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", this.aggregateOpts);
        this.setBackground(Color.lightGray);
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    public AggregateOptions getAggregateOptions() {
        return this.aggregateOpts;
    }

    private String getScaleValue(int option) {
        return this.aggregateOpts.getScaleValue(option);
    }

    private int getScaleUnit(int option) {
        return this.aggregateOpts.getScaleUnit(option);
    }

    private int getAggregateFunction(int option) {
        return this.aggregateOpts.getAggregateFunction(option);
    }

    private boolean checkIntervals() {
        long maxVal;
        int lUnit = this.getScaleUnit(0);
        int uUnit = this.getScaleUnit(1);
        int lInterval = Integer.parseInt(this.getScaleValue(0));
        int uInterval = Integer.parseInt(this.getScaleValue(1));
        long minVal = DateTime.getTotalSeconds(lInterval, lUnit);
        if (minVal > (maxVal = DateTime.getTotalSeconds(uInterval, uUnit))) {
            return false;
        }
        return minVal > 0L;
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        super.windowClosing(e);
        this.cancelDialog = true;
    }

    public boolean isCancelled() {
        return this.cancelDialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        Chart chart = this.chartMain.chart;
        ZoomDialog zoomDialog = null;
        if (target == this.aggregateOpts.cancelButton) {
            this.setVisible(false);
            this.cancelDialog = true;
            if (this.changeTSValue) {
                chart.setTimeChart(false);
                chart.clearPreprocInfo();
            }
            return;
        }
        if (target == this.aggregateOpts.okButton) {
            if (!this.isForDrillDown && !this.checkIntervals()) {
                MessageDialog.showError(this.chartMain, true, LanguageEncoder.getText("The minimum scale increment value should be less than the maximumn scale increment value and not equals 0."));
                return;
            }
            this.setVisible(false);
            PreprocInfo tsInfo = chart.getPreprocInfo();
            tsInfo.aggrOp[0] = this.getAggregateFunction(0);
            tsInfo.aggrColIndex[0] = chart.getPrimaryIndex() + 1;
            if (chart.getChartType() == 9) {
                tsInfo.aggrOp[0] = this.getAggregateFunction(0);
                tsInfo.aggrColIndex[0] = chart.hilowCol.hi + 1;
                tsInfo.aggrOp[2] = this.getAggregateFunction(2);
                tsInfo.aggrColIndex[2] = chart.hilowCol.low + 1;
            } else if (chart.getChartType() == 10) {
                tsInfo.aggrOp[0] = this.getAggregateFunction(0);
                tsInfo.aggrColIndex[0] = chart.hilowCol.hi + 1;
                tsInfo.aggrOp[2] = this.getAggregateFunction(2);
                tsInfo.aggrColIndex[2] = chart.hilowCol.low + 1;
                tsInfo.aggrOp[3] = this.getAggregateFunction(3);
                tsInfo.aggrColIndex[3] = chart.hilowCol.open + 1;
                tsInfo.aggrOp[4] = this.getAggregateFunction(4);
                tsInfo.aggrColIndex[4] = chart.hilowCol.close + 1;
            }
            if (this.secondaryAxisExists) {
                tsInfo.aggrOp[1] = this.getAggregateFunction(1);
                tsInfo.aggrColIndex[1] = chart.getSecondaryIndex() + 1;
            } else {
                tsInfo.aggrOp[1] = -1;
            }
            this.chartMain.chartPanel.chart.fillAggregators(tsInfo.aggrOp[0], tsInfo.aggrOp[1]);
            if (chart.getSeriesIndex() >= 0) {
                tsInfo.groupColIndex[0] = chart.getSeriesIndex() + 1;
            }
            if (chart.getSumByIndex() >= 0) {
                tsInfo.groupColIndex[1] = chart.getSumByIndex() + 1;
            }
            tsInfo.selectColIndex = chart.getCategoryIndex() + 1;
            tsInfo.lUnit = this.getScaleUnit(0);
            tsInfo.uUnit = this.getScaleUnit(1);
            tsInfo.lInterval = Integer.parseInt(this.getScaleValue(0));
            tsInfo.uInterval = Integer.parseInt(this.getScaleValue(1));
            if (this.changeTSValue) {
                zoomDialog = new ZoomDialog(this.chartMain, this.categoryType, this.changeTSValue);
                zoomDialog.setVisible(true);
            }
        }
    }
}

