/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.PreprocInfo;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.PanelAction;
import quadbase.common.util.internal.LanguageEncoder;

public class AggregateOptions
extends PanelAction {
    private static final Logger LOGGER = Logger.getLogger(AggregateOptions.class.getName());
    public static final int MIN_AGGREGATE = 0;
    public static final int MAX_AGGREGATE = 1;
    public static final int AVG_AGGREGATE = 2;
    public static final int SUM_AGGREGATE = 3;
    public static final int COUNT_AGGREGATE = 4;
    public static final int FIRST_AGGREGATE = 5;
    public static final int LAST_AGGREGATE = 6;
    public static final int SUMSQUARE_AGGREGATE = 7;
    public static final int VARIANCE_AGGREGATE = 8;
    public static final int STDDEV_AGGREGATE = 9;
    public static final int COUNTDISTINCT_AGGREGATE = 10;
    JComboBox unitChoiceMin = null;
    JComboBox unitChoiceMax = null;
    JComboBox primaryAggregateChoice = null;
    JComboBox secondaryAggregateChoice = null;
    JButton okButton = null;
    JButton cancelButton = null;
    JPanel optionsPanel = null;
    JPanel buttonPanel = null;
    boolean secondaryAxisExists = false;
    boolean isHiLowChart = false;
    boolean showCancelButton = true;
    boolean isForDrillDown = false;
    JTextField minScaleIncrement = null;
    JTextField maxScaleIncrement = null;

    public AggregateOptions(String message, boolean isSecondaryAxis, int Type2) {
        this(message, isSecondaryAxis, Type2, true, false, false);
    }

    public AggregateOptions(String message, boolean isSecondaryAxis, int type, boolean showCancel, boolean isForDrillDown, boolean isHiLowChart) {
        this.secondaryAxisExists = isSecondaryAxis;
        this.optionsPanel = new JPanel();
        this.buttonPanel = new JPanel();
        this.showCancelButton = showCancel;
        this.isForDrillDown = isForDrillDown;
        this.isHiLowChart = isHiLowChart;
        this.initializeDialog(type);
        BorderPanel centerPanel = new BorderPanel(message);
        centerPanel.setLayout(new BorderLayout());
        this.buttonPanel.setLayout(new FlowLayout(2));
        centerPanel.add("Center", this.optionsPanel);
        this.setLayout(new BorderLayout());
        this.add("Center", centerPanel);
        this.add("South", this.buttonPanel);
    }

    private void initializeDialog(int type) {
        this.setBackground(Color.lightGray);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.okButton);
        if (this.showCancelButton) {
            this.buttonPanel.add(this.cancelButton);
        }
        this.unitChoiceMin = this.fillUnitChoice(this.unitChoiceMin, type);
        this.unitChoiceMax = this.fillUnitChoice(this.unitChoiceMax, type);
        this.primaryAggregateChoice = new JComboBox();
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("minimum"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("maximum"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("average"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("sum"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("count"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("first"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("last"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("sumsquare"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("variance"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("stddev"));
        this.primaryAggregateChoice.addItem(LanguageEncoder.getText("countdistinct"));
        this.primaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("sum"));
        if (this.secondaryAxisExists) {
            this.secondaryAggregateChoice = new JComboBox();
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("minimum"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("maximum"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("average"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("sum"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("count"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("first"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("last"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("sumsquare"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("variance"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("stddev"));
            this.secondaryAggregateChoice.addItem(LanguageEncoder.getText("countdistinct"));
            this.secondaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("sum"));
        }
        if (!this.isForDrillDown) {
            this.optionsPanel.setLayout(new GridLayout(0, 2, 5, 5));
        } else {
            this.optionsPanel.setLayout(new GridLayout(0, 2, 0, 0));
        }
        this.minScaleIncrement = new JTextField("1", 4);
        this.maxScaleIncrement = new JTextField("1", 4);
        if (!this.isHiLowChart) {
            this.optionsPanel.add(new JLabel(LanguageEncoder.getText("Primary Aggregate:")));
            JPanel tmpPanel = new JPanel(new FlowLayout(1));
            tmpPanel.add(this.primaryAggregateChoice);
            this.optionsPanel.add(tmpPanel);
        }
        if (this.secondaryAxisExists) {
            this.optionsPanel.add(new JLabel(LanguageEncoder.getText("Secondary Aggregate:")));
            JPanel tmpPanel2 = new JPanel(new FlowLayout(1));
            tmpPanel2.add(this.secondaryAggregateChoice);
            this.optionsPanel.add(tmpPanel2);
        }
        JPanel scalePanel1 = new JPanel();
        scalePanel1.setLayout(new FlowLayout(0));
        if (!this.isForDrillDown) {
            this.optionsPanel.add(new JLabel(LanguageEncoder.getText("Min. Scale Increment:")));
        }
        scalePanel1.add(this.minScaleIncrement);
        scalePanel1.add(this.unitChoiceMin);
        if (!this.isForDrillDown) {
            this.optionsPanel.add(scalePanel1);
        }
        JPanel scalePanel2 = new JPanel();
        scalePanel2.setLayout(new FlowLayout(0));
        if (!this.isForDrillDown) {
            this.optionsPanel.add(new JLabel(LanguageEncoder.getText("Max. Scale Increment:")));
        }
        scalePanel2.add(this.maxScaleIncrement);
        scalePanel2.add(this.unitChoiceMax);
        if (!this.isForDrillDown) {
            this.optionsPanel.add(scalePanel2);
        }
    }

    private JComboBox fillUnitChoice(JComboBox choiceBox, int type) {
        choiceBox = new JComboBox<String>();
        switch (type) {
            case 93: {
                choiceBox.addItem(LanguageEncoder.getText("years"));
                choiceBox.addItem(LanguageEncoder.getText("months"));
                choiceBox.addItem(LanguageEncoder.getText("weeks"));
                choiceBox.addItem(LanguageEncoder.getText("days"));
                choiceBox.addItem(LanguageEncoder.getText("hours"));
                choiceBox.addItem(LanguageEncoder.getText("minutes"));
                choiceBox.addItem(LanguageEncoder.getText("seconds"));
                choiceBox.setSelectedItem(LanguageEncoder.getText("seconds"));
                break;
            }
            case 91: {
                choiceBox.addItem(LanguageEncoder.getText("years"));
                choiceBox.addItem(LanguageEncoder.getText("months"));
                choiceBox.addItem(LanguageEncoder.getText("weeks"));
                choiceBox.addItem(LanguageEncoder.getText("days"));
                choiceBox.setSelectedItem(LanguageEncoder.getText("days"));
                break;
            }
            case 92: {
                choiceBox.addItem(LanguageEncoder.getText("hours"));
                choiceBox.addItem(LanguageEncoder.getText("minutes"));
                choiceBox.addItem(LanguageEncoder.getText("seconds"));
                choiceBox.setSelectedItem(LanguageEncoder.getText("seconds"));
                break;
            }
            default: {
                choiceBox.addItem(LanguageEncoder.getText("units"));
            }
        }
        return choiceBox;
    }

    public int getScaleUnit(int option) {
        String unitValue = null;
        unitValue = option == 0 ? this.unitChoiceMin.getSelectedItem().toString() : this.unitChoiceMax.getSelectedItem().toString();
        if (unitValue.equalsIgnoreCase(LanguageEncoder.getText("years"))) {
            return 6;
        }
        if (unitValue.equalsIgnoreCase(LanguageEncoder.getText("months"))) {
            return 5;
        }
        if (unitValue.equalsIgnoreCase(LanguageEncoder.getText("weeks"))) {
            return 4;
        }
        if (unitValue.equalsIgnoreCase(LanguageEncoder.getText("days"))) {
            return 3;
        }
        if (unitValue.equalsIgnoreCase(LanguageEncoder.getText("hours"))) {
            return 2;
        }
        if (unitValue.equalsIgnoreCase(LanguageEncoder.getText("minutes"))) {
            return 1;
        }
        if (unitValue.equalsIgnoreCase(LanguageEncoder.getText("seconds"))) {
            return 0;
        }
        return 7;
    }

    public void setScaleUnit(int option, int unit) {
        JComboBox minMaxChoice = option == 0 ? this.unitChoiceMin : this.unitChoiceMax;
        switch (unit) {
            case 6: {
                minMaxChoice.setSelectedItem(LanguageEncoder.getText("years"));
                break;
            }
            case 5: {
                minMaxChoice.setSelectedItem(LanguageEncoder.getText("months"));
                break;
            }
            case 4: {
                minMaxChoice.setSelectedItem(LanguageEncoder.getText("weeks"));
                break;
            }
            case 3: {
                minMaxChoice.setSelectedItem(LanguageEncoder.getText("days"));
                break;
            }
            case 2: {
                minMaxChoice.setSelectedItem(LanguageEncoder.getText("hours"));
                break;
            }
            case 1: {
                minMaxChoice.setSelectedItem(LanguageEncoder.getText("minutes"));
                break;
            }
            case 0: {
                minMaxChoice.setSelectedItem(LanguageEncoder.getText("seconds"));
            }
        }
    }

    public void extractPreprocInfo(Chart chart) {
        PreprocInfo tsInfo = chart.getPreprocInfo();
        if (tsInfo == null) {
            LOGGER.warning("AggregateOptions.extractPreprocInfo: Null");
            return;
        }
        if (!chart.isHiLow() && tsInfo.aggrOp[0] != -1) {
            this.setAggregateFunction(0, tsInfo.aggrOp[0]);
        }
        if (tsInfo.aggrOp[1] != -1 && this.secondaryAxisExists) {
            this.setAggregateFunction(1, tsInfo.aggrOp[1]);
        }
        if (tsInfo.lInterval != 0) {
            this.minScaleIncrement.setText(Integer.toString(tsInfo.lInterval));
        }
        if (tsInfo.uInterval != 0) {
            this.maxScaleIncrement.setText(Integer.toString(tsInfo.uInterval));
        }
        this.setScaleUnit(0, tsInfo.lUnit);
        this.setScaleUnit(1, tsInfo.uUnit);
    }

    public String getScaleValue(int option) {
        if (option == 0) {
            return this.minScaleIncrement.getText();
        }
        return this.maxScaleIncrement.getText();
    }

    public int getAggregateFunction(int option) {
        String aggFunction = null;
        if (this.isHiLowChart) {
            if (option == 0) {
                return 1;
            }
            if (option == 2) {
                return 2;
            }
            if (option == 3) {
                return 5;
            }
            if (option == 4) {
                return 6;
            }
        }
        if ((aggFunction = option == 0 ? this.primaryAggregateChoice.getSelectedItem().toString() : this.secondaryAggregateChoice.getSelectedItem().toString()).equalsIgnoreCase(LanguageEncoder.getText("minimum"))) {
            return 2;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("maximum"))) {
            return 1;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("average"))) {
            return 4;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("sum"))) {
            return 3;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("count"))) {
            return 0;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("first"))) {
            return 5;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("last"))) {
            return 6;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("sumsquare"))) {
            return 7;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("variance"))) {
            return 8;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("stddev"))) {
            return 9;
        }
        if (aggFunction.equalsIgnoreCase(LanguageEncoder.getText("countdistinct"))) {
            return 10;
        }
        return -1;
    }

    public void setAggregateFunction(int option, int function) {
        if (this.isHiLowChart && option == 0) {
            this.primaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("maximum"));
        }
        switch (function) {
            case 2: {
                if (option == 0) {
                    this.primaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("minimum"));
                    break;
                }
                this.secondaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("minimum"));
                break;
            }
            case 1: {
                if (option == 0) {
                    this.primaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("maximum"));
                    break;
                }
                this.secondaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("maximum"));
                break;
            }
            case 4: {
                if (option == 0) {
                    this.primaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("average"));
                    break;
                }
                this.secondaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("average"));
                break;
            }
            case 3: {
                if (option == 0) {
                    this.primaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("sum"));
                    break;
                }
                this.secondaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("sum"));
                break;
            }
            case 0: {
                if (option == 0) {
                    this.primaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("count"));
                    break;
                }
                this.secondaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("count"));
                break;
            }
            case 5: {
                if (option == 0) {
                    this.primaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("first"));
                    break;
                }
                this.secondaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("first"));
                break;
            }
            case 6: {
                if (option == 0) {
                    this.primaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("last"));
                    break;
                }
                this.secondaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("last"));
                break;
            }
            case 7: {
                if (option == 0) {
                    this.primaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("sumsquare"));
                    break;
                }
                this.secondaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("sumsquare"));
                break;
            }
            case 8: {
                if (option == 0) {
                    this.primaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("variance"));
                    break;
                }
                this.secondaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("variance"));
                break;
            }
            case 9: {
                if (option == 0) {
                    this.primaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("stddev"));
                    break;
                }
                this.secondaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("stddev"));
                break;
            }
            case 10: {
                if (option == 0) {
                    this.primaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("countdistinct"));
                    break;
                }
                this.secondaryAggregateChoice.setSelectedItem(LanguageEncoder.getText("countdistinct"));
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target instanceof JButton) {
            this.fireEvent((JButton)target, 1);
        }
    }
}

