/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import quadbase.chart.designer.AggregateDialog;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class AggregationDialog
extends QbDialog
implements ItemListener {
    ChartMain chartMain = null;
    JPanel mainPanel = null;
    JPanel buttonPanel = null;
    JCheckBox checkAggregation = null;
    JButton okButton = null;
    JButton cancelButton = null;
    JButton optionButton = null;
    boolean enabledItemStateChanged = true;
    AggregateDialog aggDialog = null;

    public AggregationDialog(ChartMain chartMain) {
        super(chartMain, LanguageEncoder.getText("Draw Aggregation Chart"), true);
        this.chartMain = chartMain;
        this.init();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", this.mainPanel);
        contentPane.add("South", this.buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.mainPanel = new BorderPanel(LanguageEncoder.getText("Draw Aggregation Chart"));
        this.mainPanel.setLayout(new FlowLayout(0));
        this.checkAggregation = new JCheckBox(LanguageEncoder.getText("Enable Aggregation"));
        this.checkAggregation.setSelected(this.chartMain.chart.isAggregationChart());
        this.checkAggregation.addItemListener(this);
        this.mainPanel.add(this.checkAggregation);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2));
        this.optionButton = new JButton(LanguageEncoder.getText("Options"));
        this.optionButton.setEnabled(this.checkAggregation.isSelected());
        this.optionButton.addActionListener(this);
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        this.buttonPanel.add(this.optionButton);
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(this.cancelButton);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.cancelButton) {
            this.setVisible(false);
            return;
        }
        if (target == this.optionButton) {
            this.displayAggregationOptions();
        }
        if (target == this.okButton) {
            this.chartMain.chart.setAggregationChart(this.checkAggregation.isSelected());
            this.chartMain.chart.gt.clear();
            this.chartMain.chart.gt.shift = false;
            this.chartMain.do_Reload();
            this.chartMain.setModified();
            this.setVisible(false);
        }
    }

    private void displayAggregationOptions() {
        if (this.aggDialog == null) {
            this.aggDialog = new AggregateDialog(this.chartMain, this.chartMain.chart.getSubValueMap() >= 0, this.chartMain.chart.getCategoryType(), false, true, true);
        } else {
            this.aggDialog.cancelDialog = false;
        }
        this.aggDialog.setVisible(true);
        this.checkAggregation.setSelected(!this.aggDialog.isCancelled());
        this.optionButton.setEnabled(!this.aggDialog.isCancelled());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.enabledItemStateChanged) {
            return;
        }
        this.enabledItemStateChanged = false;
        Object target = e.getSource();
        if (target == this.checkAggregation) {
            if (this.checkAggregation.isSelected()) {
                this.optionButton.setEnabled(true);
                this.displayAggregationOptions();
            } else {
                this.optionButton.setEnabled(false);
            }
        }
        this.enabledItemStateChanged = true;
    }
}

