/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.util.logging.Level;
import java.util.logging.Logger;
import quadbase.chart.designer.AlarmTarget;

public class Alarm
extends Thread {
    private static final Logger LOGGER = Logger.getLogger(Alarm.class.getName());
    long sleepTime = 500L;
    AlarmTarget target;
    long wakeTime = 0L;
    boolean periodic;
    boolean pleaseStop = false;

    public Alarm(long mills, AlarmTarget at) {
        this(at, mills, null);
    }

    public Alarm(AlarmTarget at, long mills) {
        this(at, mills, null);
    }

    public Alarm(AlarmTarget at) {
        this(at, 500L, null);
    }

    public Alarm(AlarmTarget at, long mills, ThreadGroup tg) {
        super(tg, "alarm");
        this.target = at;
        this.sleepTime = mills;
    }

    public synchronized void setPeriodic(boolean periodic) {
        this.periodic = periodic;
    }

    public synchronized void setSleepTime(long mill) {
        long old = this.sleepTime;
        this.sleepTime = mill;
        if (mill < old) {
            this.cancelSleep();
        }
    }

    public synchronized void restart() {
        boolean wakeNow = this.wakeTime == 0L;
        this.wakeTime = System.currentTimeMillis() + this.sleepTime;
        if (wakeNow) {
            this.notify();
        }
    }

    public synchronized void restart(long mills) {
        this.sleepTime = mills;
        this.restart();
    }

    public synchronized void cancelSleep() {
        if (this.periodic) {
            this.restart();
        } else {
            this.wakeTime = 0L;
        }
    }

    @Override
    public synchronized void run() {
        long now = 0L;
        while (!this.pleaseStop) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.wakeTime <= 0L || this.pleaseStop || (now = System.currentTimeMillis()) < this.wakeTime) continue;
            this.target.onAlarm(this);
            if (this.periodic) {
                this.restart();
                continue;
            }
            this.wakeTime = 0L;
        }
    }

    public void suspendAlarm() {
        this.periodic = false;
        this.wakeTime = 0L;
    }

    public void resumeAlarm() {
        this.periodic = true;
        this.restart();
    }

    public void pleaseStop() {
        this.pleaseStop = true;
        try {
            this.interrupt();
        }
        catch (SecurityException e) {
            LOGGER.log(Level.FINEST, "Security exception", e);
        }
    }
}

