/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class ApproximateDialog
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(ApproximateDialog.class.getName());
    JTextField threshold;
    JButton okButton;
    JButton cancelButton;
    JCheckBox isApproximateNotUsed;
    JCheckBox drawSeriesOnCategoryAxis;
    Chart chart;
    ChartMain chartMain;

    public ApproximateDialog(ChartMain frame, Chart chart) {
        super(frame, LanguageEncoder.getText("3D Display Options"), true);
        this.chartMain = frame;
        this.chart = chart;
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        this.threshold = new JTextField(Integer.toString(this.chart.approximationThreshold), 5);
        this.isApproximateNotUsed = new JCheckBox(LanguageEncoder.getText("Do Not Use Approximation Display"), !this.chart.is3DApproximationUsed);
        this.isApproximateNotUsed.addItemListener(this);
        this.threshold.setEnabled(!this.isApproximateNotUsed.isSelected());
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.threshold.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        BorderPanel titlePanel = new BorderPanel(LanguageEncoder.getText("3D Approximation Display"));
        titlePanel.setLayout(new GridLayout(0, 1));
        JPanel thresholdPanel = new JPanel();
        thresholdPanel.setLayout(new FlowLayout(0));
        thresholdPanel.add(new JLabel(LanguageEncoder.getText("Use Approximation Display if point threshold is greater than")));
        thresholdPanel.add(this.threshold);
        titlePanel.add(this.isApproximateNotUsed);
        titlePanel.add(thresholdPanel);
        BorderPanel displayPanel = new BorderPanel(LanguageEncoder.getText("3D Display Method"));
        displayPanel.setLayout(new FlowLayout(0));
        this.drawSeriesOnCategoryAxis = new JCheckBox(LanguageEncoder.getText("Draw Series On Category Axis"), this.chart.isDrawSeriesOnCategoryAxis());
        displayPanel.add(this.drawSeriesOnCategoryAxis);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        if (this.chart.chartType != 12 && this.chart.chartType != 2 && this.chart.subvalueCol < 0) {
            this.threshold.setEnabled(false);
            this.isApproximateNotUsed.setEnabled(false);
        }
        if (this.chart.chartType != 0 && this.chart.chartType != 4 && this.chart.chartType != 1 && this.chart.chartType != 5 && this.chart.chartType != 11) {
            this.drawSeriesOnCategoryAxis.setEnabled(false);
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("North", displayPanel);
        contentPane.add("Center", titlePanel);
        contentPane.add("South", buttonPanel);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.threshold.setEnabled(!this.isApproximateNotUsed.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            this.dispose();
            if (this.chart.chartType == 12 || this.chart.chartType == 2 || this.chart.subvalueCol >= 0) {
                this.chart.is3DApproximationUsed = !this.isApproximateNotUsed.isSelected();
                try {
                    this.chart.approximationThreshold = Integer.parseInt(this.threshold.getText());
                }
                catch (NumberFormatException ex) {
                    LOGGER.log(Level.FINE, "Failed to parse integer. Invalid number.", ex);
                }
            }
            this.chart.setDrawSeriesOnCategoryAxis(this.drawSeriesOnCategoryAxis.isSelected());
            this.chartMain.setModified();
            this.chart.doNewSurface();
            this.chartMain.updateNavigationPanel(this.chart);
            this.chartMain.chartPanel.repaint();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }
}

