/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.chart.Area;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;

public class AreaOptionPanel
extends JPanel {
    JRadioButton ck_raise;
    JRadioButton ck_lower;
    JRadioButton ck_none;
    JRadioButton ck_shadow;
    JRadioButton ck_cutCorner;
    SpinBox spinDepth;
    Area area;
    boolean forLegend = false;

    public AreaOptionPanel(Area area, String title) {
        this(area, title, false);
    }

    public AreaOptionPanel(Area area, String title, boolean forLegend) {
        this.area = area;
        this.forLegend = forLegend;
        BorderPanel areapanel = new BorderPanel(title);
        ButtonGroup ckg_effect = new ButtonGroup();
        this.ck_raise = new JRadioButton(LanguageEncoder.getText("Raise"), true);
        this.ck_lower = new JRadioButton(LanguageEncoder.getText("Lower"), false);
        this.ck_none = new JRadioButton(LanguageEncoder.getText("None"), false);
        this.ck_shadow = new JRadioButton(LanguageEncoder.getText("Shadow"), false);
        if (forLegend) {
            this.ck_cutCorner = new JRadioButton(LanguageEncoder.getText("Cut Corner"), false);
        }
        ckg_effect.add(this.ck_raise);
        ckg_effect.add(this.ck_lower);
        ckg_effect.add(this.ck_none);
        ckg_effect.add(this.ck_shadow);
        if (forLegend) {
            ckg_effect.add(this.ck_cutCorner);
        }
        JPanel areapanel1 = new JPanel();
        areapanel1.setLayout(new GridLayout(2, 0));
        areapanel1.add(this.ck_raise);
        areapanel1.add(this.ck_shadow);
        areapanel1.add(this.ck_lower);
        if (forLegend) {
            areapanel1.add(this.ck_cutCorner);
        }
        areapanel1.add(this.ck_none);
        areapanel.setLayout(new FlowLayout());
        JPanel areapanel2 = new JPanel();
        areapanel2.setLayout(new FlowLayout());
        areapanel2.add(new JLabel(LanguageEncoder.getText("Depth")));
        this.spinDepth = new SpinBox(1, 20);
        areapanel2.add(this.spinDepth);
        areapanel.add(areapanel1);
        areapanel.add(areapanel2);
        if (area.appearance == 1) {
            this.ck_raise.setSelected(true);
        } else if (area.appearance == 2) {
            this.ck_lower.setSelected(true);
        } else if (area.appearance == 3) {
            this.ck_shadow.setSelected(true);
        } else if (forLegend && area.appearance == 4) {
            this.ck_cutCorner.setSelected(true);
        } else {
            this.ck_none.setSelected(true);
        }
        this.spinDepth.setValue(area.depth);
        this.setLayout(new BorderLayout());
        this.add("Center", areapanel);
    }

    Area getArea() {
        this.area.appearance = this.ck_raise.isSelected() ? 1 : (this.ck_lower.isSelected() ? 2 : (this.ck_shadow.isSelected() ? 3 : (this.forLegend && this.ck_cutCorner.isSelected() ? 4 : 0)));
        this.area.depth = this.spinDepth.getValue();
        return this.area;
    }

    void setEnable(boolean enable) {
        this.ck_raise.setEnabled(enable);
        this.ck_lower.setEnabled(enable);
        this.ck_none.setEnabled(enable);
        this.ck_shadow.setEnabled(enable);
        if (this.ck_cutCorner != null) {
            this.ck_cutCorner.setEnabled(enable);
        }
        this.spinDepth.setEnabled(enable);
    }
}

