/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.text.DateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import quadbase.chart.Axis;
import quadbase.chart.Chart;
import quadbase.chart.StepSize;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.DateAxisPanel;
import quadbase.chart.designer.FormatValueDialog;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;

public class AxisDialog
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(AxisDialog.class.getName());
    ChartMain chartmain;
    JTabbedPane tabPanel;
    JPanel[] axispanel;
    JRadioButton[][] checkbox;
    JRadioButton[][] scaleOptions;
    JCheckBox[] bestFitCheckBox;
    JCheckBox[] checkAxisPadding;
    JCheckBox checkCombineScale = null;
    JTextField[] textmin;
    JTextField[] textmax;
    JTextField[] textunit;
    JTextField[] textorigin;
    JCheckBox[] checkLogScale;
    JButton[] expButton;
    JCheckBox[] showLogValueCheckBox;
    JTextField[] logBaseValueTextField;
    DateAxisPanel[] dateAxisPanel;
    JButton butcancel;
    JButton butOK;
    Chart chart;
    boolean[] automatic;
    boolean[] autoOrigin;
    boolean[] addAxisPadding;
    boolean[] logScale;
    boolean[] showLogValue;
    double[] logBase;
    double[] stepsize;
    int[] monthStepSize;
    boolean[] isDynamicScale;
    double[] maxscale;
    double[] minscale;
    double[] origin;
    int panel_no = 0;
    int[] map;
    int[] rmap;
    int axislimit;
    boolean initializing = true;
    int axisCount = 4;

    public AxisDialog(ChartMain frame, String title) {
        super(frame, title, true);
        int i;
        boolean isMultiAxisRadar;
        this.chartmain = frame;
        this.chart = this.chartmain.chart;
        boolean bl = isMultiAxisRadar = this.chart.getChartType() == 16 && !this.chart.isSynchronizeRadarAxis();
        if ((this.chart.getChartType() == 14 || isMultiAxisRadar) && this.chart.colDataAxis != null) {
            this.axisCount += this.chart.colDataAxis.length;
        }
        this.setBackground(Color.lightGray);
        this.tabPanel = new JTabbedPane();
        this.axispanel = new JPanel[this.axisCount];
        this.automatic = new boolean[this.axisCount];
        this.autoOrigin = new boolean[this.axisCount];
        this.addAxisPadding = new boolean[this.axisCount];
        this.logScale = new boolean[this.axisCount];
        this.showLogValue = new boolean[this.axisCount];
        this.logBase = new double[this.axisCount];
        this.stepsize = new double[this.axisCount];
        this.monthStepSize = new int[this.axisCount];
        this.isDynamicScale = new boolean[this.axisCount];
        this.maxscale = new double[this.axisCount];
        this.minscale = new double[this.axisCount];
        this.origin = new double[this.axisCount];
        this.map = new int[this.axisCount];
        this.rmap = new int[this.axisCount];
        this.axislimit = frame.chart.showSecAxis() ? 4 : 3;
        for (i = 0; i < 4; ++i) {
            this.map[i] = -1;
            this.axispanel[i] = new JPanel();
            if (isMultiAxisRadar) continue;
            this.setAxisStepSize(this.chart.axis[i], i);
        }
        for (i = 4; i < this.axisCount; ++i) {
            this.map[i] = -1;
            this.axispanel[i] = new JPanel();
            this.setAxisStepSize(this.chart.colDataAxis[i - 4], i);
        }
        this.checkbox = new JRadioButton[this.axisCount][2];
        this.checkLogScale = new JCheckBox[this.axisCount];
        this.showLogValueCheckBox = new JCheckBox[this.axisCount];
        this.expButton = new JButton[this.axisCount];
        this.logBaseValueTextField = new JTextField[this.axisCount];
        this.bestFitCheckBox = new JCheckBox[this.axisCount];
        this.checkAxisPadding = new JCheckBox[this.axisCount];
        this.textmax = new JTextField[this.axisCount];
        this.textmin = new JTextField[this.axisCount];
        this.textunit = new JTextField[this.axisCount];
        this.textorigin = new JTextField[this.axisCount];
        if (this.chart.getChartType() == 18) {
            this.dateAxisPanel = new DateAxisPanel[this.axisCount];
            if (this.chart.axis.length >= 1 && DataType.isDateTime(this.chart.axis[0].columnField.axisType)) {
                this.scaleOptions = new JRadioButton[this.axisCount][5];
            }
        }
        ButtonGroup[] checkgroup = new ButtonGroup[this.axisCount];
        ButtonGroup[] scaleOptionGroup = new ButtonGroup[this.axisCount];
        for (i = 0; i < this.panel_no; ++i) {
            JPanel checkpanel = new JPanel();
            checkgroup[i] = new ButtonGroup();
            this.checkbox[i][0] = new JRadioButton(LanguageEncoder.getText("Automatic"), true);
            this.checkbox[i][1] = new JRadioButton(LanguageEncoder.getText("Manual"), false);
            checkgroup[i].add(this.checkbox[i][0]);
            checkgroup[i].add(this.checkbox[i][1]);
            this.checkbox[i][0].addItemListener(this);
            this.checkbox[i][1].addItemListener(this);
            checkpanel.setLayout(new GridLayout(3, 1));
            checkpanel.add(this.checkbox[i][0]);
            if (this.chart.getChartType() == 18 && DataType.isDateTime(this.chart.axis[i].columnField.axisType)) {
                this.scaleOptions[i][0] = new JRadioButton(LanguageEncoder.getText("Auto"), true);
                this.scaleOptions[i][1] = new JRadioButton(LanguageEncoder.getText("Day"));
                this.scaleOptions[i][2] = new JRadioButton(LanguageEncoder.getText("Month"));
                this.scaleOptions[i][3] = new JRadioButton(LanguageEncoder.getText("Year"));
                this.scaleOptions[i][4] = new JRadioButton(LanguageEncoder.getText("Dynamic"));
                scaleOptionGroup[i] = new ButtonGroup();
                scaleOptionGroup[i].add(this.scaleOptions[i][0]);
                scaleOptionGroup[i].add(this.scaleOptions[i][1]);
                scaleOptionGroup[i].add(this.scaleOptions[i][2]);
                scaleOptionGroup[i].add(this.scaleOptions[i][3]);
                scaleOptionGroup[i].add(this.scaleOptions[i][4]);
                BorderPanel autoScalePanel = new BorderPanel(LanguageEncoder.getText("Auto Scale Step Options:"));
                autoScalePanel.add(this.scaleOptions[i][0]);
                autoScalePanel.add(this.scaleOptions[i][1]);
                autoScalePanel.add(this.scaleOptions[i][2]);
                autoScalePanel.add(this.scaleOptions[i][3]);
                autoScalePanel.add(this.scaleOptions[i][4]);
                checkpanel.add(autoScalePanel);
            }
            checkpanel.add(this.checkbox[i][1]);
            this.bestFitCheckBox[i] = new JCheckBox(LanguageEncoder.getText("Best fit"), true);
            this.bestFitCheckBox[i].addItemListener(this);
            this.checkAxisPadding[i] = new JCheckBox(LanguageEncoder.getText("Add Padding"), true);
            this.checkAxisPadding[i].addItemListener(this);
            this.checkLogScale[i] = new JCheckBox(LanguageEncoder.getText("Logarithmic scale"));
            this.checkLogScale[i].addItemListener(this);
            this.expButton[i] = new JButton(LanguageEncoder.getText("e"));
            this.expButton[i].addActionListener(this);
            this.showLogValueCheckBox[i] = new JCheckBox(LanguageEncoder.getText("Show Log Value"));
            this.showLogValueCheckBox[i].addItemListener(this);
            this.showLogValueCheckBox[i].setSelected(false);
            this.logBaseValueTextField[i] = new JTextField(8);
            this.textmax[i] = new JTextField(8);
            this.textmax[i].addActionListener(this);
            this.textmin[i] = new JTextField(8);
            this.textmin[i].addActionListener(this);
            this.textunit[i] = new JTextField(8);
            this.textunit[i].addActionListener(this);
            this.textorigin[i] = new JTextField(8);
            this.textorigin[i].addActionListener(this);
            this.textmin[i].setEditable(true);
            this.textmax[i].setEditable(true);
            this.textunit[i].setEditable(true);
            this.textorigin[i].setEditable(true);
            if (this.chart.getChartType() == 18 && DataType.isDateTime(this.chart.axis[i].columnField.axisType)) {
                this.dateAxisPanel[i] = new DateAxisPanel(this.chartmain, this.chart, i, true);
            }
            JPanel unitpanel = new JPanel();
            unitpanel.setLayout(new GridLayout(0, 2));
            unitpanel.add(new JLabel(LanguageEncoder.getText("Maximum")));
            unitpanel.add(this.textmax[i]);
            unitpanel.add(new JLabel(LanguageEncoder.getText("Minimum")));
            unitpanel.add(this.textmin[i]);
            unitpanel.add(new JLabel(LanguageEncoder.getText("Unit")));
            unitpanel.add(this.textunit[i]);
            if (this.rmap[i] < 2 && this.chart.chartType != 8 && this.chart.chartType != 11 && this.chart.chartType != 18 || Chart.isCoordinateType(this.chart.chartType) || this.rmap[i] == 3 && this.chart.getChartType() != 11) {
                unitpanel.add(this.checkAxisPadding[i]);
                unitpanel.add(new JLabel(""));
            }
            if ((this.rmap[i] < 2 || this.rmap[i] == 3) && this.chart.chartType != 8 && this.chart.chartType != 11 || Chart.isCoordinateType(this.chart.chartType)) {
                unitpanel.add(this.bestFitCheckBox[i]);
            }
            if (this.rmap[i] < 2 && this.chart.chartType != 8 && this.chart.chartType != 11 || Chart.isCoordinateType(this.chart.chartType)) {
                unitpanel.add(new JLabel(""));
                unitpanel.add(new JLabel(LanguageEncoder.getText("Origin")));
                unitpanel.add(this.textorigin[i]);
            }
            BorderPanel mainpanel = new BorderPanel(LanguageEncoder.getText("Scale"));
            mainpanel.setLayout(new BorderLayout());
            JPanel npanel = new JPanel();
            npanel.setLayout(new BorderLayout());
            npanel.add("North", checkpanel);
            if (this.chart.getChartType() == 18 && DataType.isDateTime(this.chart.axis[i].columnField.axisType)) {
                npanel.add("Center", this.dateAxisPanel[i]);
                if (this.rmap[i] < 2 && this.chart.chartType != 8 && this.chart.chartType != 11 && this.chart.chartType != 18 || Chart.isCoordinateType(this.chart.chartType) || this.rmap[i] == 3 && this.chart.getChartType() != 11) {
                    JPanel paddingPanel = new JPanel();
                    paddingPanel.setLayout(new FlowLayout(0));
                    paddingPanel.add(this.checkAxisPadding[i]);
                    npanel.add("South", paddingPanel);
                }
            } else {
                npanel.add("Center", unitpanel);
            }
            mainpanel.add("North", npanel);
            if (this.rmap[i] == 3 && this.chart.getChartType() != 11) {
                this.checkCombineScale = new JCheckBox(LanguageEncoder.getText("Align axis scale"), this.chart.isJoinAxis());
                mainpanel.add("Center", this.checkCombineScale);
                this.checkCombineScale.addItemListener(this);
            }
            if (!(this.chart.getChartType() == 17 || this.chart.getChartType() == 19 || this.chart.getChartType() == 18 && DataType.isDateTime(this.chart.axis[i].columnField.axisType))) {
                JPanel logarithmicScalePanel = new JPanel(new BorderLayout());
                logarithmicScalePanel.add("North", this.checkLogScale[i]);
                JPanel logPanel = new JPanel(new BorderLayout());
                logPanel.setBorder(new EmptyBorder(0, 10, 0, 0));
                JPanel logbasePanel = new JPanel(new FlowLayout(0));
                logbasePanel.add(new JLabel(LanguageEncoder.getText("Log Base")));
                logbasePanel.add(this.logBaseValueTextField[i]);
                logbasePanel.add(this.expButton[i]);
                logPanel.add("Center", logbasePanel);
                logPanel.add("South", this.showLogValueCheckBox[i]);
                logarithmicScalePanel.add("Center", logPanel);
                mainpanel.add("South", logarithmicScalePanel);
                this.enableLogarithmSettings(this.checkbox[i][0].isSelected(), i);
            }
            String tabTitle = "";
            int dataMap = this.chart.mDataMap[0];
            if (this.chart.getChartType() == 16) {
                dataMap = this.chart.mDataMap[this.chart.dataDim - 1];
            }
            tabTitle = this.rmap[i] < 4 ? FormatValueDialog.axischar[this.rmap[i]] : this.chart.colData[dataMap].getFieldName()[this.rmap[i] - 4].toString();
            if (i == 0 && this.chart.getChartType() == 19 || this.rmap[i] == 3 && !this.chart.showSecAxis()) continue;
            this.tabPanel.addTab(tabTitle + LanguageEncoder.getText("Axis"), mainpanel);
        }
        if (this.chart.getChartType() == 19) {
            this.tabPanel.setSelectedIndex(0);
        }
        if (this.panel_no - 1 < this.tabPanel.getTabCount()) {
            this.tabPanel.setSelectedIndex(this.panel_no - 1);
        } else {
            this.tabPanel.setSelectedIndex(0);
        }
        JPanel spanel = new JPanel();
        spanel.setLayout(new BorderLayout());
        spanel.add("Center", this.tabPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.butcancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.butOK = new JButton(LanguageEncoder.getText("OK"));
        buttonPanel.add(this.butOK);
        buttonPanel.add(this.butcancel);
        this.butOK.addActionListener(this);
        this.butcancel.addActionListener(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", spanel);
        contentPane.add("South", buttonPanel);
        this.setValues();
        this.pack();
        Dimension dim = this.getPreferredSize();
        dim.height += 15;
        Dimension screensize = this.getToolkit().getScreenSize();
        this.setBounds((screensize.width - dim.width) / 2, (screensize.height - dim.height) / 2, dim.width, dim.height);
        this.initializing = false;
    }

    private void enableScale(int index, boolean enable) {
        this.scaleOptions[index][0].setEnabled(enable);
        this.scaleOptions[index][1].setEnabled(enable);
        this.scaleOptions[index][2].setEnabled(enable);
        this.scaleOptions[index][3].setEnabled(enable);
        this.scaleOptions[index][4].setEnabled(enable);
    }

    private void setAxisStepSize(Axis a, int i) {
        if (a == null || a.stepsize == null) {
            return;
        }
        this.map[i] = this.panel_no;
        this.rmap[this.panel_no++] = i;
        this.automatic[i] = a.autoscale;
        this.autoOrigin[i] = a.autoOrigin;
        this.addAxisPadding[i] = a.addAxisPadding;
        this.logScale[i] = a.logScale;
        this.showLogValue[i] = a.isShowLogValue();
        this.logBase[i] = a.getBaseForLog();
        this.origin[i] = a.getAxisShift();
        if (a.autoscale) {
            this.maxscale[i] = a.stepsize.maxvalue;
            this.minscale[i] = a.stepsize.minvalue;
            this.stepsize[i] = a.stepsize.stepsize;
            this.monthStepSize[i] = a.stepsize.stepmonth;
            this.isDynamicScale[i] = a.isDynamicAutoScale();
        } else {
            this.maxscale[i] = a.maxScale;
            this.minscale[i] = a.minScale;
            this.stepsize[i] = a.stepScale;
            this.monthStepSize[i] = a.stepScaleMonth;
            this.isDynamicScale[i] = false;
        }
    }

    public void show(int i) {
        if (this.map[i] >= 0) {
            this.tabPanel.setSelectedIndex(this.map[i]);
        } else {
            this.tabPanel.setSelectedIndex(0);
        }
        this.setVisible(true);
    }

    private void setValues() {
        for (int i = 0; i < this.axisCount; ++i) {
            int m = this.map[i];
            if (m < 0) continue;
            this.checkAxisPadding[m].setSelected(this.addAxisPadding[i]);
            if (this.automatic[i]) {
                this.checkbox[m][0].setSelected(true);
                this.textmin[m].setEnabled(false);
                this.textmax[m].setEnabled(false);
                this.textunit[m].setEnabled(false);
                if (this.dateAxisPanel != null && this.dateAxisPanel[m] != null) {
                    this.dateAxisPanel[m].setEnabled(false);
                }
                if (this.scaleOptions != null) {
                    this.enableScale(m, true);
                    if (this.isDynamicScale[i]) {
                        this.scaleOptions[m][4].setSelected(true);
                    } else if (this.stepsize[i] == 8.64E7 && this.monthStepSize[i] == 0) {
                        this.scaleOptions[m][1].setSelected(true);
                    } else if (this.stepsize[i] == 0.0 && this.monthStepSize[i] == 1) {
                        this.scaleOptions[m][2].setSelected(true);
                    } else if (this.stepsize[i] == 0.0 && this.monthStepSize[i] == 12) {
                        this.scaleOptions[m][3].setSelected(true);
                    } else {
                        this.scaleOptions[m][0].setSelected(true);
                    }
                }
                this.checkAxisPadding[m].setEnabled(true);
            } else {
                this.checkbox[m][1].setSelected(true);
                this.textmin[m].setEnabled(true);
                this.textmax[m].setEnabled(true);
                this.textunit[m].setEnabled(true);
                if (this.dateAxisPanel != null && this.dateAxisPanel[m] != null) {
                    this.dateAxisPanel[m].setEnabled(true);
                }
                if (this.scaleOptions != null) {
                    this.enableScale(m, false);
                }
                this.checkAxisPadding[m].setEnabled(false);
            }
            if (this.autoOrigin[i]) {
                this.bestFitCheckBox[m].setSelected(true);
                this.textorigin[m].setEnabled(false);
            } else {
                this.bestFitCheckBox[m].setSelected(false);
                this.textorigin[m].setEnabled(true);
            }
            this.checkLogScale[m].setSelected(this.logScale[i]);
            this.enableLogarithmSettings(this.logScale[i], m);
            this.showLogValueCheckBox[m].setSelected(this.showLogValue[i]);
            this.logBaseValueTextField[m].setText(Double.valueOf(this.logBase[i]).toString());
            boolean isLog = this.checkLogScale[m].isSelected();
            int scale = 5;
            double value = isLog ? Math.pow(this.logBase[i], this.minscale[i]) : this.minscale[i];
            this.textmin[m].setText(BigDecimal.valueOf(value).setScale(scale, 4).toString());
            value = isLog ? Math.pow(this.logBase[i], this.maxscale[i]) : this.maxscale[i];
            this.textmax[m].setText(BigDecimal.valueOf(value).setScale(scale, 4).toString());
            value = isLog ? Math.pow(this.logBase[i], this.stepsize[i]) : this.stepsize[i];
            this.textunit[m].setText(BigDecimal.valueOf(value).setScale(scale, 4).toString());
            value = isLog ? Math.pow(this.logBase[i], this.origin[i]) : this.origin[i];
            this.textorigin[m].setText(BigDecimal.valueOf(value).setScale(scale, 4).toString());
        }
        if (this.checkCombineScale != null && this.checkAxisPadding != null) {
            for (int ii = 1; ii < this.checkAxisPadding.length; ++ii) {
                if (this.checkAxisPadding[ii] == null) continue;
                this.checkAxisPadding[ii].setEnabled(!this.checkCombineScale.isSelected());
            }
        }
    }

    private void restoreValues() throws Exception {
        int m;
        int i;
        for (i = 0; i < this.axislimit; ++i) {
            m = this.map[i];
            if (m < 0) continue;
            this.restoreValues(this.chart.axis[i], i);
        }
        if (this.checkCombineScale != null) {
            this.chart.setJoinAxis(this.checkCombineScale.isSelected());
        }
        if (this.chart.colDataAxis == null) {
            return;
        }
        for (i = 4; i < this.map.length; ++i) {
            m = this.map[i];
            if (m < 0) continue;
            this.restoreValues(this.chart.colDataAxis[i - 4], i);
        }
    }

    private void restoreValues(Axis a, int i) throws Exception {
        if (a == null || a.stepsize == null) {
            return;
        }
        a.addAxisPadding = this.addAxisPadding[i];
        boolean useDateVal = false;
        if (this.chart.getChartType() == 18 && DataType.isDateTime(this.chart.axis[i].columnField.axisType) && this.dateAxisPanel != null && this.dateAxisPanel[i] != null) {
            useDateVal = true;
            a.autoscale = this.automatic[i];
            if (!a.autoscale) {
                String err = this.dateAxisPanel[i].setValues();
                if (err != null) {
                    new MessageDialog((Frame)this.chartmain, LanguageEncoder.getText("Error")).show(err);
                    throw new Exception(err);
                }
            } else if (this.scaleOptions != null) {
                if (this.scaleOptions[i][0].isSelected()) {
                    a.setDynamicAutoScale(false);
                    a.setScaleStep(0.0);
                    a.setScaleStepMonth(0);
                } else if (this.scaleOptions[i][1].isSelected()) {
                    a.setDynamicAutoScale(false);
                    a.setScaleStep(8.64E7);
                    a.setScaleStepMonth(0);
                } else if (this.scaleOptions[i][2].isSelected()) {
                    a.setDynamicAutoScale(false);
                    a.setScaleStep(0.0);
                    a.setScaleStepMonth(1);
                } else if (this.scaleOptions[i][3].isSelected()) {
                    a.setDynamicAutoScale(false);
                    a.setScaleStep(0.0);
                    a.setScaleStepMonth(12);
                } else if (this.scaleOptions[i][4].isSelected()) {
                    a.setDynamicAutoScale(true);
                    a.setScaleStep(0.0);
                    a.setScaleStepMonth(0);
                }
            } else {
                a.setScaleStep(0.0);
                a.setScaleStepMonth(0);
            }
        } else {
            a.autoOrigin = this.autoOrigin[i];
            a.logScale = this.logScale[i];
            a.setShowLogValue(this.showLogValue[i]);
            a.setBaseForLog(this.logBase[i]);
            a.autoscale = this.automatic[i];
            if (this.minscale[i] != this.maxscale[i]) {
                a.maxScale = Math.max(this.maxscale[i], this.minscale[i]);
                a.minScale = Math.min(this.maxscale[i], this.minscale[i]);
            }
            if (this.autoOrigin[i]) {
                if (this.origin[i] > a.maxScale) {
                    this.origin[i] = a.maxScale;
                } else if (this.origin[i] < a.minScale) {
                    this.origin[i] = a.minScale;
                }
            }
            a.setAxisShift(this.origin[i]);
            a.stepScale = this.stepsize[i];
        }
        if (a.logScale && a.getBaseForLog() != 10.0) {
            a.setShowSubTickers(false);
        }
        if (!a.autoscale && !a.logScale) {
            double maxS = a.maxScale;
            double minS = a.minScale;
            double stepS = a.stepScale;
            new StepSize(a);
            if (maxS != a.maxScale || minS != a.minScale || stepS != a.stepScale) {
                String maxStr = a.maxScale + "";
                String minStr = a.minScale + "";
                String scaleStr = "\n\tUnit = " + a.stepScale + "";
                if (useDateVal) {
                    maxStr = DateFormat.getDateInstance().format(new Date((long)a.maxScale));
                    minStr = DateFormat.getDateInstance().format(new Date((long)a.minScale));
                    scaleStr = "";
                }
                String errorMsg = LanguageEncoder.getText("Invalid max/min/unit scale combination!\nValues auto changed to:") + "\n\tMax = " + maxStr + "\n\tMin = " + minStr + scaleStr;
                new MessageDialog((Frame)this.chartmain, LanguageEncoder.getText("Error")).show(errorMsg);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object srcObj = e.getSource();
        if (this.initializing) {
            return;
        }
        if (e.getSource() == this.butOK) {
            try {
                this.checktextbox();
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Failed to parse double. Invalid number.", ex);
                return;
            }
            try {
                this.restoreValues();
                this.chart.legend.invalidate();
                this.chart.newSurface();
                this.chartmain.setModified();
                this.chartmain.chartPanel.update();
                this.dispose();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to save changes", ex);
            }
        } else if (srcObj == this.butcancel) {
            this.dispose();
        } else if (srcObj instanceof JButton) {
            for (int i = 0; i < this.expButton.length; ++i) {
                if (srcObj != this.expButton[i]) continue;
                this.logBaseValueTextField[i].setText(new BigDecimal(Math.E).setScale(8, RoundingMode.HALF_EVEN) + "");
            }
        }
    }

    private void enableLogarithmSettings(boolean enable, int index) {
        this.showLogValueCheckBox[index].setEnabled(enable);
        this.logBaseValueTextField[index].setEnabled(enable);
        this.expButton[index].setEnabled(enable);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.initializing) {
            return;
        }
        this.initializing = true;
        Object target = e.getSource();
        for (int currpage = 0; currpage < this.axisCount; ++currpage) {
            int m = this.map[currpage];
            if (m < 0) continue;
            if (target == this.checkbox[m][0] || target == this.checkbox[m][1]) {
                boolean isAutomatic = target == this.checkbox[m][0];
                this.textmin[m].setEnabled(!isAutomatic);
                this.textmax[m].setEnabled(!isAutomatic);
                this.textunit[m].setEnabled(!isAutomatic);
                this.enableLogarithmSettings(this.checkLogScale[m].isSelected(), m);
                if (this.dateAxisPanel != null && this.dateAxisPanel[m] != null) {
                    this.dateAxisPanel[m].setEnabled(!isAutomatic);
                }
                if (this.scaleOptions != null) {
                    this.enableScale(m, isAutomatic);
                }
                this.automatic[currpage] = isAutomatic;
                this.bestFitCheckBox[m].setSelected(isAutomatic);
                this.autoOrigin[currpage] = isAutomatic;
                this.textorigin[m].setEnabled(!isAutomatic);
                this.checkAxisPadding[m].setEnabled(isAutomatic);
                continue;
            }
            if (target == this.checkAxisPadding[m]) {
                this.addAxisPadding[currpage] = this.checkAxisPadding[m].isSelected();
                continue;
            }
            if (target == this.bestFitCheckBox[m]) {
                if (this.bestFitCheckBox[m].isSelected()) {
                    this.autoOrigin[currpage] = true;
                    this.textorigin[m].setEnabled(false);
                    continue;
                }
                this.autoOrigin[currpage] = false;
                this.textorigin[m].setEnabled(true);
                continue;
            }
            if (target == this.checkLogScale[m]) {
                Axis tmpAxis = null;
                tmpAxis = currpage < 4 ? this.chart.axis[currpage] : this.chart.colDataAxis[currpage - 4];
                if (tmpAxis.stepsize.minlimit < 0.0 && !tmpAxis.logScale) {
                    new MessageDialog(this.frame, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Data must be >0 for log scale"));
                    this.checkLogScale[m].setSelected(false);
                }
                this.logScale[currpage] = this.checkLogScale[m].isSelected();
                this.showLogValue[currpage] = this.showLogValueCheckBox[m].isSelected();
                this.enableLogarithmSettings(this.checkLogScale[m].isSelected(), m);
                continue;
            }
            if (target != this.showLogValueCheckBox[m]) continue;
            this.showLogValue[currpage] = this.showLogValueCheckBox[m].isSelected();
        }
        if (this.checkCombineScale != null && this.checkAxisPadding != null) {
            for (int i = 1; i < this.checkAxisPadding.length; ++i) {
                if (this.checkAxisPadding[i] == null) continue;
                this.checkAxisPadding[i].setEnabled(!this.checkCombineScale.isSelected());
            }
        }
        this.initializing = false;
    }

    private void checktextbox() throws NumberFormatException {
        for (int i = 0; i < this.axisCount; ++i) {
            StringBuilder strBuild = new StringBuilder();
            String msg = null;
            int m = this.map[i];
            if (m < 0) continue;
            try {
                msg = this.getTextValue(this.logBase, this.logBaseValueTextField[m], i);
                if (!msg.equals("")) {
                    strBuild.append(msg).append("\n");
                }
            }
            catch (NumberFormatException ex) {
                new MessageDialog(this.frame, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Please enter valid number for logarithm base."));
                throw new NumberFormatException(ex.getMessage());
            }
            try {
                msg = this.getTextValue(this.origin, this.textorigin[m], i);
                if (!msg.equals("")) {
                    strBuild.append(msg).append("\n");
                }
            }
            catch (NumberFormatException ex) {
                new MessageDialog(this.frame, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Please enter valid number for origin."));
                throw new NumberFormatException(ex.getMessage());
            }
            try {
                msg = this.getTextValue(this.minscale, this.textmin[m], i);
                if (!msg.equals("")) {
                    strBuild.append(msg).append("\n");
                }
            }
            catch (NumberFormatException ex) {
                new MessageDialog(this.frame, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Please enter valid number for min scale."));
                throw new NumberFormatException(ex.getMessage());
            }
            try {
                msg = this.getTextValue(this.maxscale, this.textmax[m], i);
                if (!msg.equals("")) {
                    strBuild.append(msg).append("\n");
                }
            }
            catch (NumberFormatException ex) {
                new MessageDialog(this.frame, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Please enter valid number for max scale."));
                throw new NumberFormatException(ex.getMessage());
            }
            try {
                msg = this.getTextValue(this.stepsize, this.textunit[m], i);
                if (!msg.equals("")) {
                    strBuild.append(msg).append("\n");
                }
            }
            catch (NumberFormatException ex) {
                new MessageDialog(this.frame, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Please enter valid number for the Unit field."));
                throw new NumberFormatException(ex.getMessage());
            }
            if (!strBuild.toString().equals("")) {
                new MessageDialog(this.frame, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText(strBuild.toString()));
            }
            if (this.checkLogScale[m] != null && this.checkLogScale[m].isSelected()) {
                this.minscale[i] = this.getLogValue(this.minscale[i], this.logBase[i]);
                this.maxscale[i] = this.getLogValue(this.maxscale[i], this.logBase[i]);
                this.origin[i] = this.getLogValue(this.origin[i], this.logBase[i]);
                this.stepsize[i] = this.getLogValue(this.stepsize[i], this.logBase[i]);
            }
            if (this.minscale[i] > this.origin[i]) {
                if (!this.autoOrigin[i]) {
                    this.textmin[m].setText(Double.valueOf(this.origin[i]).toString());
                    this.minscale[i] = this.origin[i];
                } else {
                    this.textorigin[m].setText(Double.valueOf(this.minscale[i]).toString());
                    this.origin[i] = this.minscale[i];
                }
            }
            if (!(this.maxscale[i] < this.origin[i])) continue;
            if (!this.autoOrigin[i]) {
                this.textmax[m].setText(Double.valueOf(this.origin[i]).toString());
                this.maxscale[i] = this.origin[i];
                continue;
            }
            this.textorigin[m].setText(Double.valueOf(this.maxscale[i]).toString());
            this.origin[i] = this.maxscale[i];
        }
    }

    private double getLogValue(double value, double logBase) {
        return Math.log(value) / Math.log(logBase);
    }

    private String getTextValue(double[] arr, JTextField tf, int currpage) throws NumberFormatException {
        String errorMessage = "";
        int m = this.map[currpage];
        if (m < 0) {
            return errorMessage;
        }
        Axis tmpAxis = currpage < 4 ? this.chart.axis[currpage] : this.chart.colDataAxis[currpage - 4];
        double newvalue = Double.valueOf(tf.getText());
        boolean isLog = this.checkLogScale[m].isSelected();
        if (tf == this.textmax[m]) {
            double maximValue;
            double d = maximValue = isLog && tmpAxis.logScale ? Math.pow(this.logBase[currpage], tmpAxis.stepsize.maxlimit) : tmpAxis.stepsize.maxlimit;
            if (newvalue < maximValue) {
                newvalue = maximValue;
                errorMessage = "Max must be >= " + newvalue;
            } else if (isLog && newvalue <= 0.0) {
                newvalue = maximValue;
                errorMessage = "If logarithmic scale is enabled, max must be greater than 0! Using " + newvalue + " instead.";
            }
        } else if (tf == this.textmin[m]) {
            double minimValue;
            double d = minimValue = isLog && tmpAxis.logScale ? Math.pow(this.logBase[currpage], tmpAxis.stepsize.minlimit) : tmpAxis.stepsize.minlimit;
            if (newvalue > minimValue && this.chart.chartType != 18) {
                newvalue = minimValue;
                errorMessage = "Min scale must be  <= " + newvalue;
            }
            if (isLog && newvalue <= 0.0) {
                newvalue = minimValue;
                if (newvalue <= 0.0) {
                    errorMessage = "If logarithmic scale is enabled, min must be greater than 0. However, the minimum value in the axis data doesn't allow this. Logarithmic scale will be disabled.";
                    isLog = false;
                    this.checkLogScale[m].setSelected(false);
                } else {
                    errorMessage = "If logarithmic scale is enabled, min must be greater than 0! Using " + newvalue + " instead.";
                }
            }
        } else if (tf == this.logBaseValueTextField[m]) {
            if (newvalue < 0.0 || newvalue == 1.0) {
                newvalue = 10.0;
                errorMessage = "Logarithm base must be greater than 0 and not equal to 1. Using default value " + newvalue + ".";
            }
        } else if (tf != this.textorigin[m] && !this.automatic[m]) {
            if (newvalue <= 0.0) {
                newvalue = arr[currpage];
                errorMessage = "Scale must be > 0";
            } else if (!isLog && Math.abs(this.maxscale[currpage] - this.minscale[currpage]) / newvalue > 1000.0) {
                newvalue = Math.abs(this.maxscale[currpage] - this.minscale[currpage]) / 1000.0;
                errorMessage = "Scale is too small";
            } else if (isLog && newvalue <= 0.0) {
                newvalue = this.logBase[currpage];
                errorMessage = "Logarithm scale must be greater than 0 and not equal to 1. Using logarithm base " + newvalue + " as default value.";
            }
        } else if (tf == this.textorigin[m] && isLog && newvalue <= 0.0) {
            newvalue = this.logBase[currpage];
            errorMessage = "If logarithmic scale is enabled, origin must be greater than 0! Using default value " + newvalue + ".";
        }
        tf.setText(Double.valueOf(newvalue).toString());
        arr[currpage] = newvalue;
        return errorMessage;
    }
}

