/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.PieChart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;

public class BubbleDialog
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(BubbleDialog.class.getName());
    boolean checkFillSave;
    boolean checkBorderSave;
    double ratioSave;
    JTextField textRatio;
    JCheckBox checkFill;
    JCheckBox checkBorder;
    boolean check3DBubbleSave;
    int lightSave;
    JCheckBox check3DBubble;
    JTextField text3DBubbleLight;
    SpinBox spinRatio;
    JButton okButton;
    JButton cancelButton;
    Chart chart;
    PieChart pieChart;
    ChartMain chartMain;

    public BubbleDialog(JFrame frame, Chart chart) {
        super(frame, LanguageEncoder.getText("Bubble Options"), true);
        this.chartMain = (ChartMain)frame;
        this.chart = chart;
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        BorderPanel mainPanel = new BorderPanel(LanguageEncoder.getText("Bubble Options"));
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        JPanel subPanel1 = new JPanel(new BorderLayout());
        subPanel1.add("West", new JLabel(LanguageEncoder.getText("x-axis unit length : radius =")));
        this.textRatio = new JTextField(this.chart.axisUnitToRadiusRatio + "", 10);
        subPanel1.add("East", this.textRatio);
        mainPanel.add(subPanel1);
        JPanel subPanel2 = new JPanel(new BorderLayout());
        this.checkFill = new JCheckBox(LanguageEncoder.getText("Fill Bubble"));
        subPanel2.add("West", this.checkFill);
        this.checkFill.addItemListener(this);
        this.checkBorder = new JCheckBox(LanguageEncoder.getText("Draw Border"));
        subPanel2.add("East", this.checkBorder);
        mainPanel.add(subPanel2);
        JPanel subPanel3 = new JPanel(new BorderLayout());
        this.check3DBubble = new JCheckBox(LanguageEncoder.getText("3D Shading;"));
        subPanel3.add("North", this.check3DBubble);
        this.check3DBubble.addItemListener(this);
        JPanel subPanel31 = new JPanel(new BorderLayout());
        subPanel31.add("West", new JLabel(LanguageEncoder.getText("light intensity =")));
        this.text3DBubbleLight = new JTextField(this.chart.bubble3DLight + "", 3);
        subPanel31.add("East", this.text3DBubbleLight);
        subPanel3.add("East", subPanel31);
        mainPanel.add(subPanel3);
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", mainPanel);
        contentPane.add("South", buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.getValues();
    }

    private void getValues() {
        this.ratioSave = this.chart.axisUnitToRadiusRatio;
        this.lightSave = this.chart.bubble3DLight;
        this.check3DBubbleSave = this.chart.bubble3D;
        this.check3DBubble.setSelected(this.check3DBubbleSave);
        this.text3DBubbleLight.setEditable(this.check3DBubbleSave);
        this.checkFillSave = this.chart.bubbleDrawMode == 1;
        this.checkFill.setSelected(this.checkFillSave);
        this.checkBorderSave = this.chart.drawDataBorder;
        this.checkBorder.setSelected(this.checkBorderSave);
        this.check3DBubble.setEnabled(this.checkFillSave);
        this.checkBorder.setEnabled(this.checkFillSave);
    }

    private void setValues() {
        this.chart.axisUnitToRadiusRatio = this.getRatio();
        this.chart.bubbleDrawMode = this.checkFill.isSelected() ? 1 : 0;
        this.chart.drawDataBorder = this.checkBorder.isSelected();
        this.chart.bubble3D = this.check3DBubble.isSelected();
        this.chart.bubble3DLight = this.getLight();
        if (this.check3DBubble.isSelected()) {
            this.chart.setTranslucent(false);
        }
    }

    private double getRatio() {
        double result = this.ratioSave;
        try {
            result = Double.valueOf(this.textRatio.getText());
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.FINEST, "Failed to parse double. Invalid number.", ex);
        }
        return result;
    }

    private int getLight() {
        int light = this.lightSave;
        try {
            light = Double.valueOf(this.text3DBubbleLight.getText()).intValue();
            if (light > 100) {
                light = 100;
            } else if (light < 0) {
                light = 0;
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.FINEST, "Failed to parse integer. Invalid number.", ex);
        }
        return light;
    }

    private boolean isModified() {
        return this.ratioSave != this.getRatio() || this.checkFillSave != this.checkFill.isSelected() || this.checkBorderSave != this.checkBorder.isSelected() || this.lightSave != this.getLight() || this.check3DBubbleSave != this.check3DBubble.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            if (this.isModified()) {
                this.setValues();
                this.chartMain.setModified();
                this.chartMain.qbpaint();
            }
            this.dispose();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this.checkFill) {
            this.checkBorder.setEnabled(this.checkFill.isSelected());
            this.check3DBubble.setEnabled(this.checkFill.isSelected());
        } else if (source == this.check3DBubble) {
            this.text3DBubbleLight.setEditable(this.check3DBubble.isSelected());
        }
    }
}

