/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.applet.Applet;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import quadbase.chart.designer.Alarm;
import quadbase.chart.designer.AlarmTarget;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ChartPanel;
import quadbase.chart.designer.InitPanel;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.ImageCanvas;
import quadbase.common.swing.LoadingScreen;
import quadbase.common.swing.MessageDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class ChartDesignManager
implements AlarmTarget {
    private static final Logger LOGGER = Logger.getLogger(ChartDesignManager.class.getName());
    LoadingScreen loadscr;
    ImageCanvas logo = null;
    String query;
    Alarm alarm = new Alarm(100L, this);
    boolean runview = false;
    InitPanel initPanel;
    JFrame parentFrame;
    ChartMain designer;
    String loginUser;

    public ChartDesignManager(JFrame f, InitPanel p) {
        this.alarm.start();
        this.parentFrame = f;
        this.initPanel = p;
    }

    private void hideLoadingScreen() {
        if (this.loadscr != null) {
            this.loadscr.setVisible(false);
        }
    }

    private void setLoadingScreenText(String text) {
        if (this.loadscr != null) {
            this.loadscr.setText(text);
        }
    }

    private void showLoadingScreen() {
        try {
            if (this.loadscr == null) {
                String logoName = ServerMessage.imagesPath + "cyberLogo.gif";
                Applet applet = ServerMessage.getApplet();
                if (applet == null) {
                    Image image = this.parentFrame.getToolkit().getImage(logoName);
                    this.logo = new ImageCanvas(image);
                    MediaTracker tracker = new MediaTracker(this.logo);
                    tracker.addImage(image, 0);
                    tracker.waitForID(0, 5000L);
                } else {
                    URL u = new URL(applet.getDocumentBase(), logoName);
                    this.logo = new ImageCanvas(u);
                }
                this.loadscr = new LoadingScreen(this.parentFrame, this.logo);
                this.setLoadingScreenText(LanguageEncoder.getText("Loading..."));
            }
            this.loadscr.setVisible(true);
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "Failed to load splash screen", t);
        }
    }

    public boolean loadView() {
        this.runview = false;
        return this.loadchartView();
    }

    private boolean loadchartView() {
        this.query = null;
        this.showLoadingScreen();
        this.alarm.restart();
        return true;
    }

    @Override
    public synchronized void onAlarm(Alarm a) {
        this.setLoadingScreenText(LanguageEncoder.getText("Retrieving data..."));
        try {
            ChartPanel cpanel = new ChartPanel(null);
            this.setLoadingScreenText(LanguageEncoder.getText("Loading..."));
            this.designer = new ChartMain(cpanel);
            this.designer.manager = this;
            this.setLoadingScreenText(LanguageEncoder.getText("Initializing..."));
            this.designer.init();
            this.setLoadingScreenText(LanguageEncoder.getText("Launching..."));
            this.designer.setLoginUser(this.loginUser);
            this.designer.setVisible(true);
            this.hideLoadingScreen();
            this.initPanel.resumeButton();
        }
        catch (Throwable th) {
            LOGGER.log(Level.SEVERE, "Failed to launch ChartDesigner", th);
            new MessageDialog((Frame)this.parentFrame, LanguageEncoder.getText("Error")).show(th.toString());
            this.hideLoadingScreen();
            try {
                this.initPanel.logoutFromServer();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Failed to log out from server", ex2);
            }
            this.initPanel.resumeButton();
        }
    }

    public ChartMain getDesigner() {
        return this.designer;
    }

    public InitPanel getInitPanel() {
        return this.initPanel;
    }

    public void setLoginUser(String user) {
        this.loginUser = user;
    }
}

