/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.common.swing.PanelAction;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;

public class ChartExportPanel
extends PanelAction
implements ItemListener {
    private static final Logger LOGGER = Logger.getLogger(ChartExportPanel.class.getName());
    private static final String PAC = LanguageEncoder.getText("PAC - Chart In Pack Format");
    private static final String PNG = LanguageEncoder.getText("PNG - Portable Network Graphics");
    private static final String TPL = LanguageEncoder.getText("TPL - Chart Template");
    private static final String JPG = LanguageEncoder.getText("JPG - JPEG");
    private static final String BMP = LanguageEncoder.getText("BMP - OS/2 or Windows Bitmap");
    private static final String TXT = LanguageEncoder.getText("TXT - Data Source File");
    private static final String XML = LanguageEncoder.getText("XML - Data Source File");
    private static final String PDF = LanguageEncoder.getText("PDF - ACROBAT");
    private static final String XLS = LanguageEncoder.getText("XLS - MS Excel");
    private static final String SVG = LanguageEncoder.getText("SVG - Scalable Vector Graphics");
    private static final String SWF = LanguageEncoder.getText("SWF - Flash");
    private static final String GIF = LanguageEncoder.getText("GIF - CompuServe");
    private static final String WMF = LanguageEncoder.getText("WMF - Windows Meta File");
    public JTextField edTitle;
    JTextField edLocation;
    JTextField chartTitle;
    JCheckBox chkUpdate;
    JCheckBox chkTitle;
    JCheckBox chkRandomLocation;
    JCheckBox chkSpecificLocation;
    JCheckBox chkTransparent;
    JCheckBox chkGenerateDataMapFile;
    JCheckBox chkGrayScale;
    JComboBox folderChoice;
    public JTextField twidth;
    public JTextField theight;
    JComboBox choiceFormats;
    int width;
    int height;
    int displayUnit;
    LinkedHashMap<String, String> exportExtensionHashMap = new LinkedHashMap();

    public ChartExportPanel(String filename, int w, int h, boolean isBackgroundTransparent, int displayunit) {
        if (filename.endsWith(".tpl") || filename.endsWith(".cht") || filename.endsWith(".pac")) {
            filename = filename.substring(0, filename.length() - 4);
        }
        this.width = w;
        this.height = h;
        this.displayUnit = displayunit;
        this.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        JPanel panel2 = new JPanel();
        panel2.add(new JLabel(LanguageEncoder.getText("Name")));
        this.edTitle = new JTextField(filename, 40);
        panel2.add(this.edTitle);
        JPanel panel3 = new JPanel();
        panel3.setLayout(new FlowLayout(0));
        panel3.add(new JLabel(LanguageEncoder.getText("Save as Type")));
        this.choiceFormats = new JComboBox();
        this.initExportOptions();
        this.choiceFormats.addItemListener(this);
        panel3.add(this.choiceFormats);
        JPanel panel4 = new JPanel();
        panel4.setLayout(new FlowLayout(0));
        panel4.add(new JLabel(LanguageEncoder.getText("width")));
        this.twidth = new JTextField(this.width + "", 5);
        panel4.add(this.twidth);
        panel4.add(new JLabel(LanguageEncoder.getText("height")));
        this.theight = new JTextField(this.height + "", 5);
        panel4.add(this.theight);
        if (this.displayUnit == 0) {
            panel4.add(new JLabel(LanguageEncoder.getText("Pixel")));
        } else if (this.displayUnit == 1) {
            panel4.add(new JLabel(LanguageEncoder.getText("Inch")));
        } else {
            panel4.add(new JLabel(LanguageEncoder.getText("cm")));
        }
        JPanel panel5 = new JPanel();
        panel5.setLayout(new GridLayout(1, -1));
        this.chkTransparent = new JCheckBox(LanguageEncoder.getText("Set Background Transparent"), isBackgroundTransparent);
        panel5.add(this.chkTransparent);
        this.chkGenerateDataMapFile = new JCheckBox(LanguageEncoder.getText("Generate Data Map File"), false);
        panel5.add(this.chkGenerateDataMapFile);
        this.chkGrayScale = new JCheckBox(LanguageEncoder.getText("Use Grayscale"), false);
        panel5.add(this.chkGrayScale);
        JPanel bpanel = new JPanel();
        bpanel.setLayout(new GridLayout(4, 1));
        panel2.setAlignmentX(0.0f);
        panel3.setAlignmentX(0.0f);
        panel4.setAlignmentX(0.0f);
        panel5.setAlignmentX(0.0f);
        bpanel.add(panel2);
        bpanel.add(panel3);
        bpanel.add(panel4);
        bpanel.add(panel5);
        this.choiceFormats.setSelectedIndex(1);
        this.chkTransparent.setEnabled(true);
        this.add("North", bpanel);
        this.edTitle.requestFocus();
    }

    private void initExportOptions() {
        this.putExportFormatToExtensionHashMap(PAC, "pac");
        this.putExportFormatToExtensionHashMap(PNG, "png");
        this.putExportFormatToExtensionHashMap(TPL, "tpl");
        this.putExportFormatToExtensionHashMap(JPG, "jpg");
        this.putExportFormatToExtensionHashMap(BMP, "bmp");
        this.putExportFormatToExtensionHashMap(TXT, "txt");
        this.putExportFormatToExtensionHashMap(XML, "xml");
        this.putExportFormatToExtensionHashMap(PDF, "pdf");
        this.putExportFormatToExtensionHashMap(XLS, "xls");
        this.putExportFormatToExtensionHashMap(SVG, "svg");
        this.putExportFormatToExtensionHashMap(SWF, "swf");
        this.putExportFormatToExtensionHashMap(GIF, "gif");
        try {
            Class<?> objClass = Class.forName("quadbase.util.internal.WMF");
            if (objClass != null) {
                this.putExportFormatToExtensionHashMap(WMF, "wmf");
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to initialize WMF export format", ex);
        }
    }

    private void putExportFormatToExtensionHashMap(String title, String extension) {
        if (!this.exportExtensionHashMap.containsKey(title)) {
            this.exportExtensionHashMap.put(title, "." + extension);
        }
        if (this.choiceFormats != null) {
            this.choiceFormats.addItem(title);
        }
    }

    public String getTitle() {
        return this.edTitle.getText();
    }

    public void setTitle(String title) {
        this.edTitle.setText(title);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.chkSpecificLocation) {
            if (this.chkSpecificLocation.isSelected()) {
                this.edLocation.requestFocus();
            }
        } else {
            int item = this.getChoice();
            boolean b = item != 2 && item != 5 && item != 8 && item != 11 && item != 12 && item != 13 && item != 14 && item != 15 && item != 16 && item != 18;
            this.chkGenerateDataMapFile.setEnabled(b);
            this.chkGrayScale.setEnabled(b);
            this.chkTransparent.setEnabled(item == 1 || item == 10);
        }
    }

    public boolean isUpdateChecked() {
        return this.chkUpdate.isSelected();
    }

    public boolean isTransparent() {
        return this.chkTransparent.isSelected();
    }

    public boolean getGenerateDataMapFile() {
        if (this.chkGenerateDataMapFile.isEnabled()) {
            return this.chkGenerateDataMapFile.isSelected();
        }
        return false;
    }

    public boolean getUseGrayScale() {
        if (this.chkGrayScale.isEnabled()) {
            return this.chkGrayScale.isSelected();
        }
        return false;
    }

    public int processTextField(JTextField txt) {
        int newvalue;
        try {
            double dblvalue = Double.valueOf(txt.getText());
            newvalue = this.displayUnit == 0 ? (int)dblvalue : (this.displayUnit == 1 ? QbUtil.toPixel(dblvalue) : QbUtil.toPixel(dblvalue / 2.54));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to convert units", ex);
            txt.setText(Integer.valueOf(txt == this.twidth ? this.width : this.height).toString());
            return txt == this.twidth ? this.width : this.height;
        }
        if (newvalue < 1 || newvalue > 10000) {
            txt.setText(Integer.valueOf(txt == this.twidth ? this.width : this.height).toString());
            return txt == this.twidth ? this.width : this.height;
        }
        if (txt == this.twidth) {
            this.width = newvalue;
        } else {
            this.height = newvalue;
        }
        return newvalue;
    }

    public final int getChoice() {
        String str = this.choiceFormats.getSelectedItem().toString();
        if (str.equals(GIF)) {
            return 1;
        }
        if (str.equals(BMP)) {
            return 2;
        }
        if (str.equals(TPL)) {
            return 5;
        }
        if (str.equals(JPG)) {
            return 7;
        }
        if (str.equals(WMF)) {
            return 8;
        }
        if (str.equals(PNG)) {
            return 10;
        }
        if (str.equals(TXT)) {
            return 11;
        }
        if (str.equals(XML)) {
            return 12;
        }
        if (str.equals(PDF)) {
            return 13;
        }
        if (str.equals(SVG)) {
            return 14;
        }
        if (str.equals(SWF)) {
            return 15;
        }
        if (str.equals(PAC)) {
            return 16;
        }
        if (str.equals(XLS)) {
            return 18;
        }
        return -1;
    }
}

