/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.applet.Applet;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import quadbase.chart.Area;
import quadbase.chart.Axis;
import quadbase.chart.CAnnotation;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.ColMetaData;
import quadbase.chart.DataAttribute;
import quadbase.chart.DataLine;
import quadbase.chart.DeleteFile;
import quadbase.chart.DrillDownInfo;
import quadbase.chart.DrillDownNode;
import quadbase.chart.DrillHistory;
import quadbase.chart.FaceData;
import quadbase.chart.GraphicsTable;
import quadbase.chart.Grid;
import quadbase.chart.HorzVertLine;
import quadbase.chart.IPieChart;
import quadbase.chart.Legend;
import quadbase.chart.LoadChart;
import quadbase.chart.MultiDimData;
import quadbase.chart.OffsetCString;
import quadbase.chart.Point3D;
import quadbase.chart.PreprocInfo;
import quadbase.chart.QbPattern;
import quadbase.chart.ReadDataFile;
import quadbase.chart.ReloadChart;
import quadbase.chart.SaveChart;
import quadbase.chart.Ticker;
import quadbase.chart.TrendLine;
import quadbase.chart.ValueTable;
import quadbase.chart.chart3d.lib3d.HiddenSurface;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.designer.AggregateDialog;
import quadbase.chart.designer.AggregationDialog;
import quadbase.chart.designer.ApplyGaugeTemplateDialog;
import quadbase.chart.designer.ApproximateDialog;
import quadbase.chart.designer.AxisDialog;
import quadbase.chart.designer.BubbleDialog;
import quadbase.chart.designer.ChartDesignManager;
import quadbase.chart.designer.ChartOptionDialog;
import quadbase.chart.designer.ChartPanel;
import quadbase.chart.designer.ChartToolbar;
import quadbase.chart.designer.ChartViewerDialog;
import quadbase.chart.designer.ChartWizard;
import quadbase.chart.designer.ColumnDialog;
import quadbase.chart.designer.ControlRangeListDialog;
import quadbase.chart.designer.DataBorderDialog;
import quadbase.chart.designer.DataOrderDialog;
import quadbase.chart.designer.DataPropDialog;
import quadbase.chart.designer.DataSourceInfoFrame;
import quadbase.chart.designer.DialDialog;
import quadbase.chart.designer.DrillDownAggregate;
import quadbase.chart.designer.DrillDownDialog;
import quadbase.chart.designer.DrillDownNavigationFrame;
import quadbase.chart.designer.DrillDownTreeModel;
import quadbase.chart.designer.DrillDynamicDialog;
import quadbase.chart.designer.DrillNameDialog;
import quadbase.chart.designer.DrillYesNoDialog;
import quadbase.chart.designer.ExportDialog;
import quadbase.chart.designer.FlashHintBoxDialog;
import quadbase.chart.designer.FontMappingDialog;
import quadbase.chart.designer.FormatTableDialog;
import quadbase.chart.designer.FormatValueDialog;
import quadbase.chart.designer.GanttDialog;
import quadbase.chart.designer.HistogramDialog;
import quadbase.chart.designer.HorzVertLineListDialog;
import quadbase.chart.designer.HyperLinkListDialog;
import quadbase.chart.designer.HyperLinkListForSurfaceDialog;
import quadbase.chart.designer.IByPassSaveAsForChart;
import quadbase.chart.designer.IChartIO;
import quadbase.chart.designer.ImageDialog;
import quadbase.chart.designer.LegendDialog;
import quadbase.chart.designer.LightDialog;
import quadbase.chart.designer.LineDialog;
import quadbase.chart.designer.LinePointDialog;
import quadbase.chart.designer.LineStyleDialog;
import quadbase.chart.designer.ModifyWizard;
import quadbase.chart.designer.NoDataToPlotMessageDialog;
import quadbase.chart.designer.NullDataPropertiesDialog;
import quadbase.chart.designer.OpenSaveDialog;
import quadbase.chart.designer.OptionDialog;
import quadbase.chart.designer.ParamDialog;
import quadbase.chart.designer.PieOptionsDlg;
import quadbase.chart.designer.PlotAreaDialog;
import quadbase.chart.designer.PointDialog;
import quadbase.chart.designer.PolarDialog;
import quadbase.chart.designer.PolyLineDialog;
import quadbase.chart.designer.QbChartDesigner;
import quadbase.chart.designer.RadarDialog;
import quadbase.chart.designer.RecordFrame;
import quadbase.chart.designer.RenderingDialog;
import quadbase.chart.designer.ScheduleDialog;
import quadbase.chart.designer.SizeDialog;
import quadbase.chart.designer.SizeLabel;
import quadbase.chart.designer.TextDialog;
import quadbase.chart.designer.TextPropertiesDialog;
import quadbase.chart.designer.TitleDialog;
import quadbase.chart.designer.TrendLineListDialog;
import quadbase.chart.designer.UpdateDatabaseWizard;
import quadbase.chart.designer.UpdateQueryWizard;
import quadbase.chart.designer.ViewTableFrame;
import quadbase.chart.designer.YAStatusBar;
import quadbase.chart.designer.YesNoDialog;
import quadbase.chart.designer.ZoomDialog;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.swing.AboutDialog;
import quadbase.common.swing.ArrowSlideBar;
import quadbase.common.swing.CanShowHint;
import quadbase.common.swing.FontPanel;
import quadbase.common.swing.ImageCanvas;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.NavigatePanel;
import quadbase.common.swing.OverWriteDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.ToggleButton;
import quadbase.common.swing.YASpeedMeter;
import quadbase.common.swing.ZoomMeter;
import quadbase.common.swing.color.ColorPanel;
import quadbase.common.swing.color.ColorSetPanel;
import quadbase.common.swing.color.PatternPanel;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.internal.CopyFile;
import quadbase.common.util.internal.CustomizeElement;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.OrgUtil;
import quadbase.common.util.internal.QbBrowseDirectories;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.RecentFiles;
import quadbase.datasourcemanager.manager.DataSourceManagerListener;
import quadbase.datasourcemanager.manager.IChangeDataRegistry;
import quadbase.datasourcemanager.manager.IChangeDataRegistryPlus;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.util.ControlRange;
import quadbase.util.HyperLink;
import quadbase.util.IReferenceObj;
import quadbase.util.PickData;
import quadbase.util.PolyLine;

public class ChartMain
extends JFrame
implements ActionListener,
ItemListener,
WindowListener,
ComponentListener,
ChangeListener {
    public static final String CLOSE_QUESTION = LanguageEncoder.getText("Save changes before exit?");
    public static final String SAVE_QUESTION = LanguageEncoder.getText("Save changes?");
    public static final String BEAN_CLOSE_QUESTION = LanguageEncoder.getText("Update changes to bean before exit?");
    public static final String BACKGROUND_IMG = "backgroundImages/";
    public static final int PIXEL = 0;
    public static final int INCH = 1;
    public static final int CM = 2;
    public static final int width = 640;
    public static final int height = 480;
    private static final Logger LOGGER = Logger.getLogger(ChartMain.class.getName());
    public ChartPanel chartPanel;
    public PatternPanel patternPanel;
    public int currentLevel = -1;
    public ChartWizard chartWizard = null;
    public int displayUnit = 0;
    protected boolean modified;
    protected JMenu drillDownmenu;
    protected JMenu linkParamMenu;
    protected JMenuItem closeitem;
    protected JMenuItem saveitem;
    protected JMenuItem saveasitem;
    protected JMenuItem templateitem;
    protected JMenuItem exportitem;
    protected JMenuItem newitem;
    protected JMenuItem openitem;
    protected JMenuItem exititem;
    protected JMenuItem linkitem;
    protected JMenuItem vieweritem;
    protected JMenuItem aboutitem;
    protected JMenuItem zoomitem;
    protected JMenuItem histogramitem;
    protected JMenuItem optionsitem;
    protected JMenuItem aggregationItem;
    protected JMenuItem orderingitem;
    protected JMenuItem refreshitem;
    protected JMenuItem schedulerefreshitem;
    protected JMenuItem modifydataitem;
    protected JMenuItem modifyparamitem;
    protected JMenuItem modifydbitem;
    protected JMenuItem modifysqlitem;
    protected JMenuItem undoitem;
    protected JMenuItem redoitem;
    protected JMenuItem display3DOptionItem;
    protected JMenuItem lightingModelItem;
    protected JMenuItem controlAreaItem;
    protected boolean allowOpeningSaveAsDialogForSaveColorsForCategories = false;
    protected boolean isForBean = false;
    protected ActionListener actionListener;
    JPanel mainPanel;
    ToggleButton animateButton;
    ToggleButton frameButton;
    ToggleButton frameBorderButton;
    ToggleButton inLineSeriesButton;
    ToggleButton gouraudButton;
    JMenuBar menubar;
    JMenu filemenu;
    JMenu helpmenu;
    JMenu editmenu;
    JMenu formatmenu;
    JMenu chartTypemenu;
    JMenu datamenu;
    JMenu layoutmenu;
    JMenuItem dialForegroundImage;
    JMenuItem dialBackgroundImage;
    NavigatePanel navigatePanel;
    ZoomMeter zoomMeter;
    YASpeedMeter speedMeter;
    Chart chart;
    boolean[] oldTickerState = new boolean[4];
    boolean rotateMode = true;
    JPanel navigateAll;
    JPanel globalPanel;
    ArrowSlideBar slideBar;
    double increment = 0.10471975511965977;
    int movement = 33;
    ColorPanel colorpanel;
    JPanel centerPanel;
    FontPanel fontpanel;
    JPanel cfpanel;
    ColorSetPanel csPanel;
    ChartDesignManager manager = null;
    QbChartDesigner qbChartDesigner = null;
    String filename;
    CanShowHint statusBar;
    boolean cfexist = true;
    boolean toolbarExist = false;
    boolean bchart2d;
    boolean navexist = true;
    boolean loading = false;
    ExportDialog exportDialog;
    SizeLabel sizelabel;
    ArrowSlideBar xscale_bar;
    ArrowSlideBar yscale_bar;
    ArrowSlideBar zscale_bar;
    ArrowSlideBar xlight_bar;
    ArrowSlideBar ylight_bar;
    ArrowSlideBar zlight_bar;
    ArrowSlideBar thickness_bar;
    boolean oldTopValueState;
    boolean oldTopValueState2;
    boolean oldAntiAliasState;
    OptionDialog optionDialog;
    DrillDownDialog drillDialog;
    DrillDownAggregate drillAggDialog;
    ChartToolbar toolbar;
    boolean isnew2DChart;
    int newchartType;
    boolean viewmode = false;
    boolean refresh = true;
    boolean isOpen;
    MessageDialog checksaveDialog;
    MessageDialog exitdialog;
    boolean actionCallback = false;
    boolean isClose = false;
    boolean skipClosingCommand = false;
    boolean firstErrorEncounter = true;
    JMenuItem gobackItem;
    Vector<Object> linkhistory = new Vector();
    boolean bgoback = false;
    boolean bgoback2 = false;
    boolean doClose = false;
    JMenuItem drilloptionsitem;
    JMenuItem drillGoToTopitem;
    JMenuItem drillPreviousitem;
    JMenuItem drillNextitem;
    JMenuItem drillRemoveitem;
    JMenuItem drillRemoveAllitem;
    JMenuItem drillDynamicitem;
    JMenuItem drillNavigateItem;
    MessageDialog evalBox;
    Chart parentChart = null;
    boolean isDrillDownDefined = false;
    String drillTemplateName = null;
    String oldTitle = null;
    String lastDir = "";
    MessageDialog drillsaveDialog;
    MessageDialog checkRemoveDialog = null;
    boolean ignoreSave = false;
    boolean nextDrill = false;
    boolean previousDrill = false;
    boolean isNewDrillLevel = false;
    boolean isOkToChange = true;
    DrillHistory drillHistory = null;
    Vector<ColMetaData> originalMetaData = null;
    ColData[] originalColData = null;
    ValueTable valueTableSave;
    RecordFrame recordFrame;
    ViewTableFrame viewTableFrame;
    DataSourceInfoFrame dataSourceInfoFrame = null;
    boolean changeType = false;
    boolean firstRemovePanel = true;
    Vector<Color> recentColors = new Vector();
    RecentFileOpener recentFileOpener = new RecentFileOpener();
    private MessageDialog closedialog;
    private JPanel buttonPanel;
    private IChartIO chartIO;
    private IByPassSaveAsForChart byPassSaveAs;
    private DBInfoBasic presetDBInfo = null;
    private Manager presetManager = null;
    private QueryInParamSet presetQueryInParamSet = null;
    private String presetDataRegistry = null;
    private BrowseDirectories browseDir;
    private Vector<String> dataRegHiddenNodes = null;
    private boolean isSaveOnExit = true;
    private boolean enableItemStateChanged = true;
    private boolean initializing = false;
    private DrillDownNavigationFrame drillDownNavigationFrame;
    private JTree drillDownTree = null;
    private boolean forceNewChart = false;
    private String[] defaultParamNames = null;
    private Vector<DataSourceManagerListener> managerListeners = null;
    private String loginUser;
    private String QLOGO = CustomizeElement.getCustomData("[ERES Organizer][Images][Chart Designer Frame Icon]", ServerMessage.imagesPath + "QuadLogo.png");
    private JTabbedPane tabbedPane;
    private Vector<Chart> undoChartList = new Vector();
    private Vector<Chart> redoChartList = new Vector();
    private Chart backupChart = null;
    private boolean showReportDataHasChangedDialog = false;

    public ChartMain(ChartPanel _chartPanel) {
        this.chartPanel = _chartPanel;
        this.chart = this.chartPanel.chart;
        this.chartPanel.progressiveDraw = false;
        this.addWindowListener(this);
        this.addComponentListener(this);
        this.browseDir = new QbBrowseDirectories();
    }

    public boolean isChangeDataRegistryEnabled() {
        return false;
    }

    public IChangeDataRegistry getChangeDataRegObj() {
        return null;
    }

    public IChangeDataRegistryPlus getChangeDataRegPlusObj() {
        return null;
    }

    public boolean canModify() {
        return true;
    }

    public boolean hasBean() {
        return this.isForBean;
    }

    public void setBean(boolean bean) {
        this.isForBean = bean;
    }

    public boolean showNavButtons() {
        return this.navexist;
    }

    public void addRecentColor(Color newColor) {
        if (!this.recentColors.contains(newColor)) {
            this.recentColors.insertElementAt(newColor, 0);
        }
    }

    public Vector<Color> getRecentColors() {
        return this.recentColors;
    }

    public void setRecentColors(Vector<Color> colors) {
        this.recentColors = colors;
    }

    public Color[] getRecentColorArray() {
        Color[] colors = new Color[this.recentColors.size()];
        for (int i = 0; i < this.recentColors.size(); ++i) {
            colors[i] = this.recentColors.elementAt(i);
        }
        return colors;
    }

    public void setFileName(String name) {
        this.filename = name;
        if (this.filename != null) {
            this.setTitle(name);
        } else if (CustomizeElement.isERES()) {
            this.setTitle(CustomizeElement.getCustomData("[ERES Organizer][Text][Chart Designer Title]", LanguageEncoder.getText("Chart Designer")));
        } else {
            this.setTitle(CustomizeElement.getCustomData("[Organizer][Text][Chart Designer Title]", LanguageEncoder.getText("Chart Designer")));
        }
    }

    public void setFilenameToNull() {
        this.filename = null;
        if (CustomizeElement.isERES()) {
            this.setTitle(CustomizeElement.getCustomData("[ERES Organizer][Text][Chart Designer Title]", LanguageEncoder.getText("Chart Designer")));
        } else {
            this.setTitle(CustomizeElement.getCustomData("[Organizer][Text][Chart Designer Title]", LanguageEncoder.getText("Chart Designer")));
        }
    }

    public void init() {
        boolean isInited = this.initializing;
        this.initializing = true;
        if (this.viewmode) {
            this.toolbarExist = false;
            this.cfexist = false;
            this.navexist = false;
        }
        CustomizeElement.load();
        this.QLOGO = CustomizeElement.getCustomData("[ERES Organizer][Images][Chart Designer Frame Icon]", ServerMessage.imagesPath + "QuadLogo.png");
        Dimension screensize = this.getToolkit().getScreenSize();
        this.setLocation((screensize.width - 640) / 2, (screensize.height - 480) / 2);
        this.globalPanel = new JPanel();
        this.globalPanel.setBackground(Color.lightGray);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.globalPanel.setLayout(new BorderLayout());
        this.toolbar = new ChartToolbar(this);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        if (System.getProperty("java.vendor.url").indexOf("microsoft") >= 0) {
            this.mainPanel.add("Center", this.chartPanel);
        } else {
            this.mainPanel.add("Center", this.chartPanel.getScrollPane());
        }
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add("Center", this.mainPanel);
        this.colorpanel = new ColorPanel(this, Color.red, 6, 7);
        this.colorpanel.addActionListener(this);
        this.fontpanel = new FontPanel(CString.defaultfont);
        this.cfpanel = new JPanel();
        this.cfpanel.setLayout(new BorderLayout());
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new BorderLayout());
        cPanel.add("Center", this.colorpanel);
        this.csPanel = new ColorSetPanel();
        this.csPanel.addActionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.csPanel, 20, 31);
        scrollPane.setPreferredSize(new Dimension(210, -1));
        if (IOUtil.isJava14() && IOUtil.isJava2D()) {
            this.patternPanel = new PatternPanel(null, 6, 5);
            this.patternPanel.setPatternColor(this.colorpanel.getColor());
            this.patternPanel.addActionListener(this);
            this.tabbedPane = new JTabbedPane();
            this.tabbedPane.addTab(LanguageEncoder.getText("Color"), cPanel);
            this.tabbedPane.addTab(LanguageEncoder.getText("Color Set"), scrollPane);
            this.tabbedPane.addTab(LanguageEncoder.getText("Pattern"), this.patternPanel);
            this.tabbedPane.addChangeListener(this);
            this.cfpanel.add("Center", this.tabbedPane);
        } else {
            this.cfpanel.add("Center", cPanel);
        }
        JPanel dpcfPanel = new JPanel(new BorderLayout());
        this.fontpanel.setPreferredSize(new Dimension(-1, 125));
        dpcfPanel.add("North", this.fontpanel);
        this.cfpanel.add("South", dpcfPanel);
        this.fontpanel.addActionListener(this);
        this.cfpanel.setVisible(this.cfexist);
        this.centerPanel.add("East", this.cfpanel);
        this.globalPanel.add("Center", this.centerPanel);
        this.toolbar.setVisible(this.toolbarExist);
        contentPane.add("North", this.toolbar);
        contentPane.add("Center", this.globalPanel);
        this.sizelabel = new SizeLabel(this);
        JPanel bottombar = new JPanel();
        bottombar.setLayout(new BorderLayout());
        this.statusBar = new YAStatusBar();
        bottombar.add("Center", (Component)((Object)this.statusBar));
        bottombar.add("East", this.sizelabel);
        if (!this.viewmode) {
            this.globalPanel.add("South", bottombar);
        }
        ((YAStatusBar)this.statusBar).setDelay(100000L);
        this.navigatePanel = new NavigatePanel(50, 50);
        this.navigatePanel.addActionListener(this);
        this.navigatePanel.setHint(this.statusBar, LanguageEncoder.getText("Navigation - Press the center button to toggle between rotation and translation"));
        this.slideBar = new ArrowSlideBar(0.0, 1000.0, false);
        this.slideBar.setHint(this.statusBar, LanguageEncoder.getText("Adjust step size of navigation"));
        this.slideBar.setDValue(1000.0 * (this.increment - 0.002) / 0.3121592653589793);
        this.slideBar.addChangeListener(this);
        this.zoomMeter = new ZoomMeter(80, 40, 0.0, 100.0, 20);
        this.zoomMeter.setHint(this.statusBar, LanguageEncoder.getText("Zoom in / Zoom out"));
        this.zoomMeter.addActionListener(this);
        if (this.chart != null) {
            this.zoomMeter.setValue(100.0f * (1.0f - this.chart.getZoomfactor() / 4000.0f));
        }
        this.speedMeter = new YASpeedMeter(0.0017453292519943296, 0.3141592653589793);
        this.speedMeter.setHint(this.statusBar, LanguageEncoder.getText("Speed of Animation"));
        this.speedMeter.addActionListener(this);
        if (this.chart != null) {
            this.speedMeter.setValue(this.chart.getAnimateSpeed());
        }
        this.xscale_bar = new ArrowSlideBar(0.01, 5.0, false);
        if (this.chart != null) {
            this.xscale_bar.setDValue(this.chart.getX_scale());
        } else {
            this.xscale_bar.setDValue(1.0);
        }
        this.xscale_bar.setHint(this.statusBar, LanguageEncoder.getText("Scaling in X dimension"));
        this.xscale_bar.addChangeListener(this);
        this.yscale_bar = new ArrowSlideBar(0.01, 5.0, false);
        if (this.chart != null) {
            this.yscale_bar.setDValue(this.chart.getY_scale());
        } else {
            this.yscale_bar.setDValue(1.0);
        }
        this.yscale_bar.setHint(this.statusBar, LanguageEncoder.getText("Scaling in Y dimension"));
        this.yscale_bar.addChangeListener(this);
        this.zscale_bar = new ArrowSlideBar(0.01, 5.0, false);
        if (this.chart != null) {
            this.zscale_bar.setDValue(this.chart.getZ_scale());
        } else {
            this.zscale_bar.setDValue(1.0);
        }
        this.zscale_bar.setHint(this.statusBar, LanguageEncoder.getText("Scaling in Z dimension"));
        this.zscale_bar.addChangeListener(this);
        this.thickness_bar = new ArrowSlideBar(0.333, 3.0, false);
        if (this.chart != null) {
            this.thickness_bar.setDValue(this.chart.thickRatio);
        }
        this.thickness_bar.setHint(this.statusBar, LanguageEncoder.getText("Thickness of shape"));
        this.thickness_bar.addChangeListener(this);
        this.xlight_bar = new ArrowSlideBar(-1000.0, 1000.0, false);
        this.ylight_bar = new ArrowSlideBar(-1000.0, 1000.0, false);
        this.zlight_bar = new ArrowSlideBar(-1000.0, 1000.0, false);
        this.xlight_bar.addChangeListener(this);
        this.ylight_bar.addChangeListener(this);
        this.zlight_bar.addChangeListener(this);
        this.xlight_bar.setHint(this.statusBar, LanguageEncoder.getText("Light X position"));
        this.ylight_bar.setHint(this.statusBar, LanguageEncoder.getText("Light Y position"));
        this.zlight_bar.setHint(this.statusBar, LanguageEncoder.getText("Light Z position"));
        this.frameButton = new ToggleButton();
        this.addNewButton(this.frameButton, this.statusBar, LanguageEncoder.getText("Toggle between wireframe and solid mode"), "nav_frame");
        this.frameBorderButton = new ToggleButton();
        this.addNewButton(this.frameBorderButton, this.statusBar, LanguageEncoder.getText("Toggle on/off border drawing"), "nav_flatFrame");
        this.inLineSeriesButton = new ToggleButton();
        this.addNewButton(this.inLineSeriesButton, this.statusBar, LanguageEncoder.getText("Toggle on/off draw series in-line"), "nav_inLineSeries");
        this.gouraudButton = new ToggleButton();
        this.addNewButton(this.gouraudButton, this.statusBar, LanguageEncoder.getText("Toggle on/off Gouraud Shading"), "nav_gouraud");
        this.setGouraudButtonEnabled();
        this.animateButton = new ToggleButton();
        this.addNewButton(this.animateButton, this.statusBar, LanguageEncoder.getText("Toggle on/off animation"), "nav_animate");
        this.navigateAll = new JPanel();
        this.navigateAll.setLayout(new FlowLayout());
        Dimension vslideDim = new Dimension(20, 70);
        this.thickness_bar.setPreferredSize(vslideDim);
        this.slideBar.setPreferredSize(vslideDim);
        this.xlight_bar.setPreferredSize(vslideDim);
        this.ylight_bar.setPreferredSize(vslideDim);
        this.zlight_bar.setPreferredSize(vslideDim);
        this.xscale_bar.setPreferredSize(vslideDim);
        this.yscale_bar.setPreferredSize(vslideDim);
        this.zscale_bar.setPreferredSize(vslideDim);
        this.thickness_bar.setPreferredSize(vslideDim);
        this.navigateAll.add(this.slideBar);
        this.navigateAll.add(this.xlight_bar);
        this.navigateAll.add(this.ylight_bar);
        this.navigateAll.add(this.zlight_bar);
        this.navigateAll.add(this.navigatePanel);
        this.navigateAll.add(this.zoomMeter);
        this.navigateAll.add(this.xscale_bar);
        this.navigateAll.add(this.yscale_bar);
        this.navigateAll.add(this.zscale_bar);
        this.navigateAll.add(this.thickness_bar);
        this.navigateAll.add(this.speedMeter);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridLayout(1, 0));
        this.buttonPanel.add(this.frameButton);
        this.buttonPanel.add(this.frameBorderButton);
        if (this.chart != null && this.isInLineSeriesEnabled(this.chart)) {
            this.buttonPanel.add(this.inLineSeriesButton);
            this.inLineSeriesButton.setSelected(this.chart.isDrawSeriesOnCategoryAxis());
        }
        this.buttonPanel.add(this.gouraudButton);
        this.buttonPanel.add(this.animateButton);
        this.navigateAll.add(this.buttonPanel);
        if (this.chart != null && !this.chart.is2DimChart() && this.navexist) {
            this.centerPanel.add("South", this.navigateAll);
        }
        this.setTitle(CustomizeElement.getCustomData("[ERES Organizer][Text][Chart Designer Title]", LanguageEncoder.getText("Chart Designer")));
        this.setIconImage(IOUtil.getImage(this.QLOGO));
        this.menubar = new JMenuBar();
        this.filemenu = new JMenu(LanguageEncoder.getText("File"));
        this.newitem = this.newMenuItem(LanguageEncoder.getText("New..."), 78);
        this.openitem = this.newMenuItem(LanguageEncoder.getText("Open..."), 79);
        this.closeitem = this.newMenuItem(LanguageEncoder.getText("Close"), 127);
        this.saveitem = this.newMenuItem(LanguageEncoder.getText("Save"), 83);
        this.saveasitem = this.newMenuItem(LanguageEncoder.getText("Save As..."), 127);
        this.templateitem = this.newMenuItem(LanguageEncoder.getText("Apply Template..."), 127);
        this.exportitem = this.newMenuItem(LanguageEncoder.getText("Export..."), 127);
        this.exititem = this.newMenuItem(LanguageEncoder.getText("Exit"), 127);
        if (!this.viewmode) {
            if (!this.isForBean) {
                this.filemenu.add(this.newitem);
            }
            this.filemenu.add(this.openitem);
            if (!this.isForBean) {
                this.filemenu.add(this.closeitem);
            }
            this.filemenu.add(this.templateitem);
            this.filemenu.addSeparator();
            if (!this.isForBean) {
                this.filemenu.add(this.saveitem);
            }
            if (!this.isForBean) {
                this.filemenu.add(this.saveasitem);
            }
            if (!this.isForBean && !this.isSaas()) {
                this.filemenu.add(this.exportitem);
            }
            if (!this.isForBean) {
                this.filemenu.addSeparator();
            }
        }
        if (this.isForBean) {
            this.filemenu.add(this.newMenuItem(LanguageEncoder.getText("Reset"), 127));
            this.filemenu.add(this.newMenuItem(LanguageEncoder.getText("Update"), 127));
            this.filemenu.addSeparator();
        }
        this.filemenu.add(this.exititem);
        this.menubar.add(this.filemenu);
        if (!this.viewmode) {
            this.editmenu = new JMenu(LanguageEncoder.getText("Insert"));
            this.editmenu.add(this.newMenuItem(LanguageEncoder.getText("Titles..."), 127));
            this.editmenu.add(this.newMenuItem(LanguageEncoder.getText("Text..."), 127));
            this.editmenu.add(this.newMenuItem(LanguageEncoder.getText("Background..."), 127));
            this.dialForegroundImage = this.newMenuItem(LanguageEncoder.getText("Dial Foreground..."), 127);
            this.editmenu.add(this.dialForegroundImage);
            this.dialBackgroundImage = this.newMenuItem(LanguageEncoder.getText("Dial Background..."), 127);
            this.editmenu.add(this.dialBackgroundImage);
            this.linkitem = this.newMenuItem(LanguageEncoder.getText("Link..."), 127);
            this.editmenu.add(this.linkitem);
            this.editmenu.add(this.newMenuItem(LanguageEncoder.getText("Line"), 127));
            this.editmenu.add(this.newMenuItem(LanguageEncoder.getText("TrendLine..."), 127));
            this.editmenu.add(this.newMenuItem(LanguageEncoder.getText("Horz/Vert Line..."), 127));
            this.controlAreaItem = this.newMenuItem(LanguageEncoder.getText("Control Area..."), 127);
            this.editmenu.add(this.controlAreaItem);
            this.menubar.add(this.editmenu);
            this.formatmenu = new JMenu(LanguageEncoder.getText("Format"));
            this.undoitem = this.newMenuItem(LanguageEncoder.getText("Undo"), 127);
            this.formatmenu.add(this.undoitem);
            this.undoitem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
            this.redoitem = this.newMenuItem(LanguageEncoder.getText("Redo"), 127);
            this.formatmenu.add(this.redoitem);
            this.redoitem.setAccelerator(KeyStroke.getKeyStroke(89, 2));
            this.formatmenu.addSeparator();
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("Data Properties..."), 127));
            this.histogramitem = this.newMenuItem(LanguageEncoder.getText("Histogram Options..."), 127);
            this.formatmenu.add(this.histogramitem);
            this.aggregationItem = this.newMenuItem(LanguageEncoder.getText("Aggregation Options..."), 127);
            this.formatmenu.add(this.aggregationItem);
            this.zoomitem = this.newMenuItem(LanguageEncoder.getText("Time Zooming Options..."), 127);
            this.formatmenu.add(this.zoomitem);
            this.formatmenu.addSeparator();
            this.display3DOptionItem = this.newMenuItem(LanguageEncoder.getText("3D Display Options..."), 127);
            this.formatmenu.add(this.display3DOptionItem);
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("Rendering Options..."), 127));
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("Font Mapping..."), 127));
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("Chart Options..."), 127));
            this.formatmenu.addSeparator();
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("Axis Scale..."), 127));
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("Axis Elements..."), 127));
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("Canvas..."), 127));
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("Data Border..."), 127));
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("Legend..."), 127));
            this.lightingModelItem = this.newMenuItem(LanguageEncoder.getText("Lighting Model..."), 127);
            this.formatmenu.add(this.lightingModelItem);
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("Line and Point..."), 127));
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("Plot Area..."), 127));
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("No Data To Plot Message..."), 127));
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("Flash Hintbox Customization..."), 127));
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("NULL Data Properties..."), 127));
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("Table..."), 127));
            this.formatmenu.add(this.newMenuItem(LanguageEncoder.getText("Text Properties..."), 127));
            this.menubar.add(this.formatmenu);
            this.chartTypemenu = new JMenu(LanguageEncoder.getText("Type"));
            this.chartTypemenu.add(this.newCheckboxMenuItem(LanguageEncoder.getText("2D Chart")));
            this.chartTypemenu.add(this.newCheckboxMenuItem(LanguageEncoder.getText("3D Chart")));
            this.chartTypemenu.addSeparator();
            for (String element : Chart.stypeName) {
                this.chartTypemenu.add(this.newCheckboxMenuItem(LanguageEncoder.getText(element)));
            }
            if (this.chart != null) {
                this.setMenu(this.chart.is2DimChart(), this.chart.chartType);
                if (this.chart.isHistogram()) {
                    this.setMenuForHistogram(false);
                }
            }
            this.menubar.add(this.chartTypemenu);
            this.drillDownmenu = new JMenu(LanguageEncoder.getText("Drill-Down"));
            this.drilloptionsitem = this.newMenuItem(LanguageEncoder.getText("Add..."), 127);
            this.drillDownmenu.add(this.drilloptionsitem);
            this.drillRemoveitem = this.newMenuItem(LanguageEncoder.getText("Remove This..."), 127);
            this.drillDownmenu.add(this.drillRemoveitem);
            this.drillRemoveAllitem = this.newMenuItem(LanguageEncoder.getText("Remove All..."), 127);
            this.drillDownmenu.add(this.drillRemoveAllitem);
            this.drillPreviousitem = this.newMenuItem(LanguageEncoder.getText("Previous..."), 127);
            this.drillDownmenu.add(this.drillPreviousitem);
            this.drillNextitem = this.newMenuItem(LanguageEncoder.getText("Next..."), 127);
            this.drillDownmenu.add(this.drillNextitem);
            this.drillGoToTopitem = this.newMenuItem(LanguageEncoder.getText("Go To Top Level..."), 127);
            this.drillDownmenu.add(this.drillGoToTopitem);
            this.drillDownmenu.addSeparator();
            this.drillDynamicitem = this.newMenuItem(LanguageEncoder.getText("Dynamic..."), 127);
            this.drillDownmenu.add(this.drillDynamicitem);
            this.drillDownmenu.addSeparator();
            this.drillNavigateItem = this.newMenuItem(LanguageEncoder.getText("Parameter Drill Down..."), 127);
            this.drillDownmenu.add(this.drillNavigateItem);
            this.menubar.add(this.drillDownmenu);
            this.datamenu = new JMenu(LanguageEncoder.getText("Data"));
            this.optionsitem = this.newMenuItem(LanguageEncoder.getText("Modify Data Mapping"), 127);
            this.datamenu.add(this.optionsitem);
            this.modifydataitem = this.newMenuItem(LanguageEncoder.getText("Modify Data Source"), 127);
            this.datamenu.add(this.modifydataitem);
            this.modifydataitem.setEnabled(false);
            this.modifydbitem = this.newMenuItem(LanguageEncoder.getText("Modify Database"), 127);
            this.datamenu.add(this.modifydbitem);
            this.modifydbitem.setEnabled(false);
            this.modifysqlitem = this.newMenuItem(LanguageEncoder.getText("Modify Query"), 127);
            this.datamenu.add(this.modifysqlitem);
            this.modifysqlitem.setEnabled(false);
            this.modifyparamitem = this.newMenuItem(LanguageEncoder.getText("Query Parameters"), 127);
            this.datamenu.add(this.modifyparamitem);
            this.modifyparamitem.setEnabled(false);
            this.orderingitem = this.newMenuItem(LanguageEncoder.getText("Ordering"), 127);
            this.datamenu.add(this.orderingitem);
            this.datamenu.addSeparator();
            this.refreshitem = this.newMenuItem(LanguageEncoder.getText("Refresh"), 127);
            this.datamenu.add(this.refreshitem);
            if (!this.isForBean) {
                this.schedulerefreshitem = this.newMenuItem(LanguageEncoder.getText("Schedule Refresh"), 127);
                this.datamenu.add(this.schedulerefreshitem);
            }
            this.datamenu.addSeparator();
            this.datamenu.add(this.newMenuItem(LanguageEncoder.getText("View Table"), 127));
            this.datamenu.add(this.newMenuItem(LanguageEncoder.getText("View Chart Data"), 127));
            this.datamenu.add(this.newMenuItem(LanguageEncoder.getText("View Data Source Info"), 127));
            this.datamenu.addSeparator();
            this.gobackItem = this.newMenuItem(LanguageEncoder.getText("Go Back"), 127);
            this.datamenu.add(this.gobackItem);
            this.gobackItem.setEnabled(false);
            this.menubar.add(this.datamenu);
            this.layoutmenu = new JMenu(LanguageEncoder.getText("Layout"));
            this.layoutmenu.add(this.newCheckboxMenuItem(LanguageEncoder.getText("Show Font/Color Panel")));
            this.layoutmenu.add(this.newCheckboxMenuItem(LanguageEncoder.getText("Show Navigation Panel")));
            this.layoutmenu.add(this.newCheckboxMenuItem(LanguageEncoder.getText("Show Toolbar")));
            ((JCheckBoxMenuItem)this.layoutmenu.getItem(0)).setSelected(this.cfexist);
            ((JCheckBoxMenuItem)this.layoutmenu.getItem(1)).setSelected(this.navexist);
            ((JCheckBoxMenuItem)this.layoutmenu.getItem(2)).setSelected(this.toolbarExist);
            this.menubar.add(this.layoutmenu);
            this.helpmenu = new JMenu(LanguageEncoder.getText("Help"));
            this.aboutitem = this.newMenuItem(LanguageEncoder.getText("About..."), 127);
            this.helpmenu.add(this.aboutitem);
            if (!this.isForBean) {
                this.helpmenu.add(this.newMenuItem(LanguageEncoder.getText("Contents..."), 127));
            }
            if (ServerMessage.isEvalVersion()) {
                this.helpmenu.add(this.newMenuItem(LanguageEncoder.getText("Order..."), 127));
            }
            this.menubar.add(this.helpmenu);
            this.enableUndoRedoButtons();
        }
        this.getRootPane().setJMenuBar(this.menubar);
        this.chartPanel.setFrame(this);
        this.setSize(640, 480);
        this.chartPanel.addActionListener(this);
        if (this.chart == null) {
            this.do_disable();
        }
        QueryFileInfo.setParentFrame(this);
        this.setPosition();
        this.initializing = isInited;
    }

    DBInfoBasic getPresetDBInfo() {
        return this.presetDBInfo;
    }

    void setPresetDBInfo(DBInfoBasic dbInfo) {
        this.presetDBInfo = dbInfo;
    }

    public Manager getPresetManager() {
        return this.presetManager;
    }

    public void setPresetManager(Manager manager) {
        this.presetManager = manager;
    }

    QueryInParamSet getPresetQueryInParamSet() {
        return this.presetQueryInParamSet;
    }

    void setPresetQueryInParamSet(QueryInParamSet inSet) {
        this.presetQueryInParamSet = inSet;
    }

    public String getPresetDataRegistry() {
        return this.presetDataRegistry;
    }

    public void setPresetDataRegistry(String dataReg) {
        this.presetDataRegistry = dataReg;
    }

    public BrowseDirectories getBrowseDirectories() {
        return this.browseDir;
    }

    public void setBrowseDirectories(BrowseDirectories browseDir) {
        this.browseDir = browseDir;
    }

    public Vector<String> getDataRegistryHiddenNodes() {
        return this.dataRegHiddenNodes;
    }

    public void setDataRegistryHiddenNodes(Vector<String> vec) {
        this.dataRegHiddenNodes = vec;
    }

    protected void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        dim.height = (int)((double)screenSize.height * 0.8);
        dim.width = (int)((double)screenSize.width * 0.76);
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    public void do_CloseChart() {
        if (this.modified && this.chart != null) {
            this.doClose = true;
            this.checksaveDialog = new MessageDialog(this, LanguageEncoder.getText("Question"), true, true, LanguageEncoder.getText("Yes") + "," + LanguageEncoder.getText("No"));
            this.checksaveDialog.addActionListener(this);
            this.checksaveDialog.show(SAVE_QUESTION);
            return;
        }
        this.do_Close();
    }

    private void addNewButton(ToggleButton newBtn, Object statusBar, String tip, String img) {
        img = ServerMessage.imagesPath + img + ".gif";
        try {
            this.setIcon(newBtn, img);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error loading image icon: " + img, e);
        }
        newBtn.setHint(statusBar, tip);
        newBtn.setMargin(new Insets(0, 0, 0, 0));
        newBtn.addActionListener(this);
    }

    private void setIcon(AbstractButton b, String img) throws MalformedURLException {
        b.setIcon(IOUtil.getImageIcon(img));
    }

    void do_Close() {
        if (this.modified && this.chart != null) {
            this.doClose = true;
            this.checksaveDialog = new MessageDialog(this, LanguageEncoder.getText("Question"), true, true, LanguageEncoder.getText("Yes") + "," + LanguageEncoder.getText("No") + "," + LanguageEncoder.getText("Cancel"));
            this.checksaveDialog.addActionListener(this);
            this.checksaveDialog.show(SAVE_QUESTION);
            return;
        }
        if (this.drillDownNavigationFrame != null) {
            try {
                this.drillDownNavigationFrame.setVisible(false);
                this.drillDownNavigationFrame = null;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to close drilldown navigation frame", ex);
            }
        }
        this.chartPanel.chart = null;
        this.chart = null;
        this.drillTemplateName = null;
        this.parentChart = null;
        this.isDrillDownDefined = false;
        this.drillTemplateName = null;
        this.originalMetaData = null;
        this.originalColData = null;
        this.drillHistory = null;
        this.oldTitle = null;
        this.enableNonDrillDownMenu(true);
        this.enableZoomHistOptions(true);
        this.do_disable();
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.remove(this.toolbar);
        if (this.toolbarExist) {
            this.do_ToggleToolbar();
        }
        contentPane.add("North", this.toolbar);
        this.chartPanel.chart = null;
        this.mainPanel.validate();
        this.centerPanel.validate();
        this.globalPanel.validate();
        contentPane.validate();
        if (!this.firstRemovePanel && System.getProperty("java.vendor.url").indexOf("microsoft") >= 0) {
            this.firstRemovePanel = true;
            this.mainPanel.remove(this.chartPanel.getScrollPane());
            this.mainPanel.add("Center", this.chartPanel);
        }
        this.validate();
    }

    public void do_New() {
        if (this.isDrillDownDefined && this.parentChart != null && this.parentChart.getDrillNumber() > 0) {
            this.showHint(LanguageEncoder.getText("This function is only available for top level chart"), true);
            return;
        }
        if (this.modified && this.chart != null) {
            this.actionCallback = true;
            this.isOpen = false;
            this.checksaveDialog = new MessageDialog(this, LanguageEncoder.getText("Question"), true, true, LanguageEncoder.getText("Yes") + "," + LanguageEncoder.getText("No") + "," + LanguageEncoder.getText("Cancel"));
            this.checksaveDialog.addActionListener(this);
            this.checksaveDialog.show(SAVE_QUESTION);
            return;
        }
        try {
            if (this.chartWizard != null && this.chartWizard.isVisible() || this.chartWizard != null && this.chartWizard.manager != null && this.chartWizard.manager.isVisible()) {
                return;
            }
            if (this.presetDBInfo != null) {
                this.chartWizard = new ChartWizard(this, this.presetDBInfo, this.presetQueryInParamSet, true);
                this.chartWizard.setVisible(true);
            } else if (this.presetManager != null) {
                this.chartWizard = new ChartWizard(this, this.presetDBInfo, this.presetQueryInParamSet, this.presetManager, false, true, false);
            } else {
                this.chartWizard = new ChartWizard(this);
                this.chartWizard.init();
                this.chartWizard.newChart(true, this.chartWizard.step1, false);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to initialize new chart wizard", ex);
        }
    }

    private void saveHideAttribute() {
        this.oldAntiAliasState = this.chart.isAntiAliasEnabled();
        this.chart.setAntiAliasEnabled(false);
        for (int i = 0; i < 3; ++i) {
            this.oldTickerState[i] = this.chart.getTickerLabelState(i);
            this.chart.setTickerLabelState(i, false);
            this.chart.axis[i].title.bshow = false;
        }
        if (this.chart.axis[3] != null) {
            this.oldTickerState[3] = this.chart.getTickerLabelState(3);
            this.chart.setTickerLabelState(3, false);
            this.chart.axis[3].title.bshow = false;
        }
        this.oldTopValueState = this.chart.getTopValueState();
        this.oldTopValueState2 = this.chart.getTopValueState2();
        this.chart.setTopValueState(false);
        this.chart.setTopValueState2(false);
        this.chart.doDrawAnnotation = false;
        this.chartPanel.setEnabled(false);
    }

    private void restoreAttribute() {
        for (int i = 0; i < 3; ++i) {
            this.chart.setTickerLabelState(i, this.oldTickerState[i]);
            this.chart.axis[i].title.bshow = true;
        }
        if (this.chart.axis[3] != null) {
            this.chart.setTickerLabelState(3, this.oldTickerState[3]);
            this.chart.axis[3].title.bshow = true;
        }
        this.chart.setTopValueState(this.oldTopValueState);
        this.chart.setTopValueState2(this.oldTopValueState2);
        this.chart.doDrawAnnotation = true;
        this.chart.setAntiAliasEnabled(this.oldAntiAliasState);
        this.chartPanel.setEnabled(true);
    }

    private void startNew() {
        this.clearUndoRedoList();
        if (this.isOpen) {
            new OpenSaveDialog(this, LanguageEncoder.getText("Open File..."), 1, 0).setVisible(true);
        } else {
            this.chartWizard = new ChartWizard(this);
            this.chartWizard.init();
            this.chartWizard.newChart(true, this.chartWizard.step1, false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block319: {
            boolean isHexField = this.colorpanel.hexPanel.isHexField();
            this.colorpanel.hexPanel.setIsHexField(false);
            if (this.initializing) {
                return;
            }
            if (this.chartPanel.isLineMode()) {
                return;
            }
            try {
                String cmd = e.getActionCommand();
                Object target = e.getSource();
                String tplName = null;
                if (target instanceof ImageDialog) {
                    ImageDialog imageDialog = (ImageDialog)target;
                    if (imageDialog.getTitle().equalsIgnoreCase(LanguageEncoder.getText("Choose A Background Image"))) {
                        if (imageDialog.getImageURL() != null || imageDialog.getDisplayOption() == 3) {
                            this.chart.setBackgroundImage(imageDialog.getImageURL(), imageDialog.getRelativeURL(), imageDialog.getDisplayOption());
                            this.setURLForRelativeBGImagePath();
                            this.qbpaint();
                            this.setModified();
                        }
                        return;
                    }
                    if (imageDialog.getTitle().equalsIgnoreCase(LanguageEncoder.getText("Choose A Dial Foreground Image"))) {
                        if (imageDialog.getImageURL() != null) {
                            this.chart.setDialPlotFGImage(imageDialog.getImageURL(), imageDialog.getRelativeURL(), imageDialog.getDisplayOption());
                            this.chart.setDialPlotFGRatio(imageDialog.getRatio());
                            this.setURLForRelativeFGDialImagePath();
                            this.qbpaint();
                            this.setModified();
                        }
                        return;
                    }
                    if (imageDialog.getImageURL() != null) {
                        this.chart.setDialPlotBGImage(imageDialog.getImageURL(), imageDialog.getRelativeURL(), imageDialog.getDisplayOption());
                        this.chart.setDialPlotBGRatio(imageDialog.getRatio());
                        this.setURLForRelativeBGDialImagePath();
                        this.qbpaint();
                        this.setModified();
                    }
                    return;
                }
                if (target == this.drillsaveDialog) {
                    tplName = this.createDrillTemplateName();
                    if (cmd.equals(LanguageEncoder.getText("Cancel"))) {
                        this.ignoreSave = false;
                        this.nextDrill = false;
                        this.previousDrill = false;
                        return;
                    }
                    if (cmd.equals(LanguageEncoder.getText("No"))) {
                        this.ignoreSave = true;
                        this.setUnModified();
                        if (this.nextDrill) {
                            this.nextDrillDown();
                        }
                        if (this.previousDrill) {
                            this.previousDrillDown();
                        }
                        return;
                    }
                    if (cmd.equals(LanguageEncoder.getText("Yes"))) {
                        this.doSaveDrillTemplate(this.chart, tplName);
                        if (this.nextDrill) {
                            this.nextDrillDown();
                        }
                        if (this.previousDrill) {
                            this.previousDrillDown();
                        }
                        return;
                    }
                }
                if (target == this.checkRemoveDialog) {
                    if (cmd.equals(LanguageEncoder.getText("No")) || cmd.equals(LanguageEncoder.getText("Cancel"))) {
                        return;
                    }
                    if (this.parentChart != null) {
                        this.ignoreSave = true;
                        this.setUnModified();
                        this.do_drillPrevious();
                        this.parentChart.removeDrillDown(this.parentChart.drillNumber);
                        String tplName2 = this.createDrillTemplateName();
                        if (tplName2 != null) {
                            try {
                                new DeleteFile(tplName2, this.parentChart.getDrillNumber()).delete();
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.FINEST, "Failed to delete drilldown template", ex);
                            }
                        }
                        if (this.parentChart.drillDownVector.size() <= 0) {
                            this.resetDrillDownChart();
                        } else if (this.parentChart.getDrillNumber() <= 0) {
                            this.enableNonDrillDownMenu(true);
                        } else {
                            this.enableNonDrillDownMenu(false);
                        }
                        return;
                    }
                }
                if (target == this.checksaveDialog) {
                    if (cmd.equals(LanguageEncoder.getText("Cancel"))) {
                        this.doClose = false;
                        this.isClose = false;
                        return;
                    }
                    if (cmd.equals(LanguageEncoder.getText("Yes"))) {
                        if (this.filename == null) {
                            this.do_SaveAs();
                            return;
                        }
                        this.do_Save();
                        this.modified = false;
                    }
                    if (cmd.equals(LanguageEncoder.getText("No"))) {
                        this.modified = false;
                        if (this.doClose) {
                            this.doClose = false;
                            this.do_Close();
                        }
                    }
                    if (this.actionCallback) {
                        this.startNew();
                        this.actionCallback = false;
                    }
                    if (this.isOpen) {
                        this.do_Open();
                        this.isOpen = false;
                    }
                    return;
                }
                if (target == this.exitdialog) {
                    if (cmd.equals(LanguageEncoder.getText("Cancel"))) {
                        this.bgoback2 = false;
                        this.bgoback = false;
                        this.setVisible(true);
                        return;
                    }
                    if (cmd.equals(LanguageEncoder.getText("No"))) {
                        if (this.bgoback || this.bgoback2) {
                            this.modified = false;
                            if (this.bgoback) {
                                this.bgoback = false;
                                this.do_JumpLink();
                            } else {
                                this.bgoback2 = false;
                                this.do_goback();
                            }
                            return;
                        }
                        this.cleanup();
                        if (this.drillDownNavigationFrame != null) {
                            try {
                                this.drillDownNavigationFrame.setVisible(false);
                                this.drillDownNavigationFrame = null;
                            }
                            catch (Exception ex) {
                                LOGGER.log(Level.FINEST, "Failed to close drilldown navigation frame", ex);
                            }
                        }
                        if (this.isForBean) {
                            this.setVisible(false);
                        } else {
                            this.dispose();
                        }
                        return;
                    }
                    if (!this.bgoback && !this.bgoback2) {
                        this.isClose = true;
                    }
                    if (this.isForBean) {
                        this.do_UpdateBean();
                        this.setVisible(false);
                    } else {
                        this.onDocSave();
                    }
                    if (this.getTitle().equals(CustomizeElement.getCustomData("[ERES Organizer][Text][Chart Designer Title]", LanguageEncoder.getText("Chart Designer")))) {
                        this.setVisible(true);
                        this.isClose = false;
                    }
                    return;
                }
                if (target == this.gouraudButton) {
                    this.createBackupChart();
                    if (this.gouraudButton.isSelected()) {
                        if (this.frameBorderButton.isSelected()) {
                            this.chart.set3DDrawType(4);
                        } else {
                            this.chart.set3DDrawType(3);
                        }
                    } else if (this.frameBorderButton.isSelected()) {
                        this.chart.set3DDrawType(2);
                    } else {
                        this.chart.set3DDrawType(1);
                    }
                    this.setDrawMode();
                    this.saveBackupChartToUndoList();
                    this.enableUndoRedoButtons();
                    this.setModified();
                    this.qbpaint();
                    return;
                }
                if (target == this.frameBorderButton) {
                    this.createBackupChart();
                    this.chart.setDataBorder(this.frameBorderButton.isSelected());
                    if (!this.frameBorderButton.isSelected()) {
                        if (this.gouraudButton.isSelected()) {
                            this.chart.set3DDrawType(3);
                        } else {
                            this.chart.set3DDrawType(1);
                        }
                    } else if (this.gouraudButton.isSelected()) {
                        this.chart.set3DDrawType(4);
                    } else {
                        this.chart.set3DDrawType(2);
                    }
                    this.setDrawMode();
                    this.saveBackupChartToUndoList();
                    this.enableUndoRedoButtons();
                    this.setModified();
                    this.qbpaint();
                    return;
                }
                if (target == this.inLineSeriesButton) {
                    this.createBackupChart();
                    boolean state = this.inLineSeriesButton.isSelected();
                    this.chart.setDrawSeriesOnCategoryAxis(state);
                    this.setModified();
                    this.chart.doNewSurface();
                    this.chartPanel.repaint();
                    return;
                }
                if (target == this.frameButton) {
                    this.createBackupChart();
                    if (this.frameButton.isSelected()) {
                        this.chart.set3DDrawType(0);
                    } else if (this.frameBorderButton.isSelected()) {
                        if (this.gouraudButton.isSelected()) {
                            this.chart.set3DDrawType(4);
                        } else {
                            this.chart.set3DDrawType(2);
                        }
                    } else if (this.gouraudButton.isSelected()) {
                        this.chart.set3DDrawType(3);
                    } else {
                        this.chart.set3DDrawType(1);
                    }
                    this.setDrawMode();
                    this.setModified();
                    this.saveBackupChartToUndoList();
                    this.enableUndoRedoButtons();
                    if (this.chart.chartType == 12) {
                        this.qbrepaint();
                    } else {
                        this.qbpaint();
                    }
                    return;
                }
                if (target == this.animateButton) {
                    if (this.animateButton.isSelected()) {
                        this.saveHideAttribute();
                        this.chartPanel.animation = true;
                        this.chartPanel.stop();
                        this.chartPanel.start();
                        this.disableNavControl();
                        this.toolbar.setAllEnabledWithSave(false);
                        this.setMenuBarEnabled(false);
                    } else {
                        this.chartPanel.animation = false;
                        this.chartPanel.stop();
                        this.restoreAttribute();
                        this.chartPanel.paint(this.chartPanel.getGraphics());
                        this.enableNavControl();
                        this.toolbar.setAllEnabledWithSave(true);
                        this.setMenuBarEnabled(true);
                    }
                }
                if (target == this.navigatePanel) {
                    this.createBackupChart();
                    int argument = e.getID();
                    if (argument == 0 || argument == 1 || argument == 2 || argument == 3) {
                        this.setModified();
                        this.navigate(argument);
                        return;
                    }
                    if (argument == 4) {
                        this.rotateMode = false;
                        this.slideBar.setDValue(1000 * (this.movement - 5) / 995);
                        return;
                    }
                    if (argument == 9) {
                        this.slideBar.setDValue(1000.0 * (this.increment - 0.002) / 0.3121592653589793);
                        this.rotateMode = true;
                        return;
                    }
                }
                if (target == this.zoomMeter) {
                    this.createBackupChart();
                    this.setModified();
                    if (this.zoomMeter != null) {
                        this.zooming(this.zoomMeter.getValue());
                    }
                    return;
                }
                if (target == this.speedMeter) {
                    this.setModified();
                    if (this.chart != null && this.speedMeter != null) {
                        this.chart.setAnimateSpeed(this.speedMeter.getValue());
                    }
                    return;
                }
                if (target == this.colorpanel) {
                    if (this.chart == null) {
                        return;
                    }
                    if (!isHexField) {
                        return;
                    }
                    this.setObjectColor(this.colorpanel.getColor());
                    this.qbrepaint();
                    return;
                }
                if (target == this.patternPanel) {
                    if (this.chart == null) {
                        return;
                    }
                    if (this.chartPanel.selectobj instanceof MultiDimData) {
                        this.setObjectColor(this.patternPanel.getPattern());
                    } else {
                        this.setObjectColor(this.colorpanel.getColor());
                    }
                    this.qbrepaint();
                    return;
                }
                if (target == this.csPanel) {
                    if (this.chart == null) {
                        return;
                    }
                    this.createBackupChart();
                    this.setModified();
                    if (this.csPanel.getSelectedValueAxis() == 0) {
                        this.chart.setColorSetForValueAxis(this.csPanel.getSelectedValueColorSet(), true);
                    } else {
                        this.chart.setColorSetForSecondValueAxis(this.csPanel.getSelectedSecondValueColorSet(), true);
                    }
                    if (this.chartPanel.selectobj instanceof MultiDimData) {
                        int patternID = this.patternPanel.getPattern().getPatternTypeID();
                        QbPattern pattern = new QbPattern(this.chart.getDataColor((MultiDimData)this.chartPanel.selectobj), patternID);
                        this.chart.setDataColor((MultiDimData)this.chartPanel.selectobj, (Color)pattern);
                        this.colorpanel.setColor(pattern, true);
                    }
                    this.chart.legend.invalidate();
                    this.chart.legend2.invalidate();
                    this.qbrepaint();
                    return;
                }
                if (target == this.fontpanel) {
                    if (this.chart == null) {
                        return;
                    }
                    if (this.chartPanel.selectobj != null) {
                        this.createBackupChart();
                        if (this.chartPanel.selectobj instanceof GraphicsTable) {
                            this.setModified();
                            GraphicsTable tmpgt = (GraphicsTable)this.chartPanel.selectobj;
                            boolean isModifiedText = false;
                            if (tmpgt.select == 2) {
                                isModifiedText = !tmpgt.headFont.equals(this.fontpanel.getNewFont());
                            } else if (tmpgt.select == 3) {
                                boolean bl = isModifiedText = !tmpgt.cellFont.equals(this.fontpanel.getNewFont());
                            }
                            if (isModifiedText) {
                                if (tmpgt.select == 2) {
                                    tmpgt.headFont = this.fontpanel.getNewFont();
                                } else if (tmpgt.select == 3) {
                                    tmpgt.cellFont = this.fontpanel.getNewFont();
                                }
                                tmpgt.resizeTableByFontSize();
                            }
                            this.chartPanel.paint();
                        } else if (this.chartPanel.selectobj instanceof Ticker) {
                            this.setModified();
                            ((Ticker)this.chartPanel.selectobj).setFont(this.fontpanel.getNewFont(), this.fontpanel.getAngle(), false);
                        } else if (this.chartPanel.selectobj instanceof CString) {
                            this.setModified();
                            ((CString)this.chartPanel.selectobj).setFont(this.fontpanel.getNewFont(), this.fontpanel.getAngle(), false);
                        } else if (this.chartPanel.selectobj instanceof CString[]) {
                            this.setModified();
                            if (this.chartPanel.chart.targetName.startsWith("percentage")) {
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().piePercentFont = this.fontpanel.getNewFont();
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().piePercentAngle = this.fontpanel.getAngle();
                            } else if (this.chartPanel.chart.targetName.startsWith("name")) {
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().pieLabelFont = this.fontpanel.getNewFont();
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().pieLabelAngle = this.fontpanel.getAngle();
                            } else if (this.chartPanel.chart.targetName.startsWith("value")) {
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().pieValueFont = this.fontpanel.getNewFont();
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().pieValueAngle = this.fontpanel.getAngle();
                            } else if (this.chartPanel.chart.targetName.startsWith("category")) {
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().catLabelFont = this.fontpanel.getNewFont();
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().catLabelAngle = this.fontpanel.getAngle();
                            }
                            CString.setStringsFont((CString[])this.chartPanel.selectobj, this.fontpanel.getNewFont(), this.fontpanel.getAngle(), false);
                        } else if (this.chartPanel.selectobj instanceof CString[][]) {
                            this.setModified();
                            if (this.chartPanel.chart.targetName.startsWith("percentage")) {
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().piePercentFont = this.fontpanel.getNewFont();
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().piePercentAngle = this.fontpanel.getAngle();
                            } else if (this.chartPanel.chart.targetName.startsWith("name")) {
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().pieLabelFont = this.fontpanel.getNewFont();
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().pieLabelAngle = this.fontpanel.getAngle();
                            } else if (this.chartPanel.chart.targetName.startsWith("value")) {
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().pieValueFont = this.fontpanel.getNewFont();
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().pieValueAngle = this.fontpanel.getAngle();
                            } else if (this.chartPanel.chart.targetName.startsWith("category")) {
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().catLabelFont = this.fontpanel.getNewFont();
                                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().catLabelAngle = this.fontpanel.getAngle();
                            }
                            CString.setStringsFont((CString[][])this.chartPanel.selectobj, this.fontpanel.getNewFont(), this.fontpanel.getAngle(), false);
                        } else if (this.chartPanel.selectobj instanceof Legend) {
                            this.setModified();
                            ((Legend)this.chartPanel.selectobj).setFont(this.fontpanel.getNewFont(), this.fontpanel.getAngle());
                        } else if (this.chartPanel.selectobj instanceof CAnnotation) {
                            this.setModified();
                            ((CAnnotation)this.chartPanel.selectobj).setFont(this.fontpanel.getNewFont(), this.fontpanel.getAngle());
                        } else if (this.chartPanel.selectobj == this.chart.topLabels) {
                            this.setModified();
                            this.chart.setTopValueFont(this.fontpanel.getNewFont(), this.fontpanel.getAngle());
                            if (!(this.chart.getChartType() != 4 && this.chart.getChartType() != 5 || this.chart.is2DimChart())) {
                                this.chart.newSurface();
                            }
                        } else if (this.chartPanel.selectobj == this.chart.topLabels2) {
                            this.setModified();
                            this.chart.setTopValueFont2(this.fontpanel.getNewFont(), this.fontpanel.getAngle());
                        }
                        this.qbpaint();
                    }
                    return;
                }
                if (target == this.chartPanel) {
                    this.showHint("");
                    if (this.chartPanel.getValue() instanceof HyperLink) {
                        String s = null;
                        s = ((HyperLink)this.chartPanel.getValue()).hint;
                        if (s == null || s.equals("")) {
                            s = ((HyperLink)this.chartPanel.getValue()).link;
                        }
                        if (s != null && !(s = s.trim()).equals("")) {
                            this.showHint(LanguageEncoder.getText("[HyperLink]") + s);
                        }
                        return;
                    }
                    if (this.chartPanel.getValue() instanceof FaceData) {
                        String s = null;
                        s = ((FaceData)this.chartPanel.getValue()).getHint();
                        if (s == null || s.equals("")) {
                            s = ((FaceData)this.chartPanel.getValue()).getHyperLink();
                        }
                        if (s == null) {
                            return;
                        }
                        if (!(s = s.trim()).equals("")) {
                            this.showHint(LanguageEncoder.getText("[HyperLink]") + s);
                        }
                        return;
                    }
                    if (!(this.chartPanel.getValue() instanceof Color)) {
                        return;
                    }
                    this.fontpanel.setEnabled(false);
                    if (this.chartPanel.chart.tableInPanel && this.chartPanel.selectobj instanceof GraphicsTable) {
                        GraphicsTable tmpgt = (GraphicsTable)this.chartPanel.selectobj;
                        if (tmpgt.select == 2) {
                            this.showHint(LanguageEncoder.getText("table header text"));
                            this.colorpanel.setColor(tmpgt.headTextColor, true);
                            this.fontpanel.setFont(tmpgt.headFont, 0);
                        } else if (tmpgt.select == 3) {
                            this.showHint(LanguageEncoder.getText("table cell text"));
                            this.colorpanel.setColor(tmpgt.cellTextColor, true);
                            this.fontpanel.setFont(tmpgt.cellFont, 0);
                        } else if (tmpgt.select == 0) {
                            this.showHint(LanguageEncoder.getText("table header background"));
                            this.colorpanel.setColor(tmpgt.headColor, true);
                        } else if (tmpgt.select == 1) {
                            this.showHint(LanguageEncoder.getText("table cell background"));
                            this.colorpanel.setColor(tmpgt.cellColor, true);
                        }
                        return;
                    }
                    this.showHint(LanguageEncoder.getText("Current selection :") + " " + this.chart.targetName);
                    this.colorpanel.setColor((Color)this.chartPanel.getValue(), true);
                    if (this.chartPanel.selectobj instanceof Ticker) {
                        CString str = ((Ticker)this.chartPanel.selectobj).getString();
                        this.fontpanel.setFont(str.getFont(), str.getAngle());
                    } else if (this.chartPanel.selectobj instanceof CString) {
                        CString str = (CString)this.chartPanel.selectobj;
                        this.fontpanel.setFont(str.getFont(), str.getAngle());
                    } else if (this.chartPanel.selectobj instanceof CString[]) {
                        CString[] str = (CString[])this.chartPanel.selectobj;
                        this.fontpanel.setFont(str[0].getFont(), str[0].getAngle());
                    } else if (this.chartPanel.selectobj instanceof OffsetCString[][]) {
                        OffsetCString[] str = ((OffsetCString[][])this.chartPanel.selectobj)[0];
                        this.fontpanel.setFont(str[0].getFont(), str[0].getAngle());
                    } else if (this.chartPanel.selectobj instanceof Legend) {
                        this.fontpanel.setFont(((Legend)this.chartPanel.selectobj).getFont(), ((Legend)this.chartPanel.selectobj).getAngle());
                    } else if (this.chartPanel.selectobj instanceof CAnnotation) {
                        CAnnotation cAnno = (CAnnotation)this.chartPanel.selectobj;
                        this.fontpanel.setFont(cAnno.getFont(), cAnno.getAngle());
                    } else if (this.chartPanel.selectobj == this.chart.topLabels) {
                        this.fontpanel.setFont(((CString)this.chart.topLabels.elementAt(0)).getFont(), ((CString)this.chart.topLabels.elementAt(0)).getAngle());
                    } else if (this.chartPanel.selectobj == this.chart.topLabels2) {
                        this.fontpanel.setFont(((CString)this.chart.topLabels2.elementAt(0)).getFont(), ((CString)this.chart.topLabels2.elementAt(0)).getAngle());
                    }
                    return;
                }
                if (target instanceof JMenuItem) {
                    if (this.loading || this.chartPanel.animation) {
                        return;
                    }
                    this.createBackupChart();
                    String menustr = ((JMenuItem)target).getText();
                    if (ServerMessage.isEvalVersion() && menustr.equals(LanguageEncoder.getText("Order..."))) {
                        this.showEvalBox();
                        return;
                    }
                    if (menustr.equals(LanguageEncoder.getText("Exit"))) {
                        this.do_exit();
                    } else if (menustr.equals(LanguageEncoder.getText("Contents..."))) {
                        this.do_help();
                    } else if (menustr.equals(LanguageEncoder.getText("About..."))) {
                        ImageCanvas imgCanvas;
                        if (this.manager == null) {
                            String logoName = ServerMessage.imagesPath + "cyberLogo.gif";
                            imgCanvas = new ImageCanvas(IOUtil.getImage(logoName));
                        } else {
                            imgCanvas = this.manager.logo;
                        }
                        new AboutDialog((Frame)this, imgCanvas, SaveChart.VERSIONNAME + "." + 6612 + " Update " + SaveChart.getUpdateVersion()).setVisible(true);
                    } else if (menustr.equals(LanguageEncoder.getText("Export..."))) {
                        this.do_Export();
                    } else if (menustr.equals(LanguageEncoder.getText("Save As..."))) {
                        this.do_SaveAs();
                    } else if (menustr.equals(LanguageEncoder.getText("Apply Template..."))) {
                        this.do_OpenTemplate();
                    } else if (menustr.equals(LanguageEncoder.getText("Open..."))) {
                        this.do_Open();
                    } else if (menustr.equals(LanguageEncoder.getText("Close"))) {
                        this.do_Close();
                    } else if (menustr.equals(LanguageEncoder.getText("New..."))) {
                        this.do_New();
                    } else if (menustr.equals(LanguageEncoder.getText("Save"))) {
                        this.onDocSave();
                    } else if (menustr.equals(LanguageEncoder.getText("3D Display Options..."))) {
                        this.do_3DOption();
                    } else if (menustr.equals(LanguageEncoder.getText("Rendering Options..."))) {
                        this.do_RenderingOption();
                    } else if (menustr.equals(LanguageEncoder.getText("Font Mapping..."))) {
                        this.setFontMapping();
                    } else if (menustr.equals(LanguageEncoder.getText("Chart Options..."))) {
                        this.do_ChartOption();
                    } else if (menustr.equals(LanguageEncoder.getText("Modify Data Mapping"))) {
                        this.do_ChangeDataMappingOption(this.showReportDataHasChangedDialog);
                    } else if (menustr.equals(LanguageEncoder.getText("Add..."))) {
                        this.do_drillDown();
                    } else if (menustr.equals(LanguageEncoder.getText("Remove This..."))) {
                        this.do_drillRemove();
                    } else if (menustr.equals(LanguageEncoder.getText("Remove All..."))) {
                        this.do_drillRemoveAll();
                    } else if (menustr.equals(LanguageEncoder.getText("Go To Top Level..."))) {
                        this.do_drillGoToTop();
                    } else if (menustr.equals(LanguageEncoder.getText("Previous..."))) {
                        this.do_drillPrevious();
                    } else if (menustr.equals(LanguageEncoder.getText("Next..."))) {
                        this.do_drillNext();
                    } else if (menustr.equals(LanguageEncoder.getText("Dynamic..."))) {
                        this.do_drillDynamic();
                    } else if (menustr.equals(LanguageEncoder.getText("Parameter Drill Down..."))) {
                        this.do_drillNavigate();
                    } else if (menustr.equals(LanguageEncoder.getText("Canvas..."))) {
                        this.do_CanvasSize();
                    } else if (menustr.equals(LanguageEncoder.getText("Data Border..."))) {
                        this.do_DataBorder();
                    } else if (menustr.equals(LanguageEncoder.getText("Lighting Model..."))) {
                        this.do_Lightmodel();
                    } else if (menustr.equals(LanguageEncoder.getText("Legend..."))) {
                        this.do_Legend(this.chart.legend);
                    } else if (menustr.equals(LanguageEncoder.getText("Plot Area..."))) {
                        this.do_PlotArea();
                    } else if (menustr.equals(LanguageEncoder.getText("No Data To Plot Message..."))) {
                        this.do_NoDataToPlotMessage();
                    } else if (menustr.equals(LanguageEncoder.getText("Flash Hintbox Customization..."))) {
                        this.do_FlashHintBoxCustomization();
                    } else if (menustr.equals(LanguageEncoder.getText("Table..."))) {
                        this.do_TableDirection();
                    } else if (menustr.equals(LanguageEncoder.getText("Text Properties..."))) {
                        this.do_TextProperties();
                    } else if (menustr.equals(LanguageEncoder.getText("NULL Data Properties..."))) {
                        this.do_NullDataProperties();
                    } else if (menustr.equals(LanguageEncoder.getText("Viewer Options..."))) {
                        this.do_ChartViewer();
                    } else if (menustr.equals(LanguageEncoder.getText("Line and Point..."))) {
                        this.do_PointLine();
                    } else if (menustr.equals(LanguageEncoder.getText("Axis Scale..."))) {
                        this.do_AxisDialog();
                    } else if (menustr.equals(LanguageEncoder.getText("Time Zooming Options..."))) {
                        this.do_ZoomOptions();
                    } else if (menustr.equals(LanguageEncoder.getText("Histogram Options..."))) {
                        this.do_HistogramOptions();
                    } else if (menustr.equals(LanguageEncoder.getText("Aggregation Options..."))) {
                        this.do_AggregationOptions();
                    } else if (menustr.equals(LanguageEncoder.getText("Axis Elements..."))) {
                        this.do_FormatValue();
                    } else if (menustr.equals(LanguageEncoder.getText("Data Properties..."))) {
                        this.do_DataProp();
                    } else if (menustr.equals(LanguageEncoder.getText("Undo"))) {
                        this.do_undo();
                    } else if (menustr.equals(LanguageEncoder.getText("Redo"))) {
                        this.do_redo();
                    } else if (menustr.equals(LanguageEncoder.getText("Refresh"))) {
                        this.do_Refresh();
                    } else if (menustr.equals(LanguageEncoder.getText("Schedule Refresh"))) {
                        this.do_PeriodicRefresh();
                    } else if (menustr.equals(LanguageEncoder.getText("Modify Data Source"))) {
                        this.doQuery();
                    } else if (menustr.equals(LanguageEncoder.getText("Go Back"))) {
                        if (this.isPreviousDrillDownEnabled()) {
                            this.previousDrillDown();
                        } else if (this.isGoBackLinkEnabled()) {
                            this.do_goback();
                        }
                    } else if (menustr.equals(LanguageEncoder.getText("Modify Database"))) {
                        this.do_modifyDatabase();
                    } else if (menustr.equals(LanguageEncoder.getText("Modify Query"))) {
                        this.do_modifySQL();
                    } else if (menustr.equals(LanguageEncoder.getText("Query Parameters"))) {
                        this.do_param();
                    } else if (menustr.equals(LanguageEncoder.getText("View Table"))) {
                        this.do_viewRecord();
                    } else if (menustr.equals(LanguageEncoder.getText("View Chart Data"))) {
                        this.do_viewTable();
                    } else if (menustr.equals(LanguageEncoder.getText("View Data Source Info"))) {
                        this.do_viewDataSourceInfo();
                    } else if (menustr.equals(LanguageEncoder.getText("item_go_back"))) {
                        this.do_goback();
                    } else if (menustr.equals(LanguageEncoder.getText("Ordering"))) {
                        this.do_DataOrder();
                    } else if (menustr.equals(LanguageEncoder.getText("Titles..."))) {
                        this.do_Titles();
                    } else if (menustr.equals(LanguageEncoder.getText("Text..."))) {
                        this.do_Text(true);
                    } else if (menustr.equals(LanguageEncoder.getText("Background..."))) {
                        this.do_ImageDialog();
                    } else if (menustr.equals(LanguageEncoder.getText("Dial Foreground..."))) {
                        this.do_DialPlotFGDialog();
                    } else if (menustr.equals(LanguageEncoder.getText("Dial Background..."))) {
                        this.do_DialPlotBGDialog();
                    } else if (menustr.equals(LanguageEncoder.getText("Link..."))) {
                        this.do_DefineHyperLink();
                    } else if (menustr.equals(LanguageEncoder.getText("TrendLine..."))) {
                        this.do_DefineTrendLine();
                    } else if (menustr.equals(LanguageEncoder.getText("Horz/Vert Line..."))) {
                        this.do_DefineHorzVertLine();
                    } else if (menustr.equals(LanguageEncoder.getText("Control Area..."))) {
                        this.do_DefineControlRange();
                    } else if (menustr.equals(LanguageEncoder.getText("Line"))) {
                        this.do_AddLine();
                    } else if (menustr.equals(LanguageEncoder.getText("Update"))) {
                        this.do_UpdateBean();
                    } else if (menustr.equals(LanguageEncoder.getText("Reset"))) {
                        this.do_ResetBean();
                    }
                    return;
                }
                if (e.getSource() == this.closedialog) {
                    if (!e.getActionCommand().equals(LanguageEncoder.getText("Cancel")) && e.getActionCommand().equals(LanguageEncoder.getText("Yes"))) {
                        this.onDocSave();
                    }
                    this.dispose();
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to perform action", ex);
                if (this.firstErrorEncounter) {
                    new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(ex.toString());
                    this.firstErrorEncounter = false;
                }
            }
            catch (Error err) {
                LOGGER.log(Level.WARNING, "Failed to perform action", err);
                System.gc();
                if (!this.firstErrorEncounter) break block319;
                new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(err.toString());
                this.firstErrorEncounter = false;
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.initializing) {
            return;
        }
        Object target = e.getSource();
        if (target == this.slideBar) {
            if (this.rotateMode) {
                this.increment = 0.002 + this.slideBar.getDValue() * 0.3121592653589793 / 1000.0;
            } else {
                this.movement = (int)(5.0 + this.slideBar.getDValue() * 995.0 / 1000.0);
            }
            return;
        }
        if (target == this.thickness_bar) {
            if (this.chart.isCircularChart() && !this.chart.is2DimChart()) {
                this.chart.thickRatio = 1.0;
                float zScale = (float)(this.thickness_bar.getDValue() / 3.0 * 5.0);
                this.chart.scaleSpace((float)this.xscale_bar.getDValue(), (float)this.yscale_bar.getDValue(), zScale);
            } else {
                this.chart.thickRatio = this.thickness_bar.getDValue();
            }
            ((HiddenSurface)this.chart.gethiddenSurface()).reset();
            this.qbrepaint();
            this.setModifiedOnly();
            return;
        }
        if (target == this.xlight_bar || target == this.ylight_bar || target == this.zlight_bar) {
            float[] f = new float[]{(float)this.xlight_bar.getDValue(), (float)this.ylight_bar.getDValue(), (float)this.zlight_bar.getDValue()};
            this.chart.setLightPos(f);
            this.setModifiedOnly();
            this.qbpaint();
            return;
        }
        if (target == this.xscale_bar || target == this.yscale_bar || target == this.zscale_bar) {
            this.chart.scaleSpace((float)this.xscale_bar.getDValue(), (float)this.yscale_bar.getDValue(), (float)this.zscale_bar.getDValue());
            ((HiddenSurface)this.chart.gethiddenSurface()).reset();
            this.qbrepaint();
            this.setModifiedOnly();
            return;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        block37: {
            if (this.initializing) {
                return;
            }
            if (!this.enableItemStateChanged) {
                return;
            }
            try {
                String menustr = ((JMenuItem)e.getSource()).getText();
                if (menustr.equals(LanguageEncoder.getText("Show Font/Color Panel"))) {
                    this.do_LayoutToggle();
                } else if (menustr.equals(LanguageEncoder.getText("Show Navigation Panel"))) {
                    this.do_NavLayout();
                } else if (menustr.equals(LanguageEncoder.getText("Show Toolbar"))) {
                    this.do_ToggleToolbar();
                } else {
                    if (this.chart.isHistogram()) {
                        this.setMenuForHistogram(false);
                    } else {
                        this.setMenuForHistogram(true);
                    }
                    this.createBackupChart();
                    this.isnew2DChart = this.chart.is2DimChart();
                    this.newchartType = this.chart.chartType;
                    if (menustr.equals(LanguageEncoder.getText("2D Chart"))) {
                        this.isnew2DChart = true;
                    } else if (menustr.equals(LanguageEncoder.getText("3D Chart"))) {
                        this.isnew2DChart = false;
                    } else {
                        this.newchartType = this.findChartType(menustr);
                    }
                    if (!Chart.isValidChartType(this.isnew2DChart, this.newchartType)) {
                        new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("This chart type is not supported."));
                        this.setMenu(this.chart.is2DimChart(), this.chart.chartType);
                        return;
                    }
                    this.isOkToChange = true;
                    if (this.chart.chartType == 12) {
                        new YesNoDialog(this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("You may not be able to change back to surface chart later. Continue?")).setVisible(true);
                        if (!this.isOkToChange) {
                            return;
                        }
                    }
                    boolean popupOptionDialog = false;
                    this.setMenu(this.chart.is2DimChart(), this.chart.chartType);
                    if (this.newchartType == this.chart.chartType && this.isnew2DChart == this.chart.is2DimChart()) {
                        return;
                    }
                    if (this.isDrillDownEnabled() && !DrillDownInfo.checkDrillDownType(this.newchartType)) {
                        new DrillYesNoDialog(this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("It will lose all the drill-down charts. Continue?")).setVisible(true);
                    }
                    if (this.chart.chartType != this.newchartType && (Chart.isCircularChart(this.newchartType) || this.chart.isCircularChart() || !this.chart.isStackType() && (Chart.isStackChart(this.newchartType) || this.newchartType == 11)) && this.isOkToChange && this.chart.isTimeChart()) {
                        if (this.chart.isDrillDownDefined()) {
                            new JMessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please remove drill-down before change chart type!"));
                        } else {
                            new JMessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please undo zooming before change chart type!"));
                        }
                        this.isOkToChange = false;
                    }
                    if (this.chart.isCircularChart() && !Chart.isCircularChart(this.newchartType) && this.newchartType != 8 && this.newchartType != 5 && this.newchartType != 4 && this.newchartType != 11 && this.isOkToChange) {
                        if (this.newchartType == 12 && !this.isSurfaceSupport()) {
                            this.isOkToChange = false;
                            return;
                        }
                        new YesNoDialog(this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Attributes of current chart may be lost. Continue?")).setVisible(true);
                    }
                    if (this.chart.dataDim == 3 && this.newchartType != 4 && this.newchartType != 5) {
                        new YesNoDialog(this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Attributes of current chart may be lost. Continue?")).setVisible(true);
                    }
                    if (this.chart.chartType != this.newchartType && (this.newchartType == 18 || this.chart.chartType == 18)) {
                        popupOptionDialog = true;
                    }
                    if (this.chart.chartType != this.newchartType && this.newchartType == 17 && this.chart.dataDim > 1) {
                        popupOptionDialog = true;
                    }
                    if (!(this.newchartType != 8 && this.newchartType != 5 && this.newchartType != 4 && this.newchartType != 11 || !this.chart.isCircularChart() && this.chart.chartType != 17)) {
                        popupOptionDialog = true;
                    }
                    if (Chart.isCoordinateType(this.newchartType) != Chart.isCoordinateType(this.chart.chartType)) {
                        popupOptionDialog = true;
                    }
                    if (!this.isnew2DChart || this.chart.chartType != this.newchartType && (Chart.stackType(this.newchartType) || this.newchartType == 15 || this.newchartType == 3 || this.newchartType == 17 || this.newchartType == 16 || this.newchartType == 14 || this.newchartType == 7)) {
                        this.chart.setXAxisAtTop(false);
                    }
                    if (this.chart.chartType != this.newchartType && this.newchartType == 14) {
                        this.chart.subvalueCol = -1;
                    }
                    if (this.isOkToChange) {
                        this.changeChartType(popupOptionDialog);
                    } else {
                        this.setMenu(this.chart.is2DimChart(), this.chart.chartType);
                        this.isOkToChange = true;
                    }
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Error changing item state", ex);
                if (this.firstErrorEncounter) {
                    new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(ex.toString());
                    this.firstErrorEncounter = false;
                }
            }
            catch (Error err) {
                LOGGER.log(Level.WARNING, "Error changing item state", err);
                System.gc();
                if (!this.firstErrorEncounter) break block37;
                new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(err.toString());
                this.firstErrorEncounter = false;
            }
        }
    }

    private void zooming(double value) {
        this.chart.zoomSpace((float)(1.0 - (value != 100.0 ? value : 99.0) / 100.0) * 4.0f * 1000.0f);
        this.qbpaint();
    }

    private void navigate(int direction) {
        Space space = (Space)this.chart.getSpace();
        float scale = space.spaceScale;
        double alpha = Math.atan2(-space.viewVec.k, -space.viewVec.i);
        double pheta = Math.asin(-space.viewVec.j);
        switch (direction) {
            case 0: {
                if (this.rotateMode) {
                    if (!((pheta -= this.increment) < -1.5707963267948966)) break;
                    pheta = -1.5702963267948966;
                    break;
                }
                this.chart.translateSpace(0.0f, this.movement, 0.0f);
                break;
            }
            case 1: {
                if (this.rotateMode) {
                    if (!((pheta += this.increment) > 1.5707963267948966)) break;
                    pheta = 1.5702963267948966;
                    break;
                }
                this.chart.translateSpace(0.0f, -this.movement, 0.0f);
                break;
            }
            case 2: {
                if (this.rotateMode) {
                    alpha -= this.increment;
                    break;
                }
                this.chart.translateSpace(-this.movement, 0.0f, 0.0f);
                break;
            }
            case 3: {
                if (this.rotateMode) {
                    alpha += this.increment;
                    break;
                }
                this.chart.translateSpace(this.movement, 0.0f, 0.0f);
                break;
            }
        }
        double t = Math.cos(pheta) * (double)scale;
        double t2 = Math.sin(pheta) * (double)scale;
        this.chart.setlookfrom_x((float)(t * Math.cos(alpha) + (double)this.chart.getlookto_x()));
        this.chart.setlookfrom_y((float)(t2 + (double)this.chart.getlookto_y()));
        this.chart.setlookfrom_z((float)(t * Math.sin(alpha) + (double)this.chart.getlookto_z()));
        space.lookat(this.chart.getlookfrom_x(), this.chart.getlookfrom_y(), this.chart.getlookfrom_z(), this.chart.getlookto_x(), this.chart.getlookto_y(), this.chart.getlookto_z());
        this.qbpaint();
    }

    private void setMenuBarEnabled(boolean state) {
        this.filemenu.setEnabled(state);
        this.helpmenu.setEnabled(state);
        this.editmenu.setEnabled(state);
        this.formatmenu.setEnabled(state);
        this.drillDownmenu.setEnabled(state);
        this.chartTypemenu.setEnabled(state);
        this.datamenu.setEnabled(state);
        this.layoutmenu.setEnabled(state);
    }

    private void disableNavControl() {
        this.enableNavControl(false);
    }

    private void enableNavControl() {
        this.enableNavControl(true);
    }

    private void enableNavControl(boolean isEnabled) {
        this.navigatePanel.setEnabled(isEnabled);
        this.zoomMeter.setEnabled(isEnabled);
        this.frameButton.setEnabled(isEnabled);
        this.frameBorderButton.setEnabled(isEnabled);
        this.inLineSeriesButton.setEnabled(isEnabled);
        this.gouraudButton.setEnabled(isEnabled);
        this.setGouraudButtonEnabled();
        this.xscale_bar.setEnabled(isEnabled);
        this.yscale_bar.setEnabled(isEnabled);
        this.zscale_bar.setEnabled(isEnabled);
        this.xlight_bar.setEnabled(isEnabled);
        this.ylight_bar.setEnabled(isEnabled);
        this.zlight_bar.setEnabled(isEnabled);
        this.thickness_bar.setEnabled(isEnabled);
        if (this.chart.getSpace() != null && isEnabled) {
            this.zoomMeter.setValue(100.0f * (1.0f - ((Space)this.chart.getSpace()).zoomfactor / 4000.0f));
        }
    }

    public Chart getChart() {
        return this.chartPanel.chart;
    }

    public String getChartFile() {
        return this.filename;
    }

    @Override
    public void setVisible(boolean x) {
        if (!x && this.skipClosingCommand) {
            this.skipClosingCommand = true;
            return;
        }
        if (!x && this.chartWizard != null) {
            if (this.chartWizard.manager != null) {
                this.chartWizard.manager.setVisible(false);
            }
            this.chartWizard.setVisible(false);
        }
        super.setVisible(x);
        if (x && this.isForBean && (this.chart == null || this.chart.isEmpty())) {
            this.modified = false;
            this.do_New();
        }
    }

    private boolean isInLineSeriesEnabled(Chart chart) {
        int i = chart.getChartType();
        int dataDim = chart.getDataDimension();
        return (i == 0 || i == 1) && dataDim > 1 || (i == 4 || i == 5 || i == 11) && dataDim > 2;
    }

    private boolean findComponent(Container container, Component comp) {
        Component[] comps;
        for (Component comp2 : comps = container.getComponents()) {
            if (comp2 != comp) continue;
            return true;
        }
        return false;
    }

    void updateNavigationPanel(Chart chart) {
        boolean isButtonExisted = this.findComponent(this.buttonPanel, this.inLineSeriesButton);
        if (this.isInLineSeriesEnabled(chart)) {
            if (!isButtonExisted) {
                this.buttonPanel.remove(this.animateButton);
                this.buttonPanel.remove(this.gouraudButton);
                this.buttonPanel.add(this.inLineSeriesButton);
                this.buttonPanel.add(this.gouraudButton);
                this.buttonPanel.add(this.animateButton);
            }
            this.inLineSeriesButton.setSelected(chart.isDrawSeriesOnCategoryAxis());
        } else if (isButtonExisted) {
            this.buttonPanel.remove(this.inLineSeriesButton);
        } else {
            return;
        }
        this.buttonPanel.validate();
        this.buttonPanel.repaint();
    }

    private void checkDataSource() {
        if (this.chart == null) {
            String msg = LanguageEncoder.getText("Please insert a chart first!");
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), msg);
            return;
        }
        if (this.chart.sourceData == 0 && this.chart.getOriginalSourceData() >= 0) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Data source not found!") + " " + LanguageEncoder.getText("Please update your data source!"));
        }
        if (this.showReportDataHasChangedDialog) {
            JMessageDialog jMessageDialog = new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Report data has changed, please update chart data mapping!"));
            jMessageDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    ChartMain.this.do_ChangeDataMappingOption(ChartMain.this.showReportDataHasChangedDialog);
                }
            });
        }
    }

    public void setNewChart(Chart newchart) {
        if (this.chart != null) {
            this.setChart(newchart, true);
            return;
        }
        if (this.drillDownNavigationFrame != null) {
            try {
                this.drillDownNavigationFrame.setVisible(false);
                this.drillDownNavigationFrame = null;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to close drilldown navigation frame", ex);
            }
        }
        this.setMenu(newchart.is2DimChart(), newchart.chartType);
        this.chart = newchart;
        this.chartPanel.chart = newchart;
        if (!this.chart.is2DimChart()) {
            this.centerPanel.add("South", this.navigateAll);
        } else {
            this.centerPanel.remove(this.navigateAll);
        }
        this.updateNavigationPanel(this.chart);
        if (!this.toolbarExist) {
            this.do_ToggleToolbar();
        }
        this.centerPanel.validate();
        this.chartPanel.progressiveDraw = true;
        this.chartPanel.setSize(this.chart.getSize());
        this.chartPanel.update();
        this.chartPanel.progressiveDraw = false;
        this.initControlParam();
        if (this.csPanel != null) {
            if (this.chart.chartColorSet != null && this.chart.chartColorSet.getChartDataPointsColors().length == 0) {
                this.csPanel.setSelectedValueColorSet(this.chart.chartColorSet.getColorSetIndex());
            } else {
                this.csPanel.clearValueColorSetSelection();
            }
            if (this.chart.mData2 != null) {
                this.csPanel.setSelectAxisPanelVisible(true);
                if (this.chart.chartColorSet2 != null && this.chart.chartColorSet2.getChartDataPointsColors().length == 0) {
                    this.csPanel.setSelectedSecondValueColorSet(this.chart.chartColorSet2.getColorSetIndex());
                } else {
                    this.csPanel.clearSecondValueColorSetSelection();
                }
            } else {
                this.csPanel.setSelectAxisPanelVisible(false);
            }
        }
        if (this.optionDialog != null) {
            this.optionDialog.changeType = true;
        }
        if (this.chart.getScrollBarOption() != this.chartPanel.scrollBarOption) {
            this.setChartPanel(this.chart);
        }
        this.do_enable();
    }

    void setChart(Chart newchart, boolean progressive) {
        if (this.drillDownNavigationFrame != null) {
            try {
                this.drillDownNavigationFrame.setVisible(false);
                this.drillDownNavigationFrame = null;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to close drilldown navigation frame", ex);
            }
        }
        if (this.chart == null) {
            this.setNewChart(newchart);
            return;
        }
        if (this.valueTableSave != null) {
            newchart.valueTable = new ValueTable(newchart, this.valueTableSave);
            this.valueTableSave = null;
        }
        boolean isold2DChart = this.chart.is2DimChart();
        Color axisColor = this.chart.getAxisColor();
        this.setMenu(newchart.is2DimChart(), newchart.chartType);
        this.chartPanel.chart = newchart;
        this.chart = newchart;
        if (this.isDrillDownDefined) {
            if (!this.chart.is2DimChart() && this.navexist) {
                this.centerPanel.add("South", this.navigateAll);
            } else {
                this.centerPanel.remove(this.navigateAll);
            }
        } else {
            if (isold2DChart && !this.chart.is2DimChart()) {
                this.chart.setAxisColor(axisColor);
                if (this.navexist) {
                    this.centerPanel.add("South", this.navigateAll);
                }
            } else if (!isold2DChart && this.chart.is2DimChart()) {
                this.chart.setAxisColor(axisColor);
                this.centerPanel.remove(this.navigateAll);
            }
            this.updateNavigationPanel(this.chart);
        }
        if (this.csPanel != null) {
            if (this.chart.chartColorSet.getChartDataPointsColors().length == 0) {
                this.csPanel.setSelectedValueColorSet(this.chart.chartColorSet.getColorSetIndex());
            } else {
                this.csPanel.setSelectedValueColorSet(-1);
            }
            if (this.chart.chartColorSet2 != null && this.chart.chartColorSet2.getChartDataPointsColors().length == 0) {
                this.csPanel.setSelectedSecondValueColorSet(this.chart.chartColorSet2.getColorSetIndex());
            } else {
                this.csPanel.setSelectedSecondValueColorSet(-1);
            }
            this.csPanel.setSelectAxisPanelVisible(this.chart.mData2 != null);
        }
        this.centerPanel.validate();
        this.chartPanel.selectobj = null;
        this.chartPanel.progressiveDraw = progressive;
        if (this.chart.getSize().width != 0 && this.chart.getSize().height != 0) {
            this.chartPanel.setSize(this.chart.getSize());
        }
        this.chartPanel.update();
        this.chartPanel.progressiveDraw = false;
        this.initControlParam();
        if (this.optionDialog != null) {
            this.optionDialog.changeType = true;
        }
        if (this.chart.getScrollBarOption() != this.chartPanel.scrollBarOption) {
            this.setChartPanel(this.chart);
        }
        this.do_enable();
    }

    void setChartPanel(Chart newChart) {
        this.chartPanel.removeActionListener(this);
        this.chartPanel.removeChartPanelListener();
        if (this.firstRemovePanel && System.getProperty("java.vendor.url").indexOf("microsoft") >= 0) {
            this.mainPanel.remove(this.chartPanel);
            this.firstRemovePanel = false;
        } else {
            this.mainPanel.remove(this.chartPanel.getScrollPane());
        }
        this.chartPanel = new ChartPanel(newChart);
        this.mainPanel.add("Center", this.chartPanel.getScrollPane());
        this.chartPanel.setFrame(this);
        this.chartPanel.addActionListener(this);
        this.validate();
    }

    private void initControlParam() {
        if (!this.chart.is2DimChart()) {
            boolean isInited = this.initializing;
            this.initializing = true;
            this.enableNavControl();
            this.removeScaleChangeListeners();
            this.removeLightChangeListeners();
            this.zoomMeter.setValue(100.0f * (1.0f - this.chart.getZoomfactor() / 4000.0f));
            this.speedMeter.setValue(this.chart.getAnimateSpeed());
            this.xscale_bar.setDValue(this.chart.getX_scale());
            this.yscale_bar.setDValue(this.chart.getY_scale());
            this.zscale_bar.setDValue(this.chart.getZ_scale());
            this.thickness_bar.setDValue(this.chart.thickRatio);
            this.xlight_bar.setDValue(this.chart.getlightpos_x());
            this.ylight_bar.setDValue(this.chart.getlightpos_y());
            this.zlight_bar.setDValue(this.chart.getlightpos_z());
            this.setDrawMode();
            this.addLightChangeListeners();
            this.addScaleChangeListeners();
            this.initializing = isInited;
        }
    }

    private void removeScaleChangeListeners() {
        this.xscale_bar.removeChangeListener(this);
        this.yscale_bar.removeChangeListener(this);
        this.zscale_bar.removeChangeListener(this);
    }

    private void addScaleChangeListeners() {
        this.xscale_bar.addChangeListener(this);
        this.yscale_bar.addChangeListener(this);
        this.zscale_bar.addChangeListener(this);
    }

    private void removeLightChangeListeners() {
        this.xlight_bar.removeChangeListener(this);
        this.ylight_bar.removeChangeListener(this);
        this.zlight_bar.removeChangeListener(this);
    }

    private void addLightChangeListeners() {
        this.xlight_bar.addChangeListener(this);
        this.ylight_bar.addChangeListener(this);
        this.zlight_bar.addChangeListener(this);
    }

    private int findChartType(String str) {
        for (int i = 0; i < Chart.stypeName.length; ++i) {
            if (!str.equals(Chart.stypeName[i])) continue;
            return i;
        }
        return 0;
    }

    boolean isSaveOnExitEnabled() {
        return this.isSaveOnExit;
    }

    void setSaveOnExitEnabled(boolean b) {
        this.isSaveOnExit = b;
    }

    public boolean do_exitOrganizer() {
        boolean close = true;
        if (this.modified && this.isSaveOnExitEnabled()) {
            int answer = JOptionPane.showConfirmDialog(this, CLOSE_QUESTION, LanguageEncoder.getText("Question"), 1, 3);
            if (answer == 0) {
                if (this.filename == null) {
                    this.do_SaveAs();
                } else {
                    this.do_Save();
                }
            } else if (answer != 1) {
                close = false;
            }
        }
        if (close) {
            this.modified = false;
            this.do_Close();
        }
        return close;
    }

    public boolean do_exit() {
        return this.do_exit(true);
    }

    public boolean do_exit(boolean checkWizard) {
        return this.do_exit(checkWizard, true);
    }

    private boolean do_exit(boolean checkWizard, boolean showCancel) {
        if (this.isDrillDownDefined && this.parentChart != null && this.parentChart.getDrillNumber() > 0) {
            this.showHint(LanguageEncoder.getText("This function is only available for top level chart."), true);
            return false;
        }
        String optionStr = LanguageEncoder.getText("Yes") + "," + LanguageEncoder.getText("No") + "," + LanguageEncoder.getText("Cancel");
        if (!showCancel) {
            optionStr = LanguageEncoder.getText("Yes") + "," + LanguageEncoder.getText("No");
        }
        if (this.isForBean) {
            if (this.modified && this.isSaveOnExitEnabled()) {
                this.exitdialog = new MessageDialog(this, LanguageEncoder.getText("Question"), true, true, optionStr);
                this.exitdialog.addActionListener(this);
                this.exitdialog.show(BEAN_CLOSE_QUESTION);
                return false;
            }
            this.setVisible(false);
            this.do_Close();
            return true;
        }
        if (this.modified && this.isSaveOnExitEnabled()) {
            this.exitdialog = new MessageDialog(this, LanguageEncoder.getText("Question"), true, true, optionStr);
            this.exitdialog.addActionListener(this);
            this.exitdialog.show(CLOSE_QUESTION);
            return false;
        }
        this.cleanup();
        this.dispose();
        if (this.drillDownNavigationFrame != null) {
            try {
                this.drillDownNavigationFrame.setVisible(false);
                this.drillDownNavigationFrame = null;
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to close drilldown navigation frame", ex);
            }
        }
        if (this.chartWizard != null && checkWizard) {
            this.chartWizard.cancel();
        }
        return true;
    }

    public void setQbChartDesigner(QbChartDesigner qbDesigner) {
        this.qbChartDesigner = qbDesigner;
    }

    public void cleanup() {
        if (this.qbChartDesigner != null) {
            this.qbChartDesigner.cleanup();
            return;
        }
        if (this.manager != null) {
            this.manager.designer = null;
            try {
                this.manager.getInitPanel().logoutFromServer();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to log out from server", ex);
            }
        }
    }

    void createBackupChart() {
        try {
            if (this.backupChart == null && this.chart != null) {
                LOGGER.finest("CREATE BACKUP CHART");
                this.backupChart = Chart.createChart(this, this.chart.chartType, this.chart.is2DimChart(), this.chart, null);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to create backup chart", ex);
        }
    }

    void do_undo() {
        Chart previousChart = this.getBackupChart();
        if (previousChart != null) {
            try {
                if (this.backupChart != null) {
                    this.redoChartList.insertElementAt(this.backupChart, 0);
                    if (this.redoChartList.size() > 10) {
                        this.redoChartList.remove(this.redoChartList.size() - 1);
                    }
                    this.backupChart = null;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to load backup chart", ex);
            }
            this.chartPanel.selectobj = null;
            this.fontpanel.setEnabled(false);
            this.colorpanel.setColor(Color.WHITE, true);
            this.showHint("");
            this.setChart(previousChart, true);
        }
        this.enableUndoRedoButtons();
    }

    void do_redo() {
        Chart redoChart = this.getRedoChart();
        if (redoChart != null) {
            try {
                if (this.backupChart != null) {
                    this.undoChartList.insertElementAt(this.backupChart, 0);
                    if (this.undoChartList.size() > 10) {
                        this.undoChartList.remove(this.undoChartList.size() - 1);
                    }
                    this.backupChart = null;
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to load backup chart", ex);
            }
            this.chartPanel.selectobj = null;
            this.setChart(redoChart, true);
        }
        this.enableUndoRedoButtons();
    }

    private void saveBackupChartToUndoList() {
        if (this.backupChart != null) {
            LOGGER.finest("SAVE IT TO UNDO LIST...");
            this.undoChartList.insertElementAt(this.backupChart, 0);
            if (this.undoChartList.size() > 10) {
                this.undoChartList.remove(this.undoChartList.size() - 1);
            }
            this.backupChart = null;
            this.redoChartList.removeAllElements();
        } else {
            LOGGER.finest("MODIFIED BUT NO BACKUP...");
        }
    }

    private Chart getBackupChart() {
        if (this.undoChartList.size() > 0) {
            Chart newChart = this.undoChartList.elementAt(0);
            this.undoChartList.remove(0);
            return newChart;
        }
        return null;
    }

    private Chart getRedoChart() {
        if (this.redoChartList.size() > 0) {
            Chart newChart = this.redoChartList.elementAt(0);
            this.redoChartList.remove(0);
            return newChart;
        }
        return null;
    }

    private void enableUndoRedoButtons() {
        this.redoitem.setEnabled(this.redoChartList.size() > 0);
        this.toolbar.button[22].setEnabled(this.redoChartList.size() > 0);
        this.undoitem.setEnabled(this.undoChartList.size() > 0);
        this.toolbar.button[21].setEnabled(this.undoChartList.size() > 0);
        this.enableMenuItems();
        this.enableZoomHistOptions(!this.isDrillDownEnabled());
    }

    private void clearUndoRedoList() {
        this.backupChart = null;
        this.redoChartList.removeAllElements();
        this.undoChartList.removeAllElements();
        this.enableUndoRedoButtons();
    }

    private void enableMenuItems() {
        if (this.chart != null) {
            this.display3DOptionItem.setEnabled(!this.chart.is2DimChart());
            this.lightingModelItem.setEnabled(!this.chart.is2DimChart());
            this.controlAreaItem.setEnabled(this.chart.isControlRangeEnabled());
        }
    }

    public void do_Save() {
        if (ServerMessage.isEvalVersion()) {
            this.showEvalBox();
        }
        String oldtitle = this.getTitle();
        this.setTitle(LanguageEncoder.getText("Saving..."));
        boolean featureSelected = this.chart.isSaveColorsForCategories();
        this.chart.chartColorSet.setDataPointsColorsMapped(featureSelected);
        if (featureSelected) {
            this.chart.chartColorSet.setChartDataPointsColors(new DataAttribute((MultiDimData)this.chart.mData, (boolean)false, (boolean)this.chart.is2DChart, (int)this.chart.chartType).dataColor);
        }
        if (this.chart.mData2 != null && this.chart.chartColorSet2 != null) {
            this.chart.chartColorSet2.setDataPointsColorsMapped(featureSelected);
            if (featureSelected) {
                this.chart.chartColorSet2.setChartDataPointsColors(new DataAttribute((MultiDimData)this.chart.mData2, (boolean)true, (boolean)this.chart.is2DChart, (int)this.chart.chartType).dataColor);
            }
        }
        try {
            if (this.drillDownTree != null && !this.chart.currentNode.equals((DrillDownNode)this.drillDownTree.getModel().getRoot())) {
                String nodeName = this.chart.currentNode.getFileName();
                if (nodeName != null && nodeName.length() > 4) {
                    this.saveToFile(new SaveChart(this.chart), nodeName.substring(0, nodeName.length() - 4));
                }
                if (this.parentChart != null && this.parentChart.isPACFile()) {
                    this.saveTree(this.chart.getPACFileName(this.filename), (DrillDownNode)this.drillDownTree.getModel().getRoot());
                } else {
                    this.saveTree(this.filename, (DrillDownNode)this.drillDownTree.getModel().getRoot());
                }
            } else {
                SaveChart saveChart = new SaveChart(this.chart);
                if (this.drillDownTree != null) {
                    saveChart.setDrillDownNode((DrillDownNode)this.drillDownTree.getModel().getRoot());
                }
                this.filename = this.getPath(this.filename);
                if (this.filename.endsWith(".xml")) {
                    String chartName = this.chart.getXMLChartLocation();
                    try {
                        this.saveToFile(saveChart, chartName.substring(0, chartName.length() - 4), chartName.endsWith(".tpl"), chartName.endsWith(".pac"));
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINEST, "Failed to save chart to file", ex);
                    }
                    saveChart.createXMLChartFile(this.filename, this.chart.getXMLChartLocation());
                } else {
                    this.saveToFile(saveChart, this.filename.substring(0, this.filename.length() - 4), this.filename.endsWith(".tpl"), this.filename.endsWith(".pac"));
                }
            }
            this.setTitle(this.filename);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Saving failed", ex);
            this.actionCallback = false;
            this.isClose = false;
            this.doClose = false;
            new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(ex.toString());
            this.setTitle(oldtitle);
            return;
        }
        this.insertChartFileToOrganizer(null, false);
        this.setUnModified();
        this.showStatus(LanguageEncoder.getText("Save success"));
        if (this.doClose) {
            this.doClose = false;
            this.do_Close();
            return;
        }
        if (this.actionCallback) {
            this.startNew();
            this.actionCallback = false;
        }
        if (this.isClose) {
            this.cleanup();
            this.dispose();
        }
        if (this.bgoback) {
            this.bgoback = false;
            this.do_JumpLink();
        }
        if (this.bgoback2) {
            this.bgoback2 = false;
            this.do_goback();
        }
    }

    public void do_SaveToDatabase(String dbLabel) {
        boolean newID = false;
        if (this.filename == null || !this.isChartData(this.filename) || dbLabel != null && this.getItemName() != null && !dbLabel.equals(this.getItemName())) {
            this.filename = this.createChartDataName();
            newID = true;
        }
        if (ServerMessage.isEvalVersion()) {
            this.showEvalBox();
        }
        String oldtitle = this.getTitle();
        this.setTitle(LanguageEncoder.getText("Saving..."));
        try {
            if (this.drillDownTree != null && !this.chart.currentNode.equals((DrillDownNode)this.drillDownTree.getModel().getRoot())) {
                String nodeName = this.chart.currentNode.getFileName();
                if (nodeName != null && nodeName.length() > 4) {
                    this.saveToFile(new SaveChart(this.chart), nodeName.substring(0, nodeName.length() - 4));
                }
                this.saveTree(this.filename, (DrillDownNode)this.drillDownTree.getModel().getRoot());
            } else {
                SaveChart saveChart = new SaveChart(this.chart);
                if (this.drillDownTree != null) {
                    saveChart.setDrillDownNode((DrillDownNode)this.drillDownTree.getModel().getRoot());
                }
                this.filename = this.getPath(this.filename);
                this.saveToDatabase(saveChart, this.filename.substring(0, this.filename.length() - 4), this.filename.endsWith(".tpl"), newID);
            }
            this.setTitle(this.filename);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Saving to database failed", ex);
            this.actionCallback = false;
            this.isClose = false;
            this.doClose = false;
            new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(ex.toString());
            this.setTitle(oldtitle);
            return;
        }
        if (dbLabel != null) {
            this.setItemName(dbLabel);
        }
        this.insertChartFileToOrganizer(dbLabel, false);
        this.setUnModified();
        this.showStatus(LanguageEncoder.getText("Save success"));
        if (this.doClose) {
            this.doClose = false;
            this.do_Close();
            return;
        }
        if (this.actionCallback) {
            this.startNew();
            this.actionCallback = false;
        }
        if (this.isClose) {
            this.cleanup();
            this.dispose();
        }
        if (this.bgoback) {
            this.bgoback = false;
            this.do_JumpLink();
        }
        if (this.bgoback2) {
            this.bgoback2 = false;
            this.do_goback();
        }
    }

    public void onDocSave() {
        if (this.parentChart != null && this.parentChart.getDrillNumber() > 0) {
            String tplName = this.createDrillTemplateName();
            LOGGER.finest("Saving drill template: " + tplName);
            this.doSaveDrillTemplate(this.chart, tplName);
            return;
        }
        if (this.chart.chartType != 3 && this.chart.getComboType() != 0) {
            this.chart.setStepLineState(false);
            this.chart.setStepLineState2(false);
        }
        if (this.filename == null || this.filename.toUpperCase().endsWith("QCH")) {
            this.do_SaveAs();
        } else if (this.isChartData(this.filename)) {
            this.do_SaveToDatabase(null);
        } else {
            this.do_Save();
        }
    }

    private void doSaveDrillTemplate(Chart chart, String file) {
        String oldtitle = this.getTitle();
        this.setTitle(LanguageEncoder.getText("Saving..."));
        if (!file.endsWith(".tpl")) {
            file = file + ".tpl";
        }
        try {
            SaveChart sChart = new SaveChart(chart);
            this.saveToFile(sChart, file.substring(0, file.length() - 4), true, false);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Failed to save drilldown template", ex);
            this.setTitle(oldtitle);
            new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(ex.toString());
        }
        this.ignoreSave = true;
        this.setUnModified();
        this.setTitle(oldtitle);
    }

    void do_saveChart(String file, boolean generateHtml, int viewerType, boolean useSwing, boolean generateXML) {
        String lfile;
        if (file == null) {
            return;
        }
        if (ServerMessage.isEvalVersion()) {
            this.showEvalBox();
        }
        if ((lfile = (file = this.getPath(file)).toLowerCase()).endsWith(".xml")) {
            file = file.substring(0, file.length() - 4);
        } else if (!(lfile.endsWith(".tpl") || lfile.endsWith(".cht") || lfile.endsWith(".qch") || lfile.endsWith(".pac"))) {
            file = file + ".pac";
        }
        String oldtitle = this.getTitle();
        this.setTitle(LanguageEncoder.getText("Saving..."));
        try {
            SaveChart saveChart = new SaveChart(this.chart);
            saveChart.generateHtmlFile(generateHtml, viewerType, useSwing);
            saveChart.generateXMLFile(generateXML);
            if (this.drillDownTree != null && !this.chart.currentNode.equals((DrillDownNode)this.drillDownTree.getModel().getRoot())) {
                String nodeName = this.chart.currentNode.getFileName();
                if (nodeName != null && nodeName.length() > 4) {
                    this.saveToFile(saveChart, nodeName.substring(0, nodeName.length() - 4));
                }
                this.saveTree(file, (DrillDownNode)this.drillDownTree.getModel().getRoot());
            } else {
                if (this.drillDownTree != null) {
                    saveChart.setDrillDownNode((DrillDownNode)this.drillDownTree.getModel().getRoot());
                }
                if ((file = this.getPath(file)).endsWith(".xml")) {
                    String chartName = this.chart.getXMLChartLocation();
                    this.saveToFile(saveChart, chartName.substring(0, chartName.length() - 4), chartName.endsWith(".tpl"), chartName.endsWith(".pac"));
                    saveChart.createXMLChartFile(file, this.chart.getXMLChartLocation());
                } else {
                    this.saveToFile(saveChart, file.substring(0, file.length() - 4), file.endsWith(".tpl"), file.endsWith(".pac"));
                }
            }
            this.setTitle(file);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Saving failed", ex);
            new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(ex.toString());
            this.setTitle(oldtitle);
            this.doClose = false;
            this.isClose = false;
            this.actionCallback = false;
            this.bgoback = false;
            this.bgoback2 = false;
            return;
        }
        if (file != null) {
            this.filename = file;
        }
        this.insertChartFileToOrganizer(null, generateXML);
        this.setUnModified();
        this.showStatus(LanguageEncoder.getText("Save success"));
        if (this.isClose) {
            this.cleanup();
            this.dispose();
            return;
        }
        if (this.doClose) {
            this.doClose = false;
            this.do_Close();
            return;
        }
        if (this.actionCallback) {
            this.startNew();
            this.actionCallback = false;
        }
        if (this.bgoback) {
            this.bgoback = false;
            this.do_JumpLink();
        }
        if (this.bgoback2) {
            this.bgoback2 = false;
            this.do_goback();
        }
    }

    void do_SaveAs() {
        if (this.byPassSaveAs != null) {
            String tmp = null;
            if (this.filename != null) {
                tmp = this.filename;
            }
            Properties prop = this.byPassSaveAs.getSaveAsProperties(tmp);
            tmp = this.byPassSaveAs.getFileName(tmp);
            boolean generateHtml = this.getBoolean(prop.getProperty("CREATE_HTML"), false);
            int viewerType = 0;
            boolean useSwing = this.getBoolean(prop.getProperty("USE_SWINGVIEWER"), false);
            boolean generateXML = this.getBoolean(prop.getProperty("GENERATE_XML"), false);
            if (tmp != null) {
                this.do_saveChart(tmp, generateHtml, viewerType, useSwing, generateXML);
                return;
            }
        }
        if (this.isDrillDownDefined && this.parentChart != null && this.parentChart.getDrillNumber() > 0) {
            this.showHint(LanguageEncoder.getText("This function is only available for top level chart."), true);
            return;
        }
        String defaultDir = this.getBrowseDirectories().getChartTemplatesDirectory();
        if (defaultDir.endsWith("/")) {
            defaultDir = defaultDir.substring(0, defaultDir.length() - 1);
        }
        if (!defaultDir.endsWith("\\")) {
            defaultDir = defaultDir + "\\";
        }
        String defaultFileName = null;
        int defaultSaveFormat = 0;
        if (this.filename != null) {
            String str = this.filename.toLowerCase();
            if (str.endsWith(".cht") || str.endsWith(".tpl") || str.endsWith(".pac") || str.endsWith(".xml")) {
                if (str.endsWith(".cht")) {
                    defaultSaveFormat = 1;
                } else if (str.endsWith(".tpl")) {
                    defaultSaveFormat = 2;
                } else if (str.endsWith(".xml")) {
                    defaultSaveFormat = 3;
                }
                defaultFileName = this.filename.substring(0, this.filename.length() - 4);
            } else {
                defaultFileName = this.filename;
            }
            int index = this.filename.replace('\\', '/').lastIndexOf(47);
            if (index >= 0) {
                defaultDir = this.filename.substring(0, index);
            }
        }
        OpenSaveDialog dialog = new OpenSaveDialog(this, LanguageEncoder.getText("Save As..."), 3, defaultSaveFormat);
        dialog.setCurrentDirectory(defaultDir, defaultFileName);
        dialog.setVisible(true);
        try {
            if (new FileInfo(dialog.getCurrentDirectory()).exists()) {
                this.getBrowseDirectories().setChartTemplatesDirectory(dialog.getCurrentDirectory());
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to set templates directory", ex);
        }
        if (this.chart != null && this.drillDownTree != null && this.chart.currentNode.equals((DrillDownNode)this.drillDownTree.getModel().getRoot())) {
            this.chart.currentNode.setFileName(this.filename);
            this.copyChildNodes(this.chart.currentNode);
            this.setDrillDownTree(new JTree(new DrillDownTreeModel(this.chart.currentNode)));
        }
    }

    private boolean getBoolean(String s, boolean b) {
        if (s == null) {
            return b;
        }
        return s.equalsIgnoreCase("true");
    }

    private void saveToFile(SaveChart saveChart, String fileName) throws Exception {
        this.saveToFile(saveChart, fileName, true, false);
    }

    private void saveToFile(SaveChart saveChart, String fileName, boolean template, boolean pack) throws Exception {
        saveChart.pack = pack;
        if (!saveChart.createXML) {
            if (this.chart.currentNode != null && this.drillDownTree != null && this.chart.currentNode.equals((DrillDownNode)this.drillDownTree.getModel().getRoot())) {
                this.chart.currentNode.setFileName(fileName + (template ? ".tpl" : ".cht"));
            }
            if (this.chartIO == null) {
                saveChart.saveToFile(this.getPath(fileName), template, this.isReportPakFile());
                return;
            }
            ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
            DataOutputStream out = new DataOutputStream(fstream);
            String name = saveChart.saveToFile(fileName, out, template);
            out.close();
            fstream.close();
            this.filename = this.chartIO.saveChartFile(fstream.toByteArray(), name);
        } else {
            String xmlName = null;
            if (fileName.toLowerCase().endsWith(".pac") || fileName.toLowerCase().endsWith(".cht") || fileName.toLowerCase().endsWith(".tpl")) {
                xmlName = fileName.substring(0, fileName.length() - 4) + ".xml";
            } else if (!fileName.toLowerCase().endsWith(".xml")) {
                xmlName = fileName.substring(0, fileName.length()) + ".xml";
            }
            if (!OverWriteDialog.continueSave(this, xmlName)) {
                return;
            }
            ByteArrayOutputStream fstream2 = new ByteArrayOutputStream(2048);
            saveChart.createXMLChartFile(fstream2, fileName);
            fstream2.close();
            if (this.chartIO != null) {
                this.filename = this.chartIO.saveChartFile(fstream2.toByteArray(), xmlName);
            } else {
                saveChart.saveToFile(this.getPath(fileName), template, this.isReportPakFile());
            }
        }
    }

    private void saveToDatabase(SaveChart saveChart, String fileName, boolean template, boolean newID) throws Exception {
        saveChart.pack = true;
        if (this.chart.currentNode != null && this.drillDownTree != null && this.chart.currentNode.equals((DrillDownNode)this.drillDownTree.getModel().getRoot())) {
            this.chart.currentNode.setFileName(fileName + (template ? ".tpl" : ".cht"));
        }
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        saveChart.saveToFile(fileName, out, template);
        out.close();
        fstream.close();
        this.saveToDatabase(fstream.toByteArray(), fileName + ".pac", newID);
    }

    public String createChartDataName() {
        return null;
    }

    void saveTree(String url, DrillDownNode node) throws Exception {
        if (this.chartIO == null) {
            SaveChart.saveTree(this.chart, url, node);
            return;
        }
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        SaveChart.saveTree(url, node, out);
        out.close();
        fstream.close();
        this.filename = this.chartIO.saveChartFile(fstream.toByteArray(), url);
    }

    void do_Export() {
        this.exportDialog = null;
        try {
            this.exportDialog = new ExportDialog(this, LanguageEncoder.getText("Export..."));
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to initialize export dialog", ex);
            new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(ex.toString());
            return;
        }
        if (this.chartPanel.chart.tableInPanel) {
            GraphicsTable.recoverTableSize(this.exportDialog.chartmain.chart);
            GraphicsTable.recoverTableSize(this.exportDialog.chartmain.chartPanel.chart);
        }
        this.exportDialog.setVisible(true);
    }

    void do_ChangeDataMappingOption(boolean reloadData) {
        if (this.isFieldDrillDownChart()) {
            this.showHint(LanguageEncoder.getText("Please undo field drill-down before modify data mapping!"), true);
            return;
        }
        if (this.isDrillDownEnabled()) {
            this.showHint(LanguageEncoder.getText("Please remove drill-down layer before modify data mapping!"), true);
            return;
        }
        if (this.chart.isTimeChart()) {
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Please undo zooming before modify data mapping!"));
            return;
        }
        if (this.chart.isHistogram()) {
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Please remove histogram before modify data mapping!"));
            return;
        }
        if (this.chart.isAggregationChart()) {
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Please remove aggregation before modify data mapping!"));
            return;
        }
        if (this.chartPanel.chart.tableInPanel) {
            GraphicsTable.recoverTableSize(this.chart);
        }
        if (!this.chart.is2DimChart()) {
            this.chartPanel.animation = false;
            this.animateButton.setSelected(false);
            this.enableNavControl();
        }
        this.bchart2d = this.chart.is2DimChart();
        if (this.optionDialog == null || this.optionDialog.isChartType || this.optionDialog.changeType) {
            this.optionDialog = new OptionDialog(this);
            this.optionDialog.init();
        }
        this.optionDialog.initialize(reloadData);
        this.optionDialog.setVisible(true);
    }

    private void do_drillDynamic() {
        DrillDynamicDialog dynamicDialog = null;
        if (this.isDrillDownDefined) {
            return;
        }
        if (this.chart.hyperlinkList != null && this.chart.hyperlinkList.size() > 0) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("Please remove all the hyperlinks before contine."));
            return;
        }
        if (this.chartPanel.chart.colData[this.chartPanel.chart.valueCol].dataType == 0) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("Type of vaue column cannot be boolean/logical."));
            return;
        }
        if (this.chartPanel.chart.subvalueCol >= 0 && this.chartPanel.chart.colData[this.chartPanel.chart.subvalueCol].dataType == 0) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("Type of subvalue column cannot be boolean/logical."));
            return;
        }
        if (!this.isDrillDownEnabled()) {
            this.drillTemplateName = null;
            this.chartPanel.chart.primaryAggregate = -1;
            this.chartPanel.chart.secondaryAggregate = -1;
            if (this.chart.isHistogram()) {
                MessageDialog.showError(this, true, LanguageEncoder.getText("Drill-Down not available for historgram plots!"));
                return;
            }
            if (this.chart.isAggregationChart()) {
                MessageDialog.showError(this, true, LanguageEncoder.getText("Drill-Down not available for aggregation plots!"));
                return;
            }
            if (this.chart.isTimeChart()) {
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Please undo zooming before drill-down!"));
                return;
            }
        }
        if (!this.chart.is2DimChart()) {
            this.chartPanel.animation = false;
            this.animateButton.setSelected(false);
            this.enableNavControl();
        }
        GraphicsTable.recoverTableSize(this.chart);
        dynamicDialog = new DrillDynamicDialog(this);
        dynamicDialog.setVisible(true);
    }

    public JTree getDrillDownTree() {
        return this.drillDownTree;
    }

    public void setDrillDownTree(JTree t) {
        this.getTitle();
        if (t == null && this.drillDownNavigationFrame != null) {
            this.drillDownNavigationFrame.setVisible(false);
            this.drillDownNavigationFrame.dispose();
            this.drillDownNavigationFrame = null;
        } else if (t != this.drillDownTree && this.drillDownNavigationFrame != null) {
            this.drillDownNavigationFrame.updateTree(t);
        }
        if (t != null) {
            t.validate();
            t.repaint();
        }
        this.drillDownTree = t;
    }

    private void do_drillNavigate() {
        if (this.isDrillDownDefined) {
            return;
        }
        if (this.chart.hyperlinkList != null && this.chart.hyperlinkList.size() > 0) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("Please remove all the hyperlinks before contine."));
            return;
        }
        if (this.chartPanel.chart.colData[this.chartPanel.chart.valueCol].dataType == 0) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("Type of vaue column cannot be boolean/logical."));
            return;
        }
        if (this.chartPanel.chart.subvalueCol >= 0 && this.chartPanel.chart.colData[this.chartPanel.chart.subvalueCol].dataType == 0) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("Type of subvalue column cannot be boolean/logical."));
            return;
        }
        if (!this.isDrillDownEnabled()) {
            this.drillTemplateName = null;
            this.chartPanel.chart.primaryAggregate = -1;
            this.chartPanel.chart.secondaryAggregate = -1;
            if (this.chart.isHistogram()) {
                MessageDialog.showError(this, true, LanguageEncoder.getText("Drill-Down not available for historgram plots!"));
                return;
            }
            if (this.chart.isAggregationChart()) {
                MessageDialog.showError(this, true, LanguageEncoder.getText("Drill-Down not available for aggregation plots!"));
                return;
            }
            if (this.chart.isTimeChart()) {
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Please undo zooming before drill-down!"));
                return;
            }
        }
        if (!this.chart.is2DimChart()) {
            this.chartPanel.animation = false;
            this.animateButton.setSelected(false);
            this.enableNavControl();
        }
        if (this.drillDownNavigationFrame == null) {
            try {
                this.drillDownNavigationFrame = new DrillDownNavigationFrame(this);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Failed to initialize drilldown navigation frame", e);
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(e.toString());
                return;
            }
        }
        this.drillDownNavigationFrame.setPosition();
        this.drillDownNavigationFrame.setVisible(true);
    }

    public void addDrillDown() {
        JMessageDialog msgDialog;
        int response;
        if (this.isModified() && (response = (msgDialog = new JMessageDialog((Frame)this, "Question", LanguageEncoder.getText("Current Chart must be saved before inserting a drill-down chart. Continue?"), 2)).getResponse()) == 5) {
            return;
        }
        boolean old_state = this.isModified();
        this.setModified();
        this.onDocSave();
        if (this.isModified()) {
            this.modified = old_state;
            return;
        }
        this.chartWizard = new ChartWizard(this, null, null, false);
        this.chartWizard.init();
        this.chartWizard.setFieldDrillDownOp(true);
        if (this.forceNewChart) {
            this.chartWizard.newChart(false, null);
        } else {
            this.chartWizard.setVisible(true);
        }
    }

    private void do_drillDown() {
        DrillNameDialog dnameDialog = null;
        if (this.chart.hyperlinkList != null && this.chart.hyperlinkList.size() > 0) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("Please remove all the hyperlinks before continue."));
            return;
        }
        if (this.chartPanel.chart.colData[this.chartPanel.chart.valueCol].dataType == 0) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("Type of vaue column cannot be boolean/logical."));
            return;
        }
        if (this.chartPanel.chart.subvalueCol >= 0 && this.chartPanel.chart.colData[this.chartPanel.chart.subvalueCol].dataType == 0) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("Type of subvalue column cannot be boolean/logical."));
            return;
        }
        if (!this.isDrillDownEnabled()) {
            this.drillTemplateName = null;
            this.chartPanel.chart.primaryAggregate = -1;
            this.chartPanel.chart.secondaryAggregate = -1;
            if (this.chart.isHistogram()) {
                MessageDialog.showError(this, true, LanguageEncoder.getText("Drill-Down not available for historgram plots!"));
                return;
            }
            if (this.chart.isAggregationChart()) {
                MessageDialog.showError(this, true, LanguageEncoder.getText("Drill-Down not available for aggregation plots!"));
                return;
            }
            if (this.chart.isTimeChart()) {
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Please undo zooming before drill-down!"));
                return;
            }
        }
        if (!this.chart.is2DimChart()) {
            this.chartPanel.animation = false;
            this.animateButton.setSelected(false);
            this.enableNavControl();
        }
        if (this.chartPanel.chart.primaryAggregate < 0 && !this.isDrillDownEnabled()) {
            int categoryType = this.chartPanel.chart.getCategoryType();
            if (categoryType != 92 && categoryType != 91 && categoryType != 93) {
                this.displayAggregatesDialog(true);
                return;
            }
            this.do_ZoomOptions(true);
            if (!this.chart.isTimeChart()) {
                return;
            }
        }
        if (this.drillTemplateName == null || this.drillTemplateName.equals("")) {
            dnameDialog = new DrillNameDialog(this, LanguageEncoder.getText("Enter a base drill-down name to use."), null);
            dnameDialog.pack();
            dnameDialog.setVisible(true);
            return;
        }
        this.displayDrillDown();
    }

    private void copyChildNodes(DrillDownNode node) {
        int i;
        Vector<DrillDownNode> children = new Vector<DrillDownNode>();
        for (i = 0; i < node.getChildCount(); ++i) {
            children.addElement(node.getChildAt(i));
        }
        node.removeAllChildren();
        for (i = 0; i < children.size(); ++i) {
            DrillDownNode oldChild = (DrillDownNode)children.elementAt(i);
            DrillDownNode newChild = node.createNewChild(oldChild.getName());
            newChild.setColumnMapping(oldChild.getColumnMapping());
            try {
                CopyFile.copy(oldChild.getFileName(), newChild.getFileName());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to rename drilldown template", ex);
            }
            if (oldChild.isLeaf()) continue;
            for (int j = 0; j < oldChild.getChildCount(); ++j) {
                newChild.add(oldChild.getChildAt(j));
            }
            this.copyChildNodes(newChild);
        }
    }

    private void do_drillRemove() {
        this.checkRemoveDialog = new MessageDialog(QbDialog.findFrame(this), LanguageEncoder.getText("Question"), true, true, LanguageEncoder.getText("Yes") + "," + LanguageEncoder.getText("No") + "," + LanguageEncoder.getText("Cancel"));
        this.checkRemoveDialog.addActionListener(this);
        this.checkRemoveDialog.show(LanguageEncoder.getText("Remove this drill-down chart from list?"));
    }

    private void do_drillRemoveAll() {
        if (this.isDrillDownEnabled()) {
            this.isOkToChange = true;
            new DrillYesNoDialog(this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("It will lose all the drill-down charts. Continue?")).setVisible(true);
            if (!this.isOkToChange) {
                this.isOkToChange = true;
                return;
            }
        }
    }

    void resetDrillDownChart() {
        GraphicsTable.recoverTableSize(this.parentChart);
        Chart tempChart = this.parentChart;
        tempChart.drillDownVector = null;
        tempChart.usedColumns = null;
        tempChart.summaryChart = false;
        tempChart.drillNumber = 0;
        tempChart.valueTable.setDrillHistory(null);
        tempChart.setTimeChart(false);
        tempChart.isDynamicDrillDown = false;
        this.parentChart = tempChart = ReloadChart.reloadData(tempChart, true, true);
        this.nextDrill = false;
        this.previousDrill = false;
        this.drillHistory = null;
        this.enableZoomHistOptions(true);
        this.isDrillDownDefined = false;
        this.enableNonDrillDownMenu(true);
        this.setNewChart(tempChart);
        this.setFileName(this.filename);
        this.setModified();
    }

    public String getDrillDownName() {
        if (this.filename != null && this.drillTemplateName == null && this.isChartData(this.filename)) {
            this.setDrillDownName(OrgUtil.createTemplateName(this.filename));
        }
        return this.drillTemplateName;
    }

    public void setDrillDownName(String dName) {
        this.chart.drillTemplateName = this.drillTemplateName = dName;
    }

    private String createDrillTemplateName() {
        int index;
        String drillTName = null;
        if (this.parentChart == null) {
            this.parentChart = this.chart;
        }
        this.isDrillDownDefined = this.parentChart.drillDownVector.size() > 0;
        if (this.parentChart.drillDownVector.size() <= 0) {
            return null;
        }
        int num = this.parentChart.getDrillNumber() - 1;
        if (num < 0) {
            num = 0;
        }
        drillTName = (index = this.getDrillDownName().indexOf(58)) < 0 ? this.chart.drillTemplatePath + this.getDrillDownName() + num + ".tpl" : this.getDrillDownName() + num + ".tpl";
        return drillTName;
    }

    private void displayAggregatesDialog(boolean displayDrillWizard) {
        boolean secAxisExists = false;
        int secAxis = this.chartPanel.chart.getSecondaryIndex();
        if (secAxis >= 0) {
            secAxisExists = true;
        }
        this.drillAggDialog = new DrillDownAggregate(this, secAxisExists, displayDrillWizard);
        this.drillAggDialog.pack();
        this.drillAggDialog.setVisible(true);
    }

    public void displayDrillDown() {
        String oldTitle = this.getTitle();
        this.setTitle(LanguageEncoder.getText("Please wait..."));
        this.pickingData();
        if (this.isDrillDownDefined) {
            this.currentLevel = this.parentChart.getDrillNumber();
            while (this.parentChart.isDrillDownDefined()) {
                this.parentChart.incrementDrillNumber();
            }
            this.originalMetaData = ReloadChart.getMetaDataInfo(this.parentChart);
            boolean moreCols = this.parentChart.fillUsedColumns2(this.originalMetaData);
            if (this.chartPanel.chart.notEnoughData() || !moreCols) {
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("No more data available to plot."));
                while (this.parentChart.getDrillNumber() > this.currentLevel) {
                    this.parentChart.decrementDrillNumber();
                }
                this.currentLevel = -1;
                this.setTitle(oldTitle);
                return;
            }
        } else {
            this.currentLevel = -1;
            this.chart.usedColumns = null;
            boolean moreCols = this.chart.fillUsedColumns();
            if (this.chartPanel.chart.notEnoughData() || !moreCols) {
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("No more data available to plot."));
                this.setTitle(oldTitle);
                this.chart.usedColumns = null;
                if (this.parentChart != null) {
                    this.parentChart.usedColumns = null;
                }
                return;
            }
        }
        this.drillDialog = new DrillDownDialog(this);
        this.drillDialog.init();
        this.setTitle(oldTitle);
        if (this.drillDialog.chartOptionPanel.chartPanel != null) {
            this.drillDialog.setVisible(true);
        } else {
            this.drillDialog.setVisible(false);
        }
    }

    public void backToCurrentLevel() {
        if (this.currentLevel < 0) {
            return;
        }
        if (this.parentChart == null) {
            this.currentLevel = -1;
            return;
        }
        while (this.parentChart.getDrillNumber() > this.currentLevel) {
            this.parentChart.decrementDrillNumber();
        }
        while (this.parentChart.getDrillNumber() < this.currentLevel) {
            this.parentChart.incrementDrillNumber();
        }
        this.currentLevel = -1;
    }

    void do_3DOption() {
        if (this.chart.is2DimChart()) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("This option is only available for 3D chart."));
            return;
        }
        ApproximateDialog dialog = new ApproximateDialog(this, this.chart);
        dialog.setVisible(true);
    }

    void do_RenderingOption() {
        new RenderingDialog(this, LanguageEncoder.getText("Rendering Options...")).setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    void do_ChartOption() {
        boolean showDialog = false;
        if (this.chart.isCircularChart()) {
            PieOptionsDlg d = new PieOptionsDlg(this, this.chart);
            d.pack();
            d.setVisible(true);
        } else if (this.chart.is2DimChart() && this.chart.chartType == 10 && this.chart.comboType == 3) {
            new ChartOptionDialog(this, this.chart, false, true, false, true).setVisible(true);
        } else if (this.chart.chartType == 10) {
            if (this.chart.getComboType() == 0 && this.chart.is2DimChart() && this.chart.getSubValueMap() != -1) {
                new ChartOptionDialog(this, this.chart, false, false, false, true, true).setVisible(true);
            } else {
                new ChartOptionDialog(this, this.chart, false, false, false, true, false).setVisible(true);
            }
        } else if (this.chart.chartType == 2 && !this.chart.is2DimChart()) {
            ChartOptionDialog optDialog = new ChartOptionDialog(this, this.chart, false, false, false, false, false, false, true);
            if (optDialog.isNothingToShow()) {
                showDialog = true;
            } else {
                optDialog.setVisible(true);
            }
        } else if (this.chart.chartType == 0 || this.chart.chartType == 1) {
            if (this.chart.getComboType() == 0 && this.chart.is2DimChart() && this.chart.getSubValueMap() != -1) {
                new ColumnDialog(this, this.chart, (Boolean)true).setVisible(true);
            } else {
                new ColumnDialog(this, this.chart).setVisible(true);
            }
        } else if (!this.chart.is2DimChart()) {
            showDialog = true;
        } else if (this.chart.chartType == 13) {
            new BubbleDialog(this, this.chart).setVisible(true);
        } else if (this.chart.chartType == 19) {
            new PolarDialog(this, this.chart).setVisible(true);
        } else if (this.chart.chartType == 16) {
            new RadarDialog(this, this.chart).setVisible(true);
        } else if (this.chart.chartType == 17) {
            new DialDialog(this, this.chart).setVisible(true);
        } else if (this.chart.chartType == 18) {
            new GanttDialog(this, this.chart).setVisible(true);
        } else if (this.chart.chartType == 15) {
            if (this.chart.getComboType() == 0 && this.chart.getSubValueMap() != -1) {
                new ChartOptionDialog(this, this.chart, false, false, false, false, true, true).setVisible(true);
            } else {
                new ChartOptionDialog(this, this.chart, false, false, false, false, false, true).setVisible(true);
            }
        } else if (this.chart.chartType == 2) {
            new ChartOptionDialog(this, this.chart, false, false, false, false, true, false, true).setVisible(true);
        } else if (this.chart.chartType == 3) {
            if ((this.chart.dataDim < 2 || this.chart.mDataLen[0] < 2) && this.chart.dataDim != 1) {
                MessageDialog.showError(this, true, LanguageEncoder.getText("This option is only available for 2D line chart with more than 1 series or no series."));
                return;
            }
            new LineDialog(this, this.chart).setVisible(true);
        } else if (this.chart.getComboType() == 0 && this.chart.getSubValueMap() != -1 && this.chart.getChartType() != 8 && this.chart.chartType != 14) {
            new ChartOptionDialog(this, this.chart, false, false, false, false, true).setVisible(true);
        } else if (this.chart.chartType == 8 && this.chart.comboType == 3) {
            new ChartOptionDialog(this, this.chart, false, true, true, false).setVisible(true);
        } else if (this.chart.chartType == 8 && this.chart.comboType == 0) {
            new ChartOptionDialog(this, this.chart, false, false, true, false, true).setVisible(true);
        } else if (this.chart.chartType == 14) {
            if (this.chart.getComboType() == 0) {
                new ChartOptionDialog(this, this.chart, true, false, false, false, true).setVisible(true);
            } else {
                new ChartOptionDialog(this, this.chart, true, false, false, false).setVisible(true);
            }
        } else if (this.chart.comboType == 3) {
            new ChartOptionDialog(this, this.chart, false, true, false, false).setVisible(true);
        } else if (this.chart.getChartType() == 8 || this.chart.getComboType() == 1) {
            new ChartOptionDialog(this, this.chart, false, false, true, false).setVisible(true);
        } else {
            showDialog = true;
        }
        if (showDialog) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("This option is only available for column, bar, scatter, hlco, box, radar, polar, bubble, dial, Gantt, overlay, pie, 2D line or 2D stack area chart / combo chart."));
        }
    }

    void do_CanvasSize() {
        Dimension size = this.chart.getSize();
        new SizeDialog(this, size.width, size.height).setVisible(true);
    }

    private void do_DataBorder() {
        int chartType = this.chart.getChartType();
        if (chartType == 12 || chartType == 2 || chartType == 3 || chartType == 13 || chartType == 15 || chartType == 16 || chartType == 17 || chartType == 19) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("This option is not available for Surface, Scatter, Line, Bubble, Box, Radar, Dial and Polar charts."));
            return;
        }
        new DataBorderDialog(this).setVisible(true);
    }

    protected void do_help() {
        QbUtil.showDocumentation();
    }

    void do_PlotArea() {
        if (this.chart.isCircularChart()) {
            this.showHint(LanguageEncoder.getText("This function is not available for Pie Chart."), true);
        } else {
            new PlotAreaDialog(this, LanguageEncoder.getText("Plot Area...")).setVisible(true);
        }
    }

    private void do_NoDataToPlotMessage() {
        new NoDataToPlotMessageDialog(this, LanguageEncoder.getText("No Data To Plot Message...")).setVisible(true);
    }

    private void do_FlashHintBoxCustomization() {
        FlashHintBoxDialog dialog = new FlashHintBoxDialog(this, this.chart.flashHintFont, this.chart.flashHintFontColor, this.chart.flashHintBgColor, this.chart.flashHintBorderColor, this.chart.flashEnableHintBox);
        dialog.setVisible(true);
        if (!dialog.isCancel()) {
            this.chart.flashHintFont = dialog.getFont();
            this.chart.flashHintFontColor = dialog.getFlashFontColor();
            this.chart.flashHintBgColor = dialog.getFlashBgColor();
            this.chart.flashHintBorderColor = dialog.getFlashBorderColor();
            this.chart.flashEnableHintBox = dialog.isFlashEnableHintBox();
        }
    }

    void do_TextProperties() {
        new TextPropertiesDialog(this, LanguageEncoder.getText("Text Properties...")).setVisible(true);
    }

    private void do_NullDataProperties() {
        if (this.chart.isTimeChart()) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("Please undo zoom first!"));
            return;
        }
        new NullDataPropertiesDialog(this, LanguageEncoder.getText("Null Data Properties...")).setVisible(true);
    }

    private void do_ChartViewer() {
        new ChartViewerDialog(this, LanguageEncoder.getText("Viewer Options...")).setVisible(true);
    }

    void do_PointLine() {
        Object selectobj = this.chartPanel.selectobj;
        if (selectobj instanceof PolyLine) {
            new PolyLineDialog(this, (PolyLine)selectobj).setVisible(true);
        } else if (this.chart.is2DimChart()) {
            if (selectobj instanceof DataLine) {
                DataLine dLine = (DataLine)selectobj;
                new LineStyleDialog(this, dLine).setVisible(true);
            } else {
                new LinePointDialog(this, LanguageEncoder.getText("Line and Point...")).setVisible(true);
            }
        } else if (this.chart.chartType == 12) {
            new PointDialog(this, LanguageEncoder.getText("Point ...")).setVisible(true);
        } else {
            String str = LanguageEncoder.getText("Current chart type does not support this function.");
            this.showHint(str);
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), str);
        }
    }

    private void do_LayoutToggle() {
        boolean isInited = this.initializing;
        this.initializing = true;
        this.cfpanel.setVisible(!this.cfexist);
        this.cfexist = !this.cfexist;
        ((JCheckBoxMenuItem)this.layoutmenu.getItem(0)).setSelected(this.cfexist);
        this.centerPanel.validate();
        this.setChartPanel(this.chart);
        this.qbpaint();
        this.sizelabel.setSize();
        this.initializing = isInited;
    }

    private void setObjectColor(Color color) {
        if (this.chartPanel.selectobj == null) {
            return;
        }
        this.createBackupChart();
        if (this.chartPanel.selectobj instanceof FaceData && this.chart.chartType == 12) {
            this.setModified();
            this.chart.set3DSurfaceColor(color);
            return;
        }
        if (this.chartPanel.chart.tableInPanel && this.chartPanel.selectobj instanceof GraphicsTable) {
            this.setModified();
            GraphicsTable tmpgt = (GraphicsTable)this.chartPanel.selectobj;
            if (tmpgt.select == 0) {
                tmpgt.headColor = color;
            } else if (tmpgt.select == 1) {
                tmpgt.cellColor = color;
            } else if (tmpgt.select == 2) {
                tmpgt.headTextColor = color;
            } else if (tmpgt.select == 3) {
                tmpgt.cellTextColor = color;
            }
            return;
        }
        if (this.chartPanel.selectobj instanceof MultiDimData) {
            this.setModified();
            MultiDimData selectedMData = (MultiDimData)this.chartPanel.selectobj;
            Color c = this.chart.getDataColor(selectedMData);
            if (color instanceof QbPattern) {
                this.chart.setDataColor(selectedMData, color);
            } else if (c instanceof QbPattern) {
                int patternID = ((QbPattern)c).getPatternTypeID();
                QbPattern pattern = new QbPattern(color, patternID);
                this.chart.setDataColor(selectedMData, (Color)pattern);
                this.colorpanel.setColor(pattern, true);
            } else {
                this.chart.setDataColor(selectedMData, color);
            }
            if (c.getRGB() != color.getRGB() || color instanceof QbPattern) {
                if (this.chart.mData2 != null && this.chart.mData2 == selectedMData.getRootMData()) {
                    if (!(color instanceof QbPattern)) {
                        this.csPanel.clearSecondValueColorSetSelection();
                    }
                    DataAttribute dataAttr = new DataAttribute(this.chart.mData2, true, this.chart.is2DChart, this.chart.chartType);
                    this.chart.chartColorSet2.setChartDataPointsColors(dataAttr.dataColor);
                } else {
                    if (!(color instanceof QbPattern)) {
                        this.csPanel.clearValueColorSetSelection();
                    }
                    DataAttribute dataAttr = new DataAttribute(this.chart.mData, false, this.chart.is2DChart, this.chart.chartType);
                    this.chart.chartColorSet.setChartDataPointsColors(dataAttr.dataColor);
                }
            }
            this.setGouraudButtonEnabled();
            this.invalidateLegend();
            return;
        }
        if (this.chartPanel.selectobj instanceof Axis) {
            this.setModified();
            this.chart.setAxisColor(color, (Axis)this.chartPanel.selectobj);
            return;
        }
        if (this.chartPanel.selectobj instanceof Area) {
            this.setModified();
            if (this.chartPanel.chart.targetName != null && this.chartPanel.chart.targetName.equals("Drop bar")) {
                if (((Area)this.chartPanel.selectobj).automatic) {
                    this.chart.setDropBarColor(color);
                } else {
                    this.chart.setDropBarColor2(color);
                }
                return;
            }
            ((Area)this.chartPanel.selectobj).setColor(color);
            return;
        }
        if (this.chartPanel.selectobj instanceof Grid) {
            this.setModified();
            ((Grid)this.chartPanel.selectobj).setColor(color);
            return;
        }
        if (this.chartPanel.selectobj instanceof Ticker) {
            this.setModified();
            if (this.chartPanel.chart.targetName.indexOf(" axis label") != -1) {
                ((Ticker)this.chartPanel.selectobj).setLabelColor(color);
                return;
            }
            ((Ticker)this.chartPanel.selectobj).setTickerColor(color);
            return;
        }
        if (this.chartPanel.selectobj instanceof CString) {
            this.setModified();
            ((CString)this.chartPanel.selectobj).setColor(color);
            return;
        }
        if (this.chartPanel.selectobj instanceof CString[]) {
            this.setModified();
            if (this.chartPanel.chart.targetName.startsWith("percentage")) {
                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().piePercentColor = color;
            } else if (this.chartPanel.chart.targetName.startsWith("name")) {
                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().pieLabelColor = color;
            } else if (this.chartPanel.chart.targetName.startsWith("value")) {
                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().pieValueColor = color;
            } else if (this.chartPanel.chart.targetName.startsWith("category")) {
                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().catLabelColor = color;
            }
            CString.setStringsColor((CString[])this.chartPanel.selectobj, color);
            return;
        }
        if (this.chartPanel.selectobj instanceof CString[][]) {
            this.setModified();
            if (this.chartPanel.chart.targetName.startsWith("percentage")) {
                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().piePercentColor = color;
            } else if (this.chartPanel.chart.targetName.startsWith("name")) {
                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().pieLabelColor = color;
            } else if (this.chartPanel.chart.targetName.startsWith("value")) {
                ((IPieChart)((Object)this.chartPanel.chart)).getPieChart().pieValueColor = color;
            }
            CString.setStringsColor((CString[][])this.chartPanel.selectobj, color);
            return;
        }
        if (this.chartPanel.selectobj instanceof Legend) {
            this.setModified();
            ((Legend)this.chartPanel.selectobj).setfontColor(color);
            return;
        }
        if (this.chartPanel.selectobj instanceof CAnnotation) {
            this.setModified();
            CAnnotation cAnno = (CAnnotation)this.chartPanel.selectobj;
            Object annoPart = cAnno.selectedObj;
            if (annoPart instanceof Area) {
                ((Area)annoPart).setColor(color);
            } else if (annoPart instanceof CString) {
                cAnno.setfontColor(color);
            }
            return;
        }
        if (this.chartPanel.selectobj == this.chart.topLabels) {
            this.setModified();
            this.chart.topvalueLabel_color = color;
            CString.setStringsColor(this.chart.topLabels, this.chart.topvalueLabel_color);
            return;
        }
        if (this.chartPanel.selectobj == this.chart.topLabels2) {
            this.setModified();
            this.chart.topvalueLabel2_color = color;
            CString.setStringsColor(this.chart.topLabels2, this.chart.topvalueLabel2_color);
            return;
        }
        if (this.chartPanel.selectobj instanceof PolyLine && this.chart.targetName.equals("line")) {
            this.setModified();
            ((PolyLine)this.chartPanel.selectobj).setColor(color);
            return;
        }
        if (this.chartPanel.selectobj instanceof Point3D) {
            this.setModified();
            ((Point3D)this.chartPanel.selectobj).color = color;
            return;
        }
        if (this.chartPanel.selectobj instanceof DataLine) {
            this.setModified();
            ((DataLine)this.chartPanel.selectobj).setColor(color);
            this.invalidateLegend();
            return;
        }
        if (this.chartPanel.selectobj instanceof ControlRange) {
            this.setModified();
            ((ControlRange)this.chartPanel.selectobj).setColor(color);
            this.invalidateLegend();
            return;
        }
        if (this.chartPanel.selectobj instanceof GraphicsTable) {
            this.setModified();
            GraphicsTable tmpgt = (GraphicsTable)this.chartPanel.selectobj;
            if (tmpgt.select == 0) {
                tmpgt.headColor = color;
            } else if (tmpgt.select == 1) {
                tmpgt.cellColor = color;
            } else if (tmpgt.select == 2) {
                tmpgt.headTextColor = color;
            } else if (tmpgt.select == 3) {
                tmpgt.cellTextColor = color;
            }
            return;
        }
    }

    private void do_ToggleToolbar() {
        boolean isInited = this.initializing;
        this.initializing = true;
        this.toolbar.setVisible(!this.toolbarExist);
        this.validate();
        this.toolbarExist = !this.toolbarExist;
        ((JCheckBoxMenuItem)this.layoutmenu.getItem(2)).setSelected(this.toolbarExist);
        this.initializing = isInited;
    }

    void setGouraudButtonEnabled() {
        if (this.chart == null) {
            return;
        }
        if (this.chart.is2DimChart()) {
            return;
        }
        this.gouraudButton.setEnabled(!this.chart.isPatternOn() && !this.chart.isTranslucent());
        String tip = "";
        tip = this.gouraudButton.isEnabled() ? "Toggle on/off Gouraud Shading" : "Please remove pattern / translucency first before turning on gouraud Shading.";
        this.gouraudButton.setToolTipText(tip);
        this.gouraudButton.setHint(this.statusBar, tip);
    }

    private void do_NavLayout() {
        if (this.chart.is2DimChart()) {
            this.showHint(LanguageEncoder.getText("This function is available for 3D chart only."), true);
            this.enableItemStateChanged = false;
            ((JCheckBoxMenuItem)this.layoutmenu.getItem(1)).setSelected(this.navexist);
            this.enableItemStateChanged = true;
            return;
        }
        if (this.navexist) {
            this.centerPanel.remove(this.navigateAll);
        } else {
            this.centerPanel.add("South", this.navigateAll);
        }
        this.navexist = !this.navexist;
        this.enableItemStateChanged = false;
        ((JCheckBoxMenuItem)this.layoutmenu.getItem(1)).setSelected(this.navexist);
        this.enableItemStateChanged = true;
        this.centerPanel.validate();
        this.qbpaint();
        this.sizelabel.setSize();
    }

    ColData[] getOriginalColData() {
        this.originalColData = ReloadChart.getOriginalColData(this.parentChart, true);
        return this.originalColData;
    }

    synchronized void do_Refresh() {
        this.originalColData = null;
        this.originalMetaData = null;
        this.chartPanel.chart.gt.keepPosition = true;
        GraphicsTable.recoverTableSize(this.chartPanel.chart);
        if (this.chart.getTable() != null) {
            this.chart.getTable().clear();
        }
        this.do_Reload();
    }

    protected synchronized void do_Reload() {
        Chart newchart = null;
        this.loading = true;
        String oldtitle = this.getTitle();
        this.setTitle(LanguageEncoder.getText("Refresh data ..."));
        this.setEnabled(false);
        String errorMessage = "";
        try {
            this.chart.usedColumns = null;
            if (this.chart.isSaveColorsForCategories()) {
                this.chart.setUnusedDataAttribute(new DataAttribute(this.chart.mData, false, this.chart.is2DChart, this.chart.chartType, true));
                this.chart.chartColorSet.setDataPointsColorsMapped(true);
                this.chart.chartColorSet.setChartDataPointsColors(this.chart.getUnusedDataAttribute().dataColor);
                if (this.chart.chartColorSet2 != null && this.chart.mData2 != null) {
                    this.chart.setUnusedDataAttribute2(new DataAttribute(this.chart.mData2, true, this.chart.is2DChart, this.chart.chartType, true));
                    this.chart.chartColorSet2.setDataPointsColorsMapped(true);
                    this.chart.chartColorSet2.setChartDataPointsColors(this.chart.getUnusedDataAttribute2().dataColor);
                }
            }
            newchart = ReloadChart.reloadData(this.chart, false);
            if (this.chart.isSaveColorsForCategories()) {
                newchart.chartColorSet.setChartDataPointsColors(new DataAttribute((MultiDimData)newchart.mData, (boolean)false, (boolean)newchart.is2DChart, (int)newchart.chartType).dataColor);
                if (newchart.chartColorSet2 != null && newchart.mData2 != null) {
                    newchart.chartColorSet2.setChartDataPointsColors(new DataAttribute((MultiDimData)newchart.mData2, (boolean)true, (boolean)newchart.is2DChart, (int)newchart.chartType).dataColor);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to reload data", ex);
            newchart = null;
            errorMessage = ex.getMessage();
        }
        if (newchart == null) {
            this.setEnabled(true);
            this.loading = false;
            this.setTitle(oldtitle);
            new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Failed to reload data.\n") + errorMessage);
            return;
        }
        this.setChart(newchart, false);
        if (this.parentChart != null && this.parentChart.getDrillNumber() == 0) {
            this.parentChart = newchart;
        }
        this.setTitle(oldtitle);
        this.loading = false;
        this.setEnabled(true);
        this.originalMetaData = null;
        this.originalColData = null;
    }

    void do_AddLine() {
        this.setModified();
        this.showHint(LanguageEncoder.getText("Click the left mouse button to add point, when done click the right mouse button."));
        this.chartPanel.setCursor(new Cursor(1));
        this.chartPanel.do_AddLine();
    }

    private void removeRepaint() {
        this.setModified();
        this.chartPanel.selectobj = null;
        this.qbrepaint();
    }

    void do_Remove() {
        Object obj = this.chartPanel.selectobj;
        if (obj != null) {
            int i;
            this.createBackupChart();
            if (obj == this.chart.gt) {
                this.setModified();
                int dx = 0;
                int dy = 0;
                if (this.chartPanel.chart.gt.direction == 2) {
                    dy = this.chartPanel.chart.gt.getHeight();
                } else {
                    dx = this.chartPanel.chart.gt.getWidth();
                }
                this.chartPanel.chart.gt.clear();
                this.chartPanel.chart.gt.shift = false;
                this.chartPanel.chart.tableInPanel = false;
                GraphicsTable.shiftWithoutTable(this.chartPanel.chart);
                this.chartPanel.chart.winWidth -= dx;
                this.chartPanel.chart.winHeight -= dy;
                this.chartPanel.chart.gt.tableWidth = dx;
                this.chartPanel.chart.gt.tableHeight = dy;
                this.chartPanel.update();
                this.chartPanel.chart.gt.tableWidth = 0;
                this.chartPanel.chart.gt.tableHeight = 0;
                return;
            }
            if (obj == this.chart.mainTitle) {
                this.chart.mainTitle.setText("");
                this.removeRepaint();
                return;
            }
            for (i = 0; i < 4; ++i) {
                if (obj != this.chart.axis[i].title) continue;
                this.chart.axis[i].title.setText("");
                this.removeRepaint();
                return;
            }
            for (i = 0; i < this.chart.stringList.size(); ++i) {
                if (obj != this.chart.stringList.elementAt(i)) continue;
                this.chart.stringList.removeElementAt(i);
                this.removeRepaint();
                return;
            }
            if (obj instanceof Ticker) {
                Axis ax = ((Ticker)obj).axis;
                if (this.chartPanel.chart.targetName.indexOf(" axis label") != -1) {
                    this.chart.setTickerLabelState(ax, false);
                } else {
                    this.chart.setTickerLineState(ax, false);
                }
                this.removeRepaint();
                return;
            }
            if (this.chart.isCircularChart() && obj == ((IPieChart)((Object)this.chart)).getPieChart().pieLabel) {
                this.chart.setLabelState(false);
                this.removeRepaint();
                return;
            }
            if (this.chart.isCircularChart() && obj == ((IPieChart)((Object)this.chart)).getPieChart().pieValue) {
                this.chart.setValueState(false);
                this.removeRepaint();
                return;
            }
            if (this.chart.isCircularChart() && obj == ((IPieChart)((Object)this.chart)).getPieChart().piePercent) {
                this.chart.setPercentState(false);
                this.removeRepaint();
                return;
            }
            if (obj instanceof Grid) {
                ((Grid)obj).bshow = false;
                this.removeRepaint();
                return;
            }
            if (obj instanceof Axis) {
                for (i = 0; i < 4; ++i) {
                    if ((Axis)obj != this.chart.axis[i]) continue;
                    this.chart.setAxisState(i, false);
                    this.removeRepaint();
                    return;
                }
                if (this.chart.colDataAxis != null) {
                    for (i = 0; i < this.chart.colDataAxis.length; ++i) {
                        if ((Axis)obj != this.chart.colDataAxis[i]) continue;
                        this.chart.setAxisState(i + 4, false);
                        this.removeRepaint();
                        return;
                    }
                }
            }
            if (obj == this.chart.border) {
                this.chart.setBorderState(false);
                this.removeRepaint();
                return;
            }
            if (obj == this.chart.background) {
                this.chart.setBackgroundState(false);
                this.removeRepaint();
                return;
            }
            if (this.chartPanel.chart.targetName != null) {
                if (this.chartPanel.chart.targetName.equals("legend label")) {
                    this.chart.setLegendState(false);
                    this.removeRepaint();
                    return;
                }
                if (this.chartPanel.chart.targetName.equals("legend border")) {
                    this.chart.legend.framearea.drawBorder = false;
                    this.removeRepaint();
                    return;
                }
                if (this.chartPanel.chart.targetName.equals("legend background")) {
                    this.chart.legend.area.drawArea = false;
                    this.removeRepaint();
                    return;
                }
                if (this.chartPanel.chart.targetName.equals("2nd legend label")) {
                    this.chart.setLegendState2(false);
                    this.removeRepaint();
                    return;
                }
                if (this.chartPanel.chart.targetName.equals("2nd legend border")) {
                    this.chart.legend2.framearea.drawBorder = false;
                    this.removeRepaint();
                    return;
                }
                if (this.chartPanel.chart.targetName.equals("2nd legend background")) {
                    this.chart.legend2.area.drawArea = false;
                    this.removeRepaint();
                    return;
                }
            }
            if (obj instanceof CAnnotation) {
                CAnnotation cAnno = (CAnnotation)obj;
                Object annoPart = cAnno.selectedObj;
                if (annoPart == cAnno.framearea) {
                    cAnno.setBorderVisible(false);
                } else if (annoPart == cAnno.area) {
                    cAnno.setBackgroundVisible(false);
                } else {
                    IReferenceObj refObj = cAnno.getReferenceObject();
                    if (refObj == null) {
                        this.chart.removeAnnotation(cAnno);
                    } else {
                        refObj.removeAnnotation(cAnno);
                    }
                }
                this.removeRepaint();
                return;
            }
            if (obj == this.chart.topLabels) {
                this.chart.setTopValueState(false);
                this.removeRepaint();
                return;
            }
            if (obj == this.chart.topLabels2) {
                this.chart.setTopValueState2(false);
                this.removeRepaint();
                return;
            }
            if (obj == this.chart.desktopArea) {
                this.chart.setbackgroundImageState(false);
                this.removeRepaint();
                return;
            }
            if (obj instanceof PolyLine && this.chart.targetName.equals("line")) {
                this.chart.removeLine((PolyLine)obj);
                this.removeRepaint();
                return;
            }
            if (obj instanceof DataLine) {
                this.chart.dataLineSet.removeDataLine((DataLine)obj);
                this.removeRepaint();
                return;
            }
            if (obj instanceof ControlRange) {
                this.chart.getControlRangeList().removeElement(obj);
                this.invalidateLegend();
                this.removeRepaint();
                return;
            }
        }
        this.showHint(LanguageEncoder.getText("Please select an object to be removed."));
    }

    void do_AxisDialog() {
        int i;
        if (this.chart instanceof IPieChart) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("This option is not available for pie and doughnut charts."));
            return;
        }
        for (i = 0; i < 4; ++i) {
            if (this.chart.axis[i].stepsize == null) continue;
            this.do_AxisDialog(i);
            return;
        }
        if (this.chart.colDataAxis == null) {
            return;
        }
        for (i = 0; i < this.chart.colDataAxis.length; ++i) {
            if (this.chart.colDataAxis[i] == null || this.chart.colDataAxis[i].stepsize == null) continue;
            this.do_AxisDialog(i + 4);
            return;
        }
    }

    public void do_TableDirection() {
        int chartType = this.chart.chartType;
        if (chartType == 2 || chartType == 12 || chartType == 13 || chartType == 19) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("This chart type does not support table!"));
            return;
        }
        FormatTableDialog d = new FormatTableDialog(this, this.chartPanel);
        d.pack();
        d.setVisible(true);
    }

    public void do_Titles() {
        TitleDialog d = new TitleDialog(this, this.chart);
        d.pack();
        d.setVisible(true);
    }

    private void do_ZoomOptions() {
        this.do_ZoomOptions(false);
    }

    public boolean do_ZoomOptions(boolean isForDrillDown) {
        int categoryType = this.chartPanel.chart.getCategoryType();
        ZoomDialog zoomDialog = null;
        String dialogTitle = null;
        if (!this.isZoomEnabled(true)) {
            return true;
        }
        GraphicsTable.recoverTableSize(this.chartPanel.chart);
        dialogTitle = isForDrillDown ? LanguageEncoder.getText("Define date/time interval...") : LanguageEncoder.getText("Time Zooming Options...");
        zoomDialog = new ZoomDialog(this, categoryType, isForDrillDown, dialogTitle, false);
        if (zoomDialog.isCancelled()) {
            return false;
        }
        zoomDialog.setVisible(true);
        this.enableZoomHistOptions(true);
        return !zoomDialog.isCancelled();
    }

    private boolean isZoomEnabled(boolean displayMessage) {
        if (this.chartPanel == null || this.chart == null || this.chartPanel.chart == null) {
            return false;
        }
        int categoryType = this.chartPanel.chart.getCategoryType();
        int chartType = this.chart.chartType;
        String message = null;
        if (chartType == 2 || chartType == 12 || chartType == 13 || chartType == 19 || chartType == 18 || chartType == 17 || chartType == 16 || chartType == 15) {
            message = "This chart type does not support zooming!";
        } else if (categoryType != 92 && categoryType != 91 && categoryType != 93) {
            message = "Zoom is only valid for the types:\n Time\n Date\n Timestamp";
        } else if (this.chart.isOverlayCombo()) {
            message = "Cannot set zooming for charts with the second series! Please remove the second series first.";
        } else if (this.chart.isHistogram()) {
            message = "Please undo histogram first!";
        } else if (this.chart.isAggregationChart()) {
            message = "Please undo aggregation first!";
        } else if (this.chart.isDrawNullColumn()) {
            message = "Please undo drawing null column feature first!";
        }
        if (displayMessage && message != null) {
            MessageDialog.showError(this, true, LanguageEncoder.getText(message));
        }
        return message == null;
    }

    private void do_AggregationOptions() {
        if (!this.isAggregationEnabled(true)) {
            return;
        }
        AggregationDialog aggrDialog = new AggregationDialog(this);
        aggrDialog.pack();
        aggrDialog.setVisible(true);
        this.enableZoomHistOptions(true);
    }

    private boolean isAggregationEnabled(boolean displayMessage) {
        if (this.chart == null) {
            return false;
        }
        String message = null;
        int chartType = this.chart.chartType;
        if (chartType == 2 || chartType == 12 || chartType == 13 || chartType == 9 || chartType == 10 || chartType == 19 || chartType == 18) {
            message = "This chart type does not support aggregation!";
        } else if (this.chart.isOverlayCombo()) {
            message = "Cannot aggregate data for charts with the second series! Please remove the second series first.";
        } else if (this.chart.isHistogram()) {
            message = "Please undo histogram first!";
        } else if (this.chart.isTimeChart()) {
            message = "Please undo zoom first!";
        } else if (!this.chart.isDataSourceAvail()) {
            message = "Data source not found!  Please update data source first.";
        }
        if (displayMessage && message != null) {
            MessageDialog.showError(this, true, LanguageEncoder.getText(message));
        }
        return message == null;
    }

    private void do_HistogramOptions() {
        if (!this.isHistogramEnabled(true)) {
            return;
        }
        HistogramDialog histDialog = null;
        histDialog = new HistogramDialog(this);
        histDialog.pack();
        histDialog.setVisible(true);
        this.enableZoomHistOptions(true);
        if (this.chart.isHistogram()) {
            this.setMenuForHistogram(false);
        } else {
            this.setMenuForHistogram(true);
        }
    }

    private boolean isHistogramEnabled(boolean displayMessage) {
        if (this.chart == null) {
            return false;
        }
        int chartType = this.chart.chartType;
        if (chartType == 2 || chartType == 12 || chartType == 13 || chartType == 9 || chartType == 10 || chartType == 18 || chartType == 19 || this.chart.showLegend2()) {
            if (displayMessage) {
                MessageDialog.showError(this, true, LanguageEncoder.getText("This chart type does not support histogram!"));
            }
            return false;
        }
        if (this.chart.isAggregationChart()) {
            if (displayMessage) {
                MessageDialog.showError(this, true, LanguageEncoder.getText("Please undo aggregation first!"));
            }
            return false;
        }
        int categoryType = this.chartPanel.chart.getCategoryType();
        if (categoryType == 92 || categoryType == 91 || categoryType == 93) {
            if (displayMessage) {
                MessageDialog.showError(this, true, LanguageEncoder.getText("Can't display histogram for the following category types:\n Time\n Date\n Timestamp"));
            }
            return false;
        }
        if (!this.chart.isDataSourceAvail()) {
            if (displayMessage) {
                MessageDialog.showError(this, true, LanguageEncoder.getText("Data source not found!  Please update data source first."));
            }
            return false;
        }
        return true;
    }

    void do_AxisDialog(int j) {
        AxisDialog dialog = new AxisDialog(this, LanguageEncoder.getText("Axis Options..."));
        dialog.show(j);
    }

    void do_FormatValue() {
        this.do_FormatValue(0);
    }

    void do_DataProp() {
        new DataPropDialog(this, LanguageEncoder.getText("Data Properties...")).setVisible(true);
    }

    void do_FormatValue(int i) {
        new FormatValueDialog(this, LanguageEncoder.getText("Axis Elements...")).show(i);
    }

    void do_PeriodicRefresh() {
        if (this.isDrillDownDefined && this.parentChart != null && this.parentChart.getDrillNumber() > 0) {
            this.showHint(LanguageEncoder.getText("This function is only available for top level chart."), true);
            return;
        }
        new ScheduleDialog(this, LanguageEncoder.getText("Schedule Refresh")).setVisible(true);
    }

    void do_Legend() {
        this.do_Legend(this.chart.legend);
    }

    void do_Legend(Legend legend) {
        new LegendDialog(this, this.chart.legend, this.chart.showLegend2() ? this.chart.legend2 : null, legend == this.chart.legend, LanguageEncoder.getText("Legend")).setVisible(true);
    }

    void do_Text() {
        this.do_Text(false);
    }

    private void do_Text(boolean alwaysInsertNewText) {
        Object target = this.chartPanel.selectobj;
        if (target instanceof IReferenceObj) {
            this.do_Text(null, (IReferenceObj)target);
        } else if (!alwaysInsertNewText && target instanceof CAnnotation) {
            this.do_Text((CAnnotation)target, null);
        } else {
            this.do_Text(null, this.chartPanel.chart);
        }
        this.chartPanel.selectobj = null;
    }

    void do_Text(CAnnotation anno) {
        this.do_Text(anno, null);
    }

    private void do_Text(CAnnotation anno, IReferenceObj refObj) {
        new TextDialog(this, anno, refObj).setVisible(true);
    }

    void do_DataOrder() {
        this.do_DataOrder(-1);
    }

    void do_DataOrder(int i) {
        if (Chart.isCoordinateType(this.chart.chartType) && this.chart.dataDim == 1) {
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Data ordering is not supported for scatter, surface, bubble and polar charts without series!"));
            return;
        }
        if (i >= 0) {
            for (int j = 0; j < this.chart.dataDim; ++j) {
                if (this.chart.axis[i].ticker.name != this.chart.colData[this.chart.mDataMap[j]].getFieldName()) continue;
                new DataOrderDialog(this, LanguageEncoder.getText("Data Ordering...")).show(j);
                break;
            }
        } else {
            new DataOrderDialog(this, LanguageEncoder.getText("Data Ordering")).setVisible(true);
        }
    }

    void resumeMenuBar() {
        this.enableItemStateChanged = false;
        ((JCheckBoxMenuItem)this.chartTypemenu.getItem(3 + this.newchartType)).setSelected(false);
        this.enableItemStateChanged = true;
    }

    private void changeChartType(boolean popupOptionDialog) {
        if (this.chart.chartType == 2 && (this.chart.isLabelDateTimeDisplay(0) || this.chart.isLabelDateTimeDisplay(1))) {
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Please remove date/time column from your column mapping before change chart type!"));
            return;
        }
        if (this.chart.chartType != this.newchartType && (this.newchartType == 2 || this.newchartType == 12 || this.newchartType == 13 || this.newchartType == 19 || this.newchartType == 18 || !this.chart.isStackType() && (Chart.isStackChart(this.newchartType) || this.newchartType == 11))) {
            if (this.chart.isTimeChart()) {
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Please undo zooming before change chart type!"));
                return;
            }
            if (this.chart.isHistogram()) {
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Please undo histogram before change chart type!"));
                return;
            }
            if (this.chart.isAggregationChart()) {
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Please undo aggregation before change chart type!"));
                return;
            }
        }
        if (this.chart.showTable() && this.chart.chartType != this.newchartType && (this.newchartType == 2 || this.newchartType == 12 || this.newchartType == 13 || this.newchartType == 19)) {
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Please remove table before change chart type!"));
            return;
        }
        if (this.chart.comboType == 3 && this.newchartType == 1) {
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("BAR chart can't have OVERLAY as combo chart type, please set 2nd value to NONE or set its chart type to LINE!"));
            return;
        }
        if (this.newchartType == 3) {
            this.chart.setStepLineState(this.chart.getStepLineState2());
        }
        Chart newchart = this.chart;
        if (this.isDrillDownDefined && this.parentChart.getDrillNumber() > 0) {
            this.changeDrillDownChartType();
        } else {
            if (this.isDrillDownEnabled() && (this.parentChart.dataDim == 1 && Chart.stackType(this.newchartType) || this.parentChart.dataDim == 2 && this.newchartType == 17 || this.parentChart.dataDim == 3 && !Chart.stackType(this.newchartType))) {
                this.do_drillRemoveAll();
                if (this.isDrillDownEnabled()) {
                    return;
                }
            }
            try {
                GraphicsTable.recoverTableSize(this.chartPanel.chart);
                newchart.gt.tableWidth = this.chart.gt.tableWidth;
                newchart.gt.tableHeight = this.chart.gt.tableHeight;
                newchart = Chart.createChart(this.chartPanel, this.newchartType, this.isnew2DChart, this.chart, null, this.chart.usedColumns);
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.FINE, "Failed to change chart type", e);
                String message = null;
                message = this.newchartType == 12 ? LanguageEncoder.getText("The chart data does not support surface chart.") : (e.getMessage() == null ? LanguageEncoder.getText("Not enough data to plot") : e.getMessage());
                new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(message);
                this.resumeMenuBar();
                return;
            }
            if (this.optionDialog != null) {
                this.optionDialog.changeType = true;
            }
            if (this.newchartType != this.chart.chartType) {
                newchart.setDefault();
            }
            this.changeType = true;
            if (newchart.addNewColumnFromDataMapping || popupOptionDialog) {
                JMessageDialog msgDialog = new JMessageDialog((Frame)this, "Question", LanguageEncoder.getText("Current data mapping cannot switch to a new chart type. Do you want to redo data mapping for new chart type?"), 2);
                int response = msgDialog.getResponse();
                if (response != 4) {
                    this.resumeMenuBar();
                    return;
                }
                if ((newchart = this.redoMappingForChangingChartType(newchart)) == null) {
                    this.resumeMenuBar();
                    return;
                }
            }
            if (newchart.is2DimChart() && !this.chart.is2DimChart()) {
                float chartheight = newchart.chart_heightProp * (float)newchart.winHeight;
                float chartwidth = newchart.chart_widthProp * (float)newchart.winWidth;
                if (chartheight > chartwidth) {
                    newchart.chart_heightProp = chartwidth / (float)newchart.winHeight;
                } else if (chartheight < chartwidth) {
                    newchart.chart_widthProp = chartheight / (float)newchart.winWidth;
                }
            }
            this.setChart(newchart, true);
            newchart.newSurface();
            if (this.parentChart != null) {
                this.parentChart = this.chart;
            }
            this.sizelabel.setSize();
            if (!this.useReportData()) {
                this.drillDownmenu.setEnabled(this.chart != null);
                if (DrillDownInfo.checkDrillDownType(this.newchartType)) {
                    this.drilloptionsitem.setEnabled(true);
                    this.drillDynamicitem.setEnabled(!this.isDrillDownDefined);
                    this.drillNavigateItem.setEnabled(!this.isDrillDownDefined);
                } else {
                    this.drilloptionsitem.setEnabled(false);
                    this.drillDynamicitem.setEnabled(false);
                    this.drillNavigateItem.setEnabled(!this.isDrillDownDefined);
                }
                if (this.parentChart != null && this.parentChart.isDynamicDrillDown) {
                    this.drilloptionsitem.setEnabled(false);
                    this.drillNavigateItem.setEnabled(false);
                }
                if (this.isFieldDrillDownChart()) {
                    this.drillNavigateItem.setEnabled(true);
                    this.drilloptionsitem.setEnabled(false);
                    this.drillDynamicitem.setEnabled(false);
                    this.modifydataitem.setEnabled(false);
                    this.modifydbitem.setEnabled(false);
                    this.modifysqlitem.setEnabled(false);
                } else {
                    this.modifydataitem.setEnabled(true);
                    this.modifydbitem.setEnabled(this.chart.sourceData == 1);
                    this.modifysqlitem.setEnabled(this.chart.sourceData == 1);
                }
            }
            this.setModified();
            if (this.chart.showTable() || this.chart.showTopValue) {
                this.qbpaint();
            }
        }
    }

    private Chart redoMappingForChangingChartType(Chart newChart) {
        OptionDialog optionDialog = new OptionDialog(this, newChart, false);
        optionDialog.init(newChart);
        optionDialog.setVisible(true);
        if (optionDialog.isCancelled()) {
            return null;
        }
        return optionDialog.getChart();
    }

    private boolean isSurfaceSupport() {
        try {
            GraphicsTable.recoverTableSize(this.chartPanel.chart);
            Chart newchart = Chart.createChart(this.chartPanel, this.newchartType, this.isnew2DChart, this.chart, null, this.chart.usedColumns);
            return newchart != null;
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.FINE, "The chart data does not support surface chart", e);
            String message = LanguageEncoder.getText("The chart data does not support surface chart.");
            new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(message);
            return false;
        }
    }

    private void changeDrillDownChartType() {
        this.parentChart.decrementDrillNumber();
        int[] map = this.parentChart.getDrillDownMap();
        int dim = this.parentChart.getDrillDownDimension();
        int[] oldMap = this.parentChart.getDrillDownMap();
        int oldDim = this.parentChart.getDrillDownDimension();
        int oldcType = this.parentChart.getDrillDownType();
        boolean olddType = this.parentChart.isDrillDown2D();
        String tplName = null;
        if (this.newchartType != this.chart.chartType) {
            if (dim == 1 && Chart.stackType(this.newchartType)) {
                dim = 2;
                if (map.length < 2) {
                    int[] map2 = new int[]{map[0], map[0]};
                    map = map2;
                } else {
                    map[1] = map[0];
                }
            } else if (this.chart.isStackType() != Chart.stackType(this.newchartType)) {
                if (dim == 2) {
                    int tempMap = map[0];
                    map[0] = map[1];
                    map[1] = tempMap;
                } else if (dim == 3) {
                    dim = 2;
                }
            }
        }
        this.parentChart.modifyDrillDown(this.parentChart.getDrillNumber(), this.newchartType, map, dim, this.isnew2DChart);
        this.parentChart.incrementDrillNumber();
        tplName = this.createDrillTemplateName();
        if (!this.doesTemplateFileExist(tplName) && !this.ignoreSave || this.modified) {
            this.drillsaveDialog = new MessageDialog(this, LanguageEncoder.getText("Question"), true, true, LanguageEncoder.getText("Yes") + "," + LanguageEncoder.getText("No"));
            this.drillsaveDialog.addActionListener(this);
            this.drillsaveDialog.show(SAVE_QUESTION);
        }
        this.parentChart.decrementDrillNumber();
        int cType = this.newchartType;
        boolean dType = this.isnew2DChart;
        String oldTitle = this.getTitle();
        int valCol = this.parentChart.getValueMap();
        int subvalCol = this.parentChart.getSubValueMap();
        if (this.parentChart.summaryChart) {
            valCol = this.parentChart.originalMap[valCol];
            if (subvalCol >= 0) {
                subvalCol = this.parentChart.originalMap[subvalCol];
            }
        }
        this.setTitle(LanguageEncoder.getText("Please wait..."));
        PreprocInfo tsInfo = this.drillHistory.createPreprocInfo(map, dim, valCol, subvalCol, cType, dType, this.parentChart.primaryAggregate, this.parentChart.secondaryAggregate);
        this.valueTableSave = this.chart.valueTable;
        Chart tempChart = this.chart;
        GraphicsTable.recoverTableSize(this.chart);
        tempChart.gt.tableWidth = this.chart.gt.tableWidth;
        tempChart.gt.tableHeight = this.chart.gt.tableHeight;
        tempChart = Chart.createChart(this.chartPanel, cType, dType, null, this.drillHistory.currentDrill(tsInfo), null);
        tempChart.setSubFilesTable(this.chart.getSubFilesTable());
        if (tempChart.notEnoughData()) {
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Not enough data to plot"));
            this.parentChart.modifyDrillDown(this.parentChart.getDrillNumber(), oldcType, oldMap, oldDim, olddType);
            this.parentChart.incrementDrillNumber();
            this.setTitle(oldTitle);
            this.ignoreSave = false;
            this.nextDrill = false;
            this.previousDrill = false;
            this.setUnModified();
            return;
        }
        this.chart = tempChart;
        this.drillHistory.setChartType(this.chart, tsInfo);
        this.parentChart.incrementDrillNumber();
        this.chart.setSize(this.parentChart.getSize());
        tplName = this.createDrillTemplateName();
        if (this.doesTemplateFileExist(tplName)) {
            this.do_loadTemplate(tplName);
            if (this.chart.showTable()) {
                GraphicsTable.recoverTableSize(this.chart);
            }
        } else {
            if (this.chart.showTable()) {
                GraphicsTable.recoverTableSize(this.chart);
            }
            this.setNewChart(this.chart);
        }
        this.setTitle(LanguageEncoder.getText("Drill-Down Chart:") + " " + this.parentChart.getDrillNumber());
        this.enableNonDrillDownMenu(false);
        this.ignoreSave = false;
        this.nextDrill = false;
        this.previousDrill = false;
        this.setUnModified();
    }

    private void setMenu(boolean newDim2D, int newType) {
        this.enableItemStateChanged = false;
        ((JCheckBoxMenuItem)this.chartTypemenu.getItem(0)).setSelected(newDim2D);
        ((JCheckBoxMenuItem)this.chartTypemenu.getItem(1)).setSelected(!newDim2D);
        for (int i = 0; i < 21; ++i) {
            ((JCheckBoxMenuItem)this.chartTypemenu.getItem(3 + i)).setSelected(false);
        }
        ((JCheckBoxMenuItem)this.chartTypemenu.getItem(3 + newType)).setSelected(true);
        this.enableItemStateChanged = true;
    }

    private void setMenuForHistogram(boolean b) {
        for (int i = 0; i < 21; ++i) {
            ((JCheckBoxMenuItem)this.chartTypemenu.getItem(3 + i)).setEnabled(b);
        }
    }

    void do_ImageDialog() {
        ImageDialog imageDialog = new ImageDialog(this, true, LanguageEncoder.getText("Choose A Background Image"));
        imageDialog.addActionListener(this);
        if (this.chart.showbackgroundImage && this.chart.getBackgroundImage() != null) {
            imageDialog.show(this.chart.getBackgroundImage().getUrl(), this.chart.getBackgroundImage().getRelativeUrl(), this.chart.getBackgroundImage().getOption());
        } else {
            imageDialog.pack();
            imageDialog.setVisible(true);
        }
    }

    private void do_DialPlotFGDialog() {
        URL urldir = null;
        ImageDialog imageDialog = new ImageDialog(this, true, LanguageEncoder.getText("Choose A Dial Foreground Image"));
        imageDialog.addActionListener(this);
        try {
            String urlStr = IOUtil.nameToURL(null, null, this.getBrowseDirectories().getImagesDir());
            urldir = new URL(urlStr);
            imageDialog.addChoice(urldir);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to get images directory", ex);
        }
        if (this.chart.getDialPlotFGImageState() && this.chart.getDialPlotFGImage() != null) {
            imageDialog.setRatio(this.chart.getDialPlotFGRatio());
            imageDialog.show(this.chart.getDialPlotFGImage().getUrl(), this.chart.getDialPlotFGImage().getRelativeUrl(), this.chart.getDialPlotFGImage().getOption());
        } else {
            imageDialog.pack();
            if (urldir != null) {
                imageDialog.show(urldir);
            } else {
                imageDialog.setVisible(true);
            }
        }
    }

    private void do_DialPlotBGDialog() {
        URL urldir = null;
        ImageDialog imageDialog = new ImageDialog(this, true, LanguageEncoder.getText("Choose A Dial Background Image"));
        imageDialog.addActionListener(this);
        try {
            String urlStr = IOUtil.nameToURL(null, null, this.getBrowseDirectories().getImagesDir());
            urldir = new URL(urlStr);
            imageDialog.addChoice(urldir);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to get images directory", ex);
        }
        if (this.chart.getDialPlotBGImageState() && this.chart.getDialPlotBGImage() != null) {
            imageDialog.setRatio(this.chart.getDialPlotBGRatio());
            imageDialog.show(this.chart.getDialPlotBGImage().getUrl(), this.chart.getDialPlotBGImage().getRelativeUrl(), this.chart.getDialPlotBGImage().getOption());
        } else {
            imageDialog.pack();
            if (urldir != null) {
                imageDialog.show(urldir);
            } else {
                imageDialog.setVisible(true);
            }
        }
    }

    void doQuery() {
        if (this.isDrillDownEnabled() || this.isFieldDrillDownChart()) {
            this.showHint(LanguageEncoder.getText("This function is not available for drill-down chart."), true);
            return;
        }
        if (this.chartWizard != null && this.chartWizard instanceof ModifyWizard && (this.chartWizard.isVisible() || this.chartWizard.manager != null && this.chartWizard.manager.isVisible())) {
            this.chartWizard.toFront();
            return;
        }
        this.chartWizard = new ModifyWizard(this);
        this.chartWizard.toFront();
    }

    private void do_modifyDatabase() {
        if (this.isDrillDownEnabled()) {
            this.showHint(LanguageEncoder.getText("This function is not available for drill-down chart."), true);
            return;
        }
        UpdateDatabaseWizard wizard = new UpdateDatabaseWizard(this);
        wizard.updateChart(true);
    }

    private void do_modifySQL() {
        if (this.isDrillDownEnabled()) {
            this.showHint(LanguageEncoder.getText("This function is not available for drill-down chart."), true);
            return;
        }
        UpdateQueryWizard wizard = new UpdateQueryWizard(this);
        wizard.updateChart();
    }

    private void do_param() {
        try {
            new ParamDialog(this).setVisible(true);
            this.chart.setTickerOrder();
            this.qbrepaint();
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to modify query parameters", ex);
            new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(ex.toString());
        }
    }

    private void showStatus(String s) {
        this.showHint(s);
    }

    private void do_OpenTemplate() {
        if (this.chart == null) {
            this.showStatus(LanguageEncoder.getText("Please create a chart first before using a template."));
            return;
        }
        this.do_drillRemoveAll();
        if (this.isDrillDownEnabled()) {
            return;
        }
        OpenSaveDialog dialog = this.chart.chartType == 17 ? new ApplyGaugeTemplateDialog(this, LanguageEncoder.getText("Apply Template..."), 2) : new OpenSaveDialog(this, LanguageEncoder.getText("Apply Template..."), 2);
        dialog.setCurrentDirectory(this.getBrowseDirectories().getChartTemplatesDirectory());
        dialog.setVisible(true);
        try {
            if (new FileInfo(dialog.getCurrentDirectory()).exists()) {
                this.getBrowseDirectories().setChartTemplatesDirectory(dialog.getCurrentDirectory());
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to set templates directory", ex);
        }
    }

    private boolean doesTemplateFileExist(String file) {
        if (file == null) {
            return false;
        }
        if (!file.endsWith(".tpl")) {
            file = file + ".tpl";
        }
        try {
            return Chart.fileExists(this.chart, file);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to check if template file exists", ex);
            return false;
        }
    }

    void do_loadTemplate(String file) {
        if (file == null) {
            return;
        }
        if (!file.endsWith(".tpl") && !file.endsWith(".xml")) {
            file = file + ".tpl";
        }
        this.chartPanel.setEnabled(false);
        Chart newChart = null;
        try {
            newChart = this.chart.loadTemplate(file);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to load chart", ex);
            new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Invalid file format!"));
            this.chartPanel.setEnabled(true);
            return;
        }
        catch (Error err) {
            LOGGER.log(Level.FINE, "Failed to load chart", err);
            new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Invalid file format!"));
            this.chartPanel.setEnabled(true);
            return;
        }
        this.setURLForRelativeImagePath();
        this.setChart(newChart, true);
        this.setModified();
        this.chartPanel.setEnabled(true);
    }

    public void do_Open() {
        if (this.isDrillDownDefined && this.parentChart != null && this.parentChart.getDrillNumber() > 0) {
            this.showHint(LanguageEncoder.getText("This function is only available for top level chart."), true);
            return;
        }
        if (this.modified && this.chart != null) {
            this.isOpen = true;
            this.checksaveDialog = new MessageDialog(this, LanguageEncoder.getText("Question"), true, true, LanguageEncoder.getText("Yes") + "," + LanguageEncoder.getText("No") + "," + LanguageEncoder.getText("Cancel"));
            this.checksaveDialog.addActionListener(this);
            this.checksaveDialog.show(SAVE_QUESTION);
            return;
        }
        if (this.chart != null) {
            this.do_Close();
        }
        OpenSaveDialog dialog = new OpenSaveDialog(this, LanguageEncoder.getText("Open File..."), 1);
        dialog.setCurrentDirectory(this.getBrowseDirectories().getChartTemplatesDirectory());
        dialog.setVisible(true);
        try {
            if (new FileInfo(dialog.getCurrentDirectory()).exists()) {
                this.getBrowseDirectories().setChartTemplatesDirectory(dialog.getCurrentDirectory());
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to set templates directory", ex);
        }
    }

    public boolean do_openChart(String file) {
        boolean isOpen = this.do_openChart(file, null, false);
        if (isOpen) {
            this.clearUndoRedoList();
            this.clearItemName();
            this.setTitle(this.getChartFile());
        }
        return isOpen;
    }

    public boolean do_openChart(String file, byte[] bytes) {
        boolean isOpen = this.do_openChart(file, bytes, false);
        if (isOpen) {
            this.clearUndoRedoList();
        }
        return isOpen;
    }

    public boolean do_openChart(String file, byte[] bytes, boolean dontExpandSubFilesForPac) {
        DataInputStream din;
        Chart newchart;
        this.isOpen = false;
        if (file == null) {
            return false;
        }
        if (!(file.toLowerCase().endsWith(".tpl") || file.toLowerCase().endsWith(".cht") || file.toLowerCase().endsWith(".xml") || file.toLowerCase().endsWith(".qch") || file.toLowerCase().endsWith(".pac"))) {
            file = file + ".cht";
        }
        if (file.toLowerCase().startsWith("http://") || file.toLowerCase().startsWith("https://")) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), "Cannot open URL path file in designer", 6);
            return false;
        }
        this.chartPanel.setEnabled(false);
        ReadDataFile readfile = new ReadDataFile();
        if (IOUtil.isXMLFormat(file)) {
            try {
                newchart = readfile.createXMLChart(file, this.chartPanel);
                this.setDrillDownTree(new JTree(new DrillDownTreeModel(newchart.currentNode)));
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Cannot create chart", ex);
                new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Cannot create chart!\n") + ex.toString());
                this.chartPanel.setEnabled(true);
                return false;
            }
        }
        if (bytes != null) {
            din = new DataInputStream(new ByteArrayInputStream(bytes));
        } else {
            try {
                din = readfile.getInputStream(this.chart, file);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Can't read file", ex);
                new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("File not found!\n") + file);
                this.chartPanel.setEnabled(true);
                return false;
            }
        }
        try {
            LoadChart lchart = new LoadChart();
            lchart.setDontExpandSubFilesForPac(dontExpandSubFilesForPac);
            newchart = lchart.load(this.chartPanel, din, file.endsWith(".tpl"), null);
            if (this.chart != null) {
                newchart.mergeSubFilesTable(this.chart.getSubFilesTable());
            }
            if (lchart.getDrillDownNode() != null) {
                lchart.getDrillDownNode().setSelected(true);
                this.setDrillDownTree(new JTree(new DrillDownTreeModel(lchart.getDrillDownNode())));
                newchart.currentNode = lchart.getDrillDownNode();
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to load chart", ex);
            new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Invalid file format!\n") + ex.toString());
            this.chartPanel.setEnabled(true);
            try {
                readfile.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Failed to close read data file", ex2);
            }
            return false;
        }
        catch (Error err) {
            LOGGER.log(Level.FINE, "Failed to load chart", err);
            new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Invalid file format!\n") + err.toString());
            this.chartPanel.setEnabled(true);
            try {
                readfile.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Failed to close read data file", ex2);
            }
            return false;
        }
        try {
            readfile.close();
        }
        catch (Exception ex2) {
            LOGGER.log(Level.FINEST, "Failed to close read data file", ex2);
        }
        this.setURLForRelativeImagePath(newchart);
        boolean success = this.openNewChart(newchart, file);
        if (success) {
            this.insertLastOpenedFile(file);
        }
        if (newchart.isHistogram()) {
            this.setMenuForHistogram(false);
        }
        return success;
    }

    private Object do_openChart(String s, Object[] params) {
        Object object = null;
        String chartName = this.filename;
        Cursor currentCursor = this.getCursor();
        if (s.toLowerCase().endsWith(".cht") || s.toLowerCase().endsWith(".tpl") || s.toLowerCase().endsWith(".xml") || s.toLowerCase().endsWith(".qch")) {
            try {
                Chart cht;
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (params == null) {
                    LoadChart lr = new LoadChart();
                    lr.setSubFilesTable(this.chart.getSubFilesTable());
                    cht = lr.loadChartFromFile(this, s, null);
                    if (lr.getDrillDownNode() != null) {
                        cht.currentNode = lr.getDrillDownNode();
                    }
                } else {
                    chartName = this.chart.currentNode.getFileName();
                    Vector<Object[]> vect = new Vector<Object[]>();
                    vect.addElement(params);
                    LoadChart loadChart = new LoadChart();
                    loadChart.setSubFilesTable(this.chart.getSubFilesTable());
                    cht = loadChart.loadChartFromFile(this, s, vect);
                    cht.currentNode = this.chart.currentNode.getChildAt(0);
                    object = this.chart;
                }
                this.setCursor(currentCursor);
                if (object == null) {
                    object = chartName == null || chartName.equals("") ? this.chart : chartName;
                }
                if (!this.openNewChart(cht, s)) {
                    return null;
                }
                this.repaint();
                if (this.chart.isHistogram()) {
                    this.setMenuForHistogram(false);
                }
                return object;
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to open chart", ex);
                this.setCursor(currentCursor);
                return null;
            }
        }
        return null;
    }

    protected boolean openNewChart(Chart newchart, String file) {
        return this.openNewChart(newchart, file, false);
    }

    protected boolean openNewChart(Chart newchart, String file, boolean showReportDataHasChangedDialog) {
        this.showReportDataHasChangedDialog = showReportDataHasChangedDialog;
        if (this.chart != null) {
            this.setChart(newchart, true);
            if (this.isForBean) {
                this.modified = true;
            }
            this.chartPanel.setEnabled(true);
        } else {
            this.do_enable();
            if (this.isForBean) {
                this.modified = true;
            }
            this.setNewChart(newchart);
        }
        if (this.drillDownTree != null && this.drillDownTree.getModel().getChildCount(this.drillDownTree.getModel().getRoot()) > 0) {
            String rootFile = ((DrillDownNode)this.drillDownTree.getModel().getRoot()).getFileName();
            if (file.toLowerCase().endsWith(".pac") || rootFile == null || rootFile.trim().equals("")) {
                this.setFileName(file);
                if (file.toLowerCase().endsWith(".pac")) {
                    ((DrillDownNode)this.drillDownTree.getModel().getRoot()).setFileName(file);
                }
            } else {
                this.setFileName(rootFile);
            }
        } else {
            this.setFileName(file);
        }
        this.toFront();
        this.parentChart = newchart;
        this.isDrillDownDefined = this.parentChart.drillDownVector != null && this.parentChart.drillDownVector.size() > 0;
        this.drillTemplateName = this.parentChart.drillTemplateName;
        this.oldTitle = null;
        this.originalMetaData = null;
        this.originalColData = null;
        this.drillHistory = null;
        if (this.isDrillDownEnabled()) {
            this.enableNonDrillDownMenu(true);
            this.enableZoomHistOptions(false);
        } else {
            this.enableNonDrillDownMenu(true);
            this.enableZoomHistOptions(true);
        }
        this.checkDataSource();
        return true;
    }

    protected void do_disable() {
        if (CustomizeElement.isERES()) {
            this.setTitle(CustomizeElement.getCustomData("[ERES Organizer][Text][Chart Designer Title]", LanguageEncoder.getText("Chart Designer")));
        } else {
            this.setTitle(CustomizeElement.getCustomData("[Organizer][Text][Chart Designer Title]", LanguageEncoder.getText("Chart Designer")));
        }
        this.showHint("");
        if (this.getChartFile() != null) {
            this.clearItemName();
        }
        this.filename = null;
        this.editmenu.setEnabled(false);
        this.formatmenu.setEnabled(false);
        this.drillDownmenu.setEnabled(false);
        this.chartTypemenu.setEnabled(false);
        this.datamenu.setEnabled(false);
        this.layoutmenu.setEnabled(false);
        this.closeitem.setEnabled(false);
        this.saveitem.setEnabled(false);
        this.saveasitem.setEnabled(false);
        this.templateitem.setEnabled(false);
        this.exportitem.setEnabled(false);
        this.globalPanel.setEnabled(false);
    }

    protected void do_enable() {
        this.chartPanel.setEnabled(true);
        this.globalPanel.setEnabled(true);
        this.editmenu.setEnabled(true);
        this.formatmenu.setEnabled(true);
        this.drillDownmenu.setEnabled(true);
        this.chartTypemenu.setEnabled(true);
        this.datamenu.setEnabled(true);
        this.layoutmenu.setEnabled(true);
        this.closeitem.setEnabled(true);
        this.saveitem.setEnabled(true);
        this.saveasitem.setEnabled(true);
        this.templateitem.setEnabled(true);
        this.exportitem.setEnabled(true);
        if (this.chart != null && this.chart.chartType == 17) {
            this.dialForegroundImage.setEnabled(true);
            this.dialBackgroundImage.setEnabled(true);
        } else {
            this.dialForegroundImage.setEnabled(false);
            this.dialBackgroundImage.setEnabled(false);
            if (this.chart != null) {
                this.chart.setDialPlotBGImage(null, 3);
                this.chart.setDialPlotFGImage(null, 3);
            }
            this.repaint();
        }
        this.toFront();
    }

    private void do_viewRecord() {
        if (this.recordFrame == null) {
            this.recordFrame = new RecordFrame(this, LanguageEncoder.getText("View Table"), this.chart.colData);
            this.recordFrame.setVisible(true);
        } else {
            this.recordFrame.toFront();
        }
    }

    private void do_viewTable() {
        if (this.viewTableFrame == null) {
            this.viewTableFrame = new ViewTableFrame(this, "View Chart Data", this.chart);
            this.viewTableFrame.setVisible(true);
        } else {
            this.viewTableFrame.toFront();
        }
    }

    private void do_viewDataSourceInfo() {
        if (this.dataSourceInfoFrame == null) {
            this.dataSourceInfoFrame = new DataSourceInfoFrame(this, LanguageEncoder.getText("View Data Source Info"));
            this.dataSourceInfoFrame.setVisible(true);
        } else {
            this.dataSourceInfoFrame.toFront();
        }
    }

    void qbpaint() {
        this.chartPanel.paint();
        this.firstErrorEncounter = true;
    }

    void qbrepaint() {
        this.chartPanel.repaint();
        this.firstErrorEncounter = true;
    }

    void do_DefineControlRange() {
        this.do_DefineControlRange(null);
    }

    void do_DefineControlRange(ControlRange controlRange) {
        if (!this.chart.isControlRangeEnabled()) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("This chart type does not support control area!"));
            return;
        }
        new ControlRangeListDialog(this, controlRange).setVisible(true);
    }

    void do_DefineTrendLine() {
        this.do_DefineTrendLine(null);
    }

    void do_DefineTrendLine(TrendLine tline) {
        if (tline == null && TrendLine.invalidchart(this.chart) || tline != null && tline.invalidchart()) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("TrendLine does not support this chart type!"));
            return;
        }
        new TrendLineListDialog(this).show(tline);
    }

    void do_DefineHorzVertLine() {
        this.do_DefineHorzVertLine(null);
    }

    void do_DefineHorzVertLine(HorzVertLine hline) {
        if (hline == null && HorzVertLine.invalidchart(this.chart) || hline != null && hline.invalidchart()) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("Horz/Vert Line does not support this chart type!"));
            return;
        }
        new HorzVertLineListDialog(this).show(hline);
    }

    private void do_DefineHyperLink() {
        PickData pd = null;
        if (this.chart.chartType != 12) {
            pd = new PickData();
            pd.category = "";
            switch (this.chart.dataDim) {
                case 2: {
                    if (this.chart.isStackType()) {
                        pd.sumBy = "";
                        break;
                    }
                    pd.series = "";
                    break;
                }
                case 3: {
                    pd.sumBy = "";
                    pd.series = "";
                    break;
                }
            }
        }
        this.do_DefineHyperLink(pd, true);
    }

    void do_DefineHyperLink(PickData pd, boolean showfirst) {
        if (this.parentChart != null && this.parentChart.isDrillDownDefined()) {
            MessageDialog.showError(this, true, "Cannot add hyperlink to drill-down chart!");
            return;
        }
        if (this.chart.chartType == 12) {
            HyperLinkListForSurfaceDialog hs = new HyperLinkListForSurfaceDialog(this, LanguageEncoder.getText("Define HyperLink..."));
            hs.setVisible(true);
            this.setModified();
            if (!showfirst) {
                hs.show(pd);
            }
        } else if (pd.category != null || pd.series != null || pd.sumBy != null) {
            HyperLinkListDialog hd = new HyperLinkListDialog(this, LanguageEncoder.getText("Define HyperLink..."), pd);
            if (!showfirst) {
                hd.show(pd);
            }
            hd.setVisible(true);
        }
    }

    void do_goback() {
        if (this.linkhistory.size() > 0) {
            if (this.modified) {
                this.bgoback2 = true;
                this.exitdialog = new MessageDialog(this, LanguageEncoder.getText("Question"), true, true, LanguageEncoder.getText("Yes") + "," + LanguageEncoder.getText("No") + "," + LanguageEncoder.getText("Cancel"));
                this.exitdialog.addActionListener(this);
                this.exitdialog.show(SAVE_QUESTION);
                return;
            }
            if (this.linkhistory.lastElement() instanceof Chart) {
                Chart tmpCht = (Chart)this.linkhistory.lastElement();
                this.linkhistory.removeElement(tmpCht);
                if (this.linkhistory.size() == 0) {
                    this.gobackItem.setEnabled(false);
                }
                this.openNewChart(tmpCht, this.filename);
            } else {
                String s = (String)this.linkhistory.lastElement();
                this.linkhistory.removeElement(s);
                if (this.linkhistory.size() == 0) {
                    this.gobackItem.setEnabled(false);
                }
                this.do_openChart(s);
            }
        }
    }

    boolean isGoBackLinkEnabled() {
        return this.linkhistory.size() > 0;
    }

    boolean isFieldDrillDownChart() {
        if (this.drillDownTree == null) {
            return false;
        }
        return ((DrillDownNode)this.drillDownTree.getModel().getRoot()).getChildCount() > 0;
    }

    boolean isFieldDrillDownEnabled() {
        if (this.drillDownTree == null || this.chart.currentNode == null) {
            return false;
        }
        return this.chart.currentNode.getChildCount() > 0;
    }

    void nextFieldDrillDownFromLegend(int x, int y) {
        MultiDimData lData = this.chart.legend.getSelectedData(x, y);
        if (lData == null) {
            return;
        }
        this.chart.getInformation(lData);
        this.nextFieldDrillDown();
    }

    void nextFieldDrillDown() {
        Object obj;
        DrillDownNode cNode = this.chart.currentNode.getChildAt(0);
        int[] mapping = cNode.getColumnMapping();
        if (mapping == null) {
            LOGGER.fine("Mapping is null");
            return;
        }
        Object[] value = new Object[mapping.length];
        for (int i = 0; i < mapping.length; ++i) {
            if (mapping[i] >= 0) {
                String param = this.chart.colData[mapping[i]].getName();
                if (param.equals(this.chart.pickdata.valueName)) {
                    try {
                        value[i] = DataType.createObject(this.chart.pickdata.value + "", this.chart.colData[mapping[i]].getDataType());
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.WARNING, "ChartMain:  Cannot get field data!", ex);
                        value[i] = "";
                    }
                } else if (param.equals(this.chart.pickdata.seriesName)) {
                    value[i] = this.chart.pickdata.series;
                } else if (param.equals(this.chart.pickdata.categoryName)) {
                    value[i] = this.chart.pickdata.category;
                } else if (param.equals(this.chart.pickdata.sumByName)) {
                    value[i] = this.chart.pickdata.sumBy;
                }
            } else {
                value[i] = "UnMapped";
            }
            if (this.chart.getChartType() != 6 || !(this.chart.getPieGroupOthersLimit() > 0.0) || !this.chart.getPieGroupOthersName().equals(value[i])) continue;
            return;
        }
        if (this.modified) {
            this.do_Save();
        }
        if ((obj = this.do_openChart(cNode.getFileName(), value)) != null) {
            this.gobackItem.setEnabled(true);
            this.linkhistory.addElement(obj);
        }
    }

    public void enableNonDrillDownMenu(boolean enable) {
        this.newitem.setEnabled(enable);
        this.openitem.setEnabled(enable);
        this.closeitem.setEnabled(enable);
        this.exititem.setEnabled(enable);
        this.saveasitem.setEnabled(enable);
        this.templateitem.setEnabled(enable);
        this.drillDynamicitem.setEnabled(!this.isDrillDownDefined);
        this.drillNavigateItem.setEnabled(!this.isDrillDownDefined);
        this.drillDownmenu.setEnabled(this.chart != null);
        if (this.isDrillDownDefined) {
            this.drillRemoveAllitem.setEnabled(true);
            this.drilloptionsitem.setEnabled(true);
            this.drillDynamicitem.setEnabled(false);
            this.drillNavigateItem.setEnabled(false);
        } else {
            if (this.chart == null || DrillDownInfo.checkDrillDownType(this.chart.getChartType())) {
                this.drilloptionsitem.setEnabled(enable);
                this.drillDynamicitem.setEnabled(!this.isFieldDrillDownChart());
            } else {
                this.drilloptionsitem.setEnabled(false);
                this.drillDynamicitem.setEnabled(false);
            }
            if (this.chart != null) {
                if (this.parentChart != null) {
                    this.drillNavigateItem.setEnabled(!this.parentChart.isDynamicDrillDown);
                } else {
                    this.drillNavigateItem.setEnabled(true);
                }
            }
            this.drillRemoveAllitem.setEnabled(false);
        }
        this.drillGoToTopitem.setEnabled(!enable);
        if (this.isDrillDownDefined && this.parentChart != null) {
            if (this.parentChart.getDrillNumber() > 0) {
                this.drillPreviousitem.setEnabled(true);
                this.drillRemoveitem.setEnabled(true);
            } else {
                this.drillPreviousitem.setEnabled(false);
                this.drillRemoveitem.setEnabled(false);
            }
            if (this.parentChart.isDrillDownDefined()) {
                this.drillNextitem.setEnabled(true);
            } else {
                this.drillNextitem.setEnabled(false);
            }
        } else {
            this.drillNextitem.setEnabled(false);
            this.drillPreviousitem.setEnabled(false);
            this.drillRemoveitem.setEnabled(false);
        }
        if (this.parentChart != null && this.parentChart.isDynamicDrillDown) {
            this.drilloptionsitem.setEnabled(false);
            this.drillRemoveAllitem.setEnabled(false);
            this.drillRemoveitem.setEnabled(false);
            this.drillPreviousitem.setEnabled(false);
            this.drillNextitem.setEnabled(false);
            this.drillGoToTopitem.setEnabled(false);
            this.drillNavigateItem.setEnabled(false);
        }
        if (this.isFieldDrillDownChart()) {
            this.drilloptionsitem.setEnabled(false);
            this.drillRemoveAllitem.setEnabled(false);
            this.drillRemoveitem.setEnabled(false);
            this.drillPreviousitem.setEnabled(false);
            this.drillNextitem.setEnabled(false);
            this.drillGoToTopitem.setEnabled(false);
            this.drillDynamicitem.setEnabled(false);
            this.modifydataitem.setEnabled(false);
            this.modifydbitem.setEnabled(false);
            this.modifysqlitem.setEnabled(false);
        } else {
            this.modifydataitem.setEnabled(true);
            this.modifydbitem.setEnabled(true);
            this.modifysqlitem.setEnabled(true);
        }
        if (this.chartPanel != null && this.chartPanel.chart != null) {
            if (this.chartPanel.chart.nRow <= 0) {
                this.chartTypemenu.setEnabled(false);
            } else {
                this.chartTypemenu.setEnabled(true);
            }
        }
        if (!this.isForBean) {
            this.schedulerefreshitem.setEnabled(enable);
        }
    }

    boolean isDrillDownEnabled() {
        if (this.isDrillDownDefined) {
            return true;
        }
        return this.parentChart != null && this.parentChart.isDynamicDrillDown;
    }

    public void enableZoomHistOptions(boolean enable) {
        this.zoomitem.setEnabled(enable && this.isZoomEnabled(false));
        this.histogramitem.setEnabled(enable && this.isHistogramEnabled(false));
        this.optionsitem.setEnabled(enable);
        this.modifydataitem.setEnabled(enable && !this.isFieldDrillDownChart());
        this.aggregationItem.setEnabled(enable && this.isAggregationEnabled(false));
        boolean enabledb = enable && this.chart != null && (this.chart.sourceData == 1 || this.chart.sourceData == 0 && this.chart.getOriginalSourceData() == 1) && !this.isFieldDrillDownChart();
        this.modifydbitem.setEnabled(enabledb);
        this.modifysqlitem.setEnabled(enabledb);
        this.modifyparamitem.setEnabled(enable && this.chart != null && this.chart.getQueryFileInfo() != null && !(this.chart.getQueryFileInfo() instanceof SalesForceQueryFileInfo) && !(this.chart.getQueryFileInfo() instanceof SOAPQueryFileInfo) && QueryParser.hasParameters(this.chart.getQueryFileInfo().getQuery()));
        this.do_enable();
    }

    private void do_drillGoToTop() {
        String tplName = null;
        if (this.parentChart == null) {
            return;
        }
        if (this.parentChart.getDrillNumber() > 0 && (!this.doesTemplateFileExist(tplName = this.createDrillTemplateName()) && !this.ignoreSave || this.modified)) {
            this.drillsaveDialog = new MessageDialog(this, LanguageEncoder.getText("Question"), true, true, LanguageEncoder.getText("Yes") + "," + LanguageEncoder.getText("No"));
            this.drillsaveDialog.addActionListener(this);
            this.drillsaveDialog.show(SAVE_QUESTION);
        }
        while (this.parentChart.getDrillNumber() > 0) {
            this.parentChart.decrementDrillNumber();
        }
        GraphicsTable.recoverTableSize(this.parentChart);
        this.parentChart.valueTable.setDrillHistory(null);
        this.parentChart.usedColumns = null;
        this.parentChart = ReloadChart.reloadData(this.parentChart, true);
        this.setNewChart(this.parentChart);
        this.setFileName(this.filename);
        this.setModified();
        this.ignoreSave = false;
        this.nextDrill = false;
        this.previousDrill = false;
        this.drillHistory = null;
        this.enableNonDrillDownMenu(true);
    }

    private void do_drillPrevious() {
        this.previousDrillDown();
    }

    boolean isPreviousDrillDownEnabled() {
        if (this.parentChart == null) {
            return false;
        }
        return this.parentChart.getDrillNumber() > 0;
    }

    public void previousDrillDown() {
        String tplName = null;
        if (this.parentChart == null) {
            return;
        }
        if (this.parentChart.getDrillNumber() > 0 && (!this.doesTemplateFileExist(tplName = this.createDrillTemplateName()) && !this.ignoreSave || this.modified)) {
            if (this.parentChart.isPACFile()) {
                this.doSaveDrillTemplate(this.chart, tplName);
            } else {
                this.previousDrill = true;
                this.drillsaveDialog = new MessageDialog(this, LanguageEncoder.getText("Question"), true, true, LanguageEncoder.getText("Yes") + "," + LanguageEncoder.getText("No") + "," + LanguageEncoder.getText("Cancel"));
                this.drillsaveDialog.addActionListener(this);
                this.drillsaveDialog.show(SAVE_QUESTION);
                return;
            }
        }
        this.parentChart.decrementDrillNumber();
        if (this.parentChart.getDrillNumber() <= 0) {
            this.parentChart.valueTable.setDrillHistory(null);
            this.parentChart.usedColumns = null;
            GraphicsTable.recoverTableSize(this.parentChart);
            this.parentChart = ReloadChart.reloadData(this.parentChart, true);
            this.setNewChart(this.parentChart);
            this.setFileName(this.filename);
            this.setModified();
            this.ignoreSave = false;
            this.nextDrill = false;
            this.previousDrill = false;
            this.drillHistory = null;
            this.clearUndoRedoList();
            this.enableNonDrillDownMenu(true);
            return;
        }
        if (!this.parentChart.isDrillDownDefined()) {
            return;
        }
        if (this.drillHistory == null) {
            return;
        }
        this.setTitle(LanguageEncoder.getText("Please wait..."));
        this.originalMetaData = ReloadChart.getMetaDataInfo(this.parentChart);
        this.parentChart.decrementDrillNumber();
        int[] map = this.parentChart.getDrillDownMap();
        int dim = this.parentChart.getDrillDownDimension();
        int cType = this.parentChart.getDrillDownType();
        boolean dType = this.parentChart.isDrillDown2D();
        this.parentChart.incrementDrillNumber();
        int valCol = this.parentChart.getValueMap();
        int subvalCol = this.parentChart.getSubValueMap();
        if (this.parentChart.summaryChart) {
            valCol = this.parentChart.originalMap[valCol];
            if (subvalCol >= 0) {
                subvalCol = this.parentChart.originalMap[subvalCol];
            }
        }
        PreprocInfo tsInfo = this.drillHistory.createPreprocInfo(map, dim, valCol, subvalCol, cType, dType, this.parentChart.primaryAggregate, this.parentChart.secondaryAggregate);
        this.valueTableSave = this.chart.valueTable;
        this.chart = Chart.createChart(this.chartPanel, cType, dType, null, this.drillHistory.previousDrill(tsInfo), null);
        this.chart.setSubFilesTable(this.parentChart.getSubFilesTable());
        this.drillHistory.setChartType(this.chart, tsInfo);
        this.chart.setSize(this.parentChart.getSize());
        tplName = this.createDrillTemplateName();
        if (this.doesTemplateFileExist(tplName)) {
            this.do_loadTemplate(tplName);
            this.clearUndoRedoList();
            if (this.chart.showTable()) {
                GraphicsTable.recoverTableSize(this.chart);
            }
        } else {
            if (this.chart.showTable()) {
                GraphicsTable.recoverTableSize(this.chart);
            }
            this.setNewChart(this.chart);
            this.clearUndoRedoList();
        }
        this.setTitle("Drill-Down Chart: " + this.parentChart.getDrillNumber());
        this.enableNonDrillDownMenu(false);
        this.ignoreSave = false;
        this.nextDrill = false;
        this.previousDrill = false;
        this.setUnModified();
    }

    private void do_drillNext() {
        if (this.chartPanel.chart.notEnoughData()) {
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("No more data available to plot"));
            return;
        }
        this.pickingData();
        this.nextDrillDown();
    }

    private void pickingData() {
        if (!(this.chartPanel.selectobj instanceof MultiDimData)) {
            MultiDimData drillmData = this.chartPanel.chart.mData.getAnyLeafNode();
            this.chartPanel.chart.getInformation(drillmData);
        }
    }

    public void nextDrillDownFromLegend(int x, int y) {
        MultiDimData lData = this.chart.legend.getSelectedData(x, y);
        if (lData == null) {
            return;
        }
        this.chart.getInformation(lData);
        this.nextDrillDown();
    }

    public void nextDrillDown() {
        String tplName;
        String oldTitle = this.getTitle();
        if (this.parentChart == null) {
            this.parentChart = this.chart;
        }
        if (!this.parentChart.isDrillDownDefined()) {
            return;
        }
        if (this.drillHistory == null) {
            this.originalMetaData = ReloadChart.getMetaDataInfo(this.parentChart);
            this.drillHistory = new DrillHistory(this.parentChart, this.originalMetaData);
            this.chart.valueTable.setDrillHistory(this.drillHistory);
        }
        if (this.parentChart.getDrillNumber() > 0 && (!this.doesTemplateFileExist(tplName = this.createDrillTemplateName()) && !this.ignoreSave || this.modified)) {
            if (this.parentChart.isPACFile()) {
                this.doSaveDrillTemplate(this.chart, tplName);
                this.nextDrillDown();
                return;
            }
            this.nextDrill = true;
            this.drillsaveDialog = new MessageDialog(this, LanguageEncoder.getText("Question"), true, true, LanguageEncoder.getText("Yes") + "," + LanguageEncoder.getText("No") + "," + LanguageEncoder.getText("Cancel"));
            this.drillsaveDialog.addActionListener(this);
            this.drillsaveDialog.show(SAVE_QUESTION);
            return;
        }
        this.isDrillDownDefined = this.parentChart.drillDownVector.size() > 0;
        int[] map = this.parentChart.getDrillDownMap();
        int dim = this.parentChart.getDrillDownDimension();
        int cType = this.parentChart.getDrillDownType();
        boolean dType = this.parentChart.isDrillDown2D();
        int valCol = this.parentChart.getValueMap();
        int subvalCol = this.parentChart.getSubValueMap();
        if (this.parentChart.summaryChart) {
            valCol = this.parentChart.originalMap[valCol];
            if (subvalCol >= 0) {
                subvalCol = this.parentChart.originalMap[subvalCol];
            }
        }
        this.setTitle(LanguageEncoder.getText("Please wait..."));
        PreprocInfo tsInfo = this.drillHistory.createPreprocInfo(map, dim, valCol, subvalCol, cType, dType, this.parentChart.primaryAggregate, this.parentChart.secondaryAggregate);
        this.valueTableSave = this.chart.valueTable;
        Chart tempChart = Chart.createChart(this.chartPanel, cType, dType, null, this.drillHistory.nextDrill(this.chart.pickdata, tsInfo), null);
        tempChart.setSubFilesTable(this.parentChart.getSubFilesTable());
        if (tempChart.notEnoughData()) {
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show("Not enough data available to plot.\nPlease try other data point.");
            this.drillHistory.removeLastDrill();
            this.setTitle(oldTitle);
            this.ignoreSave = false;
            this.nextDrill = false;
            this.previousDrill = false;
            this.setUnModified();
            if (this.isNewDrillLevel) {
                this.isNewDrillLevel = false;
                this.parentChart.removeDrillDown(this.parentChart.drillNumber);
                if (this.parentChart.drillDownVector.size() <= 0) {
                    this.resetDrillDownChart();
                } else if (this.parentChart.getDrillNumber() <= 0) {
                    this.enableNonDrillDownMenu(true);
                } else {
                    this.enableNonDrillDownMenu(false);
                }
            }
            return;
        }
        this.isNewDrillLevel = false;
        this.chart = tempChart;
        this.drillHistory.setChartType(this.chart, tsInfo);
        this.parentChart.incrementDrillNumber();
        this.chart.setSize(this.parentChart.getSize());
        tplName = this.createDrillTemplateName();
        if (this.doesTemplateFileExist(tplName)) {
            this.do_loadTemplate(tplName);
            if (this.chart.showTable()) {
                GraphicsTable.recoverTableSize(this.chart);
            }
        } else {
            if (this.chart.showTable()) {
                GraphicsTable.recoverTableSize(this.chart);
            }
            this.setNewChart(this.chart);
        }
        this.setTitle("Drill-Down Chart: " + this.parentChart.getDrillNumber());
        this.clearUndoRedoList();
        this.enableNonDrillDownMenu(false);
        this.ignoreSave = false;
        this.nextDrill = false;
        this.previousDrill = false;
        this.setUnModified();
    }

    public JMenuBar getChartMenuBar() {
        return this.menubar;
    }

    public JToolBar getChartToolBar() {
        return this.toolbar;
    }

    void do_JumpLink() {
        this.do_JumpLink(-1, -1);
    }

    void do_JumpLink(int x, int y) {
        String target;
        String s;
        if (this.chart.chartType == 12) {
            if (this.chart.pickdata.faceData == null) {
                return;
            }
            FaceData faceData = (FaceData)this.chart.pickdata.faceData;
            s = faceData.getHyperLink();
            if (s == null) {
                return;
            }
            s = s.trim();
            target = faceData.getTarget();
        } else if (x < 0 || y < 0) {
            HyperLink ln = new HyperLink(this.chart.pickdata).findNewLink(this.chart.hyperlinkList);
            if (ln == null) {
                return;
            }
            s = ln.link.trim();
            target = ln.target;
        } else {
            String[] lnkInfo = this.chart.cgraphics.findLinkContaining(x, y);
            if (lnkInfo == null) {
                return;
            }
            s = lnkInfo[0].trim();
            target = lnkInfo[1];
        }
        if (s.toLowerCase().endsWith(".cht") || s.toLowerCase().endsWith(".tpl") || s.toLowerCase().endsWith(".qch")) {
            if (this.modified) {
                this.bgoback = true;
                this.exitdialog = new MessageDialog(this, LanguageEncoder.getText("Question"), true, true, LanguageEncoder.getText("Yes") + "," + LanguageEncoder.getText("No") + "," + LanguageEncoder.getText("Cancel"));
                this.exitdialog.addActionListener(this);
                this.exitdialog.show(SAVE_QUESTION);
                return;
            }
            String oldname = this.filename;
            if (this.do_openChart(s) && oldname != null) {
                this.gobackItem.setEnabled(true);
                this.linkhistory.addElement(oldname);
            }
        } else {
            try {
                Applet applet = ServerMessage.getApplet();
                if (applet == null) {
                    String m = LanguageEncoder.getText("Cannot start browser from an application. Please open the following URL in your browser:") + " " + s;
                    new MessageDialog((Frame)this, LanguageEncoder.getText("Warning")).show(m);
                    return;
                }
                if (s.startsWith("http:") || s.startsWith("https:")) {
                    applet.getAppletContext().showDocument(new URL(s), target);
                } else {
                    applet.getAppletContext().showDocument(new URL(applet.getDocumentBase(), s), target);
                }
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to open URL in browser", ex);
                new MessageDialog((Frame)this, LanguageEncoder.getText("Error")).show(ex.toString());
            }
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
    }

    private void do_UpdateBean() {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, null));
        }
        this.modified = false;
        LOGGER.finest("Updating bean");
    }

    private void do_ResetBean() {
        this.modified = false;
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1, null));
            LOGGER.finest("Resetting bean");
        }
    }

    void showHint(String s) {
        this.showHint(s, false);
    }

    private void showHint(String s, boolean showDialog) {
        s = s.replaceAll("\u001d", "");
        this.statusBar.showHint(s);
        if (showDialog) {
            MessageDialog.showError(this, true, s);
        }
    }

    private void setDrawMode() {
        int tp = this.chart.get3DDrawType();
        this.frameButton.setSelected(tp == 0);
        this.frameBorderButton.setSelected(tp == 4 || tp == 2);
        this.gouraudButton.setSelected(tp == 3 || tp == 4);
        this.setGouraudButtonEnabled();
    }

    void do_Lightmodel() {
        if (this.chart.is2DimChart()) {
            MessageDialog.showError(this, true, LanguageEncoder.getText("This function is available for 3D chart only."));
            return;
        }
        new LightDialog(this).setVisible(true);
    }

    private JMenuItem newMenuItem(String s, int key) {
        JMenuItem m = key != 127 ? new JMenuItem(s, key) : new JMenuItem(s);
        m.addActionListener(this);
        return m;
    }

    private JCheckBoxMenuItem newCheckboxMenuItem(String s) {
        JCheckBoxMenuItem m = new JCheckBoxMenuItem(s);
        m.addItemListener(this);
        return m;
    }

    void updateSizeLabel() {
        this.sizelabel.repaint();
    }

    public boolean launchAggregateDialog(boolean isSecondaryAxis, int categoryType, boolean changeTSChart) {
        return this.launchAggregateDialog(isSecondaryAxis, categoryType, changeTSChart, true, false);
    }

    public boolean launchAggregateDialog(boolean isSecondaryAxis, int categoryType, boolean changeTSChart, boolean showCancelButton, boolean isForDrillDown) {
        int chartType = this.chart.chartType;
        if (chartType == 2 || chartType == 12 || chartType == 13 || chartType == 19 || chartType == 18) {
            return true;
        }
        AggregateDialog aggDialog = null;
        aggDialog = new AggregateDialog(this, isSecondaryAxis, categoryType, changeTSChart, showCancelButton, isForDrillDown);
        aggDialog.setVisible(true);
        return !aggDialog.isCancelled();
    }

    public String getLoginUser() {
        return this.loginUser;
    }

    public void setLoginUser(String username) {
        this.loginUser = username;
        this.updateRecentFiles();
    }

    private void insertLastOpenedFile(String fn) {
        RecentFiles.insertFilePath(this.getLoginUser(), 2, fn);
        this.updateRecentFiles();
    }

    private void updateRecentFiles() {
        String[] recentFiles = RecentFiles.getFilePaths(this.getLoginUser(), 2);
        this.updateRecentFiles(recentFiles);
    }

    private void updateRecentFiles(String[] files) {
        int origTotalItems = 10;
        if (files == null || files.length == 0) {
            return;
        }
        while (this.filemenu.getItemCount() > origTotalItems) {
            this.filemenu.remove(origTotalItems - 1);
        }
        for (int i = files.length - 1; i >= 0; --i) {
            if (files[i] == null || files[i].equals("null") || this.isChartData(files[i])) continue;
            JMenuItem jmenuitem = new JMenuItem(files[i]);
            jmenuitem.addActionListener(this.recentFileOpener);
            this.filemenu.insert(jmenuitem, origTotalItems - 1);
        }
        if (this.filemenu.getItemCount() > origTotalItems) {
            this.filemenu.insertSeparator(this.filemenu.getItemCount() - 1);
        }
    }

    public void setChartIO(IChartIO chartIO) {
        this.chartIO = chartIO;
    }

    public void setByPassSaveAsIO(IByPassSaveAsForChart saveAsCHT) {
        this.byPassSaveAs = saveAsCHT;
    }

    public void setModified() {
        this.modified = true;
        this.saveBackupChartToUndoList();
        this.enableUndoRedoButtons();
    }

    public void setModifiedOnly() {
        this.modified = true;
        this.clearUndoRedoList();
    }

    public void setUnModified() {
        this.modified = false;
        this.clearUndoRedoList();
    }

    public boolean isModified() {
        return this.modified;
    }

    void invalidateLegend() {
        this.chart.legend.invalidate();
        this.chart.legend2.invalidate();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.do_exit(true, false);
        if (this.isClose) {
            this.dispose();
        } else {
            this.skipClosingCommand = true;
        }
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.chartPanel.update();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private void showEvalBox() {
        String message = LanguageEncoder.getText("EspressChart Evaluation Copy") + "\n\n" + LanguageEncoder.getText("To order, please contact:") + "\n \t" + LanguageEncoder.getText("Quadbase Systems, Inc.") + "\n \t" + LanguageEncoder.getText("990 Linden Drive, Suite 230") + "\n \t" + LanguageEncoder.getText("Santa Clara, CA 95050") + "\n \t" + LanguageEncoder.getText("USA") + "\n\n \t" + LanguageEncoder.getText("TEL   : 408-982-0835") + "\n \t" + LanguageEncoder.getText("FAX   : 408-982-0838") + "\n \t" + LanguageEncoder.getText("EMAIL : sales@quadbase.com") + "\n \t" + LanguageEncoder.getText("URL   : http://www.quadbase.com");
        MessageDialog mDialog = new MessageDialog((Frame)this, LanguageEncoder.getText("Order Information"));
        mDialog.getTextArea().setText(message);
        Dimension dim = mDialog.getSize();
        dim = new Dimension(dim.width, dim.height * 2);
        mDialog.setSize(dim);
        mDialog.setVisible(true);
    }

    public void saveToDatabase(byte[] data, String fileName, boolean newID) {
    }

    public boolean isChartData(String filename) {
        return false;
    }

    public String getItemName() {
        return null;
    }

    public void setItemName(String str) {
    }

    public void clearItemName() {
    }

    public void insertChartFileToOrganizer(String dbLabel, boolean insertXML) {
    }

    public void insertChartFileToOrganizer(String fileLocation) {
    }

    public boolean isFileNameExisted(String str) {
        return false;
    }

    public String getPath(String loc) {
        return loc;
    }

    public String getBackgroundImagesDir() {
        return ServerMessage.backgroundImagesPath;
    }

    public String getFileDialogDefaultDirectory() {
        return System.getProperty("user.dir");
    }

    public String getBrowseDialogDefaultDirectory() {
        if (this.lastDir != null) {
            return this.lastDir;
        }
        return "";
    }

    public boolean isFromOrganizer() {
        return false;
    }

    public String getURL(String file) {
        return null;
    }

    public boolean isParameterizedChart() {
        return this.chart.queryFilename != null && !this.chart.queryFilename.equals("");
    }

    public String[] getDefaultParamNames() {
        return this.defaultParamNames;
    }

    public void setDefaultParamNames(String[] names) {
        this.defaultParamNames = names;
    }

    public void addDataSourceManagerListener(DataSourceManagerListener listener) {
        if (this.managerListeners == null) {
            this.managerListeners = new Vector();
        }
        this.managerListeners.addElement(listener);
    }

    public void removeDataSourceManagerListener(DataSourceManagerListener listener) {
        if (this.managerListeners == null) {
            return;
        }
        for (int i = this.managerListeners.size() - 1; i >= 0; --i) {
            if (this.managerListeners.elementAt(i) == null || !this.managerListeners.elementAt(i).equals(listener)) continue;
            this.managerListeners.removeElementAt(i);
        }
    }

    Vector<DataSourceManagerListener> getDataSourceManagerListeners() {
        return this.managerListeners;
    }

    protected boolean isReportVersion() {
        return false;
    }

    protected boolean isUsingReportToolBar() {
        return false;
    }

    protected boolean useReportData() {
        return false;
    }

    protected boolean isReportPakFile() {
        return false;
    }

    public void updatePanelSize() {
    }

    private void setFontMapping() {
        if (this.chart == null) {
            new JMessageDialog((Frame)this, LanguageEncoder.getText("Warning"), LanguageEncoder.getText("Please open a chart first."));
        }
        FontMappingDialog fDialog = new FontMappingDialog(this, this.chart.getFontMapping());
        fDialog.setBrowseDirectories(this.getBrowseDirectories());
        fDialog.setVisible(true);
        if (fDialog.isModified()) {
            this.chart.setFontMapping(fDialog.getFontMapping());
            this.setModifiedOnly();
        }
    }

    private void setURLForRelativeImagePath() {
        this.setURLForRelativeImagePath(null);
    }

    private void setURLForRelativeImagePath(Chart chart) {
        this.setURLForRelativeBGImagePath(chart);
        this.setURLForRelativeFGDialImagePath(chart);
        this.setURLForRelativeBGDialImagePath(chart);
    }

    private void setURLForRelativeBGImagePath() {
        this.setURLForRelativeBGImagePath(null);
    }

    private void setURLForRelativeBGImagePath(Chart chart) {
        if (chart == null) {
            chart = this.chart;
        }
        if (chart.getBackgroundImage() != null && chart.getBackgroundImage().getRelativeUrl() != null && chart.getBackgroundImage().getOption() != 3) {
            try {
                String relative = new FileInfo(chart.getBackgroundImage().getRelativeUrl()).getAbsolutePath();
                relative = this.getURL(relative);
                relative = QbUtil.fixUrlString(relative);
                if (relative == null && ServerMessage.getApplet() != null) {
                    relative = IOUtil.getCodeBase(ServerMessage.getApplet()) + chart.getBackgroundImage().getRelativeUrl();
                }
                if (relative == null) {
                    return;
                }
                chart.getBackgroundImage().setAppletDesigner(true);
                chart.setBackgroundImage(new URL(relative), chart.getBackgroundImage().getRelativeUrl(), chart.getBackgroundImage().getOption());
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Failed to set URL for background image", e);
            }
        }
    }

    private void setURLForRelativeFGDialImagePath() {
        this.setURLForRelativeFGDialImagePath(null);
    }

    private void setURLForRelativeFGDialImagePath(Chart chart) {
        if (chart == null) {
            chart = this.chart;
        }
        if (chart.getDialPlotFGImage() != null && chart.getDialPlotFGImage().getRelativeUrl() != null && chart.getDialPlotFGImage().getOption() != 3) {
            try {
                String relative = new FileInfo(chart.getDialPlotFGImage().getRelativeUrl()).getAbsolutePath();
                relative = this.getURL(relative);
                if (relative == null && ServerMessage.getApplet() != null) {
                    relative = IOUtil.getCodeBase(ServerMessage.getApplet()) + chart.getDialPlotFGImage().getRelativeUrl();
                }
                if (relative == null) {
                    return;
                }
                chart.getDialPlotFGImage().setAppletDesigner(true);
                chart.setDialPlotFGImage(new URL(relative), chart.getDialPlotFGImage().getRelativeUrl(), chart.getDialPlotFGImage().getOption());
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Failed to set URL for dial image", e);
            }
        }
    }

    private void setURLForRelativeBGDialImagePath() {
        this.setURLForRelativeBGDialImagePath(null);
    }

    private void setURLForRelativeBGDialImagePath(Chart chart) {
        if (chart == null) {
            chart = this.chart;
        }
        if (chart.getDialPlotBGImage() != null && chart.getDialPlotBGImage().getRelativeUrl() != null && chart.getDialPlotBGImage().getOption() != 3) {
            try {
                String relative = new FileInfo(chart.getDialPlotBGImage().getRelativeUrl()).getAbsolutePath();
                relative = this.getURL(relative);
                if (relative == null && ServerMessage.getApplet() != null) {
                    relative = IOUtil.getCodeBase(ServerMessage.getApplet()) + chart.getDialPlotBGImage().getRelativeUrl();
                }
                if (relative == null) {
                    return;
                }
                chart.getDialPlotBGImage().setAppletDesigner(true);
                chart.setDialPlotBGImage(new URL(relative), chart.getDialPlotBGImage().getRelativeUrl(), chart.getDialPlotBGImage().getOption());
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Failed to set URL for background image", e);
            }
        }
    }

    @Override
    public void dispose() {
        if (!this.isForBean && !this.isFromOrganizer() && this.manager != null) {
            try {
                this.manager.getInitPanel().logoutFromServer();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to log out from server", ex);
            }
        }
        super.dispose();
        if (!this.isForBean && !this.isFromOrganizer() && this.manager != null && ServerMessage.getApplet() == null) {
            System.exit(0);
        }
    }

    public boolean isShowReportDataHasChangedDialog() {
        return this.showReportDataHasChangedDialog;
    }

    public void setShowReportDataHasChangedDialog(boolean showReportDataHasChangedDialog) {
        this.showReportDataHasChangedDialog = showReportDataHasChangedDialog;
    }

    public boolean isSaas() {
        return false;
    }

    public String getAbsoluteDataRegistryPath() {
        return null;
    }

    class RecentFileOpener
    implements ActionListener {
        RecentFileOpener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionevent) {
            if (!(actionevent.getSource() instanceof JMenuItem)) {
                return;
            }
            JMenuItem item = (JMenuItem)actionevent.getSource();
            ChartMain.this.do_openChart(item.getText());
        }
    }
}

