/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.HiLowMap;
import quadbase.chart.LoadChart;
import quadbase.chart.ReadDataFile;
import quadbase.chart.ReloadChart;
import quadbase.chart.designer.ChartPanel;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.CanShowHint;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.PanelAction;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SmartGridLayout;
import quadbase.common.swing.SteppedComboBox;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.internal.TransposeRS;

public class ChartOption
extends PanelAction
implements ItemListener,
ListSelectionListener {
    private static final Logger LOGGER = Logger.getLogger(ChartOption.class.getName());
    private static final String OVERLAY_TEXT = LanguageEncoder.getText("Overlay");
    private static final String LINE_TEXT = LanguageEncoder.getText("Line");
    private static final String STACKAREA_TEXT = LanguageEncoder.getText("Stack Area");
    private static final String COLUMN_TEXT = LanguageEncoder.getText("Column");
    public static final String EMPTY = LanguageEncoder.getText("None");
    private int chartType;
    private int appliedChartType;
    private boolean is2DChart;
    int width = 950;
    int height = 630;
    ChartPanel chartPanel;
    Chart chart;
    private Chart parentChart;
    JButton butcancel;
    JButton butprev;
    JButton butdone;
    JButton fetchButton;
    private CanShowHint statusBar;
    private Dimension defaultDimension = new Dimension(600, 500);
    private Dimension originalDimension = null;
    private int listSize = 130;
    private SteppedComboBox choiceCType;
    private SteppedComboBox choiceSeries;
    private SteppedComboBox choiceCategory;
    private SteppedComboBox choiceSum;
    private SteppedComboBox choiceValue;
    private SteppedComboBox choiceSubValue;
    private SteppedComboBox choiceSubSeries;
    private SteppedComboBox choiceAxisX;
    private SteppedComboBox choiceAxisY;
    private SteppedComboBox choiceAxisZ;
    private SteppedComboBox choiceHigh;
    private SteppedComboBox choiceLow;
    private SteppedComboBox choiceClose;
    private SteppedComboBox choiceOpen;
    private SteppedComboBox choiceCombo;
    private MyComboBoxRenderer myComboBoxRenderer;
    private JList numericList;
    JScrollPane listScroller;
    private JCheckBox multiSeries;
    private JCheckBox multiCategory;
    private JCheckBox multiSum;
    private JCheckBox multiSubSeries;
    private JPanel dataMappingPanel;
    ColData[] originalData;
    ColData[] transposedData;
    boolean[] transposeCol;
    private ColData[] colData;
    private HiLowMap hilow;
    private Vector vparam;
    private String[] name;
    private int[] datamap;
    private int[] dataval;
    private int datadim;
    private int subSeries;
    private int insertLevel;
    private int[] indexSeries;
    private int[] indexCategory;
    private int[] indexSum;
    private int[] indexValue;
    private int[] indexSubValue;
    private int[] indexSubSeries;
    private int[] indexAxisX;
    private int[] indexAxisY;
    private int[] indexAxisZ;
    private int[] indexHigh;
    private int[] indexLow;
    private int[] indexClose;
    private int[] indexOpen;
    private int iSeries = 0;
    private int iCategory = 0;
    private int iSum = 0;
    private int iValue = 0;
    private int iSubValue = 0;
    private int iSubSeries = 0;
    private int iAxisX = 0;
    private int iAxisY = 0;
    private int iAxisZ = 0;
    private int iHigh = 0;
    private int iLow = 0;
    private int iClose = 0;
    private int iOpen = 0;
    private int[] listSelection;
    private String[] comboName = new String[]{LINE_TEXT, STACKAREA_TEXT, OVERLAY_TEXT};
    private String[] comboName2 = new String[]{LINE_TEXT, COLUMN_TEXT, OVERLAY_TEXT};
    private String[] comboName3 = new String[]{LINE_TEXT, COLUMN_TEXT};
    private String[] comboName4 = new String[]{LINE_TEXT, OVERLAY_TEXT};
    private boolean drawPreviousButton = true;
    private boolean drillDown = false;
    public boolean reloadNeeded = false;
    public boolean initializing = false;
    boolean processComboBoxEvent = true;
    boolean disableReloadNeeded = false;
    boolean processListEvent = true;
    boolean fromReportChartCreate = false;
    private boolean stepline2 = false;

    public ChartOption(Vector vparam, boolean drawPreviousButton) {
        this.vparam = vparam;
        this.drawPreviousButton = drawPreviousButton;
    }

    public ChartOption(Chart pChart, Vector vparam, boolean drawPreviousButton, boolean drillDown, int currentLevel) {
        this.parentChart = pChart;
        this.vparam = vparam;
        this.drawPreviousButton = drawPreviousButton;
        this.drillDown = drillDown;
        this.insertLevel = currentLevel;
    }

    public void initialize(int _chartType, boolean _is2DChart, ColData[] _colData) {
        this.initialize(_chartType, _is2DChart, _colData, false);
    }

    public void initialize(int _chartType, boolean _is2DChart, ColData[] _colData, boolean refreshChart) {
        this.colData = _colData;
        this.transposedData = null;
        int len = this.colData.length;
        this.appliedChartType = this.chartType = _chartType;
        this.is2DChart = _is2DChart;
        this.datamap = new int[len];
        this.dataval = new int[3];
        this.iSubSeries = 0;
        this.iSubValue = 0;
        this.iValue = 0;
        this.iSum = 0;
        this.iCategory = 0;
        this.iSeries = 0;
        this.iOpen = 0;
        this.iClose = 0;
        this.iLow = 0;
        this.iHigh = 0;
        this.iAxisZ = 0;
        this.iAxisY = 0;
        this.iAxisX = 0;
        this.butcancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.butprev = new JButton(LanguageEncoder.getText("<< Back"));
        this.butdone = new JButton(LanguageEncoder.getText("Done"));
        this.butcancel.addActionListener(this);
        this.butprev.addActionListener(this);
        this.butdone.addActionListener(this);
        this.hilow = new HiLowMap();
        this.init();
        if (refreshChart) {
            this.refreshChart();
        }
    }

    private void refreshChart() {
        this.updateMappingforChoiceSeriesStateChange();
        this.updateMappingforChoiceCategoryStateChange();
        this.updateMappingForChoiceValueStateChange();
        this.updateMappingForChoiceComboStateChange();
        this.updateMappingForChoiceSumStateChange();
        this.updateMappingForChoiceSubSeriesStateChange();
        this.updateMappingForChoiceSubValueStateChange();
        this.updateMappingForChoiceValueStateChange();
        this.updateMappingForChoiceAxisXStateChange();
        this.updateMappingForChoiceHighStateChange();
        this.updateMappingForChoiceLowStateChange();
        this.updateMappingForChoiceCloseStateChange();
        this.updateMappingForChoiceOpenStateChange();
        this.updateMappingForChoiceAxisYStateChange();
        this.updateMappingForChoiceAxisZStateChange();
        this.reloadNeeded = false;
        if (!this.setChartType(false)) {
            return;
        }
        if (this.chart.showTable()) {
            this.chart.getTable().clear();
            this.chart.getTable().calculateRelativePos(true);
        }
    }

    private void setName() {
        int l = this.colData.length - 1;
        this.name = new String[l];
        for (int i = 0; i < l; ++i) {
            this.name[i] = this.isExisted(this.name, this.colData[i].colName) ? this.colData[i].colName + "(IDX " + i + ")" : this.colData[i].colName;
        }
    }

    private boolean isExisted(String[] list, String val) {
        for (String element : list) {
            if (element == null || !element.equals(val)) continue;
            return true;
        }
        return false;
    }

    public void initialize(int _chartType, boolean _is2DChart, ColData[] _colData, Chart _chart) {
        this.initialize(_chartType, _is2DChart, _colData, _chart, false);
    }

    public void initialize(int _chartType, boolean _is2DChart, ColData[] _colData, Chart _chart, boolean refreshChart) {
        this.chart = _chart;
        this.initialize(_chartType, _is2DChart, _colData, refreshChart);
    }

    private void init() {
        int i;
        this.initializing = true;
        this.reloadNeeded = false;
        String tplName = null;
        Chart newChart = null;
        try {
            if (this.drillDown) {
                int[] map = this.parentChart.getDrillDownMap();
                int dim = 1;
                if (map != null) {
                    dim = this.parentChart.getDrillDownDimension();
                    int cType = this.parentChart.getDrillDownType();
                    this.chart = Chart.createChart(this, cType, this.is2DChart, null, this.colData, null);
                    this.chart.setSubFilesTable(this.parentChart.getSubFilesTable());
                    tplName = this.createDrillTemplateName();
                } else {
                    this.chart = Chart.createChart(this, this.chartType, this.is2DChart, null, this.colData, this.parentChart.usedColumns);
                    this.chart.setSubFilesTable(this.parentChart.getSubFilesTable());
                    dim = this.chart.getDataDimension();
                    map = this.chart.getDataMap();
                }
                int valCol = -1;
                int subvalCol = -1;
                if (this.parentChart.summaryChart) {
                    valCol = this.parentChart.originalMap[this.parentChart.getValueMap()];
                    subvalCol = this.parentChart.getSubValueMap();
                    if (subvalCol >= 0) {
                        subvalCol = this.parentChart.originalMap[subvalCol];
                    }
                } else {
                    valCol = this.parentChart.getValueMap();
                    subvalCol = this.parentChart.getSubValueMap();
                }
                this.chart.setChartType(map, dim, valCol, subvalCol);
                if (tplName != null && this.doesTemplateFileExist(tplName)) {
                    this.chart = newChart = this.applyTemplate(tplName);
                }
                this.chart.setSize(this.parentChart.getSize());
                this.originalDimension = this.chart.getSize();
                this.chartPanel = new ChartPanel(this.chartType, this.is2DChart, this.colData, this.chart, this.defaultDimension);
                this.chart.component = this.chartPanel;
            } else if (this.chartPanel == null) {
                if (this.chart != null) {
                    this.originalDimension = this.chart.getSize();
                }
                this.chartPanel = new ChartPanel(this.chartType, this.is2DChart, this.colData, this.chart, this.defaultDimension);
                this.chart.component = this.chartPanel;
            } else {
                if (this.chart != null) {
                    this.originalDimension = this.chart.getSize();
                }
                this.chartPanel.setChart(Chart.createChart(this.chartPanel, this.chartType, this.is2DChart, this.chart, this.colData, null), this.defaultDimension);
            }
            this.chart = this.chartPanel.chart;
            this.chart.parameters = this.vparam;
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.FINEST, "Chart initilization failed", e);
            throw e;
        }
        this.myComboBoxRenderer = new MyComboBoxRenderer();
        this.choiceCType = this.setupJComboBox(this.choiceCType);
        this.choiceSeries = this.setupJComboBox(this.choiceSeries);
        this.choiceCategory = this.setupJComboBox(this.choiceCategory);
        this.choiceSum = this.setupJComboBox(this.choiceSum);
        this.choiceValue = this.setupJComboBox(this.choiceValue);
        this.choiceSubValue = this.setupJComboBox(this.choiceSubValue);
        this.choiceSubSeries = this.setupJComboBox(this.choiceSubSeries);
        this.choiceAxisX = this.setupJComboBox(this.choiceAxisX);
        this.choiceAxisY = this.setupJComboBox(this.choiceAxisY);
        this.choiceAxisZ = this.setupJComboBox(this.choiceAxisZ);
        this.choiceHigh = this.setupJComboBox(this.choiceHigh);
        this.choiceLow = this.setupJComboBox(this.choiceLow);
        this.choiceClose = this.setupJComboBox(this.choiceClose);
        this.choiceOpen = this.setupJComboBox(this.choiceOpen);
        this.choiceCombo = this.setupJComboBox(this.choiceCombo);
        DefaultListModel<String> model = new DefaultListModel<String>();
        this.numericList = new JList(model);
        if (!this.chart.isTransposed) {
            this.originalData = this.colData;
            this.renameSpecialCols();
            this.setName();
            for (i = 0; i < this.name.length; ++i) {
                if (!DataType.isSuitableForTranspose(this.originalData[i].getDataType())) continue;
                model.addElement(this.name[i]);
            }
        } else {
            this.transposedData = this.colData;
            if (this.originalData == null) {
                this.originalData = ReloadChart.getOriginalColData(this.chart, false, false);
                this.renameSpecialCols();
            } else {
                this.fromReportChartCreate = true;
            }
            this.colData = this.originalData;
            this.setName();
            for (i = 0; i < this.name.length; ++i) {
                int index;
                if (!DataType.isSuitableForTranspose(this.originalData[i].getDataType())) continue;
                model.addElement(this.name[i]);
                if (!this.chart.transposeCol[i] || (index = this.getIndex(this.numericList.getModel(), this.name[i])) < 0) continue;
                this.numericList.addSelectionInterval(index, index);
            }
            this.colData = this.transposedData;
            this.setName();
        }
        int len = this.originalData.length;
        this.indexSeries = new int[len + 1];
        this.indexCategory = new int[len + 1];
        this.indexSum = new int[len + 1];
        this.indexValue = new int[len + 1];
        this.indexSubValue = new int[len + 1];
        this.indexSubSeries = new int[len + 1];
        this.indexAxisX = new int[len + 1];
        this.indexAxisY = new int[len + 1];
        this.indexAxisZ = new int[len + 1];
        this.indexHigh = new int[len + 1];
        this.indexLow = new int[len + 1];
        this.indexClose = new int[len + 1];
        this.indexOpen = new int[len + 1];
        this.numericList.setVisibleRowCount(-1);
        this.listScroller = new JScrollPane(this.numericList);
        this.listScroller.setPreferredSize(new Dimension(this.listSize, 100));
        this.listScroller.setAlignmentX(0.0f);
        this.numericList.addListSelectionListener(this);
        this.multiSeries = new JCheckBox(LanguageEncoder.getText("Multi Selection"));
        this.multiSeries.setVerticalAlignment(1);
        this.multiSeries.addItemListener(this);
        this.multiSeries.setToolTipText("Check the checkbox to enable multiple items selection for Series");
        this.multiCategory = new JCheckBox(LanguageEncoder.getText("Multi Selection"));
        this.multiCategory.setVerticalAlignment(1);
        this.multiCategory.addItemListener(this);
        this.multiCategory.setToolTipText("Check the checkbox to enable multiple items selection for Category");
        this.multiSum = new JCheckBox(LanguageEncoder.getText("Multi Selection"));
        this.multiSum.setVerticalAlignment(1);
        this.multiSum.addItemListener(this);
        this.multiSum.setToolTipText("Check the checkbox to enable multiple items selection for Summerization");
        this.multiSubSeries = new JCheckBox(LanguageEncoder.getText("Multi Selection"));
        this.multiSubSeries.setVerticalAlignment(1);
        this.multiSubSeries.addItemListener(this);
        this.multiSubSeries.setToolTipText("Check the checkbox to enable multiple items selection for 2nd Series");
        if (this.chart.isTransposed) {
            this.findMapping();
            this.enabledisableCheckBox();
            if (this.fromReportChartCreate) {
                this.multiSeries.setSelected(true);
                this.multiCategory.setSelected(false);
                this.multiSum.setSelected(false);
                this.multiSubSeries.setSelected(false);
                this.chart.valueCol = this.transposedData.length - 2;
                this.chart.mDataMap[0] = this.transposedData.length - 3;
                this.chart.mDataLen[0] = this.numericList.getSelectedIndices().length;
            }
        }
        this.choiceCType.addItem(LanguageEncoder.getText("Column"));
        this.choiceCType.addItem(LanguageEncoder.getText("Bar"));
        this.choiceCType.addItem(LanguageEncoder.getText("Line"));
        this.choiceCType.addItem(LanguageEncoder.getText("Stack Column"));
        this.choiceCType.addItem(LanguageEncoder.getText("Stack Bar"));
        this.choiceCType.addItem(LanguageEncoder.getText("Pie"));
        this.choiceCType.addItem(LanguageEncoder.getText("Area"));
        this.choiceCType.addItem(LanguageEncoder.getText("Doughnut"));
        if (this.is2DChart) {
            this.choiceCType.addItem(LanguageEncoder.getText("Overlay"));
            this.choiceCType.addItem(LanguageEncoder.getText("Radar"));
            this.choiceCType.addItem(LanguageEncoder.getText("Dial"));
        }
        String[] comboNames = null;
        if (this.is2DChart) {
            if (this.chart.getChartType() == 4) {
                comboNames = this.comboName;
            } else if (this.chart.isHiLow() && this.chart.chartType != 18) {
                comboNames = this.comboName2;
            } else if (this.chart.isSecOverlayAvailable()) {
                comboNames = this.comboName4;
            }
        } else if (this.chart.isHiLow()) {
            comboNames = this.comboName3;
        }
        if (comboNames != null) {
            for (String element : comboNames) {
                this.choiceCombo.addItem(element);
            }
        }
        this.setComboBoxesValue();
        this.datadim = this.chart.getDataDimension();
        this.subSeries = this.chart.getComboSeries();
        this.datamap[0] = this.chart.mDataMap[0];
        this.dataMappingPanel = new JPanel();
        this.dataMappingPanel.setLayout(new SmartGridLayout(3, 10));
        BorderPanel dpanel = new BorderPanel(LanguageEncoder.getText("Data Mapping"));
        dpanel.setLayout(new BorderLayout());
        dpanel.add("North", this.dataMappingPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        if (this.drawPreviousButton) {
            buttonPanel.add(this.butprev);
        }
        if (this.drillDown) {
            this.choiceValue.setEnabled(false);
            this.choiceSubValue.setEnabled(false);
        }
        buttonPanel.add(this.butcancel);
        buttonPanel.add(this.butdone);
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        if (System.getProperty("java.vendor.url").indexOf("microsoft") >= 0) {
            JPanel tempPanel = new JPanel();
            tempPanel.setLayout(new BorderLayout());
            tempPanel.add("Center", this.chartPanel);
            leftPanel.add("Center", tempPanel);
        } else {
            leftPanel.add("Center", this.chartPanel.getScrollPane());
        }
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add("Center", leftPanel);
        this.add("East", dpanel);
        this.add("South", buttonPanel);
        this.setBackground(Color.lightGray);
        this.refreshDataMappingPanel();
        this.setValues();
        this.validate();
        this.initializing = false;
        if (this.chart.isTransposed && this.fromReportChartCreate) {
            this.chartPanel.setChart(this.chart);
            this.setValues(this.chart.setNewData(this.colData));
            this.enabledisableCheckBox();
        }
    }

    private void renameSpecialCols() {
        int indexColumnLabel = this.getOriginalColDataIndex("ColumnLabel");
        int indexValue = this.getOriginalColDataIndex("Value");
        if (!this.drillDown) {
            if (indexColumnLabel > -1) {
                this.originalData[indexColumnLabel].colName = "reportColumnLabel";
                this.originalData[indexValue].colName = "reportValue";
            } else if (indexValue > -1) {
                this.originalData[indexValue].colName = "reportValue";
            }
        }
    }

    private int getOriginalColDataIndex(String colName) {
        int colData_len = this.originalData.length;
        for (int len = 0; len < colData_len; ++len) {
            if (!this.originalData[len].colName.equals(colName)) continue;
            return len;
        }
        return -1;
    }

    private SteppedComboBox setupJComboBox(SteppedComboBox comboBox) {
        comboBox = new SteppedComboBox();
        comboBox.setRenderer(this.myComboBoxRenderer);
        comboBox.addItemListener(this);
        comboBox.addFocusListener(this);
        return comboBox;
    }

    private void enabledisableCheckBox() {
        if (this.multiSeries.isSelected()) {
            this.multiSeries.setEnabled(true);
            this.multiCategory.setEnabled(false);
            this.multiSum.setEnabled(false);
            this.multiSubSeries.setEnabled(false);
            this.choiceValue.setEnabled(false);
        } else if (this.multiCategory.isSelected()) {
            this.multiCategory.setEnabled(true);
            this.multiSeries.setEnabled(false);
            this.multiSum.setEnabled(false);
            this.multiSubSeries.setEnabled(false);
            this.choiceValue.setEnabled(false);
        } else if (this.multiSum.isSelected()) {
            this.multiSum.setEnabled(true);
            this.multiSeries.setEnabled(false);
            this.multiCategory.setEnabled(false);
            this.multiSubSeries.setEnabled(false);
            this.choiceValue.setEnabled(false);
        } else if (this.multiSubSeries.isSelected()) {
            this.multiSubSeries.setEnabled(true);
            this.multiSeries.setEnabled(false);
            this.multiCategory.setEnabled(false);
            this.multiSum.setEnabled(false);
            this.choiceSubValue.setEnabled(false);
        } else {
            this.multiSeries.setEnabled(true);
            this.multiCategory.setEnabled(true);
            this.multiSum.setEnabled(true);
            this.multiSubSeries.setEnabled(true);
            this.choiceValue.setEnabled(true);
            this.choiceSubValue.setEnabled(true);
        }
    }

    private int getIndex(ListModel model, Object value) {
        if (value == null) {
            return -1;
        }
        if (model instanceof DefaultListModel) {
            return ((DefaultListModel)model).indexOf(value);
        }
        for (int i = 0; i < model.getSize(); ++i) {
            if (!value.equals(model.getElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    private void clearListSelection() {
        this.processListEvent = false;
        this.numericList.clearSelection();
        this.processListEvent = true;
    }

    private void clearComboBoxesValue() {
        this.processComboBoxEvent = false;
        this.choiceSeries.removeAllItems();
        this.choiceSubSeries.removeAllItems();
        this.choiceSum.removeAllItems();
        this.choiceCategory.removeAllItems();
        this.choiceAxisX.removeAllItems();
        this.choiceAxisY.removeAllItems();
        this.choiceAxisZ.removeAllItems();
        this.choiceSubValue.removeAllItems();
        this.choiceHigh.removeAllItems();
        this.choiceLow.removeAllItems();
        this.choiceOpen.removeAllItems();
        this.choiceClose.removeAllItems();
        this.choiceValue.removeAllItems();
        this.iSubSeries = 0;
        this.iSubValue = 0;
        this.iValue = 0;
        this.iSum = 0;
        this.iCategory = 0;
        this.iSeries = 0;
        this.iOpen = 0;
        this.iClose = 0;
        this.iLow = 0;
        this.iHigh = 0;
        this.iAxisZ = 0;
        this.iAxisY = 0;
        this.iAxisX = 0;
    }

    private void setComboBoxesValue() {
        int i;
        this.processComboBoxEvent = false;
        this.choiceSeries.addItem(EMPTY);
        this.indexSeries[this.iSeries++] = -1;
        if (this.chart.chartType != 12 && this.chart.chartType != 13) {
            this.choiceAxisZ.addItem(EMPTY);
            this.indexAxisZ[this.iAxisZ++] = -1;
        }
        this.choiceClose.addItem(EMPTY);
        this.indexClose[this.iClose++] = -1;
        this.choiceOpen.addItem(EMPTY);
        this.indexOpen[this.iOpen++] = -1;
        this.choiceSubValue.addItem(EMPTY);
        this.indexSubValue[this.iSubValue++] = -1;
        for (i = 0; i < this.name.length; ++i) {
            if (this.name[i].equals("ColumnLabel")) continue;
            if (!(DataType.isNumeric(this.colData[i].getDataType()) || this.drillDown && this.parentChart.usedColumns[i])) {
                this.choiceSeries.addItem(this.name[i]);
                this.choiceSubSeries.addItem(this.name[i]);
                this.choiceSum.addItem(this.name[i]);
                this.indexSeries[this.iSeries++] = i;
                this.indexSubSeries[this.iSubSeries++] = i;
                this.indexSum[this.iSum++] = i;
            }
            if (!this.drillDown || !this.parentChart.usedColumns[i]) {
                this.choiceCategory.addItem(this.name[i]);
                this.indexCategory[this.iCategory++] = i;
            }
            if (Chart.isCoordinateType(this.chartType)) {
                if (!DataType.isNumeric(this.colData[i].getDataType()) && (!DataType.isDateTime(this.colData[i].getDataType()) || this.chartType != 2)) continue;
                this.choiceAxisX.addItem(this.name[i]);
                this.choiceAxisY.addItem(this.name[i]);
                this.choiceAxisZ.addItem(this.name[i]);
                this.indexAxisX[this.iAxisX++] = i;
                this.indexAxisY[this.iAxisY++] = i;
                this.indexAxisZ[this.iAxisZ++] = i;
                continue;
            }
            if (!DataType.isNumeric(this.colData[i].getDataType()) && !DataType.isTime(this.colData[i].getDataType()) && (!DataType.isDateTime(this.colData[i].getDataType()) || this.chartType != 18)) continue;
            this.choiceSubValue.addItem(this.name[i]);
            this.indexSubValue[this.iSubValue++] = i;
            if (this.chart.isHiLow()) {
                this.choiceHigh.addItem(this.name[i]);
                this.choiceLow.addItem(this.name[i]);
                this.indexHigh[this.iHigh++] = i;
                this.indexLow[this.iLow++] = i;
                if (this.chartType == 18) continue;
                if (this.chartType == 10) {
                    this.choiceOpen.addItem(this.name[i]);
                    this.indexOpen[this.iOpen++] = i;
                }
                this.choiceClose.addItem(this.name[i]);
                this.indexClose[this.iClose++] = i;
                continue;
            }
            this.choiceValue.addItem(this.name[i]);
            this.indexValue[this.iValue++] = i;
        }
        for (i = 0; i < this.name.length; ++i) {
            if (!DataType.isInt(this.colData[i].getDataType()) && this.colData[i].getDataType() != 5 || this.drillDown && this.parentChart.usedColumns[i]) continue;
            this.choiceSeries.addItem(this.name[i]);
            this.choiceSum.addItem(this.name[i]);
            this.indexSeries[this.iSeries++] = i;
            this.indexSum[this.iSum++] = i;
        }
        int index = this.name.length - 2;
        if (this.multiSeries.isSelected()) {
            this.choiceSeries.addItem("ColumnLabel");
            this.indexSeries[this.iSeries++] = index;
        } else if (this.multiCategory.isSelected()) {
            this.choiceCategory.addItem("ColumnLabel");
            this.indexCategory[this.iCategory++] = index;
        } else if (this.multiSum.isSelected()) {
            this.choiceSum.addItem("ColumnLabel");
            this.indexSum[this.iSum++] = index;
        } else if (this.multiSubSeries.isSelected()) {
            this.choiceSubSeries.addItem("ColumnLabel");
            this.indexSubSeries[this.iSubSeries++] = index;
        }
        this.processComboBoxEvent = true;
        this.setComboBoxSize();
    }

    private void setComboBoxSize() {
        this.setComboBoxSize(this.choiceSeries);
        this.setComboBoxSize(this.choiceSubSeries);
        this.setComboBoxSize(this.choiceSum);
        this.setComboBoxSize(this.choiceCategory);
        this.setComboBoxSize(this.choiceAxisX);
        this.setComboBoxSize(this.choiceAxisY);
        this.setComboBoxSize(this.choiceAxisZ);
        this.setComboBoxSize(this.choiceSubValue);
        this.setComboBoxSize(this.choiceHigh);
        this.setComboBoxSize(this.choiceLow);
        this.setComboBoxSize(this.choiceOpen);
        this.setComboBoxSize(this.choiceClose);
        this.setComboBoxSize(this.choiceValue);
    }

    private void setComboBoxSize(SteppedComboBox comboBox) {
        comboBox.setPreferredSize(null);
        Dimension d = comboBox.getPreferredSize();
        comboBox.setPreferredSize(new Dimension(this.listSize, d.height));
        comboBox.setPopupWidth(d.width);
    }

    private void refreshDataMappingPanel() {
        JLabel label;
        this.dataMappingPanel.removeAll();
        if (this.drillDown) {
            label = new JLabel(LanguageEncoder.getText("Chart Type :"), 2);
            label.setVerticalAlignment(1);
            this.dataMappingPanel.add(label);
            this.dataMappingPanel.add(this.choiceCType);
            this.dataMappingPanel.add(new JLabel(""));
        }
        if (this.drillDown || this.chartType != 12 && this.chartType != 15 && this.chartType != 17 && (this.chartType != 8 || !this.chart.is2DChart)) {
            label = new JLabel(LanguageEncoder.getText("DataSeries :"), 2);
            label.setVerticalAlignment(1);
            this.dataMappingPanel.add(label);
            if (this.drillDown) {
                this.dataMappingPanel.add(this.choiceSeries);
                this.dataMappingPanel.add(new JLabel(""));
            } else {
                if (this.multiSeries.isSelected()) {
                    this.dataMappingPanel.add(this.listScroller);
                } else {
                    this.dataMappingPanel.add(this.choiceSeries);
                }
                this.dataMappingPanel.add(this.multiSeries);
            }
        }
        if (Chart.isCoordinateType(this.chartType)) {
            JLabel label2;
            String xAxisLabel = LanguageEncoder.getText("X axis :");
            String yAxisLabel = LanguageEncoder.getText("Y axis :");
            if (this.chartType == 19) {
                xAxisLabel = LanguageEncoder.getText("Angle :");
                yAxisLabel = LanguageEncoder.getText("Radius :");
            }
            JLabel xLabel = new JLabel(xAxisLabel, 2);
            xLabel.setVerticalAlignment(1);
            this.dataMappingPanel.add(xLabel);
            this.dataMappingPanel.add(this.choiceAxisX);
            this.dataMappingPanel.add(new JLabel(""));
            JLabel yLabel = new JLabel(yAxisLabel, 2);
            yLabel.setVerticalAlignment(1);
            this.dataMappingPanel.add(new JLabel(yAxisLabel, 2));
            this.dataMappingPanel.add(this.choiceAxisY);
            this.dataMappingPanel.add(new JLabel(""));
            if (this.chartType == 13) {
                label2 = new JLabel(LanguageEncoder.getText("bubble size:"), 2);
                label2.setVerticalAlignment(1);
                this.dataMappingPanel.add(label2);
                this.dataMappingPanel.add(this.choiceAxisZ);
                this.dataMappingPanel.add(new JLabel(""));
            }
            if (!this.is2DChart) {
                label2 = new JLabel(LanguageEncoder.getText("Z axis :"), 2);
                label2.setVerticalAlignment(1);
                this.dataMappingPanel.add(label2);
                this.dataMappingPanel.add(this.choiceAxisZ);
                this.dataMappingPanel.add(new JLabel(""));
            }
        } else {
            if (this.chartType == 1 || this.chartType == 5) {
                label = new JLabel(LanguageEncoder.getText("Category (Y) :"), 2);
                label.setVerticalAlignment(1);
                this.dataMappingPanel.add(label);
            } else {
                label = new JLabel(LanguageEncoder.getText("Category (X) :"), 2);
                label.setVerticalAlignment(1);
                this.dataMappingPanel.add(label);
            }
            if (this.drillDown) {
                this.dataMappingPanel.add(this.choiceCategory);
                this.dataMappingPanel.add(new JLabel(""));
            } else {
                if (this.multiCategory.isSelected()) {
                    this.dataMappingPanel.add(this.listScroller);
                } else {
                    this.dataMappingPanel.add(this.choiceCategory);
                }
                this.dataMappingPanel.add(this.multiCategory);
            }
            if (this.drillDown || Chart.stackType(this.chartType)) {
                label = new JLabel(LanguageEncoder.getText("Sum by :"), 2);
                label.setVerticalAlignment(1);
                this.dataMappingPanel.add(label);
                if (this.drillDown) {
                    this.dataMappingPanel.add(this.choiceSum);
                    this.dataMappingPanel.add(new JLabel(""));
                } else {
                    if (this.multiSum.isSelected()) {
                        this.dataMappingPanel.add(this.listScroller);
                    } else {
                        this.dataMappingPanel.add(this.choiceSum);
                    }
                    this.dataMappingPanel.add(this.multiSum);
                }
            }
            if (this.chart.isHiLow()) {
                if (this.chartType == 18) {
                    JLabel startLabel = new JLabel(LanguageEncoder.getText("Start   :"), 2);
                    startLabel.setVerticalAlignment(1);
                    this.dataMappingPanel.add(startLabel);
                    this.dataMappingPanel.add(this.choiceLow);
                    this.dataMappingPanel.add(new JLabel(""));
                    JLabel endLabel = new JLabel(LanguageEncoder.getText("End  :"), 2);
                    endLabel.setVerticalAlignment(1);
                    this.dataMappingPanel.add(endLabel);
                    this.dataMappingPanel.add(this.choiceHigh);
                    this.dataMappingPanel.add(new JLabel(""));
                } else {
                    JLabel highLabel = new JLabel(LanguageEncoder.getText("High  :"), 2);
                    highLabel.setVerticalAlignment(1);
                    this.dataMappingPanel.add(highLabel);
                    this.dataMappingPanel.add(this.choiceHigh);
                    this.dataMappingPanel.add(new JLabel(""));
                    JLabel lowLabel = new JLabel(LanguageEncoder.getText("Low   :"), 2);
                    this.dataMappingPanel.add(lowLabel);
                    this.dataMappingPanel.add(this.choiceLow);
                    this.dataMappingPanel.add(new JLabel(""));
                }
                if (this.chartType == 10) {
                    JLabel openLabel = new JLabel(LanguageEncoder.getText("Open  :"), 2);
                    openLabel.setVerticalAlignment(1);
                    this.dataMappingPanel.add(openLabel);
                    this.dataMappingPanel.add(this.choiceOpen);
                    this.dataMappingPanel.add(new JLabel(""));
                    JLabel closeLabel = new JLabel(LanguageEncoder.getText("Close :"), 2);
                    closeLabel.setVerticalAlignment(1);
                    this.dataMappingPanel.add(closeLabel);
                    this.dataMappingPanel.add(this.choiceClose);
                    this.dataMappingPanel.add(new JLabel(""));
                } else if (this.chartType == 9) {
                    label = new JLabel(LanguageEncoder.getText("Close :"), 2);
                    label.setVerticalAlignment(1);
                    this.dataMappingPanel.add(label);
                    this.dataMappingPanel.add(this.choiceClose);
                    this.dataMappingPanel.add(new JLabel(""));
                }
            } else {
                if (this.chartType == 1 || this.chartType == 5) {
                    label = new JLabel(LanguageEncoder.getText("Value (X) :"), 2);
                    label.setVerticalAlignment(1);
                    this.dataMappingPanel.add(label);
                } else {
                    label = new JLabel(LanguageEncoder.getText("Value (Y) :"), 2);
                    label.setVerticalAlignment(1);
                    this.dataMappingPanel.add(label);
                }
                this.dataMappingPanel.add(this.choiceValue);
                this.dataMappingPanel.add(new JLabel(""));
                if (this.drillDown) {
                    this.choiceValue.setEnabled(false);
                }
            }
        }
        if (!Chart.isCircularChart(this.chartType) && this.chartType != 16 && this.chartType != 17 && this.chartType != 14 && this.chartType != 18 && !Chart.isCoordinateType(this.chartType)) {
            label = new JLabel(LanguageEncoder.getText("2nd Value :"), 2);
            label.setVerticalAlignment(1);
            this.dataMappingPanel.add(label);
            this.dataMappingPanel.add(this.choiceSubValue);
            this.dataMappingPanel.add(new JLabel(""));
            if (this.drillDown) {
                this.choiceValue.setEnabled(false);
            }
        }
        if (!this.drillDown) {
            if (this.chart.is2DChart) {
                if (this.chart.chartType == 4 || this.chart.isSecOverlayAvailable() || this.chart.isHiLow() && this.chart.chartType != 18) {
                    label = new JLabel(LanguageEncoder.getText("Combo:"), 2);
                    label.setVerticalAlignment(1);
                    this.dataMappingPanel.add(label);
                    this.dataMappingPanel.add(this.choiceCombo);
                    this.dataMappingPanel.add(new JLabel(""));
                }
                if (this.chart.isSecOverlayAvailable()) {
                    label = new JLabel(LanguageEncoder.getText("2nd Series :"), 2);
                    label.setVerticalAlignment(1);
                    this.dataMappingPanel.add(label);
                    if (this.drillDown) {
                        this.dataMappingPanel.add(this.choiceSubSeries);
                        this.dataMappingPanel.add(new JLabel(""));
                    } else {
                        if (this.multiSubSeries.isSelected()) {
                            this.dataMappingPanel.add(this.listScroller);
                        } else {
                            this.dataMappingPanel.add(this.choiceSubSeries);
                        }
                        this.dataMappingPanel.add(this.multiSubSeries);
                    }
                }
            } else if (this.chart.isHiLow()) {
                label = new JLabel(LanguageEncoder.getText("Combo:"), 2);
                label.setVerticalAlignment(1);
                this.dataMappingPanel.add(label);
                this.dataMappingPanel.add(this.choiceCombo);
                this.dataMappingPanel.add(new JLabel(""));
            }
        }
        if (this.chart.getChartType() == 2 && this.multiSeries.isSelected() && this.numericList.getSelectedIndex() < 0) {
            int ls = this.numericList.getModel().getSize();
            int[] selected = new int[ls];
            for (int i = 0; i < ls; ++i) {
                selected[i] = i;
            }
            this.numericList.setSelectedIndices(selected);
        }
        this.dataMappingPanel.repaint();
        this.revalidate();
    }

    public void setValues(Chart _chart) {
        this.chart = _chart;
        try {
            if (this.chartPanel == null) {
                this.chartPanel = new ChartPanel(this.chartType, this.is2DChart, this.colData, this.chart, this.defaultDimension);
            } else if (this.drillDown) {
                this.chartPanel.setChart(Chart.createChart(this.chartPanel, this.chartType, this.is2DChart, this.chart, this.colData, this.parentChart.usedColumns));
            } else {
                this.chartPanel.setChart(Chart.createChart(this.chartPanel, this.chartType, this.is2DChart, this.chart, this.colData, null));
            }
            this.chart = this.chartPanel.chart;
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.FINEST, "Failed to set chart panel", e);
            throw e;
        }
        this.setValues();
    }

    private void setValues() {
        boolean isSubValueEmpty;
        int index;
        this.reloadNeeded = false;
        this.datadim = this.chart.getDataDimension();
        this.datamap[0] = this.chart.mDataMap[0];
        this.subSeries = this.chart.getComboSeries();
        if (this.drillDown) {
            this.choiceCType.setSelectedIndex(this.getChartTypeIndex(this.chart.chartType));
        }
        if (!Chart.isCircularChart(this.chartType) && this.chartType != 17 && this.chartType != 16) {
            if (this.chart.getSubValueMap() >= 0) {
                index = this.getIndexOf(this.indexSubValue, this.chart.getSubValueMap());
                if (index < this.choiceSubValue.getItemCount()) {
                    this.choiceSubValue.setSelectedIndex(index);
                }
            } else {
                this.choiceSubValue.setSelectedItem(EMPTY);
            }
        }
        if (!this.drillDown && this.chart.isSecOverlayAvailable()) {
            if (this.chart.getComboSeries() >= 0) {
                index = this.getIndexOf(this.indexSubSeries, this.chart.getComboSeries());
                if (index < this.choiceSubSeries.getItemCount()) {
                    this.choiceSubSeries.setSelectedIndex(index);
                }
            } else {
                this.choiceSubSeries.setSelectedItem(EMPTY);
            }
        }
        if (Chart.stackType(this.chartType)) {
            this.datamap[1] = this.chart.mDataMap[1];
            if (this.datadim == 2) {
                int idx2;
                this.choiceSeries.setSelectedItem(EMPTY);
                index = this.getIndexOf(this.indexCategory, this.datamap[0]);
                if (index < this.choiceCategory.getItemCount()) {
                    this.choiceCategory.setSelectedIndex(index);
                }
                if ((idx2 = this.getIndexOf(this.indexSum, this.datamap[1])) < this.choiceSum.getItemCount()) {
                    this.choiceSum.setSelectedIndex(idx2);
                }
                this.choiceCombo.setSelectedItem(this.comboName[this.chart.getComboType() == 3 ? 2 : this.chart.getComboType()]);
            } else {
                this.datamap[2] = this.chart.mDataMap[2];
                index = this.getIndexOf(this.indexSeries, this.datamap[0]);
                if (index < this.choiceSeries.getItemCount()) {
                    this.choiceSeries.setSelectedIndex(index);
                }
                if ((index = this.getIndexOf(this.indexCategory, this.datamap[1])) < this.choiceCategory.getItemCount()) {
                    this.choiceCategory.setSelectedIndex(index);
                }
                if ((index = this.getIndexOf(this.indexSum, this.datamap[2])) < this.choiceSum.getItemCount()) {
                    this.choiceSum.setSelectedIndex(index);
                }
            }
            if (this.chart.getChartType() == 4) {
                this.choiceCombo.setSelectedItem(this.comboName[this.chart.getComboType() == 3 ? 2 : this.chart.getComboType()]);
            } else if (this.chart.isSecOverlayAvailable()) {
                this.choiceCombo.setSelectedItem(this.comboName4[this.chart.getComboType() == 3 ? 1 : 0]);
            }
        } else {
            if (this.datadim == 2) {
                this.datamap[1] = this.chart.mDataMap[1];
                index = this.getIndexOf(this.indexSeries, this.datamap[0]);
                if (index < this.choiceSeries.getItemCount()) {
                    this.choiceSeries.setSelectedIndex(index);
                }
                if (!Chart.isCoordinateType(this.chartType) && (index = this.getIndexOf(this.indexCategory, this.datamap[1])) < this.choiceCategory.getItemCount()) {
                    this.choiceCategory.setSelectedIndex(index);
                }
            } else {
                this.choiceSeries.setSelectedItem(EMPTY);
                if (!Chart.isCoordinateType(this.chartType) && (index = this.getIndexOf(this.indexCategory, this.datamap[0])) < this.choiceCategory.getItemCount()) {
                    this.choiceCategory.setSelectedIndex(index);
                }
            }
            if (this.chart.isSecOverlayAvailable() && !this.chart.isHiLow()) {
                this.choiceCombo.setSelectedItem(this.comboName4[this.chart.getComboType() == 3 ? 1 : 0]);
            }
        }
        if (Chart.isCoordinateType(this.chartType)) {
            this.dataval[0] = this.chart.coordCol[0];
            this.dataval[1] = this.chart.coordCol[1];
            index = this.getIndexOf(this.indexAxisX, this.dataval[0]);
            if (index < this.choiceAxisX.getItemCount()) {
                this.choiceAxisX.setSelectedIndex(index);
            }
            if ((index = this.getIndexOf(this.indexAxisY, this.dataval[1])) < this.choiceAxisY.getItemCount()) {
                this.choiceAxisY.setSelectedIndex(index);
            }
            if (!this.is2DChart || this.chartType == 13) {
                if (this.chart.bcoordCol[2]) {
                    this.dataval[2] = this.chart.coordCol[2];
                    index = this.getIndexOf(this.indexAxisZ, this.dataval[2]);
                    if (index < this.choiceAxisZ.getItemCount()) {
                        this.choiceAxisZ.setSelectedIndex(this.getIndexOf(this.indexAxisZ, this.dataval[2]));
                    }
                } else {
                    this.dataval[2] = -1;
                    index = this.getIndexOf(this.indexAxisZ, this.dataval[0]);
                    if (index < this.choiceAxisZ.getItemCount()) {
                        this.choiceAxisZ.setSelectedIndex(index);
                    }
                }
            }
        } else if (this.chart.isHiLow()) {
            this.hilow.copy(this.chart.hilowCol);
            index = this.getIndexOf(this.indexHigh, this.hilow.hi);
            if (index < this.choiceHigh.getItemCount()) {
                this.choiceHigh.setSelectedIndex(index);
            }
            if ((index = this.getIndexOf(this.indexLow, this.hilow.low)) < this.choiceLow.getItemCount()) {
                this.choiceLow.setSelectedIndex(index);
            }
            if (this.hilow.close >= 0) {
                index = this.getIndexOf(this.indexClose, this.hilow.close);
                if (index < this.choiceClose.getItemCount()) {
                    this.choiceClose.setSelectedIndex(index);
                }
            } else {
                this.choiceClose.setSelectedItem(EMPTY);
            }
            if (this.is2DChart) {
                this.choiceCombo.setSelectedItem(this.comboName2[this.chart.getComboType() == 0 ? 0 : (this.chart.getComboType() == 3 ? 2 : 1)]);
            } else {
                this.choiceCombo.setSelectedItem(this.comboName3[this.chart.getComboType() == 0 ? 0 : 1]);
            }
            if (this.chartType == 10) {
                if (this.hilow.open >= 0) {
                    index = this.getIndexOf(this.indexOpen, this.hilow.open);
                    if (index < this.choiceOpen.getItemCount()) {
                        this.choiceOpen.setSelectedIndex(index);
                    }
                } else {
                    this.choiceOpen.setSelectedItem(EMPTY);
                }
            }
        } else {
            this.dataval[0] = this.chart.valueCol;
            index = this.getIndexOf(this.indexValue, this.dataval[0]);
            if (index < this.choiceValue.getItemCount()) {
                this.choiceValue.setSelectedIndex(index);
            }
        }
        if (this.chart.getSubValueMap() >= 0) {
            index = this.getIndexOf(this.indexSubValue, this.chart.getSubValueMap());
            if (index < this.choiceSubValue.getItemCount()) {
                this.choiceSubValue.setSelectedIndex(index);
            }
        } else {
            this.choiceSubValue.setSelectedItem(EMPTY);
        }
        if (this.drillDown) {
            this.choiceValue.setEnabled(false);
            this.choiceSubValue.setEnabled(false);
            this.enableDisableChoiceBoxes();
        }
        this.choiceCombo.setEnabled(!(isSubValueEmpty = this.choiceSubValue.getSelectedItem().equals(EMPTY)));
        this.choiceSubSeries.setEnabled(this.chart.getComboType() == 3);
        if (!(this.multiSeries.isSelected() || this.multiCategory.isSelected() || this.multiSum.isSelected())) {
            this.multiSubSeries.setEnabled(this.chart.getComboType() == 3);
        } else {
            this.multiSubSeries.setEnabled(false);
        }
        this.setComboBoxToolTips();
    }

    private void setComboBoxToolTips() {
        if (this.choiceCType.getItemCount() > 0) {
            this.choiceCType.setToolTipText(this.choiceCType.getSelectedItem().toString());
        }
        if (this.choiceSeries.getItemCount() > 0) {
            this.choiceSeries.setToolTipText(this.choiceSeries.getSelectedItem().toString());
        }
        if (this.choiceCategory.getItemCount() > 0) {
            this.choiceCategory.setToolTipText(this.choiceCategory.getSelectedItem().toString());
        }
        if (this.choiceSum.getItemCount() > 0) {
            this.choiceSum.setToolTipText(this.choiceSum.getSelectedItem().toString());
        }
        if (this.choiceValue.getItemCount() > 0) {
            this.choiceValue.setToolTipText(this.choiceValue.getSelectedItem().toString());
        }
        if (this.choiceSubValue.getItemCount() > 0) {
            this.choiceSubValue.setToolTipText(this.choiceSubValue.getSelectedItem().toString());
        }
        if (this.choiceSubSeries.getItemCount() > 0) {
            this.choiceSubSeries.setToolTipText(this.choiceSubSeries.getSelectedItem().toString());
        }
        if (this.choiceAxisX.getItemCount() > 0) {
            this.choiceAxisX.setToolTipText(this.choiceAxisX.getSelectedItem().toString());
        }
        if (this.choiceAxisY.getItemCount() > 0) {
            this.choiceAxisY.setToolTipText(this.choiceAxisY.getSelectedItem().toString());
        }
        if (this.choiceAxisZ.getItemCount() > 0) {
            this.choiceAxisZ.setToolTipText(this.choiceAxisZ.getSelectedItem().toString());
        }
        if (this.choiceHigh.getItemCount() > 0) {
            this.choiceHigh.setToolTipText(this.choiceHigh.getSelectedItem().toString());
        }
        if (this.choiceLow.getItemCount() > 0) {
            this.choiceLow.setToolTipText(this.choiceLow.getSelectedItem().toString());
        }
        if (this.choiceClose.getItemCount() > 0) {
            this.choiceClose.setToolTipText(this.choiceClose.getSelectedItem().toString());
        }
        if (this.choiceOpen.getItemCount() > 0) {
            this.choiceOpen.setToolTipText(this.choiceOpen.getSelectedItem().toString());
        }
        if (this.choiceCombo.getItemCount() > 0) {
            this.choiceCombo.setToolTipText(this.choiceCombo.getSelectedItem().toString());
        }
    }

    private void setOriginalDefaultValue() {
        this.processComboBoxEvent = false;
        this.disableReloadNeeded = true;
        if (this.choiceSeries.getItemCount() > 0) {
            this.choiceSeries.setSelectedIndex(0);
            this.updateMappingforChoiceSeriesStateChange();
        }
        if (this.choiceSubSeries.getItemCount() > 0) {
            this.choiceSubSeries.setSelectedIndex(0);
            this.updateMappingForChoiceSubSeriesStateChange();
        }
        if (this.choiceSum.getItemCount() > 0) {
            this.choiceSum.setSelectedIndex(0);
            this.updateMappingForChoiceSumStateChange();
        }
        if (this.choiceCategory.getItemCount() > 0) {
            this.choiceCategory.setSelectedIndex(0);
            this.updateMappingforChoiceCategoryStateChange();
        }
        if (this.choiceAxisX.getItemCount() > 0) {
            this.choiceAxisX.setSelectedIndex(0);
            this.updateMappingForChoiceAxisXStateChange();
        }
        if (this.choiceAxisY.getItemCount() > 0) {
            this.choiceAxisY.setSelectedIndex(0);
            this.updateMappingForChoiceAxisYStateChange();
        }
        if (this.choiceAxisZ.getItemCount() > 0) {
            this.choiceAxisZ.setSelectedIndex(0);
            this.updateMappingForChoiceAxisZStateChange();
        }
        if (this.choiceSubValue.getItemCount() > 0) {
            this.choiceSubValue.setSelectedIndex(0);
            this.updateMappingForChoiceSubValueStateChange();
        }
        if (this.choiceHigh.getItemCount() > 0) {
            this.choiceHigh.setSelectedIndex(0);
            this.updateMappingForChoiceHighStateChange();
        }
        if (this.choiceLow.getItemCount() > 0) {
            this.choiceLow.setSelectedIndex(0);
            this.updateMappingForChoiceLowStateChange();
        }
        if (this.choiceOpen.getItemCount() > 0) {
            this.choiceOpen.setSelectedIndex(0);
            this.updateMappingForChoiceOpenStateChange();
        }
        if (this.choiceClose.getItemCount() > 0) {
            this.choiceClose.setSelectedIndex(0);
            this.updateMappingForChoiceCloseStateChange();
        }
        if (this.choiceValue.getItemCount() > 0) {
            this.choiceValue.setSelectedIndex(0);
            this.updateMappingForChoiceValueStateChange();
        }
        if (this.choiceCombo.getItemCount() > 0) {
            this.choiceCombo.setSelectedIndex(0);
            this.updateMappingForChoiceComboStateChange();
        }
        this.disableReloadNeeded = false;
        this.processComboBoxEvent = true;
    }

    private void updateDataMapping() {
        this.chart.mDataMap[0] = this.datamap[0];
        this.chart.comboSeries = this.subSeries;
        if (Chart.stackType(this.chartType)) {
            this.chart.mDataMap[1] = this.datamap[1];
            if (this.datadim != 2) {
                this.chart.mDataMap[2] = this.datamap[2];
            }
        } else if (this.datadim == 2) {
            this.chart.mDataMap[1] = this.datamap[1];
        }
        if (Chart.isCoordinateType(this.chartType)) {
            this.chart.coordCol[0] = this.dataval[0];
            this.chart.coordCol[1] = this.dataval[1];
            if (!this.is2DChart || this.chartType == 13) {
                if (this.chart.bcoordCol[2]) {
                    this.chart.coordCol[2] = this.dataval[2];
                } else {
                    this.dataval[2] = -1;
                    this.chart.coordCol[2] = -1;
                }
            }
        } else if (!this.chart.isHiLow()) {
            this.chart.valueCol = this.dataval[0];
        }
    }

    private void findMapping() {
        this.datadim = this.chart.getDataDimension();
        this.datamap[0] = this.chart.mDataMap[0];
        this.subSeries = this.chart.getComboSeries();
        if (!this.drillDown && this.chart.isSecOverlayAvailable() && this.chart.getComboSeries() >= 0 && this.chart.getComboSeries() == this.colData.length - 3) {
            this.multiSubSeries.setSelected(true);
        }
        if (Chart.stackType(this.chartType)) {
            this.datamap[1] = this.chart.mDataMap[1];
            if (this.datadim == 2) {
                if (this.datamap[0] == this.colData.length - 3) {
                    this.multiCategory.setSelected(true);
                } else if (this.datamap[1] == this.colData.length - 3) {
                    this.multiSum.setSelected(true);
                }
            } else {
                this.datamap[2] = this.chart.mDataMap[2];
                if (this.datamap[0] == this.colData.length - 3) {
                    this.multiSeries.setSelected(true);
                } else if (this.datamap[1] == this.colData.length - 3) {
                    this.multiCategory.setSelected(true);
                } else if (this.datamap[2] == this.colData.length - 3) {
                    this.multiSum.setSelected(true);
                }
            }
        } else if (this.datadim == 2) {
            this.datamap[1] = this.chart.mDataMap[1];
            if (this.datamap[0] == this.colData.length - 3) {
                this.multiSeries.setSelected(true);
            }
            if (!Chart.isCoordinateType(this.chartType) && this.datamap[1] == this.colData.length - 3) {
                this.multiCategory.setSelected(true);
            }
        } else if (!Chart.isCoordinateType(this.chartType) && this.datamap[0] == this.colData.length - 3) {
            this.multiCategory.setSelected(true);
        }
    }

    public boolean chartRepaint(boolean recompute) {
        this.chartPanel.recompute = recompute;
        this.chartPanel.paint(this.chartPanel.getGraphics());
        this.repaint();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.initializing) {
            return;
        }
        Object target = e.getSource();
        if (target == this.butdone) {
            if (!this.isValidComboChartType()) {
                return;
            }
            if (this.drillDown && this.parentChart != null) {
                this.parentChart.fillUsedColumns(this.chart.getDataMap(), this.chart.getDataDimension());
                this.parentChart.insertDrillDownAt(this.insertLevel, this.appliedChartType, this.chart.getDataMap(), this.chart.getDataDimension(), this.is2DChart);
            }
            if (this.originalDimension != null) {
                this.chart.setSize(this.originalDimension);
            }
            this.fireEvent(this.butdone, 1);
        }
        if (target == this.butcancel || target == this.butprev) {
            try {
                this.chartRepaint(true);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to repaint the chart", ex);
            }
            this.fireEvent((Component)target, 1);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        boolean adjust = e.getValueIsAdjusting();
        if (!adjust && this.processListEvent) {
            JList list = (JList)e.getSource();
            this.valueChanged(list);
        }
    }

    private int getColDataIndex(String colName) {
        int colData_len = this.colData.length;
        for (int len = 0; len < colData_len; ++len) {
            if (!this.colData[len].colName.equals(colName)) continue;
            return len;
        }
        return -1;
    }

    public void valueChanged(JList list) {
        this.transposeCol = new boolean[this.originalData.length];
        block4: for (int element : this.listSelection = list.getSelectedIndices()) {
            int len = this.originalData.length;
            int l = len;
            for (int j = 0; j < l; ++j) {
                if (!this.originalData[j].colName.equals(list.getModel().getElementAt(element))) continue;
                this.transposeCol[j] = true;
                continue block4;
            }
        }
        ArrayList<String> datamapString = new ArrayList<String>();
        int l = this.chart.mDataMap.length;
        for (int i = 0; i < l; ++i) {
            if (this.chart.mDataMap[i] >= this.colData.length - 1) {
                this.chart.mDataMap[i] = this.colData.length - 2;
            }
            datamapString.add(this.colData[this.chart.mDataMap[i]].colName);
        }
        String subvalcolString = this.chart.subvalueCol >= 0 ? this.colData[this.chart.subvalueCol].colName : null;
        String valcolString = this.colData[this.chart.valueCol].colName;
        String subseriesString = this.chart.getComboSeries() >= 0 ? this.colData[this.chart.getComboSeries()].colName : null;
        String[] datavalString = new String[3];
        for (int i = 0; i < 3; ++i) {
            datavalString[i] = this.dataval[i] >= 0 ? this.colData[this.dataval[i]].colName : null;
        }
        try {
            this.transposedData = ColData.getColData(TransposeRS.doTranspose(this.originalData, this.transposeCol));
            this.colData = this.transposedData;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to transpose data", ex);
            this.transposeCol = null;
        }
        this.setName();
        this.clearComboBoxesValue();
        this.setComboBoxesValue();
        this.disableReloadNeeded = false;
        try {
            int i;
            this.updateDataMapping();
            this.chart.setTransposed(true, this.transposeCol);
            int theIndex = 0;
            int ll = this.chart.mDataMap.length;
            for (i = 0; i < ll; ++i) {
                theIndex = this.getColDataIndex((String)datamapString.get(i));
                this.chart.mDataMap[i] = theIndex >= 0 ? theIndex : 0;
            }
            this.chart.subvalueCol = subvalcolString != null ? this.getColDataIndex(subvalcolString) : -1;
            this.chart.valueCol = this.getColDataIndex(valcolString);
            if (subseriesString != null) {
                this.chart.setComboSeries(this.getColDataIndex(subseriesString));
            } else {
                this.chart.setComboSeries(-1);
            }
            if (Chart.isCoordinateType(this.chartType)) {
                for (i = 0; i < 3; ++i) {
                    theIndex = this.getColDataIndex(datavalString[i]);
                    this.dataval[i] = theIndex >= 0 ? theIndex : this.colData.length - 2;
                }
                this.chart.coordCol[0] = this.dataval[0];
                this.chart.coordCol[1] = this.dataval[1];
            }
            int length = this.colData.length;
            if ((this.multiSeries.isSelected() || this.multiCategory.isSelected() || this.multiSum.isSelected()) && this.choiceSubValue.getItemCount() > 0) {
                this.chart.valueCol = length - 2;
                this.chart.subvalueCol = this.indexSubValue[0];
            }
            if (this.multiSubSeries.isSelected() && this.choiceValue.getItemCount() > 0) {
                this.chart.subvalueCol = length - 2;
                this.chart.valueCol = this.indexValue[0];
            }
            int d = this.chart.mDataMap.length;
            for (int i2 = 0; i2 < d; ++i2) {
                if (this.chart.mDataMap[i2] <= this.colData.length - 1) continue;
                this.chart.mDataMap[i2] = this.colData.length - 3;
            }
            this.chart = this.chart.setNewData(this.colData);
            this.setValues(this.chart);
            d = this.chart.mDataMap.length;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Error setting chart values", ex);
        }
        if (this.multiSeries.isSelected()) {
            this.choiceSeries.getModel().setSelectedItem("ColumnLabel");
            if (this.chart.isHiLow()) {
                this.choiceLow.getModel().setSelectedItem("Value");
            } else if (this.chartType == 2) {
                this.choiceAxisY.getModel().setSelectedItem("Value");
            } else {
                this.choiceValue.getModel().setSelectedItem("Value");
                this.choiceValue.setEnabled(false);
            }
        } else if (this.multiCategory.isSelected()) {
            this.choiceCategory.getModel().setSelectedItem("ColumnLabel");
            if (!this.chart.isHiLow()) {
                this.choiceValue.getModel().setSelectedItem("Value");
                this.choiceValue.setEnabled(false);
            } else {
                this.choiceLow.getModel().setSelectedItem("Value");
            }
        } else if (this.multiSum.isSelected()) {
            this.choiceSum.getModel().setSelectedItem("ColumnLabel");
            this.choiceValue.getModel().setSelectedItem("Value");
            this.choiceValue.setEnabled(false);
        } else {
            this.choiceSubSeries.getModel().setSelectedItem("ColumnLabel");
            this.choiceSubValue.getModel().setSelectedItem("Value");
            this.choiceSubValue.setEnabled(false);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.initializing) {
            return;
        }
        Object target = e.getSource();
        if (e.getStateChange() == 2) {
            if (target == this.multiSeries) {
                this.updateAfterCheckBoxDeSel();
            } else if (target == this.multiCategory) {
                this.updateAfterCheckBoxDeSel();
            } else if (target == this.multiSum) {
                this.updateAfterCheckBoxDeSel();
            } else if (target == this.multiSubSeries) {
                this.choiceSubSeries.setEnabled(false);
                this.multiSubSeries.setEnabled(false);
                this.updateAfterCheckBoxDeSel();
            }
        } else if (e.getStateChange() == 1 && this.processComboBoxEvent) {
            this.setComboBoxToolTips();
            if (target == this.multiSeries) {
                this.enabledisableCheckBox();
                this.refreshDataMappingPanel();
            } else if (target == this.multiCategory) {
                this.enabledisableCheckBox();
                this.refreshDataMappingPanel();
            } else if (target == this.multiSum) {
                this.enabledisableCheckBox();
                this.refreshDataMappingPanel();
            } else if (target == this.multiSubSeries) {
                this.enabledisableCheckBox();
                this.refreshDataMappingPanel();
            } else if (target == this.choiceCType) {
                this.updateMappingforChoiceCTypeStateChange();
            } else if (target == this.choiceSeries) {
                this.updateMappingforChoiceSeriesStateChange();
            } else if (target == this.choiceCategory) {
                this.updateMappingforChoiceCategoryStateChange();
            } else if (target == this.choiceCombo) {
                this.updateMappingForChoiceComboStateChange();
            } else if (target == this.choiceSum) {
                this.updateMappingForChoiceSumStateChange();
            } else if (target == this.choiceSubSeries) {
                this.updateMappingForChoiceSubSeriesStateChange();
            } else if (target == this.choiceSubValue) {
                this.updateMappingForChoiceSubValueStateChange();
            } else if (target == this.choiceValue) {
                this.updateMappingForChoiceValueStateChange();
            } else if (target == this.choiceAxisX) {
                this.updateMappingForChoiceAxisXStateChange();
            } else if (target == this.choiceHigh) {
                this.updateMappingForChoiceHighStateChange();
            } else if (target == this.choiceLow) {
                this.updateMappingForChoiceLowStateChange();
            } else if (target == this.choiceClose) {
                this.updateMappingForChoiceCloseStateChange();
            } else if (target == this.choiceOpen) {
                this.updateMappingForChoiceOpenStateChange();
            } else if (target == this.choiceAxisY) {
                this.updateMappingForChoiceAxisYStateChange();
            } else if (target == this.choiceAxisZ) {
                this.updateMappingForChoiceAxisZStateChange();
            }
            if (this.reloadNeeded) {
                this.reloadChart();
            }
        }
    }

    private void reloadChart() {
        try {
            this.reloadNeeded = false;
            if (!this.setChartType(false)) {
                return;
            }
            if (this.chart.showTable()) {
                this.chart.getTable().clear();
                this.chart.getTable().calculateRelativePos(true);
            }
            this.chartRepaint(false);
            this.appliedChartType = this.chartType;
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Failed to reload the chart", ex);
            ChartPanel.printException = false;
            String message = LanguageEncoder.getText("The new data mapping cannot plot a") + " " + Chart.TypeName(this.chart.chartType, this.chart.is2DChart);
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(message);
            ChartPanel.printException = true;
        }
    }

    private void updateMappingforChoiceCTypeStateChange() {
        String arg = this.choiceCType.getSelectedItem().toString();
        int newChartType = this.getNewChartType(arg);
        if (newChartType == this.chartType) {
            return;
        }
        if (this.parentChart.countUnusedCol != -1 && this.parentChart.countUnusedCol < 2 && Chart.stackType(newChartType)) {
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(LanguageEncoder.getText("Not enough information to plot!"));
            this.choiceCType.setSelectedIndex(this.getChartTypeIndex(this.chartType));
            return;
        }
        try {
            this.chart = Chart.createChart(this.chartPanel, newChartType, this.is2DChart, this.chart, null, this.parentChart.usedColumns);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINE, "Error changing chart type", ex);
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Warning")).show(ex.toString());
            return;
        }
        this.appliedChartType = this.chartType = newChartType;
        this.setValues();
        this.enabledisableCheckBox();
        this.enableDisableChoiceBoxes();
        this.chartPanel.setChart(this.chart);
        this.chartRepaint(true);
    }

    private void updateMappingforChoiceSeriesStateChange() {
        String arg = this.choiceSeries.getSelectedItem().toString();
        int selIndex = this.choiceSeries.getSelectedIndex();
        if (arg.equals(EMPTY)) {
            if (Chart.stackType(this.chartType)) {
                if (this.datadim == 2) {
                    return;
                }
                this.datadim = 2;
                this.datamap[0] = this.datamap[1];
                this.datamap[1] = this.datamap[2];
            } else {
                if (this.datadim == 1) {
                    return;
                }
                this.datadim = 1;
                this.datamap[0] = this.datamap[1];
            }
            if (this.statusBar != null) {
                this.statusBar.showHint("None");
            }
        } else {
            int newcol;
            if (Chart.stackType(this.chartType)) {
                if (this.is2DChart && this.chartType == 4) {
                    this.choiceCombo.setSelectedIndex(0);
                    this.chart.setComboType(0);
                }
                if (this.datadim == 2) {
                    this.datadim = 3;
                    this.datamap[2] = this.datamap[1];
                    this.datamap[1] = this.datamap[0];
                    newcol = this.indexSeries[selIndex];
                } else {
                    newcol = this.indexSeries[selIndex];
                    if (newcol == this.datamap[0]) {
                        return;
                    }
                }
                this.datamap[0] = newcol;
            } else {
                if (this.datadim == 1) {
                    this.datadim = 2;
                    this.datamap[1] = this.datamap[0];
                    newcol = this.indexSeries[selIndex];
                } else {
                    newcol = this.indexSeries[selIndex];
                    if (newcol == this.datamap[0]) {
                        return;
                    }
                }
                this.datamap[0] = newcol;
            }
            if (this.statusBar != null && newcol >= 0) {
                this.statusBar.showHint(this.name[newcol]);
            }
        }
        if (!this.disableReloadNeeded) {
            this.reloadNeeded = true;
        }
    }

    private void updateMappingforChoiceCategoryStateChange() {
        int newcol = this.indexCategory[this.choiceCategory.getSelectedIndex()];
        if (Chart.stackType(this.chartType)) {
            if (this.datadim == 2) {
                if (newcol == this.datamap[0]) {
                    return;
                }
                this.datamap[0] = newcol;
            } else {
                if (newcol == this.datamap[1]) {
                    return;
                }
                this.datamap[1] = newcol;
            }
        } else if (this.datadim == 1) {
            if (newcol == this.datamap[0]) {
                return;
            }
            this.datamap[0] = newcol;
        } else {
            if (newcol == this.datamap[1]) {
                return;
            }
            this.datamap[1] = newcol;
        }
        if (this.statusBar != null) {
            this.statusBar.showHint(this.name[newcol]);
        }
        if (!this.disableReloadNeeded) {
            this.reloadNeeded = true;
        }
    }

    private void updateMappingForChoiceComboStateChange() {
        if (this.is2DChart) {
            if (this.chartType == 4) {
                if (this.datadim == 3 && this.choiceCombo.getSelectedIndex() == 1) {
                    this.choiceCombo.setSelectedIndex(0);
                    this.chart.setComboType(0);
                } else {
                    this.chart.setComboType(this.choiceCombo.getSelectedIndex() == 2 ? 3 : this.choiceCombo.getSelectedIndex());
                }
            } else if (this.chart.isHiLow() && this.chart.chartType != 18) {
                this.chart.setComboType(this.choiceCombo.getSelectedIndex() == 1 ? 2 : (this.choiceCombo.getSelectedIndex() == 2 ? 3 : 0));
            } else if (this.chart.isSecOverlayAvailable()) {
                this.chart.setComboType(this.choiceCombo.getSelectedIndex() == 1 ? 3 : 0);
            }
        } else if (this.chart.isHiLow() && !this.is2DChart) {
            this.chart.setComboType(this.choiceCombo.getSelectedIndex() == 1 ? 2 : 0);
            this.chart.newSurface();
        }
        boolean enableSubSeries = this.chart.getComboType() == 3;
        this.choiceSubSeries.setEnabled(enableSubSeries);
        if (!enableSubSeries) {
            this.multiSubSeries.setEnabled(enableSubSeries);
        } else {
            this.enabledisableCheckBox();
        }
        if (this.chart.chartType != 3 && this.chart.getComboType() != 0) {
            this.stepline2 = this.chart.getStepLineState2();
            this.chart.setStepLineState(false);
            this.chart.setStepLineState2(false);
        } else if (this.chart.getComboType() == 0) {
            this.chart.setStepLineState(this.stepline2);
            this.chart.setStepLineState2(this.stepline2);
        }
        if (!this.disableReloadNeeded) {
            this.reloadNeeded = true;
        }
    }

    private void updateMappingForChoiceSumStateChange() {
        int index = this.choiceSum.getSelectedIndex();
        int newcol = 0;
        if (index >= 0) {
            newcol = this.indexSum[index];
        }
        if (this.datadim == 2) {
            if (newcol == this.datamap[1]) {
                return;
            }
            this.datamap[1] = newcol;
        } else {
            if (newcol == this.datamap[2]) {
                return;
            }
            this.datamap[2] = newcol;
        }
        if (this.statusBar != null && newcol >= 0) {
            this.statusBar.showHint(this.name[newcol]);
        }
        if (!this.disableReloadNeeded) {
            this.reloadNeeded = true;
        }
    }

    private void updateMappingForChoiceSubSeriesStateChange() {
        int index = this.choiceSubSeries.getSelectedIndex();
        int newSubSeries = -1;
        if (index >= 0) {
            newSubSeries = this.indexSubSeries[index];
            if (newSubSeries == this.chart.getComboSeries()) {
                return;
            }
            this.subSeries = newSubSeries;
        }
        if (this.statusBar != null && newSubSeries > -1) {
            this.statusBar.showHint(this.name[newSubSeries]);
        }
        if (!this.disableReloadNeeded) {
            this.reloadNeeded = true;
        }
    }

    private void updateMappingForChoiceSubValueStateChange() {
        boolean subValueEnabled = !this.choiceSubValue.getSelectedItem().equals(EMPTY);
        this.choiceCombo.setEnabled(subValueEnabled);
        if (this.choiceCombo.getSelectedItem() != null) {
            boolean enableSubSeries = subValueEnabled && this.choiceCombo.getSelectedItem().equals(OVERLAY_TEXT);
            this.choiceSubSeries.setEnabled(enableSubSeries);
            if (!enableSubSeries) {
                this.multiSubSeries.setEnabled(enableSubSeries);
            } else {
                this.enabledisableCheckBox();
            }
        }
        if (this.statusBar != null && this.getsubvalue() > -1) {
            this.statusBar.showHint(this.name[this.getsubvalue()]);
        }
        if (!this.disableReloadNeeded) {
            this.reloadNeeded = true;
        }
    }

    private void updateMappingForChoiceValueStateChange() {
        int newcol;
        int selIndex = this.choiceValue.getSelectedIndex();
        if (selIndex < 0) {
            selIndex = 0;
        }
        this.dataval[0] = newcol = this.indexValue[selIndex];
        if (this.statusBar != null && newcol >= 0) {
            this.statusBar.showHint(this.name[newcol]);
        }
        if (!this.disableReloadNeeded) {
            this.reloadNeeded = true;
        }
    }

    private void updateMappingForChoiceAxisXStateChange() {
        int newcol;
        if (this.choiceAxisX.getSelectedIndex() == -1 || (newcol = this.indexAxisX[this.choiceAxisX.getSelectedIndex()]) == this.dataval[0]) {
            return;
        }
        this.dataval[0] = newcol;
        if (this.statusBar != null && newcol >= 0) {
            this.statusBar.showHint(this.name[newcol]);
        }
        if (!this.disableReloadNeeded) {
            this.reloadNeeded = true;
        }
    }

    private void updateMappingForChoiceHighStateChange() {
        int newcol;
        if (this.choiceHigh.getSelectedIndex() == -1 || (newcol = this.indexHigh[this.choiceHigh.getSelectedIndex()]) == this.hilow.hi) {
            return;
        }
        this.hilow.hi = newcol;
        if (this.statusBar != null && newcol >= 0) {
            this.statusBar.showHint(this.name[newcol]);
        }
        if (!this.disableReloadNeeded) {
            this.reloadNeeded = true;
        }
    }

    private void updateMappingForChoiceLowStateChange() {
        int newcol;
        if (this.choiceLow.getSelectedIndex() == -1 || (newcol = this.indexLow[this.choiceLow.getSelectedIndex()]) == this.hilow.low) {
            return;
        }
        this.hilow.low = newcol;
        if (this.statusBar != null && newcol >= 0) {
            this.statusBar.showHint(this.name[newcol]);
        }
        if (!this.disableReloadNeeded) {
            this.reloadNeeded = true;
        }
    }

    private void updateMappingForChoiceCloseStateChange() {
        int newcol;
        if (this.choiceClose.getSelectedIndex() == -1 || (newcol = this.indexClose[this.choiceClose.getSelectedIndex()]) == this.hilow.close) {
            return;
        }
        this.hilow.close = newcol;
        if (this.statusBar != null && newcol >= 0) {
            this.statusBar.showHint(this.name[newcol]);
        }
        if (!this.disableReloadNeeded) {
            this.reloadNeeded = true;
        }
    }

    private void updateMappingForChoiceOpenStateChange() {
        int newcol = this.indexOpen[this.choiceOpen.getSelectedIndex()];
        if (newcol == this.hilow.open) {
            return;
        }
        this.hilow.open = newcol;
        if (this.statusBar != null && newcol >= 0) {
            this.statusBar.showHint(this.name[newcol]);
        }
        if (!this.disableReloadNeeded) {
            this.reloadNeeded = true;
        }
    }

    private void updateMappingForChoiceAxisYStateChange() {
        int newcol;
        if (this.choiceAxisY.getSelectedIndex() == -1 || (newcol = this.indexAxisY[this.choiceAxisY.getSelectedIndex()]) == this.dataval[1]) {
            return;
        }
        this.dataval[1] = newcol;
        if (this.statusBar != null && newcol >= 0) {
            this.statusBar.showHint(this.name[newcol]);
        }
        if (!this.disableReloadNeeded) {
            this.reloadNeeded = true;
        }
    }

    private void updateMappingForChoiceAxisZStateChange() {
        int newcol;
        if (this.choiceAxisZ.getSelectedIndex() == -1 || (newcol = this.indexAxisZ[this.choiceAxisZ.getSelectedIndex()]) == this.dataval[2]) {
            return;
        }
        this.dataval[2] = newcol;
        if (this.statusBar != null && newcol >= 0) {
            this.statusBar.showHint(this.name[newcol]);
        }
        if (!this.disableReloadNeeded) {
            this.reloadNeeded = true;
        }
    }

    private void updateAfterCheckBoxDeSel() {
        this.enabledisableCheckBox();
        this.colData = this.originalData;
        this.setName();
        this.clearComboBoxesValue();
        this.setComboBoxesValue();
        this.chart.isTransposed = false;
        this.setOriginalDefaultValue();
        this.updateDataMapping();
        this.setValues(this.chart.setNewData(this.colData));
        this.refreshDataMappingPanel();
        this.clearListSelection();
    }

    private int getChartTypeIndex(int chartType) {
        int index = 0;
        switch (chartType) {
            case 1: {
                index = 1;
                break;
            }
            case 3: {
                index = 2;
                break;
            }
            case 4: {
                index = 3;
                break;
            }
            case 5: {
                index = 4;
                break;
            }
            case 6: {
                index = 5;
                break;
            }
            case 7: {
                index = 6;
                break;
            }
            case 20: {
                index = 7;
                break;
            }
            case 14: {
                index = 8;
                break;
            }
            case 16: {
                index = 9;
                break;
            }
            case 17: {
                index = 10;
                break;
            }
            default: {
                index = 0;
            }
        }
        return index;
    }

    private int getNewChartType(String s) {
        int chartType = 0;
        if (s.equalsIgnoreCase(LanguageEncoder.getText("Column"))) {
            return 0;
        }
        if (s.equalsIgnoreCase(LanguageEncoder.getText("Bar"))) {
            return 1;
        }
        if (s.equalsIgnoreCase(LanguageEncoder.getText("Line"))) {
            return 3;
        }
        if (s.equalsIgnoreCase(LanguageEncoder.getText("Stack Column"))) {
            return 4;
        }
        if (s.equalsIgnoreCase(LanguageEncoder.getText("Stack Bar"))) {
            return 5;
        }
        if (s.equalsIgnoreCase(LanguageEncoder.getText("Pie"))) {
            return 6;
        }
        if (s.equalsIgnoreCase(LanguageEncoder.getText("Doughnut"))) {
            return 20;
        }
        if (s.equalsIgnoreCase(LanguageEncoder.getText("Area"))) {
            return 7;
        }
        if (s.equalsIgnoreCase(LanguageEncoder.getText("Overlay"))) {
            return 14;
        }
        if (s.equalsIgnoreCase(LanguageEncoder.getText("Radar"))) {
            return 16;
        }
        if (s.equalsIgnoreCase(LanguageEncoder.getText("Dial"))) {
            return 17;
        }
        return chartType;
    }

    private void enableDisableChoiceBoxes() {
        if (!this.drillDown) {
            return;
        }
        if (this.chartType == 17) {
            this.choiceSeries.setEnabled(false);
            this.multiSeries.setEnabled(false);
        } else {
            this.choiceSeries.setEnabled(true);
        }
        if (this.chartType == 4 || this.chartType == 5 || this.chartType == 8) {
            if (this.choiceSum.getItemAt(0).toString().equals(EMPTY)) {
                this.choiceSum.removeItem(EMPTY);
            }
            this.choiceSum.setEnabled(true);
        } else {
            if (!this.choiceSum.getItemAt(0).toString().equals(EMPTY)) {
                this.choiceSum.insertItemAt(EMPTY, 0);
            }
            this.choiceSum.setSelectedItem(EMPTY);
            this.choiceSum.setEnabled(false);
            this.multiSum.setEnabled(false);
        }
    }

    private String createDrillTemplateName() {
        String drillName = null;
        drillName = this.chart.drillTemplatePath + this.parentChart.drillTemplateName + this.parentChart.getDrillNumber() + ".tpl";
        return drillName;
    }

    private boolean doesTemplateFileExist(String file) {
        if (file == null) {
            return false;
        }
        if (!file.endsWith(".tpl")) {
            file = file + ".tpl";
        }
        ReadDataFile readfile = new ReadDataFile();
        try {
            readfile.getInputStream(this.chart, file);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Failed to close file", ex);
            try {
                readfile.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Error reading chart file", ex2);
            }
            return false;
        }
        try {
            readfile.close();
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Failed to close file", e);
        }
        return true;
    }

    private Chart applyTemplate(String file) {
        if (file == null) {
            return null;
        }
        if (!file.endsWith(".tpl")) {
            file = file + ".tpl";
        }
        ReadDataFile readfile = new ReadDataFile();
        DataInputStream din = null;
        try {
            din = readfile.getInputStream(this.chart, file);
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Error reading file", ex);
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(ex.toString());
            this.chartPanel.setEnabled(true);
            return null;
        }
        Chart newChart = null;
        try {
            newChart = new LoadChart().loadTemplate(this.chart, din);
        }
        catch (Throwable th) {
            LOGGER.log(Level.FINE, "Failed to load chart template", th);
            String message = LanguageEncoder.getText("Invalid file format !\n") + th.toString();
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(message);
            this.chartPanel.setEnabled(true);
            try {
                readfile.close();
            }
            catch (Exception ex2) {
                LOGGER.log(Level.FINEST, "Failed to close file", ex2);
            }
            return null;
        }
        try {
            readfile.close();
        }
        catch (Exception ex2) {
            LOGGER.log(Level.FINEST, "Failed to close file", ex2);
        }
        return newChart;
    }

    private int getsubvalue() {
        int index = this.choiceSubValue.getSelectedIndex();
        if (index >= this.choiceSubValue.getItemCount()) {
            index = 0;
        }
        return this.indexSubValue[index];
    }

    private int getsubseries() {
        int index = this.choiceSubSeries.getSelectedIndex();
        if (index >= this.choiceSubSeries.getItemCount()) {
            index = 0;
        }
        return this.indexSubSeries[index];
    }

    private final boolean setChartType(boolean doComboOverlayCheck) {
        if (doComboOverlayCheck && this.chart.getComboType() == 3 && (this.getsubvalue() < 0 || this.getsubseries() < 0)) {
            String message = LanguageEncoder.getText("2nd Series and 2nd Value are required for Overlay Combo!");
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(message);
            return false;
        }
        this.chartPanel.chart.setChanging3DChartType(true);
        if (this.chart.isHiLow()) {
            this.chartPanel.setChartType(this.datamap, this.datadim, this.hilow, this.getsubvalue());
        } else {
            this.chartPanel.setChartType(this.datamap, this.datadim, this.dataval, this.getsubvalue());
        }
        this.chartPanel.chart.setComboSeries(this.subSeries);
        if (this.chart.getChartType() == 18) {
            this.chart.setLabelDateTimeDisplay(0, true);
        } else if (this.chart.getChartType() == 2) {
            this.chart.setLabelDateTimeDisplay(0, DataType.isDateTime(this.chart.colData[this.chart.coordCol[0]].axisType));
            this.chart.setLabelDateTimeDisplay(1, DataType.isDateTime(this.chart.colData[this.chart.coordCol[1]].axisType));
            if (!this.chart.is2DimChart()) {
                this.chart.setLabelDateTimeDisplay(2, DataType.isDateTime(this.chart.colData[this.chart.coordCol[2]].axisType));
            }
        } else if (Chart.isCircularChart(this.chartType)) {
            this.chart.setPieGroupOthersLimit(0.0);
        }
        this.chart = this.chartPanel.chart;
        return true;
    }

    private final boolean isValidComboChartType() {
        if (this.chart.getComboType() == 3 && this.choiceCombo.isEnabled() && (this.getsubvalue() < 0 || this.getsubseries() < 0)) {
            String message = LanguageEncoder.getText("2nd Series and 2nd Value are required for Overlay Combo!");
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show(message);
            return false;
        }
        return true;
    }

    private int getIndexOf(int[] intArr, int tmp) {
        for (int i = 0; i < intArr.length; ++i) {
            if (intArr[i] != tmp) continue;
            return i;
        }
        return 0;
    }

    private class MyComboBoxRenderer
    extends BasicComboBoxRenderer {
        private MyComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                if (-1 < index) {
                    list.setToolTipText(value == null ? "" : value.toString());
                }
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }
}

