/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import quadbase.chart.Chart;
import quadbase.chart.designer.BoxPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ComboLinePanel;
import quadbase.chart.designer.CutOffPointPanel;
import quadbase.chart.designer.DateAxisPanel;
import quadbase.chart.designer.HLCOPanel;
import quadbase.chart.designer.OverlayPanel;
import quadbase.chart.designer.StackAreaPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.DataType;
import quadbase.common.util.internal.LanguageEncoder;

public class ChartOptionDialog
extends QbDialog {
    JButton okButton;
    JButton cancelButton;
    Chart chart;
    ChartMain chartMain;
    JCheckBox[] hideArea;
    OverlayPanel overlayPanel;
    StackAreaPanel stackAreaPanel;
    HLCOPanel hlcoPanel;
    ComboLinePanel comboLinePanel;
    DateAxisPanel[] axisPanel;
    BoxPanel boxPanel;
    CutOffPointPanel cutOffPointPanel;
    boolean init = false;
    boolean nothingToShow = false;

    public ChartOptionDialog(JFrame frame, Chart chart, boolean doOverlay, boolean doOverlayCombo, boolean doStackArea, boolean doHLCO) {
        this(frame, chart, doOverlay, doOverlayCombo, doStackArea, doHLCO, false, false);
    }

    public ChartOptionDialog(JFrame frame, Chart chart, boolean doOverlay, boolean doOverlayCombo, boolean doStackArea, boolean doHLCO, boolean doComboLine) {
        this(frame, chart, doOverlay, doOverlayCombo, doStackArea, doHLCO, doComboLine, false);
    }

    public ChartOptionDialog(JFrame frame, Chart chart, boolean doOverlay, boolean doOverlayCombo, boolean doStackArea, boolean doHLCO, boolean doComboLine, boolean doBox) {
        this(frame, chart, doOverlay, doOverlayCombo, doStackArea, doHLCO, doComboLine, doBox, false);
    }

    public ChartOptionDialog(JFrame frame, Chart chart, boolean doOverlay, boolean doOverlayCombo, boolean doStackArea, boolean doHLCO, boolean doComboLine, boolean doBox, boolean doScatter) {
        super(frame, LanguageEncoder.getText("Chart Options"), true);
        this.chartMain = (ChartMain)frame;
        this.chart = chart;
        this.init = false;
        if (doOverlay) {
            this.addOverlayPanel(chart, true);
        } else if (doOverlayCombo) {
            this.addOverlayPanel(chart.mData2.chart, false);
        }
        if (doStackArea) {
            this.addStackAreaPanel();
        }
        if (doHLCO) {
            this.addHLCOPanel();
        }
        if (doComboLine) {
            this.addComboLinePanel();
        }
        if (doScatter) {
            this.addDateTimeAxisPanels();
            this.addCutOffPointPanel();
        }
        if (doBox) {
            this.addBoxPanel();
        }
    }

    private void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        if ((double)dim.height > (double)screenSize.height * 0.6) {
            dim.height = (int)((double)screenSize.height * 0.6);
        }
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    private void addOverlayPanel(Chart chart, boolean displayAxis) {
        this.overlayPanel = new OverlayPanel(this.chartMain, chart, displayAxis);
    }

    private void addStackAreaPanel() {
        this.stackAreaPanel = new StackAreaPanel(this.chartMain, this.chart);
    }

    private void addHLCOPanel() {
        this.hlcoPanel = new HLCOPanel(this.chart);
    }

    private void addComboLinePanel() {
        this.comboLinePanel = new ComboLinePanel(this.chartMain, this.chart);
    }

    private void addBoxPanel() {
        this.boxPanel = new BoxPanel(this.chartMain, this.chart);
    }

    private void addCutOffPointPanel() {
        this.cutOffPointPanel = new CutOffPointPanel(this.chartMain, this.chart);
    }

    private void addDateTimeAxisPanels() {
        this.axisPanel = new DateAxisPanel[3];
        boolean reset = true;
        for (int i = 0; i < this.chart.coordCol.length; ++i) {
            if (!DataType.isDateTime(this.chart.colData[this.chart.coordCol[i]].axisType)) continue;
            reset = false;
            this.axisPanel[i] = new DateAxisPanel(this.chartMain, this.chart, i);
        }
        if (reset) {
            this.axisPanel = null;
            this.nothingToShow = true;
        }
    }

    boolean isNothingToShow() {
        return this.nothingToShow;
    }

    private void init() {
        if (this.init) {
            return;
        }
        this.setBackground(Color.lightGray);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        if (this.overlayPanel != null && (this.stackAreaPanel != null || this.hlcoPanel != null || this.comboLinePanel != null)) {
            JTabbedPane tabPanel = new JTabbedPane();
            JScrollPane scrollPane = new JScrollPane(this.overlayPanel);
            tabPanel.add(LanguageEncoder.getText("Overlay"), scrollPane);
            if (this.stackAreaPanel != null) {
                JScrollPane scrollPane2 = new JScrollPane(this.stackAreaPanel);
                tabPanel.add(LanguageEncoder.getText("Stack Area"), scrollPane2);
            }
            if (this.hlcoPanel != null) {
                tabPanel.add(LanguageEncoder.getText("HLCO"), this.hlcoPanel);
            }
            if (this.comboLinePanel != null) {
                tabPanel.add(LanguageEncoder.getText("Combo Line"), this.comboLinePanel);
            }
            contentPane.add("Center", tabPanel);
            contentPane.add("South", buttonPanel);
        } else if (this.hlcoPanel != null && this.comboLinePanel != null) {
            JTabbedPane tabPanel = new JTabbedPane();
            tabPanel.add(LanguageEncoder.getText("HLCO"), this.hlcoPanel);
            tabPanel.add(LanguageEncoder.getText("Combo Line"), this.comboLinePanel);
            contentPane.add("Center", tabPanel);
            contentPane.add("South", buttonPanel);
        } else if (this.hlcoPanel != null) {
            contentPane.add("Center", this.hlcoPanel);
            contentPane.add("South", buttonPanel);
        } else if (this.overlayPanel != null) {
            contentPane.add("Center", this.overlayPanel);
            contentPane.add("South", buttonPanel);
        } else if (this.stackAreaPanel != null && this.comboLinePanel == null) {
            JScrollPane scrollPane2 = new JScrollPane(this.stackAreaPanel);
            contentPane.add("Center", scrollPane2);
            contentPane.add("South", buttonPanel);
        } else if (this.stackAreaPanel != null && this.comboLinePanel != null) {
            JTabbedPane tabPanel = new JTabbedPane();
            JScrollPane scrollPane2 = new JScrollPane(this.stackAreaPanel);
            tabPanel.add(LanguageEncoder.getText("Stack Area"), scrollPane2);
            tabPanel.add(LanguageEncoder.getText("Combo Line"), this.comboLinePanel);
            contentPane.add("Center", tabPanel);
            contentPane.add("South", buttonPanel);
        } else if (this.boxPanel != null && this.comboLinePanel != null) {
            JTabbedPane tabPanel = new JTabbedPane();
            tabPanel.add(LanguageEncoder.getText("BOX"), this.boxPanel);
            tabPanel.add(LanguageEncoder.getText("Combo Line"), this.comboLinePanel);
            contentPane.add("Center", tabPanel);
            contentPane.add("South", buttonPanel);
        } else if (this.cutOffPointPanel != null && this.comboLinePanel != null) {
            JTabbedPane tabPanel = new JTabbedPane();
            tabPanel.add(LanguageEncoder.getText("Combo Line"), this.comboLinePanel);
            tabPanel.add(LanguageEncoder.getText("Cut Off Point"), this.cutOffPointPanel);
            contentPane.add("Center", tabPanel);
            contentPane.add("South", buttonPanel);
        } else if (this.axisPanel != null && this.comboLinePanel != null) {
            JTabbedPane tabPanel = new JTabbedPane();
            for (int i = 0; i < this.axisPanel.length; ++i) {
                String axisType = " ";
                if (i == 0) {
                    axisType = "X ";
                } else if (i == 1) {
                    axisType = "Y ";
                } else if (i == 2) {
                    axisType = "Z ";
                }
                if (this.axisPanel[i] == null) continue;
                tabPanel.add(axisType + LanguageEncoder.getText("Date/Time Axis"), this.axisPanel[i]);
            }
            tabPanel.add(LanguageEncoder.getText("Combo Line"), this.comboLinePanel);
            contentPane.add("Center", tabPanel);
            contentPane.add("South", buttonPanel);
        } else if (this.axisPanel != null) {
            int panelCt = 0;
            DateAxisPanel[] i = this.axisPanel;
            int axisType = i.length;
            for (int j = 0; j < axisType; ++j) {
                DateAxisPanel element = i[j];
                if (element == null) continue;
                ++panelCt;
            }
            if (panelCt < 1) {
                JTabbedPane tabPanel = new JTabbedPane();
                for (int i2 = 0; i2 < this.axisPanel.length; ++i2) {
                    String axisType2 = " ";
                    if (i2 == 0) {
                        axisType2 = "X ";
                    } else if (i2 == 1) {
                        axisType2 = "Y ";
                    } else if (i2 == 2) {
                        axisType2 = "Z ";
                    }
                    if (this.axisPanel[i2] == null) continue;
                    tabPanel.add(axisType2 + LanguageEncoder.getText("Date/Time Axis"), this.axisPanel[i2]);
                }
                contentPane.add("Center", tabPanel);
                contentPane.add("South", buttonPanel);
            } else {
                for (DateAxisPanel element : this.axisPanel) {
                    if (element == null) continue;
                    contentPane.add("Center", element);
                }
                contentPane.add("South", buttonPanel);
            }
        } else if (this.boxPanel != null) {
            contentPane.add("Center", this.boxPanel);
            contentPane.add("South", buttonPanel);
        } else if (this.cutOffPointPanel != null) {
            contentPane.add("Center", this.cutOffPointPanel);
            contentPane.add("South", buttonPanel);
        } else if (this.comboLinePanel != null) {
            contentPane.add("Center", this.comboLinePanel);
            contentPane.add("South", buttonPanel);
        }
        this.setPosition();
        this.init = true;
    }

    @Override
    public void setVisible(boolean b) {
        this.init();
        super.setVisible(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            String errorMsg;
            if (this.overlayPanel != null && !this.overlayPanel.setValues()) {
                new MessageDialog((Frame)this.chartMain, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Overlay Options: Cannot set all invisible!"));
            }
            if (this.stackAreaPanel != null) {
                this.stackAreaPanel.setValues();
            }
            if (this.hlcoPanel != null) {
                this.hlcoPanel.setValues();
            }
            if (this.comboLinePanel != null && (errorMsg = this.comboLinePanel.setValues()) != null) {
                new MessageDialog((Frame)this.chartMain, LanguageEncoder.getText("Error")).show(errorMsg);
                return;
            }
            if (this.boxPanel != null) {
                this.boxPanel.setValues();
            }
            if (this.cutOffPointPanel != null) {
                this.cutOffPointPanel.setValues();
            }
            if (this.axisPanel != null) {
                for (DateAxisPanel element : this.axisPanel) {
                    if (element == null) continue;
                    element.setValues();
                }
            }
            this.chartMain.invalidateLegend();
            this.chartMain.setModified();
            this.chartMain.chartPanel.repaint();
            this.dispose();
        } else if (source == this.cancelButton) {
            if (this.comboLinePanel != null && this.comboLinePanel.stateChanged) {
                this.comboLinePanel.setStepLineEnabled(!this.comboLinePanel.checkStep.isSelected());
                this.comboLinePanel.stateChanged = false;
            }
            this.dispose();
        }
    }
}

