/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Adjustable;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import quadbase.chart.Area;
import quadbase.chart.Axis;
import quadbase.chart.CAnnotation;
import quadbase.chart.CGraphics;
import quadbase.chart.CString;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.ControlLine;
import quadbase.chart.DataLine;
import quadbase.chart.FaceData;
import quadbase.chart.GraphicsTable;
import quadbase.chart.Grid;
import quadbase.chart.HiLowMap;
import quadbase.chart.HintInterface;
import quadbase.chart.HorzVertLine;
import quadbase.chart.IPieChart;
import quadbase.chart.Legend;
import quadbase.chart.MultiDimData;
import quadbase.chart.Point3D;
import quadbase.chart.PropCString;
import quadbase.chart.Ticker;
import quadbase.chart.TrendLine;
import quadbase.chart.chart3d.lib3d.HiddenSurface;
import quadbase.chart.chart3d.lib3d.Space;
import quadbase.chart.chart3d.lib3d.Vertex;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.EditTextDialog;
import quadbase.chart.designer.PopupMenuForChart;
import quadbase.chart.designer.TextDialog;
import quadbase.common.swing.CScrollPane;
import quadbase.common.swing.PanelAction;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.ControlRange;
import quadbase.util.HyperLink;
import quadbase.util.Point_2D;
import quadbase.util.PolyLine;
import quadbase.util.internal.IOUtil;

public class ChartPanel
extends PanelAction
implements Runnable,
KeyListener,
HintInterface {
    private static final Logger LOGGER = Logger.getLogger(ChartPanel.class.getName());
    public Chart chart;
    public static final int DRAWMODE = 0;
    public static final int LINEMODE = 2;
    public static final int TEXTPOSMODE = 3;
    Image offScreenImage;
    Image offScreenImage2;
    Graphics backbuffer;
    Graphics backbuffer2;
    int chartType;
    int prefWidth = 400;
    int prefHeight = 300;
    int width;
    int height;
    int offsetWidth;
    int offsetHeight;
    boolean recompute = true;
    boolean please_stop;
    boolean firstPanel = true;
    Thread animator = null;
    boolean animation = false;
    JFrame fwindow;
    JDialog dialog;
    public boolean progressiveDraw = true;
    Object selectobj;
    Object dragtarget;
    int lastx;
    int lasty;
    byte doubleclick = 0;
    boolean draginit = false;
    boolean dragstate;
    private int mode = 0;
    float old_XProp;
    float old_YProp;
    long systime = System.currentTimeMillis();
    StringBuffer textString;
    PropCString ctextString;
    int labelIndex;
    private Axis selAxis;
    int lastwidth = -1;
    int lastheight = -1;
    boolean firstTime = true;
    Vector<Vertex> currLine;
    Vector<Boolean> vertexStatus = new Vector();
    Point lastMouseCoord = new Point(-1, -1);
    String oldtitle;
    boolean b_doubleclick = false;
    boolean firstErrorMessage = true;
    Object eventObject;
    CScrollPane pane;
    int scrollBarOption = 0;
    float newChartWidth;
    float newChartHeight;
    int newxboundmax;
    int newxboundmin;
    int newyboundmax;
    int newyboundmin;
    int old_xboundmin;
    int old_yboundmin;
    int old_xboundmax;
    int old_yboundmax;
    float newChartX;
    float newChartY;
    boolean changeTableSize = false;
    boolean changeTabSize = false;
    boolean changeTablePosition = false;
    int cell;
    int tabNum;
    boolean isPopupTrigger = false;
    boolean isPopupMenuEnabled = true;
    PopupMenuForChart popupMenu;
    static boolean printException = true;
    int lastDashRectX = -1;
    int lastDashRectY = -1;
    int lastDashRectW = -1;
    int lastDashRectH = -1;
    boolean dashRectVisible = false;
    public static final int NW = 0;
    public static final int NE = 1;
    public static final int SW = 2;
    public static final int SE = 4;
    public static final int NORTH = 8;
    public static final int SOUTH = 16;
    public static final int EAST = 32;
    public static final int WEST = 64;
    int cursorDirection = -1;
    final int SECT_1 = 1;
    final int SECT_2 = 2;
    final int SECT_3 = 3;
    final int SECT_4 = 4;
    final int BORDER_41 = 5;
    final int BORDER_12 = 6;
    final int BORDER_23 = 7;
    final int BORDER_34 = 8;
    final int AREA_41 = 0;
    final int AREA_12 = 1;
    final int AREA_23 = 2;
    final int AREA_34 = 3;

    public ChartPanel(Chart chart) {
        this.setLayout(null);
        this.setChart(chart);
        this.addListener();
        if (chart != null) {
            this.scrollBarOption = chart.getScrollBarOption();
        }
        this.pane = new CScrollPane(this, this.scrollBarOption);
        this.setPane(this.pane);
    }

    public ChartPanel(int _chartType, boolean is2DChart, ColData[] colData, Chart _chart, Dimension defaultSize) {
        this.setLayout(null);
        try {
            this.chart = Chart.createChart(this, _chartType, is2DChart, _chart, colData);
        }
        catch (IllegalArgumentException e) {
            LOGGER.log(Level.FINEST, "Failed to create chart", e);
            throw e;
        }
        this.chartType = _chartType;
        if (defaultSize != null) {
            this.chart.newSurface();
            this.chart.setSize(defaultSize);
            this.setSize(defaultSize);
        } else {
            this.chart.newSurface();
            this.chart.setSize(_chart.getSize());
            this.setSize(this.chart.getSize());
        }
        this.addListener();
        if (this.chart != null) {
            this.scrollBarOption = this.chart.getScrollBarOption();
        }
        this.pane = new CScrollPane(this, this.scrollBarOption);
        this.setPane(this.pane);
    }

    private void addListener() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.popupMenu = new PopupMenuForChart(this);
        this.add(this.popupMenu);
    }

    public void removeChartPanelListener() {
        this.removeMouseListener(this);
        this.removeMouseListener(this);
        if (!this.firstTime) {
            this.removeKeyListener(this);
        }
        if (this.popupMenu != null) {
            this.remove(this.popupMenu);
        }
    }

    public void setChart(Chart chart) {
        this.setChart(chart, null);
    }

    public void setChart(Chart chart, Dimension dim) {
        if (chart == null) {
            return;
        }
        this.chart = chart;
        this.chartType = chart.chartType;
        if (dim != null) {
            this.setSize(dim);
        } else {
            this.setSize(chart.getSize());
        }
        if (this.getGraphics() != null) {
            this.update(this.getGraphics());
        }
        this.recompute = true;
    }

    public void setRecompute() {
        this.recompute = true;
    }

    public void setFrame(JFrame f) {
        this.fwindow = f;
        this.dialog = null;
    }

    public void setScrollPane(CScrollPane p) {
        this.pane = p;
        this.setPane(this.pane);
    }

    public CScrollPane getScrollPane() {
        return this.pane;
    }

    public void setPane(CScrollPane p) {
        this.pane = p;
        Adjustable vAdjust = this.pane.getVAdjustable();
        Adjustable hAdjust = this.pane.getHAdjustable();
        vAdjust.setUnitIncrement(5 * vAdjust.getUnitIncrement());
        hAdjust.setUnitIncrement(5 * hAdjust.getUnitIncrement());
        if (this.chart != null) {
            this.setSize(this.chart.getSize());
        }
    }

    public void setDialog(JDialog dialog) {
        this.dialog = dialog;
        this.fwindow = null;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.chart != null) {
            Dimension size = this.chart.getSize();
            return new Dimension(Math.max(size.width, this.prefWidth), Math.max(size.height, this.prefHeight));
        }
        return new Dimension(this.prefWidth, this.prefHeight);
    }

    @Override
    public void setSize(Dimension d) {
        this.setSize(d.width, d.height, false);
    }

    @Override
    public void setSize(int w, int h) {
        this.setSize(w, h, false);
    }

    public void setSize(int w, int h, boolean isOverride) {
        if (this.chart != null) {
            Dimension currentChartSize = this.chart.getSize();
            LOGGER.finest("CURRENT CHART SIZE = " + currentChartSize.width + ", " + currentChartSize.height);
            if ((currentChartSize.width != w || currentChartSize.height != h) && isOverride) {
                float ratio = ((float)(w - currentChartSize.width) / (float)currentChartSize.width + (float)(h - currentChartSize.height) / (float)currentChartSize.height) / 2.0f;
                this.chart.resizeFont(ratio);
                this.chart.setSize(w, h);
            }
            if (this.pane != null) {
                Dimension size = this.pane.getViewSize();
                this.prefWidth = Math.max(size.width, w);
                this.prefHeight = Math.max(size.height, h);
            } else {
                this.prefWidth = w;
                this.prefHeight = h;
            }
            this.width = w;
            this.height = h;
            if (this.firstPanel) {
                if (this.chart.getSize().width != 0) {
                    this.width = this.chart.getSize().width;
                    this.height = this.chart.getSize().height;
                    Dimension size = this.pane != null ? this.pane.getViewSize() : new Dimension(this.prefWidth, this.prefHeight);
                    this.prefWidth = this.width > size.width ? this.width : size.width;
                    this.prefHeight = this.height > size.height ? this.height : size.height;
                } else {
                    this.prefWidth = 600;
                    this.prefHeight = 500;
                    this.width = 600;
                    this.height = 500;
                    this.chart.setSize(600, 500);
                }
                this.firstPanel = false;
            }
            this.offsetWidth = (this.prefWidth - this.width) / 2;
            this.offsetHeight = (this.prefHeight - this.height) / 2;
            super.setSize(this.prefWidth, this.prefHeight);
            LOGGER.finest("Setsize called with " + this.prefWidth + "," + this.prefHeight);
        } else {
            super.setSize(w, h);
        }
    }

    public void update() {
        this.update(this.getGraphics());
    }

    @Override
    public synchronized void update(Graphics g) {
        if (g == null) {
            return;
        }
        if (this.chart == null) {
            return;
        }
        boolean progressive = !this.chart.is2DChart && this.chart.get3DDrawType() != 0 && this.progressiveDraw;
        Dimension size = new Dimension(this.width, this.height);
        if (this.pane != null) {
            size = this.pane.getViewportSize();
        }
        this.width = this.chart.getSize().width != 0 ? this.chart.getSize().width : size.width;
        this.height = this.chart.getSize().height != 0 ? this.chart.getSize().height : size.height;
        if (this.pane != null) {
            this.pane.doLayout();
            if (this.fwindow instanceof ChartMain) {
                ((ChartMain)this.fwindow).updateSizeLabel();
            }
        }
        if (this.width <= 0 || this.height <= 0) {
            return;
        }
        this.setSize(this.width, this.height);
        if (this.fwindow != null) {
            this.oldtitle = this.fwindow.getTitle();
            this.fwindow.setTitle(LanguageEncoder.getText("Processing ..."));
        } else {
            this.oldtitle = this.dialog.getTitle();
            this.dialog.setTitle(LanguageEncoder.getText("Processing ..."));
        }
        try {
            if (this.width != this.lastwidth || this.height != this.lastheight) {
                if (this.offScreenImage != null) {
                    this.offScreenImage.flush();
                }
                this.offScreenImage = null;
                this.offScreenImage = this.createImage(this.width, this.height);
                this.backbuffer = this.offScreenImage.getGraphics();
                this.lastwidth = this.width;
                this.lastheight = this.height;
            }
            this.chart.draw(progressive ? g : this.backbuffer, this, this.width, this.height);
            if (progressive) {
                this.chart.draw(this.backbuffer, this, this.width, this.height);
            }
            g.setColor(Color.gray);
            g.fillRect(0, 0, this.prefWidth, this.prefHeight);
            g.drawImage(this.offScreenImage, this.offsetWidth, this.offsetHeight, this.width, this.height, this);
            this.dashRectVisible = false;
            this.recompute = false;
        }
        catch (Exception ex) {
            if (printException) {
                LOGGER.log(Level.WARNING, "Failed to redraw the chart", ex);
                throw new IllegalArgumentException(ex.toString());
            }
        }
        catch (Error err) {
            LOGGER.log(Level.WARNING, "Failed to redraw the chart", err);
            this.showError(err.toString());
            throw new IllegalArgumentException(err.toString());
        }
        this.showError(null);
    }

    private void showError(String s) {
        if (this.fwindow != null) {
            this.fwindow.setTitle(this.oldtitle);
        } else {
            this.dialog.setTitle(this.oldtitle);
        }
        if (s != null && this.firstErrorMessage) {
            this.firstErrorMessage = false;
            if (this.fwindow != null) {
                new JMessageDialog((Frame)this.fwindow, LanguageEncoder.getText("Error"), s);
            } else {
                new JMessageDialog((Dialog)this.dialog, LanguageEncoder.getText("Error"), s);
            }
        }
    }

    public void setChartType(int[] map, int dim, int[] val, int subvalue) {
        if (Chart.isCoordinateType(this.chart.chartType)) {
            this.chart.setChartType(map, dim, val);
        } else {
            this.chart.setChartType(map, dim, val[0], subvalue);
        }
        this.chart.setDefault();
    }

    public void setChartType(int[] map, int dim, HiLowMap hilow, int subvalue) {
        this.chart.setChartType(map, dim, hilow, subvalue);
        this.chart.setDefault();
    }

    public void paint() {
        this.paintComponent(this.getGraphics());
    }

    @Override
    public synchronized void paint(Graphics g) {
        this.paintComponent(g);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.firstTime) {
            this.addKeyListener(this);
            this.firstTime = false;
        }
        if (this.chart == null) {
            return;
        }
        if (this.chart.getSize().width != this.width || this.chart.getSize().height != this.height || this.recompute) {
            this.update(g);
            return;
        }
        if (this.animation) {
            this.threadPaint(g);
            return;
        }
        this.chart.draw(this.backbuffer, this, this.width, this.height);
        g.setColor(Color.gray);
        g.fillRect(0, 0, this.prefWidth, this.prefHeight);
        g.drawImage(this.offScreenImage, this.offsetWidth, this.offsetHeight, this.width, this.height, this);
        this.dashRectVisible = false;
        this.firstErrorMessage = true;
    }

    private synchronized void threadPaint(Graphics g) {
        this.backbuffer.setColor(this.getBackground());
        this.backbuffer.fillRect(0, 0, this.width, this.height);
        this.chart.draw(this.backbuffer);
        g.drawImage(this.offScreenImage, this.offsetWidth, this.offsetHeight, this.width, this.height, this);
        this.dashRectVisible = false;
    }

    public void start() {
        this.please_stop = false;
        if (this.animator == null) {
            this.animator = new Thread(this);
        }
        this.animator.setPriority(1);
        this.animator.start();
    }

    public void stop() {
        if (this.animator != null) {
            this.please_stop = true;
            this.animator = null;
        }
    }

    @Override
    public void run() {
        if (this.chart.is2DChart) {
            return;
        }
        Space space = (Space)this.chart.getSpace();
        float scale = space.spaceScale;
        double alpha = Math.atan2(-space.viewVec.k, -space.viewVec.i);
        double pheta = Math.asin(-space.viewVec.j);
        double pi2 = Math.PI * 2;
        double t = Math.cos(pheta) * (double)scale;
        double t2 = Math.sin(pheta) * (double)scale;
        while (!this.please_stop && this.animation) {
            this.chart.setlookfrom_x((float)(t * Math.cos(alpha) + (double)this.chart.getlookto_x()));
            this.chart.setlookfrom_y((float)(t2 + (double)this.chart.getlookto_y()));
            this.chart.setlookfrom_z((float)(t * Math.sin(alpha) + (double)this.chart.getlookto_z()));
            space.lookat(this.chart.getlookfrom_x(), this.chart.getlookfrom_y(), this.chart.getlookfrom_z(), this.chart.getlookto_x(), this.chart.getlookto_y(), this.chart.getlookto_z());
            try {
                this.threadPaint(this.getGraphics());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Error repainting the chart", ex);
                return;
            }
            if (!((alpha += this.chart.getAnimateSpeed()) > pi2)) continue;
            alpha -= pi2;
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this.fwindow instanceof ChartMain) {
            ((ChartMain)this.fwindow).createBackupChart();
            if (e.getKeyCode() == 127 || e.getKeyCode() == 8) {
                ((ChartMain)this.fwindow).do_Remove();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    boolean isLineMode() {
        return this.mode == 2;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Graphics g;
        if (e.getX() < 0 || e.getY() < 0) {
            return;
        }
        if (e.getX() > this.prefWidth || e.getY() > this.prefHeight) {
            return;
        }
        int x = e.getX() - this.offsetWidth;
        int y = e.getY() - this.offsetHeight;
        if (this.chart != null && this.chart.gt != null && this.chart.tableInPanel && !this.chart.gt.clear) {
            int currentType;
            Cursor currentCursor = this.getCursor();
            int n = currentType = currentCursor == null ? 0 : currentCursor.getType();
            if (this.chart.showLegend2() && this.chart.gt.atAxisTab(x, y) >= 0 && currentType != 12) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else if (this.chart.gt.tabPanel && this.chart.gt.atSeriesTab(x, y) >= 0 && currentType != 12) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else if ((this.chart.gt.atCBorder(x, y) >= 0 || this.chart.gt.atTBorder(x, y) >= 0) && currentType != 11) {
                this.setCursor(Cursor.getPredefinedCursor(11));
            } else if (currentType != 1 && currentType != 0) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        if (this.mode == 2 && this.currLine.size() > 0) {
            g = this.getGraphics();
            g.setXORMode(Color.white);
            Vertex v = this.currLine.lastElement();
            if (this.lastMouseCoord.x != -1 && this.lastMouseCoord.y != -1) {
                g.drawLine(v.screen_x + this.offsetWidth, v.screen_y + this.offsetHeight, this.lastMouseCoord.x + this.offsetWidth, this.lastMouseCoord.y + this.offsetHeight);
            }
            g.drawLine(v.screen_x + this.offsetWidth, v.screen_y + this.offsetHeight, x + this.offsetWidth, y + this.offsetHeight);
            this.lastMouseCoord.x = x;
            this.lastMouseCoord.y = y;
            g.setPaintMode();
            g.dispose();
        }
        if (this.mode == 3) {
            g = this.getGraphics();
            g.setColor(Color.gray);
            g.fillRect(0, 0, this.prefWidth, this.offsetHeight);
            g.fillRect(0, this.offsetHeight + this.height, this.prefWidth, this.prefHeight);
            g.fillRect(0, this.offsetHeight, this.offsetWidth, this.height);
            g.fillRect(this.offsetWidth + this.width, this.offsetHeight, this.prefWidth - this.offsetWidth - this.width, this.height);
            g.drawImage(this.offScreenImage, this.offsetWidth, this.offsetHeight, this.width, this.height, this);
            this.dashRectVisible = false;
            int width = TextDialog.saveAnnoWidth;
            int height = TextDialog.saveAnnoHeight;
            g.drawRect(x + this.offsetWidth, y - height / 2 + this.offsetHeight, width, height);
            g.dispose();
        }
        if (this.dashRectVisible && this.dragtarget == null && this.chart != null && (this.chart.inside(x, y) || this.isOnElementCursor(x, y))) {
            this.setOnElementCursor(x, y);
        }
    }

    private void setOnElementCursor(int x, int y) {
        int xi = this.lastDashRectX;
        int yi = this.lastDashRectY;
        int wi = this.lastDashRectW;
        int hi = this.lastDashRectH;
        Rectangle ul = new Rectangle(xi - 4, yi - 4, 8, 8);
        Rectangle ur = new Rectangle(xi + wi - 4, yi - 4, 8, 8);
        Rectangle ll = new Rectangle(xi - 4, yi + hi - 4, 8, 8);
        Rectangle lr = new Rectangle(xi + wi - 4, yi + hi - 4, 8, 8);
        Rectangle top = new Rectangle(xi + wi / 2 - 4, yi - 4, 8, 8);
        Rectangle bottom = new Rectangle(xi + wi / 2 - 4, yi + hi - 4, 8, 8);
        Rectangle left = new Rectangle(xi - 4, yi + hi / 2 - 4, 8, 8);
        Rectangle right = new Rectangle(xi + wi - 4, yi + hi / 2 - 4, 8, 8);
        boolean isHead = true;
        boolean isTail = true;
        this.cursorDirection = -1;
        this.setCursor(Cursor.getPredefinedCursor(12));
        if (isHead && ul.contains(x, y)) {
            this.setOnElementCursor(6, ul, 0);
        } else if (isTail && lr.contains(x, y)) {
            this.setOnElementCursor(5, lr, 4);
        } else if (isHead && ur.contains(x, y)) {
            this.setOnElementCursor(7, ur, 1);
        } else if (isTail && ll.contains(x, y)) {
            this.setOnElementCursor(4, ll, 2);
        }
        if (this.chart.is2DimChart() && !this.isCircularRatioChart(this.chart)) {
            if (top.contains(x, y) && isHead) {
                this.setOnElementCursor(8, top, 8);
            } else if (bottom.contains(x, y) && isTail) {
                this.setOnElementCursor(9, bottom, 16);
            } else if (right.contains(x, y)) {
                this.setOnElementCursor(11, right, 32);
            } else if (left.contains(x, y)) {
                this.setOnElementCursor(10, left, 64);
            }
        }
    }

    private boolean isCircularRatioChart(Chart chart) {
        return chart.getChartType() == 17 || chart.getChartType() == 6 || chart.getChartType() == 20;
    }

    private boolean isOnElementCursor(int x, int y) {
        int xi = this.lastDashRectX;
        int yi = this.lastDashRectY;
        int wi = this.lastDashRectW;
        int hi = this.lastDashRectH;
        int full = 20;
        int half = 10;
        Rectangle ul = new Rectangle(xi - half, yi - half, full, full);
        Rectangle ur = new Rectangle(xi + wi - half, yi - half, full, full);
        Rectangle ll = new Rectangle(xi - half, yi + hi - half, full, full);
        Rectangle lr = new Rectangle(xi + wi - half, yi + hi - half, full, full);
        Rectangle top = new Rectangle(xi + wi / 2 - half, yi - half, full, full);
        Rectangle bottom = new Rectangle(xi + wi / 2 - half, yi + hi - half, full, full);
        Rectangle left = new Rectangle(xi - half, yi + hi / 2 - half, full, full);
        Rectangle right = new Rectangle(xi + wi - half, yi + hi / 2 - half, full, full);
        boolean isHead = true;
        boolean isTail = true;
        this.cursorDirection = -1;
        if (isHead && ul.contains(x, y)) {
            this.cursorDirection = 0;
            return true;
        }
        if (isTail && lr.contains(x, y)) {
            this.cursorDirection = 4;
            return true;
        }
        if (isHead && ur.contains(x, y)) {
            this.cursorDirection = 1;
            return true;
        }
        if (isTail && ll.contains(x, y)) {
            this.cursorDirection = 2;
            return true;
        }
        if (this.chart.is2DimChart() && !this.isCircularRatioChart(this.chart)) {
            if (top.contains(x, y) && isHead) {
                this.cursorDirection = 8;
                return true;
            }
            if (bottom.contains(x, y) && isTail) {
                this.cursorDirection = 16;
                return true;
            }
            if (right.contains(x, y)) {
                this.cursorDirection = 32;
                return true;
            }
            if (left.contains(x, y)) {
                this.cursorDirection = 64;
                return true;
            }
        }
        return false;
    }

    private void setOnElementCursor(int cursorType, Rectangle bounds, int direction) {
        this.setCursor(Cursor.getPredefinedCursor(cursorType));
        this.cursorDirection = direction;
    }

    private void setChartPosition(int x, int y) {
        LOGGER.finest("SET CHART POSITION...");
        if (this.chart.is2DimChart()) {
            this.newChartX = this.chart.chart_XProp;
            this.newChartY = this.chart.chart_YProp;
            this.newChartWidth = this.chart.chart_widthProp;
            this.newChartHeight = this.chart.chart_heightProp;
            switch (this.cursorDirection) {
                case 8: {
                    float tempHeight;
                    this.newChartY = (float)y / (float)this.height;
                    this.newChartHeight = tempHeight = (this.chart.chart_heightProp * (float)this.height - (float)(y - this.lasty)) / (float)this.height;
                    break;
                }
                case 16: {
                    float tempHeight;
                    this.newChartHeight = tempHeight = (this.chart.chart_heightProp * (float)this.height + (float)(y - this.lasty)) / (float)this.height;
                    break;
                }
                case 32: {
                    float tempWidth;
                    this.newChartWidth = tempWidth = (this.chart.chart_widthProp * (float)this.width + (float)(x - this.lastx)) / (float)this.width;
                    break;
                }
                case 64: {
                    float tempWidth;
                    this.newChartX = (float)x / (float)this.width;
                    this.newChartWidth = tempWidth = (this.chart.chart_widthProp * (float)this.width - (float)(x - this.lastx)) / (float)this.width;
                    break;
                }
                case 0: {
                    float tempWidth;
                    float tempHeight;
                    this.newChartY = (float)y / (float)this.height;
                    this.newChartHeight = tempHeight = (this.chart.chart_heightProp * (float)this.height - (float)(y - this.lasty)) / (float)this.height;
                    this.newChartX = (float)x / (float)this.width;
                    this.newChartWidth = tempWidth = (this.chart.chart_widthProp * (float)this.width - (float)(x - this.lastx)) / (float)this.width;
                    break;
                }
                case 1: {
                    float tempWidth;
                    float tempHeight;
                    this.newChartY = (float)y / (float)this.height;
                    this.newChartHeight = tempHeight = (this.chart.chart_heightProp * (float)this.height - (float)(y - this.lasty)) / (float)this.height;
                    this.newChartWidth = tempWidth = (this.chart.chart_widthProp * (float)this.width + (float)(x - this.lastx)) / (float)this.width;
                    break;
                }
                case 2: {
                    float tempWidth;
                    float tempHeight;
                    this.newChartHeight = tempHeight = (this.chart.chart_heightProp * (float)this.height + (float)(y - this.lasty)) / (float)this.height;
                    this.newChartX = (float)x / (float)this.width;
                    this.newChartWidth = tempWidth = (this.chart.chart_widthProp * (float)this.width - (float)(x - this.lastx)) / (float)this.width;
                    break;
                }
                case 4: {
                    float tempWidth;
                    float tempHeight;
                    this.newChartHeight = tempHeight = (this.chart.chart_heightProp * (float)this.height + (float)(y - this.lasty)) / (float)this.height;
                    this.newChartWidth = tempWidth = (this.chart.chart_widthProp * (float)this.width + (float)(x - this.lastx)) / (float)this.width;
                    break;
                }
                default: {
                    LOGGER.fine("UNKNOWN POSITION = " + this.cursorDirection);
                    break;
                }
            }
        } else {
            this.newxboundmax = this.chart.xboundmax;
            this.newxboundmin = this.chart.xboundmin;
            this.newyboundmax = this.chart.yboundmax;
            this.newyboundmin = this.chart.yboundmin;
            switch (this.cursorDirection) {
                case 0: {
                    this.newyboundmin = y;
                    this.newxboundmin = x;
                    break;
                }
                case 1: {
                    this.newyboundmin = y;
                    this.newxboundmax = x;
                    break;
                }
                case 2: {
                    this.newyboundmax = y;
                    this.newxboundmin = x;
                    break;
                }
                case 4: {
                    this.newyboundmax = y;
                    this.newxboundmax = x;
                    break;
                }
                default: {
                    LOGGER.fine("UNKNOWN POSITION = " + this.cursorDirection);
                }
            }
        }
    }

    private final Vertex transformCoord(int x, int y) {
        Vertex v = new Vertex((float)((x - this.chart.chartxorigin) * 1000) / (float)this.chart.chartwidth, (float)((this.chart.winHeight - y - this.chart.chartyorigin) * 1000) / (float)this.chart.chartheight, 500.0f);
        v.screen_x = x;
        v.screen_y = y;
        return v;
    }

    void setMode(int newMode) {
        if (this.fwindow instanceof ChartMain) {
            this.mode = newMode;
            ChartMain chartMain = (ChartMain)this.fwindow;
            boolean isDrawMode = this.mode == 0;
            JMenuBar menubar = chartMain.menubar;
            int nMenu = menubar.getMenuCount();
            for (int i = 0; i < nMenu; ++i) {
                menubar.getMenu(i).setEnabled(isDrawMode);
            }
            chartMain.toolbar.setAllEnabledWithSave(isDrawMode);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.animation) {
            return;
        }
        if (!this.isPopupTrigger) {
            this.isPopupTrigger = e.isPopupTrigger();
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.animation) {
            return;
        }
        this.requestFocus();
        int x = e.getX() - this.offsetWidth;
        int y = e.getY() - this.offsetHeight;
        if (this.chart == null) {
            return;
        }
        if (this.chart.tableInPanel) {
            if (this.fwindow instanceof ChartMain) {
                ((ChartMain)this.fwindow).createBackupChart();
            }
            int axisTab = this.chart.gt.atAxisTab(x, y);
            if (this.chart.showLegend2() && axisTab >= 0) {
                if (axisTab == 0) {
                    this.chart.gt.setData(this.chart, this.chart.mData);
                } else {
                    this.chart.gt.setData(this.chart, this.chart.mData2);
                }
                this.chart.gt.select_axis = axisTab;
                this.chart.gt.cBorder = null;
                this.chart.gt.firstShown = true;
                this.chart.gt.paint();
                this.update();
                return;
            }
            this.cell = this.chart.gt.atCBorder(x, y);
            if (this.cell >= 0) {
                this.changeTableSize = true;
            }
            int seriesTab = this.chart.gt.atSeriesTab(x, y);
            if (this.chart.gt.atHead(x, y)) {
                this.setCursor(Cursor.getPredefinedCursor(13));
                this.changeTablePosition = true;
            }
            if (this.chart.gt.tabPanel && seriesTab >= 0) {
                this.chart.gt.select_tab = seriesTab;
                this.update();
                return;
            }
            this.tabNum = this.chart.gt.atTBorder(x, y);
            if (this.tabNum >= 0) {
                this.changeTabSize = true;
                this.chart.gt.dragged = true;
            }
        }
        this.b_doubleclick = false;
        if (this.chart == null) {
            return;
        }
        if (this.checkViewMode()) {
            return;
        }
        if (IOUtil.isRightMouseClicked(e) && this.mode == 2) {
            this.isPopupMenuEnabled = false;
            this.endLineMode();
            this.repaint();
            return;
        }
        if (this.mode == 3) {
            CAnnotation anno = TextDialog.saveAnno;
            Point_2D pos = null;
            pos = anno.getReferenceObject() instanceof Chart ? (this.chart.is2DChart ? new Point_2D((float)(x - this.chart.chartxorigin) / (float)this.width, (float)(this.height - y - this.chart.chartyorigin) / (float)this.height) : new Point_2D((float)(x - this.chart.chartxorigin) / (float)this.width, (float)(this.height - y - (this.height - this.chart.chartyorigin - this.chart.chartheight)) / (float)this.height)) : new Point_2D((float)x / (float)this.width, (float)(this.height - y) / (float)this.height);
            anno.setRelativePosition(pos);
            this.chart.addAnnotation(anno);
            TextDialog.saveAnno = null;
            if (this.fwindow instanceof ChartMain) {
                ((ChartMain)this.fwindow).setModified();
                ((ChartMain)this.fwindow).qbpaint();
            }
            this.setMode(0);
            this.setCursor(Cursor.getPredefinedCursor(0));
            if (this.fwindow instanceof ChartMain) {
                ((ChartMain)this.fwindow).statusBar.showHint("");
            }
            return;
        }
        if (this.mode == 2) {
            Vertex v;
            if (e.getX() < 0 || e.getY() < 0) {
                return;
            }
            if (e.getX() > this.prefWidth || e.getY() > this.prefHeight) {
                return;
            }
            if (!this.chart.is2DChart) {
                v = ((HiddenSurface)this.chart.gethiddenSurface()).pick3DPoint(x, y);
                if (v != null) {
                    this.vertexStatus.addElement(Boolean.TRUE);
                } else {
                    v = ((Space)this.chart.getSpace()).computeProjectVertex(new Vertex(), x, y);
                    this.vertexStatus.addElement(Boolean.FALSE);
                }
                ((Space)this.chart.getSpace()).transform(v);
            } else {
                v = this.transformCoord(x, y);
            }
            if (this.currLine.size() > 0) {
                Graphics g = this.getGraphics();
                g.setColor(Color.black);
                Vertex lastVertex = this.currLine.lastElement();
                g.setXORMode(Color.white);
                g.drawLine(lastVertex.screen_x + this.offsetWidth, lastVertex.screen_y + this.offsetHeight, this.lastMouseCoord.x + this.offsetWidth, this.lastMouseCoord.y + this.offsetHeight);
                g.setPaintMode();
                g.drawLine(lastVertex.screen_x + this.offsetWidth, lastVertex.screen_y + this.offsetHeight, v.screen_x + this.offsetWidth, v.screen_y + this.offsetHeight);
            }
            this.currLine.addElement(v);
            if (this.fwindow instanceof ChartMain) {
                ((ChartMain)this.fwindow).statusBar.showHint(LanguageEncoder.getText("Press right mouse button when done"));
            }
            return;
        }
        long currtime = System.currentTimeMillis();
        CGraphics g = this.chart.cgraphics;
        if (g != null) {
            this.selectobj = this.chart.select(g, x, y);
        }
        int dy = 0;
        if (this.chart.tableInPanel) {
            dy = this.chart.gt.y;
            if (this.chart.gt.tabPanel) {
                dy += this.chart.gt.tab_height;
            }
        }
        if (this.chart.tableInPanel && x > this.chart.gt.x && x < this.chart.gt.x + this.chart.gt.totalLength && y > dy && y < dy + this.chart.gt.getHeight() - this.chart.gt.tInterval) {
            this.selectobj = this.chart.gt;
            this.chart.gt.selectItem(x, y);
        }
        this.lastx = x;
        this.lasty = y;
        if (!this.isPopupTrigger) {
            this.isPopupTrigger = e.isPopupTrigger();
        }
        if ((this.doubleclick = (byte)(this.doubleclick + 1)) >= 2 && currtime - this.systime < 400L || e.getClickCount() >= 2) {
            this.doubleclick = 0;
            this.b_doubleclick = true;
            this.systime = currtime;
            if (this.fwindow instanceof ChartMain) {
                int i;
                ((ChartMain)this.fwindow).createBackupChart();
                if (this.selectobj instanceof MultiDimData && !IOUtil.isRightMouseClicked(e) && ((ChartMain)this.fwindow).isDrillDownDefined && ((ChartMain)this.fwindow).parentChart != null && ((ChartMain)this.fwindow).parentChart.isDrillDownDefined()) {
                    ((ChartMain)this.fwindow).nextDrillDown();
                    return;
                }
                if (this.selectobj instanceof MultiDimData && !IOUtil.isRightMouseClicked(e) && ((ChartMain)this.fwindow).isFieldDrillDownEnabled()) {
                    ((ChartMain)this.fwindow).nextFieldDrillDown();
                    return;
                }
                if (IOUtil.isRightMouseClicked(e) && ((ChartMain)this.fwindow).isDrillDownDefined) {
                    this.isPopupMenuEnabled = false;
                    ((ChartMain)this.fwindow).previousDrillDown();
                    return;
                }
                if (!(this.selectobj instanceof MultiDimData) && !(this.selectobj instanceof FaceData) && IOUtil.isRightMouseClicked(e)) {
                    this.isPopupMenuEnabled = false;
                    ((ChartMain)this.fwindow).do_goback();
                    return;
                }
                if (this.selectobj instanceof GraphicsTable) {
                    ((ChartMain)this.fwindow).do_TableDirection();
                    return;
                }
                if (this.selectobj == this.chart.legend.area || this.selectobj == this.chart.legend.framearea || this.selectobj == this.chart.legend) {
                    if (((ChartMain)this.fwindow).isDrillDownDefined && ((ChartMain)this.fwindow).parentChart != null && ((ChartMain)this.fwindow).parentChart.isDrillDownDefined()) {
                        ((ChartMain)this.fwindow).nextDrillDownFromLegend(x, y);
                        return;
                    }
                    if (((ChartMain)this.fwindow).isFieldDrillDownEnabled()) {
                        ((ChartMain)this.fwindow).nextFieldDrillDownFromLegend(x, y);
                        return;
                    }
                    if (this.chart.cgraphics.imagemap) {
                        ((ChartMain)this.fwindow).do_JumpLink(x, y);
                    } else {
                        ((ChartMain)this.fwindow).do_Legend(this.chart.legend);
                    }
                    return;
                }
                if (this.selectobj == this.chart.legend2.area || this.selectobj == this.chart.legend2.framearea || this.selectobj == this.chart.legend2) {
                    if (this.chart.cgraphics.imagemap) {
                        ((ChartMain)this.fwindow).do_JumpLink(x, y);
                    } else {
                        ((ChartMain)this.fwindow).do_Legend(this.chart.legend2);
                    }
                    return;
                }
                if (this.selectobj instanceof CAnnotation) {
                    ((ChartMain)this.fwindow).do_Text((CAnnotation)this.selectobj);
                    return;
                }
                if (this.selectobj == this.chart.topLabels) {
                    if (this.chart.chartType == 1 || this.chart.chartType == 5) {
                        ((ChartMain)this.fwindow).do_FormatValue(0);
                    } else {
                        ((ChartMain)this.fwindow).do_FormatValue(1);
                    }
                    return;
                }
                if (this.selectobj == this.chart.topLabels2) {
                    ((ChartMain)this.fwindow).do_FormatValue(3);
                    return;
                }
                for (i = 0; i < 4; ++i) {
                    if (this.selectobj == this.chart.axis[i]) {
                        if (this.chart.getChartType() == 19) {
                            ((ChartMain)this.fwindow).do_AxisDialog(0);
                        } else if (this.chart.axis[i].stepsize != null) {
                            ((ChartMain)this.fwindow).do_AxisDialog(i);
                        } else {
                            ((ChartMain)this.fwindow).do_DataOrder(i);
                        }
                        return;
                    }
                    if (this.selectobj == this.chart.axis[i].grid) {
                        ((ChartMain)this.fwindow).do_PointLine();
                        return;
                    }
                    if (this.selectobj != this.chart.axis[i].ticker) continue;
                    if (this.chart.axis[i].columnField.axisType == 7) {
                        ((ChartMain)this.fwindow).do_DataOrder(i);
                    } else {
                        ((ChartMain)this.fwindow).do_FormatValue(i);
                    }
                    return;
                }
                if ((this.chart.getChartType() == 14 || this.chart.getChartType() == 16) && this.chart.colDataAxis != null) {
                    for (i = 0; i < this.chart.colDataAxis.length; ++i) {
                        if (this.chart.colDataAxis[i] == null) continue;
                        if (this.selectobj == this.chart.colDataAxis[i]) {
                            if (this.chart.colDataAxis[i].stepsize != null) {
                                ((ChartMain)this.fwindow).do_AxisDialog(i + 4);
                            }
                            return;
                        }
                        if (this.selectobj == this.chart.colDataAxis[i].grid) {
                            ((ChartMain)this.fwindow).do_PointLine();
                            return;
                        }
                        if (this.selectobj != this.chart.colDataAxis[i].ticker) continue;
                        ((ChartMain)this.fwindow).do_FormatValue(i + 4);
                        return;
                    }
                }
                if (this.chart.chartType == 6) {
                    if (this.selectobj == ((IPieChart)((Object)this.chart)).getPieChart().pieLabel) {
                        ((ChartMain)this.fwindow).do_DataOrder();
                        return;
                    }
                    if (this.selectobj == ((IPieChart)((Object)this.chart)).getPieChart().pieValue) {
                        ((ChartMain)this.fwindow).do_FormatValue(1);
                        return;
                    }
                    if (this.selectobj == ((IPieChart)((Object)this.chart)).getPieChart().piePercent) {
                        ((ChartMain)this.fwindow).do_FormatValue(0);
                        return;
                    }
                }
                for (i = 0; i < this.chart.stringList.size(); ++i) {
                    PropCString str = (PropCString)this.chart.stringList.elementAt(i);
                    if (!str.select(g, x, y)) continue;
                    new EditTextDialog((ChartMain)this.fwindow, LanguageEncoder.getText("Edit Text"), this.chart.stringList, i).setVisible(true);
                    return;
                }
                for (i = 0; i < 4; ++i) {
                    if (this.selectobj != this.chart.axis[i].title) continue;
                    new EditTextDialog((ChartMain)this.fwindow, LanguageEncoder.getText("Edit Text"), this.chart.axis[i].title, 0).setVisible(true);
                    return;
                }
                if (this.selectobj == this.chart.mainTitle) {
                    new EditTextDialog((ChartMain)this.fwindow, LanguageEncoder.getText("Edit Text"), this.chart.mainTitle, 0).setVisible(true);
                    return;
                }
                if (this.selectobj == this.chart.background || this.selectobj == this.chart.border) {
                    ((ChartMain)this.fwindow).do_PlotArea();
                    return;
                }
                if (this.selectobj instanceof MultiDimData || this.selectobj instanceof FaceData) {
                    if (IOUtil.isRightMouseClicked(e)) {
                        this.isPopupMenuEnabled = false;
                        ((ChartMain)this.fwindow).do_DefineHyperLink(this.chart.pickdata, false);
                    } else {
                        ((ChartMain)this.fwindow).do_JumpLink();
                    }
                    return;
                }
                if (this.selectobj instanceof ControlRange) {
                    if (!this.chart.targetName.equals("Center")) {
                        ((ChartMain)this.fwindow).do_DefineControlRange((ControlRange)this.selectobj);
                    } else {
                        ((ChartMain)this.fwindow).do_ChartOption();
                    }
                    return;
                }
                if (this.selectobj instanceof TrendLine) {
                    ((ChartMain)this.fwindow).do_DefineTrendLine((TrendLine)this.selectobj);
                    return;
                }
                if (this.selectobj instanceof ControlLine) {
                    ((ChartMain)this.fwindow).do_DefineHorzVertLine((ControlLine)this.selectobj);
                    return;
                }
                if (this.selectobj instanceof HorzVertLine) {
                    ((ChartMain)this.fwindow).do_DefineHorzVertLine((HorzVertLine)this.selectobj);
                    return;
                }
                if (this.selectobj instanceof PolyLine) {
                    ((ChartMain)this.fwindow).do_PointLine();
                    return;
                }
                ((ChartMain)this.fwindow).do_ImageDialog();
                return;
            }
        }
        this.systime = currtime;
        if (IOUtil.isRightMouseClicked(e)) {
            if (this.selectobj instanceof FaceData && ((FaceData)this.selectobj).isSurfaceChart()) {
                this.eventObject = this.selectobj;
                this.fireEvent(this, 0);
                return;
            }
            if (this.selectobj instanceof MultiDimData) {
                this.eventObject = new HyperLink(this.chart.pickdata).findNewLink(this.chart.getHyperLinkList());
                if (this.eventObject != null) {
                    this.fireEvent(this, 0);
                }
            }
            return;
        }
        Color color = Color.white;
        if (this.selectobj instanceof FaceData && ((FaceData)this.selectobj).isSurfaceChart()) {
            color = this.chart.get3DSurfaceColor();
        } else if (this.selectobj instanceof MultiDimData) {
            color = this.chart.getDataColor((MultiDimData)this.selectobj);
        } else if (this.selectobj instanceof Axis) {
            Axis a = (Axis)this.selectobj;
            color = a.color;
        } else if (this.selectobj instanceof Area) {
            color = ((Area)this.selectobj).areaColor;
        } else if (this.selectobj instanceof Grid) {
            color = ((Grid)this.selectobj).color;
        } else if (this.selectobj instanceof Ticker) {
            Ticker ticker = (Ticker)this.selectobj;
            color = this.chart.targetName.indexOf(" axis label") >= 0 ? ticker.label[0].color : ticker.color;
        } else if (this.selectobj instanceof CString) {
            color = ((CString)this.selectobj).color;
        } else if (this.selectobj instanceof CString[]) {
            color = ((CString[])this.selectobj)[0].color;
        } else if (this.selectobj instanceof CString[][]) {
            color = ((CString[][])this.selectobj)[0][0].color;
        } else if (this.selectobj instanceof Legend) {
            color = ((Legend)this.selectobj).fontcolor;
        } else if (this.selectobj instanceof CAnnotation) {
            CAnnotation cAnno = (CAnnotation)this.selectobj;
            Object annoPart = cAnno.selectedObj;
            if (annoPart instanceof Area) {
                color = ((Area)annoPart).areaColor;
            } else if (annoPart instanceof CString) {
                color = cAnno.getfontColor();
            }
        } else if (this.selectobj == this.chart.topLabels) {
            color = ((CString)this.chart.topLabels.elementAt((int)0)).color;
        } else if (this.selectobj == this.chart.topLabels2) {
            color = ((CString)this.chart.topLabels2.elementAt((int)0)).color;
        } else if (this.selectobj instanceof DataLine) {
            color = ((DataLine)this.selectobj).getColor();
        } else if (this.selectobj instanceof ControlRange) {
            color = ((ControlRange)this.selectobj).getColor();
        } else if (this.selectobj instanceof PolyLine && this.chart.targetName.equals("line")) {
            color = ((PolyLine)this.selectobj).getColor();
        }
        if (this.chart.inside(x, y) || this.isOnElementCursor(x, y)) {
            LOGGER.finest("MOUSE PRESSED - SHOULD SHOW BOUNDING BOX");
            if (this.chart.is2DimChart()) {
                this.newChartX = this.chart.chart_XProp;
                this.newChartY = this.chart.chart_YProp;
                this.newChartWidth = this.chart.chart_widthProp;
                this.newChartHeight = this.chart.chart_heightProp;
            } else {
                this.chart.computeBoundingBox();
                this.newxboundmin = this.chart.xboundmin;
                this.newyboundmin = this.chart.yboundmin;
                this.newxboundmax = this.chart.xboundmax;
                this.newyboundmax = this.chart.yboundmax;
                this.newChartWidth = this.chart.chart_widthProp;
                this.newChartHeight = this.chart.chart_heightProp;
            }
            if (this.fwindow instanceof ChartMain) {
                ((ChartMain)this.fwindow).createBackupChart();
            }
            this.initBackImage();
            if (!(this.selectobj instanceof MultiDimData || this.selectobj instanceof FaceData || this.selectobj instanceof DataLine || this.selectobj == this.chart.topLabels || this.selectobj == this.chart.topLabels2)) {
                this.drawFrame();
            }
        } else {
            this.repaint();
            this.dashRectVisible = false;
        }
        this.eventObject = color;
        this.fireEvent(this, 0);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.animation) {
            return;
        }
        int x = e.getX() - this.offsetWidth;
        int y = e.getY() - this.offsetHeight;
        if (this.b_doubleclick || this.chart == null) {
            return;
        }
        if (this.checkViewMode()) {
            return;
        }
        if (this.mode != 0) {
            return;
        }
        if (Math.abs(this.lastx - x) < 3 && Math.abs(this.lasty - y) < 3) {
            return;
        }
        if (this.chart.tableInPanel) {
            if (this.changeTableSize) {
                int change = x - this.lastx;
                if (this.cell < this.chart.gt.cBorder.length) {
                    this.chart.gt.cBorder[this.cell] = Math.max(0, this.chart.gt.cBorder[this.cell] + change);
                    this.update();
                }
                this.lastx = x;
                return;
            }
            if (this.changeTabSize) {
                int change = x - this.lastx;
                this.chart.gt.tBorder[this.tabNum] = Math.max(0, this.chart.gt.tBorder[this.tabNum] + change);
                this.update();
                this.lastx = x;
                return;
            }
            if (this.changeTablePosition) {
                this.chart.gt.relX = -1.0f;
                this.chart.gt.relY = -1.0f;
                int changex = this.chart.gt.ox + x - this.lastx;
                int changey = this.chart.gt.oy + y - this.lasty;
                this.chart.gt.rect = true;
                this.chart.gt.ox = changex;
                this.chart.gt.oy = changey;
                this.lastx = x;
                this.lasty = y;
            }
        }
        if (x <= 5 || x >= this.width - 5 || y <= 5 || y >= this.height - 5) {
            return;
        }
        if (!this.draginit) {
            int i;
            if (this.fwindow instanceof ChartMain) {
                ((ChartMain)this.fwindow).createBackupChart();
            }
            this.dragtarget = null;
            CGraphics g = new CGraphics(null, null, this.height, this.width, this.chart);
            if (this.dragtarget == null && !IOUtil.isRightMouseClicked(e) && this.chart.legend.select(g, x, y) != null) {
                this.old_XProp = this.chart.legend_XProp;
                this.old_YProp = this.chart.legend_YProp;
                this.dragtarget = this.chart.legend;
                this.chart.legend.showLegend = false;
                this.initBackImage();
                this.chart.legend.showLegend = true;
            } else if (this.chart.showLegend2() && this.dragtarget == null && !IOUtil.isRightMouseClicked(e) && this.chart.legend2.select(g, x, y) != null) {
                this.old_XProp = this.chart.legend2_XProp;
                this.old_YProp = this.chart.legend2_YProp;
                this.dragtarget = this.chart.legend2;
                this.chart.legend2.showLegend = false;
                this.initBackImage();
                this.chart.legend2.showLegend = true;
            } else if (this.dragtarget == null && !IOUtil.isRightMouseClicked(e) && (this.dragtarget = CAnnotation.select(g, x, y)) != null) {
                CAnnotation anno = (CAnnotation)this.dragtarget;
                Point_2D pos = anno.getRelativePosition();
                this.old_XProp = pos.x;
                this.old_YProp = pos.y;
                anno.setVisible(false);
                this.initBackImage();
                anno.setVisible(true);
            }
            if (!this.chart.isCircularChart()) {
                if (this.dragtarget == null && !IOUtil.isRightMouseClicked(e)) {
                    for (i = 0; i < 4; ++i) {
                        if (this.chart.axis[i].title.bshow && this.chart.axis[i].title.select(g, x, y)) {
                            this.dragtarget = this.chart.axis[i];
                            this.old_XProp = ((Axis)this.dragtarget).titleoffset;
                            this.old_YProp = ((Axis)this.dragtarget).titlevoffset;
                            this.selAxis = this.chart.axis[i];
                            break;
                        }
                        if (!this.chart.axis[i].showTitleTicker || (this.labelIndex = CString.selectStringIndex(g, x, y, this.chart.axis[i].ticker.label)) < 0 || i == 3 && !this.chart.showSecAxis()) continue;
                        this.dragtarget = this.chart.axis[i].ticker;
                        if (this.chart.getChartType() == 16 && i == 0 || this.chart.getChartType() == 19 && i == 0 || this.chart.getChartType() == 17 && i == 1) {
                            Dimension dim = this.chart.getLabelOffset(this.labelIndex);
                            this.old_XProp = dim.width;
                            this.old_YProp = dim.height;
                        } else {
                            this.old_XProp = ((Ticker)this.dragtarget).twidth;
                            this.old_YProp = ((Ticker)this.dragtarget).displacement;
                        }
                        this.selAxis = this.chart.axis[i];
                        break;
                    }
                    if (this.dragtarget == null && this.chart.colDataAxis != null && (this.chart.getChartType() == 14 || this.chart.getChartType() == 16 && !this.chart.isSynchronizeRadarAxis())) {
                        for (i = 0; i < this.chart.colDataAxis.length; ++i) {
                            if (this.chart.colDataAxis[i] == null) continue;
                            if (this.chart.colDataAxis[i].title.bshow && this.chart.colDataAxis[i].title.select(g, x, y)) {
                                this.dragtarget = this.chart.colDataAxis[i];
                                this.old_XProp = ((Axis)this.dragtarget).titleoffset;
                                this.old_YProp = ((Axis)this.dragtarget).titlevoffset;
                                this.selAxis = this.chart.colDataAxis[i];
                                break;
                            }
                            if (!this.chart.colDataAxis[i].showTitleTicker || (this.labelIndex = CString.selectStringIndex(g, x, y, this.chart.colDataAxis[i].ticker.label)) < 0) continue;
                            this.dragtarget = this.chart.colDataAxis[i].ticker;
                            if (this.chart.getChartType() == 16 && i != 0) {
                                this.old_XProp = ((Ticker)this.dragtarget).radarXOffset;
                                this.old_YProp = ((Ticker)this.dragtarget).radarYOffset;
                            } else {
                                this.old_XProp = ((Ticker)this.dragtarget).twidth;
                                this.old_YProp = ((Ticker)this.dragtarget).displacement;
                            }
                            this.selAxis = this.chart.colDataAxis[i];
                            break;
                        }
                    }
                    if (this.dragtarget != null && !IOUtil.isRightMouseClicked(e)) {
                        this.selAxis.ticker.showText = false;
                        this.selAxis.title.bshow = false;
                        this.initBackImage();
                        this.selAxis.ticker.showText = true;
                        this.selAxis.title.bshow = true;
                    }
                }
                if (this.dragtarget == null && this.chart.selectTopLabel(g, x, y) != null && !IOUtil.isRightMouseClicked(e)) {
                    this.dragtarget = this.chart.topLabels;
                    if (this.chart.is2DChart) {
                        this.old_YProp = this.chart.toplabel_offset_up;
                        this.old_XProp = this.chart.toplabel_offset_side;
                    } else {
                        this.old_YProp = this.chart.toplabel_offset3D_up;
                        this.old_XProp = this.chart.toplabel_offset3D_side;
                    }
                    this.chart.showTopValue = false;
                    this.initBackImage();
                    this.chart.showTopValue = true;
                } else if (this.dragtarget == null && this.chart.selectTopLabel2(g, x, y) != null && !IOUtil.isRightMouseClicked(e)) {
                    this.dragtarget = this.chart.topLabels2;
                    if (this.chart.is2DChart) {
                        this.old_YProp = this.chart.toplabel2_offset_up;
                        this.old_XProp = this.chart.toplabel2_offset_side;
                    } else {
                        this.old_YProp = this.chart.toplabel2_offset3D_up;
                        this.old_XProp = this.chart.toplabel2_offset3D_side;
                    }
                    this.chart.setTopValueState2(false);
                    this.initBackImage();
                    this.chart.setTopValueState2(true);
                }
            } else if (this.dragtarget == null && (this.dragtarget = ((IPieChart)((Object)this.chart)).getPieChart().selectPieLabel(g, x, y)) != null) {
                boolean oldlabel = ((IPieChart)((Object)this.chart)).getPieChart().showLabel;
                boolean oldvalue = ((IPieChart)((Object)this.chart)).getPieChart().showValue;
                boolean oldpercent = ((IPieChart)((Object)this.chart)).getPieChart().showPercent;
                boolean oldcat = ((IPieChart)((Object)this.chart)).getPieChart().showCategory;
                ((IPieChart)((Object)this.chart)).getPieChart().showLabel = false;
                ((IPieChart)((Object)this.chart)).getPieChart().showValue = false;
                ((IPieChart)((Object)this.chart)).getPieChart().showPercent = false;
                ((IPieChart)((Object)this.chart)).getPieChart().showCategory = false;
                this.initBackImage();
                ((IPieChart)((Object)this.chart)).getPieChart().showPercent = oldpercent;
                ((IPieChart)((Object)this.chart)).getPieChart().showLabel = oldlabel;
                ((IPieChart)((Object)this.chart)).getPieChart().showValue = oldvalue;
                ((IPieChart)((Object)this.chart)).getPieChart().showCategory = oldcat;
                this.old_XProp = this.chart.targetstr.xoffset;
                this.old_YProp = this.chart.targetstr.yoffset;
            }
            if (this.dragtarget == null && this.chart.mainTitle.select(g, x, y) && !IOUtil.isRightMouseClicked(e)) {
                this.old_XProp = this.chart.title_XProp;
                this.old_YProp = this.chart.title_YProp;
                this.dragtarget = this.chart.mainTitle;
                this.chart.mainTitle.bshow = false;
                this.initBackImage();
                this.chart.mainTitle.bshow = true;
            }
            if (this.dragtarget == null && !IOUtil.isRightMouseClicked(e)) {
                for (i = 0; i < this.chart.stringList.size(); ++i) {
                    PropCString str = (PropCString)this.chart.stringList.elementAt(i);
                    if (!str.select(g, x, y)) continue;
                    this.old_XProp = str.xprop;
                    this.old_YProp = str.yprop;
                    this.dragtarget = str;
                    this.chart.showStringList = false;
                    this.initBackImage();
                    this.chart.showStringList = true;
                    break;
                }
            }
            if (this.dragtarget == null && this.selectobj instanceof GraphicsTable) {
                this.dragtarget = this.chart.gt;
                this.initBackImage();
            }
            if (this.dragtarget == null && (this.chart.inside(x, y) || this.isOnElementCursor(x, y))) {
                if (this.fwindow instanceof ChartMain) {
                    ((ChartMain)this.fwindow).createBackupChart();
                }
                if (IOUtil.isRightMouseClicked(e)) {
                    this.old_XProp = this.chart.chart_widthProp;
                    this.old_YProp = this.chart.chart_heightProp;
                } else {
                    this.old_XProp = this.chart.chart_XProp;
                    this.old_YProp = this.chart.chart_YProp;
                }
                this.old_xboundmin = this.chart.xboundmin;
                this.old_yboundmin = this.chart.yboundmin;
                this.old_xboundmax = this.chart.xboundmax;
                this.old_yboundmax = this.chart.yboundmax;
                this.dragtarget = this.chart;
                this.initBackImage();
            }
            if (this.dragtarget == null) {
                return;
            }
            this.draginit = true;
            if (this.isOnElementCursor(x, y)) {
                this.dragstate = true;
                this.lastx = x;
                this.lasty = y;
                this.drawFrame();
                return;
            }
            this.dragstate = IOUtil.isRightMouseClicked(e);
            this.lastx = x;
            this.lasty = y;
            this.drawFrame();
            this.setCursor(this.dragstate ? new Cursor(5) : new Cursor(13));
            return;
        }
        if (this.dragstate) {
            if (this.dragtarget == this.chart) {
                if (this.cursorDirection == -1) {
                    float tempWidth = this.chart.chart_widthProp * (float)this.width + (float)(x - this.lastx);
                    float tempHeight = this.chart.chart_heightProp * (float)this.height + (float)(y - this.lasty);
                    int minSize = 100;
                    if (tempWidth < (float)minSize) {
                        tempWidth = 100.0f;
                    }
                    this.newChartWidth = tempWidth / (float)this.width;
                    if (tempHeight < (float)minSize) {
                        tempHeight = 100.0f;
                    }
                    this.newChartHeight = tempHeight / (float)this.height;
                } else {
                    this.setChartPosition(x, y);
                }
            }
        } else if (this.dragtarget == this.chart) {
            this.chart.chart_XProp = this.old_XProp + (float)(x - this.lastx) / (float)this.width;
            this.chart.chart_YProp = this.old_YProp + (float)(y - this.lasty) / (float)this.height;
            if (this.chart.gt.direction == 2) {
                this.chart.gt.x = (int)((float)this.chart.winWidth * this.chart.chart_XProp + (float)this.chart.aTCX);
                this.chart.gt.y = (int)((float)this.chart.winHeight * (this.chart.chart_YProp + this.chart.chart_heightProp) + (float)this.chart.aTCY);
            } else {
                this.chart.gt.x = (int)((float)this.chart.winWidth * (this.chart.chart_XProp + this.chart.chart_widthProp) + (float)this.chart.aTCX);
                this.chart.gt.y = (int)((float)this.chart.winHeight * this.chart.chart_YProp + (float)this.chart.aTCY);
            }
        } else if (this.dragtarget == this.chart.legend) {
            this.chart.legend_XProp = this.old_XProp + (float)(x - this.lastx) / (float)this.width;
            this.chart.legend_YProp = this.old_YProp - (float)(y - this.lasty) / (float)this.height;
            this.chart.legend.setpos((int)((float)this.chart.winWidth * this.chart.legend_XProp), (int)((float)this.chart.winHeight * this.chart.legend_YProp));
        } else if (this.dragtarget == this.chart.legend2) {
            this.chart.legend2_XProp = this.old_XProp + (float)(x - this.lastx) / (float)this.width;
            this.chart.legend2_YProp = this.old_YProp - (float)(y - this.lasty) / (float)this.height;
            this.chart.legend2.setpos((int)((float)this.chart.winWidth * this.chart.legend2_XProp), (int)((float)this.chart.winHeight * this.chart.legend2_YProp));
        } else if (this.dragtarget instanceof CAnnotation) {
            Point_2D newPos = new Point_2D(this.old_XProp + (float)(x - this.lastx) / (float)this.width, this.old_YProp - (float)(y - this.lasty) / (float)this.height);
            ((CAnnotation)this.dragtarget).setRelativePosition(newPos);
        } else if (this.dragtarget == this.chart.topLabels) {
            if (this.chart.is2DChart) {
                if (this.chart.chartType == 1 || this.chart.chartType == 5) {
                    this.chart.toplabel_offset_up = this.chart.isLabelOnNegativeSide() ? (int)(this.old_YProp + (float)(this.lastx - x)) : (int)(this.old_YProp + (float)(x - this.lastx));
                    this.chart.toplabel_offset_side = (int)(this.old_XProp + (float)(this.lasty - y));
                } else {
                    this.chart.toplabel_offset_up = this.chart.isLabelOnNegativeSide() ? (int)(this.old_YProp + (float)(y - this.lasty)) : (int)(this.old_YProp + (float)(this.lasty - y));
                    this.chart.toplabel_offset_side = (int)(this.old_XProp + (float)(x - this.lastx));
                }
            } else if (this.chart.chartType == 1 || this.chart.chartType == 5) {
                this.chart.toplabel_offset3D_up = this.chart.isLabelOnNegativeSide() ? (int)(this.old_YProp + (float)((this.lastx - x) * 3)) : (int)(this.old_YProp + (float)((x - this.lastx) * 3));
                this.chart.toplabel_offset3D_side = (int)(this.old_XProp + (float)((this.lasty - y) * 3));
            } else {
                this.chart.toplabel_offset3D_up = this.chart.isLabelOnNegativeSide() ? (int)(this.old_YProp + (float)((y - this.lasty) * 3)) : (int)(this.old_YProp + (float)((this.lasty - y) * 3));
                this.chart.toplabel_offset3D_side = (int)(this.old_XProp + (float)((x - this.lastx) * 3));
            }
            this.chart.prepareLabel(false);
        } else if (this.dragtarget == this.chart.topLabels2) {
            if (this.chart.is2DChart) {
                if (this.chart.chartType == 1 || this.chart.chartType == 5) {
                    this.chart.toplabel2_offset_up = (int)(this.old_YProp + (float)(x - this.lastx));
                    this.chart.toplabel2_offset_side = (int)(this.old_XProp + (float)(this.lasty - y));
                } else {
                    this.chart.toplabel2_offset_up = (int)(this.old_YProp + (float)(this.lasty - y));
                    this.chart.toplabel2_offset_side = (int)(this.old_XProp + (float)(x - this.lastx));
                }
            } else if (this.chart.chartType == 1 || this.chart.chartType == 5) {
                this.chart.toplabel2_offset3D_up = (int)(this.old_YProp + (float)((x - this.lastx) * 3));
                this.chart.toplabel2_offset3D_side = (int)(this.old_XProp + (float)((this.lasty - y) * 3));
            } else {
                this.chart.toplabel2_offset3D_up = (int)(this.old_YProp + (float)((this.lasty - y) * 3));
                this.chart.toplabel2_offset3D_side = (int)(this.old_XProp + (float)((x - this.lastx) * 3));
            }
            this.chart.prepareLabel(false);
        } else if (this.dragtarget == this.chart.mainTitle) {
            this.chart.title_XProp = this.old_XProp + (float)(x - this.lastx) / (float)this.width;
            this.chart.title_YProp = this.old_YProp - (float)(y - this.lasty) / (float)this.height;
            this.chart.mainTitle.setpos(new Point3D((int)((float)this.chart.winWidth * this.chart.title_XProp), (int)((float)this.chart.winHeight * this.chart.title_YProp)));
        } else if (this.dragtarget instanceof PropCString) {
            ((PropCString)this.dragtarget).xprop = this.old_XProp + (float)(x - this.lastx) / (float)this.chart.chartwidth;
            ((PropCString)this.dragtarget).yprop = this.old_YProp - (float)(y - this.lasty) / (float)this.chart.chartheight;
        } else if (this.dragtarget instanceof Ticker) {
            if (this.labelIndex >= 0 && this.selAxis == this.chart.axis[0] && (this.chart.getChartType() == 16 || this.chart.getChartType() == 19) || this.selAxis == this.chart.axis[1] && this.chart.getChartType() == 17) {
                Dimension dim = new Dimension((int)(this.old_XProp + (float)(x - this.lastx)), (int)(this.old_YProp + (float)(y - this.lasty)));
                this.chart.setLabelOffset(this.labelIndex, dim);
            } else {
                Ticker tk = (Ticker)this.dragtarget;
                if (tk.axis.orient == 0 || ((Ticker)this.dragtarget).axis.orient == 3 && (this.chart.chartType == 1 || this.chart.chartType == 5)) {
                    tk.twidth = tk.reverseSide || tk.onTop ? (int)(this.old_XProp - (float)(y - this.lasty)) : (int)(this.old_XProp + (float)(y - this.lasty));
                    tk.displacement = (int)(this.old_YProp + (float)(x - this.lastx));
                } else if (this.chart.getChartType() == 16 && !this.chart.isSynchronizeRadarAxis() && tk.axis != this.chart.colDataAxis[0]) {
                    tk.radarXOffset = (int)(this.old_XProp - (float)(x - this.lastx));
                    tk.radarYOffset = (int)(this.old_YProp - (float)(y - this.lasty));
                } else {
                    tk.twidth = tk.reverseSide ? (int)(this.old_XProp + (float)(x - this.lastx)) : (int)(this.old_XProp - (float)(x - this.lastx));
                    tk.displacement = (int)(this.old_YProp - (float)(y - this.lasty));
                }
            }
        } else if (this.chart.isCircularChart() && (this.dragtarget == ((IPieChart)((Object)this.chart)).getPieChart().pieLabel || this.dragtarget == ((IPieChart)((Object)this.chart)).getPieChart().pieValue || this.dragtarget == ((IPieChart)((Object)this.chart)).getPieChart().catLabel || this.dragtarget == ((IPieChart)((Object)this.chart)).getPieChart().piePercent)) {
            if (this.chart.is2DChart) {
                float pw = ((IPieChart)((Object)this.chart)).getPieChart().piewidth[0];
                float ph = ((IPieChart)((Object)this.chart)).getPieChart().pieheight[0];
                this.chart.targetstr.xoffset = this.old_XProp + (float)(x - this.lastx) / pw;
                this.chart.targetstr.yoffset = this.old_YProp + (float)(this.lasty - y) / ph;
            } else {
                float pw = ((IPieChart)((Object)this.chart)).getPieChart().piewidth[0] / 2;
                float ph = ((IPieChart)((Object)this.chart)).getPieChart().pieheight[0] / 2;
                this.chart.targetstr.xoffset = this.old_XProp + (float)(x - this.lastx) / pw;
                this.chart.targetstr.yoffset = this.old_YProp + (float)(this.lasty - y) / ph;
            }
        } else if (this.dragtarget instanceof Axis) {
            if (((Axis)this.dragtarget).orient == 3) {
                ((Axis)this.dragtarget).titleoffset = (int)(this.old_XProp + (float)(x - this.lastx));
                ((Axis)this.dragtarget).titlevoffset = (int)(this.old_YProp - (float)(y - this.lasty));
            } else if (((Axis)this.dragtarget).orient == 0) {
                ((Axis)this.dragtarget).titleoffset = (int)(this.old_XProp + (float)(y - this.lasty));
                ((Axis)this.dragtarget).titlevoffset = (int)(this.old_YProp + (float)(x - this.lastx));
            } else {
                ((Axis)this.dragtarget).titleoffset = (int)(this.old_XProp - (float)(x - this.lastx));
                ((Axis)this.dragtarget).titlevoffset = (int)(this.old_YProp - (float)(y - this.lasty));
            }
        }
        this.drawFrame();
    }

    private void initBackImage() {
        if (this.offScreenImage2 == null || this.offScreenImage2.getHeight(null) != this.height || this.offScreenImage2.getWidth(null) != this.width) {
            if (this.offScreenImage != null) {
                this.offScreenImage.flush();
            }
            this.offScreenImage2 = this.createImage(this.width, this.height);
            this.backbuffer2 = this.offScreenImage2.getGraphics();
        }
        this.chart.draw(this.backbuffer2);
    }

    private void drawFrame() {
        if (this.dragtarget != this.chart && this.dragtarget != null) {
            CGraphics g = new CGraphics(this.backbuffer, this, this.height, this.width, this.chart);
            g.chart = this.chart;
            this.backbuffer.drawImage(this.offScreenImage2, 0, 0, this);
            this.dashRectVisible = false;
            if (this.dragtarget == this.chart.topLabels || this.dragtarget == this.chart.topLabels2) {
                if (this.chart.is2DChart) {
                    this.chart.drawLabel(g);
                } else {
                    this.chart.drawLabel3D(g);
                }
            } else if (this.dragtarget == this.chart.mainTitle) {
                this.chart.mainTitle.draw(g);
            } else if (this.dragtarget instanceof Axis || this.dragtarget instanceof Ticker) {
                if (this.selAxis == this.chart.axis[0] && this.chart.getChartType() == 16 || this.selAxis == this.chart.axis[0] && this.chart.getChartType() == 19 || this.selAxis == this.chart.axis[1] && this.chart.getChartType() == 17) {
                    boolean arrowState = this.chart.showArrow;
                    if (this.chart.getChartType() == 16 || this.chart.getChartType() == 19) {
                        this.chart.showArrow = false;
                    }
                    boolean showAxis = this.selAxis.bshow;
                    if (this.chart.getChartType() == 17) {
                        this.selAxis.bshow = false;
                    }
                    this.chart.drawAxis(g, this.selAxis);
                    if (this.chart.getChartType() == 16 || this.chart.getChartType() == 19) {
                        this.chart.showArrow = arrowState;
                    }
                    if (this.chart.getChartType() == 17) {
                        this.selAxis.bshow = showAxis;
                    }
                } else if (this.chart.getChartType() == 16 && !this.chart.isSynchronizeRadarAxis() && this.selAxis != this.chart.colDataAxis[0]) {
                    this.chart.drawTickerForRadar(g, this.selAxis);
                } else {
                    this.selAxis.drawAxisTitle(g);
                    this.selAxis.drawTicker(g);
                }
            } else if (this.dragtarget instanceof PropCString) {
                this.chart.drawStringList(g);
            } else if (this.dragtarget == this.chart.legend) {
                this.chart.legend.draw(g);
            } else if (this.dragtarget == this.chart.legend2) {
                this.chart.legend2.draw(g);
            } else if (this.dragtarget instanceof CAnnotation) {
                ((CAnnotation)this.dragtarget).draw(g);
            } else if (this.chart.isCircularChart() && (this.dragtarget == ((IPieChart)((Object)this.chart)).getPieChart().pieLabel || this.dragtarget == ((IPieChart)((Object)this.chart)).getPieChart().pieValue || this.dragtarget == ((IPieChart)((Object)this.chart)).getPieChart().catLabel || this.dragtarget == ((IPieChart)((Object)this.chart)).getPieChart().piePercent)) {
                ((IPieChart)((Object)this.chart)).getPieChart().drawLabel(g);
            } else if (this.dragtarget instanceof GraphicsTable) {
                int adx = 0;
                if (this.chart.tableInPanel && !this.chart.gt.clear && this.chart.gt.tabPanel) {
                    adx = this.chart.gt.tab_height;
                }
                this.backbuffer.setColor(Color.black);
                this.backbuffer.drawRect(this.chart.gt.ox, this.chart.gt.oy + adx, this.chart.gt.totalLength, this.chart.gt.rrow * this.chart.gt.heightPerCell);
            }
        } else {
            this.backbuffer.drawImage(this.offScreenImage2, 0, 0, this);
            this.dashRectVisible = false;
            if (this.chart.border.areaColor.equals(this.chart.desktopArea.areaColor)) {
                Color c = this.chart.desktopArea.areaColor;
                this.backbuffer.setColor(new Color(255 - c.getRed(), 255 - c.getGreen(), 55 - c.getBlue()));
            } else {
                this.backbuffer.setColor(this.chart.border.areaColor);
            }
            if (this.chart.is2DChart) {
                if (this.dragstate) {
                    int x = (int)((float)this.width * this.chart.chart_XProp);
                    int y = (int)((float)this.height * this.chart.chart_YProp);
                    if (this.cursorDirection != -1) {
                        x = (int)((float)this.width * this.newChartX);
                        y = (int)((float)this.height * this.newChartY);
                    }
                    int h = (int)((float)this.height * this.newChartHeight);
                    int w = (int)((float)this.width * this.newChartWidth);
                    if (this.cursorDirection != -1) {
                        int minSize = 100;
                        if (this.cursorDirection == 32 || this.cursorDirection == 4 || this.cursorDirection == 1) {
                            if (w < minSize) {
                                w = 100;
                                this.newChartWidth = (float)w / (float)this.width;
                            }
                        } else if ((this.cursorDirection == 64 || this.cursorDirection == 0 || this.cursorDirection == 2) && w < minSize) {
                            w = 100;
                            if (this.chart.is2DimChart()) {
                                x = (int)((this.chart.chart_XProp + this.chart.chart_widthProp) * (float)this.width) - w;
                                this.newChartX = (float)x / (float)this.width;
                                this.newChartWidth = (float)w / (float)this.width;
                            }
                        }
                        if (this.cursorDirection == 16 || this.cursorDirection == 4 || this.cursorDirection == 2) {
                            if (h < minSize) {
                                h = 100;
                                this.newChartHeight = (float)h / (float)this.height;
                            }
                        } else if ((this.cursorDirection == 8 || this.cursorDirection == 1 || this.cursorDirection == 0) && h < minSize) {
                            h = 100;
                            if (this.chart.is2DimChart()) {
                                y = (int)((this.chart.chart_YProp + this.chart.chart_heightProp) * (float)this.height) - h;
                                this.newChartY = (float)y / (float)this.height;
                                this.newChartHeight = (float)h / (float)this.height;
                            }
                        }
                    }
                    this.drawDashRect(x, y, w, h, this.backbuffer);
                } else {
                    int h = (int)((float)this.height * this.chart.chart_heightProp);
                    int w = (int)((float)this.width * this.chart.chart_widthProp);
                    this.drawDashRect((int)((float)this.width * this.chart.chart_XProp), (int)((float)this.height * this.chart.chart_YProp), w, h, this.backbuffer);
                }
            } else {
                int oldWidth = this.chart.xboundmax - this.chart.xboundmin;
                int oldHeight = this.chart.yboundmax - this.chart.yboundmin;
                float oldRatio = (float)oldWidth / (float)oldHeight;
                if (this.dragstate) {
                    LOGGER.finest("DrawFrame:  RESIZE 3D...");
                    if (this.cursorDirection == -1) {
                        int newWidth = this.chart.xboundmax - this.chart.xboundmin + (int)((this.newChartWidth - this.chart.chart_widthProp) * (float)this.width);
                        int newHeight = this.chart.yboundmax - this.chart.yboundmin + (int)((this.newChartHeight - this.chart.chart_heightProp) * (float)this.height);
                        float newRatio = (float)newWidth / (float)newHeight;
                        if (newRatio > oldRatio) {
                            newWidth = (int)((float)(oldWidth * newHeight) / (float)oldHeight);
                        } else if (newRatio < oldRatio) {
                            newHeight = (int)((float)(oldHeight * newWidth) / (float)oldWidth);
                        }
                        this.drawDashRect(this.chart.xboundmin, this.chart.yboundmin, newWidth, newHeight, this.backbuffer);
                    } else {
                        int minSize = 100;
                        if (this.newxboundmax - this.newxboundmin < minSize) {
                            switch (this.cursorDirection) {
                                case 0: {
                                    this.newxboundmin = this.newxboundmax - minSize;
                                    break;
                                }
                                case 1: {
                                    this.newxboundmax = this.newxboundmin + minSize;
                                    break;
                                }
                                case 2: {
                                    this.newxboundmin = this.newxboundmax - minSize;
                                    break;
                                }
                                case 4: {
                                    this.newxboundmax = this.newxboundmin + minSize;
                                    break;
                                }
                                default: {
                                    LOGGER.fine("UNKNOWN POSITION = " + this.cursorDirection);
                                }
                            }
                        }
                        if (this.newyboundmax - this.newyboundmin < minSize) {
                            switch (this.cursorDirection) {
                                case 0: {
                                    this.newyboundmin = this.newyboundmax - minSize;
                                    break;
                                }
                                case 1: {
                                    this.newyboundmin = this.newyboundmax - minSize;
                                    break;
                                }
                                case 2: {
                                    this.newyboundmax = this.newyboundmin + minSize;
                                    break;
                                }
                                case 4: {
                                    this.newyboundmax = this.newyboundmin + minSize;
                                    break;
                                }
                                default: {
                                    LOGGER.fine("UNKNOWN POSITION = " + this.cursorDirection);
                                }
                            }
                        }
                        this.newChartWidth = (float)(this.newxboundmax - this.newxboundmin - (this.chart.xboundmax - this.chart.xboundmin)) / (float)this.width + this.chart.chart_widthProp;
                        this.newChartHeight = (float)(this.newyboundmax - this.newyboundmin - (this.chart.yboundmax - this.chart.yboundmin)) / (float)this.height + this.chart.chart_heightProp;
                        this.drawDashRect(this.newxboundmin, this.newyboundmin, this.newxboundmax - this.newxboundmin, this.newyboundmax - this.newyboundmin, this.backbuffer);
                    }
                } else {
                    this.chart.computeBoundingBox();
                    this.drawDashRect(this.chart.xboundmin, this.chart.yboundmin, this.chart.xboundmax - this.chart.xboundmin, this.chart.yboundmax - this.chart.yboundmin, this.backbuffer);
                }
            }
            this.chart.validatePosition();
        }
        Graphics graphics = this.getGraphics();
        graphics.drawImage(this.offScreenImage, this.offsetWidth, this.offsetHeight, this.width, this.height, this);
        graphics.dispose();
    }

    private void drawDashRect(int x, int y, int w, int h, Graphics g) {
        this.drawDashRect(x, y, w, h, null, g);
    }

    private void drawDashRect(int x, int y, int w, int h, boolean[] corners, Graphics g) {
        if (this.chart.chartType == 17) {
            int[] pos = this.customizePositionForDial(x, y, w, h);
            x = pos[0];
            y = pos[1];
            w = pos[2];
            h = pos[3];
        }
        this.lastDashRectX = x;
        this.lastDashRectY = y;
        this.lastDashRectW = w;
        this.lastDashRectH = h;
        this.dashRectVisible = true;
        this.drawRectHandles(x, y, w, h, corners, g);
        int wSpan = w + x;
        int hSpan = h + y;
        int x0 = x;
        while (x < wSpan) {
            g.drawLine(x, y, x + 2, y);
            g.drawLine(x, y + h, x + 2, y + h);
            x += 5;
        }
        x = x0;
        while (y < hSpan) {
            g.drawLine(x, y, x, y + 2);
            g.drawLine(x + w, y, x + w, y + 2);
            y += 5;
        }
    }

    private void drawRectHandles(int x, int y, int w, int h, boolean[] corners, Graphics g) {
        if (this.chart.is2DimChart() && !this.isCircularRatioChart(this.chart)) {
            if (corners == null || corners[1]) {
                g.fillRect(x + w / 2 - 2, y - 1, 5, 5);
            }
            if (corners == null || corners[6]) {
                g.fillRect(x + w / 2 - 2, y + h - 3, 5, 5);
            }
            if (corners == null || corners[3]) {
                g.fillRect(x - 1, y + h / 2 - 2, 5, 5);
            }
            if (corners == null || corners[4]) {
                g.fillRect(x + w - 3, y + h / 2 - 2, 5, 5);
            }
        }
        if (corners == null || corners[2]) {
            g.fillRect(x + w - 3, y - 1, 5, 5);
        }
        if (corners == null || corners[0]) {
            g.fillRect(x - 1, y - 1, 5, 5);
        }
        if (corners == null || corners[5]) {
            g.fillRect(x - 1, y + h - 3, 5, 5);
        }
        if (corners == null || corners[7]) {
            g.fillRect(x + w - 3, y + h - 3, 5, 5);
        }
    }

    private int[] customizePositionForDial(int x, int y, int w, int h) {
        int xboundmin = x;
        int xboundmax = x + w;
        int yboundmin = y;
        int yboundmax = y + h;
        LOGGER.finest("OLD X MIN " + xboundmin + ", MAX " + xboundmax);
        LOGGER.finest("OLD Y MIN " + yboundmin + ", MAX " + yboundmax);
        double startingAngle = this.chart.getStartAngleForDial();
        double endingAngle = this.chart.getEndAngleForDial();
        switch (this.isAdjacentSection(startingAngle, endingAngle)) {
            case 1: {
                xboundmin += w / 2;
                break;
            }
            case 2: {
                yboundmin += h / 2;
                break;
            }
            case 3: {
                xboundmax -= w / 2;
                break;
            }
            case 0: {
                yboundmax -= h / 2;
                break;
            }
        }
        LOGGER.finest("NEW X MIN " + xboundmin + ", MAX " + xboundmax);
        LOGGER.finest("NEW Y MIN " + yboundmin + ", MAX " + yboundmax);
        return new int[]{xboundmin, yboundmin, xboundmax - xboundmin, yboundmax - yboundmin};
    }

    private int isAdjacentSection(double angle1, double angle2) {
        int sec1 = this.getSection(angle1);
        int sec2 = this.getSection(angle2);
        if (sec1 < 5 && sec2 < 5) {
            if (sec2 - sec1 == 1) {
                if (sec1 == 1) {
                    return 1;
                }
                if (sec1 == 2) {
                    return 2;
                }
                if (sec1 == 3) {
                    return 3;
                }
            }
            if (sec1 == 4 && sec2 == 1) {
                return 0;
            }
        }
        if (angle1 > angle2) {
            angle2 += 360.0;
        }
        if (angle2 - angle1 > 90.0 && angle2 - angle1 <= 180.0) {
            if (sec1 == 1 || sec1 == 5) {
                return 1;
            }
            if (sec1 == 2 || sec1 == 6) {
                return 2;
            }
            if (sec1 == 3 || sec1 == 7) {
                return 3;
            }
            if (sec1 == 4 || sec1 == 8) {
                return 0;
            }
        }
        return -1;
    }

    private int getSection(double angle) {
        if (angle == 0.0 || angle == 360.0) {
            return 5;
        }
        if (angle == 90.0) {
            return 6;
        }
        if (angle == 180.0) {
            return 7;
        }
        if (angle == 270.0) {
            return 8;
        }
        if (angle > 0.0 && angle < 90.0) {
            return 1;
        }
        if (angle > 90.0 && angle < 180.0) {
            return 2;
        }
        if (angle > 180.0 && angle < 270.0) {
            return 3;
        }
        if (angle > 270.0 && angle < 360.0) {
            return 4;
        }
        return -1;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.animation) {
            return;
        }
        if (this.chart == null) {
            return;
        }
        if (this.chart.tableInPanel) {
            if (this.changeTablePosition) {
                this.chart.gt.rect = false;
                this.chart.gt.x = this.chart.gt.ox;
                this.chart.gt.y = this.chart.gt.oy;
                this.draginit = false;
                this.dragtarget = null;
                this.paint();
            }
            if ((this.changeTableSize || this.changeTabSize || this.changeTablePosition) && this.fwindow instanceof ChartMain) {
                ((ChartMain)this.fwindow).setModified();
            }
            this.changeTableSize = false;
            this.changeTabSize = false;
            this.changeTablePosition = false;
        }
        if (this.draginit) {
            this.draginit = false;
            this.setCursor(new Cursor(0));
            if (this.dragtarget == this.chart && this.chart.gt != null) {
                this.chart.gt.relX = -1.0f;
                this.chart.gt.relY = -1.0f;
            }
            if (this.dragstate) {
                if (this.newChartWidth != 0.0f && this.newChartHeight != 0.0f) {
                    this.chart.reCalculateAnnotationTextPosition(this.chart.chart_widthProp, this.newChartWidth, this.chart.chart_heightProp, this.newChartHeight);
                    if (this.chart.is2DimChart()) {
                        if (this.cursorDirection != -1) {
                            this.chart.chart_XProp = this.newChartX;
                            this.chart.chart_YProp = this.newChartY;
                        }
                        this.chart.chart_widthProp = this.newChartWidth;
                        this.chart.chart_heightProp = this.newChartHeight;
                    } else {
                        if (this.cursorDirection != -1) {
                            this.chart.computeBoundingBox();
                        }
                        this.chart.chart_widthProp = this.newChartWidth;
                        this.chart.chart_heightProp = this.newChartHeight;
                        this.chart.computeBoundingBox();
                        float xDelta = 0.0f;
                        float yDelta = 0.0f;
                        switch (this.cursorDirection) {
                            case 0: {
                                xDelta = (float)(this.chart.xboundmax - this.old_xboundmax) / (float)this.chart.winWidth;
                                this.chart.chart_XProp -= xDelta;
                                yDelta = (float)(this.chart.yboundmax - this.old_yboundmax) / (float)this.chart.winHeight;
                                this.chart.chart_YProp -= yDelta;
                                break;
                            }
                            case 1: {
                                xDelta = (float)(this.chart.xboundmin - this.old_xboundmin) / (float)this.chart.winWidth;
                                this.chart.chart_XProp -= xDelta;
                                yDelta = (float)(this.chart.yboundmax - this.old_yboundmax) / (float)this.chart.winHeight;
                                this.chart.chart_YProp -= yDelta;
                                break;
                            }
                            case 2: {
                                yDelta = (float)(this.chart.yboundmin - this.old_yboundmin) / (float)this.chart.winHeight;
                                this.chart.chart_YProp -= yDelta;
                                xDelta = (float)(this.chart.xboundmax - this.old_xboundmax) / (float)this.chart.winWidth;
                                this.chart.chart_XProp -= xDelta;
                                break;
                            }
                            case 4: {
                                xDelta = (float)(this.chart.xboundmin - this.old_xboundmin) / (float)this.chart.winWidth;
                                this.chart.chart_XProp -= xDelta;
                                yDelta = (float)(this.chart.yboundmin - this.old_yboundmin) / (float)this.chart.winHeight;
                                this.chart.chart_YProp -= yDelta;
                                break;
                            }
                        }
                        this.old_xboundmin = 0;
                        this.old_yboundmin = 0;
                        this.old_xboundmax = 0;
                        this.old_yboundmax = 0;
                        this.chart.newSurface();
                    }
                    this.dragtarget = null;
                    this.repaint();
                }
            } else if (this.dragtarget == this.chart && this.chart.is2DChart) {
                this.repaint();
            } else if (this.dragtarget == this.chart.topLabels || this.dragtarget == this.chart.topLabels2) {
                if (this.chart.is2DChart) {
                    this.paint();
                } else {
                    ((HiddenSurface)this.chart.gethiddenSurface()).reset();
                    this.repaint();
                }
            } else {
                this.paint();
            }
            this.dragtarget = null;
            if (this.fwindow instanceof ChartMain) {
                ((ChartMain)this.fwindow).setModified();
            }
            return;
        }
        if (!this.isPopupTrigger) {
            this.isPopupTrigger = e.isPopupTrigger();
        }
        if (this.isPopupTrigger && this.isPopupMenuEnabled) {
            this.isPopupTrigger = false;
            if (this.fwindow != null) {
                this.popupMenu.addMenu((ChartMain)this.fwindow);
                this.popupMenu.show(this, e.getX(), e.getY());
            }
        }
        this.isPopupTrigger = false;
        this.isPopupMenuEnabled = true;
    }

    void do_AddLine() {
        this.setMode(2);
        this.currLine = new Vector();
    }

    private void endLineMode() {
        if (this.mode != 2) {
            return;
        }
        Graphics g = this.getGraphics();
        int size = this.currLine.size();
        if (this.lastMouseCoord.x != -1 && this.lastMouseCoord.y != -1 && size > 0) {
            Vertex v = this.currLine.lastElement();
            g.setXORMode(Color.white);
            g.drawLine(v.screen_x, v.screen_y, this.lastMouseCoord.x, this.lastMouseCoord.y);
            g.setPaintMode();
        }
        if (size > 1) {
            if (!this.chart.is2DChart) {
                Vertex v1 = null;
                for (int i = 0; i < size; ++i) {
                    if (this.vertexStatus.elementAt(i).booleanValue()) {
                        v1 = this.currLine.elementAt(i);
                        continue;
                    }
                    Vertex v = this.currLine.elementAt(i);
                    Vertex v2 = null;
                    for (int j = i + 1; j < size; ++j) {
                        if (!this.vertexStatus.elementAt(j).booleanValue()) continue;
                        v2 = this.currLine.elementAt(j);
                        break;
                    }
                    if (v1 == null) {
                        if (v2 == null) continue;
                        v2 = ((Space)this.chart.getSpace()).computeProjectVertex(v2, v.screen_x, v.screen_y);
                        v.x = v2.x;
                        v.y = v2.y;
                        v.z = v2.z;
                        continue;
                    }
                    v2 = v2 != null ? ((Space)this.chart.getSpace()).computeProjectVertex(v1, v2, v.screen_x, v.screen_y) : ((Space)this.chart.getSpace()).computeProjectVertex(v1, v.screen_x, v.screen_y);
                    v.x = v2.x;
                    v.y = v2.y;
                    v.z = v2.z;
                }
            }
            this.chart.addLine(this.currLine);
        }
        this.setMode(0);
        this.currLine = null;
        this.lastMouseCoord.x = -1;
        this.lastMouseCoord.y = -1;
        this.vertexStatus.removeAllElements();
        this.setCursor(new Cursor(0));
        if (this.fwindow instanceof ChartMain) {
            ((ChartMain)this.fwindow).statusBar.showHint("");
        }
    }

    private boolean checkViewMode() {
        return this.fwindow instanceof ChartMain && ((ChartMain)this.fwindow).viewmode;
    }

    @Override
    public void displayHint(String s) {
        if (this.fwindow instanceof ChartMain) {
            ((ChartMain)this.fwindow).showHint(s);
        }
    }

    public Object getValue() {
        return this.eventObject;
    }
}

