/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.TitledBorder;
import quadbase.chart.designer.ChartMain;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;

public class ChartToolbar
extends JToolBar
implements ActionListener {
    private static final Logger LOGGER = Logger.getLogger(ChartToolbar.class.getName());
    ChartMain chartmain;
    public static final int NEW = 0;
    public static final int SAVE = 1;
    public static final int OPEN = 2;
    public static final int EXPORT = 3;
    public static final int MAPPING = 4;
    public static final int RELOAD = 5;
    public static final int PERIODRELOAD = 6;
    public static final int HELP = 7;
    public static final int ADDTEXT = 8;
    public static final int ADDBACKGROUND = 9;
    public static final int ADDLINE = 10;
    public static final int REMOVE = 11;
    public static final int FORMATAXIS = 12;
    public static final int FORMATVALUE = 13;
    public static final int FORMATLEGEND = 14;
    public static final int DATAORDER = 15;
    public static final int QUERY = 16;
    public static final int DATAPROPERTIES = 18;
    public static final int CHARTOPTIONS = 19;
    public static final int LINEANDPOINTS = 20;
    public static final int UNDO = 21;
    public static final int REDO = 22;
    public static final int NBUTTON = 23;
    JButton[] button;
    boolean[] enableSave;

    ChartToolbar(ChartMain chartmain) {
        this.setFloatable(false);
        this.chartmain = chartmain;
        this.button = new JButton[23];
        this.enableSave = new boolean[23];
        this.setBorder(new TitledBorder(""));
        if (chartmain.isForBean) {
            this.button[2] = new JButton();
            this.addNewButton(this.button[2], LanguageEncoder.getText("Open chart"), "OPEN_FILE", "OpenIcon.png");
            this.addSeparator();
        } else if (chartmain.isUsingReportToolBar()) {
            this.addSaveAndExportToolbarIcons();
            this.addSeparator();
        } else {
            this.button[0] = new JButton();
            this.addNewButton(this.button[0], LanguageEncoder.getText("New chart"), "NEW_FILE", "NewIcon.png");
            this.button[2] = new JButton();
            this.addNewButton(this.button[2], LanguageEncoder.getText("Open chart"), "OPEN_FILE", "OpenIcon.png");
            this.addSeparator();
            this.addSaveAndExportToolbarIcons();
            this.addSeparator();
        }
        this.button[21] = new JButton();
        this.addNewButton(this.button[21], LanguageEncoder.getText("Undo"), "UNDO", "UndoIcon.png");
        this.button[22] = new JButton();
        this.addNewButton(this.button[22], LanguageEncoder.getText("Redo"), "REDO", "RedoIcon.png");
        this.addSeparator();
        this.button[4] = new JButton();
        this.addNewButton(this.button[4], LanguageEncoder.getText("Change data mapping"), "MAPPING", "DataMappingIcon.png");
        this.button[18] = new JButton();
        this.addNewButton(this.button[18], LanguageEncoder.getText("Change data properties"), "DATAPROPERTIES", "DataPropertiesIcon.png");
        this.button[19] = new JButton();
        this.addNewButton(this.button[19], LanguageEncoder.getText("Change chart options"), "CHARTOPTIONS", "ChartOptionsIcon.png");
        this.button[20] = new JButton();
        this.addNewButton(this.button[20], LanguageEncoder.getText("Format line and points"), "LINEANDPOINTS", "FormatLineAndPointsIcon.png");
        this.button[12] = new JButton();
        this.addNewButton(this.button[12], LanguageEncoder.getText("Format axis scale"), "FORMAT_AXIS", "FormatAxisScaleIcon.png");
        this.button[13] = new JButton();
        this.addNewButton(this.button[13], LanguageEncoder.getText("Format value elements"), "FORMATVALE", "FormatAxisElementsIcon.png");
        this.button[14] = new JButton();
        this.addNewButton(this.button[14], LanguageEncoder.getText("Format legend"), "FORMATLEGEND", "LegendIcon.png");
        this.button[15] = new JButton();
        this.addNewButton(this.button[15], LanguageEncoder.getText("Change data ordering"), "DATAORDER", "DataOrderingIcon.png");
        this.addSeparator();
        this.button[8] = new JButton();
        this.addNewButton(this.button[8], LanguageEncoder.getText("Add text"), "ALL_TEXT", "AddTextIcon.png");
        this.button[10] = new JButton();
        this.addNewButton(this.button[10], LanguageEncoder.getText("Add line"), "ALL_LINE", "AddLineIcon.png");
        this.button[9] = new JButton();
        this.addNewButton(this.button[9], LanguageEncoder.getText("Change background image"), "ADD_BACKGROUND", "AddBackgroundImageIcon.png");
        if (chartmain.isForBean) {
            this.addSeparator();
            this.button[16] = new JButton();
            this.addNewButton(this.button[16], LanguageEncoder.getText("Modify data source"), "QUERY", "ChangeDataSourceIcon.png");
            this.button[5] = new JButton();
            this.addNewButton(this.button[5], LanguageEncoder.getText("Refresh data source"), "RELOAD", "ReloadIcon.png");
        } else if (!chartmain.isUsingReportToolBar()) {
            this.addSeparator();
            this.button[16] = new JButton();
            this.addNewButton(this.button[16], LanguageEncoder.getText("Modify data source"), "QUERY", "ChangeDataSourceIcon.png");
            this.button[5] = new JButton();
            this.addNewButton(this.button[5], LanguageEncoder.getText("Refresh data source"), "RELOAD", "ReloadIcon.png");
            this.button[6] = new JButton();
            this.addNewButton(this.button[6], LanguageEncoder.getText("Schedule refresh"), "PERIODRELOAD", "ScheduleReloadIcon.png");
        }
    }

    private void addSaveAndExportToolbarIcons() {
        this.button[1] = new JButton();
        this.addNewButton(this.button[1], LanguageEncoder.getText("Save chart"), "SAVE_FILE", "SaveIcon.png");
        this.button[3] = new JButton();
        if (!this.chartmain.isSaas()) {
            this.addNewButton(this.button[3], LanguageEncoder.getText("Export chart"), "EXPORT_FILE", "ExportIcon.png");
        }
    }

    private void addNewButton(JButton newBtn, String tip, String command, String img) {
        img = ServerMessage.imagesPath + img;
        try {
            this.setIcon(newBtn, img);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error loading image icon: " + img, e);
        }
        this.add(newBtn);
        newBtn.setToolTipText(tip);
        newBtn.setMargin(new Insets(0, 3, 0, 3));
        newBtn.addActionListener(this);
        newBtn.setActionCommand(command);
    }

    private void setIcon(AbstractButton b, String img) throws MalformedURLException {
        b.setIcon(IOUtil.getImageIcon(img));
    }

    public void setEnabled(int index, boolean state) {
        JButton target = this.button[index];
        if (target != null) {
            target.setEnabled(state);
        }
    }

    public void setAllEnabledWithSave(boolean state) {
        for (int i = 0; i < this.button.length; ++i) {
            JButton target = this.button[i];
            if (target == null) continue;
            if (state) {
                target.setEnabled(this.enableSave[i]);
                continue;
            }
            this.enableSave[i] = target.isEnabled();
            target.setEnabled(false);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton target = (JButton)e.getSource();
        this.chartmain.createBackupChart();
        if (target == this.button[1]) {
            this.chartmain.onDocSave();
        } else if (target == this.button[2]) {
            this.chartmain.do_Open();
        } else if (target == this.button[0]) {
            this.chartmain.do_New();
        } else if (target == this.button[3]) {
            this.chartmain.do_Export();
        } else if (target == this.button[21]) {
            this.chartmain.do_undo();
        } else if (target == this.button[22]) {
            this.chartmain.do_redo();
        } else if (target == this.button[4]) {
            this.chartmain.do_ChangeDataMappingOption(this.chartmain.isShowReportDataHasChangedDialog());
        } else if (target == this.button[5]) {
            this.chartmain.do_Refresh();
        } else if (target == this.button[8]) {
            this.chartmain.do_Text();
        } else if (target == this.button[11]) {
            this.chartmain.do_Remove();
        } else if (target == this.button[12]) {
            this.chartmain.do_AxisDialog();
        } else if (target == this.button[6]) {
            this.chartmain.do_PeriodicRefresh();
        } else if (target == this.button[15]) {
            this.chartmain.do_DataOrder();
        } else if (target == this.button[13]) {
            this.chartmain.do_FormatValue();
        } else if (target == this.button[14]) {
            this.chartmain.do_Legend();
        } else if (target == this.button[10]) {
            this.chartmain.do_AddLine();
        } else if (target == this.button[9]) {
            this.chartmain.do_ImageDialog();
        } else if (target == this.button[16]) {
            this.chartmain.doQuery();
        } else if (target == this.button[18]) {
            this.chartmain.do_DataProp();
        } else if (target == this.button[19]) {
            this.chartmain.do_ChartOption();
        } else if (target == this.button[20]) {
            this.chartmain.do_PointLine();
        }
    }
}

