/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import quadbase.chart.Chart;
import quadbase.chart.ReadDataFile;
import quadbase.chart.designer.ApplyGaugeTemplateDialog;
import quadbase.chart.designer.YAStatusBar;
import quadbase.common.client.ReadURL;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.CanShowHint;
import quadbase.common.swing.PanelAction;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;

public class ChartType
extends PanelAction
implements ItemListener,
ChangeListener {
    private static final Logger LOGGER = Logger.getLogger(ChartType.class.getName());
    int width = 600;
    int height = 500;
    int gWidth = 450;
    int gHeight = 380;
    boolean bcompute = true;
    Chart chart;
    int chartType = 0;
    JRadioButton[] chart2DBut;
    JRadioButton[] chart3DBut;
    int currentGaugeTab;
    int selectedGaugeTab;
    int[] chart2DButMap;
    int[] chart3DButMap;
    int[] chart2DButReverseMap;
    int[] chart3DButReverseMap;
    JButton cancel;
    JButton button2dim;
    JButton button3dim;
    JButton buttonNext;
    JButton buttonprev;
    JRadioButton checkbox2dim;
    JRadioButton checkbox3dim;
    JRadioButton gaugestyle;
    JTabbedPane gaugeTabbedPane;
    int chartStyle = 0;
    boolean isPrevGauge = false;
    CardLayout cardlayout;
    JPanel cardpanel;
    JPanel gaugePanel;
    JPanel[] gaugeTabs;
    ButtonGroup checkbox_group;
    CanShowHint statusBar;
    boolean eventDone = true;
    String gaugeTemplate = "";
    boolean is2DChart = true;
    JScrollPane[] gaugeScrollPane;
    public static final int CHART2D = 0;
    public static final int CHART3D = 1;
    public static final int CHARTGAUGE = 2;
    public static String[] GAUGETYPE = new String[]{"Circular/", "Square/", "Semicircular/", "QuarterCircle/", "Misc/", "Custom/"};
    private static int[] gaugeCount;
    private static JRadioButton[][] gaugeBut;
    private static String[][] gaugeMap;
    private static Hashtable[] gaugeReverseMap;
    QbDialog wizard;

    public ChartType(QbDialog wizard) {
        this.wizard = wizard;
        wizard.setResizable(false);
    }

    public void init(boolean bprevButton) {
        int i;
        Applet applet = ServerMessage.getApplet();
        this.chart2DBut = new JRadioButton[20];
        this.chart3DBut = new JRadioButton[14];
        this.chart2DButMap = new int[20];
        this.chart3DButMap = new int[14];
        this.chart2DButReverseMap = new int[21];
        this.chart3DButReverseMap = new int[21];
        this.statusBar = new YAStatusBar();
        try {
            int buttonIndex = 0;
            ButtonGroup bg2D = new ButtonGroup();
            for (int i2 = 0; i2 < 21; ++i2) {
                if (!Chart.isValidChartType(true, i2)) continue;
                String img = ServerMessage.imagesPath + "ch2d" + i2 + ".gif";
                String selimg = ServerMessage.imagesPath + "sel_ch2d" + i2 + ".gif";
                this.chart2DBut[buttonIndex] = new JRadioButton(IOUtil.getImageIcon(img));
                this.chart2DBut[buttonIndex].setSelectedIcon(IOUtil.getImageIcon(selimg));
                this.chart2DButMap[buttonIndex] = i2;
                this.chart2DButReverseMap[i2] = buttonIndex;
                this.chart2DBut[buttonIndex].setToolTipText(LanguageEncoder.getText("2D") + " " + Chart.stypeName[i2] + " " + LanguageEncoder.getText("Chart"));
                this.chart2DBut[buttonIndex].setMargin(new Insets(0, 0, 0, 0));
                bg2D.add(this.chart2DBut[buttonIndex]);
                this.chart2DBut[buttonIndex++].addActionListener(this);
            }
            buttonIndex = 0;
            ButtonGroup bg3D = new ButtonGroup();
            for (int i3 = 0; i3 < 21; ++i3) {
                if (!Chart.isValidChartType(false, i3)) continue;
                String img = ServerMessage.imagesPath + "ch3d" + i3 + ".gif";
                String selimg = ServerMessage.imagesPath + "sel_ch3d" + i3 + ".gif";
                this.chart3DBut[buttonIndex] = new JRadioButton(IOUtil.getImageIcon(img));
                this.chart3DBut[buttonIndex].setSelectedIcon(IOUtil.getImageIcon(selimg));
                this.chart3DButMap[buttonIndex] = i3;
                this.chart3DButReverseMap[i3] = buttonIndex;
                this.chart3DBut[buttonIndex].setToolTipText(LanguageEncoder.getText("3D") + " " + Chart.stypeName[i3] + " " + LanguageEncoder.getText("Chart"));
                this.chart3DBut[buttonIndex].setMargin(new Insets(0, 0, 0, 0));
                bg3D.add(this.chart3DBut[buttonIndex]);
                this.chart3DBut[buttonIndex++].addActionListener(this);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Failed to initialize GUI", ex);
        }
        this.buttonprev = new JButton(LanguageEncoder.getText("<< Back"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.buttonNext = new JButton(LanguageEncoder.getText("Next >>"));
        this.buttonprev.addActionListener(this);
        this.buttonNext.addActionListener(this);
        this.cancel.addActionListener(this);
        JPanel sspanel = new JPanel();
        sspanel.setLayout(new GridLayout(5, 4));
        JPanel sspanel2 = new JPanel();
        sspanel2.setLayout(new GridLayout(4, 4));
        this.gaugePanel = new JPanel();
        this.gaugePanel.add(this.initGaugeTabs(this));
        this.currentGaugeTab = -1;
        this.selectedGaugeTab = -1;
        for (i = 0; i < 20; ++i) {
            sspanel.add(this.chart2DBut[i]);
        }
        for (i = 0; i < 14; ++i) {
            sspanel2.add(this.chart3DBut[i]);
        }
        JScrollPane scrollpanel2 = new JScrollPane();
        scrollpanel2.setSize(this.width, this.height);
        scrollpanel2.getViewport().add(sspanel2);
        JScrollPane scrollpanel = new JScrollPane();
        scrollpanel.setSize(this.width, this.height);
        scrollpanel.getViewport().add(sspanel);
        BorderPanel paneldim = new BorderPanel(LanguageEncoder.getText("Styles"));
        paneldim.setLayout(new GridLayout(3, 1));
        this.checkbox_group = new ButtonGroup();
        this.checkbox2dim = new JRadioButton(LanguageEncoder.getText("2D") + "       ", true);
        this.checkbox3dim = new JRadioButton(LanguageEncoder.getText("3D") + "       ", false);
        this.gaugestyle = new JRadioButton(LanguageEncoder.getText("Gauges") + "       ", false);
        this.checkbox_group.add(this.checkbox2dim);
        this.checkbox_group.add(this.checkbox3dim);
        this.checkbox_group.add(this.gaugestyle);
        this.checkbox3dim.addItemListener(this);
        this.checkbox2dim.addItemListener(this);
        this.gaugestyle.addItemListener(this);
        paneldim.add(this.checkbox2dim);
        paneldim.add(this.checkbox3dim);
        paneldim.add(this.gaugestyle);
        JPanel dpanel = new JPanel();
        dpanel.setLayout(new BorderLayout());
        dpanel.add("North", paneldim);
        JPanel panelbutton = new JPanel();
        panelbutton.setLayout(new FlowLayout(2));
        if (bprevButton) {
            panelbutton.add(this.buttonprev);
        }
        panelbutton.add(this.cancel);
        panelbutton.add(this.buttonNext);
        BorderPanel spanel = new BorderPanel(LanguageEncoder.getText("Sample"));
        BorderPanel spanel2 = new BorderPanel(LanguageEncoder.getText("Sample"));
        spanel2.setLayout(new BorderLayout());
        spanel2.add("Center", scrollpanel2);
        spanel.setLayout(new BorderLayout());
        spanel.add("Center", scrollpanel);
        this.cardpanel = new JPanel();
        this.cardlayout = new CardLayout();
        this.cardpanel.setLayout(this.cardlayout);
        this.cardlayout.addLayoutComponent(spanel, "2dpanel");
        this.cardlayout.addLayoutComponent(spanel2, "3dpanel");
        this.cardlayout.addLayoutComponent(this.gaugePanel, "gaugepanel");
        this.cardpanel.add((Component)spanel, "2dpanel");
        this.cardpanel.add((Component)spanel2, "3dpanel");
        this.cardpanel.add((Component)this.gaugePanel, "gaugepanel");
        this.showcard(2);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add("Center", this.cardpanel);
        mainPanel.add("East", dpanel);
        mainPanel.add("South", panelbutton);
        this.setLayout(new BorderLayout());
        this.add("Center", mainPanel);
        this.add("South", (Component)((Object)this.statusBar));
        this.setBackground(Color.lightGray);
        this.chart2DBut[this.chart2DButReverseMap[this.chartType]].setSelected(true);
    }

    JTabbedPane initGaugeTabs(Object listener) {
        if (this.gaugeTabbedPane == null) {
            this.gaugeTabbedPane = new JTabbedPane();
        } else {
            for (int i = 0; i < ((ChangeListener[])this.gaugeTabbedPane.getListeners(ChangeListener.class)).length; ++i) {
                this.gaugeTabbedPane.removeChangeListener(((ChangeListener[])this.gaugeTabbedPane.getListeners(ChangeListener.class))[i]);
            }
        }
        if (this.gaugeTabs == null) {
            this.gaugeTabs = new JPanel[6];
        }
        String[] typeNames = new String[]{LanguageEncoder.getText("Circular"), LanguageEncoder.getText("Square"), LanguageEncoder.getText("Semi"), LanguageEncoder.getText("Quarter"), LanguageEncoder.getText("Misc"), LanguageEncoder.getText("Custom")};
        this.gaugeScrollPane = new JScrollPane[this.gaugeTabs.length];
        for (int i = 0; i < this.gaugeTabs.length; ++i) {
            this.gaugeTabs[i] = new JPanel();
            this.gaugeTabs[i].setSize(this.width, this.height);
            this.gaugeScrollPane[i] = new JScrollPane();
            this.gaugeScrollPane[i].setPreferredSize(new Dimension(this.gWidth, this.gHeight));
            this.gaugeScrollPane[i].getViewport().add(this.gaugeTabs[i]);
            BorderPanel tempPanel = new BorderPanel(LanguageEncoder.getText("Sample"));
            tempPanel.setSize(this.width, this.height);
            tempPanel.setLayout(new BorderLayout());
            tempPanel.add("Center", this.gaugeScrollPane[i]);
            this.gaugeTabbedPane.add(typeNames[i], tempPanel);
        }
        this.gaugeTabbedPane.addChangeListener((ChangeListener)listener);
        if (gaugeCount == null) {
            gaugeCount = new int[this.gaugeTabs.length];
        }
        if (gaugeBut == null) {
            gaugeBut = new JRadioButton[this.gaugeTabs.length][];
        }
        if (gaugeMap == null) {
            gaugeMap = new String[this.gaugeTabs.length][];
        }
        if (gaugeReverseMap == null) {
            gaugeReverseMap = new Hashtable[this.gaugeTabs.length];
        }
        return this.gaugeTabbedPane;
    }

    void loadGaugePanel(int panel, Object listener, int currentGaugeTab) {
        this.gaugeTabs[panel].removeAll();
        this.gaugeTabs[panel].add(new JLabel(LanguageEncoder.getText("Loading Templates...")));
        this.gaugeTabs[panel].repaint();
        LoadGaugePanelHelper helper = new LoadGaugePanelHelper(this, panel, this.chartType, listener, currentGaugeTab);
        helper.start();
    }

    private String[] getFileList(String dir, String[] extensions) {
        if (ServerMessage.useServer || !ServerMessage.isLoadBalancer) {
            return this.getFileListFromServer(dir, extensions);
        }
        return this.getFileListFromFileSystem(dir, extensions);
    }

    private String[] getFileListFromFileSystem(String dir, String[] extensions) {
        File directory = new File(dir);
        try {
            ImageFilenameFilter iff = new ImageFilenameFilter(extensions);
            String[] files = directory.list(iff);
            return files;
        }
        catch (Throwable t) {
            LOGGER.log(Level.WARNING, "Failed to get file list", t);
            return null;
        }
    }

    private String[] getFileListFromServer(String dir, String[] extensions) {
        try {
            String[] filenameList = ReadURL.getFilename(dir, extensions, "", false, false);
            return filenameList;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Cannot open URL", ex);
            return null;
        }
    }

    private void showcard(int panel2d) {
        this.cardlayout.show(this.cardpanel, panel2d == 2 ? "2dpanel" : (panel2d == 3 ? "3dpanel" : "gaugepanel"));
    }

    public void setType(int _chartType, boolean _is2DChart) {
        this.setType(_chartType, _is2DChart ? 0 : 1, "");
    }

    public void setType(int _chartType, boolean _is2DChart, String gaugeTemplate) {
        this.setType(_chartType, _is2DChart ? 0 : 1, gaugeTemplate);
    }

    public void setType(int _chartType, int _chartStyle, String gaugeTemplate) {
        if (_chartStyle == 0 && gaugeTemplate != null && gaugeTemplate.length() > 0) {
            Object val;
            int i;
            if (this.chartStyle != 2) {
                this.showcard(1);
                this.gaugestyle.setSelected(true);
            } else {
                for (i = 0; i < gaugeBut[this.currentGaugeTab].length; ++i) {
                    gaugeBut[this.currentGaugeTab][i].setSelected(false);
                }
            }
            for (i = 0; i < GAUGETYPE.length; ++i) {
                if (gaugeTemplate.indexOf("/" + GAUGETYPE[i]) <= -1) continue;
                this.gaugeTabbedPane.setSelectedIndex(i);
                break;
            }
            if ((val = gaugeReverseMap[this.currentGaugeTab].get(gaugeTemplate)) != null) {
                gaugeBut[this.currentGaugeTab][(Integer)val].setSelected(true);
                this.chartType = (Integer)val;
            } else {
                gaugeBut[this.currentGaugeTab][0].setSelected(true);
                this.chartType = 0;
            }
        } else if (_chartStyle == 0) {
            if (this.chartStyle != 0) {
                this.chart3DBut[this.chart3DButReverseMap[this.chartType]].setSelected(false);
                this.showcard(2);
                this.checkbox2dim.setSelected(true);
            } else {
                this.chart2DBut[this.chart2DButReverseMap[this.chartType]].setSelected(false);
            }
            this.chart2DBut[this.chart2DButReverseMap[_chartType]].setSelected(true);
            this.chartType = _chartType;
            this.chartStyle = _chartStyle;
        } else {
            if (this.chartStyle == 0) {
                this.chart2DBut[this.chart2DButReverseMap[this.chartType]].setSelected(false);
                this.showcard(3);
                this.checkbox3dim.setSelected(true);
            } else {
                this.chart3DBut[this.chart3DButReverseMap[this.chartType]].setSelected(false);
            }
            this.chart3DBut[this.chart3DButReverseMap[_chartType]].setSelected(true);
            this.chartType = _chartType;
            this.chartStyle = _chartStyle;
        }
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.eventDone) {
            return;
        }
        this.eventDone = false;
        Object target = e.getSource();
        if (this.chartStyle == 0) {
            for (int i = 0; i < 20; ++i) {
                if (target != this.chart2DBut[i]) continue;
                if (!this.isPrevGauge && this.chartType == this.chart2DButMap[i]) {
                    this.fireEvent(this.buttonNext, 0);
                    this.eventDone = true;
                    return;
                }
                this.chart2DBut[this.chart2DButReverseMap[this.chartType]].setSelected(false);
                this.chart2DBut[i].setSelected(true);
                this.chartType = this.chart2DButMap[i];
                this.isPrevGauge = false;
                target = this.buttonNext;
                this.eventDone = true;
                return;
            }
        } else if (this.chartStyle == 2) {
            for (int i = 0; i < gaugeCount[this.currentGaugeTab]; ++i) {
                if (target != gaugeBut[this.currentGaugeTab][i]) continue;
                if (this.isPrevGauge && this.chartType == i && this.selectedGaugeTab == this.currentGaugeTab) {
                    this.gaugeTemplate = gaugeMap[this.currentGaugeTab][this.chartType];
                    this.chartType = 17;
                    this.is2DChart = true;
                    this.fireEvent(this.buttonNext, 0);
                    this.eventDone = true;
                    return;
                }
                if (this.isPrevGauge && this.selectedGaugeTab == this.currentGaugeTab) {
                    gaugeBut[this.currentGaugeTab][this.chartType].setSelected(false);
                }
                gaugeBut[this.currentGaugeTab][i].setSelected(true);
                this.selectedGaugeTab = this.currentGaugeTab;
                this.chartType = i;
                this.isPrevGauge = true;
                target = this.buttonNext;
                this.eventDone = true;
                return;
            }
        } else {
            for (int i = 0; i < 14; ++i) {
                if (target != this.chart3DBut[i]) continue;
                if (this.isPrevGauge && this.chartType == this.chart3DButMap[i]) {
                    this.fireEvent(this.buttonNext, 0);
                    this.eventDone = true;
                    return;
                }
                this.chart3DBut[this.chart3DButReverseMap[this.chartType]].setSelected(false);
                this.chart3DBut[i].setSelected(true);
                this.chartType = this.chart3DButMap[i];
                this.isPrevGauge = false;
                target = this.buttonNext;
                this.eventDone = true;
                return;
            }
        }
        if (this.chartStyle == 2 && gaugeMap.length > this.currentGaugeTab && gaugeMap[this.currentGaugeTab] != null && gaugeMap[this.currentGaugeTab].length > this.chartType) {
            this.gaugeTemplate = gaugeMap[this.currentGaugeTab][this.chartType];
            this.chartType = 17;
            this.is2DChart = true;
            this.isPrevGauge = false;
        } else if (this.chartStyle != 2) {
            this.gaugeTemplate = "";
            this.is2DChart = this.chartStyle == 0;
            this.isPrevGauge = false;
        }
        if (this.wizard != null) {
            this.wizard.setResizable(true);
        }
        if (target == this.buttonprev && this.statusBar != null && ((YAStatusBar)this.statusBar).alarm != null) {
            ((YAStatusBar)this.statusBar).alarm.pleaseStop();
        }
        this.fireEvent((Component)target, 0);
        this.eventDone = true;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.checkbox2dim) {
            if (this.chartStyle == 0) {
                return;
            }
            if (this.chartStyle == 1) {
                this.chart3DBut[this.chart3DButReverseMap[this.chartType]].setSelected(false);
            } else if (this.chartStyle == 2 && this.currentGaugeTab > -1 && this.chartType > -1) {
                gaugeBut[this.currentGaugeTab][this.chartType].setSelected(false);
            }
            if (!Chart.isValidChartType(true, this.chartType)) {
                this.chartType = 0;
            }
            this.showcard(2);
            this.chartStyle = 0;
            if (this.chartType > this.chart2DButReverseMap.length) {
                this.chart2DBut[0].setSelected(true);
            } else {
                this.chart2DBut[this.chart2DButReverseMap[this.chartType]].setSelected(true);
            }
            this.isPrevGauge = false;
        } else if (e.getSource() == this.checkbox3dim) {
            if (this.chartStyle == 1) {
                return;
            }
            if (this.chartStyle == 0) {
                this.chart2DBut[this.chart2DButReverseMap[this.chartType]].setSelected(false);
            } else if (this.chartStyle == 2 && this.currentGaugeTab > -1 && this.chartType > -1) {
                gaugeBut[this.currentGaugeTab][this.chartType].setSelected(false);
            }
            if (!Chart.isValidChartType(false, this.chartType)) {
                this.chartType = 0;
            }
            this.showcard(3);
            this.chartStyle = 1;
            if (this.chartType > this.chart3DButReverseMap.length) {
                this.chart3DBut[0].setSelected(true);
            } else {
                this.chart3DBut[this.chart3DButReverseMap[this.chartType]].setSelected(true);
            }
            this.isPrevGauge = false;
        } else {
            if (this.chartStyle == 2) {
                return;
            }
            if (this.chartStyle == 1) {
                this.chart3DBut[this.chart3DButReverseMap[this.chartType]].setSelected(false);
            } else if (this.chartStyle == 0) {
                this.chart2DBut[this.chart2DButReverseMap[this.chartType]].setSelected(false);
            }
            this.showcard(1);
            int newTab = 0;
            if (this.currentGaugeTab >= 0) {
                newTab = this.currentGaugeTab;
            }
            this.loadGaugePanel(newTab, this, this.currentGaugeTab);
            this.currentGaugeTab = newTab;
            this.chartStyle = 2;
        }
        this.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        JTabbedPane pane = (JTabbedPane)evt.getSource();
        int sel = pane.getSelectedIndex();
        this.loadGaugePanel(sel, this, this.currentGaugeTab);
        this.currentGaugeTab = sel;
    }

    public JTabbedPane getGaugeTabbedPane() {
        return this.gaugeTabbedPane;
    }

    public JRadioButton[][] getGaugeButtons() {
        return gaugeBut;
    }

    public String[][] getGaugeMap() {
        return gaugeMap;
    }

    private class ImageFilenameFilter
    implements FilenameFilter {
        String[] extensions = null;

        public ImageFilenameFilter(String[] ext) {
            this.extensions = ext;
        }

        @Override
        public boolean accept(File dir, String name) {
            String filenameUpper = name.toUpperCase();
            for (String extension : this.extensions) {
                if (!filenameUpper.endsWith(extension.toUpperCase())) continue;
                return true;
            }
            return false;
        }
    }

    public class LoadGaugePanelHelper
    extends Thread {
        ChartType chartType;
        int panel;
        int chartTypeInd;
        int prevGaugeTab;
        Object listener;

        public LoadGaugePanelHelper(ChartType ct, int panel, int ctInd, Object listener, int prevGaugeTab) {
            this.chartType = ct;
            this.panel = panel;
            this.chartTypeInd = ctInd;
            this.listener = listener;
            this.prevGaugeTab = prevGaugeTab;
        }

        @Override
        public void run() {
            if (gaugeCount[this.panel] <= 0) {
                ButtonGroup bgGauge = new ButtonGroup();
                String gaugePrefix = "gauges/";
                String selImg = "screenshots/selected/";
                String img = "screenshots/unselected/";
                String[] imgs = ChartType.this.getFileList(gaugePrefix + img + GAUGETYPE[this.panel], new String[]{".GIF", ".JPG", ".JPEG", ".PNG"});
                if (imgs == null) {
                    if (ChartType.this.chartStyle == 2 && this.prevGaugeTab > -1 && this.chartTypeInd > -1 && gaugeBut[this.prevGaugeTab] != null && gaugeBut[this.prevGaugeTab][this.chartTypeInd] != null) {
                        gaugeBut[this.prevGaugeTab][this.chartTypeInd].setSelected(false);
                    }
                    this.chartType.gaugeTabs[this.panel].removeAll();
                    this.chartType.gaugeTabs[this.panel].repaint();
                    this.chartType.gaugeScrollPane[this.panel].repaint();
                    this.chartType.repaint();
                    if (this.listener instanceof ApplyGaugeTemplateDialog) {
                        ((ApplyGaugeTemplateDialog)this.listener).repaint();
                    }
                    return;
                }
                gaugeCount[this.panel] = imgs.length;
                gaugeBut[this.panel] = new JRadioButton[imgs.length];
                gaugeMap[this.panel] = new String[imgs.length];
                gaugeReverseMap[this.panel] = new Hashtable();
                for (int i = 0; i < imgs.length; ++i) {
                    try {
                        String s1 = gaugePrefix + img + GAUGETYPE[this.panel];
                        String s2 = gaugePrefix + selImg + GAUGETYPE[this.panel];
                        String s3 = gaugePrefix + "templates/" + GAUGETYPE[this.panel] + imgs[i].substring(0, imgs[i].lastIndexOf(46)) + ".tpl";
                        BufferedImage unselectedImage = ImageIO.read(new ReadDataFile().getInputStream(s1 + imgs[i]));
                        BufferedImage selectedImage = ImageIO.read(new ReadDataFile().getInputStream(s2 + imgs[i]));
                        gaugeBut[this.panel][i] = new JRadioButton(new ImageIcon(unselectedImage));
                        gaugeBut[this.panel][i].setSelectedIcon(new ImageIcon(selectedImage));
                        String tooltip = imgs[i].substring(0, imgs[i].lastIndexOf(46));
                        StringBuffer sb = new StringBuffer();
                        for (int c = 0; c < tooltip.length(); ++c) {
                            if (tooltip.charAt(c) >= 'A' && tooltip.charAt(c) <= 'Z') {
                                sb.append(" ").append(tooltip.charAt(c));
                                continue;
                            }
                            if (tooltip.charAt(c) == '_') {
                                sb.append(" ");
                                continue;
                            }
                            sb.append(tooltip.charAt(c));
                        }
                        gaugeBut[this.panel][i].setToolTipText(sb.toString().trim() + " " + LanguageEncoder.getText("Gauge"));
                        gaugeBut[this.panel][i].setMargin(new Insets(0, 0, 0, 0));
                        bgGauge.add(gaugeBut[this.panel][i]);
                        gaugeBut[this.panel][i].addActionListener((ActionListener)this.listener);
                        gaugeMap[this.panel][i] = s3;
                        gaugeReverseMap[this.panel].put(gaugeMap[this.panel][i], i);
                        continue;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.WARNING, "Failed to initialize GUI - Gauges", e);
                    }
                }
            } else {
                try {
                    for (int j = 0; gaugeBut[this.panel] != null && j < gaugeBut[this.panel].length; ++j) {
                        for (int k = 0; gaugeBut[this.panel][j] != null && k < ((ActionListener[])gaugeBut[this.panel][j].getListeners(ActionListener.class)).length; ++k) {
                            gaugeBut[this.panel][j].removeActionListener(((ActionListener[])gaugeBut[this.panel][j].getListeners(ActionListener.class))[k]);
                        }
                        gaugeBut[this.panel][j].addActionListener((ActionListener)this.listener);
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Threading inconsistency", e);
                    return;
                }
            }
            this.chartType.gaugeTabs[this.panel].removeAll();
            int rows = gaugeCount[this.panel] / 4 + (gaugeCount[this.panel] % 4 > 0 ? 1 : 0);
            this.chartType.gaugeTabs[this.panel].setLayout(new GridLayout(rows > 3 ? rows : 3, 4));
            for (int i = 0; i < gaugeCount[this.panel]; ++i) {
                this.chartType.gaugeTabs[this.panel].add(gaugeBut[this.panel][i]);
            }
            if (gaugeBut[this.panel].length <= this.chartTypeInd) {
                this.chartTypeInd = 0;
            }
            if (gaugeBut[this.panel].length > this.chartTypeInd) {
                gaugeBut[this.panel][this.chartTypeInd].setSelected(true);
                this.chartType.chartType = this.chartTypeInd;
            }
            this.chartType.gaugeTabs[this.panel].repaint();
            this.chartType.gaugeScrollPane[this.panel].repaint();
            this.chartType.repaint();
            if (this.listener instanceof ApplyGaugeTemplateDialog) {
                ((ApplyGaugeTemplateDialog)this.listener).repaint();
            }
        }
    }
}

