/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class ChartViewerDialog
extends QbDialog {
    ChartMain chartMain;
    JButton okButton;
    JButton cancelButton;
    JCheckBox enableMenu;
    JCheckBox enableType;
    JCheckBox enableDim;
    JCheckBox autoRotate;

    public ChartViewerDialog(ChartMain parent, String title) {
        super(parent, title, true);
        this.chartMain = parent;
        this.init();
    }

    private void init() {
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.setLayout(new GridLayout(1, 3, 5, 5));
        buttonPanel.add(new JLabel(""));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        BorderPanel borderPanel = new BorderPanel(LanguageEncoder.getText("Popup Menu"));
        borderPanel.setLayout(new GridLayout(0, 1));
        this.enableMenu = new JCheckBox(LanguageEncoder.getText("Enable Menu"), this.chartMain.chart.isPopupMenuEnabled());
        this.enableDim = new JCheckBox(LanguageEncoder.getText("2D/3D"), this.chartMain.chart.isDimMenuEnabled());
        this.enableType = new JCheckBox(LanguageEncoder.getText("Type"), this.chartMain.chart.isTypeMenuEnabled());
        this.enableMenu.addItemListener(this);
        this.enableDim.addItemListener(this);
        this.enableType.addItemListener(this);
        if (!this.enableMenu.isSelected()) {
            this.enableDim.setEnabled(false);
            this.enableType.setEnabled(false);
        }
        JPanel menuPanel = new JPanel();
        menuPanel.setLayout(new FlowLayout(0));
        menuPanel.add(this.enableMenu);
        JPanel dimPanel = new JPanel();
        dimPanel.setLayout(new FlowLayout(0));
        dimPanel.add(new JLabel("  "));
        dimPanel.add(this.enableDim);
        JPanel typePanel = new JPanel();
        typePanel.setLayout(new FlowLayout(0));
        typePanel.add(new JLabel("  "));
        typePanel.add(this.enableType);
        borderPanel.add(menuPanel);
        borderPanel.add(dimPanel);
        borderPanel.add(typePanel);
        BorderPanel animatePanel = new BorderPanel(LanguageEncoder.getText("3D Chart Animation"));
        animatePanel.setLayout(new FlowLayout(0));
        this.autoRotate = new JCheckBox(LanguageEncoder.getText("Auto Rotation"), this.chartMain.chart.isAutoRotate());
        this.autoRotate.addItemListener(this);
        animatePanel.add(this.autoRotate);
        if (this.chartMain.chart.is2DimChart()) {
            this.autoRotate.setEnabled(false);
        }
        cop.add("North", animatePanel);
        cop.add("Center", borderPanel);
        cop.add("South", buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object target = e.getSource();
        if (target == this.enableMenu) {
            this.enableDim.setEnabled(this.enableMenu.isSelected());
            this.enableType.setEnabled(this.enableMenu.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.chartMain.chart.setPopupMenuEnabled(this.enableMenu.isSelected());
            this.chartMain.chart.setDimMenuEnabled(this.enableDim.isSelected());
            this.chartMain.chart.setTypeMenuEnabled(this.enableType.isSelected());
            this.chartMain.chart.setAutoRotate(this.autoRotate.isSelected());
            this.chartMain.setModified();
        }
        this.dispose();
    }
}

