/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.chart.Chart;
import quadbase.chart.ColData;
import quadbase.chart.DBAccess;
import quadbase.chart.DataFileInput;
import quadbase.chart.DrillDownNode;
import quadbase.chart.EJBAccess;
import quadbase.chart.ExcelAccess;
import quadbase.chart.LoadChart;
import quadbase.chart.SOAPAccess;
import quadbase.chart.SalesForceAccess;
import quadbase.chart.SaveChart;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.DrillDownColumnMapDialog;
import quadbase.chart.designer.DrillDownTreeModel;
import quadbase.chart.designer.WizardStep1;
import quadbase.chart.designer.WizardStep2;
import quadbase.chart.designer.WizardStep3;
import quadbase.chart.designer.WizardStep31;
import quadbase.chart.designer.WizardStep32;
import quadbase.chart.designer.WizardStep33;
import quadbase.chart.designer.WizardStep4;
import quadbase.chart.designer.WizardStep41;
import quadbase.chart.designer.WizardStep5;
import quadbase.chart.designer.WizardStepMultiData;
import quadbase.common.paramquery.QueryClassFileInfo;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.paramquery.QueryInParam;
import quadbase.common.paramquery.QueryInParamSet;
import quadbase.common.paramquery.QueryParser;
import quadbase.common.paramquery.QueryXMLFileInfo;
import quadbase.common.paramquery.SOAPQueryFileInfo;
import quadbase.common.paramquery.SalesForceQueryFileInfo;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.OpenFileDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.BrowseDirectories;
import quadbase.common.util.IQueryInParam;
import quadbase.common.util.internal.ClassFileUtil;
import quadbase.common.util.internal.CustomizeElement;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.ExcelFileInfo;
import quadbase.common.util.internal.IDataInterchange;
import quadbase.common.util.internal.IInterchange;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.datasourcemanager.manager.ClassFileNode;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.DisplayMsgDialog;
import quadbase.datasourcemanager.manager.EJBNode;
import quadbase.datasourcemanager.manager.ExcelFileNode;
import quadbase.datasourcemanager.manager.JNDIDataSourceNode;
import quadbase.datasourcemanager.manager.Manager;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.datasourcemanager.manager.SOAPViewNode;
import quadbase.datasourcemanager.manager.SalesForceQueryNode;
import quadbase.datasourcemanager.manager.TextFileNode;
import quadbase.datasourcemanager.manager.UpdateDialog;
import quadbase.datasourcemanager.manager.XMLFileNode;
import quadbase.datasourcemanager.manager.XMLQueryNode;
import quadbase.util.internal.TransposeRS;

public class ChartWizard
extends QbDialog
implements IDataInterchange {
    private static final Logger LOGGER = Logger.getLogger(ChartWizard.class.getName());
    WizardStep1 step1;
    WizardStep2 step2;
    WizardStep3 step3;
    WizardStep32 step32;
    WizardStep33 step33;
    WizardStep4 step4;
    WizardStep5 step5;
    WizardStep31 step31;
    WizardStep31 step21;
    WizardStep41 step41;
    WizardStep41 stepMerge41;
    WizardStepMultiData stepMulti;
    ChartMain chartmain;
    ColData[] originalData;
    ColData[] colData;
    Vector<ColData[]> colDataList = new Vector();
    Vector sourceInfo = new Vector();
    Vector<Integer> sourceType = new Vector();
    Vector<Boolean> doTranspose = new Vector();
    Vector<boolean[]> transposeColList = new Vector();
    Dimension screensize;
    DBInfoBasic dbInfo;
    String sourceFile;
    XMLFileQueryInfo xmlFileQueryInfo;
    SalesForceQueryFileInfo sfQueryInfo;
    ExcelFileInfo excelInfo;
    String queryFilename = "";
    int sourceData;
    Chart chart;
    boolean isTransposed;
    boolean[] transposeCol;
    Manager manager;
    private JPanel managerPreviousPanel;
    boolean isDrillDownOp;
    private int[] drillDownMapping = null;
    Vector<QueryInParamSet> sqlParams = null;
    private boolean fromDesigner = true;
    private boolean exitOnCancel = false;
    private boolean isModifyWizard = false;
    private boolean doNotOpenPresetManager = false;
    boolean stepMultiOp = true;
    public String jndiName;
    public String homeName;
    public String remoteName;
    public String selectedMethodName;
    public Object[] selectedMethodParamVal;
    public Hashtable<String, String> environment;
    public SOAPQueryFileInfo soapInfo;
    protected int dbSourceType = -1;
    protected byte[][] dbFileBytes = null;
    private boolean isCancelled = false;
    IInterchange toReport;
    public String registryID;
    public String dataSourceID;
    public String dataSourceLoc;
    Vector<String> selectedNames;
    boolean connectionOnly;
    DisplayMsgDialog displayMsgDialog;

    public ChartWizard(ChartMain f, String title) {
        super(f, title, true);
        this.chartmain = f;
    }

    public ChartWizard(ChartMain f) {
        this(f, f.getPresetDBInfo(), f.getPresetQueryInParamSet(), false);
    }

    public ChartWizard(ChartMain f, DBInfoBasic dbInfo, QueryInParamSet inSet, boolean newChart) {
        this(f, dbInfo, inSet, newChart, true, false);
    }

    public ChartWizard(ChartMain f, DBInfoBasic dbInfo, QueryInParamSet inSet, boolean newChart, boolean fromDesigner, boolean exit_on_cancel) {
        this(f, dbInfo, inSet, null, newChart, fromDesigner, exit_on_cancel);
    }

    public ChartWizard(ChartMain f, DBInfoBasic dbInfo, QueryInParamSet inSet, Manager presetManager, boolean newChart, boolean fromDesigner, boolean exit_on_cancel) {
        this(f, f, dbInfo, inSet, presetManager, newChart, fromDesigner, exit_on_cancel, null, false, false, null, null);
    }

    public ChartWizard(Frame frame, ChartMain f, DBInfoBasic dbInfo, QueryInParamSet inSet, Manager presetManager, boolean newChart, boolean fromDesigner, boolean exit_on_cancel, IInterchange toReport, boolean fromCreateReportChart, boolean isTransposed, boolean[] transposeCol, JPanel prevPanel) {
        super(frame, LanguageEncoder.getText("Chart Wizard"), true);
        this.screensize = this.getToolkit().getScreenSize();
        this.chartmain = f;
        this.toReport = toReport;
        this.exitOnCancel = exit_on_cancel;
        this.fromDesigner = fromDesigner;
        this.setBackground(Color.lightGray);
        if (dbInfo != null) {
            this.dbInfo = dbInfo;
            try {
                this.colData = this.getData(dbInfo, inSet);
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to load data from database", ex);
            }
            this.sourceData = 1;
        }
        if (presetManager != null) {
            this.manager = presetManager;
            this.next(fromCreateReportChart, isTransposed, transposeCol, prevPanel);
        } else if (newChart && dbInfo != null) {
            this.newchartType();
        } else if (newChart && this.chartmain.getPresetDataRegistry() != null) {
            this.newChart(false, null);
        } else {
            this.step1 = new WizardStep1(this, dbInfo);
            JPanel contentPane = (JPanel)this.getContentPane();
            contentPane.setLayout(new BorderLayout());
            this.setBackground(Color.lightGray);
            contentPane.add("Center", this.step1);
            this.pack();
            this.validate();
            this.setpos();
        }
    }

    private boolean fromDesigner() {
        return this.fromDesigner;
    }

    public void init() {
        this.setpos();
    }

    void setpos() {
        Dimension dim = this.getPreferredSize();
        int x = (this.screensize.width - dim.width) / 2;
        int y = (this.screensize.height - dim.height) / 2;
        this.setBounds(x, y, dim.width, dim.height);
        this.setSize(dim);
    }

    @Override
    public boolean isReport() {
        return false;
    }

    @Override
    public void setIsReport(boolean b) {
    }

    @Override
    public boolean isDataRegistryManager() {
        return false;
    }

    @Override
    public void updateReports(DefaultMutableTreeNode node) {
        UpdateDialog dialog = new UpdateDialog(this.manager, false);
        dialog.setCurrentDirectory(this.chartmain.getBrowseDirectories().getChartTemplatesDirectory());
        dialog.setVisible(true);
        if (dialog.isCancelled) {
            return;
        }
        this.selectedNames = dialog.getSelectedNames();
        this.connectionOnly = dialog.isConnectionOnly();
        this.displayMsgDialog = new DisplayMsgDialog(this.manager);
        this.displayMsgDialog.setVisible(true);
        this.doUpdateCharts((DefaultDataSourceNode)node);
    }

    private void doUpdateCharts(DefaultDataSourceNode node) {
        if (node.isLeaf()) {
            for (int i = 0; this.selectedNames != null && i < this.selectedNames.size(); ++i) {
                String templatename = this.selectedNames.elementAt(i);
                try {
                    DefaultMutableTreeNode original;
                    ColData[] colData;
                    QueryInParamSet paramSet;
                    String[] result = LoadChart.loadDataSourceID(templatename);
                    if (result == null) continue;
                    String registryID = result[0];
                    String dataSourceID = result[1];
                    if (node.getID() == null || node.getID().equals("") || !node.getID().equals(dataSourceID) || !this.manager.getRegistryID().equals(registryID)) continue;
                    LoadChart loadChart = new LoadChart();
                    Chart loadedChart = loadChart.loadChartFromFile(IOUtil.getOffScreenComponent(), templatename, null, true);
                    Chart chart = null;
                    boolean hasDrillDown = false;
                    boolean isDrillDown = false;
                    if (loadedChart.currentNode != null && loadedChart.currentNode.getChildCount() > 0) {
                        hasDrillDown = true;
                    }
                    if (loadChart.getDrillDownNode() == null) {
                        isDrillDown = true;
                    }
                    if (node instanceof QueryNode || node instanceof DataViewQueryNode) {
                        String query = null;
                        DefaultDataSourceNode ddsNode = null;
                        DatabaseNode dbNode = null;
                        JNDIDataSourceNode jndiNode = null;
                        if (this.connectionOnly) {
                            if (node instanceof QueryNode) {
                                ddsNode = (DefaultDataSourceNode)node.getParent().getParent();
                            } else if (node instanceof DataViewQueryNode) {
                                ddsNode = (DefaultDataSourceNode)node.getParent().getParent().getParent();
                            }
                            chart = loadedChart;
                            if (ddsNode instanceof JNDIDataSourceNode) {
                                jndiNode = (JNDIDataSourceNode)ddsNode;
                                chart.dbInfo.setUseJNDIDataSource(true);
                                chart.dbInfo.setJNDIName(jndiNode.getJNDIName());
                                chart.dbInfo.setEnvProperties(jndiNode.getEnvProperties());
                            } else {
                                dbNode = (DatabaseNode)ddsNode;
                                chart.dbInfo.setUseJNDIDataSource(false);
                                if (dbNode != null) {
                                    chart.dbInfo.setURLString(dbNode.getURL());
                                    chart.dbInfo.setDriverName(dbNode.getDriver());
                                    chart.dbInfo.setUserID(dbNode.getUserName() != null ? dbNode.getUserName() : "");
                                    chart.dbInfo.setPassword(dbNode.getPassword() != null ? dbNode.getPassword() : "");
                                }
                            }
                        } else {
                            Vector<Object> sqlParams;
                            DBInfoBasic dbInfo;
                            paramSet = null;
                            byte[][] queryFileBytes = null;
                            if (node instanceof QueryNode) {
                                query = ((QueryNode)node).getSQL();
                                ddsNode = (DefaultDataSourceNode)node.getParent().getParent();
                                paramSet = ((QueryNode)node).getInSet();
                                queryFileBytes = ((QueryNode)node).getBytes();
                            } else if (node instanceof DataViewQueryNode) {
                                query = ((DataViewQueryNode)node).getSQL();
                                ddsNode = (DefaultDataSourceNode)node.getParent().getParent().getParent();
                                paramSet = ((DataViewQueryNode)node).getInSet();
                                queryFileBytes = ((DataViewQueryNode)node).getBytes();
                            }
                            if (ddsNode instanceof JNDIDataSourceNode) {
                                dbInfo = new DBInfoBasic(jndiNode.getJNDIName(), query, jndiNode.getEnvProperties());
                            } else {
                                dbNode = (DatabaseNode)ddsNode;
                                dbInfo = new DBInfoBasic(dbNode.getURL(), dbNode.getDriver(), dbNode.getUserName() != null ? dbNode.getUserName() : "", dbNode.getPassword() != null ? dbNode.getPassword() : "", query, dbNode.getAdditionalDb());
                            }
                            if (!QueryParser.hasParameters(query)) {
                                sqlParams = null;
                                if (isDrillDown) {
                                    LOGGER.finest(templatename + " : update failed. Drill-down chart requires query with parameter.");
                                    this.displayMsgDialog.appendMessage(templatename + ": update failed.\n\tDrill-down chart requires query with parameter.\n");
                                    continue;
                                }
                            } else {
                                IQueryInParam[] newParams;
                                IQueryInParam[] oldParams;
                                if (isDrillDown && !this.isParamCompatible(oldParams = ((QueryFileInfo)loadedChart.dbInfo).getInParam(), newParams = paramSet.getParameter())) {
                                    LOGGER.finest(templatename + ": update failed. Parameter(s) for this drill-down chart are not compatible.");
                                    this.displayMsgDialog.appendMessage(templatename + ": update failed.\n\tparameter(s) for this drill-down chart are not compatible.\n");
                                    continue;
                                }
                                sqlParams = new Vector();
                                QueryFileInfo qfInfo = new QueryFileInfo("", 0, dbInfo, new QueryInParamSet(paramSet.getParameter()));
                                sqlParams = QueryFileInfo.getParameter(qfInfo, false, true, false);
                                dbInfo = qfInfo;
                            }
                            if ((chart = this.updateChart(loadedChart, colData = DBAccess.retrieveResult(sqlParams, dbInfo, true, false, null, null, null, 0, 1))) == null) continue;
                            chart.dbInfo = dbInfo;
                            chart.setQueryFileBytes(queryFileBytes);
                        }
                        chart.setOriginalSourceData(-1);
                        chart.sourceData = 1;
                        chart.originalColDataFromMemSource = null;
                        chart.setDBSourceType(loadedChart.getDBSourceType());
                    } else if (node instanceof TextFileNode || node instanceof ClassFileNode || node instanceof XMLFileNode || node instanceof XMLQueryNode) {
                        String sourceFile = null;
                        if (node instanceof TextFileNode) {
                            sourceFile = ((TextFileNode)node).getFile();
                        }
                        if (node instanceof ClassFileNode) {
                            sourceFile = ((ClassFileNode)node).getFile();
                        }
                        if (node instanceof XMLFileNode) {
                            sourceFile = ((XMLFileNode)node).getFile();
                        }
                        if (node instanceof XMLQueryNode) {
                            sourceFile = ((XMLFileNode)node.getParent()).getFile();
                        }
                        QueryFileInfo dbInfo = null;
                        XMLFileQueryInfo xmlInfo = null;
                        if (loadedChart.sourceData == 6 && ClassFileUtil.isParameterized(sourceFile)) {
                            QueryClassFileInfo classInfo = new QueryClassFileInfo(sourceFile);
                            paramSet = classInfo.getInSet();
                            colData = new DataFileInput().readProcessedData(sourceFile, false, null, null, null, paramSet);
                            dbInfo = classInfo;
                        } else {
                            if (loadedChart.sourceData == 7) {
                                DefaultMutableTreeNode original2 = this.manager.getSelectedNode();
                                this.manager.setSelectedNode(node);
                                xmlInfo = this.manager.getXMLFileQueryInfo();
                                this.manager.setSelectedNode(original2);
                                if (((XMLQueryNode)node).getInSet() != null) {
                                    QueryXMLFileInfo xmlFileInfo = new QueryXMLFileInfo(xmlInfo);
                                    xmlFileInfo.getInSet();
                                    dbInfo = xmlFileInfo;
                                }
                            }
                            int dataType = -1;
                            dataType = node instanceof TextFileNode ? 2 : (node instanceof ClassFileNode ? 6 : (node instanceof XMLFileNode ? 4 : 7));
                            colData = new DataFileInput().readProcessedData(sourceFile, false, null, null, null, xmlInfo, dataType);
                        }
                        chart = this.updateChart(loadedChart, colData);
                        if (chart == null) continue;
                        if (node instanceof TextFileNode) {
                            chart.sourceData = 2;
                        }
                        if (node instanceof ClassFileNode) {
                            chart.sourceData = 6;
                        }
                        if (node instanceof XMLFileNode) {
                            chart.sourceData = 4;
                        }
                        if (node instanceof XMLQueryNode) {
                            chart.sourceData = 7;
                        }
                        chart.setOriginalSourceData(-1);
                        chart.originalColDataFromMemSource = null;
                        chart.sourceFile = sourceFile;
                        chart.dbInfo = dbInfo;
                        chart.setXMLFileQueryInfo(xmlInfo);
                    } else if (node instanceof SOAPViewNode) {
                        original = this.manager.getSelectedNode();
                        this.manager.setSelectedNode(node);
                        SOAPQueryFileInfo sqfi = this.manager.getSOAPQueryFileInfo();
                        this.manager.setSelectedNode(original);
                        colData = SOAPAccess.retrieveResult(sqfi);
                        chart = this.updateChart(loadedChart, colData);
                        if (chart == null) continue;
                        chart.sourceData = 12;
                        chart.soapInfo = sqfi;
                        if (sqfi.isParameterized()) {
                            chart.dbInfo = sqfi;
                        }
                    } else if (node instanceof EJBNode) {
                        Hashtable environment;
                        Object[] selectedMethodParamVal;
                        String selectedMethodName;
                        String remoteName;
                        String homeName;
                        EJBNode ejbnode = (EJBNode)node;
                        String jndiName = ejbnode.getJNDIName();
                        colData = EJBAccess.retrieveResult(jndiName, homeName = ejbnode.getHomeName(), remoteName = ejbnode.getRemoteName(), selectedMethodName = ejbnode.getSelectedMethod(), selectedMethodParamVal = ejbnode.getParam(selectedMethodName), environment = ejbnode.getEnvironment(), false, null, null, null);
                        chart = this.updateChart(loadedChart, colData);
                        if (chart == null) continue;
                        chart.sourceData = 5;
                        chart.jndiName = jndiName;
                        chart.homeName = homeName;
                        chart.remoteName = remoteName;
                        chart.selectedMethodName = selectedMethodName;
                        chart.selectedMethodParamVal = selectedMethodParamVal;
                        chart.environment = environment;
                    } else if (node instanceof SalesForceQueryNode) {
                        original = this.manager.getSelectedNode();
                        this.manager.setSelectedNode(node);
                        SalesForceQueryFileInfo sfQfi = this.manager.getSalesForceQueryInfo();
                        this.manager.setSelectedNode(original);
                        colData = SalesForceAccess.getColData(sfQfi);
                        chart = this.updateChart(loadedChart, colData);
                        if (chart == null) continue;
                        chart.sourceData = 11;
                        chart.sfQueryInfo = sfQfi;
                        if (sfQfi.isParameterized()) {
                            chart.dbInfo = sfQfi;
                        }
                    } else if (node instanceof ExcelFileNode) {
                        original = this.manager.getSelectedNode();
                        this.manager.setSelectedNode(node);
                        ExcelFileInfo excelInfo = this.manager.getExcelFileInfo();
                        this.manager.setSelectedNode(original);
                        colData = ExcelAccess.getColData(excelInfo);
                        chart = this.updateChart(loadedChart, colData);
                        if (chart == null) continue;
                        chart.sourceData = 13;
                    }
                    if (hasDrillDown && chart != null) {
                        this.updateDrillDown(chart.currentNode);
                    }
                    SaveChart saveChart = new SaveChart(chart);
                    if (!isDrillDown && chart != null) {
                        saveChart.setDrillDownNode(chart.currentNode);
                    }
                    saveChart.saveToFile(templatename.substring(0, templatename.length() - 4));
                    LOGGER.finest(templatename + " updated successfully.");
                    this.displayMsgDialog.appendMessage(templatename + ": updated successfully.\n");
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to update charts", ex);
                }
            }
        } else {
            int ct = node.getChildCount();
            for (int i = 0; i < ct; ++i) {
                DefaultDataSourceNode tmp = (DefaultDataSourceNode)node.getChildAt(i);
                this.doUpdateCharts(tmp);
            }
        }
    }

    private void updateDrillDown(DrillDownNode parent) {
        int ct = parent.getChildCount();
        for (int i = 0; i < ct; ++i) {
            this.selectedNames.addElement(parent.getChildAt(i).getFileName());
        }
    }

    private Chart updateChart(Chart loadedChart, ColData[] colData) {
        if (ColData.isColDataCompatible(loadedChart.colData, colData)) {
            return loadedChart.setNewData(colData);
        }
        return null;
    }

    private boolean isParamCompatible(IQueryInParam[] oldParams, IQueryInParam[] newParams) {
        if (oldParams.length != newParams.length) {
            return false;
        }
        for (int j = 0; j < oldParams.length; ++j) {
            if (oldParams[j].getSqlType() == newParams[j].getSqlType()) continue;
            return false;
        }
        return true;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean isCancelled) {
        this.isCancelled = isCancelled;
    }

    public boolean isDoNotOpenPresetManager() {
        return this.doNotOpenPresetManager;
    }

    public void setDoNotOpenPresetManager(boolean doNotOpenPresetManager) {
        this.doNotOpenPresetManager = doNotOpenPresetManager;
    }

    void openChart() {
        this.setVisible(false);
        this.dispose();
        if (!this.isDrillDownOp) {
            this.chartmain.do_Open();
        } else {
            String file = "";
            Cursor currentCursor = this.getCursor();
            try {
                int i;
                OpenFileDialog openDialog = new OpenFileDialog(this.chartmain, LanguageEncoder.getText("Open File..."), "", new String[]{"TPL", "PAC", "CHT"}, this.chartmain.getBrowseDirectories().getChartTemplatesDirectory());
                openDialog.setVisible(true);
                if (openDialog.getSelectedFile() == null) {
                    return;
                }
                this.chartmain.getBrowseDirectories().setChartTemplatesDirectory(openDialog.getCurrentDirectory());
                file = openDialog.getSelectedFile();
                LoadChart lr = new LoadChart();
                lr.loadChartFromFile(this, file, null);
                this.dbInfo = lr.getDBInfo();
                if (lr.getSourceDataType() != 1 && lr.getSourceDataType() != 6 || this.dbInfo == null || !(this.dbInfo instanceof QueryFileInfo)) {
                    throw new Exception(LanguageEncoder.getText("Chart template must use a parameterized query."));
                }
                DrillDownColumnMapDialog dDialog = new DrillDownColumnMapDialog(this, this.chartmain.chart, ((QueryFileInfo)this.dbInfo).getInSet());
                dDialog.setVisible(true);
                if (!dDialog.isModified()) {
                    throw new Exception("CANCELED");
                }
                DrillDownNode parentNode = this.chartmain.chart.currentNode;
                boolean failed = true;
                String chartName = "";
                String text = LanguageEncoder.getText("Drill-Down Chart Name:");
                while (failed) {
                    chartName = JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter drill-down chart name:"), text, -1);
                    if (chartName != null && !chartName.trim().equals("")) {
                        chartName = chartName.trim();
                        boolean ok = true;
                        for (i = 0; i < parentNode.getChildCount(); ++i) {
                            if (!parentNode.getChildAt(i).getUserObject().equals(chartName)) continue;
                            text = "'" + chartName + LanguageEncoder.getText("' already exists. Please enter another name:");
                            ok = false;
                            i = parentNode.getChildCount();
                        }
                        if (!ok) continue;
                        failed = false;
                        continue;
                    }
                    if (chartName != null) continue;
                    throw new Exception("CANCELED");
                }
                this.drillDownMapping = dDialog.getColInfoIndices();
                QueryInParam[] paramArray = new QueryInParam[this.drillDownMapping.length];
                for (i = 0; i < this.drillDownMapping.length; ++i) {
                    Object value = null;
                    try {
                        value = this.chartmain.chart.colData[this.drillDownMapping[i]].getDataSet().elementAt(0);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayEx) {
                        LOGGER.log(Level.FINEST, "Array index out of bounds", arrayEx);
                    }
                    this.chartmain.setModified();
                    QueryInParam currParam = ((QueryFileInfo)this.dbInfo).getInSet().getParameter()[i];
                    Object defaultValue = currParam.getDefaultValue((QueryFileInfo)this.dbInfo);
                    if (value != null) {
                        defaultValue = value;
                    }
                    paramArray[i] = new QueryInParam(currParam.getParamIndexMap(), currParam.getParamName(), currParam.getPromptName(), false, "", "", currParam.getSqlType(), defaultValue, currParam.getDefaultSql(), currParam.isAllOptionEnabled(), currParam.getAllOptionLabel(), value);
                }
                QueryInParamSet paramSet = new QueryInParamSet(paramArray);
                Vector<QueryInParamSet> params = new Vector<QueryInParamSet>();
                params.add(paramSet);
                Chart chart = new LoadChart().loadChartFromFile(this, file, params);
                String oldFile = this.chartmain.getTitle();
                JTree drillDownTree = this.chartmain.getDrillDownTree();
                this.chartmain.do_Save();
                this.chartmain.do_Close();
                DrillDownNode newNode = parentNode.createNewChild(chartName);
                newNode.setColumnMapping(this.drillDownMapping);
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.chartmain.setChart(chart, false);
                this.chartmain.chart.currentNode = newNode;
                newNode.setSelected(true);
                if (oldFile != null) {
                    this.chartmain.setFileName(oldFile);
                }
                this.chartmain.setDrillDownTree(drillDownTree);
                chart.dataSourceID = this.dataSourceID;
                chart.dataSourceLoc = this.dataSourceLoc;
                chart.registryID = this.registryID;
                this.chartmain.enableNonDrillDownMenu(true);
                this.chartmain.setModified();
                this.chartmain.do_Save();
                this.setVisible(false);
                this.dispose();
            }
            catch (Exception e) {
                this.setCursor(currentCursor);
                if (!"CANCELED".equals(e.getMessage())) {
                    LOGGER.log(Level.WARNING, "Failed to open chart", e);
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), e.getMessage());
                }
                LOGGER.log(Level.FINEST, "User canceled", e);
            }
        }
    }

    void doneloading(Chart chart, String file) {
        this.chartmain.setNewChart(chart);
        if (this.chartmain.hasBean()) {
            this.chartmain.setModified();
        }
        this.chartmain.setFileName(file);
        this.chartmain.do_enable();
        this.chartmain.toFront();
        this.chartmain.parentChart = chart;
        if (chart.drillDownVector == null || chart.drillDownVector.size() <= 0) {
            this.chartmain.isDrillDownDefined = false;
            this.chartmain.enableNonDrillDownMenu(true);
            this.chartmain.enableZoomHistOptions(true);
        } else {
            this.chartmain.isDrillDownDefined = true;
            this.chartmain.enableNonDrillDownMenu(true);
            this.chartmain.enableZoomHistOptions(false);
        }
        this.chartmain.drillTemplateName = chart.drillTemplateName;
        this.chartmain.originalMetaData = null;
        this.chartmain.originalColData = null;
        this.chartmain.drillHistory = null;
        this.setVisible(false);
    }

    public void newChart() {
        this.newChart(true, true);
    }

    void newChart(boolean showBackButton, JPanel prevPanel) {
        this.newChart(showBackButton, prevPanel, true);
    }

    public void newChart(boolean showBackButton, boolean showStartupBackButton) {
        this.newChart(showBackButton, this.managerPreviousPanel != null ? this.managerPreviousPanel : this.step1, showStartupBackButton);
    }

    public void newChart(boolean showBackButton, JPanel prevPanel, boolean showStartupBackButton) {
        if (this.chartmain.isChangeDataRegistryEnabled()) {
            if (this.getPresetDataRegistry() == null) {
                String errorMsg = LanguageEncoder.getText("There are no available data registries.") + " " + LanguageEncoder.getText("Please create a new registry, or modify user privileges");
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), errorMsg);
                return;
            }
            boolean showChangeButton = true;
            this.manager = new Manager(this, this, showChangeButton, this.chartmain.getChangeDataRegObj(), this.chartmain.canModify());
        } else {
            this.manager = new Manager(this, this, showBackButton, false, showStartupBackButton, null);
        }
        this.manager.setDefaultParamNames(this.chartmain.getDefaultParamNames());
        this.manager.setDataSourceManagerListeners(this.chartmain.getDataSourceManagerListeners());
        this.managerPreviousPanel = prevPanel;
        if (this.manager.initialize(this.chartmain.getAbsoluteDataRegistryPath(), this.fromDesigner(), this.chartmain.getDataRegistryHiddenNodes())) {
            this.setVisible(false);
            this.manager.setVisible(true);
            this.manager.toFront();
        } else {
            this.cancel();
        }
    }

    @Override
    public void setPresetDataRegistry(String data) {
        this.chartmain.setPresetDataRegistry(data);
    }

    @Override
    public String getPresetDataRegistry() {
        return this.chartmain.getPresetDataRegistry();
    }

    @Override
    public BrowseDirectories getBrowseDirectories() {
        return this.chartmain.getBrowseDirectories();
    }

    public void setDataRegistryHiddenNodes(Vector<String> vec) {
        this.chartmain.setDataRegistryHiddenNodes(vec);
    }

    public Vector<String> getDataRegistryHiddenNodes() {
        return this.chartmain.getDataRegistryHiddenNodes();
    }

    @Override
    public void toFront() {
        if (this.isVisible()) {
            super.toFront();
        }
        if (this.manager != null && this.manager.isVisible()) {
            this.manager.toFront();
        }
    }

    void getFromDB() {
        if (this.step3 == null) {
            this.step3 = new WizardStep3(this);
        }
        this.swapPanel(this.step2, this.step3);
    }

    void getStep32(boolean fromStep3) {
        if (this.step32 == null || fromStep3) {
            try {
                this.step32 = new WizardStep32(this, this.step3.getQueryFileInfo());
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Failed to open wizard step 32", ex);
                new MessageDialog((Frame)this.chartmain, LanguageEncoder.getText("Error")).show(ex.toString());
                return;
            }
        }
        if (fromStep3) {
            this.swapPanel(this.step3, this.step32);
        } else {
            this.swapPanel(this.step33, this.step32);
        }
    }

    void getStep33() {
        this.step33 = new WizardStep33(this, this.step32.getQueryFileInfo());
        this.swapPanel(this.step32, this.step33);
    }

    void getFromFile() {
        if (this.step31 == null) {
            this.step31 = new WizardStep31(this);
        }
        this.swapPanel(this.step2, this.step31);
    }

    void getMultiSource(JPanel prevPanel) {
        if (this.stepMulti == null) {
            this.stepMulti = new WizardStepMultiData(this);
        }
        this.swapPanel(prevPanel, this.stepMulti);
    }

    void getStep1(boolean fromNew) {
        if (fromNew) {
            this.swapPanel(this.step2, this.step1);
        } else {
            this.swapPanel(this.step21, this.step1);
        }
    }

    void getStep2(boolean fromdb) {
        this.setVisible(false);
        if (fromdb) {
            this.swapPanel(this.step3, this.step2);
        } else {
            this.swapPanel(this.step31, this.step2);
        }
    }

    void displayResult(JPanel removedPanel) {
        this.step41 = new WizardStep41(this, this.chartmain.getPresetManager() == null || this.toReport != null);
        this.swapPanel(removedPanel, this.step41);
    }

    void displayMergeResult(JPanel removedPanel) {
        this.stepMerge41 = new WizardStep41(this);
        this.swapPanel(removedPanel, this.stepMerge41);
    }

    public void newchartType(ColData[] colData, int sourceData) {
        this.colData = colData;
        this.sourceData = sourceData;
        this.setBackground(Color.lightGray);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        this.step41 = new WizardStep41(this, false);
        contentPane.add("Center", this.step41);
        this.screensize = this.getToolkit().getScreenSize();
        this.pack();
        this.validate();
        this.setpos();
    }

    private void newchartType() {
        JPanel newPanel = this.newStep4(null);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", newPanel);
        this.pack();
        this.validate();
        this.setpos();
    }

    void newchartType(boolean fromdb, JPanel prevPanel) {
        this.swapPanel(prevPanel, this.newStep4(prevPanel));
    }

    void newchartType(JPanel prevPanel) {
        this.swapPanel(null, this.newStep4(prevPanel));
    }

    void getStep3(JPanel removedPanel) {
        this.setVisible(false);
        if (this.toReport != null) {
            this.isCancelled = true;
            this.toReport.back();
            return;
        }
        JPanel contentPane = (JPanel)this.getContentPane();
        if (removedPanel != null) {
            contentPane.remove(removedPanel);
        }
        this.manager.setVisible(true);
        this.manager.toFront();
        if (this.dbSourceType == Manager.DATAVIEW && this.dbFileBytes != null && this.dbFileBytes.length == 2) {
            this.manager.openDataViewQuery();
        }
    }

    void newPreview(int ctype, boolean is2D, String gaugeTemplate) {
        try {
            this.step5 = new WizardStep5(this, ctype, is2D, gaugeTemplate);
        }
        catch (Exception ex) {
            if (ctype == 12) {
                LOGGER.log(Level.FINEST, "The data cannot plot a 3D surface chart", ex);
                new MessageDialog((Frame)this.chartmain, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("The data cannot plot a 3D surface chart"));
            } else {
                LOGGER.log(Level.WARNING, "Error opening wizard step 5", ex);
                new MessageDialog((Frame)this.chartmain, LanguageEncoder.getText("Error")).show(ex.toString());
            }
            return;
        }
        this.swapPanel(this.step4, this.step5);
    }

    private JPanel newStep4(JPanel prevPanel) {
        if (this.step4 != null) {
            boolean is2d = this.step4.chartType.is2DChart;
            String gaugeTemplate = this.step4.chartType.gaugeTemplate;
            int ctype = this.step4.chartType.chartType;
            this.step4 = new WizardStep4(this, prevPanel);
            this.step4.chartType.setType(ctype, is2d, gaugeTemplate);
        } else {
            this.step4 = new WizardStep4(this, prevPanel);
        }
        return this.step4;
    }

    void getStep4() {
        this.swapPanel(this.step5, this.newStep4(this.step41));
    }

    void swapPanel(JPanel oldPanel, JPanel newPanel) {
        this.setVisible(false);
        JPanel contentPane = (JPanel)this.getContentPane();
        if (oldPanel != null) {
            contentPane.remove(oldPanel);
        }
        if (oldPanel == this.managerPreviousPanel) {
            this.managerPreviousPanel = null;
        }
        contentPane.add("Center", newPanel);
        this.pack();
        this.validate();
        this.setpos();
        this.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doneWizard(Chart chart) {
        if (!this.chartmain.isReportVersion()) {
            this.turnOff();
        }
        chart.sourceData = this.sourceData;
        chart.registryID = this.registryID;
        chart.dataSourceID = this.dataSourceID;
        chart.dataSourceLoc = this.dataSourceLoc;
        if (this.sourceData == 1) {
            if (this.dbInfo instanceof QueryFileInfo) {
                chart.setQueryFileInfo((QueryFileInfo)this.dbInfo);
            } else {
                chart.setQueryFileInfo(null);
            }
            chart.dbInfo = this.dbInfo;
            chart.setDBSourceType(this.dbSourceType);
            chart.setQueryFileBytes(this.dbFileBytes);
        } else if (this.sourceData == 3) {
            chart.sourceList = new Object[this.sourceInfo.size()];
            chart.sourceType = new int[this.sourceInfo.size()];
            chart.doTranspose = new boolean[this.sourceInfo.size()];
            chart.transposeColList = new Object[this.sourceInfo.size()];
            for (int i = 0; i < this.sourceInfo.size(); ++i) {
                chart.sourceList[i] = this.sourceInfo.elementAt(i);
                chart.sourceType[i] = this.sourceType.elementAt(i);
                chart.doTranspose[i] = this.doTranspose.elementAt(i);
                chart.transposeColList[i] = this.transposeColList.elementAt(i);
            }
        } else if (this.sourceData == 12) {
            chart.soapInfo = this.soapInfo;
            chart.dbInfo = this.dbInfo;
            if (this.soapInfo.isParameterized()) {
                chart.setQueryFileInfo(this.soapInfo);
            }
        } else if (this.sourceData == 11) {
            chart.sfQueryInfo = this.sfQueryInfo;
            chart.dbInfo = this.dbInfo;
            if (this.sfQueryInfo.isParameterized()) {
                chart.setQueryFileInfo(this.sfQueryInfo);
            }
        } else if (this.sourceData == 13) {
            chart.excelInfo = this.excelInfo;
        } else if (this.sourceData == 5) {
            chart.jndiName = this.jndiName;
            chart.homeName = this.homeName;
            chart.remoteName = this.remoteName;
            chart.selectedMethodName = this.selectedMethodName;
            chart.selectedMethodParamVal = this.selectedMethodParamVal;
            chart.environment = this.environment;
        } else if (this.sourceData == 7) {
            chart.sourceFile = this.sourceFile;
            chart.setXMLFileQueryInfo(this.xmlFileQueryInfo);
            if (this.dbInfo instanceof QueryXMLFileInfo) {
                chart.setQueryFileInfo((QueryXMLFileInfo)this.dbInfo);
            } else {
                chart.setQueryFileInfo(null);
            }
            chart.dbInfo = this.dbInfo;
        } else {
            chart.sourceFile = this.sourceFile;
            chart.dbInfo = this.dbInfo;
        }
        DrillDownNode newNode = null;
        String oldFile = null;
        JTree drillDownTree = null;
        if (this.isDrillDownOp) {
            DrillDownNode parentNode = this.chartmain.chart.currentNode;
            boolean failed = true;
            String chartName = "";
            String text = LanguageEncoder.getText("Drill-Down Chart Name:");
            while (failed) {
                chartName = JOptionPane.showInputDialog(this, LanguageEncoder.getText("Please enter drill-down chart name:"), text, -1);
                if (chartName != null && !chartName.trim().equals("")) {
                    chartName = chartName.trim();
                    boolean ok = true;
                    for (int i = 0; i < parentNode.getChildCount(); ++i) {
                        if (!parentNode.getChildAt(i).getUserObject().equals(chartName)) continue;
                        text = "'" + chartName + LanguageEncoder.getText("' already exists. Please enter another name:");
                        ok = false;
                        i = parentNode.getChildCount();
                    }
                    if (!ok) continue;
                    failed = false;
                    continue;
                }
                if (chartName != null) continue;
                return;
            }
            if (this.drillDownMapping != null && this.drillDownMapping.length > 0) {
                this.chartmain.setModified();
            }
            try {
                newNode = parentNode.createNewChild(chartName);
                newNode.setColumnMapping(this.drillDownMapping);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to create drill-down chart", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to create drill-down chart.\n") + LanguageEncoder.getText("Please open the root chart and try again."));
                return;
            }
            try {
                oldFile = this.chartmain.filename;
                drillDownTree = this.chartmain.getDrillDownTree();
                if (this.chartmain.isModified()) {
                    this.chartmain.do_Save();
                }
                this.chartmain.do_Close();
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Failed to close parent chart", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Failed to close parent chart.\n") + LanguageEncoder.getText("Please make sure parent chart is saved."));
                return;
            }
        }
        if (!this.isModifyWizard && !this.chartmain.isReportVersion()) {
            this.chartmain.setFileName(null);
            this.chartmain.chartPanel.firstPanel = true;
            if (CustomizeElement.isERES()) {
                this.chartmain.setTitle(CustomizeElement.getCustomData("[ERES Organizer][Text][Chart Designer Title]", LanguageEncoder.getText("Chart Designer")));
            } else {
                this.chartmain.setTitle(CustomizeElement.getCustomData("[Organizer][Text][Chart Designer Title]", LanguageEncoder.getText("Chart Designer")));
            }
        }
        Cursor currentCursor = this.getCursor();
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            chart.newSurface();
            this.chartmain.setNewChart(chart);
            this.chartmain.parentChart = null;
            this.chartmain.isDrillDownDefined = false;
            this.chartmain.drillTemplateName = null;
            this.chartmain.originalMetaData = null;
            this.chartmain.originalColData = null;
            this.chartmain.drillHistory = null;
            this.chartmain.oldTitle = null;
            this.chartmain.setModified();
            this.chartmain.enableNonDrillDownMenu(true);
            this.chartmain.enableZoomHistOptions(true);
            this.chartmain.do_enable();
            if (newNode == null) {
                this.chartmain.chart.currentNode = newNode = new DrillDownNode("ROOT");
                this.chartmain.setDrillDownTree(new JTree(new DrillDownTreeModel(newNode)));
            }
            this.chartmain.chart.currentNode = newNode;
            newNode.setSelected(true);
            if (this.isDrillDownOp) {
                if (oldFile != null) {
                    this.chartmain.setFileName(oldFile);
                }
                this.chartmain.setDrillDownTree(drillDownTree);
            }
        }
        catch (Exception ex) {
            LOGGER.log(Level.FINEST, "Error resetting chart settings", ex);
        }
        finally {
            this.setCursor(currentCursor);
        }
        this.chartmain.do_enable();
        this.chartmain.toFront();
        if (this.isDrillDownOp) {
            this.chartmain.do_Save();
        }
        this.dispose();
        this.chartmain.qbrepaint();
        this.chartmain.updatePanelSize();
    }

    public void launchAggregateDialog(boolean secondaryAxisExists, int categoryType) {
        this.chartmain.launchAggregateDialog(secondaryAxisExists, categoryType, true);
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
        this.turnOff();
    }

    private void turnOff() {
        if (this.manager != null) {
            this.manager.setVisible(false);
            this.manager.dispose();
        }
        if (this.chartmain.chart == null) {
            this.chartmain.do_disable();
        }
        this.setVisible(false);
        this.dispose();
        if (this.exitOnCancel) {
            try {
                this.chartmain.do_exit(false);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Failed to close chart", ex);
                this.chartmain.setVisible(false);
                this.chartmain.dispose();
            }
            return;
        }
    }

    @Override
    public void next() {
        this.next(false, false, null, null);
    }

    @Override
    public void next(boolean fromCreateReportChart, boolean isTransposed, boolean[] transposeCol, JPanel prevPanel) {
        String err_msg;
        this.sourceData = this.manager.getSourceData();
        DefaultMutableTreeNode node = this.manager.getSelectedNode();
        if (node instanceof DefaultDataSourceNode) {
            this.dataSourceID = node instanceof DataViewNode ? this.manager.getLastID() : ((DefaultDataSourceNode)node).getID();
        }
        this.registryID = this.manager.getRegistryID();
        this.dataSourceLoc = this.manager.managerPane.dataSourceLoc;
        ColData[] colData2 = null;
        String tmp = this.manager.getTitle();
        this.manager.setTitle(Manager.WAIT_TITLE);
        this.manager.setCursor(Cursor.getPredefinedCursor(3));
        if (this.sourceData == 2 || this.sourceData == 6 || this.sourceData == 4 || this.sourceData == 7) {
            String loc = this.manager.getFileName();
            if (this.sourceData == 6 && ClassFileUtil.isParameterized(loc)) {
                try {
                    QueryClassFileInfo classInfo = new QueryClassFileInfo(loc);
                    Vector<QueryInParamSet> paramV = null;
                    if (this.isDrillDownOp) {
                        QueryInParamSet tempParamSet = classInfo.getInSet();
                        this.drillDownMapping = this.setupDrillDownMapping(this.manager, this.chartmain.chart, tempParamSet);
                        paramV = new Vector();
                        paramV.addElement(tempParamSet);
                    } else {
                        QueryFileInfo.setParentDialog(this.manager);
                        paramV = QueryFileInfo.getParameter(classInfo, false, false, true);
                    }
                    if (paramV == null) {
                        throw new Exception("CANCELED");
                    }
                    colData2 = new DataFileInput().readProcessedData(loc, false, null, null, null, paramV.elementAt(0));
                    this.colData = colData2;
                    this.dbInfo = classInfo;
                }
                catch (Exception ex) {
                    if (!"CANCELED".equals(ex.getMessage())) {
                        LOGGER.log(Level.FINE, "Failed to process parameterized class file", ex);
                        new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "An error occured with the parameterized class file data source.\n" + ex.getMessage());
                    } else {
                        LOGGER.log(Level.FINEST, "Cancelled processing parameterized class file", ex);
                    }
                    this.backToDataSourceManager(tmp);
                    return;
                }
            }
            if (this.sourceData == 7) {
                XMLFileQueryInfo xmlInfo = this.manager.getXMLFileQueryInfo();
                if (QueryParser.hasParameters(xmlInfo.getCondition())) {
                    try {
                        QueryXMLFileInfo xmlFileInfo = new QueryXMLFileInfo(xmlInfo);
                        if (this.isDrillDownOp) {
                            QueryInParamSet tempParamSet = xmlFileInfo.getInSet();
                            this.drillDownMapping = this.setupDrillDownMapping(this.manager, this.chartmain.chart, tempParamSet);
                        }
                        colData2 = new DataFileInput().readProcessedData(loc, false, null, null, null, xmlInfo, this.sourceData);
                        this.colData = colData2;
                        this.dbInfo = xmlFileInfo;
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.FINE, "Failed to process XML", ex);
                        MessageDialog.showError(this.manager, true, ex.toString());
                        this.backToDataSourceManager(tmp);
                        return;
                    }
                }
                try {
                    if (this.isDrillDownOp) {
                        throw new Exception(LanguageEncoder.getText("Parameter drill-down charts require a database query."));
                    }
                    colData2 = new DataFileInput().readProcessedData(loc, false, null, null, null, xmlInfo, this.sourceData);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to set up drill-down", ex);
                    MessageDialog.showError(this.manager, true, ex.toString());
                    this.backToDataSourceManager(tmp);
                    return;
                }
                this.colData = colData2;
                this.dbInfo = null;
                this.xmlFileQueryInfo = xmlInfo;
            } else {
                try {
                    if (this.isDrillDownOp) {
                        throw new Exception(LanguageEncoder.getText("Parameter drill-down charts require a database query."));
                    }
                    colData2 = new DataFileInput().readProcessedData(loc, false, null, null, null, null, this.sourceData);
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINE, "Failed to set up drill-down", ex);
                    MessageDialog.showError(this.manager, true, ex.toString());
                    this.backToDataSourceManager(tmp);
                    return;
                }
                this.colData = colData2;
                this.dbInfo = null;
            }
            this.sourceFile = loc;
        } else if (this.sourceData == 12) {
            this.soapInfo = this.manager.getSOAPQueryFileInfo();
            err_msg = "";
            boolean hasParameters = this.soapInfo.isParameterized();
            if (hasParameters) {
                this.dbInfo = this.soapInfo;
            }
            if (this.isDrillDownOp && !hasParameters) {
                err_msg = LanguageEncoder.getText("Query must be parameterized for drill down charts.");
            }
            try {
                if (!hasParameters) {
                    this.sqlParams = null;
                } else if (this.isDrillDownOp) {
                    try {
                        QueryInParamSet tempParamSet = this.soapInfo.getInSet();
                        this.drillDownMapping = this.setupDrillDownMapping(this.manager, this.chartmain.chart, tempParamSet);
                        this.sqlParams = new Vector();
                        this.sqlParams.add(tempParamSet);
                        this.soapInfo.setInSet(tempParamSet);
                    }
                    catch (Exception excep) {
                        LOGGER.log(Level.FINER, "An error occured while mapping to an existing column", excep);
                        err_msg = LanguageEncoder.getText("An error occured while mapping to an existing column.\n") + this.toString(excep);
                    }
                } else {
                    QueryInParam[] paramarray;
                    if (this.colDataList.size() > 0) {
                        err_msg = LanguageEncoder.getText("Parameterized query cannot be used with multiple datasources.");
                        throw new Exception();
                    }
                    for (QueryInParam element : paramarray = this.soapInfo.getInSet().getParameter()) {
                        element.setValue(null);
                    }
                    SOAPQueryFileInfo.setParentDialog(this.manager);
                    this.sqlParams = SOAPQueryFileInfo.getParameter(this.soapInfo, true, false, true);
                    if (this.sqlParams == null) {
                        throw new Exception("CANCELED");
                    }
                }
            }
            catch (Exception ex) {
                this.sqlParams = null;
                String err_tmp = ex.getMessage();
                if (err_tmp != null && err_tmp.equals("CANCELED")) {
                    err_msg = err_tmp;
                }
                if (err_tmp != null) {
                    LOGGER.log(Level.FINER, "Failed to get parameter value(s): " + err_msg, ex);
                }
                LOGGER.log(Level.FINER, "Failed to get parameter value(s)", ex);
            }
            try {
                if (!err_msg.equals("")) {
                    throw new Exception();
                }
                colData2 = SOAPAccess.retrieveResult(this.soapInfo);
            }
            catch (Exception ex) {
                if (err_msg.equals("")) {
                    err_msg = LanguageEncoder.getText("Failed to retrieve result set from SOAP service.") + "\n" + ex.toString();
                }
                if (!err_msg.equals("CANCELED")) {
                    MessageDialog.showError(this.manager, true, err_msg);
                }
                LOGGER.log(Level.FINE, "Failed to perform action: " + err_msg, ex);
                this.backToDataSourceManager(tmp);
                return;
            }
            this.colData = colData2;
        } else if (this.sourceData == 11) {
            block99: {
                this.sfQueryInfo = this.manager.getSalesForceQueryInfo();
                err_msg = "";
                boolean hasParameters = this.sfQueryInfo.isParameterized();
                if (hasParameters) {
                    this.dbInfo = this.sfQueryInfo;
                }
                if (this.isDrillDownOp && !hasParameters) {
                    err_msg = LanguageEncoder.getText("Query must be parameterized for drill down charts.");
                }
                try {
                    if (!hasParameters) {
                        this.sqlParams = null;
                    } else if (this.isDrillDownOp) {
                        try {
                            QueryInParamSet tempParamSet = this.manager.getInSet();
                            this.drillDownMapping = this.setupDrillDownMapping(this.manager, this.chartmain.chart, tempParamSet);
                            this.sqlParams = new Vector();
                            this.sqlParams.add(tempParamSet);
                            this.sfQueryInfo.setInSet(tempParamSet);
                        }
                        catch (Exception excep) {
                            LOGGER.log(Level.FINER, "An error occured while mapping to an existing column", excep);
                            err_msg = LanguageEncoder.getText("An error occured while mapping to an existing column.\n") + this.toString(excep);
                        }
                    } else {
                        QueryInParam[] paramarray;
                        if (this.colDataList.size() > 0) {
                            err_msg = LanguageEncoder.getText("Parameterized query cannot be used with multiple datasources.");
                            throw new Exception();
                        }
                        for (QueryInParam element : paramarray = this.manager.getInSet().getParameter()) {
                            element.setValue(null);
                        }
                        SalesForceQueryFileInfo.setParentDialog(this.manager);
                        this.sfQueryInfo.setInSet(this.manager.getInSet());
                        this.sqlParams = QueryFileInfo.getParameter(this.sfQueryInfo, true, false, true);
                        if (this.sqlParams == null) {
                            throw new Exception("CANCELED");
                        }
                    }
                }
                catch (Exception ex) {
                    LOGGER.log(Level.FINER, "Failed to get parameter value(s)", ex);
                    this.sqlParams = null;
                    String err_tmp = ex.getMessage();
                    if (err_tmp == null || !err_tmp.equals("CANCELED")) break block99;
                    err_msg = err_tmp;
                }
            }
            try {
                if (!err_msg.equals("")) {
                    throw new Exception();
                }
                colData2 = SalesForceAccess.getColData(this.sfQueryInfo);
            }
            catch (Exception ex) {
                if (err_msg.equals("")) {
                    err_msg = LanguageEncoder.getText("Failed to retrieve result set from SalesForce.\n") + ex.toString();
                }
                if (!err_msg.equals("CANCELED")) {
                    MessageDialog.showError(this.manager, true, err_msg);
                }
                LOGGER.log(Level.FINE, "Failed to perform action: " + err_msg, ex);
                this.backToDataSourceManager(tmp);
                return;
            }
            this.colData = colData2;
        } else if (this.sourceData == 13) {
            this.excelInfo = this.manager.getExcelFileInfo();
            try {
                if (this.isDrillDownOp) {
                    throw new Exception(LanguageEncoder.getText("Parameter drill-down charts require a database query."));
                }
                colData2 = ExcelAccess.getColData(this.excelInfo);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Excel: invalid file", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.getMessage());
                this.backToDataSourceManager(tmp);
                return;
            }
            this.colData = colData2;
        } else if (this.sourceData == 5) {
            this.jndiName = this.manager.getJNDIName();
            this.homeName = this.manager.getHomeName();
            this.remoteName = this.manager.getRemoteName();
            this.selectedMethodName = this.manager.getMethodName();
            this.selectedMethodParamVal = this.manager.getParam();
            this.environment = this.manager.getEnvironment();
            if (this.selectedMethodName == null) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "You didn't specify the method name for this EJB component.");
                this.backToDataSourceManager(tmp);
                return;
            }
            try {
                if (this.isDrillDownOp) {
                    throw new Exception(LanguageEncoder.getText("Parameter drill-down charts require a database query."));
                }
                colData2 = EJBAccess.retrieveResult(this.jndiName, this.homeName, this.remoteName, this.selectedMethodName, this.selectedMethodParamVal, this.environment, false, null, null, null);
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINE, "Invalid EJB settings", ex);
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), ex.getMessage());
                this.backToDataSourceManager(tmp);
                return;
            }
            this.colData = colData2;
        } else if (this.sourceData == 1) {
            String err_msg2;
            block100: {
                this.dbSourceType = this.manager.getDBSourceType();
                this.dbFileBytes = this.manager.getFileBytes();
                String query = this.manager.getSQL();
                this.dbInfo = this.manager.isUseJNDIDataSource() ? new DBInfoBasic(this.manager.getLookupName(), query, this.manager.getEnvProperties()) : new DBInfoBasic(this.manager.getURL(), this.manager.getDriver(), this.manager.getUserName(), this.manager.getPassword(), query, this.manager.getAdditionalDb());
                err_msg2 = "";
                boolean hasParameters = QueryParser.hasParameters(query);
                if (this.isDrillDownOp && !hasParameters) {
                    err_msg2 = LanguageEncoder.getText("Query must be parameterized for drill down charts.");
                }
                try {
                    QueryInParam[] paramarray;
                    if (!hasParameters) {
                        this.sqlParams = null;
                        break block100;
                    }
                    if (this.isDrillDownOp) {
                        try {
                            QueryInParamSet tempParamSet = this.manager.getInSet();
                            this.drillDownMapping = this.setupDrillDownMapping(this.manager, this.chartmain.chart, tempParamSet);
                            this.sqlParams = new Vector();
                            this.sqlParams.add(tempParamSet);
                            this.dbInfo = new QueryFileInfo("", 0, this.dbInfo, tempParamSet);
                        }
                        catch (Exception excep) {
                            if (excep.toString().equals("java.lang.Exception: CANCELED")) {
                                LOGGER.log(Level.FINEST, "Mapping to column: canceled", excep);
                                err_msg2 = "CANCELED";
                                break block100;
                            }
                            LOGGER.log(Level.FINE, "An error occured while mapping to an existing column", excep);
                            err_msg2 = LanguageEncoder.getText("An error occured while mapping to an existing column.\n") + this.toString(excep);
                        }
                        break block100;
                    }
                    if (this.colDataList.size() > 0) {
                        err_msg2 = LanguageEncoder.getText("Parameterized query cannot be used with multiple datasources.");
                        throw new Exception();
                    }
                    for (QueryInParam element : paramarray = this.manager.getInSet().getParameter()) {
                        element.setValue(null);
                    }
                    QueryFileInfo qfInfo = new QueryFileInfo("", 0, this.dbInfo, new QueryInParamSet(this.manager.getInSet().getParameter()));
                    this.sqlParams = QueryFileInfo.getParameter(qfInfo, true, false, true);
                    if (this.sqlParams == null) {
                        throw new Exception("CANCELED");
                    }
                    this.dbInfo = qfInfo;
                }
                catch (Exception ex) {
                    this.sqlParams = null;
                    String err_tmp = ex.getMessage();
                    if (err_tmp != null && err_tmp.equals("CANCELED")) {
                        err_msg2 = err_tmp;
                    }
                    LOGGER.log(Level.FINER, err_msg2, ex);
                }
            }
            try {
                if (!err_msg2.equals("")) {
                    throw new Exception();
                }
                colData2 = DBAccess.retrieveResult(this.sqlParams, this.dbInfo, true, false, null, null, null, 0, -1);
            }
            catch (Exception ex) {
                if (err_msg2.equals("")) {
                    err_msg2 = LanguageEncoder.getText("Failed to retrieve result set from database.\n") + ex.toString();
                }
                if (!err_msg2.equals("CANCELED")) {
                    MessageDialog.showError(this.manager, true, err_msg2);
                }
                LOGGER.log(Level.FINE, "Failed to perform action: " + err_msg2, ex);
                this.backToDataSourceManager(tmp);
                return;
            }
            this.colData = colData2;
        }
        this.manager.setCursor(Cursor.getDefaultCursor());
        this.manager.setTitle(tmp);
        this.manager.setVisible(false);
        this.manager.dispose();
        if (fromCreateReportChart) {
            if (this.colData != null && isTransposed && transposeCol != null) {
                try {
                    this.originalData = this.colData;
                    this.colData = ColData.getColData(TransposeRS.doTranspose(this.colData, transposeCol));
                    this.isTransposed = isTransposed;
                    this.transposeCol = transposeCol;
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Error transposing column data", ex);
                }
            }
            this.newchartType(prevPanel);
        } else {
            this.displayResult(this.managerPreviousPanel);
        }
    }

    private String toString(Exception ex) {
        String str = ex.toString();
        if (str.startsWith("java.lang.Exception: ")) {
            str = str.substring(21);
            return str.trim();
        }
        return ex.toString();
    }

    public void setFieldDrillDownOp(boolean state) {
        this.isDrillDownOp = state;
    }

    @Override
    public void back() {
        this.setVisible(true);
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.cancel();
    }

    private ColData[] getData(DBInfoBasic dbInfo, QueryInParamSet inSet) {
        String query = dbInfo.getQuery();
        String err_msg = "";
        Vector<QueryInParamSet> params = null;
        try {
            if (QueryParser.hasParameters(query)) {
                QueryInParam[] paramarray;
                if (this.colDataList.size() > 0) {
                    err_msg = "Parameterized query cannot be used with multiple datasources.";
                    throw new Exception();
                }
                for (QueryInParam element : paramarray = inSet.getParameter()) {
                    element.setValue(null);
                }
                QueryFileInfo qfInfo = new QueryFileInfo("", 0, dbInfo, new QueryInParamSet(inSet.getParameter()));
                QueryFileInfo.setParentFrame(this.chartmain);
                params = QueryFileInfo.getParameter(qfInfo, true, false, true);
                if (params == null) {
                    throw new Exception("CANCELED");
                }
                dbInfo = qfInfo;
            }
        }
        catch (Exception ex) {
            params = null;
            if (ex.getMessage().equals("CANCELED")) {
                err_msg = ex.getMessage();
            }
            LOGGER.log(Level.FINER, "Error getting parameter value(s): " + err_msg, ex);
        }
        try {
            if (!err_msg.equals("")) {
                throw new Exception();
            }
            return DBAccess.retrieveResult(params, dbInfo, true, false, null, null, null, 0, -1);
        }
        catch (Exception ex) {
            if (err_msg.equals("")) {
                err_msg = "Failed to retrieve result set from database.\n" + ex.toString();
            }
            if (!err_msg.equals("CANCELED")) {
                new MessageDialog((Frame)this.chartmain, LanguageEncoder.getText("Error")).show(err_msg);
            }
            LOGGER.log(Level.FINE, "Failed to configure parameter values: " + err_msg, ex);
            return null;
        }
    }

    public boolean isModifyWizard() {
        return this.isModifyWizard;
    }

    public void setModifyWizard(boolean b) {
        this.isModifyWizard = b;
    }

    private void backToDataSourceManager(String tmp) {
        this.isCancelled = true;
        this.manager.setCursor(Cursor.getDefaultCursor());
        this.manager.setTitle(tmp);
        this.manager.toFront();
    }

    private int[] setupDrillDownMapping(JDialog dialog, Chart chart, QueryInParamSet paramSet) throws Exception {
        DrillDownColumnMapDialog dDialog = new DrillDownColumnMapDialog(dialog, chart, paramSet);
        dDialog.setVisible(true);
        if (!dDialog.isModified()) {
            throw new Exception("CANCELED");
        }
        int[] ret = dDialog.getColInfoIndices();
        QueryInParam[] paramArray = paramSet.getParameter();
        for (int i = 0; i < ret.length; ++i) {
            Object value = null;
            if (ret[i] >= 0) {
                try {
                    value = chart.colData[ret[i]].getDataSet().elementAt(0);
                }
                catch (ArrayIndexOutOfBoundsException arrayEx) {
                    LOGGER.log(Level.FINEST, "Array index is out of bounds", arrayEx);
                }
            } else {
                value = paramArray[i].getDefaultValue((QueryFileInfo)chart.dbInfo);
            }
            if (!(chart.dbInfo instanceof QueryFileInfo)) continue;
            Object defaultValue = paramArray[i].getDefaultValue((QueryFileInfo)chart.dbInfo);
            if (value != null) {
                defaultValue = value;
            }
            paramArray[i].setDefaultValue(defaultValue);
            paramArray[i].setValue(value);
        }
        return ret;
    }
}

