/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.ComboLinePanel;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class ColumnDialog
extends QbDialog {
    JCheckBox checkUniqueColorCol;
    JCheckBox singleColorForCategs;
    boolean uniqueColor = false;
    boolean singleColorForCategories = false;
    JButton okButton;
    JButton cancelButton;
    Chart chart;
    ChartMain chartMain;
    Boolean doComboLine = false;
    ComboLinePanel comboLinePanel;

    public ColumnDialog(JFrame frame, Chart chart) {
        super(frame, LanguageEncoder.getText(chart.dataDim == 1 ? "Column/Bar Options" : "Column Options"), true);
        this.chartMain = (ChartMain)frame;
        this.chart = chart;
        this.init();
    }

    public ColumnDialog(JFrame frame, Chart chart, Boolean doComboLine) {
        super(frame, LanguageEncoder.getText(chart.dataDim == 1 ? "Column/Bar Options" : "Column Options"), true);
        this.chartMain = (ChartMain)frame;
        this.chart = chart;
        this.doComboLine = doComboLine;
        this.init();
    }

    private void init() {
        this.setBackground(Color.lightGray);
        BorderPanel mainPanel = new BorderPanel(LanguageEncoder.getText(this.chart.dataDim == 1 ? "Column/Bar Options" : "Column Options"));
        mainPanel.setLayout(new BorderLayout());
        if (this.chart.dataDim == 2) {
            this.checkUniqueColorCol = new JCheckBox(LanguageEncoder.getText("Unique Color Column"));
            mainPanel.add("Center", this.checkUniqueColorCol);
        }
        if (this.chart.dataDim == 1) {
            this.singleColorForCategs = new JCheckBox(LanguageEncoder.getText("Single Color For All Categories"));
            mainPanel.add("Center", this.singleColorForCategs);
        }
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        if (this.doComboLine.booleanValue()) {
            this.comboLinePanel = new ComboLinePanel(this.chartMain, this.chart);
            JTabbedPane tabPanel = new JTabbedPane();
            tabPanel.add(LanguageEncoder.getText("Column/Bar"), mainPanel);
            tabPanel.add(LanguageEncoder.getText("Combo Line"), this.comboLinePanel);
            contentPane.add("Center", tabPanel);
        } else {
            contentPane.add("Center", mainPanel);
        }
        contentPane.add("South", buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.getValues();
    }

    private void getValues() {
        if (this.chart.dataDim == 2) {
            this.uniqueColor = this.chart.isUniqueColorForCol();
            this.checkUniqueColorCol.setSelected(this.uniqueColor);
        } else {
            this.singleColorForCategories = this.chart.isSingleColorForCategories();
            this.singleColorForCategs.setSelected(this.singleColorForCategories);
        }
    }

    private void setValues() {
        if (this.chart.dataDim == 2) {
            this.chart.setUniqueColorForCol(this.checkUniqueColorCol.isSelected());
        } else {
            this.chart.setSingleColorForCategories(this.singleColorForCategs.isSelected());
        }
    }

    private boolean isModified() {
        if (this.chart.dataDim == 2) {
            return this.checkUniqueColorCol.isSelected() != this.uniqueColor;
        }
        return this.singleColorForCategs.isSelected() != this.singleColorForCategories;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.okButton) {
            String errorMsg;
            if (this.comboLinePanel != null && (errorMsg = this.comboLinePanel.setValues()) != null) {
                new MessageDialog((Frame)this.chartMain, LanguageEncoder.getText("Error")).show(errorMsg);
                return;
            }
            if (this.isModified()) {
                this.setValues();
            }
            this.chartMain.chart.newSurface();
            this.chartMain.setModified();
            this.chartMain.qbpaint();
            this.dispose();
        } else if (source == this.cancelButton) {
            this.dispose();
        }
    }
}

