/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.util.internal.LanguageEncoder;

public class ComboLinePanel
extends BorderPanel
implements ItemListener {
    JComboBox[] choice;
    JButton okButton;
    JButton cancelButton;
    Chart chart;
    ChartMain chartMain;
    JCheckBox checkStep;
    JCheckBox drawLinesInOrderFromDataSource;
    JCheckBox drawArrows;
    JTextField stepRatio;
    private boolean isListenerEnabled = true;
    boolean stateChanged = false;

    public ComboLinePanel(JFrame frame, Chart chart) {
        super(LanguageEncoder.getText("Line Options"));
        this.chartMain = (ChartMain)frame;
        this.chart = chart;
        this.init();
    }

    private void init() {
        JPanel stepPanel = new JPanel(new GridLayout(0, 1));
        if (this.chart.getChartType() == 2) {
            this.drawLinesInOrderFromDataSource = new JCheckBox(LanguageEncoder.getText("Draw Lines In Data Source Order"), this.chart.isLineInOriginalOrder());
            this.drawLinesInOrderFromDataSource.addItemListener(this);
            this.drawArrows = new JCheckBox(LanguageEncoder.getText("Draw Arrows"), this.chart.isDrawConnectLineArrows());
            this.drawArrows.addItemListener(this);
            stepPanel.add(this.drawLinesInOrderFromDataSource);
            stepPanel.add(this.drawArrows);
        }
        this.checkStep = new JCheckBox(LanguageEncoder.getText("Draw Step Lines"), this.chart.showStepLine2);
        this.checkStep.addItemListener(this);
        this.stepRatio = new JTextField(5);
        this.stepRatio.setText(Double.toString(this.chart.stepRatio2));
        this.stepRatio.setEnabled(this.chart.showStepLine2);
        JPanel ratioPanel = new JPanel();
        ratioPanel.setLayout(new FlowLayout(0));
        ratioPanel.add(new JLabel(LanguageEncoder.getText("The ratio of the step line")));
        ratioPanel.add(this.stepRatio);
        stepPanel.add(this.checkStep);
        stepPanel.add(ratioPanel);
        this.add("Center", stepPanel);
    }

    private String setLineRatio() {
        if (this.stepRatio.getText() == null || this.stepRatio.getText().trim().equals("")) {
            return "Please enter step ratio value!";
        }
        this.chart.setStepLineRatio(Double.valueOf(this.stepRatio.getText()));
        this.chart.setStepLineRatio2(Double.valueOf(this.stepRatio.getText()));
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.isListenerEnabled) {
            return;
        }
        this.isListenerEnabled = false;
        this.setStepLineEnabled(this.checkStep.isSelected());
        this.stateChanged = true;
        this.isListenerEnabled = true;
    }

    public void setStepLineEnabled(boolean b) {
        this.checkStep.setSelected(b);
        this.stepRatio.setEnabled(b);
        this.chart.setStepLineState(b);
        this.chart.setStepLineState2(b);
    }

    public String setValues() {
        String errorValues;
        this.setStepLineEnabled(this.checkStep.isSelected());
        if (this.chart.getChartType() == 2) {
            this.chart.setLineInOriginalOrder(this.drawLinesInOrderFromDataSource.isSelected());
            this.chart.setDrawConnectLineArrows(this.drawArrows.isSelected());
        }
        if ((errorValues = this.setLineRatio()) != null) {
            return errorValues;
        }
        this.stateChanged = false;
        this.chartMain.invalidateLegend();
        return null;
    }
}

