/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import quadbase.chart.CAnnotation;
import quadbase.chart.Chart;
import quadbase.chart.ControlLine;
import quadbase.chart.DataLine;
import quadbase.chart.HiLowMap;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.IAnnotation;
import quadbase.util.IReferenceObj;

public class ControlLineDialog
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(ControlLineDialog.class.getName());
    static final String NONE = "none";
    Chart chart;
    ChartMain chartmain;
    boolean callNewSurface = false;
    ControlLine curDataLine = null;
    ControlLinePanel controlLinePanel;
    JButton okButton;
    JButton cancelButton;

    public ControlLineDialog(ChartMain chartmain, ControlLine contLine) {
        super(chartmain, LanguageEncoder.getText("Define Control Line..."), true);
        this.setBackground(Color.lightGray);
        this.chart = chartmain.chart;
        this.chartmain = chartmain;
        this.curDataLine = contLine;
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        bottomPanel.add(this.okButton);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        bottomPanel.add(this.cancelButton);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        contentPane.add("South", bottomPanel);
        this.controlLinePanel = new ControlLinePanel();
        contentPane.add("Center", this.controlLinePanel);
        this.controlLinePanel.displayLine(this.curDataLine);
        this.controlLinePanel.txt_title.setSelectionStart(0);
        this.controlLinePanel.txt_title.setSelectionEnd(this.controlLinePanel.txt_title.getText().length());
        this.pack();
        this.setSize(this.getPreferredSize());
    }

    DataLine getDataLine() {
        return this.curDataLine;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.controlLinePanel.actionPerformed(e);
    }

    private void addHiLowValue(JComboBox choice, int v) {
        if (v >= 0 && v < this.chart.colData.length) {
            choice.addItem(this.chart.colData[v].getName());
        }
    }

    private void addComponent(JPanel p, Component c, String label) {
        this.addComponent(p, c, null, label);
    }

    private void addComponent(JPanel p, Component c, Component c2, String label) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0));
        if (label != null) {
            panel.add(new JLabel(label));
        }
        panel.add(c);
        if (c2 != null) {
            panel.add(c2);
        }
        p.add(panel);
    }

    private String findColumnName(int v) {
        int no;
        switch (v) {
            case 2: {
                no = this.chart.hilowCol.close;
                break;
            }
            case 3: {
                no = this.chart.hilowCol.open;
                break;
            }
            case 1: {
                no = this.chart.hilowCol.low;
                break;
            }
            default: {
                no = this.chart.hilowCol.hi;
            }
        }
        if (no >= this.chart.colData.length || no == -1) {
            return null;
        }
        return this.chart.colData[no].getName();
    }

    private static int getMapIndex(int[] map, int linetype) {
        for (int i = 0; i < map.length; ++i) {
            if (map[i] != linetype) continue;
            return i;
        }
        return -1;
    }

    private boolean showSubValue() {
        return this.chart.mData2 != null;
    }

    private void invalidateLegend() {
        this.chartmain.invalidateLegend();
    }

    private class ControlLinePanel
    extends JPanel
    implements ActionListener,
    ItemListener {
        JComboBox ch_series;
        JComboBox ch_value;
        JComboBox ch_linetype;
        SpinBox spin_thickness;
        JCheckBox checktitle;
        JCheckBox checkanno;
        JCheckBox checksubValue;
        JCheckBox checkcircular;
        JRadioButton check_neg;
        JRadioButton check_pos;
        JTextField txt_title;
        Color linecolor = Color.black;
        SpinBox line_value;
        int[] linetypeMap = ControlLine.linetypeMap;

        public ControlLinePanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.txt_title = new JTextField("New Line", 20);
            ControlLineDialog.this.addComponent(this, this.txt_title, LanguageEncoder.getText("Label"));
            this.line_value = new SpinBox(-3, 3);
            ControlLineDialog.this.addComponent(this, this.line_value, LanguageEncoder.getText("Standard deviation from average :"));
            this.line_value.setValue(1);
            this.line_value.setEnabled(false);
            if (ControlLineDialog.this.chart.dataDim > 1 && !ControlLineDialog.this.chart.isStackType() || ControlLineDialog.this.chart.dataDim > 2 && ControlLineDialog.this.chart.isStackType()) {
                Object[] name;
                this.ch_series = new JComboBox();
                ControlLineDialog.this.addComponent(this, this.ch_series, LanguageEncoder.getText("Series :"));
                for (Object element : name = ControlLineDialog.this.chart.colData[ControlLineDialog.this.chart.mDataMap[0]].getFieldName()) {
                    this.ch_series.addItem(element.toString());
                }
            }
            if (ControlLineDialog.this.chart.isHiLow()) {
                this.ch_value = new JComboBox();
                ControlLineDialog.this.addComponent(this, this.ch_value, LanguageEncoder.getText("Value :"));
                ControlLineDialog.this.addHiLowValue(this.ch_value, ControlLineDialog.this.chart.hilowCol.hi);
                ControlLineDialog.this.addHiLowValue(this.ch_value, ControlLineDialog.this.chart.hilowCol.low);
                ControlLineDialog.this.addHiLowValue(this.ch_value, ControlLineDialog.this.chart.hilowCol.close);
                ControlLineDialog.this.addHiLowValue(this.ch_value, ControlLineDialog.this.chart.hilowCol.open);
            }
            if (ControlLineDialog.this.chart.isStackType()) {
                this.check_pos = new JRadioButton(LanguageEncoder.getText("Positive"), true);
                this.check_neg = new JRadioButton(LanguageEncoder.getText("Negative"), false);
                ControlLineDialog.this.addComponent(this, this.check_pos, this.check_neg, LanguageEncoder.getText("Stack line :"));
                ButtonGroup bg = new ButtonGroup();
                bg.add(this.check_pos);
                bg.add(this.check_neg);
            }
            this.spin_thickness = new SpinBox(1, 100);
            ControlLineDialog.this.addComponent(this, this.spin_thickness, LanguageEncoder.getText("Line thickness :"));
            this.ch_linetype = new JComboBox();
            ControlLineDialog.this.addComponent(this, this.ch_linetype, LanguageEncoder.getText("Line type :"));
            this.ch_linetype.addItem(ControlLineDialog.NONE);
            for (int i = 0; i < ControlLine.linetypeMap.length; ++i) {
                this.ch_linetype.addItem(ControlLine.defaultNames[i]);
            }
            this.selectDefaultType();
            this.ch_linetype.addItemListener(this);
            if (ControlLineDialog.this.chart.chartType == 16) {
                this.checkcircular = new JCheckBox();
                ControlLineDialog.this.addComponent(this, this.checkcircular, LanguageEncoder.getText("Circular Style"));
            }
            this.checktitle = new JCheckBox(LanguageEncoder.getText("Show Label In Legend"));
            ControlLineDialog.this.addComponent(this, this.checktitle, null);
            this.checkanno = new JCheckBox(LanguageEncoder.getText("Show attached text"));
            ControlLineDialog.this.addComponent(this, this.checkanno, null);
            if (ControlLineDialog.this.showSubValue()) {
                this.checksubValue = new JCheckBox(LanguageEncoder.getText("Use secondary axis value"));
                this.add(this.checksubValue);
            }
        }

        void selectDefaultType() {
            if (ControlLineDialog.this.chart.isCircularChart()) {
                this.ch_linetype.setSelectedItem(ControlLineDialog.NONE);
            } else {
                this.ch_linetype.setSelectedIndex(1);
            }
        }

        void displayLine(ControlLine cLine) {
            ControlLineDialog.this.curDataLine = cLine;
            if (cLine == null) {
                this.txt_title.setText(LanguageEncoder.getText("New Line"));
                this.selectDefaultType();
                this.line_value.setValue(0);
                this.spin_thickness.setValue(1);
                this.linecolor = Color.black;
                if (ControlLineDialog.this.showSubValue()) {
                    this.checksubValue.setSelected(false);
                }
            } else {
                this.txt_title.setText(cLine.getTitle());
                this.ch_linetype.setSelectedIndex(ControlLineDialog.getMapIndex(this.linetypeMap, cLine.getLineType() % 100) + 1);
                if (this.checkcircular != null) {
                    this.checkcircular.setSelected(cLine.getLineType() >= 100);
                }
                if (this.ch_series != null) {
                    this.ch_series.setSelectedItem(cLine.getSeries());
                }
                if (this.ch_value != null) {
                    String s = ControlLineDialog.this.findColumnName(cLine.getValueColumn());
                    if (s != null) {
                        this.ch_value.setSelectedItem(s);
                    } else {
                        this.ch_value.setSelectedIndex(0);
                    }
                }
                this.line_value.setValue((int)cLine.getLineValue());
                this.line_value.setEnabled(cLine.getLineType() % 100 == 11);
                this.linecolor = cLine.getColor();
                this.spin_thickness.setValue(cLine.getThickness());
                if (this.check_pos != null) {
                    this.check_pos.setSelected(cLine.getStackChartLine());
                }
                this.checktitle.setSelected(cLine.isTitleVisibleInLegend());
                Vector<IAnnotation> annoVector = cLine.getAnnotations();
                if (annoVector == null || annoVector.size() == 0) {
                    LOGGER.finest("DISPLAY LINE  2 - ANNO SIZE IS NULL!");
                    this.checkanno.setSelected(false);
                } else {
                    this.checkanno.setSelected(annoVector.elementAt(0).isVisible());
                }
                if (ControlLineDialog.this.showSubValue()) {
                    this.checksubValue.setSelected(cLine.isSecondaryValueUsed());
                }
                this.txt_title.requestFocus();
            }
        }

        ControlLine getControlLine() {
            int typeIndex = this.ch_linetype.getSelectedIndex();
            if (typeIndex == 0) {
                return null;
            }
            String label = this.txt_title.getText();
            int linetype = ControlLine.linetypeMap[typeIndex - 1];
            if (this.checkcircular != null && this.checkcircular.isSelected()) {
                linetype += 100;
            }
            ControlLine cLine = ControlLineDialog.this.curDataLine;
            cLine.setTitle(label);
            cLine.setLineType(linetype);
            if (this.ch_value != null) {
                cLine.setValueColumn(this.findColumn(this.ch_value.getSelectedItem().toString()));
            }
            if (this.ch_series != null) {
                cLine.setSeries(this.ch_series.getSelectedItem().toString());
            }
            cLine.setThickness(this.spin_thickness.getValue());
            if (this.check_pos != null) {
                cLine.setStackChartLine(this.check_pos.isSelected());
            }
            cLine.setTitleVisibleInLegend(this.checktitle.isSelected());
            boolean showAnnotation = this.checkanno.isSelected();
            Vector<IAnnotation> annoVector = cLine.getAnnotations();
            if (annoVector != null) {
                int nAnno = annoVector.size();
                for (int i = 0; i < nAnno; ++i) {
                    annoVector.elementAt(i).setVisible(showAnnotation);
                }
            } else {
                LOGGER.finest("GET CONTROL LINE:  ANNO IS NULL");
                if (showAnnotation) {
                    CAnnotation anno = new CAnnotation(ControlLineDialog.this.chart, (IReferenceObj)cLine, "New Text");
                    cLine.addAnnotation(anno);
                }
            }
            cLine.setColor(this.linecolor);
            if (ControlLineDialog.this.showSubValue()) {
                cLine.useSecondaryValue(this.checksubValue.isSelected());
            }
            cLine.setLineValue(this.line_value.getValue());
            return cLine;
        }

        int findColumn(String s) {
            HiLowMap col = ControlLineDialog.this.chart.hilowCol;
            if (col.close >= 0 && ControlLineDialog.this.chart.colData[col.close].getName().equals(s)) {
                return 2;
            }
            if (ControlLineDialog.this.chart.colData[col.low].getName().equals(s)) {
                return 1;
            }
            if (col.open >= 0 && ControlLineDialog.this.chart.colData[col.open].getName().equals(s)) {
                return 3;
            }
            return 0;
        }

        void updateControlLine() {
            this.getControlLine();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object target = e.getSource();
            if (target == ControlLineDialog.this.okButton) {
                if (ControlLineDialog.this.callNewSurface) {
                    ControlLineDialog.this.chart.newSurface();
                    ControlLineDialog.this.callNewSurface = false;
                }
                this.updateControlLine();
                ControlLineDialog.this.invalidateLegend();
                ControlLineDialog.this.chartmain.setModified();
                ControlLineDialog.this.chartmain.qbrepaint();
                this.setVisible(false);
                ControlLineDialog.this.dispose();
            } else if (target == ControlLineDialog.this.cancelButton) {
                ControlLineDialog.this.curDataLine = null;
                ControlLineDialog.this.callNewSurface = false;
                this.setVisible(false);
                ControlLineDialog.this.dispose();
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object source = e.getSource();
            if (source == this.ch_linetype) {
                int index = this.ch_linetype.getSelectedIndex() - 1;
                if (index < 0) {
                    this.line_value.setEnabled(false);
                    return;
                }
                if (this.linetypeMap[index] == 11) {
                    this.line_value.setEnabled(true);
                } else {
                    this.line_value.setEnabled(false);
                }
            }
        }
    }
}

