/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.chart.designer.GradientDialog;
import quadbase.chart.designer.IGradientDialog;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.ControlRange;

public class ControlRangeDialog
extends QbDialog
implements IGradientDialog {
    private static final Logger LOGGER = Logger.getLogger(ControlRangeDialog.class.getName());
    JTextField startScale;
    JTextField endScale;
    JTextField startScale2;
    JTextField endScale2;
    JTextField title;
    JTextField thickness;
    JTextField offset;
    JTextField centerX;
    JTextField centerY;
    JTextField depth;
    JCheckBox checkLegend;
    JCheckBox checkBorder;
    JCheckBox checkShowAxis;
    JCheckBox checkScale1;
    JCheckBox checkScale2;
    JCheckBox checkRotate;
    JCheckBox checkHighlight;
    JRadioButton ck_raise;
    JRadioButton ck_lower;
    JRadioButton ck_none;
    JRadioButton ck_shadow;
    ChartMain chartmain;
    Chart chart;
    ControlRange controlRange;
    JButton okButton;
    JButton cancelButton;
    boolean inProcess = true;
    JCheckBox enableGradient;
    JButton gradientOption;
    GradientDialog gradientDialog;
    private static final double DEFAULT_VALUE = 0.0;
    private JRadioButton absoluteValuesRadioButton;
    private JRadioButton percentageRadioButton;

    public ControlRangeDialog(ChartMain chartmain, ControlRange controlRange) {
        super(chartmain, LanguageEncoder.getText("Control Area Options"), true);
        this.setBackground(Color.lightGray);
        this.chartmain = chartmain;
        this.chart = chartmain.chart;
        String startLbl1 = LanguageEncoder.getText("Value Axis Starting Scale");
        String endLbl1 = LanguageEncoder.getText("Value Axis Ending Scale");
        String useScaleLbl1 = LanguageEncoder.getText("Use Value Axis Scale");
        String startLbl2 = LanguageEncoder.getText("Category Axis Starting Scale");
        String endLbl2 = LanguageEncoder.getText("Category Axis Ending Scale");
        String useScaleLbl2 = LanguageEncoder.getText("Use Category Axis Scale");
        if (this.chart.getChartType() == 17) {
            startLbl1 = LanguageEncoder.getText("Starting Scale");
            endLbl1 = LanguageEncoder.getText("Ending Scale");
        } else if (Chart.isCoordinateType(this.chart.getChartType())) {
            startLbl1 = LanguageEncoder.getText("Starting Scale 1");
            endLbl1 = LanguageEncoder.getText("Ending Scale 1");
            useScaleLbl1 = LanguageEncoder.getText("Use Scale 1");
            startLbl2 = LanguageEncoder.getText("Starting Scale 2");
            endLbl2 = LanguageEncoder.getText("Ending Scale 2");
            useScaleLbl2 = LanguageEncoder.getText("Use Scale 2");
        }
        this.init(useScaleLbl1, useScaleLbl2);
        BorderPanel anglePanel = new BorderPanel(LanguageEncoder.getText("Control Area"));
        anglePanel.setLayout(new GridLayout(0, 2, 5, 5));
        anglePanel.add(new JLabel(LanguageEncoder.getText("Label")));
        anglePanel.add(this.title);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.absoluteValuesRadioButton = new JRadioButton(LanguageEncoder.getText("Absolute Values"));
        this.absoluteValuesRadioButton.addActionListener(this);
        this.percentageRadioButton = new JRadioButton(LanguageEncoder.getText("Percentage"));
        this.percentageRadioButton.addActionListener(this);
        buttonGroup.add(this.absoluteValuesRadioButton);
        buttonGroup.add(this.percentageRadioButton);
        anglePanel.add(this.absoluteValuesRadioButton);
        anglePanel.add(this.percentageRadioButton);
        if (this.chart.getChartType() == 17) {
            anglePanel.add(new JLabel(startLbl1));
            anglePanel.add(this.startScale);
            anglePanel.add(new JLabel(endLbl1));
            anglePanel.add(this.endScale);
            anglePanel.add(new JLabel(LanguageEncoder.getText("Area Thickness")));
            anglePanel.add(this.thickness);
            anglePanel.add(new JLabel(LanguageEncoder.getText("Area Offset")));
            anglePanel.add(this.offset);
            anglePanel.add(new JLabel(LanguageEncoder.getText("Center X")));
            anglePanel.add(this.centerX);
            anglePanel.add(new JLabel(LanguageEncoder.getText("Center Y")));
            anglePanel.add(this.centerY);
            anglePanel.add(this.checkLegend);
            anglePanel.add(this.checkBorder);
            anglePanel.add(this.checkShowAxis);
        } else {
            anglePanel.add(this.checkScale1);
            this.checkScale1.addItemListener(this);
            anglePanel.add(new JLabel(""));
            anglePanel.add(new JLabel(startLbl1));
            anglePanel.add(this.startScale);
            anglePanel.add(new JLabel(endLbl1));
            anglePanel.add(this.endScale);
            anglePanel.add(this.checkScale2);
            this.checkScale2.addItemListener(this);
            anglePanel.add(new JLabel(""));
            anglePanel.add(new JLabel(startLbl2));
            anglePanel.add(this.startScale2);
            anglePanel.add(new JLabel(endLbl2));
            anglePanel.add(this.endScale2);
            anglePanel.add(new JLabel(LanguageEncoder.getText("Area Depth")));
            anglePanel.add(this.depth);
            anglePanel.add(new JLabel(LanguageEncoder.getText("Appearance")));
            anglePanel.add(new JLabel(""));
            anglePanel.add(this.ck_raise);
            anglePanel.add(this.ck_lower);
            anglePanel.add(this.ck_none);
            anglePanel.add(this.ck_shadow);
            this.enableGradient = new JCheckBox(LanguageEncoder.getText("Enable Gradient"), controlRange != null ? controlRange.isGradientEnabled() : false);
            this.gradientOption = new JButton(LanguageEncoder.getText("Customize..."));
            this.enableGradient.addItemListener(this);
            this.gradientOption.setEnabled(this.enableGradient.isSelected());
            anglePanel.add(this.enableGradient);
            anglePanel.add(this.gradientOption);
            this.gradientOption.addActionListener(this);
            anglePanel.add(this.checkLegend);
            anglePanel.add(this.checkHighlight);
            if (Chart.isCoordinateType(this.chart.getChartType())) {
                anglePanel.add(this.checkRotate);
                anglePanel.add(new JLabel(""));
            }
        }
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        p2.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        p2.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        cop.add("Center", anglePanel);
        cop.add("South", p2);
        this.displayCode(controlRange);
        this.title.setSelectionStart(0);
        this.title.setSelectionEnd(this.title.getText().length());
        this.pack();
        this.inProcess = false;
    }

    private void init(String useScaleLbl1, String useScaleLbl2) {
        this.title = new JTextField(8);
        this.startScale = new JTextField(8);
        this.endScale = new JTextField(8);
        this.startScale2 = new JTextField(8);
        this.endScale2 = new JTextField(8);
        this.thickness = new JTextField(8);
        this.offset = new JTextField(8);
        this.centerX = new JTextField(8);
        this.centerY = new JTextField(8);
        this.checkLegend = new JCheckBox(LanguageEncoder.getText("Show Label In Legend"));
        this.checkHighlight = new JCheckBox(LanguageEncoder.getText("Highlight Overlap Area"));
        this.checkBorder = new JCheckBox(LanguageEncoder.getText("Draw Border"));
        this.checkShowAxis = new JCheckBox(LanguageEncoder.getText("Show Axis"));
        this.checkScale1 = new JCheckBox(useScaleLbl1);
        this.checkScale2 = new JCheckBox(useScaleLbl2);
        this.depth = new JTextField(8);
        this.ck_raise = new JRadioButton(LanguageEncoder.getText("Raise"), true);
        this.ck_lower = new JRadioButton(LanguageEncoder.getText("Lower"), false);
        this.ck_none = new JRadioButton(LanguageEncoder.getText("None"), false);
        this.ck_shadow = new JRadioButton(LanguageEncoder.getText("Shadow"), false);
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.ck_raise);
        bg1.add(this.ck_lower);
        bg1.add(this.ck_none);
        bg1.add(this.ck_shadow);
        this.checkRotate = new JCheckBox(LanguageEncoder.getText("Rotate"));
    }

    private void setDirection(int dir) {
        this.checkRotate.setSelected(dir == 1);
    }

    private int getDirection() {
        return this.checkRotate.isSelected() ? 1 : 0;
    }

    private void setAppearance(int appearance) {
        if (appearance == 1) {
            this.ck_raise.setSelected(true);
        } else if (appearance == 2) {
            this.ck_lower.setSelected(true);
        } else if (appearance == 3) {
            this.ck_shadow.setSelected(true);
        } else {
            this.ck_none.setSelected(true);
        }
    }

    private int getAppearance() {
        return this.ck_raise.isSelected() ? 1 : (this.ck_lower.isSelected() ? 2 : (this.ck_shadow.isSelected() ? 3 : 0));
    }

    private void displayCode(ControlRange controlRange) {
        ControlRange lastControlRange = null;
        if (!this.chart.getControlRangeList().isEmpty()) {
            lastControlRange = this.chart.getControlRangeList().lastElement();
        }
        if (controlRange == null) {
            this.title.setText(LanguageEncoder.getText("New Range"));
            if (lastControlRange == null) {
                this.startScale.setText("0.0");
                double maxValue = ControlRange.getMaxValueOnValueAxis(this.chart);
                if (maxValue != Double.MIN_VALUE) {
                    this.endScale.setText(Double.toString(maxValue));
                } else {
                    this.endScale.setText("0.0");
                }
                this.startScale2.setText("0.0");
                double maxCategoryValue = ControlRange.getMaxValueOnCategoryAxis(this.chart);
                if (maxCategoryValue != Double.MIN_VALUE) {
                    this.endScale2.setText(Double.toString(maxCategoryValue));
                } else {
                    this.endScale2.setText("0.0");
                }
                this.thickness.setText("5");
                this.offset.setText("0");
                this.centerX.setText("0");
                this.centerY.setText("0");
                this.checkScale1.setSelected(true);
                this.checkScale2.setSelected(false);
                this.checkLegend.setSelected(false);
                this.checkHighlight.setSelected(false);
                this.checkBorder.setSelected(false);
                this.checkShowAxis.setSelected(true);
                this.checkRotate.setSelected(false);
                this.depth.setText("0");
                this.setAppearance(0);
                this.setDirection(0);
                this.absoluteValuesRadioButton.setSelected(true);
            } else {
                this.startScale.setText(Double.valueOf(lastControlRange.getEndScale()).toString());
                this.endScale.setText(Double.valueOf(lastControlRange.getEndScale()).toString());
                this.startScale2.setText(Double.valueOf(lastControlRange.getEndScale2()).toString());
                this.endScale2.setText(Double.valueOf(lastControlRange.getEndScale2()).toString());
                this.thickness.setText(Integer.valueOf(lastControlRange.getThickness()).toString());
                this.offset.setText(Integer.valueOf(lastControlRange.getOffset()).toString());
                this.centerX.setText(Integer.valueOf(lastControlRange.getCenter().x).toString());
                this.centerY.setText(Integer.valueOf(lastControlRange.getCenter().y).toString());
                this.checkScale1.setSelected(lastControlRange.isScale1Enabled());
                this.checkScale2.setSelected(lastControlRange.isScale2Enabled());
                this.checkLegend.setSelected(lastControlRange.isShowInLegend());
                this.checkHighlight.setSelected(lastControlRange.isOverlapAreaHighlighted());
                this.checkBorder.setSelected(lastControlRange.isDrawBorder());
                this.checkShowAxis.setSelected(lastControlRange.isShowAxis());
                this.depth.setText(Integer.valueOf(lastControlRange.getDepth()).toString());
                this.setAppearance(lastControlRange.getAppearance());
                this.setDirection(lastControlRange.getDirection());
                this.percentageRadioButton.setSelected(lastControlRange.isPercentage());
                this.absoluteValuesRadioButton.setSelected(!lastControlRange.isPercentage());
            }
        } else {
            this.controlRange = controlRange;
            this.title.setText(controlRange.getTitle());
            this.startScale.setText(Double.valueOf(controlRange.getStartScale()).toString());
            this.endScale.setText(Double.valueOf(controlRange.getEndScale()).toString());
            this.startScale2.setText(Double.valueOf(controlRange.getStartScale2()).toString());
            this.endScale2.setText(Double.valueOf(controlRange.getEndScale2()).toString());
            this.thickness.setText(Integer.valueOf(controlRange.getThickness()).toString());
            this.offset.setText(Integer.valueOf(controlRange.getOffset()).toString());
            this.centerX.setText(Integer.valueOf(controlRange.getCenter().x).toString());
            this.centerY.setText(Integer.valueOf(controlRange.getCenter().y).toString());
            this.checkScale1.setSelected(controlRange.isScale1Enabled());
            this.checkScale2.setSelected(controlRange.isScale2Enabled());
            this.checkLegend.setSelected(controlRange.isShowInLegend());
            this.checkHighlight.setSelected(controlRange.isOverlapAreaHighlighted());
            this.checkBorder.setSelected(controlRange.isDrawBorder());
            this.checkShowAxis.setSelected(controlRange.isShowAxis());
            this.depth.setText(Integer.valueOf(controlRange.getDepth()).toString());
            this.setAppearance(controlRange.getAppearance());
            this.setDirection(controlRange.getDirection());
            this.percentageRadioButton.setSelected(controlRange.isPercentage());
            this.absoluteValuesRadioButton.setSelected(!controlRange.isPercentage());
        }
        this.itemStateChanged(null);
    }

    private double getStartScale() {
        try {
            return Double.valueOf(this.startScale.getText());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private double getEndScale() {
        try {
            return Double.valueOf(this.endScale.getText());
        }
        catch (NumberFormatException e) {
            return ControlRange.getMaxValueOnValueAxis(this.chart);
        }
    }

    private double getStartScale2() {
        try {
            return Double.valueOf(this.startScale2.getText());
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    private double getEndScale2() {
        try {
            return Double.valueOf(this.endScale2.getText());
        }
        catch (NumberFormatException e) {
            return ControlRange.getMaxValueOnCategoryAxis(this.chart);
        }
    }

    private String updateRecord() {
        try {
            double start = Double.valueOf(this.startScale.getText());
            double end = Double.valueOf(this.endScale.getText());
            double start2 = Double.valueOf(this.startScale2.getText());
            double end2 = Double.valueOf(this.endScale2.getText());
            int thick = Integer.valueOf(this.thickness.getText());
            int off = Integer.valueOf(this.offset.getText());
            int x = Integer.valueOf(this.centerX.getText());
            int y = Integer.valueOf(this.centerY.getText());
            int d = Integer.valueOf(this.depth.getText());
            if (this.controlRange == null) {
                this.controlRange = new ControlRange(start, end, this.title.getText(), thick, off, new Point(x, y), this.checkBorder.isSelected(), this.checkLegend.isSelected(), this.checkShowAxis.isSelected());
                this.controlRange.setStartScale2(start2);
                this.controlRange.setEndScale2(end2);
                this.controlRange.setScale1Enabled(this.checkScale1.isSelected());
                this.controlRange.setScale2Enabled(this.checkScale2.isSelected());
                this.controlRange.setDepth(d);
                this.controlRange.setAppearance(this.getAppearance());
                this.controlRange.setDirection(this.getDirection());
                this.controlRange.setOverlapAreaHighlighted(this.checkHighlight.isSelected());
            } else {
                this.controlRange.setStartScale(start);
                this.controlRange.setEndScale(end);
                this.controlRange.setStartScale2(start2);
                this.controlRange.setEndScale2(end2);
                this.controlRange.setScale1Enabled(this.checkScale1.isSelected());
                this.controlRange.setScale2Enabled(this.checkScale2.isSelected());
                this.controlRange.setThickness(thick);
                this.controlRange.setOffset(off);
                this.controlRange.setCenter(new Point(x, y));
                this.controlRange.setTitle(this.title.getText());
                this.controlRange.setShowInLegend(this.checkLegend.isSelected());
                this.controlRange.setDrawBorder(this.checkBorder.isSelected());
                this.controlRange.setShowAxis(this.checkShowAxis.isSelected());
                this.controlRange.setDepth(d);
                this.controlRange.setAppearance(this.getAppearance());
                this.controlRange.setDirection(this.getDirection());
                this.controlRange.setOverlapAreaHighlighted(this.checkHighlight.isSelected());
            }
            this.controlRange.setPercentage(this.percentageRadioButton.isSelected());
            if (this.enableGradient != null && this.enableGradient.isEnabled()) {
                this.controlRange.setGradientEnabled(this.enableGradient.isSelected());
            } else {
                this.controlRange.setGradientEnabled(false);
            }
            if (this.gradientDialog != null) {
                this.gradientDialog.setValues();
            }
        }
        catch (NumberFormatException ex) {
            LOGGER.log(Level.FINEST, "Failed to update control range values. Invalid number.", ex);
            return LanguageEncoder.getText("Invalid number");
        }
        return null;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.gradientOption != null) {
            this.gradientOption.setEnabled(this.enableGradient.isSelected());
        }
        this.startScale.setEnabled(this.checkScale1.isSelected());
        this.endScale.setEnabled(this.checkScale1.isSelected());
        this.startScale2.setEnabled(this.checkScale2.isSelected());
        this.endScale2.setEnabled(this.checkScale2.isSelected());
    }

    private void computeScales(boolean toPercentage) {
        double maxValue = ControlRange.getMaxValueOnValueAxis(this.chart);
        double maxCatValue = ControlRange.getMaxValueOnCategoryAxis(this.chart);
        if (maxValue != Double.MIN_VALUE) {
            if (toPercentage) {
                this.startScale.setText(this.getStartScale() / maxValue * 100.0 + "");
                this.endScale.setText(this.getEndScale() / maxValue * 100.0 + "");
            } else {
                this.startScale.setText(this.getStartScale() / 100.0 * maxValue + "");
                this.endScale.setText(this.getEndScale() / 100.0 * maxValue + "");
            }
        }
        if (maxCatValue != Double.MIN_VALUE) {
            if (toPercentage) {
                this.startScale2.setText(this.getStartScale2() / maxCatValue * 100.0 + "");
                this.endScale2.setText(this.getEndScale2() / maxCatValue * 100.0 + "");
            } else {
                this.startScale2.setText(this.getStartScale2() / 100.0 * maxCatValue + "");
                this.endScale2.setText(this.getEndScale2() / 100.0 * maxCatValue + "");
            }
        }
    }

    ControlRange getControlRange() {
        return this.controlRange;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.inProcess = true;
        Object target = e.getSource();
        if (target == this.absoluteValuesRadioButton) {
            this.computeScales(false);
        } else if (target == this.percentageRadioButton) {
            this.computeScales(true);
        } else if (target == this.cancelButton) {
            this.controlRange = null;
            this.setVisible(false);
            this.dispose();
        } else if (target == this.okButton) {
            String msg = this.updateRecord();
            if (msg != null) {
                new MessageDialog((Frame)this.chartmain, LanguageEncoder.getText("Error")).show(msg);
                this.inProcess = false;
                return;
            }
            this.chartmain.invalidateLegend();
            this.chartmain.chartPanel.repaint();
            this.setVisible(false);
            this.dispose();
        } else if (e.getSource() == this.gradientOption) {
            if (this.gradientDialog == null) {
                this.gradientDialog = new GradientDialog(this.chartmain, this, "Gradient Options");
            }
            this.gradientDialog.setVisible(true);
            return;
        }
        this.inProcess = false;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.controlRange = null;
        super.windowClosing(e);
    }

    @Override
    public void resetGradientDialog() {
        this.gradientDialog = null;
    }

    @Override
    public double getGradientStartX() {
        return this.controlRange == null ? 0.0 : this.controlRange.getGradientStartX();
    }

    @Override
    public double getGradientStartY() {
        return this.controlRange == null ? 0.0 : this.controlRange.getGradientStartY();
    }

    @Override
    public double getGradientEndX() {
        return this.controlRange == null ? 100.0 : this.controlRange.getGradientEndX();
    }

    @Override
    public double getGradientEndY() {
        return this.controlRange == null ? 100.0 : this.controlRange.getGradientEndY();
    }

    @Override
    public Color getGradientDesColor() {
        return this.controlRange == null ? null : this.controlRange.getGradientDesColor();
    }

    @Override
    public int getGradientShade() {
        return this.controlRange == null ? -2 : this.controlRange.getGradientShade();
    }

    @Override
    public boolean isGradientCyclic() {
        return this.controlRange == null ? false : this.controlRange.isGradientCyclic();
    }

    @Override
    public void setValues(GradientDialog gDialog) {
        this.controlRange.setGradientStartX((double)gDialog.startX.getValue() / 100.0);
        this.controlRange.setGradientStartY((double)gDialog.startY.getValue() / 100.0);
        this.controlRange.setGradientEndX((double)gDialog.endX.getValue() / 100.0);
        this.controlRange.setGradientEndY((double)gDialog.endY.getValue() / 100.0);
        if (gDialog.shading.isSelected()) {
            this.controlRange.setGradientShade(gDialog.shadeValue.getValue() * (gDialog.shadeDirection.getSelectedIndex() == 0 ? -1 : 1));
            this.controlRange.setGradientDesColor(null);
        } else {
            this.controlRange.setGradientDesColor(gDialog.getButtonColor());
        }
        this.controlRange.setGradientCyclic(gDialog.checkCyclic.isSelected());
        this.controlRange.setGradientStartX((double)gDialog.startX.getValue() / 100.0);
        this.controlRange.setGradientStartY((double)gDialog.startY.getValue() / 100.0);
        this.controlRange.setGradientEndX((double)gDialog.endX.getValue() / 100.0);
        this.controlRange.setGradientEndY((double)gDialog.endY.getValue() / 100.0);
        if (gDialog.shading.isSelected()) {
            this.controlRange.setGradientShade(gDialog.shadeValue.getValue() * (gDialog.shadeDirection.getSelectedIndex() == 0 ? -1 : 1));
            this.controlRange.setGradientDesColor(null);
        } else {
            this.controlRange.setGradientDesColor(gDialog.getButtonColor());
        }
        this.controlRange.setGradientCyclic(gDialog.checkCyclic.isSelected());
    }

    @Override
    public boolean is3DShadingEnabled() {
        return false;
    }

    @Override
    public boolean isGradientEnabled() {
        return false;
    }
}

