/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.FlowLayout;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.util.internal.LanguageEncoder;

public class CutOffPointPanel
extends BorderPanel {
    private static final Logger LOGGER = Logger.getLogger(CutOffPointPanel.class.getName());
    Double cutOffPt = null;
    JTextField cutOffPointField;
    JButton okButton;
    JButton cancelButton;
    Chart chart;
    ChartMain chartMain;

    public CutOffPointPanel(JFrame frame, Chart chart) {
        super(LanguageEncoder.getText("Cut Off Point Options"));
        this.chartMain = (ChartMain)frame;
        this.chart = chart;
        this.init();
    }

    private void init() {
        JPanel cutOffPanel = new JPanel(new FlowLayout(0));
        cutOffPanel.add(new JLabel(LanguageEncoder.getText("Max Y Cut Off Point:")));
        this.cutOffPointField = new JTextField(5);
        cutOffPanel.add(this.cutOffPointField);
        this.cutOffPt = this.chart.getAreaCutOffPoint();
        if (this.cutOffPt != null) {
            this.cutOffPointField.setText("" + this.cutOffPt);
        } else {
            this.cutOffPointField.setText("N/A");
        }
        this.add("Center", cutOffPanel);
    }

    public void setValues() {
        String tmp = this.cutOffPointField.getText();
        if (tmp == null || tmp.trim().equals("")) {
            this.chart.setAreaCutOffPoint(null);
        } else {
            try {
                this.chart.setAreaCutOffPoint(Double.parseDouble(tmp));
            }
            catch (NumberFormatException ex) {
                LOGGER.log(Level.FINEST, "Failed to set area cutoff point (invalid number) - using null", ex);
                this.chart.setAreaCutOffPoint(null);
            }
        }
    }
}

