/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.DataInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import quadbase.chart.ReadDataFile;
import quadbase.common.paramquery.QueryFileInfo;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.PanelAction;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.UndoTextArea;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.LanguageEncoder;

public class DBPanel
extends PanelAction {
    private static final Logger LOGGER = Logger.getLogger(DBPanel.class.getName());
    public JTextField urlText;
    public JTextField nameText;
    public JTextField driverText;
    public JPasswordField pwdText;
    public UndoTextArea sqlText;
    public JTextField filenameText;
    QueryFileInfo queryFileInfo = null;
    JButton getFileBut;
    String queryFilename = "";
    private DBInfoBasic dbInfo;

    public DBPanel(DBInfoBasic dbInfo) {
        BorderPanel bpanel = new BorderPanel("Please type in database source");
        bpanel.setLayout(new BorderLayout());
        JPanel connpanel = new JPanel(new BorderLayout());
        this.urlText = new JTextField("", 25);
        this.driverText = new JTextField("", 25);
        this.nameText = new JTextField("", 15);
        this.pwdText = new JPasswordField("", 15);
        JPanel westPanel = new JPanel(new BorderLayout());
        JPanel westPanelWest = new JPanel(new BoxLayout(this, 1));
        JPanel westPanelCenter = new JPanel(new BoxLayout(this, 1));
        westPanelWest.add(new JLabel("URL : "));
        westPanelCenter.add(this.urlText);
        westPanelWest.add(new JLabel("Driver : "));
        westPanelCenter.add(this.driverText);
        westPanel.add("West", westPanelWest);
        westPanel.add("Center", westPanelCenter);
        connpanel.add("West", westPanel);
        JPanel centerPanel = new JPanel(new BorderLayout());
        JPanel centerPanelWest = new JPanel(new BoxLayout(this, 1));
        JPanel centerPanelCenter = new JPanel(new BoxLayout(this, 1));
        centerPanelWest.add(new JLabel("User Name : "));
        centerPanelCenter.add(this.nameText);
        centerPanelWest.add(new JLabel("Password : "));
        centerPanelCenter.add(this.pwdText);
        centerPanel.add("West", centerPanelWest);
        centerPanel.add("Center", centerPanelCenter);
        connpanel.add("Center", centerPanel);
        bpanel.add("North", connpanel);
        JPanel sqlpanel = new JPanel();
        sqlpanel.setLayout(new BorderLayout());
        sqlpanel.add("North", new JLabel("SQL Statement : "));
        this.sqlText = new UndoTextArea("", 10, 50);
        sqlpanel.add("Center", this.sqlText);
        this.sqlText.setText("");
        JPanel filePanel = new JPanel(new BorderLayout());
        JPanel filePanela = new JPanel(new FlowLayout(0));
        filePanela.setLayout(new FlowLayout(0));
        filePanela.add(new JLabel("Read file (*.sql or *.qry):"));
        JPanel filePanelb = new JPanel(new FlowLayout(2));
        this.filenameText = new JTextField(40);
        filePanelb.add(this.filenameText);
        this.filenameText.addActionListener(this);
        this.getFileBut = new JButton("Get");
        filePanelb.add(this.getFileBut);
        this.getFileBut.addActionListener(this);
        filePanel.add("West", filePanela);
        filePanel.add("Center", filePanelb);
        sqlpanel.add("South", filePanel);
        bpanel.add("South", sqlpanel);
        this.setLayout(new BorderLayout());
        this.add("Center", bpanel);
        this.urlText.requestFocus();
        this.setDBInfo(dbInfo);
    }

    void setDBInfo(DBInfoBasic dbInfo) {
        this.dbInfo = dbInfo;
        this.urlText.setText(dbInfo.getURLString());
        this.driverText.setText(dbInfo.getDriverName());
        this.nameText.setText(dbInfo.getUserID());
        this.pwdText.setText(dbInfo.getPassword());
        this.sqlText.setText(dbInfo.getQuery());
    }

    DBInfoBasic getDBInfo() {
        this.dbInfo.setURLString(this.urlText.getText());
        this.dbInfo.setDriverName(this.driverText.getText());
        this.dbInfo.setUserID(this.nameText.getText());
        this.dbInfo.setPassword(this.pwdText.getText());
        this.dbInfo.setQuery(this.sqlText.getText());
        return this.dbInfo;
    }

    public String getQueryFilename() {
        return this.queryFilename;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.getFileBut || source == this.filenameText) {
            String filename = this.filenameText.getText().trim();
            if (filename.endsWith(".sql")) {
                this.getSQLFromFile(filename);
            } else {
                this.getQueryFile(filename);
            }
        }
    }

    private void getSQLFromFile(String filename) {
        if (filename == null) {
            return;
        }
        String file = filename.trim();
        if (file.equals("")) {
            return;
        }
        if (!file.endsWith(".sql")) {
            file = file + ".sql";
        }
        try {
            ReadDataFile readfile = new ReadDataFile();
            DataInputStream din = readfile.getInputStream(file);
            if (din.available() < 0) {
                readfile.close();
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show("Can't read " + file + "!");
                return;
            }
            byte[] b = new byte[din.available()];
            din.readFully(b);
            readfile.close();
            this.sqlText.setText(new String(b));
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Can't read file: " + file, ex);
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show("Can't read " + file + "!\n" + ex.toString());
            return;
        }
    }

    private void getQueryFile(String filename) {
        if (filename == null) {
            return;
        }
        String file = filename.trim();
        if (file.equals("")) {
            return;
        }
        if (!file.endsWith(".qry")) {
            file = file + ".qry";
        }
        try {
            ReadDataFile readfile = new ReadDataFile();
            DataInputStream din = readfile.getInputStream(file);
            if (din.available() < 0) {
                readfile.close();
                new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show("Can't read " + file + "!");
                return;
            }
            this.queryFileInfo = null;
            readfile.close();
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Can't read file: " + file, ex);
            new MessageDialog((Frame)QbDialog.findFrame(this), LanguageEncoder.getText("Error")).show("Can't read " + file + "!\n" + ex.toString());
            return;
        }
        this.driverText.setText(this.queryFileInfo.getDriverName());
        this.urlText.setText(this.queryFileInfo.getURLString());
        this.nameText.setText(this.queryFileInfo.getUserID());
        this.pwdText.setText(this.queryFileInfo.getPassword());
        this.sqlText.setText(this.queryFileInfo.getQuery());
        this.queryFilename = filename;
    }

    QueryFileInfo getQueryFileInfo() {
        String query2;
        String password2;
        String userid2;
        String driver1 = this.driverText.getText().trim();
        String url1 = this.urlText.getText().trim();
        String userid1 = this.nameText.getText().trim();
        String password1 = this.pwdText.getText().trim();
        String query1 = this.sqlText.getText().trim();
        DBInfoBasic dbInfo1 = new DBInfoBasic(url1, driver1, userid1, password1, query1);
        if (this.queryFileInfo == null) {
            return new QueryFileInfo("EspressChart", 6612, dbInfo1, null);
        }
        String driver2 = this.queryFileInfo.getDriverName();
        String url2 = this.queryFileInfo.getURLString();
        DBInfoBasic dbInfo2 = new DBInfoBasic(url2, driver2, userid2 = this.queryFileInfo.getUserID(), password2 = this.queryFileInfo.getPassword(), query2 = this.queryFileInfo.getQuery());
        if (dbInfo1.equals(dbInfo2)) {
            return this.queryFileInfo;
        }
        return new QueryFileInfo("EspressChart", 6612, dbInfo1, null);
    }

    protected void disableComponents() {
        this.setEnableState(false);
    }

    protected void enableComponents() {
        this.setEnableState(true);
    }

    private void setEnableState(boolean state) {
        this.urlText.setEditable(state);
        this.nameText.setEditable(state);
        this.pwdText.setEditable(state);
        this.driverText.setEditable(state);
        this.sqlText.setEditable(state);
        this.filenameText.setEditable(state);
        this.getFileBut.setEnabled(state);
    }
}

