/*
 * Decompiled with CFR 0.152.
 */
package quadbase.chart.designer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.chart.Chart;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.ColorButton;
import quadbase.common.swing.MessageDialog;
import quadbase.common.swing.QbDialog;
import quadbase.common.swing.color.ColorDialog;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.LanguageEncoder;

public class DataBorderDialog
extends QbDialog {
    private static final Logger LOGGER = Logger.getLogger(DataBorderDialog.class.getName());
    ChartMain chartMain;
    JButton okButton;
    JButton cancelButton;
    JTextField depthField;
    JCheckBox checkDrawBorder;
    JCheckBox checkDrawBlkBorderForWhtArea;
    ColorButton colorBut;

    public DataBorderDialog(ChartMain parent) {
        super(parent, LanguageEncoder.getText("Data Border Dialog"), true);
        this.chartMain = parent;
        this.init();
    }

    private void init() {
        boolean showBorderOption;
        JPanel cop = (JPanel)this.getContentPane();
        cop.setLayout(new BorderLayout());
        this.setBackground(Color.lightGray);
        JPanel buttonPanel = new JPanel();
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        buttonPanel.setLayout(new GridLayout(1, 3, 5, 5));
        buttonPanel.add(new JLabel(""));
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        BorderPanel borderPanel = new BorderPanel(LanguageEncoder.getText("Data Border"));
        borderPanel.setLayout(new GridLayout(0, 2, 5, 5));
        this.checkDrawBorder = new JCheckBox(LanguageEncoder.getText("Draw Border"), this.chartMain.chart.getDataBorder());
        this.checkDrawBorder.addItemListener(this);
        int type = this.chartMain.chart.getChartType();
        boolean bl = showBorderOption = !this.chartMain.chart.is2DimChart() || !Chart.isCircularChart(type) && type != 8 && type != 7;
        if (showBorderOption) {
            borderPanel.add(this.checkDrawBorder);
            borderPanel.add(new JLabel(""));
        }
        if ((type == 0 || type == 1 || type == 4 || type == 5 || type == 11 || type == 9 || type == 10) && this.chartMain.chart.is2DimChart() || !showBorderOption) {
            this.checkDrawBlkBorderForWhtArea = new JCheckBox(LanguageEncoder.getText("Black Border For White Area"), this.chartMain.chart.isDrawBorderForWhiteArea());
            borderPanel.add(this.checkDrawBlkBorderForWhtArea);
            borderPanel.add(new JLabel(""));
        }
        this.depthField = new JTextField(this.chartMain.chart.getDataBorderThickness() + "");
        this.colorBut = new ColorButton(LanguageEncoder.getText("Click"));
        this.setButtonColor(this.chartMain.chart.getDataBorderColor());
        if (showBorderOption) {
            borderPanel.add(new JLabel(LanguageEncoder.getText("Border Thickness")));
            borderPanel.add(this.depthField);
            borderPanel.add(new JLabel(LanguageEncoder.getText("Border Color")));
            borderPanel.add(this.colorBut);
            this.colorBut.addActionListener(this);
        }
        cop.add("Center", borderPanel);
        cop.add("South", buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.itemStateChanged(null);
    }

    private Color getButtonColor() {
        if (IOUtil.isMac()) {
            return this.colorBut.getForeground();
        }
        return this.colorBut.getColor();
    }

    private void setButtonColor(Color color) {
        this.colorBut.setColor(color);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.colorBut.setEnabled(this.checkDrawBorder.isSelected());
        this.depthField.setEnabled(this.checkDrawBorder.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.colorBut) {
            Color currentColor = DataBorderDialog.showDialog(this.chartMain, LanguageEncoder.getText("Set Border Color..."), this.getButtonColor());
            if (currentColor != null) {
                this.setButtonColor(currentColor);
            }
            return;
        }
        if (target == this.okButton) {
            int depth;
            try {
                depth = Integer.parseInt(this.depthField.getText());
            }
            catch (Exception ex) {
                LOGGER.log(Level.FINEST, "Border Thickness: Integer only!", ex);
                new MessageDialog((Frame)this.chartMain, LanguageEncoder.getText("Error")).show(LanguageEncoder.getText("Border Thickness: Integer only!"));
                return;
            }
            this.chartMain.chart.setDataBorder(this.checkDrawBorder.isSelected());
            if (this.checkDrawBorder.isSelected()) {
                this.chartMain.chart.setDataBorderThickness(depth);
                this.chartMain.chart.setDataBorderColor(this.getButtonColor());
            }
            if (this.checkDrawBlkBorderForWhtArea != null) {
                this.chartMain.chart.setDrawBorderForWhiteArea(this.checkDrawBlkBorderForWhtArea.isSelected());
            }
            if (!this.chartMain.chart.is2DimChart()) {
                this.chartMain.frameBorderButton.setSelected(this.checkDrawBorder.isSelected());
            }
            this.chartMain.setModified();
            this.chartMain.chartPanel.repaint();
        }
        this.dispose();
    }

    private static Color showDialog(ChartMain chartMain, String title, Color initColor) {
        return ColorDialog.showDialog(chartMain, title, initColor);
    }
}

